/****************************************************************************

        Copyright (C) 2024 Atsuto Seko
                seko@cms.mtl.kyoto-u.ac.jp

*****************************************************************************/

#include "polymlp_gtinv_data_ver2_order3.h"

GtinvDataVer2Order3::GtinvDataVer2Order3(){

    set_gtinv_info();
}

GtinvDataVer2Order3::~GtinvDataVer2Order3(){}

const vector2i& GtinvDataVer2Order3::get_l_array() const{ return l_array_all; }
const vector3i& GtinvDataVer2Order3::get_m_array() const{ return m_array_all; }
const vector2d& GtinvDataVer2Order3::get_coeffs() const{ return coeffs_all; }

void GtinvDataVer2Order3::set_gtinv_info(){

    l_array_all = {
        {0, 0, 0},
        {0, 1, 1},
        {0, 2, 2},
        {0, 3, 3},
        {0, 4, 4},
        {0, 5, 5},
        {0, 6, 6},
        {0, 7, 7},
        {0, 8, 8},
        {0, 9, 9},
        {0, 10, 10},
        {0, 11, 11},
        {0, 12, 12},
        {1, 1, 2},
        {1, 2, 3},
        {1, 3, 4},
        {1, 4, 5},
        {1, 5, 6},
        {1, 6, 7},
        {1, 7, 8},
        {1, 8, 9},
        {1, 9, 10},
        {1, 10, 11},
        {1, 11, 12},
        {2, 2, 2},
        {2, 2, 4},
        {2, 3, 3},
        {2, 3, 5},
        {2, 4, 4},
        {2, 4, 6},
        {2, 5, 5},
        {2, 5, 7},
        {2, 6, 6},
        {2, 6, 8},
        {2, 7, 7},
        {2, 7, 9},
        {2, 8, 8},
        {2, 8, 10},
        {2, 9, 9},
        {2, 9, 11},
        {2, 10, 10},
        {2, 10, 12},
        {2, 11, 11},
        {2, 12, 12},
        {3, 3, 4},
        {3, 3, 6},
        {3, 4, 5},
        {3, 4, 7},
        {3, 5, 6},
        {3, 5, 8},
        {3, 6, 7},
        {3, 6, 9},
        {3, 7, 8},
        {3, 7, 10},
        {3, 8, 9},
        {3, 8, 11},
        {3, 9, 10},
        {3, 9, 12},
        {3, 10, 11},
        {3, 11, 12},
        {4, 4, 4},
        {4, 4, 6},
        {4, 4, 8},
        {4, 5, 5},
        {4, 5, 7},
        {4, 5, 9},
        {4, 6, 6},
        {4, 6, 8},
        {4, 6, 10},
        {4, 7, 7},
        {4, 7, 9},
        {4, 7, 11},
        {4, 8, 8},
        {4, 8, 10},
        {4, 8, 12},
        {4, 9, 9},
        {4, 9, 11},
        {4, 10, 10},
        {4, 10, 12},
        {4, 11, 11},
        {4, 12, 12},
        {5, 5, 6},
        {5, 5, 8},
        {5, 5, 10},
        {5, 6, 7},
        {5, 6, 9},
        {5, 6, 11},
        {5, 7, 8},
        {5, 7, 10},
        {5, 7, 12},
        {5, 8, 9},
        {5, 8, 11},
        {5, 9, 10},
        {5, 9, 12},
        {5, 10, 11},
        {5, 11, 12},
        {6, 6, 6},
        {6, 6, 8},
        {6, 6, 10},
        {6, 6, 12},
        {6, 7, 7},
        {6, 7, 9},
        {6, 7, 11},
        {6, 8, 8},
        {6, 8, 10},
        {6, 8, 12},
        {6, 9, 9},
        {6, 9, 11},
        {6, 10, 10},
        {6, 10, 12},
        {6, 11, 11},
        {6, 12, 12},
        {7, 7, 8},
        {7, 7, 10},
        {7, 7, 12},
        {7, 8, 9},
        {7, 8, 11},
        {7, 9, 10},
        {7, 9, 12},
        {7, 10, 11},
        {7, 11, 12},
        {8, 8, 8},
        {8, 8, 10},
        {8, 8, 12},
        {8, 9, 9},
        {8, 9, 11},
        {8, 10, 10},
        {8, 10, 12},
        {8, 11, 11},
        {8, 12, 12},
        {9, 9, 10},
        {9, 9, 12},
        {9, 10, 11},
        {9, 11, 12},
        {10, 10, 10},
        {10, 10, 12},
        {10, 11, 11},
        {10, 12, 12},
        {11, 11, 12},
        {12, 12, 12}
    };

    coeffs_all = {
        {1.0},
        {0.5773502691896257,
         -0.5773502691896258,
         0.5773502691896258},
        {0.44721359549995826,
         -0.44721359549995743,
         0.44721359549995787,
         -0.44721359549995787,
         0.4472135954999578},
        {0.3779644730092273,
         -0.3779644730092271,
         0.37796447300922714,
         -0.3779644730092272,
         0.37796447300922714,
         -0.37796447300922714,
         0.37796447300922725},
        {0.3333333333333334,
         -0.33333333333333326,
         0.33333333333333326,
         -0.33333333333333337,
         0.3333333333333333,
         -0.3333333333333333,
         0.33333333333333326,
         -0.33333333333333326,
         0.3333333333333335},
        {0.30151134457776363,
         -0.30151134457776363,
         0.30151134457776363,
         -0.30151134457776363,
         0.30151134457776363,
         -0.30151134457776363,
         0.30151134457776363,
         -0.30151134457776363,
         0.30151134457776363,
         -0.3015113445777637,
         0.3015113445777637},
        {0.2773500981126144,
         -0.2773500981126148,
         0.2773500981126146,
         -0.2773500981126146,
         0.2773500981126146,
         -0.2773500981126146,
         0.2773500981126145,
         -0.2773500981126145,
         0.2773500981126145,
         -0.2773500981126145,
         0.2773500981126145,
         -0.2773500981126145,
         0.2773500981126146},
        {0.2581988897471613,
         -0.2581988897471612,
         0.2581988897471612,
         -0.2581988897471612,
         0.2581988897471612,
         -0.2581988897471612,
         0.2581988897471612,
         -0.25819888974716115,
         0.25819888974716115,
         -0.25819888974716115,
         0.25819888974716115,
         -0.25819888974716115,
         0.25819888974716115,
         -0.25819888974716115,
         0.25819888974716143},
        {0.2425356250363329,
         -0.24253562503633308,
         0.242535625036333,
         -0.24253562503633305,
         0.24253562503633305,
         -0.24253562503633305,
         0.24253562503633305,
         -0.24253562503633305,
         0.24253562503633305,
         -0.242535625036333,
         0.242535625036333,
         -0.242535625036333,
         0.24253562503633294,
         -0.24253562503633294,
         0.24253562503633294,
         -0.24253562503633294,
         0.24253562503633283},
        {0.22941573387056205,
         -0.22941573387056147,
         0.22941573387056186,
         -0.22941573387056158,
         0.22941573387056163,
         -0.22941573387056158,
         0.22941573387056158,
         -0.22941573387056158,
         0.22941573387056202,
         -0.22941573387056202,
         0.22941573387056202,
         -0.22941573387056163,
         0.22941573387056163,
         -0.22941573387056163,
         0.22941573387056163,
         -0.22941573387056163,
         0.22941573387056186,
         -0.22941573387056186,
         0.22941573387056186},
        {0.21821789023599222,
         -0.21821789023599303,
         0.21821789023599245,
         -0.21821789023599245,
         0.21821789023599245,
         -0.21821789023599245,
         0.21821789023599245,
         -0.21821789023599245,
         0.21821789023599245,
         -0.21821789023599245,
         0.21821789023599245,
         -0.21821789023599245,
         0.2182178902359924,
         -0.21821789023599245,
         0.2182178902359924,
         -0.2182178902359924,
         0.2182178902359924,
         -0.2182178902359924,
         0.2182178902359924,
         -0.2182178902359924,
         0.2182178902359924},
        {0.2085144140570748,
         -0.20851441405707483,
         0.2085144140570748,
         -0.2085144140570748,
         0.2085144140570748,
         -0.20851441405707477,
         0.20851441405707474,
         -0.20851441405707474,
         0.20851441405707474,
         -0.20851441405707474,
         0.20851441405707474,
         -0.20851441405707477,
         0.2085144140570748,
         -0.2085144140570748,
         0.2085144140570748,
         -0.2085144140570748,
         0.20851441405707483,
         -0.20851441405707483,
         0.20851441405707485,
         -0.20851441405707485,
         0.20851441405707485,
         -0.20851441405707488,
         0.20851441405707488},
        {0.19999999999999993,
         -0.19999999999999996,
         0.19999999999999993,
         -0.2000000000000001,
         0.2000000000000001,
         -0.20000000000000004,
         0.20000000000000007,
         -0.20000000000000004,
         0.20000000000000007,
         -0.20000000000000004,
         0.20000000000000004,
         -0.20000000000000004,
         0.20000000000000007,
         -0.20000000000000007,
         0.20000000000000007,
         -0.2000000000000001,
         0.2000000000000001,
         -0.20000000000000007,
         0.2000000000000001,
         -0.2000000000000001,
         0.2000000000000001,
         -0.20000000000000012,
         0.1999999999999998,
         -0.1999999999999998,
         0.19999999999999998},
        {0.4472135954999582,
         -0.31622776601683755,
         0.18257418583505539,
         -0.3162277660168379,
         0.36514837167011066,
         -0.3162277660168379,
         0.18257418583505536,
         -0.3162277660168379,
         0.44721359549995787},
        {0.3779644730092273,
         -0.3086066999241839,
         0.23904572186687878,
         -0.16903085094570328,
         0.09759000729485337,
         -0.2182178902359924,
         0.27602622373694174,
         -0.2927700218845599,
         0.27602622373694174,
         -0.2182178902359924,
         0.09759000729485336,
         -0.16903085094570325,
         0.23904572186687872,
         -0.3086066999241838,
         0.3779644730092274},
        {0.3333333333333334,
         -0.28867513459481287,
         0.24397501823713316,
         -0.19920476822239885,
         0.15430334996209175,
         -0.1091089451179961,
         0.06299407883487118,
         -0.1666666666666666,
         0.21821789023599242,
         -0.24397501823713316,
         0.25197631533948467,
         -0.24397501823713316,
         0.21821789023599242,
         -0.16666666666666663,
         0.06299407883487118,
         -0.10910894511799613,
         0.15430334996209175,
         -0.19920476822239885,
         0.2439750182371332,
         -0.2886751345948129,
         0.33333333333333337},
        {0.3015113445777637,
         -0.2696799449852968,
         0.23783535600422528,
         -0.20597146021777488,
         0.17407765595569788,
         -0.14213381090374033,
         0.11009637651263603,
         -0.0778498944161523,
         0.04494665749754948,
         -0.13483997249264837,
         0.17978662999019793,
         -0.20597146021777488,
         0.22019275302527205,
         -0.2247332874877474,
         0.22019275302527205,
         -0.20597146021777488,
         0.17978662999019793,
         -0.13483997249264837,
         0.04494665749754948,
         -0.07784989441615228,
         0.11009637651263604,
         -0.1421338109037404,
         0.17407765595569788,
         -0.20597146021777488,
         0.23783535600422528,
         -0.26967994498529674,
         0.3015113445777636},
        {0.27735009811261463,
         -0.2531848417709164,
         0.229014306207172,
         -0.2048366225996756,
         0.18064892093237825,
         -0.15644655469368585,
         0.1322214713369863,
         -0.1079583792718826,
         0.08362420100070907,
         -0.05913123959890826,
         0.034139437099945914,
         -0.11322770341445962,
         0.1526762041381148,
         -0.17739371879672464,
         0.19312181983410712,
         -0.20197163363339113,
         0.20483662259967583,
         -0.20197163363339113,
         0.19312181983410712,
         -0.17739371879672464,
         0.15267620413811475,
         -0.11322770341445962,
         0.034139437099945914,
         -0.05913123959890826,
         0.08362420100070904,
         -0.1079583792718826,
         0.1322214713369863,
         -0.1564465546936858,
         0.18064892093237825,
         -0.20483662259967564,
         0.22901430620717206,
         -0.2531848417709168,
         0.27735009811261413},
        {0.25819888974716115,
         -0.2390457218668789,
         0.21989008243130992,
         -0.2007312638654984,
         0.18156825980064076,
         -0.1623995885882301,
         0.14322297480788668,
         -0.12403473458920858,
         0.10482848367219176,
         -0.08559209850218255,
         0.06629935441317963,
         -0.04688072309384953,
         0.027066598098038325,
         -0.0975900072948535,
         0.13259870882635894,
         -0.15548576840284842,
         0.17118419700436535,
         -0.18156825980064073,
         0.18752289237539815,
         -0.18946618668626863,
         0.18752289237539815,
         -0.18156825980064073,
         0.17118419700436535,
         -0.15548576840284842,
         0.13259870882635896,
         -0.09759000729485345,
         0.027066598098038318,
         -0.04688072309384953,
         0.06629935441317965,
         -0.08559209850218259,
         0.10482848367219176,
         -0.1240347345892085,
         0.14322297480788668,
         -0.1623995885882301,
         0.1815682598006407,
         -0.2007312638654984,
         0.21989008243130997,
         -0.2390457218668788,
         0.2581988897471612},
        {0.24253562503633294,
         -0.22687130324325755,
         0.21120568916876964,
         -0.1955384722187609,
         0.1798692335461251,
         -0.16419739435729638,
         0.14852213144650117,
         -0.1328422328310144,
         0.1171558372258013,
         -0.1014599312391786,
         0.0857492925712544,
         -0.07001400420140051,
         0.0542326144546641,
         -0.03834824944236854,
         0.022140372138502368,
         -0.08574929257125445,
         0.11715583722580088,
         -0.1382665796887433,
         0.15339299776947388,
         -0.16419739435729636,
         0.1714985851425088,
         -0.17573375583870185,
         0.17712297710801905,
         -0.17573375583870185,
         0.1714985851425088,
         -0.16419739435729636,
         0.1533929977694739,
         -0.1382665796887433,
         0.1171558372258009,
         -0.08574929257125447,
         0.022140372138502368,
         -0.03834824944236854,
         0.05423261445466412,
         -0.07001400420140051,
         0.0857492925712544,
         -0.10145993123917862,
         0.11715583722580132,
         -0.13284223283101443,
         0.14852213144650117,
         -0.16419739435729633,
         0.17986923354612516,
         -0.1955384722187609,
         0.2112056891687697,
         -0.22687130324325736,
         0.24253562503633308},
        {0.22941573387056183,
         -0.21629522817434987,
         0.20317398889287486,
         -0.19005186408533728,
         0.1769286567235604,
         -0.16380410662042993,
         0.15067786290445248,
         -0.1375494407157327,
         0.12441815044835991,
         -0.11128297681493152,
         0.09814236060242514,
         -0.08499377746907312,
         0.07183285265343592,
         -0.05865127858981547,
         0.045431085042425545,
         -0.03212462831016175,
         0.01854716280248858,
         -0.07647191129018732,
         0.10491859671528457,
         -0.12441815044835988,
         0.1387942574072605,
         -0.14953200701331798,
         0.15737789507292652,
         -0.16275069307900134,
         0.1658908672644794,
         -0.16692446522239693,
         0.1658908672644794,
         -0.16275069307900134,
         0.15737789507292652,
         -0.14953200701331798,
         0.13879425740726042,
         -0.12441815044835988,
         0.10491859671528457,
         -0.07647191129018735,
         0.01854716280248858,
         -0.03212462831016175,
         0.04543108504242556,
         -0.05865127858981547,
         0.07183285265343589,
         -0.0849937774690731,
         0.09814236060242515,
         -0.11128297681493154,
         0.12441815044835988,
         -0.1375494407157327,
         0.15067786290445245,
         -0.1638041066204299,
         0.17692865672356034,
         -0.19005186408533728,
         0.20317398889287486,
         -0.21629522817435026,
         0.22941573387056172},
        {0.2182178902359925,
         -0.2070196678027061,
         0.19582100158474863,
         -0.18462181082575685,
         0.17342199390482407,
         -0.16222142113076232,
         0.15101992432741992,
         -0.13981728140845517,
         0.12861319288260686,
         -0.11740724489094462,
         0.10619884881071831,
         -0.09498713802919556,
         0.08377078165833911,
         -0.07254762501100125,
         0.061313933948496435,
         -0.05006261743217588,
         0.03877833671647409,
         -0.027420424855354085,
         0.015831189671532606,
         -0.06900655593423549,
         0.09498713802919549,
         -0.11305730797793681,
         0.1266495173722609,
         -0.13710212427677004,
         0.1450952500220019,
         -0.15101992432742048,
         0.1551133468658961,
         -0.1575183483762703,
         0.1583118967153256,
         -0.15751834837627027,
         0.15511334686589612,
         -0.15101992432742048,
         0.14509525002200196,
         -0.1371021242767701,
         0.12664951737226088,
         -0.11305730797793678,
         0.09498713802919549,
         -0.06900655593423549,
         0.015831189671532606,
         -0.027420424855354085,
         0.03877833671647409,
         -0.05006261743217587,
         0.061313933948496435,
         -0.07254762501100125,
         0.0837707816583391,
         -0.09498713802919558,
         0.10619884881071831,
         -0.11740724489094459,
         0.12861319288260686,
         -0.1398172814084551,
         0.15101992432741998,
         -0.1622214211307623,
         0.17342199390482405,
         -0.18462181082575688,
         0.19582100158474863,
         -0.20701966780270606,
         0.21821789023599247},
        {0.20851441405707524,
         -0.19881069312188582,
         0.18910668975254744,
         -0.17940235811786176,
         0.16969764190127948,
         -0.15999247111968176,
         0.15028675770882577,
         -0.14058038927888314,
         0.13087322008912053,
         -0.12116505768046475,
         0.11145564251507056,
         -0.10174461594455991,
         0.09203146787097731,
         -0.08231544729143728,
         0.07259540086406278,
         -0.06286946134619317,
         0.053134392749225004,
         -0.043384050009413276,
         0.03360514063549751,
         -0.023762422826087874,
         0.013719241215239554,
         -0.06286946134619313,
         0.08676810001882661,
         -0.10357799975260108,
         0.11641162195235816,
         -0.12648515430422563,
         0.1344205625419898,
         -0.14058038927888333,
         0.14519080172812504,
         -0.14839628298601576,
         0.1502867577088255,
         -0.15091165336763512,
         0.1502867577088255,
         -0.14839628298601576,
         0.14519080172812507,
         -0.1405803892788833,
         0.1344205625419898,
         -0.12648515430422563,
         0.11641162195235813,
         -0.10357799975260105,
         0.08676810001882665,
         -0.06286946134619313,
         0.013719241215239547,
         -0.023762422826087874,
         0.03360514063549749,
         -0.043384050009413276,
         0.053134392749225004,
         -0.06286946134619316,
         0.07259540086406278,
         -0.08231544729143729,
         0.09203146787097731,
         -0.10174461594455993,
         0.11145564251507051,
         -0.12116505768046472,
         0.1308732200891205,
         -0.14058038927888314,
         0.1502867577088258,
         -0.1599924711196818,
         0.16969764190127953,
         -0.17940235811786184,
         0.1891066897525474,
         -0.19881069312188598,
         0.20851441405707508},
        {0.19999999999999954,
         -0.1914854215512677,
         0.1829706557608768,
         -0.1744556751977293,
         0.1659404467996215,
         -0.15742493034984054,
         0.1489090764308149,
         -0.140392823632607,
         0.13187609467915745,
         -0.1233587909487921,
         0.11484078455453643,
         -0.10632190661423907,
         0.09780192938436533,
         -0.08928053815224023,
         0.08075728530872485,
         -0.07223151185146155,
         0.06370220572706063,
         -0.055167728436737104,
         0.04662524041201558,
         -0.03806934938134404,
         0.029488391230979457,
         -0.020851441405707452,
         0.01203858530857692,
         -0.05773502691896255,
         0.07985494095046922,
         -0.09555330859059072,
         0.10767638041163319,
         -0.11733761520513757,
         0.12510864843424455,
         -0.13132546139874876,
         0.13620104492139962,
         -0.1398757212360472,
         0.14244246232238345,
         -0.14396054209803308,
         0.1444630237029231,
         -0.14396054209803308,
         0.14244246232238345,
         -0.1398757212360472,
         0.13620104492139962,
         -0.1313254613987488,
         0.12510864843424457,
         -0.11733761520513757,
         0.10767638041163319,
         -0.09555330859059072,
         0.0798549409504692,
         -0.05773502691896255,
         0.01203858530857692,
         -0.020851441405707452,
         0.029488391230979457,
         -0.03806934938134406,
         0.04662524041201559,
         -0.05516772843673709,
         0.06370220572706063,
         -0.07223151185146155,
         0.08075728530872484,
         -0.08928053815224023,
         0.09780192938436531,
         -0.10632190661423907,
         0.11484078455453643,
         -0.1233587909487921,
         0.13187609467915748,
         -0.140392823632607,
         0.14890907643081486,
         -0.1574249303498406,
         0.16594044679962147,
         -0.17445567519772934,
         0.18297065576087673,
         -0.1914854215512678,
         0.19999999999999943},
        {0.2390457218668787,
         -0.29277002188456014,
         0.23904572186687872,
         -0.2927700218845599,
         0.11952286093343932,
         0.11952286093343935,
         -0.2927700218845599,
         0.23904572186687878,
         0.11952286093343935,
         -0.2390457218668787,
         0.11952286093343935,
         0.23904572186687878,
         -0.2927700218845599,
         0.11952286093343935,
         0.11952286093343938,
         -0.2927700218845599,
         0.23904572186687878,
         -0.29277002188455986,
         0.23904572186687878},
        {0.3333333333333334,
         -0.2357022603955159,
         0.15430334996209197,
         -0.08908708063747481,
         0.039840953644479773,
         -0.2357022603955159,
         0.25197631533948484,
         -0.21821789023599225,
         0.15936381457791918,
         -0.08908708063747482,
         0.15430334996209197,
         -0.21821789023599225,
         0.23904572186687878,
         -0.21821789023599225,
         0.15430334996209197,
         -0.08908708063747482,
         0.15936381457791912,
         -0.21821789023599225,
         0.2519763153394849,
         -0.23570226039551595,
         0.039840953644479773,
         -0.08908708063747482,
         0.15430334996209194,
         -0.23570226039551595,
         0.3333333333333335},
        {0.15430334996209194,
         -0.21821789023599225,
         0.23904572186687864,
         -0.2182178902359923,
         0.15430334996209194,
         -0.24397501823713325,
         0.18898223650461368,
         -0.06900655593423541,
         -0.06900655593423541,
         0.18898223650461368,
         -0.24397501823713325,
         0.2439750182371334,
         -0.14638501094228004,
         0.1951800145897063,
         -0.14638501094228004,
         0.24397501823713333,
         -0.24397501823713325,
         0.18898223650461368,
         -0.06900655593423542,
         -0.06900655593423542,
         0.18898223650461368,
         -0.24397501823713325,
         0.1543033499620919,
         -0.2182178902359923,
         0.23904572186687875,
         -0.2182178902359923,
         0.15430334996209188},
        {0.30151134457776385,
         -0.2335496832484566,
         0.1740776559556978,
         -0.12309149097933272,
         0.08058229640253795,
         -0.04652421051992354,
         0.020806259464411968,
         -0.1906925178491184,
         0.2201927530252723,
         -0.21320071635561044,
         0.18609684207969426,
         -0.14712247158412486,
         0.10192943828752513,
         -0.055048188256318006,
         0.1100963765126361,
         -0.16514456476895403,
         0.19738550848793068,
         -0.20806259464411986,
         0.19738550848793068,
         -0.16514456476895403,
         0.1100963765126361,
         -0.05504818825631802,
         0.10192943828752511,
         -0.14712247158412486,
         0.1860968420796943,
         -0.21320071635561044,
         0.22019275302527225,
         -0.19069251784911834,
         0.020806259464411964,
         -0.04652421051992354,
         0.08058229640253793,
         -0.12309149097933268,
         0.1740776559556978,
         -0.2335496832484568,
         0.3015113445777636},
        {0.1100963765126361,
         -0.165144564768954,
         0.19738550848793063,
         -0.2080625946441197,
         0.1973855084879306,
         -0.16514456476895414,
         0.1100963765126361,
         -0.20597146021777496,
         0.1946247360403808,
         -0.13241022442571238,
         0.04652421051992364,
         0.04652421051992364,
         -0.13241022442571238,
         0.19462473604038083,
         -0.20597146021777496,
         0.23783535600422537,
         -0.059458839001056384,
         -0.06795295885835019,
         0.1444000375739935,
         -0.16988239714587525,
         0.14440003757399353,
         -0.06795295885835019,
         -0.059458839001056384,
         0.23783535600422542,
         -0.20597146021777496,
         0.19462473604038083,
         -0.13241022442571238,
         0.04652421051992365,
         0.04652421051992365,
         -0.13241022442571238,
         0.19462473604038083,
         -0.20597146021777496,
         0.11009637651263612,
         -0.16514456476895412,
         0.19738550848793074,
         -0.20806259464411975,
         0.19738550848793074,
         -0.16514456476895414,
         0.11009637651263607},
        {0.2773500981126143,
         -0.22645540682891918,
         0.18064892093237814,
         -0.13993005245628817,
         0.10429770312912406,
         -0.07374961314478502,
         0.04828045495852676,
         -0.02787473366690302,
         0.01246595986677943,
         -0.1601281538050872,
         0.19312181983410695,
         -0.1978909779672614,
         0.18657340327505106,
         -0.16490914830605127,
         0.13655774839978396,
         -0.10429770312912395,
         0.07051811804639269,
         -0.03739787960033826,
         0.08362420100070904,
         -0.1295500551262591,
         0.16157730690671301,
         -0.1806489209323783,
         0.18698939800169156,
         -0.1806489209323783,
         0.161577306906713,
         -0.1295500551262591,
         0.08362420100070905,
         -0.03739787960033826,
         0.07051811804639269,
         -0.10429770312912395,
         0.13655774839978393,
         -0.16490914830605122,
         0.18657340327505104,
         -0.19789097796726135,
         0.19312181983410698,
         -0.1601281538050872,
         0.01246595986677943,
         -0.027874733666903014,
         0.04828045495852677,
         -0.073749613144785,
         0.1042977031291241,
         -0.13993005245628817,
         0.18064892093237817,
         -0.22645540682891926,
         0.2773500981126144},
        {0.08362420100070904,
         -0.12955005512625928,
         0.161577306906713,
         -0.1806489209323783,
         0.18698939800169156,
         -0.1806489209323783,
         0.161577306906713,
         -0.12955005512625906,
         0.08362420100070911,
         -0.17739371879672475,
         0.1851100598717808,
         -0.15267620413811483,
         0.0989454889836309,
         -0.03413943709994597,
         -0.03413943709994596,
         0.0989454889836309,
         -0.15267620413811483,
         0.18511005987178078,
         -0.17739371879672472,
         0.2290143062071723,
         -0.09160572248286887,
         -0.01526762041381152,
         0.09160572248286881,
         -0.1374085837243036,
         0.15267620413811514,
         -0.1374085837243036,
         0.09160572248286881,
         -0.015267620413811517,
         -0.09160572248286886,
         0.2290143062071723,
         -0.17739371879672472,
         0.18511005987178075,
         -0.15267620413811483,
         0.0989454889836309,
         -0.03413943709994597,
         -0.03413943709994598,
         0.09894548898363092,
         -0.1526762041381148,
         0.1851100598717808,
         -0.17739371879672475,
         0.08362420100070911,
         -0.129550055126259,
         0.16157730690671296,
         -0.1806489209323784,
         0.18698939800169143,
         -0.1806489209323784,
         0.16157730690671296,
         -0.129550055126259,
         0.08362420100070914},
        {0.258198889747161,
         -0.2182178902359927,
         0.18156825980064045,
         -0.1482498633322203,
         0.11826247919781659,
         -0.09160572248286888,
         0.06827887419989194,
         -0.04828045495852679,
         0.03160697706205068,
         -0.0182482967150453,
         0.00816088638568548,
         -0.138013111868471,
         0.171184197004365,
         -0.18156825980064079,
         0.1787960625070698,
         -0.16724840200141827,
         0.1495915184013532,
         -0.12773807700531717,
         0.10322795481850183,
         -0.07742096611387633,
         0.05161397740925096,
         -0.027066598098038346,
         0.06629935441317951,
         -0.10482848367219189,
         0.13409704688030225,
         -0.1548419322277527,
         0.16724840200141827,
         -0.17137861409939517,
         0.16724840200141824,
         -0.15484193222775267,
         0.13409704688030222,
         -0.10482848367219189,
         0.06629935441317951,
         -0.027066598098038346,
         0.05161397740925096,
         -0.07742096611387633,
         0.10322795481850182,
         -0.12773807700531714,
         0.1495915184013532,
         -0.16724840200141827,
         0.1787960625070698,
         -0.1815682598006407,
         0.171184197004365,
         -0.13801311186847096,
         0.008160886385685477,
         -0.018248296715045298,
         0.03160697706205068,
         -0.04828045495852679,
         0.06827887419989194,
         -0.09160572248286886,
         0.11826247919781656,
         -0.14824986333222026,
         0.18156825980064045,
         -0.21821789023599258,
         0.25819888974716104},
        {0.0662993544131795,
         -0.104828483672192,
         0.1340970468803022,
         -0.1548419322277528,
         0.16724840200141833,
         -0.171378614099395,
         0.16724840200141836,
         -0.15484193222775275,
         0.13409704688030222,
         -0.10482848367219197,
         0.06629935441317951,
         -0.15548576840284828,
         0.17225077552896462,
         -0.15644655469368576,
         0.1224132957852823,
         -0.07742096611387643,
         0.02644429426739715,
         0.02644429426739715,
         -0.07742096611387643,
         0.1224132957852823,
         -0.15644655469368576,
         0.17225077552896462,
         -0.15548576840284828,
         0.21989008243130978,
         -0.10994504121565538,
         0.01999000749375526,
         0.04997501873438853,
         -0.09995003746877754,
         0.12993504870941053,
         -0.13993005245628823,
         0.12993504870941053,
         -0.09995003746877755,
         0.04997501873438853,
         0.01999000749375526,
         -0.10994504121565538,
         0.21989008243130978,
         -0.15548576840284828,
         0.17225077552896467,
         -0.15644655469368576,
         0.1224132957852823,
         -0.07742096611387643,
         0.02644429426739715,
         0.026444294267397153,
         -0.07742096611387643,
         0.12241329578528228,
         -0.15644655469368576,
         0.17225077552896467,
         -0.15548576840284828,
         0.06629935441317951,
         -0.10482848367219197,
         0.13409704688030222,
         -0.15484193222775283,
         0.16724840200141836,
         -0.17137861409939498,
         0.16724840200141836,
         -0.15484193222775286,
         0.13409704688030222,
         -0.10482848367219194,
         0.0662993544131795},
        {0.24253562503633325,
         -0.2100420126042014,
         0.17986923354612513,
         -0.1520172480262652,
         0.12648599596468268,
         -0.10327538324040182,
         0.08238525545716341,
         -0.06381534447172758,
         0.04756514941544943,
         -0.03363363969981567,
         0.022018385688753864,
         -0.01271232090452304,
         0.005685122738861028,
         -0.12126781251816657,
         0.1533929977694739,
         -0.16652655174768632,
         0.16864799461957705,
         -0.163292718633225,
         0.15254785085427638,
         -0.13785690003361395,
         0.12033136751923744,
         -0.10090091909944694,
         0.08039977681052946,
         -0.05962607031450771,
         0.03938768572388969,
         -0.020498001542269738,
         0.05423261445466404,
         -0.08696565534786733,
         0.1131325140715179,
         -0.13332794645442142,
         0.14770382146458635,
         -0.15631503171567182,
         0.15918343668810858,
         -0.15631503171567182,
         0.14770382146458635,
         -0.13332794645442136,
         0.11313251407151793,
         -0.08696565534786733,
         0.05423261445466404,
         -0.020498001542269738,
         0.03938768572388969,
         -0.059626070314507694,
         0.08039977681052943,
         -0.10090091909944694,
         0.12033136751923741,
         -0.13785690003361395,
         0.1525478508542764,
         -0.163292718633225,
         0.16864799461957705,
         -0.16652655174768624,
         0.153392997769474,
         -0.12126781251816651,
         0.005685122738861028,
         -0.012712320904523039,
         0.02201838568875387,
         -0.03363363969981567,
         0.04756514941544941,
         -0.06381534447172758,
         0.0823852554571634,
         -0.10327538324040182,
         0.12648599596468263,
         -0.15201724802626526,
         0.17986923354612513,
         -0.21004201260420136,
         0.2425356250363331},
        {0.05423261445466401,
         -0.08696565534786727,
         0.11313251407151792,
         -0.13332794645442153,
         0.14770382146458627,
         -0.15631503171567201,
         0.15918343668810844,
         -0.15631503171567201,
         0.14770382146458627,
         -0.13332794645442153,
         0.11313251407151792,
         -0.0869656553478673,
         0.05423261445466399,
         -0.13826657968874329,
         0.15943703480442306,
         -0.15349831394924765,
         0.1319879330834378,
         -0.1004997210131615,
         0.06266542425886577,
         -0.021271781490575712,
         -0.021271781490575712,
         0.06266542425886577,
         -0.1004997210131615,
         0.13198793308343781,
         -0.15349831394924765,
         0.159437034804423,
         -0.13826657968874326,
         0.21120568916876958,
         -0.12068896523929684,
         0.04409789114512783,
         0.018567533113738075,
         -0.06730730753730048,
         0.10212143212555864,
         -0.12300990687851428,
         0.12997273179616592,
         -0.12300990687851428,
         0.10212143212555866,
         -0.06730730753730048,
         0.018567533113738075,
         0.04409789114512783,
         -0.12068896523929684,
         0.21120568916876956,
         -0.1382665796887433,
         0.15943703480442306,
         -0.15349831394924765,
         0.13198793308343776,
         -0.10049972101316153,
         0.06266542425886577,
         -0.021271781490575712,
         -0.021271781490575712,
         0.06266542425886577,
         -0.10049972101316154,
         0.13198793308343781,
         -0.15349831394924765,
         0.15943703480442306,
         -0.13826657968874329,
         0.05423261445466401,
         -0.08696565534786728,
         0.11313251407151793,
         -0.13332794645442156,
         0.14770382146458627,
         -0.15631503171567201,
         0.15918343668810847,
         -0.15631503171567201,
         0.14770382146458627,
         -0.13332794645442156,
         0.11313251407151793,
         -0.08696565534786733,
         0.05423261445466402},
        {0.22941573387056177,
         -0.20232565955562776,
         0.17692865672356062,
         -0.1532247113800595,
         0.13121380363171364,
         -0.11089590441845487,
         0.09227096991223659,
         -0.0753389314522263,
         0.06009967640704209,
         -0.04655300916738581,
         0.034698564351815064,
         -0.02453559015060626,
         0.0160623141550809,
         -0.009273581401244279,
         0.004147271681612001,
         -0.10814761408717523,
         0.13879425740726042,
         -0.15322471138005972,
         0.15824980144064263,
         -0.15683049204020896,
         0.15067786290445254,
         -0.14094623468993933,
         0.12849851324064696,
         -0.11403111845120278,
         0.09814236060242522,
         -0.08137534653950045,
         0.06424925662032337,
         -0.04728617252583586,
         0.031035339444923815,
         -0.016062314155080887,
         0.04543108504242553,
         -0.07360677045181867,
         0.09690781635658215,
         -0.11582699457751021,
         0.13049085706320443,
         -0.14094623468993925,
         0.14721354090363775,
         -0.14930178053803178,
         0.14721354090363775,
         -0.14094623468993925,
         0.13049085706320443,
         -0.11582699457751024,
         0.09690781635658213,
         -0.07360677045181867,
         0.04543108504242554,
         -0.016062314155080887,
         0.03103533944492383,
         -0.04728617252583586,
         0.06424925662032337,
         -0.08137534653950045,
         0.0981423606024252,
         -0.11403111845120278,
         0.128498513240647,
         -0.14094623468993925,
         0.15067786290445265,
         -0.156830492040209,
         0.1582498014406427,
         -0.15322471138005972,
         0.13879425740726045,
         -0.10814761408717526,
         0.004147271681612003,
         -0.009273581401244279,
         0.0160623141550809,
         -0.02453559015060626,
         0.03469856435181506,
         -0.04655300916738581,
         0.06009967640704208,
         -0.07533893145222632,
         0.0922709699122366,
         -0.1108959044184549,
         0.13121380363171367,
         -0.15322471138005955,
         0.17692865672356062,
         -0.20232565955562798,
         0.22941573387056177},
        {0.045431085042425476,
         -0.07360677045181818,
         0.0969078163565821,
         -0.1158269945775104,
         0.13049085706320462,
         -0.14094623468993928,
         0.1472135409036377,
         -0.14930178053803173,
         0.1472135409036377,
         -0.14094623468993925,
         0.13049085706320462,
         -0.11582699457751043,
         0.0969078163565821,
         -0.0736067704518187,
         0.045431085042425434,
         -0.12441815044835988,
         0.14765102638788216,
         -0.14782565805907538,
         0.13457880631198615,
         -0.11243619908556608,
         0.0842314860396877,
         -0.05204784652772266,
         0.017595383576944432,
         0.017595383576944432,
         -0.052047846527722666,
         0.0842314860396877,
         -0.11243619908556608,
         0.13457880631198615,
         -0.1478256580590754,
         0.14765102638788213,
         -0.12441815044835988,
         0.2031739888928746,
         -0.12698374305804605,
         0.06095219666786279,
         -0.005079349722321398,
         -0.040634797778574844,
         0.07619024583482778,
         -0.10158699444643747,
         0.11682504361340308,
         -0.12190439333572452,
         0.11682504361340308,
         -0.1015869944464375,
         0.07619024583482778,
         -0.040634797778574844,
         -0.005079349722321397,
         0.06095219666786281,
         -0.12698374305804605,
         0.20317398889287458,
         -0.12441815044835985,
         0.14765102638788222,
         -0.1478256580590754,
         0.13457880631198615,
         -0.11243619908556605,
         0.08423148603968772,
         -0.05204784652772265,
         0.017595383576944432,
         0.017595383576944436,
         -0.05204784652772265,
         0.08423148603968772,
         -0.11243619908556608,
         0.13457880631198615,
         -0.14782565805907538,
         0.14765102638788222,
         -0.12441815044835983,
         0.04543108504242542,
         -0.07360677045181871,
         0.09690781635658215,
         -0.1158269945775104,
         0.1304908570632046,
         -0.14094623468993928,
         0.14721354090363759,
         -0.14930178053803173,
         0.14721354090363759,
         -0.14094623468993925,
         0.1304908570632046,
         -0.1158269945775104,
         0.09690781635658216,
         -0.07360677045181871,
         0.04543108504242545},
        {0.21821789023599233,
         -0.19518001458970669,
         0.17342199390482424,
         -0.15294382258037442,
         0.1337454929975021,
         -0.11582699457751022,
         0.09918831228239343,
         -0.08382942414480593,
         0.06975029703385756,
         -0.05695087904683814,
         0.04543108504242544,
         -0.03519076715388936,
         0.0262296491788211,
         -0.01854716280248857,
         0.01214196820986759,
         -0.00701016861445893,
         0.0031350427111331417,
         -0.09759000729485334,
         0.12664951737226077,
         -0.141598465080958,
         0.1483773024199086,
         -0.14953200701331806,
         0.1465108469587617,
         -0.14027345645865924,
         0.13152242139311093,
         -0.12081105830566236,
         0.10860106519162142,
         -0.0952970479489331,
         0.08126959555714969,
         -0.06687274649875102,
         0.05245929835764212,
         -0.03839627482053895,
         0.025080341689065144,
         -0.012926112238824698,
         0.038778336716474085,
         -0.06332475868613038,
         0.0841220233735074,
         -0.10158699444643703,
         0.11582699457751022,
         -0.126882115396262,
         0.13477037766349995,
         -0.13950059406771534,
         0.14107692200099112,
         -0.13950059406771534,
         0.13477037766349995,
         -0.12688211539626204,
         0.11582699457751022,
         -0.10158699444643704,
         0.0841220233735074,
         -0.06332475868613038,
         0.03877833671647408,
         -0.012926112238824698,
         0.02508034168906515,
         -0.038396274820538964,
         0.05245929835764211,
         -0.06687274649875102,
         0.08126959555714969,
         -0.0952970479489331,
         0.10860106519162142,
         -0.12081105830566233,
         0.1315224213931109,
         -0.14027345645865924,
         0.1465108469587617,
         -0.1495320070133181,
         0.14837730241990862,
         -0.141598465080958,
         0.12664951737226077,
         -0.09759000729485337,
         0.003135042711133142,
         -0.007010168614458926,
         0.012141968209867592,
         -0.018547162802488578,
         0.026229649178821098,
         -0.035190767153889385,
         0.045431085042425434,
         -0.05695087904683814,
         0.06975029703385756,
         -0.08382942414480593,
         0.09918831228239339,
         -0.1158269945775102,
         0.13374549299750205,
         -0.15294382258037448,
         0.17342199390482427,
         -0.1951800145897067,
         0.2182178902359923},
        {0.03877833671647408,
         -0.06332475868612986,
         0.0841220233735075,
         -0.10158699444643689,
         0.11582699457751046,
         -0.12688211539626187,
         0.13477037766349975,
         -0.13950059406771523,
         0.14107692200099123,
         -0.13950059406771523,
         0.13477037766349975,
         -0.12688211539626187,
         0.11582699457751047,
         -0.10158699444643692,
         0.0841220233735075,
         -0.06332475868613037,
         0.03877833671647406,
         -0.11305730797793677,
         0.13710212427677065,
         -0.14118138474910827,
         0.1335616503085432,
         -0.11803342130469549,
         0.09690781635658167,
         -0.07183285265343582,
         0.0441139612200552,
         -0.01487081329363509,
         -0.01487081329363509,
         0.0441139612200552,
         -0.07183285265343581,
         0.09690781635658167,
         -0.11803342130469552,
         0.13356165030854322,
         -0.14118138474910827,
         0.13710212427677065,
         -0.11305730797793676,
         0.19582100158474844,
         -0.13054733438983268,
         0.07295292215902445,
         -0.023037764892322732,
         -0.01919813741026909,
         0.05375478474875477,
         -0.0806321771231314,
         0.09983031453340135,
         -0.11134919697956291,
         0.11518882446161707,
         -0.11134919697956291,
         0.09983031453340135,
         -0.0806321771231314,
         0.05375478474875477,
         -0.01919813741026909,
         -0.023037764892322732,
         0.07295292215902445,
         -0.13054733438983268,
         0.19582100158474844,
         -0.11305730797793677,
         0.13710212427677065,
         -0.14118138474910824,
         0.13356165030854325,
         -0.11803342130469552,
         0.09690781635658166,
         -0.0718328526534358,
         0.04411396122005521,
         -0.01487081329363509,
         -0.01487081329363509,
         0.04411396122005521,
         -0.0718328526534358,
         0.09690781635658167,
         -0.11803342130469555,
         0.13356165030854322,
         -0.14118138474910824,
         0.1371021242767707,
         -0.11305730797793674,
         0.03877833671647403,
         -0.06332475868613036,
         0.08412202337350753,
         -0.10158699444643689,
         0.1158269945775105,
         -0.12688211539626187,
         0.1347703776634998,
         -0.1395005940677152,
         0.14107692200099128,
         -0.1395005940677152,
         0.13477037766349978,
         -0.12688211539626187,
         0.1158269945775105,
         -0.10158699444643692,
         0.08412202337350755,
         -0.06332475868613036,
         0.03877833671647406},
        {0.20851441405707513,
         -0.18860838403857927,
         0.16969764190127948,
         -0.15178218516507114,
         0.1348620105695289,
         -0.11893711375904584,
         0.10400748880880108,
         -0.0900731274922473,
         0.07713401811504476,
         -0.0651901435942368,
         0.0542414781655109,
         -0.0442879814666056,
         0.035329587287176945,
         -0.027366180638323537,
         0.02039754673060994,
         -0.014423243612783819,
         0.009442229374624293,
         -0.005451473671189535,
         0.002437973141266032,
         -0.0889108448948774,
         0.1164116219523582,
         -0.13144722819486498,
         0.13928488559248933,
         -0.14215704107647095,
         0.14131834914870756,
         -0.1375889749382107,
         0.13156022334011344,
         -0.12368960085073441,
         0.11435107643820402,
         -0.10386452312086762,
         0.0925145760085929,
         -0.0805638544074684,
         0.06826324795544869,
         -0.05586098231060415,
         0.04361178936951629,
         -0.0317872807327219,
         0.02068688808647853,
         -0.010626878549845033,
         0.03360514063549753,
         -0.05521888072258631,
         0.07386696533943111,
         -0.08990800704635266,
         0.10343444043239239,
         -0.11448094709498016,
         0.1230633203665414,
         -0.1291895746931501,
         0.13286394439981672,
         -0.1340885227696317,
         0.13286394439981672,
         -0.12918957469315015,
         0.12306332036654143,
         -0.11448094709498019,
         0.10343444043239237,
         -0.08990800704635266,
         0.0738669653394311,
         -0.05521888072258632,
         0.03360514063549753,
         -0.010626878549845028,
         0.020686888086478533,
         -0.03178728073272188,
         0.0436117893695163,
         -0.05586098231060415,
         0.06826324795544865,
         -0.08056385440746837,
         0.0925145760085929,
         -0.10386452312086762,
         0.11435107643820405,
         -0.12368960085073444,
         0.1315602233401134,
         -0.13758897493821068,
         0.1413183491487075,
         -0.14215704107647098,
         0.13928488559248933,
         -0.13144722819486498,
         0.11641162195235817,
         -0.08891084489487741,
         0.0024379731412660327,
         -0.005451473671189535,
         0.009442229374624286,
         -0.014423243612783819,
         0.02039754673060994,
         -0.027366180638323537,
         0.035329587287176945,
         -0.0442879814666056,
         0.05424147816551093,
         -0.06519014359423682,
         0.07713401811504475,
         -0.09007312749224734,
         0.10400748880880108,
         -0.11893711375904586,
         0.1348620105695289,
         -0.15178218516507125,
         0.1696976419012795,
         -0.18860838403857913,
         0.20851441405707516},
        {0.033605140635497535,
         -0.05521888072258607,
         0.07386696533943116,
         -0.08990800704635268,
         0.10343444043239243,
         -0.11448094709498019,
         0.12306332036654148,
         -0.12918957469315026,
         0.13286394439981675,
         -0.1340885227696317,
         0.13286394439981675,
         -0.1291895746931502,
         0.12306332036654151,
         -0.11448094709498019,
         0.10343444043239243,
         -0.08990800704635267,
         0.07386696533943114,
         -0.05521888072258634,
         0.033605140635497535,
         -0.10357799975260135,
         0.12774374405250166,
         -0.13436527956102054,
         0.13067627006016394,
         -0.11993242076616946,
         0.10407889800966694,
         -0.08447145968645449,
         0.06215636310465244,
         -0.03800424013344968,
         0.012784839010804823,
         0.012784839010804823,
         -0.03800424013344968,
         0.06215636310465244,
         -0.08447145968645449,
         0.10407889800966692,
         -0.11993242076616943,
         0.13067627006016394,
         -0.13436527956102057,
         0.12774374405250166,
         -0.10357799975260133,
         0.18910668975254744,
         -0.13237468282678286,
         0.08161446610373102,
         -0.036826039583391146,
         -0.001990596734237797,
         0.03483544284915321,
         -0.061708498761357033,
         0.08260976447085049,
         -0.09753923997762912,
         0.10649692528169818,
         -0.10948282038305357,
         0.10649692528169818,
         -0.09753923997762912,
         0.08260976447085049,
         -0.061708498761357033,
         0.03483544284915322,
         -0.001990596734237797,
         -0.036826039583391146,
         0.08161446610373102,
         -0.13237468282678286,
         0.18910668975254746,
         -0.10357799975260133,
         0.12774374405250163,
         -0.13436527956102054,
         0.13067627006016394,
         -0.11993242076616943,
         0.10407889800966691,
         -0.08447145968645449,
         0.06215636310465245,
         -0.038004240133449683,
         0.01278483901080483,
         0.012784839010804832,
         -0.038004240133449683,
         0.062156363104652466,
         -0.08447145968645449,
         0.10407889800966692,
         -0.11993242076616946,
         0.1306762700601639,
         -0.1343652795610205,
         0.1277437440525016,
         -0.10357799975260133,
         0.03360514063549752,
         -0.05521888072258633,
         0.07386696533943111,
         -0.0899080070463527,
         0.10343444043239249,
         -0.11448094709498025,
         0.12306332036654154,
         -0.1291895746931502,
         0.13286394439981672,
         -0.13408852276963176,
         0.13286394439981672,
         -0.1291895746931502,
         0.12306332036654154,
         -0.1144809470949802,
         0.1034344404323925,
         -0.08990800704635271,
         0.0738669653394311,
         -0.05521888072258633,
         0.03360514063549752},
        {0.1999999999999998,
         -0.18257418583505547,
         0.1659404467996216,
         -0.15009878170316587,
         0.13504918902264748,
         -0.12079166678434335,
         0.10732621239353396,
         -0.09465282238392972,
         0.08277149204042512,
         -0.07168221481614952,
         0.061384981404485006,
         -0.051879778210431465,
         0.04316658473017162,
         -0.03524536884251207,
         0.02811607785577667,
         -0.021778620259218857,
         0.016232825118589096,
         -0.011478340719169701,
         0.0075143378854412735,
         -0.004338405000941326,
         0.0019401936992059715,
         -0.08164965809277269,
         0.10767638041163324,
         -0.12255514206205213,
         0.13101695788103082,
         -0.13504918902264726,
         0.13575811352102357,
         -0.13385930513224542,
         0.12986260094871283,
         -0.12415723806063786,
         0.11705656662142558,
         -0.10882394085641144,
         0.09968895725584533,
         -0.0898584117458723,
         0.07952427724875423,
         -0.06887004431501831,
         0.058076320691250224,
         -0.047326411191964846,
         0.036812587148390856,
         -0.026743724538353348,
         0.017353620003765342,
         -0.008891084489487729,
         0.02948839123097948,
         -0.04869847535576731,
         0.06550847894051542,
         -0.08023117361505999,
         0.09294722642476436,
         -0.10368697190241662,
         0.11246431142310666,
         -0.11928641587313149,
         0.12415723806063764,
         -0.12707898458431813,
         0.12805278414759413,
         -0.12707898458431813,
         0.12415723806063761,
         -0.11928641587313146,
         0.11246431142310669,
         -0.10368697190241662,
         0.09294722642476437,
         -0.08023117361505999,
         0.06550847894051542,
         -0.04869847535576732,
         0.02948839123097948,
         -0.008891084489487729,
         0.01735362000376534,
         -0.02674372453835335,
         0.03681258714839085,
         -0.047326411191964846,
         0.05807632069125021,
         -0.06887004431501828,
         0.07952427724875423,
         -0.08985841174587232,
         0.09968895725584527,
         -0.10882394085641144,
         0.11705656662142558,
         -0.12415723806063783,
         0.1298626009487128,
         -0.13385930513224542,
         0.13575811352102357,
         -0.13504918902264726,
         0.13101695788103085,
         -0.12255514206205213,
         0.10767638041163322,
         -0.08164965809277268,
         0.0019401936992059715,
         -0.004338405000941326,
         0.007514337885441272,
         -0.011478340719169705,
         0.016232825118589096,
         -0.02177862025921886,
         0.02811607785577668,
         -0.03524536884251207,
         0.043166584730171646,
         -0.051879778210431486,
         0.06138498140448499,
         -0.07168221481614952,
         0.08277149204042512,
         -0.09465282238392975,
         0.107326212393534,
         -0.12079166678434335,
         0.13504918902264748,
         -0.15009878170316585,
         0.16594044679962155,
         -0.1825741858350555,
         0.19999999999999976},
        {0.029488391230979506,
         -0.04869847535576666,
         0.06550847894051542,
         -0.08023117361506,
         0.0929472264247644,
         -0.10368697190241664,
         0.11246431142310669,
         -0.11928641587313146,
         0.12415723806063761,
         -0.12707898458431813,
         0.12805278414759375,
         -0.1270789845843181,
         0.12415723806063761,
         -0.11928641587313146,
         0.11246431142310669,
         -0.10368697190241662,
         0.0929472264247644,
         -0.08023117361505999,
         0.0655084789405154,
         -0.04869847535576736,
         0.029488391230979495,
         -0.09555330859059102,
         0.11945197655776697,
         -0.1277437440525018,
         0.12685662398599754,
         -0.11964090823227037,
         0.10777247715580363,
         -0.09239886042108235,
         0.07438814984891452,
         -0.05444655064804762,
         0.03318241763650202,
         -0.011145564251507327,
         -0.011145564251507327,
         0.033182417636502023,
         -0.05444655064804762,
         0.07438814984891452,
         -0.09239886042108236,
         0.10777247715580363,
         -0.11964090823227035,
         0.12685662398599754,
         -0.1277437440525018,
         0.11945197655776697,
         -0.09555330859059101,
         0.18297065576087723,
         -0.13306956782609194,
         0.0879209644565252,
         -0.047524845652175636,
         0.01188121141304381,
         0.019009938260869778,
         -0.04514860336956694,
         0.06653478391304671,
         -0.08316847989130673,
         0.09504969130435245,
         -0.10217841815217714,
         0.10455466043478713,
         -0.10217841815217714,
         0.09504969130435245,
         -0.08316847989130671,
         0.06653478391304671,
         -0.045148603369566935,
         0.01900993826086978,
         0.01188121141304381,
         -0.047524845652175636,
         0.0879209644565252,
         -0.13306956782609197,
         0.18297065576087723,
         -0.09555330859059101,
         0.119451976557767,
         -0.1277437440525018,
         0.12685662398599754,
         -0.11964090823227037,
         0.1077724771558036,
         -0.09239886042108233,
         0.07438814984891452,
         -0.05444655064804762,
         0.03318241763650201,
         -0.01114556425150733,
         -0.011145564251507329,
         0.03318241763650202,
         -0.05444655064804762,
         0.07438814984891451,
         -0.09239886042108233,
         0.1077724771558036,
         -0.1196409082322704,
         0.1268566239859975,
         -0.1277437440525018,
         0.119451976557767,
         -0.09555330859059098,
         0.0294883912309795,
         -0.04869847535576736,
         0.06550847894051542,
         -0.08023117361506,
         0.09294722642476436,
         -0.10368697190241664,
         0.11246431142310671,
         -0.11928641587313152,
         0.12415723806063766,
         -0.12707898458431816,
         0.12805278414759372,
         -0.12707898458431813,
         0.12415723806063769,
         -0.11928641587313152,
         0.11246431142310671,
         -0.10368697190241664,
         0.09294722642476434,
         -0.08023117361505996,
         0.06550847894051544,
         -0.04869847535576734,
         0.029488391230979502},
        {0.026148818018424506,
         -0.04336290903919915,
         0.058597506614990726,
         -0.07212854456910499,
         0.08402721153271449,
         -0.09432031101641952,
         0.10302016773904535,
         -0.11013319188785438,
         0.11566298639324803,
         -0.11961165950507384,
         0.12198043717391789,
         -0.12276996280897032,
         0.12198043717391789,
         -0.11961165950507384,
         0.11566298639324804,
         -0.11013319188785438,
         0.10302016773904536,
         -0.0943203110164195,
         0.08402721153271449,
         -0.07212854456910502,
         0.058597506614990726,
         -0.0433629090391994,
         0.02614881801842447,
         -0.0886749562348232,
         0.1120897076635614,
         -0.12147673053282212,
         0.12261852576747871,
         -0.11804804116247118,
         0.10923537499252887,
         -0.09717297154614653,
         0.08259989391589057,
         -0.06610690305098424,
         0.04819291099718595,
         -0.02929875330749586,
         0.009829463743659367,
         0.009829463743659367,
         -0.02929875330749586,
         0.04819291099718594,
         -0.06610690305098425,
         0.08259989391589057,
         -0.09717297154614653,
         0.10923537499252889,
         -0.1180480411624712,
         0.12261852576747868,
         -0.12147673053282215,
         0.1120897076635614,
         -0.08867495623482319,
         0.17734991246964607,
         -0.13301243435223564,
         0.09253038911459852,
         -0.05590377675673662,
         0.023132597278649372,
         0.005783149319662236,
         -0.030843463038199077,
         0.05204834387696204,
         -0.06939779183594855,
         0.08289180691516175,
         -0.09253038911459743,
         0.0983135384342617,
         -0.1002412548741479,
         0.0983135384342617,
         -0.09253038911459743,
         0.08289180691516176,
         -0.06939779183594855,
         0.05204834387696204,
         -0.030843463038199077,
         0.005783149319662236,
         0.02313259727864937,
         -0.05590377675673662,
         0.0925303891145985,
         -0.13301243435223564,
         0.17734991246964607,
         -0.08867495623482322,
         0.11208970766356142,
         -0.12147673053282215,
         0.12261852576747866,
         -0.11804804116247117,
         0.10923537499252886,
         -0.09717297154614653,
         0.08259989391589055,
         -0.06610690305098427,
         0.04819291099718595,
         -0.029298753307495852,
         0.009829463743659365,
         0.009829463743659365,
         -0.02929875330749586,
         0.04819291099718596,
         -0.06610690305098427,
         0.08259989391589057,
         -0.09717297154614653,
         0.10923537499252889,
         -0.11804804116247115,
         0.12261852576747868,
         -0.12147673053282215,
         0.11208970766356142,
         -0.08867495623482319,
         0.026148818018424485,
         -0.043362909039199385,
         0.05859750661499073,
         -0.07212854456910499,
         0.08402721153271447,
         -0.0943203110164195,
         0.1030201677390454,
         -0.1101331918878544,
         0.11566298639324805,
         -0.11961165950507387,
         0.12198043717391792,
         -0.12276996280897035,
         0.12198043717391792,
         -0.11961165950507387,
         0.11566298639324808,
         -0.11013319188785443,
         0.1030201677390454,
         -0.09432031101641954,
         0.08402721153271449,
         -0.07212854456910497,
         0.05859750661499074,
         -0.04336290903919938,
         0.02614881801842448},
        {0.1740776559556979,
         -0.21320071635561033,
         0.1973855084879307,
         -0.1471224715841249,
         0.08058229640253803,
         -0.22473328748774735,
         0.10050378152592125,
         0.04652421051992356,
         -0.15194743527951723,
         0.18802535827258873,
         -0.1471224715841249,
         0.17407765595569788,
         0.10050378152592124,
         -0.1698823971458753,
         0.10403129732205987,
         0.02686076546751259,
         -0.15194743527951723,
         0.1973855084879307,
         -0.2132007163556105,
         0.046524210519923566,
         0.10403129732205989,
         -0.16116459280507578,
         0.10403129732205989,
         0.046524210519923566,
         -0.2132007163556105,
         0.19738550848793068,
         -0.1519474352795172,
         0.02686076546751259,
         0.10403129732205987,
         -0.1698823971458753,
         0.10050378152592125,
         0.17407765595569794,
         -0.1471224715841249,
         0.18802535827258868,
         -0.1519474352795172,
         0.04652421051992356,
         0.10050378152592127,
         -0.22473328748774735,
         0.08058229640253803,
         -0.1471224715841249,
         0.19738550848793074,
         -0.2132007163556105,
         0.17407765595569794},
        {0.27735009811261446,
         -0.1961161351381837,
         0.1322214713369862,
         -0.08362420100070907,
         0.04828045495852676,
         -0.02414022747926339,
         0.009124148357522652,
         -0.19611613513818407,
         0.2048366225996757,
         -0.17739371879672472,
         0.13655774839978385,
         -0.09349469900084569,
         0.05474489014513594,
         -0.02414022747926339,
         0.1322214713369862,
         -0.17739371879672472,
         0.1869893980016916,
         -0.17069718549972984,
         0.1368622253628397,
         -0.09349469900084569,
         0.04828045495852676,
         -0.08362420100070907,
         0.13655774839978385,
         -0.17069718549972984,
         0.18248296715045312,
         -0.1706971854997298,
         0.13655774839978385,
         -0.08362420100070907,
         0.04828045495852676,
         -0.09349469900084569,
         0.13686222536283973,
         -0.17069718549972984,
         0.1869893980016916,
         -0.17739371879672472,
         0.1322214713369861,
         -0.02414022747926339,
         0.05474489014513593,
         -0.09349469900084567,
         0.13655774839978385,
         -0.17739371879672472,
         0.2048366225996756,
         -0.19611613513818413,
         0.009124148357522654,
         -0.02414022747926339,
         0.048280454958526765,
         -0.08362420100070908,
         0.1322214713369861,
         -0.19611613513818413,
         0.27735009811261424},
        {0.1322214713369864,
         -0.1773937187967245,
         0.18698939800169137,
         -0.1706971854997296,
         0.13686222536283968,
         -0.0934946990008458,
         0.04828045495852675,
         -0.20197163363339116,
         0.13655774839978366,
         -0.03413943709994586,
         -0.062329799333897054,
         0.1316957377585447,
         -0.16321772771370965,
         0.1533110351679666,
         -0.10429770312912397,
         0.18064892093237822,
         0.04039432672667821,
         -0.13740858372430345,
         0.1410362360927854,
         -0.08194819531574056,
         -0.009124148357522661,
         0.10130133395943129,
         -0.16325172786566958,
         0.16157730690671296,
         -0.19789097796726127,
         0.09894548898363081,
         0.02159167585437657,
         -0.1096417439724121,
         0.14135069854804388,
         -0.1096417439724121,
         0.02159167585437657,
         0.09894548898363081,
         -0.19789097796726132,
         0.16157730690671293,
         -0.16325172786566955,
         0.10130133395943126,
         -0.00912414835752266,
         -0.08194819531574055,
         0.1410362360927854,
         -0.13740858372430345,
         0.0403943267266782,
         0.18064892093237825,
         -0.10429770312912398,
         0.15331103516796663,
         -0.16321772771370965,
         0.1316957377585447,
         -0.062329799333897054,
         -0.03413943709994586,
         0.13655774839978366,
         -0.20197163363339118,
         0.048280454958526745,
         -0.0934946990008458,
         0.13686222536283965,
         -0.17069718549972968,
         0.18698939800169131,
         -0.17739371879672466,
         0.13222147133698622},
        {0.25819888974716093,
         -0.1951800145897069,
         0.14322297480788637,
         -0.10127393670836679,
         0.06827887419989194,
         -0.04318335170875302,
         0.024931919733558856,
         -0.012465959866779435,
         0.0047116899516014615,
         -0.16903085094570358,
         0.18752289237539785,
         -0.17541160386140586,
         0.14959151840135332,
         -0.11826247919781659,
         0.08636670341750612,
         -0.057126204699798386,
         0.032643545542741924,
         -0.014135069854804377,
         0.10482848367219164,
         -0.14824986333222032,
         0.16724840200141824,
         -0.16724840200141822,
         0.15267620413811495,
         -0.12773807700531717,
         0.09656090991705352,
         -0.06321395412410137,
         0.03160697706205069,
         -0.06052275326688025,
         0.10322795481850192,
         -0.13655774839978388,
         0.15768330559708874,
         -0.16490914830605144,
         0.15768330559708874,
         -0.13655774839978388,
         0.10322795481850194,
         -0.06052275326688025,
         0.031606977062050685,
         -0.06321395412410137,
         0.09656090991705353,
         -0.12773807700531717,
         0.15267620413811495,
         -0.16724840200141824,
         0.16724840200141824,
         -0.14824986333222026,
         0.10482848367219162,
         -0.014135069854804373,
         0.032643545542741924,
         -0.057126204699798386,
         0.08636670341750616,
         -0.11826247919781659,
         0.1495915184013533,
         -0.1754116038614058,
         0.1875228923753978,
         -0.1690308509457035,
         0.00471168995160146,
         -0.012465959866779432,
         0.02493191973355885,
         -0.043183351708753016,
         0.06827887419989193,
         -0.10127393670836676,
         0.14322297480788634,
         -0.19518001458970674,
         0.258198889747161},
        {0.1048284836721918,
         -0.1482498633322199,
         0.16724840200141802,
         -0.16724840200141816,
         0.152676204138115,
         -0.1277380770053171,
         0.09656090991705354,
         -0.06321395412410133,
         0.03160697706205069,
         -0.18156825980064037,
         0.14824986333222018,
         -0.07742096611387626,
         0.06827887419989198,
         -0.11826247919781649,
         0.1448413648755805,
         -0.14598637372036244,
         0.12241329578528218,
         -0.07742096611387628,
         0.18156825980064054,
         -0.0999500374687773,
         0.13409704688030213,
         -0.11826247919781684,
         0.06827887419989193,
         -0.07067534927402215,
         0.12773807700531697,
         -0.15484193222775253,
         0.13409704688030213,
         -0.18156825980064065,
         0.12241329578528203,
         -0.031606977062050755,
         -0.05161397740925062,
         0.10795837927188272,
         -0.12773807700531692,
         0.10795837927188272,
         -0.05161397740925062,
         -0.031606977062050755,
         0.12241329578528208,
         -0.18156825980064067,
         0.1340970468803021,
         -0.15484193222775258,
         0.12773807700531703,
         -0.07067534927402215,
         0.06827887419989193,
         -0.11826247919781678,
         0.13409704688030216,
         -0.09995003746877731,
         0.1815682598006405,
         -0.07742096611387632,
         0.1224132957852822,
         -0.1459863737203624,
         0.14484136487558052,
         -0.11826247919781649,
         0.06827887419989201,
         -0.07742096611387628,
         0.14824986333222026,
         -0.18156825980064037,
         0.03160697706205069,
         -0.06321395412410133,
         0.09656090991705353,
         -0.12773807700531714,
         0.15267620413811492,
         -0.16724840200141822,
         0.16724840200141802,
         -0.1482498633322202,
         0.10482848367219173},
        {0.24253562503633266,
         -0.19174124721184282,
         0.1485221314465008,
         -0.11227217828476801,
         0.08238525545716344,
         -0.0582551728035463,
         0.0392756294919233,
         -0.024840089146271907,
         0.014341432155294376,
         -0.007170716077647187,
         0.0027102759233867102,
         -0.14852213144650103,
         0.17149858514250882,
         -0.16840826742715204,
         0.15254785085427644,
         -0.1302625264297267,
         0.10538757288364317,
         -0.08049108834116185,
         0.05736572862117758,
         -0.03726013371940787,
         0.020993707029807337,
         -0.008988968316207751,
         0.08574929257125428,
         -0.12552411131335867,
         0.14770382146458616,
         -0.15569349831298673,
         0.1521138589340321,
         -0.13941465456340715,
         0.11998903007585256,
         -0.09620525158181872,
         0.07041503402754662,
         -0.04494484158103877,
         0.022018385688753826,
         -0.04583492485141057,
         0.08039977681052933,
         -0.11009192844376928,
         0.13277586148895945,
         -0.14695594920865157,
         0.1517754517096558,
         -0.14695594920865154,
         0.13277586148895945,
         -0.1100919284437693,
         0.08039977681052933,
         -0.04583492485141059,
         0.02201838568875382,
         -0.04494484158103877,
         0.07041503402754662,
         -0.09620525158181875,
         0.11998903007585256,
         -0.13941465456340718,
         0.1521138589340321,
         -0.15569349831298676,
         0.14770382146458613,
         -0.1255241113133587,
         0.08574929257125428,
         -0.008988968316207747,
         0.02099370702980734,
         -0.03726013371940785,
         0.057365728621177565,
         -0.08049108834116184,
         0.10538757288364319,
         -0.13026252642972663,
         0.15254785085427644,
         -0.16840826742715198,
         0.17149858514250882,
         -0.14852213144650103,
         0.0027102759233867107,
         -0.007170716077647187,
         0.014341432155294376,
         -0.024840089146271907,
         0.03927562949192328,
         -0.05825517280354627,
         0.0823852554571634,
         -0.11227217828476804,
         0.1485221314465009,
         -0.19174124721184252,
         0.2425356250363328},
        {0.08574929257125433,
         -0.1255241113133585,
         0.14770382146458616,
         -0.1556934983129868,
         0.15211385893403204,
         -0.139414654563407,
         0.11998903007585243,
         -0.09620525158181872,
         0.07041503402754655,
         -0.04494484158103875,
         0.02201838568875383,
         -0.1641973943572963,
         0.1496962377130242,
         -0.10049972101316142,
         0.04019988840526482,
         0.019164544843133777,
         -0.07025838192242898,
         0.10843362021598328,
         -0.13091876497307794,
         0.1364590956937476,
         -0.12518228271563817,
         0.0986058822648918,
         -0.05962607031450766,
         0.17986923354612513,
         -0.027754425291281186,
         -0.0673073075373003,
         0.11441088814070717,
         -0.12265308699605643,
         0.10113361106393277,
         -0.0589570676753602,
         0.005236750598923197,
         0.050897413570767616,
         -0.1002802091653083,
         0.1336599347564398,
         -0.14152035614879518,
         0.11313251407151766,
         -0.16652655174768616,
         0.1319879330834376,
         -0.06431982144842334,
         -0.006638793074447696,
         0.06572069842571003,
         -0.10423821268254763,
         0.11756475936692108,
         -0.10423821268254763,
         0.06572069842571003,
         -0.006638793074447695,
         -0.06431982144842334,
         0.1319879330834376,
         -0.16652655174768616,
         0.11313251407151766,
         -0.1415203561487952,
         0.1336599347564398,
         -0.10028020916530832,
         0.050897413570767616,
         0.005236750598923198,
         -0.05895706767536023,
         0.10113361106393279,
         -0.1226530869960564,
         0.1144108881407072,
         -0.0673073075373003,
         -0.02775442529128118,
         0.1798692335461252,
         -0.05962607031450766,
         0.09860588226489178,
         -0.12518228271563817,
         0.13645909569374753,
         -0.13091876497307794,
         0.10843362021598325,
         -0.07025838192242896,
         0.019164544843133777,
         0.04019988840526484,
         -0.10049972101316144,
         0.14969623771302418,
         -0.1641973943572963,
         0.022018385688753823,
         -0.04494484158103875,
         0.07041503402754654,
         -0.0962052515818187,
         0.11998903007585243,
         -0.13941465456340693,
         0.15211385893403206,
         -0.15569349831298676,
         0.14770382146458627,
         -0.12552411131335867,
         0.08574929257125434},
        {0.22941573387056186,
         -0.18731716231633877,
         0.15067786290445284,
         -0.11912130993616611,
         0.09227096991223672,
         -0.0697502970338577,
         0.05118272511620985,
         -0.036191652009279096,
         0.02440040680697346,
         -0.01543217226894252,
         0.008909768813654653,
         -0.004454884406827322,
         0.0016837880371435106,
         -0.1324532357065046,
         0.15737789507292685,
         -0.15981800795165305,
         0.15067786290445273,
         -0.13507086940257537,
         0.11607151035434625,
         -0.09575411075314338,
         0.0756018953632754,
         -0.05670142152245656,
         0.03984569746227895,
         -0.025591362558104947,
         0.014287415269739541,
         -0.006070984104933808,
         0.07183285265343597,
         -0.10774927898015375,
         0.13049085706320512,
         -0.142377197617095,
         0.1450893879429329,
         -0.14016966550367227,
         0.1291148166001185,
         -0.11340284304491305,
         0.09450236920409438,
         -0.073875900309256,
         0.052979153753974995,
         -0.03325214940527556,
         0.016062314155080897,
         -0.03591642632671795,
         0.06424925662032359,
         -0.09004724626838372,
         0.11168986291388067,
         -0.12795681279052473,
         0.13802954493537076,
         -0.1414381951200552,
         0.13802954493537076,
         -0.12795681279052473,
         0.11168986291388067,
         -0.09004724626838372,
         0.06424925662032359,
         -0.03591642632671794,
         0.016062314155080897,
         -0.03325214940527556,
         0.05297915375397498,
         -0.073875900309256,
         0.09450236920409438,
         -0.11340284304491305,
         0.1291148166001185,
         -0.14016966550367227,
         0.14508938794293297,
         -0.14237719761709502,
         0.1304908570632051,
         -0.10774927898015373,
         0.07183285265343597,
         -0.00607098410493381,
         0.014287415269739541,
         -0.02559136255810495,
         0.03984569746227895,
         -0.05670142152245656,
         0.07560189536327536,
         -0.09575411075314338,
         0.11607151035434625,
         -0.13507086940257546,
         0.15067786290445268,
         -0.15981800795165305,
         0.15737789507292677,
         -0.1324532357065046,
         0.0016837880371435114,
         -0.00445488440682732,
         0.00890976881365465,
         -0.015432172268942524,
         0.024400406806973467,
         -0.0361916520092791,
         0.05118272511620985,
         -0.06975029703385772,
         0.09227096991223671,
         -0.11912130993616608,
         0.1506778629044528,
         -0.1873171623163389,
         0.2294157338705618},
        {0.07183285265343593,
         -0.10774927898015363,
         0.13049085706320485,
         -0.1423771976170952,
         0.14508938794293283,
         -0.14016966550367221,
         0.12911481660011867,
         -0.11340284304491322,
         0.09450236920409429,
         -0.07387590030925607,
         0.05297915375397495,
         -0.03325214940527553,
         0.016062314155080897,
         -0.14953200701331842,
         0.14662819647453845,
         -0.11243619908556636,
         0.06576121069655563,
         -0.01612104310477013,
         -0.030587528681295932,
         0.07043790719171268,
         -0.10080252715103383,
         0.12003413025789086,
         -0.12730892603109628,
         0.12256234405160073,
         -0.10649210588635395,
         0.08061693906627777,
         -0.0472861725258358,
         0.1769286567235603,
         -0.047286172525835495,
         -0.040634797778574594,
         0.09248375997842795,
         -0.11391088447148773,
         0.11056732323868118,
         -0.08810572749672761,
         0.0521811318843134,
         -0.008452548863005846,
         -0.03741395710402599,
         0.07973881616941143,
         -0.11281379848861534,
         0.1308604127297618,
         -0.12788515168011763,
         0.09690781635658197,
         -0.15322471138005964,
         0.13457880631198593,
         -0.08416582552350686,
         0.025602438673126112,
         0.029017877588586746,
         -0.07240288559717069,
         0.1000714200781438,
         -0.1095575548435214,
         0.10007142007814383,
         -0.0724028855971707,
         0.029017877588586753,
         0.025602438673126112,
         -0.08416582552350686,
         0.13457880631198593,
         -0.1532247113800596,
         0.09690781635658197,
         -0.1278851516801177,
         0.13086041272976182,
         -0.11281379848861534,
         0.0797388161694114,
         -0.03741395710402599,
         -0.00845254886300585,
         0.052181131884313385,
         -0.08810572749672764,
         0.1105673232386812,
         -0.11391088447148773,
         0.09248375997842795,
         -0.0406347977785746,
         -0.047286172525835495,
         0.1769286567235603,
         -0.04728617252583581,
         0.0806169390662778,
         -0.10649210588635394,
         0.12256234405160073,
         -0.12730892603109625,
         0.12003413025789089,
         -0.10080252715103388,
         0.07043790719171268,
         -0.03058752868129594,
         -0.016121043104770128,
         0.06576121069655563,
         -0.11243619908556636,
         0.14662819647453842,
         -0.14953200701331842,
         0.01606231415508089,
         -0.03325214940527553,
         0.05297915375397497,
         -0.07387590030925607,
         0.09450236920409427,
         -0.11340284304491327,
         0.12911481660011867,
         -0.14016966550367224,
         0.14508938794293283,
         -0.1423771976170952,
         0.13049085706320482,
         -0.1077492789801538,
         0.0718328526534359},
        {0.21821789023599236,
         -0.18257418583505525,
         0.15101992432742017,
         -0.1233072518653023,
         0.09918831228239365,
         -0.0784152460201046,
         0.06074018838492436,
         -0.04591526658677837,
         0.033692594415874993,
         -0.023824261987233274,
         0.016062314155080873,
         -0.010158699444643728,
         0.0058651278589815555,
         -0.0029325639294907778,
         0.0011084049801758492,
         -0.11952286093343939,
         0.14509525002200224,
         -0.15101992432742029,
         0.14651084695876218,
         -0.13581919019483424,
         0.12148037676984896,
         -0.10520509234399442,
         0.08822792244011049,
         -0.07147278596169979,
         0.0556414884074658,
         -0.04126483221471986,
         0.028733141061374343,
         -0.018313855869845307,
         0.010158699444643702,
         -0.004292834029074432,
         0.061313933948496616,
         -0.09365858115816934,
         0.11582699457751065,
         -0.12949851675240612,
         0.13581919019483424,
         -0.1358191901948347,
         0.13049085706320485,
         -0.12081105830566219,
         0.10774927898015386,
         -0.09227096991223692,
         0.07533893145222616,
         -0.05791349728875523,
         0.040951026655107504,
         -0.025396748611609253,
         0.012141968209867621,
         -0.028903665650804034,
         0.05245929835764222,
         -0.07476600350665918,
         0.09457234505167142,
         -0.11089590441845493,
         0.12302795988298218,
         -0.13049085706320515,
         0.13300859762110195,
         -0.13049085706320515,
         0.12302795988298218,
         -0.11089590441845493,
         0.09457234505167142,
         -0.07476600350665918,
         0.05245929835764222,
         -0.028903665650804027,
         0.01214196820986762,
         -0.025396748611609246,
         0.04095102665510749,
         -0.05791349728875523,
         0.07533893145222616,
         -0.09227096991223693,
         0.10774927898015384,
         -0.12081105830566222,
         0.13049085706320485,
         -0.13581919019483468,
         0.13581919019483424,
         -0.12949851675240612,
         0.11582699457751068,
         -0.09365858115816934,
         0.06131393394849663,
         -0.004292834029074431,
         0.010158699444643702,
         -0.018313855869845307,
         0.028733141061374343,
         -0.04126483221471987,
         0.0556414884074658,
         -0.07147278596169977,
         0.08822792244011048,
         -0.10520509234399443,
         0.12148037676984896,
         -0.13581919019483424,
         0.14651084695876218,
         -0.1510199243274203,
         0.1450952500220023,
         -0.11952286093343942,
         0.0011084049801758492,
         -0.002932563929490779,
         0.005865127858981558,
         -0.010158699444643727,
         0.016062314155080873,
         -0.023824261987233284,
         0.033692594415875,
         -0.04591526658677835,
         0.06074018838492437,
         -0.07841524602010466,
         0.09918831228239361,
         -0.1233072518653023,
         0.1510199243274202,
         -0.18257418583505508,
         0.21821789023599242},
        {0.06131393394849656,
         -0.09365858115816961,
         0.11582699457751076,
         -0.12949851675240623,
         0.13581919019483446,
         -0.13581919019483446,
         0.13049085706320468,
         -0.12081105830566194,
         0.10774927898015384,
         -0.09227096991223675,
         0.07533893145222627,
         -0.057913497288755326,
         0.04095102665510753,
         -0.02539674861160927,
         0.012141968209867625,
         -0.13710212427677052,
         0.1415984650809573,
         -0.11803342130469587,
         0.08190205331021475,
         -0.04095102665510757,
         0.03766946572611331,
         -0.0697502970338579,
         0.09463727629519526,
         -0.11128297681493131,
         0.11912130993616643,
         -0.1180334213046952,
         0.10834623246219156,
         -0.0908621700848511,
         0.0669186598213577,
         -0.038396274820538964,
         0.1734219939048242,
         -0.06131393394849623,
         -0.019198137410268858,
         0.0718328526534367,
         -0.10030911974812642,
         0.10834623246219183,
         -0.0996640383319667,
         0.07798320280925383,
         -0.047025640666996854,
         0.010515252921688763,
         0.02782074420373263,
         -0.06424925662032384,
         0.09502593204266839,
         -0.11638252291846424,
         0.1244921868431588,
         -0.11534869799374171,
         0.0841220233735074,
         -0.141598465080958,
         0.13356165030854322,
         -0.09599068705134786,
         0.048186942465242376,
         -0.04249688873453613,
         0.07533893145222655,
         -0.09599068705134721,
         0.10302801669778572,
         -0.09599068705134721,
         0.07533893145222655,
         -0.04249688873453613,
         0.04818694246524238,
         -0.09599068705134788,
         0.13356165030854322,
         -0.141598465080958,
         0.0841220233735074,
         -0.11534869799374169,
         0.12449218684315877,
         -0.11638252291846424,
         0.09502593204266842,
         -0.06424925662032384,
         0.027820744203732633,
         0.010515252921688761,
         -0.047025640666996854,
         0.07798320280925385,
         -0.0996640383319667,
         0.10834623246219183,
         -0.1003091197481264,
         0.0718328526534367,
         -0.01919813741026886,
         -0.0613139339484962,
         0.17342199390482418,
         -0.038396274820538964,
         0.06691865982135768,
         -0.09086217008485113,
         0.10834623246219155,
         -0.1180334213046952,
         0.11912130993616646,
         -0.11128297681493131,
         0.09463727629519528,
         -0.06975029703385789,
         0.03766946572611332,
         -0.04095102665510757,
         0.08190205331021472,
         -0.11803342130469587,
         0.14159846508095728,
         -0.13710212427677063,
         0.01214196820986763,
         -0.025396748611609274,
         0.04095102665510753,
         -0.05791349728875531,
         0.07533893145222623,
         -0.09227096991223675,
         0.10774927898015382,
         -0.12081105830566197,
         0.13049085706320465,
         -0.13581919019483443,
         0.1358191901948344,
         -0.12949851675240617,
         0.11582699457751068,
         -0.09365858115816944,
         0.061313933948496546},
        {0.20851441405707494,
         -0.17782168978975477,
         0.150286757708826,
         -0.12573892269238612,
         0.10400748880880117,
         -0.08492175900326475,
         0.068311034624203,
         -0.05400461468377656,
         0.04183179465772293,
         -0.03162186444567304,
         0.023204104705092456,
         -0.016407779788333552,
         0.011062122876621632,
         -0.006996300809355639,
         0.004039316155613073,
         -0.002019658077806537,
         0.0007633590010369756,
         -0.10889310129609417,
         0.13442056254199006,
         -0.14257453695652744,
         0.14131834914870775,
         -0.1342730906791136,
         0.12357931139424974,
         -0.11067652555985545,
         0.09660639162528607,
         -0.08215601377494236,
         0.06793466242321532,
         -0.054418449200679404,
         0.04197780485613375,
         -0.030894827848562536,
         0.021374052029035286,
         -0.013548278259845949,
         0.0074793601724051475,
         -0.0031474097915414395,
         0.053134392749225164,
         -0.08231544729143726,
         0.10343444043239289,
         -0.11776529095725641,
         0.1261276065335097,
         -0.12924233743771985,
         0.12779824364990983,
         -0.1224709543741202,
         0.11392989240510759,
         -0.10284120237057097,
         0.08986911108647622,
         -0.07567656392010601,
         0.060925422145741114,
         -0.04627618009738729,
         0.032386579566782106,
         -0.019905967342373408,
         0.00944222937462432,
         -0.023762422826087863,
         0.04361178936951641,
         -0.06294819583082882,
         0.08078632311226143,
         -0.09633155069390269,
         0.10898670838059867,
         -0.11831818268671683,
         0.12403115681897868,
         -0.12595423517110127,
         0.12403115681897868,
         -0.1183181826867168,
         0.10898670838059867,
         -0.09633155069390267,
         0.08078632311226143,
         -0.06294819583082882,
         0.043611789369516415,
         -0.02376242282608786,
         0.009442229374624325,
         -0.019905967342373404,
         0.03238657956678211,
         -0.0462761800973873,
         0.0609254221457411,
         -0.07567656392010601,
         0.08986911108647619,
         -0.10284120237057098,
         0.11392989240510759,
         -0.1224709543741202,
         0.12779824364990977,
         -0.12924233743771982,
         0.1261276065335097,
         -0.11776529095725638,
         0.10343444043239289,
         -0.08231544729143725,
         0.05313439274922518,
         -0.003147409791541439,
         0.007479360172405146,
         -0.013548278259845946,
         0.02137405202903529,
         -0.030894827848562536,
         0.04197780485613375,
         -0.05441844920067939,
         0.06793466242321532,
         -0.08215601377494237,
         0.09660639162528606,
         -0.11067652555985545,
         0.1235793113942498,
         -0.1342730906791136,
         0.1413183491487078,
         -0.1425745369565274,
         0.13442056254199014,
         -0.1088931012960942,
         0.0007633590010369756,
         -0.0020196580778065365,
         0.004039316155613073,
         -0.006996300809355641,
         0.011062122876621628,
         -0.016407779788333566,
         0.02320410470509245,
         -0.031621864445673026,
         0.041831794657722944,
         -0.05400461468377657,
         0.06831103462420303,
         -0.08492175900326478,
         0.10400748880880122,
         -0.1257389226923861,
         0.150286757708826,
         -0.17782168978975474,
         0.20851441405707502},
        {0.05313439274922518,
         -0.08231544729143736,
         0.10343444043239304,
         -0.11776529095725637,
         0.1261276065335099,
         -0.1292423374377198,
         0.12779824364990977,
         -0.12247095437412016,
         0.11392989240510754,
         -0.10284120237057094,
         0.0898691110864762,
         -0.07567656392010598,
         0.06092542214574122,
         -0.046276180097387265,
         0.03238657956678215,
         -0.01990596734237341,
         0.009442229374624316,
         -0.1264851543042259,
         0.135813558944418,
         -0.11993242076617022,
         0.09194172482879315,
         -0.05830250674463077,
         0.023027645074179544,
         0.01112340934491568,
         -0.042162485927564095,
         0.06863866736536194,
         -0.08951177722167268,
         0.10408029770032808,
         -0.1119408129496903,
         0.11296853544125295,
         -0.1073146290479246,
         0.09541987512962166,
         -0.07804700294394505,
         0.056331894602292064,
         -0.03178728073272189,
         0.16969764190127937,
         -0.07155080826235609,
         -0.001990596734237129,
         0.05348744907670738,
         -0.08550075179898203,
         0.10059167882549848,
         -0.10132163832639056,
         0.090252366527774,
         -0.06994607055327366,
         0.042965653066403105,
         -0.011875079174486807,
         -0.02075999679474186,
         0.05237110088913485,
         -0.08038475957011708,
         0.10221792235620385,
         -0.11526720915658273,
         0.11687937880192636,
         -0.1042484967894122,
         0.07386696533943107,
         -0.131447228194865,
         0.13067627006016355,
         -0.1027522048052529,
         0.06385989668098424,
         -0.022189994028215726,
         -0.017161152462471647,
         0.05076538236868908,
         -0.07628091845509861,
         0.09217192474777171,
         -0.09756373104039345,
         0.09217192474777171,
         -0.07628091845509863,
         0.05076538236868908,
         -0.017161152462471647,
         -0.02218999402821572,
         0.06385989668098425,
         -0.10275220480525289,
         0.1306762700601636,
         -0.13144722819486504,
         0.07386696533943106,
         -0.1042484967894122,
         0.11687937880192636,
         -0.11526720915658273,
         0.10221792235620383,
         -0.08038475957011708,
         0.05237110088913485,
         -0.02075999679474187,
         -0.011875079174486804,
         0.042965653066403105,
         -0.06994607055327366,
         0.090252366527774,
         -0.10132163832639059,
         0.10059167882549849,
         -0.08550075179898203,
         0.0534874490767074,
         -0.0019905967342371284,
         -0.07155080826235609,
         0.1696976419012793,
         -0.03178728073272189,
         0.05633189460229205,
         -0.07804700294394501,
         0.09541987512962163,
         -0.1073146290479246,
         0.11296853544125295,
         -0.1119408129496903,
         0.1040802977003281,
         -0.08951177722167267,
         0.06863866736536194,
         -0.042162485927564095,
         0.011123409344915678,
         0.023027645074179554,
         -0.058302506744630785,
         0.09194172482879316,
         -0.11993242076617022,
         0.13581355894441796,
         -0.12648515430422594,
         0.009442229374624316,
         -0.019905967342373408,
         0.03238657956678215,
         -0.046276180097387265,
         0.060925422145741245,
         -0.075676563920106,
         0.08986911108647623,
         -0.1028412023705709,
         0.11392989240510752,
         -0.12247095437412013,
         0.12779824364990983,
         -0.1292423374377199,
         0.12612760653350993,
         -0.11776529095725645,
         0.10343444043239305,
         -0.08231544729143721,
         0.05313439274922519},
        {0.1999999999999998,
         -0.173205080756888,
         0.14890907643081497,
         -0.12699008706760834,
         0.107326212393534,
         -0.08979555170897585,
         0.07427620373605244,
         -0.06064626639477802,
         0.04878383646484586,
         -0.038567009057522486,
         0.029873876758562967,
         -0.022582528171585764,
         0.01657104529998325,
         -0.011717498502967612,
         0.007899935879113983,
         -0.004996358149456976,
         0.002884648722556758,
         -0.0014423243612783814,
         0.0005451473671189526,
         -0.10000000000000019,
         0.12510864843424505,
         -0.13469332756346378,
         0.13575811352102388,
         -0.1314472281948649,
         0.12360307436175984,
         -0.1134587753181409,
         0.10190611080391758,
         -0.08962163027568913,
         0.07713401811504483,
         -0.06486337389944224,
         0.053145577759926683,
         -0.04224804167262233,
         0.032380101603007506,
         -0.02369980763734198,
         0.016318037384487984,
         -0.010300256196813353,
         0.005665337624774577,
         -0.0023762422826087864,
         0.04662524041201578,
         -0.07304771303365099,
         0.09294722642476476,
         -0.10732621239353403,
         0.11679392715865719,
         -0.12187427489342804,
         0.12306332036654154,
         -0.12084578161120216,
         0.11570102717256717,
         -0.10810562316573706,
         0.09853453834474851,
         -0.08746175552381151,
         0.07536058523767089,
         -0.0627037971284762,
         0.04996358149456962,
         -0.03761121778051367,
         0.026115916048591654,
         -0.015940317824767524,
         0.007514337885441288,
         -0.01988106931218859,
         0.036812587148390925,
         -0.053663106196766994,
         0.06964244279624461,
         -0.0841012396737773,
         0.09653881107023313,
         -0.10657596171148796,
         0.11393449554009286,
         -0.11842377680205449,
         0.11993242076616985,
         -0.11842377680205446,
         0.11393449554009286,
         -0.10657596171148795,
         0.09653881107023311,
         -0.0841012396737773,
         0.06964244279624461,
         -0.05366310619676699,
         0.03681258714839093,
         -0.019881069312188582,
         0.007514337885441288,
         -0.015940317824767524,
         0.026115916048591658,
         -0.03761121778051367,
         0.04996358149456961,
         -0.0627037971284762,
         0.0753605852376709,
         -0.08746175552381152,
         0.09853453834474851,
         -0.10810562316573706,
         0.11570102717256722,
         -0.12084578161120216,
         0.12306332036654156,
         -0.12187427489342799,
         0.11679392715865722,
         -0.10732621239353402,
         0.09294722642476473,
         -0.07304771303365101,
         0.04662524041201575,
         -0.0023762422826087864,
         0.005665337624774576,
         -0.010300256196813353,
         0.016318037384487984,
         -0.02369980763734197,
         0.0323801016030075,
         -0.04224804167262234,
         0.053145577759926683,
         -0.06486337389944224,
         0.07713401811504479,
         -0.0896216302756892,
         0.10190611080391757,
         -0.1134587753181409,
         0.12360307436175984,
         -0.13144722819486487,
         0.13575811352102393,
         -0.1346933275634638,
         0.12510864843424502,
         -0.1000000000000002,
         0.0005451473671189526,
         -0.0014423243612783816,
         0.002884648722556759,
         -0.004996358149456972,
         0.007899935879113983,
         -0.011717498502967612,
         0.016571045299983257,
         -0.022582528171585764,
         0.029873876758562967,
         -0.03856700905752247,
         0.048783836464845874,
         -0.060646266394778006,
         0.07427620373605244,
         -0.08979555170897584,
         0.10732621239353404,
         -0.12699008706760834,
         0.148909076430815,
         -0.17320508075688756,
         0.19999999999999996},
        {0.046625240412015836,
         -0.07304771303365099,
         0.09294722642476475,
         -0.107326212393534,
         0.1167939271586572,
         -0.12187427489342798,
         0.12306332036654154,
         -0.12084578161120217,
         0.11570102717256722,
         -0.10810562316573703,
         0.09853453834474815,
         -0.08746175552381152,
         0.0753605852376709,
         -0.06270379712847621,
         0.04996358149456963,
         -0.03761121778051368,
         0.026115916048591654,
         -0.015940317824767528,
         0.007514337885441302,
         -0.11733761520513816,
         0.12986260094871285,
         -0.11964090823227069,
         0.09797497923254891,
         -0.07036414541701072,
         0.04020808309543492,
         -0.009852951145709573,
         -0.018989082590015985,
         0.04503656374612353,
         -0.06732809079395988,
         0.08515764918791449,
         -0.0980356260840588,
         0.10566581727790965,
         -0.1079336720100258,
         0.10490369244690656,
         -0.0968257026717139,
         0.08415128504546229,
         -0.06756309357057694,
         0.048017344253338395,
         -0.026743724538353407,
         0.16594044679962175,
         -0.07910900403306838,
         0.011881211413044008,
         0.0375716894272062,
         -0.07107852053823617,
         0.09046818696472814,
         -0.09756970353778412,
         0.09421223276580605,
         -0.08222513958757041,
         0.06343807244731467,
         -0.0396810867483093,
         0.012784839010805283,
         0.015419096001432313,
         -0.04309768351349634,
         0.06841545159580899,
         -0.0895326066299585,
         0.10460107591827823,
         -0.1117552102593858,
         0.10908624482749396,
         -0.09455334487627343,
         0.06550847894051545,
         -0.12255514206205226,
         0.12685662398599745,
         -0.10626878549845037,
         0.07464737753390088,
         -0.03893130905288551,
         0.003447814681080016,
         0.028846487225567027,
         -0.05586098231060488,
         0.07612568693677638,
         -0.08865980200823503,
         0.09289925365954288,
         -0.08865980200823502,
         0.07612568693677638,
         -0.05586098231060488,
         0.02884648722556703,
         0.003447814681080016,
         -0.03893130905288551,
         0.07464737753390087,
         -0.10626878549845035,
         0.12685662398599745,
         -0.12255514206205223,
         0.0655084789405155,
         -0.09455334487627341,
         0.10908624482749393,
         -0.11175521025938583,
         0.10460107591827823,
         -0.0895326066299585,
         0.06841545159580902,
         -0.04309768351349634,
         0.01541909600143231,
         0.012784839010805283,
         -0.03968108674830931,
         0.06343807244731467,
         -0.08222513958757037,
         0.09421223276580604,
         -0.09756970353778412,
         0.09046818696472816,
         -0.07107852053823613,
         0.03757168942720619,
         0.011881211413044008,
         -0.07910900403306835,
         0.16594044679962183,
         -0.0267437245383534,
         0.04801734425333839,
         -0.06756309357057694,
         0.08415128504546232,
         -0.09682570267171389,
         0.10490369244690652,
         -0.10793367201002574,
         0.10566581727790962,
         -0.0980356260840588,
         0.08515764918791453,
         -0.06732809079395985,
         0.04503656374612354,
         -0.01898908259001598,
         -0.009852951145709577,
         0.04020808309543491,
         -0.07036414541701072,
         0.09797497923254891,
         -0.11964090823227067,
         0.12986260094871288,
         -0.11733761520513808,
         0.0075143378854413,
         -0.015940317824767524,
         0.02611591604859164,
         -0.037611217780513684,
         0.04996358149456963,
         -0.06270379712847621,
         0.07536058523767089,
         -0.08746175552381151,
         0.09853453834474814,
         -0.10810562316573707,
         0.11570102717256721,
         -0.12084578161120214,
         0.12306332036654156,
         -0.12187427489342806,
         0.1167939271586572,
         -0.10732621239353395,
         0.09294722642476473,
         -0.07304771303365105,
         0.04662524041201585},
        {0.04134491152973615,
         -0.06537204504606131,
         0.08402721153271484,
         -0.09812264318858284,
         0.10812588655535364,
         -0.11442968244553962,
         0.11740237702510212,
         -0.11740237702510212,
         0.114783407191697,
         -0.10989674556596435,
         0.10309228547118088,
         -0.09471908268072776,
         0.08512565307587497,
         -0.07466013667894403,
         0.06367037849263471,
         -0.05250393914963771,
         0.041508008460934616,
         -0.031029104251192895,
         0.021412116180991626,
         -0.012996661586402584,
         0.0060959746329954725,
         -0.1093883538856488,
         0.12403473458920859,
         -0.11804804116247153,
         0.10134063012139581,
         -0.07867313843493104,
         0.052970650009335825,
         -0.026251969574818918,
         0.024659431554869174,
         -0.046860129759628284,
         0.06593804733957837,
         -0.0813956927556482,
         0.09287970209589191,
         -0.10016708449412719,
         0.10315780329506202,
         -0.1018726055882158,
         0.09645589530206226,
         -0.0871842563632695,
         0.07448216232168757,
         -0.05894731616860716,
         0.04138574602021255,
         -0.022809048515134038,
         0.16224914891852696,
         -0.08473185457363225,
         0.02313259727864958,
         0.02389407160538326,
         -0.05769363485228303,
         0.07961161860099694,
         -0.09099360475287864,
         0.09318524788087969,
         -0.08753229869069509,
         0.07538063720113611,
         -0.05807632069124947,
         0.036965654699047765,
         -0.013395301134261994,
         -0.011287551685860825,
         0.03573491130084934,
         -0.05859750661498979,
         0.07852393205347238,
         -0.09415899687233158,
         0.1041402585645389,
         -0.10708987768703652,
         0.10159224067054352,
         -0.08611600128219608,
         0.058597506614990774,
         -0.11472747344203661,
         0.12261852576747866,
         -0.10767951778959754,
         0.08197469242462015,
         -0.05147821867385343,
         0.01991017777479406,
         0.010167344096841559,
         -0.03690685769237051,
         0.05895959558050246,
         -0.07535822583236315,
         0.08544932592821987,
         -0.08885437563234098,
         0.08544932592821987,
         -0.07535822583236315,
         0.05895959558050246,
         -0.03690685769237051,
         0.010167344096841559,
         0.01991017777479406,
         -0.05147821867385343,
         0.08197469242462016,
         -0.10767951778959756,
         0.12261852576747866,
         -0.11472747344203658,
         0.05859750661499078,
         -0.08611600128219608,
         0.10159224067054355,
         -0.10708987768703655,
         0.1041402585645389,
         -0.09415899687233158,
         0.07852393205347238,
         -0.058597506614989775,
         0.035734911300849354,
         -0.011287551685860826,
         -0.013395301134262001,
         0.03696565469904776,
         -0.05807632069124947,
         0.07538063720113614,
         -0.08753229869069507,
         0.09318524788087967,
         -0.09099360475287863,
         0.07961161860099696,
         -0.05769363485228303,
         0.02389407160538326,
         0.023132597278649573,
         -0.08473185457363225,
         0.1622491489185269,
         -0.022809048515134038,
         0.041385746020212555,
         -0.05894731616860716,
         0.07448216232168758,
         -0.08718425636326947,
         0.09645589530206226,
         -0.10187260558821579,
         0.10315780329506198,
         -0.10016708449412717,
         0.09287970209589193,
         -0.08139569275564822,
         0.06593804733957832,
         -0.046860129759628284,
         0.024659431554869174,
         -0.026251969574818932,
         0.052970650009335846,
         -0.07867313843493105,
         0.1013406301213958,
         -0.11804804116247156,
         0.12403473458920856,
         -0.10938835388564883,
         0.006095974632995473,
         -0.01299666158640258,
         0.02141211618099163,
         -0.031029104251192895,
         0.04150800846093461,
         -0.05250393914963772,
         0.0636703784926347,
         -0.07466013667894403,
         0.08512565307587495,
         -0.09471908268072776,
         0.10309228547118085,
         -0.10989674556596438,
         0.11478340719169702,
         -0.11740237702510213,
         0.11740237702510213,
         -0.11442968244553968,
         0.1081258865553536,
         -0.0981226431885829,
         0.08402721153271484,
         -0.06537204504606138,
         0.04134491152973613},
        {0.10429770312912401,
         -0.1649091483060512,
         0.18698939800169148,
         -0.16490914830605125,
         0.10429770312912393,
         -0.16490914830605125,
         0.15644655469368596,
         -0.06232979933389712,
         -0.06232979933389712,
         0.15644655469368593,
         -0.16490914830605122,
         0.18698939800169143,
         -0.06232979933389712,
         -0.08194819531574035,
         0.1413506985480437,
         -0.08194819531574034,
         -0.06232979933389712,
         0.18698939800169148,
         -0.16490914830605122,
         -0.06232979933389712,
         0.1413506985480437,
         -0.0670485234401511,
         -0.06704852344015108,
         0.14135069854804366,
         -0.06232979933389711,
         -0.16490914830605125,
         0.10429770312912394,
         0.15644655469368596,
         -0.08194819531574031,
         -0.06704852344015108,
         0.13409704688030202,
         -0.06704852344015108,
         -0.08194819531574031,
         0.15644655469368593,
         0.10429770312912394,
         -0.16490914830605122,
         -0.06232979933389712,
         0.14135069854804366,
         -0.06704852344015107,
         -0.06704852344015105,
         0.14135069854804366,
         -0.06232979933389714,
         -0.16490914830605122,
         0.18698939800169148,
         -0.06232979933389714,
         -0.08194819531574028,
         0.14135069854804366,
         -0.08194819531574028,
         -0.06232979933389714,
         0.1869893980016914,
         -0.16490914830605125,
         0.15644655469368593,
         -0.06232979933389714,
         -0.06232979933389714,
         0.15644655469368593,
         -0.16490914830605122,
         0.10429770312912395,
         -0.16490914830605125,
         0.1869893980016914,
         -0.1649091483060513,
         0.10429770312912398},
        {0.14322297480788648,
         -0.17541160386140597,
         0.16724840200141802,
         -0.13655774839978374,
         0.09656090991705356,
         -0.05712620469979836,
         0.024931919733558867,
         -0.18946618668626827,
         0.08770580193070303,
         0.026444294267397347,
         -0.10795837927188247,
         0.14484136487558047,
         -0.14034589305344738,
         0.10596065886762528,
         -0.05712620469979836,
         0.14322297480788646,
         0.08770580193070303,
         -0.1399300524562884,
         0.09032446046618901,
         -0.08568930704969756,
         0.13712555853457375,
         -0.14034589305344738,
         0.09656090991705356,
         -0.17541160386140583,
         0.02644429426739734,
         0.09032446046618901,
         -0.12773807700531695,
         0.09032446046618911,
         -0.006232979933389468,
         -0.08568930704969756,
         0.14484136487558047,
         -0.13655774839978368,
         0.16724840200141802,
         -0.10795837927188244,
         0.09032446046618908,
         -0.12465959866779465,
         0.09032446046618908,
         -0.10795837927188241,
         0.16724840200141802,
         -0.1365577483997837,
         0.1448413648755805,
         -0.08568930704969754,
         -0.006232979933389468,
         0.09032446046618908,
         -0.12773807700531695,
         0.09032446046618897,
         0.02644429426739734,
         -0.17541160386140586,
         0.09656090991705356,
         -0.1403458930534474,
         0.13712555853457375,
         -0.08568930704969754,
         0.09032446046618901,
         -0.13993005245628837,
         0.08770580193070301,
         0.14322297480788643,
         -0.05712620469979837,
         0.10596065886762523,
         -0.1403458930534474,
         0.14484136487558047,
         -0.10795837927188244,
         0.026444294267397344,
         0.08770580193070301,
         -0.18946618668626827,
         0.024931919733558884,
         -0.05712620469979837,
         0.09656090991705356,
         -0.13655774839978366,
         0.16724840200141802,
         -0.17541160386140586,
         0.14322297480788646},
        {0.24253562503633283,
         -0.1714985851425085,
         0.11715583722580095,
         -0.07669649888473716,
         0.04756514941544935,
         -0.027461751819054515,
         0.014341432155294372,
         -0.0064136834387879095,
         0.0021378944795959675,
         -0.17149858514250865,
         0.1771229771080188,
         -0.15339299776947418,
         0.1203313675192373,
         -0.08684168428648438,
         0.05736572862117755,
         -0.033938022733852706,
         0.017103155836767744,
         -0.006413683438787909,
         0.11715583722580095,
         -0.15339299776947418,
         0.15918343668810858,
         -0.14531393175878762,
         0.11998903007585249,
         -0.08979156814303087,
         0.059861045428687205,
         -0.033938022733852706,
         0.014341432155294372,
         -0.07669649888473716,
         0.1203313675192373,
         -0.14531393175878765,
         0.151775451709656,
         -0.14197293500509653,
         0.11972209085737442,
         -0.08979156814303085,
         0.05736572862117755,
         -0.027461751819054515,
         0.04756514941544934,
         -0.08684168428648438,
         0.11998903007585249,
         -0.1419729350050965,
         0.14965261357171813,
         -0.1419729350050965,
         0.11998903007585246,
         -0.08684168428648438,
         0.04756514941544934,
         -0.027461751819054515,
         0.05736572862117755,
         -0.08979156814303087,
         0.1197220908573744,
         -0.1419729350050965,
         0.15177545170965615,
         -0.14531393175878768,
         0.1203313675192373,
         -0.07669649888473716,
         0.014341432155294372,
         -0.03393802273385271,
         0.059861045428687205,
         -0.08979156814303087,
         0.11998903007585246,
         -0.14531393175878768,
         0.15918343668810858,
         -0.1533929977694742,
         0.117155837225801,
         -0.00641368343878791,
         0.017103155836767747,
         -0.03393802273385271,
         0.05736572862117754,
         -0.08684168428648435,
         0.12033136751923727,
         -0.1533929977694742,
         0.17712297710801878,
         -0.1714985851425087,
         0.002137894479595968,
         -0.00641368343878791,
         0.014341432155294376,
         -0.027461751819054515,
         0.04756514941544935,
         -0.07669649888473719,
         0.117155837225801,
         -0.17149858514250876,
         0.24253562503633275},
        {0.06827887419989193,
         -0.1182624791978163,
         0.1526762041381148,
         -0.16490914830605127,
         0.15267620413811478,
         -0.11826247919781653,
         0.06827887419989186,
         -0.127738077005317,
         0.15267620413811475,
         -0.11826247919781664,
         0.04407382377899556,
         0.044073823778995554,
         -0.11826247919781664,
         0.15267620413811475,
         -0.127738077005317,
         0.1672484020014181,
         -0.10795837927188252,
         0.09032446046618921,
         -0.12465959866779462,
         0.09032446046618921,
         -0.10795837927188254,
         0.1672484020014181,
         -0.16724840200141794,
         0.10795837927188263,
         -0.11660837704690658,
         0.048280454958526904,
         0.04828045495852691,
         -0.11660837704690658,
         0.10795837927188266,
         -0.16724840200141794,
         0.11826247919781645,
         0.11826247919781635,
         -0.11826247919781671,
         0.01971041319963614,
         0.07884165279854376,
         -0.11826247919781632,
         0.07884165279854376,
         0.01971041319963614,
         -0.11826247919781671,
         0.11826247919781635,
         0.11826247919781645,
         -0.16724840200141794,
         0.10795837927188266,
         -0.11660837704690658,
         0.048280454958526904,
         0.048280454958526904,
         -0.11660837704690655,
         0.10795837927188266,
         -0.16724840200141794,
         0.16724840200141808,
         -0.10795837927188258,
         0.09032446046618922,
         -0.12465959866779468,
         0.09032446046618922,
         -0.10795837927188258,
         0.1672484020014181,
         -0.12773807700531706,
         0.1526762041381148,
         -0.11826247919781664,
         0.044073823778995526,
         0.044073823778995526,
         -0.11826247919781664,
         0.15267620413811478,
         -0.12773807700531703,
         0.06827887419989186,
         -0.1182624791978165,
         0.15267620413811483,
         -0.16490914830605136,
         0.15267620413811483,
         -0.11826247919781648,
         0.06827887419989186},
        {0.11715583722580102,
         -0.1533929977694749,
         0.15918343668810844,
         -0.14531393175878785,
         0.11998903007585257,
         -0.0897915681430308,
         0.059861045428687185,
         -0.03393802273385275,
         0.01434143215529438,
         -0.17573375583870168,
         0.11070186069251207,
         -0.021271781490575802,
         -0.056279843767370524,
         0.10843362021598354,
         -0.13198793308343776,
         0.12960296509584374,
         -0.10747040532386713,
         0.07375735954606097,
         -0.03726013371940784,
         0.1485221314465011,
         0.05020964452534345,
         -0.12300990687851412,
         0.11370245477722059,
         -0.05895706767536046,
         -0.011709730320404656,
         0.07593288368438515,
         -0.11849413951619996,
         0.13130782605359695,
         -0.11336601796095955,
         0.07041503402754663,
         -0.1684082674271522,
         0.06266542425886568,
         0.04266999286754721,
         -0.10423821268254765,
         0.11337897629876947,
         -0.07774708345517202,
         0.013855139762818857,
         0.05738279921480689,
         -0.11406580819528671,
         0.13645909569374776,
         -0.11009192844376932,
         0.14770382146458613,
         -0.12455479865038939,
         0.05089741357076763,
         0.030663271749014186,
         -0.09108032686966376,
         0.1131267424461764,
         -0.09108032686966376,
         0.030663271749014193,
         0.05089741357076763,
         -0.12455479865038939,
         0.14770382146458608,
         -0.11009192844376932,
         0.13645909569374776,
         -0.11406580819528676,
         0.05738279921480689,
         0.013855139762818857,
         -0.07774708345517205,
         0.11337897629876945,
         -0.1042382126825477,
         0.04266999286754721,
         0.06266542425886569,
         -0.1684082674271522,
         0.07041503402754662,
         -0.11336601796095955,
         0.131307826053597,
         -0.11849413951619993,
         0.07593288368438511,
         -0.011709730320404656,
         -0.05895706767536046,
         0.11370245477722059,
         -0.12300990687851412,
         0.05020964452534346,
         0.14852213144650103,
         -0.03726013371940785,
         0.07375735954606097,
         -0.10747040532386713,
         0.12960296509584374,
         -0.13198793308343776,
         0.10843362021598354,
         -0.05627984376737054,
         -0.021271781490575795,
         0.11070186069251207,
         -0.17573375583870168,
         0.01434143215529438,
         -0.03393802273385275,
         0.0598610454286872,
         -0.08979156814303083,
         0.11998903007585257,
         -0.14531393175878782,
         0.1591834366881084,
         -0.15339299776947427,
         0.11715583722580117},
        {0.22941573387056158,
         -0.17099639201419248,
         0.12441815044835984,
         -0.08797691788472328,
         0.060099676407042155,
         -0.03934447376823162,
         0.024400406806973394,
         -0.014087581438342512,
         0.007356999464614971,
         -0.003290150182661734,
         0.0010967167275539097,
         -0.15294382258037462,
         0.16589086726447994,
         -0.1523804916696557,
         0.12849851324064732,
         -0.10158699444643712,
         0.07560189536327541,
         -0.052710903150553615,
         0.033980524970587137,
         -0.01974090109597036,
         0.009809332619486653,
         -0.0036373978866027497,
         0.09814236060242511,
         -0.13438696187188626,
         0.14721354090363784,
         -0.14366570530687203,
         0.12911481660011861,
         -0.10802520588259755,
         0.08409750872243348,
         -0.06030944903928061,
         0.03892958195801313,
         -0.02151913610001977,
         0.008909768813654627,
         -0.060099676407042044,
         0.09814236060242537,
         -0.12441815044835998,
         0.1380295449353704,
         -0.13945994111797627,
         0.13028330029580681,
         -0.11282864774504542,
         0.08990401849159407,
         -0.06455740830005946,
         0.03984569746227883,
         -0.018547162802488575,
         0.034698564351815155,
         -0.06557412294705289,
         0.09450236920409408,
         -0.11786516260004609,
         0.13296983655438346,
         -0.13818630767179277,
         0.13296983655438346,
         -0.11786516260004609,
         0.09450236920409408,
         -0.0655741229470529,
         0.034698564351815155,
         -0.018547162802488578,
         0.03984569746227883,
         -0.06455740830005945,
         0.0899040184915941,
         -0.11282864774504539,
         0.13028330029580681,
         -0.13945994111797627,
         0.1380295449353704,
         -0.12441815044835998,
         0.09814236060242536,
         -0.06009967640704203,
         0.008909768813654628,
         -0.02151913610001977,
         0.038929581958013125,
         -0.06030944903928061,
         0.0840975087224335,
         -0.10802520588259756,
         0.12911481660011853,
         -0.14366570530687203,
         0.1472135409036379,
         -0.1343869618718862,
         0.09814236060242511,
         -0.0036373978866027505,
         0.009809332619486653,
         -0.01974090109597036,
         0.03398052497058714,
         -0.052710903150553615,
         0.07560189536327541,
         -0.10158699444643707,
         0.12849851324064732,
         -0.1523804916696557,
         0.16589086726447994,
         -0.15294382258037464,
         0.0010967167275539099,
         -0.003290150182661734,
         0.007356999464614971,
         -0.014087581438342508,
         0.024400406806973387,
         -0.03934447376823161,
         0.06009967640704214,
         -0.08797691788472325,
         0.12441815044835981,
         -0.17099639201419248,
         0.22941573387056144},
        {0.047565149415449384,
         -0.08684168428648431,
         0.11998903007585238,
         -0.1419729350050965,
         0.14965261357171816,
         -0.1419729350050965,
         0.11998903007585238,
         -0.08684168428648437,
         0.047565149415449384,
         -0.10090091909944675,
         0.13592873654160817,
         -0.13091876497307764,
         0.09294310304227163,
         -0.03346334169568693,
         -0.03346334169568693,
         0.09294310304227163,
         -0.13091876497307764,
         0.13592873654160814,
         -0.10090091909944673,
         0.14770382146458616,
         -0.12455479865038938,
         0.050897413570767575,
         0.03066327174901387,
         -0.09108032686966394,
         0.11312674244617574,
         -0.09108032686966394,
         0.03066327174901387,
         0.05089741357076757,
         -0.12455479865038935,
         0.14770382146458616,
         -0.1632927186332249,
         0.040199888405264686,
         0.06572069842571,
         -0.11141838507043411,
         0.09576308262633088,
         -0.03702941859881222,
         -0.03702941859881222,
         0.09576308262633088,
         -0.11141838507043411,
         0.06572069842571,
         0.04019988840526469,
         -0.1632927186332249,
         0.12648599596468255,
         0.08432399730978862,
         -0.12265308699605604,
         0.06899236143528152,
         0.014053999551631101,
         -0.08176872466403731,
         0.10732145112154898,
         -0.08176872466403731,
         0.014053999551631098,
         0.06899236143528152,
         -0.12265308699605607,
         0.08432399730978862,
         0.12648599596468255,
         -0.1632927186332249,
         0.04019988840526469,
         0.06572069842571002,
         -0.11141838507043411,
         0.0957630826263309,
         -0.037029418598812223,
         -0.037029418598812223,
         0.0957630826263309,
         -0.11141838507043413,
         0.06572069842571,
         0.04019988840526471,
         -0.16329271863322492,
         0.14770382146458624,
         -0.12455479865038932,
         0.050897413570767554,
         0.030663271749013857,
         -0.09108032686966394,
         0.11312674244617575,
         -0.09108032686966394,
         0.030663271749013857,
         0.050897413570767554,
         -0.12455479865038932,
         0.14770382146458622,
         -0.10090091909944675,
         0.13592873654160814,
         -0.13091876497307764,
         0.09294310304227159,
         -0.03346334169568694,
         -0.03346334169568694,
         0.09294310304227159,
         -0.13091876497307767,
         0.13592873654160817,
         -0.10090091909944678,
         0.04756514941544936,
         -0.08684168428648438,
         0.11998903007585243,
         -0.1419729350050966,
         0.14965261357171816,
         -0.14197293500509658,
         0.11998903007585243,
         -0.08684168428648437,
         0.04756514941544936},
        {0.09814236060242501,
         -0.13438696187188626,
         0.14721354090363734,
         -0.1436657053068721,
         0.12911481660011886,
         -0.10802520588259767,
         0.08409750872243349,
         -0.06030944903928071,
         0.038929581958013146,
         -0.021519136100019817,
         0.008909768813654628,
         -0.16275069307900109,
         0.12144497523135303,
         -0.05204784652772244,
         -0.01606231415508085,
         0.07043790719171254,
         -0.10607864634004142,
         0.12223103505713272,
         -0.12082812442501642,
         0.1055415358187412,
         -0.08110329574586067,
         0.05274226935573996,
         -0.02559136255810493,
         0.15067786290445254,
         0.02174847617720074,
         -0.10158699444643739,
         0.11590651878500963,
         -0.08810572749672753,
         0.0379132835836201,
         0.018611900042258253,
         -0.0690800964505701,
         0.10476945862039953,
         -0.12062263744576203,
         0.11523654887174825,
         -0.09082315837463116,
         0.05297915375397491,
         -0.15981800795165296,
         0.08423148603968773,
         0.005542024900879474,
         -0.07240288559717079,
         0.10434052842240167,
         -0.1010285578175558,
         0.06881842847817114,
         -0.018020894726235893,
         -0.03895274743578973,
         0.08910130404077643,
         -0.12025241185364133,
         0.12256234405160088,
         -0.09004724626838372,
         0.13049085706320449,
         -0.12787554456207254,
         0.07973881616941138,
         -0.01458203214754618,
         -0.046668026042300775,
         0.08927974740080065,
         -0.10445902991252004,
         0.08927974740080065,
         -0.046668026042300775,
         -0.014582032147546177,
         0.07973881616941138,
         -0.12787554456207254,
         0.13049085706320449,
         -0.09004724626838373,
         0.12256234405160082,
         -0.12025241185364133,
         0.08910130404077644,
         -0.03895274743578973,
         -0.018020894726235893,
         0.06881842847817116,
         -0.10102855781755579,
         0.10434052842240168,
         -0.0724028855971708,
         0.005542024900879475,
         0.08423148603968772,
         -0.15981800795165296,
         0.05297915375397492,
         -0.09082315837463113,
         0.11523654887174822,
         -0.12062263744576203,
         0.10476945862039956,
         -0.0690800964505701,
         0.018611900042258253,
         0.03791328358362011,
         -0.08810572749672757,
         0.1159065187850096,
         -0.10158699444643741,
         0.021748476177200736,
         0.1506778629044525,
         -0.025591362558104937,
         0.052742269355739946,
         -0.08110329574586067,
         0.10554153581874119,
         -0.12082812442501642,
         0.12223103505713274,
         -0.10607864634004142,
         0.07043790719171254,
         -0.01606231415508084,
         -0.05204784652772242,
         0.12144497523135303,
         -0.16275069307900109,
         0.008909768813654628,
         -0.021519136100019823,
         0.038929581958013146,
         -0.06030944903928074,
         0.08409750872243354,
         -0.10802520588259763,
         0.12911481660011886,
         -0.14366570530687206,
         0.14721354090363734,
         -0.1343869618718862,
         0.098142360602425},
        {0.21821789023599245,
         -0.16903085094570325,
         0.12861319288260697,
         -0.09586261402960045,
         0.0697502970338576,
         -0.049320908022416586,
         0.03369259441587493,
         -0.02205698061002769,
         0.01367915867902048,
         -0.00789766594562009,
         0.004124421526004054,
         -0.0018444973800016966,
         0.000614832460000565,
         -0.1380131118684709,
         0.15511334686589623,
         -0.1485097230642209,
         0.13152242139311127,
         -0.11028490305013816,
         0.08822792244011048,
         -0.06738518883175013,
         0.048940045890073676,
         -0.03350695887416422,
         0.02129842117727076,
         -0.012235011472518435,
         0.00602410321720613,
         -0.002216809960351702,
         0.08377078165833918,
         -0.11846977555181851,
         0.13477037766350028,
         -0.13754944071573258,
         0.13049085706320468,
         -0.11671457073421394,
         0.09889442034075313,
         -0.07929193679543724,
         0.05976854619341822,
         -0.041790520059949106,
         0.026430645598479043,
         -0.014366570530687175,
         0.005865127858981543,
         -0.048365083340667546,
         0.08126959555714991,
         -0.10654533863443545,
         0.12302795988298221,
         -0.13049085706320512,
         0.12948319057722352,
         -0.12112043412158183,
         0.10691722576385576,
         -0.08865108037110736,
         0.06824363348827987,
         -0.04764852397446656,
         0.028733141061374333,
         -0.013114824589410564,
         0.026229649178821177,
         -0.05079349722321851,
         0.0753389314522263,
         -0.09726214227851178,
         0.11444805263353103,
         -0.12537156017984719,
         0.12911481660011873,
         -0.12537156017984719,
         0.11444805263353103,
         -0.09726214227851179,
         0.0753389314522263,
         -0.05079349722321851,
         0.026229649178821174,
         -0.013114824589410564,
         0.028733141061374333,
         -0.047648523974466554,
         0.06824363348827986,
         -0.08865108037110737,
         0.10691722576385579,
         -0.12112043412158177,
         0.12948319057722352,
         -0.13049085706320515,
         0.12302795988298221,
         -0.10654533863443545,
         0.08126959555714992,
         -0.04836508334066755,
         0.005865127858981543,
         -0.014366570530687175,
         0.026430645598479043,
         -0.04179052005994911,
         0.059768546193418204,
         -0.07929193679543721,
         0.09889442034075316,
         -0.11671457073421397,
         0.13049085706320465,
         -0.13754944071573263,
         0.13477037766350028,
         -0.11846977555181848,
         0.08377078165833919,
         -0.002216809960351702,
         0.006024103217206129,
         -0.012235011472518436,
         0.021298421177270765,
         -0.0335069588741642,
         0.04894004589007365,
         -0.06738518883175017,
         0.08822792244011049,
         -0.11028490305013824,
         0.13152242139311127,
         -0.14850972306422086,
         0.15511334686589623,
         -0.13801311186847087,
         0.0006148324600005651,
         -0.0018444973800016958,
         0.004124421526004056,
         -0.007897665945620089,
         0.01367915867902048,
         -0.02205698061002769,
         0.03369259441587494,
         -0.04932090802241658,
         0.0697502970338576,
         -0.09586261402960046,
         0.12861319288260692,
         -0.1690308509457033,
         0.2182178902359925},
        {0.0346985643518151,
         -0.06557412294705334,
         0.09450236920409415,
         -0.11786516260004608,
         0.13296983655438344,
         -0.13818630767179266,
         0.13296983655438344,
         -0.11786516260004608,
         0.09450236920409415,
         -0.06557412294705293,
         0.03469856435181512,
         -0.08137534653950056,
         0.11803342130469537,
         -0.12730892603109592,
         0.1113721101706832,
         -0.07538681129910096,
         0.026593967310876595,
         0.026593967310876595,
         -0.07538681129910096,
         0.1113721101706832,
         -0.12730892603109592,
         0.11803342130469537,
         -0.08137534653950056,
         0.13049085706320468,
         -0.12787554456207256,
         0.07973881616941136,
         -0.01458203214754617,
         -0.046668026042300824,
         0.08927974740080047,
         -0.10445902991252055,
         0.08927974740080047,
         -0.046668026042300824,
         -0.014582032147546171,
         0.07973881616941134,
         -0.12787554456207256,
         0.13049085706320468,
         -0.15683049204020932,
         0.0657612106965557,
         0.02901787758858673,
         -0.08846432836177986,
         0.10362998999257958,
         -0.0796946290876207,
         0.029611351643955695,
         0.029611351643955636,
         -0.0796946290876207,
         0.1036299899925796,
         -0.08846432836177986,
         0.029017877588586732,
         0.0657612106965557,
         -0.1568304920402093,
         0.1312138036317133,
         0.056234487270734435,
         -0.11391088447148756,
         0.09228223552120506,
         -0.03263959750679028,
         -0.03290176294861166,
         0.08140236968560807,
         -0.09909853700856655,
         0.08140236968560807,
         -0.03290176294861165,
         -0.032639597506790255,
         0.09228223552120506,
         -0.11391088447148756,
         0.056234487270734435,
         0.1312138036317133,
         -0.15683049204020932,
         0.0657612106965557,
         0.02901787758858673,
         -0.08846432836177986,
         0.1036299899925796,
         -0.0796946290876207,
         0.029611351643955636,
         0.02961135164395569,
         -0.0796946290876207,
         0.1036299899925796,
         -0.08846432836177986,
         0.02901787758858673,
         0.0657612106965557,
         -0.15683049204020932,
         0.13049085706320465,
         -0.12787554456207265,
         0.07973881616941134,
         -0.014582032147546171,
         -0.0466680260423008,
         0.08927974740080048,
         -0.10445902991252055,
         0.08927974740080047,
         -0.04666802604230081,
         -0.01458203214754617,
         0.07973881616941136,
         -0.12787554456207265,
         0.13049085706320465,
         -0.08137534653950051,
         0.11803342130469537,
         -0.127308926031096,
         0.11137211017068321,
         -0.07538681129910099,
         0.02659396731087659,
         0.02659396731087659,
         -0.07538681129910098,
         0.11137211017068324,
         -0.12730892603109603,
         0.11803342130469531,
         -0.08137534653950056,
         0.03469856435181511,
         -0.06557412294705292,
         0.09450236920409408,
         -0.11786516260004613,
         0.13296983655438346,
         -0.13818630767179263,
         0.13296983655438346,
         -0.11786516260004613,
         0.09450236920409408,
         -0.06557412294705293,
         0.03469856435181511},
        {0.0837707816583391,
         -0.11846977555181815,
         0.13477037766350028,
         -0.1375494407157326,
         0.130490857063205,
         -0.11671457073421407,
         0.09889442034075305,
         -0.07929193679543715,
         0.05976854619341829,
         -0.04179052005994906,
         0.026430645598479054,
         -0.014366570530687194,
         0.0058651278589815494,
         -0.15101992432742017,
         0.12565617248750835,
         -0.07183285265343614,
         0.013754944071573233,
         0.03766946572611339,
         -0.0771994321350966,
         0.10279108803602609,
         -0.11444805263353075,
         0.11356023776749462,
         -0.10246234135702852,
         0.08410179930220311,
         -0.061760831066532226,
         0.03879417430615471,
         -0.01831385586984527,
         0.1510199243274199,
         -0.0806321771231315,
         0.10862368805723345,
         -0.09966403833196685,
         0.0673851888317496,
         -0.023361610917279004,
         -0.022889610526706267,
         0.06390857365872071,
         -0.09429213008003698,
         0.11069289661616247,
         -0.11181671118067167,
         0.09841497412145953,
         -0.07325542347938105,
         0.040951026655107574,
         -0.15101992432742012,
         0.0969078163565819,
         -0.021945298977932157,
         -0.04249688873453666,
         0.08423148603968772,
         -0.09980995940327629,
         0.09084032559118667,
         -0.06211329522091633,
         0.020414845006564736,
         0.026355451575277092,
         -0.06992891524445952,
         0.10237191249373326,
         -0.11682504361340279,
         0.1083462324621918,
         -0.07476600350665902,
         0.11582699457751039,
         -0.1251074529554561,
         0.0950259320426688,
         -0.04543108504242529,
         -0.008530454186035378,
         0.05528366161934056,
         -0.08661285204608561,
         0.09760162722789385,
         -0.0866128520460856,
         0.05528366161934056,
         -0.008530454186035378,
         -0.04543108504242529,
         0.09502593204266882,
         -0.12510745295545606,
         0.11582699457751039,
         -0.07476600350665905,
         0.10834623246219179,
         -0.11682504361340282,
         0.10237191249373326,
         -0.06992891524445952,
         0.026355451575277095,
         0.02041484500656474,
         -0.06211329522091636,
         0.09084032559118667,
         -0.09980995940327628,
         0.08423148603968773,
         -0.04249688873453665,
         -0.021945298977932154,
         0.09690781635658186,
         -0.15101992432742006,
         0.040951026655107574,
         -0.07325542347938103,
         0.09841497412145954,
         -0.11181671118067169,
         0.11069289661616247,
         -0.09429213008003696,
         0.0639085736587207,
         -0.02288961052670628,
         -0.023361610917278997,
         0.06738518883174958,
         -0.09966403833196687,
         0.1086236880572335,
         -0.0806321771231315,
         0.1510199243274199,
         -0.018313855869845262,
         0.03879417430615471,
         -0.061760831066532185,
         0.08410179930220311,
         -0.10246234135702852,
         0.11356023776749462,
         -0.11444805263353075,
         0.10279108803602606,
         -0.07719943213509661,
         0.0376694657261134,
         0.013754944071573228,
         -0.07183285265343615,
         0.12565617248750838,
         -0.15101992432742015,
         0.0058651278589815494,
         -0.014366570530687201,
         0.02643064559847904,
         -0.04179052005994906,
         0.0597685461934183,
         -0.07929193679543715,
         0.09889442034075299,
         -0.11671457073421407,
         0.130490857063205,
         -0.13754944071573263,
         0.13477037766350025,
         -0.11846977555181847,
         0.08377078165833907},
        {0.20851441405707508,
         -0.16633695978261487,
         0.13087322008912075,
         -0.10137396037394027,
         0.07713401811504504,
         -0.05749230262764697,
         0.04183179465772293,
         -0.02957954567167911,
         0.02020667654514326,
         -0.013228374973086883,
         0.008203889894166752,
         -0.004736518038799238,
         0.0024735658727581505,
         -0.0011062122876621644,
         0.000368737429220721,
         -0.12573892269238626,
         0.1451908017281254,
         -0.14336442963229945,
         0.13156022334011386,
         -0.1149846052552937,
         0.09660639162528609,
         -0.07826012174154,
         0.06109924681322393,
         -0.04582443510991808,
         0.03281555957666706,
         -0.022216238855871914,
         0.01399260161871124,
         -0.007977010249428535,
         0.003902350147197235,
         -0.0014281139224951915,
         0.07259540086406284,
         -0.10520073039617793,
         0.12306332036654188,
         -0.12972012959375287,
         0.12779824364990988,
         -0.11954431059235553,
         0.1069236819231419,
         -0.09164887021983616,
         0.07518989286620492,
         -0.05877864307984728,
         0.043410904886642496,
         -0.029847239324145666,
         0.018613023915333194,
         -0.009996797457466323,
         0.004039316155613076,
         -0.03976213862437725,
         0.06826324795544884,
         -0.0917259832921405,
         0.1089867083805985,
         -0.1195443105923555,
         0.12346483308214394,
         -0.12124005927086011,
         0.1136764329311815,
         -0.10180759621425232,
         0.08682180977328514,
         -0.06999798085659725,
         0.05264558171567781,
         -0.03604396582332293,
         0.02137405202903531,
         -0.009615495741855896,
         0.020397546730610044,
         -0.04022450461259716,
         0.06092542214574126,
         -0.08059675775962924,
         0.09760752086802026,
         -0.11067652555985572,
         0.11888565924062687,
         -0.12168335164283826,
         0.1188856592406269,
         -0.11067652555985566,
         0.09760752086802027,
         -0.0805967577596292,
         0.060925422145741245,
         -0.040224504612597155,
         0.020397546730610044,
         -0.009615495741855898,
         0.02137405202903531,
         -0.03604396582332293,
         0.0526455817156778,
         -0.06999798085659725,
         0.08682180977328514,
         -0.10180759621425232,
         0.1136764329311815,
         -0.12124005927086011,
         0.12346483308214394,
         -0.1195443105923555,
         0.10898670838059853,
         -0.0917259832921405,
         0.06826324795544884,
         -0.039762138624377254,
         0.0040393161556130765,
         -0.009996797457466329,
         0.018613023915333187,
         -0.029847239324145666,
         0.043410904886642496,
         -0.058778643079847266,
         0.0751898928662049,
         -0.09164887021983616,
         0.10692368192314185,
         -0.1195443105923555,
         0.12779824364990988,
         -0.12972012959375287,
         0.12306332036654186,
         -0.10520073039617793,
         0.07259540086406283,
         -0.0014281139224951913,
         0.003902350147197235,
         -0.007977010249428538,
         0.013992601618711237,
         -0.022216238855871904,
         0.03281555957666707,
         -0.045824435109918064,
         0.061099246813223956,
         -0.07826012174154,
         0.09660639162528606,
         -0.1149846052552937,
         0.13156022334011375,
         -0.1433644296322994,
         0.14519080172812546,
         -0.1257389226923863,
         0.00036873742922072114,
         -0.0011062122876621648,
         0.0024735658727581484,
         -0.004736518038799238,
         0.008203889894166752,
         -0.013228374973086888,
         0.02020667654514325,
         -0.02957954567167909,
         0.04183179465772295,
         -0.05749230262764697,
         0.07713401811504503,
         -0.10137396037394032,
         0.13087322008912078,
         -0.16633695978261478,
         0.2085144140570751},
        {0.026229649178821143,
         -0.050793497223218576,
         0.07533893145222637,
         -0.09726214227851185,
         0.11444805263353115,
         -0.12537156017984732,
         0.1291148166001186,
         -0.12537156017984732,
         0.11444805263353115,
         -0.09726214227851185,
         0.07533893145222635,
         -0.05079349722321856,
         0.02622964917882115,
         -0.0668727464987511,
         0.10200939541368702,
         -0.11803342130469514,
         0.11508211871897232,
         -0.09537337719460912,
         0.06268578008992369,
         -0.02182438731961636,
         -0.02182438731961636,
         0.06268578008992369,
         -0.09537337719460913,
         0.11508211871897232,
         -0.11803342130469514,
         0.10200939541368702,
         -0.0668727464987511,
         0.11582699457751033,
         -0.12510745295545617,
         0.0950259320426688,
         -0.0454310850424254,
         -0.00853045418603535,
         0.05528366161934068,
         -0.08661285204608557,
         0.09760162722789384,
         -0.08661285204608557,
         0.05528366161934067,
         -0.00853045418603535,
         -0.04543108504242539,
         0.09502593204266878,
         -0.12510745295545617,
         0.11582699457751035,
         -0.14953200701331823,
         0.08190205331021468,
         -0.06220907522417999,
         0.09355257254337383,
         -0.09344644366911428,
         0.06736555159139983,
         -0.02440040680697313,
         -0.02440040680697313,
         0.06736555159139983,
         -0.09344644366911418,
         0.09355257254337383,
         -0.06220907522417999,
         0.08190205331021468,
         -0.14953200701331823,
         0.13374549299750194,
         0.033436373249375775,
         -0.10030911974812587,
         0.10030911974812692,
         -0.06172868907577016,
         0.007716086134470868,
         0.04372448809533696,
         -0.079732890056203,
         0.09259303361365437,
         -0.079732890056203,
         0.04372448809533696,
         0.007716086134470814,
         -0.06172868907577016,
         0.10030911974812692,
         -0.10030911974812587,
         0.033436373249375775,
         0.13374549299750194,
         -0.14953200701331823,
         0.08190205331021469,
         -0.062209075224179976,
         0.09355257254337383,
         -0.09344644366911418,
         0.06736555159139983,
         -0.02440040680697313,
         -0.02440040680697313,
         0.06736555159139983,
         -0.09344644366911428,
         0.09355257254337383,
         -0.06220907522417996,
         0.08190205331021469,
         -0.14953200701331826,
         0.11582699457751035,
         -0.12510745295545614,
         0.09502593204266876,
         -0.04543108504242542,
         -0.008530454186035348,
         0.05528366161934067,
         -0.08661285204608558,
         0.09760162722789381,
         -0.08661285204608558,
         0.05528366161934066,
         -0.00853045418603535,
         -0.04543108504242543,
         0.09502593204266875,
         -0.1251074529554561,
         0.11582699457751032,
         -0.06687274649875112,
         0.10200939541368699,
         -0.11803342130469509,
         0.11508211871897234,
         -0.09537337719460912,
         0.06268578008992377,
         -0.02182438731961635,
         -0.02182438731961635,
         0.06268578008992377,
         -0.09537337719460912,
         0.11508211871897232,
         -0.11803342130469509,
         0.10200939541368696,
         -0.06687274649875112,
         0.026229649178821132,
         -0.05079349722321857,
         0.07533893145222637,
         -0.09726214227851182,
         0.11444805263353114,
         -0.12537156017984735,
         0.12911481660011856,
         -0.12537156017984735,
         0.11444805263353115,
         -0.09726214227851183,
         0.0753389314522264,
         -0.05079349722321859,
         0.02622964917882114},
        {0.0725954008640627,
         -0.10520073039617794,
         0.12306332036654176,
         -0.12972012959375284,
         0.12779824364991013,
         -0.11954431059235557,
         0.10692368192314192,
         -0.09164887021983603,
         0.07518989286620495,
         -0.05877864307984739,
         0.04341090488664254,
         -0.029847239324145628,
         0.018613023915333177,
         -0.009996797457466322,
         0.004039316155613074,
         -0.14058038927888344,
         0.1262617479108661,
         -0.08447145968645467,
         0.03552532057049553,
         0.01112340934491581,
         -0.050516691362858204,
         0.08019276144235671,
         -0.09928627607148956,
         0.1080299983763724,
         -0.10743650827976259,
         0.09907138270052285,
         -0.08487611570154013,
         0.06701796436031526,
         -0.04775149708408357,
         0.029276335411151298,
         -0.013548278259845935,
         0.1502867577088258,
         -0.016802570317748313,
         -0.06170849876135695,
         0.0974325425090736,
         -0.10132163832639099,
         0.08309385676487996,
         -0.05123327596815252,
         0.012990006350449064,
         0.025619765587773163,
         -0.05981369584695828,
         0.08604312310415807,
         -0.1019927329292306,
         0.10657978897745439,
         -0.09995216206280051,
         0.08348241922039823,
         -0.059745339612774936,
         0.03238657956678218,
         -0.14257453695652736,
         0.10407889800966677,
         -0.04194841195313766,
         -0.017161152462472164,
         0.06189683644670993,
         -0.08769925777676173,
         0.09392767260827965,
         -0.08246362048564464,
         0.05687203867415678,
         -0.021815913474482786,
         -0.01740307852881937,
         0.05524297115826572,
         -0.08629992112956045,
         0.10570020972136368,
         -0.10954146252501734,
         0.09541987512962198,
         -0.06294819583082883,
         0.10343444043239275,
         -0.11964297819789628,
         0.10221792235620426,
         -0.06548334492258809,
         0.020596551899041513,
         0.023502491837356095,
         -0.05991274072431783,
         0.0837210308528111,
         -0.09198396775536336,
         0.0837210308528111,
         -0.05991274072431783,
         0.023502491837356095,
         0.020596551899041513,
         -0.06548334492258809,
         0.10221792235620425,
         -0.11964297819789628,
         0.10343444043239278,
         -0.06294819583082883,
         0.09541987512962197,
         -0.10954146252501733,
         0.10570020972136368,
         -0.08629992112956046,
         0.05524297115826569,
         -0.017403078528819366,
         -0.021815913474482786,
         0.05687203867415678,
         -0.08246362048564465,
         0.09392767260827967,
         -0.08769925777676171,
         0.06189683644670996,
         -0.017161152462472167,
         -0.04194841195313766,
         0.1040788980096668,
         -0.14257453695652728,
         0.03238657956678219,
         -0.059745339612774936,
         0.08348241922039827,
         -0.09995216206280053,
         0.10657978897745435,
         -0.10199273292923058,
         0.08604312310415811,
         -0.05981369584695828,
         0.025619765587773173,
         0.01299000635044906,
         -0.05123327596815252,
         0.08309385676487996,
         -0.10132163832639103,
         0.09743254250907356,
         -0.061708498761356964,
         -0.016802570317748313,
         0.15028675770882574,
         -0.013548278259845935,
         0.029276335411151298,
         -0.047751497084083584,
         0.06701796436031526,
         -0.08487611570154016,
         0.09907138270052285,
         -0.10743650827976263,
         0.10802999837637235,
         -0.0992862760714895,
         0.08019276144235667,
         -0.050516691362858204,
         0.011123409344915815,
         0.03552532057049553,
         -0.08447145968645467,
         0.1262617479108661,
         -0.14058038927888336,
         0.004039316155613077,
         -0.009996797457466323,
         0.01861302391533318,
         -0.029847239324145628,
         0.043410904886642496,
         -0.058778643079847405,
         0.07518989286620484,
         -0.09164887021983606,
         0.10692368192314193,
         -0.11954431059235565,
         0.1277982436499101,
         -0.12972012959375284,
         0.12306332036654176,
         -0.1052007303961779,
         0.07259540086406276},
        {0.19999999999999968,
         -0.1632993161855455,
         0.1318760946791577,
         -0.10520073039617779,
         0.08277149204042522,
         -0.06411452204266117,
         0.048783836464845826,
         -0.03636132484620956,
         0.026456749946173645,
         -0.01870774729509626,
         0.012779824364990979,
         -0.008366358931544613,
         0.005188595547760947,
         -0.0029956370362158756,
         0.0015644204200756,
         -0.0006996300809355638,
         0.00023321002697852095,
         -0.11547005383792515,
         0.13620104492139998,
         -0.13774008863003634,
         0.12986260094871324,
         -0.11705656662142594,
         0.10190611080391765,
         -0.08604659952375122,
         0.07055133318979645,
         -0.05612324188528873,
         0.043203691747021176,
         -0.03204071533712067,
         0.02273528658623632,
         -0.015274811703306041,
         0.009558766658308055,
         -0.005419311303938374,
         0.0026384702642753607,
         -0.0009615495741855877,
         0.06370220572706067,
         -0.09409439377939278,
         0.11246431142310681,
         -0.12147534002635711,
         0.12306332036654144,
         -0.1188904626045709,
         0.11043030384093536,
         -0.09899209386613185,
         0.08572966806188381,
         -0.07164521754152188,
         0.05759107332751967,
         -0.04427061022394226,
         0.03223870310385168,
         -0.0219018858810584,
         0.013518137447739007,
         -0.007195578134001697,
         0.002884648722556756,
         -0.033267391956523,
         0.05807632069125036,
         -0.07952427724875447,
         0.09653881107023292,
         -0.10853164706791311,
         0.11534069063463309,
         -0.11712902504162466,
         0.1143062240825118,
         -0.10746782631228295,
         0.09734668131427056,
         -0.08477176461063443,
         0.07063145965876538,
         -0.055839071745999586,
         0.04129859207272074,
         -0.02786835427932283,
         0.016318037384487984,
         -0.007259540086406279,
         0.016232825118589145,
         -0.03246565023717829,
         0.049963581494569684,
         -0.06730847019299124,
         0.08323997348302865,
         -0.09671610931155512,
         0.1069236819231419,
         -0.11328103544472923,
         0.1154389633543681,
         -0.11328103544472923,
         0.10692368192314192,
         -0.09671610931155512,
         0.08323997348302865,
         -0.06730847019299124,
         0.049963581494569684,
         -0.03246565023717828,
         0.016232825118589138,
         -0.007259540086406279,
         0.016318037384487977,
         -0.02786835427932283,
         0.04129859207272073,
         -0.0558390717459996,
         0.07063145965876538,
         -0.08477176461063443,
         0.09734668131427056,
         -0.107467826312283,
         0.11430622408251183,
         -0.11712902504162466,
         0.11534069063463312,
         -0.10853164706791313,
         0.09653881107023292,
         -0.07952427724875447,
         0.05807632069125035,
         -0.03326739195652299,
         0.0028846487225567554,
         -0.007195578134001699,
         0.013518137447739012,
         -0.0219018858810584,
         0.03223870310385167,
         -0.044270610223942256,
         0.05759107332751966,
         -0.07164521754152191,
         0.08572966806188378,
         -0.09899209386613182,
         0.11043030384093536,
         -0.1188904626045709,
         0.1230633203665415,
         -0.12147534002635714,
         0.11246431142310681,
         -0.09409439377939277,
         0.06370220572706069,
         -0.0009615495741855874,
         0.0026384702642753607,
         -0.005419311303938374,
         0.009558766658308057,
         -0.015274811703306034,
         0.022735286586236317,
         -0.032040715337120676,
         0.043203691747021176,
         -0.05612324188528873,
         0.07055133318979641,
         -0.08604659952375131,
         0.10190611080391763,
         -0.11705656662142594,
         0.12986260094871313,
         -0.13774008863003617,
         0.1362010449214,
         -0.11547005383792515,
         0.0002332100269785209,
         -0.0006996300809355636,
         0.001564420420075601,
         -0.0029956370362158756,
         0.005188595547760948,
         -0.00836635893154461,
         0.012779824364990986,
         -0.01870774729509626,
         0.02645674994617364,
         -0.03636132484620958,
         0.04878383646484583,
         -0.0641145220426612,
         0.08277149204042518,
         -0.10520073039617778,
         0.1318760946791577,
         -0.1632993161855453,
         0.19999999999999982},
        {0.02039754673061003,
         -0.0402245046125973,
         0.0609254221457413,
         -0.08059675775962914,
         0.09760752086802053,
         -0.11067652555985565,
         0.11888565924062676,
         -0.1216833516428379,
         0.11888565924062676,
         -0.11067652555985565,
         0.09760752086802055,
         -0.08059675775962916,
         0.0609254221457413,
         -0.040224504612597134,
         0.02039754673061003,
         -0.05586098231060423,
         0.0883893691659766,
         -0.1073146290479247,
         0.11192714746554575,
         -0.10300421200236637,
         0.0824934115551101,
         -0.053167283122383405,
         0.018344455483280193,
         0.018344455483280193,
         -0.053167283122383405,
         0.0824934115551101,
         -0.10300421200236637,
         0.11192714746554576,
         -0.10731462904792469,
         0.0883893691659766,
         -0.05586098231060423,
         0.1034344404323928,
         -0.11964297819789622,
         0.10221792235620433,
         -0.06548334492258805,
         0.020596551899041565,
         0.023502491837356088,
         -0.059912740724317834,
         0.08372103085281116,
         -0.09198396775536341,
         0.08372103085281116,
         -0.059912740724317834,
         0.02350249183735608,
         0.020596551899041568,
         -0.06548334492258803,
         0.10221792235620433,
         -0.11964297819789621,
         0.1034344404323928,
         -0.1421570410764712,
         0.09194172482879312,
         -0.022189994028215945,
         -0.037786270551330915,
         0.07668054205550238,
         -0.09138813321861133,
         0.08354771593571687,
         -0.05777960374482776,
         0.02056824047411373,
         0.020568240474113725,
         -0.0577796037448276,
         0.08354771593571686,
         -0.09138813321861135,
         0.07668054205550238,
         -0.037786270551330915,
         -0.022189994028215945,
         0.09194172482879313,
         -0.1421570410764712,
         0.13486201056952885,
         0.0149846678410592,
         -0.08550075179898178,
         0.09982433135293624,
         -0.07800841787845267,
         0.03702094407791013,
         0.009255236019477149,
         -0.05002234705765245,
         0.07756769235371636,
         -0.08726365389792971,
         0.07756769235371636,
         -0.05002234705765245,
         0.00925523601947715,
         0.03702094407791013,
         -0.07800841787845265,
         0.09982433135293627,
         -0.08550075179898181,
         0.0149846678410592,
         0.13486201056952887,
         -0.14215704107647126,
         0.09194172482879315,
         -0.02218999402821594,
         -0.037786270551330915,
         0.0766805420555024,
         -0.09138813321861135,
         0.08354771593571683,
         -0.0577796037448276,
         0.02056824047411373,
         0.02056824047411373,
         -0.05777960374482776,
         0.08354771593571683,
         -0.09138813321861136,
         0.0766805420555024,
         -0.03778627055133092,
         -0.022189994028215945,
         0.09194172482879318,
         -0.14215704107647126,
         0.10343444043239282,
         -0.11964297819789615,
         0.10221792235620433,
         -0.06548334492258803,
         0.02059655189904156,
         0.023502491837356084,
         -0.05991274072431781,
         0.08372103085281114,
         -0.09198396775536345,
         0.08372103085281114,
         -0.059912740724317806,
         0.02350249183735608,
         0.020596551899041558,
         -0.06548334492258805,
         0.10221792235620433,
         -0.11964297819789615,
         0.10343444043239285,
         -0.05586098231060421,
         0.08838936916597656,
         -0.1073146290479247,
         0.11192714746554577,
         -0.1030042120023664,
         0.08249341155511007,
         -0.05316728312238342,
         0.0183444554832802,
         0.0183444554832802,
         -0.053167283122383426,
         0.08249341155511007,
         -0.10300421200236637,
         0.11192714746554575,
         -0.10731462904792469,
         0.08838936916597658,
         -0.05586098231060422,
         0.020397546730610023,
         -0.04022450461259715,
         0.0609254221457413,
         -0.08059675775962911,
         0.09760752086802053,
         -0.11067652555985569,
         0.11888565924062676,
         -0.1216833516428379,
         0.11888565924062675,
         -0.11067652555985569,
         0.09760752086802052,
         -0.08059675775962911,
         0.060925422145741315,
         -0.040224504612597134,
         0.020397546730610016},
        {0.06370220572706076,
         -0.09409439377939244,
         0.11246431142310706,
         -0.12147534002635682,
         0.12306332036654154,
         -0.11889046260457056,
         0.1104303038409353,
         -0.09899209386613178,
         0.08572966806188372,
         -0.07164521754152184,
         0.05759107332751943,
         -0.044270610223942145,
         0.0322387031038517,
         -0.021901885881058344,
         0.013518137447739022,
         -0.007195578134001685,
         0.002884648722556756,
         -0.13132546139874882,
         0.12484509505867987,
         -0.09239886042108246,
         0.051332700233933985,
         -0.00985295114570956,
         -0.027517794987642168,
         0.05826798143811978,
         -0.08116278541056074,
         0.0958486827374326,
         -0.10260876789917563,
         0.10219469873701073,
         -0.09570110962029046,
         0.08446469899496373,
         -0.0699775822022645,
         0.05380787590712578,
         -0.037521456864899265,
         0.0225964149933613,
         -0.010300256196813337,
         0.14890907643081489,
         -0.02993185056965864,
         -0.04514860336956688,
         0.0850150283987608,
         -0.0975697035377843,
         0.08993444669022613,
         -0.06845061912930299,
         0.038679132670276305,
         -0.005400461468377375,
         -0.027385337924980845,
         0.056458591125197875,
         -0.07937994036414647,
         0.09449021633936108,
         -0.1009101700058943,
         0.0985398606521682,
         -0.08805709219236464,
         0.07091273693018703,
         -0.049312991466988775,
         0.026115916048591686,
         -0.13469332756346364,
         0.10777247715580338,
         -0.056399265012237576,
         0.003447814681078929,
         0.04081936903222309,
         -0.0715954782824063,
         0.08718936670447838,
         -0.08792822152823118,
         0.07552375519737373,
         -0.05264936337799179,
         0.022625064521525382,
         0.01083969781472502,
         -0.04387355637185694,
         0.072659988781597,
         -0.09365930702206363,
         0.10385296514414728,
         -0.10103185430848051,
         0.08415128504546227,
         -0.05366310619676687,
         0.09294722642476456,
         -0.1131317612675197,
         0.10460107591827912,
         -0.07801514052051216,
         0.04175976096259572,
         -0.0027593782516470654,
         -0.03337022803474715,
         0.06227811907462823,
         -0.08086238513640878,
         0.08726365389793077,
         -0.08086238513640878,
         0.06227811907462823,
         -0.03337022803474715,
         -0.0027593782516470654,
         0.04175976096259572,
         -0.07801514052051217,
         0.10460107591827911,
         -0.1131317612675197,
         0.09294722642476456,
         -0.05366310619676687,
         0.08415128504546227,
         -0.10103185430848052,
         0.10385296514414727,
         -0.0936593070220636,
         0.072659988781597,
         -0.04387355637185694,
         0.01083969781472502,
         0.02262506452152538,
         -0.05264936337799179,
         0.07552375519737374,
         -0.08792822152823117,
         0.08718936670447838,
         -0.07159547828240628,
         0.0408193690322231,
         0.003447814681078928,
         -0.05639926501223757,
         0.10777247715580338,
         -0.13469332756346367,
         0.026115916048591703,
         -0.049312991466988795,
         0.070912736930187,
         -0.0880570921923647,
         0.0985398606521682,
         -0.10091017000589433,
         0.09449021633936111,
         -0.07937994036414647,
         0.05645859112519788,
         -0.027385337924980838,
         -0.005400461468377374,
         0.038679132670276305,
         -0.06845061912930292,
         0.08993444669022616,
         -0.09756970353778428,
         0.08501502839876081,
         -0.045148603369566845,
         -0.029931850569658625,
         0.14890907643081494,
         -0.010300256196813339,
         0.022596414993361312,
         -0.03752145686489926,
         0.05380787590712578,
         -0.0699775822022645,
         0.08446469899496371,
         -0.09570110962029052,
         0.10219469873701073,
         -0.1026087678991757,
         0.09584868273743256,
         -0.08116278541056074,
         0.058267981438119794,
         -0.02751779498764217,
         -0.009852951145709563,
         0.05133270023393401,
         -0.09239886042108238,
         0.1248450950586799,
         -0.13132546139874887,
         0.002884648722556756,
         -0.007195578134001683,
         0.013518137447739024,
         -0.021901885881058333,
         0.032238703103851706,
         -0.04427061022394214,
         0.0575910733275194,
         -0.07164521754152182,
         0.08572966806188377,
         -0.09899209386613184,
         0.11043030384093523,
         -0.11889046260457056,
         0.12306332036654165,
         -0.12147534002635685,
         0.11246431142310707,
         -0.09409439377939285,
         0.06370220572706073},
        {0.016232825118589155,
         -0.0324656502371784,
         0.0499635814945698,
         -0.06730847019299109,
         0.08323997348302876,
         -0.09671610931155494,
         0.1069236819231419,
         -0.1132810354447292,
         0.11543896335436765,
         -0.11328103544472921,
         0.1069236819231419,
         -0.09671610931155492,
         0.08323997348302879,
         -0.06730847019299109,
         0.04996358149456979,
         -0.03246565023717826,
         0.01623282511858916,
         -0.047326411191964894,
         0.07699905035090197,
         -0.0968257026717142,
         0.10577045316041425,
         -0.10388976665584287,
         0.09212976800243607,
         -0.07208793164664584,
         0.0458244351099179,
         -0.01570925314744714,
         -0.015709253147447144,
         0.04582443510991789,
         -0.07208793164664584,
         0.09212976800243607,
         -0.10388976665584286,
         0.10577045316041427,
         -0.09682570267171421,
         0.07699905035090196,
         -0.0473264111919649,
         0.09294722642476466,
         -0.11313176126751971,
         0.10460107591827919,
         -0.07801514052051221,
         0.04175976096259573,
         -0.002759378251647066,
         -0.03337022803474717,
         0.06227811907462826,
         -0.08086238513640882,
         0.08726365389793081,
         -0.08086238513640882,
         0.06227811907462826,
         -0.033370228034747165,
         -0.002759378251647066,
         0.041759760962595725,
         -0.07801514052051221,
         0.10460107591827922,
         -0.11313176126751971,
         0.09294722642476469,
         -0.13504918902264743,
         0.09797497923254847,
         -0.03893130905288625,
         -0.01670402066821888,
         0.05825651291172941,
         -0.0815987568701474,
         0.08638220284845592,
         -0.07468574845872011,
         0.050199198328511954,
         -0.017649943036807468,
         -0.017649943036807468,
         0.05019919832851195,
         -0.07468574845872011,
         0.08638220284845592,
         -0.0815987568701474,
         0.05825651291172941,
         -0.016704020668218883,
         -0.03893130905288625,
         0.09797497923254847,
         -0.13504918902264743,
         0.13504918902264743,
         -0.07107852053823546,
         0.09477136071764819,
         -0.0857123335902247,
         0.05658407713436084,
         -0.018118054254844224,
         -0.02090544721712757,
         0.0536573145239623,
         -0.07525960998166117,
         0.08278557097982728,
         -0.07525960998166117,
         0.0536573145239623,
         -0.02090544721712757,
         -0.018118054254844265,
         0.05658407713436083,
         -0.0857123335902247,
         0.09477136071764818,
         -0.07107852053823546,
         0.13504918902264743,
         -0.13504918902264743,
         0.09797497923254843,
         -0.03893130905288626,
         -0.016704020668218883,
         0.058256512911729424,
         -0.08159875687014737,
         0.08638220284845591,
         -0.07468574845872016,
         0.05019919832851195,
         -0.01764994303680746,
         -0.017649943036807465,
         0.050199198328511954,
         -0.07468574845872016,
         0.08638220284845591,
         -0.08159875687014737,
         0.058256512911729424,
         -0.01670402066821888,
         -0.03893130905288625,
         0.09797497923254843,
         -0.13504918902264743,
         0.09294722642476475,
         -0.11313176126751971,
         0.1046010759182792,
         -0.07801514052051217,
         0.04175976096259574,
         -0.002759378251647065,
         -0.03337022803474718,
         0.06227811907462826,
         -0.08086238513640884,
         0.08726365389793077,
         -0.08086238513640884,
         0.06227811907462826,
         -0.03337022803474718,
         -0.002759378251647065,
         0.04175976096259574,
         -0.0780151405205122,
         0.1046010759182792,
         -0.11313176126751971,
         0.0929472264247647,
         -0.0473264111919649,
         0.07699905035090197,
         -0.09682570267171418,
         0.10577045316041424,
         -0.10388976665584285,
         0.09212976800243611,
         -0.07208793164664581,
         0.045824435109917905,
         -0.01570925314744714,
         -0.01570925314744714,
         0.045824435109917905,
         -0.07208793164664581,
         0.09212976800243611,
         -0.10388976665584285,
         0.10577045316041424,
         -0.09682570267171413,
         0.076999050350902,
         -0.04732641119196493,
         0.016232825118589148,
         -0.032465650237178255,
         0.049963581494569795,
         -0.06730847019299106,
         0.08323997348302871,
         -0.09671610931155498,
         0.10692368192314196,
         -0.11328103544472928,
         0.11543896335436767,
         -0.1132810354447293,
         0.10692368192314194,
         -0.09671610931155496,
         0.0832399734830287,
         -0.06730847019299106,
         0.049963581494569795,
         -0.03246565023717825,
         0.01623282511858914},
        {0.05648790304908824,
         -0.08473185457363197,
         0.10302016773904554,
         -0.11342147175792848,
         0.11740237702510174,
         -0.11622242369061705,
         0.11100797284177626,
         -0.10277341249192183,
         0.09242887466920877,
         -0.08078351798289678,
         0.06854708804857404,
         -0.05633072223016298,
         0.044647388168594496,
         -0.03391212572685074,
         0.02444216360556932,
         -0.01645691680258015,
         0.010077762226439012,
         -0.005327046055908227,
         0.0021223459497544867,
         -0.12311253046174928,
         0.1222998976175569,
         -0.09717297154614628,
         0.0627672826066157,
         -0.026251969574818457,
         -0.00830160169218673,
         0.038485090198685845,
         -0.06293560493244721,
         0.08101019496649642,
         -0.09258920241272223,
         0.09794481029237198,
         -0.09764582085806359,
         0.0924838754920882,
         -0.08341280022543378,
         0.07149593984086694,
         -0.05785792792273458,
         0.0436379905069772,
         -0.029941650416822528,
         0.017785335037752228,
         -0.008011680267506923,
         0.14714761857543476,
         -0.04029803498846559,
         -0.030843463038199417,
         0.07265354696939101,
         -0.09099360475287938,
         0.09120974188577184,
         -0.07813278300296854,
         0.05607827428951539,
         -0.02884648722556713,
         -0.00027757545274748134,
         0.02852416998937077,
         -0.05363879507478306,
         0.07388216274013497,
         -0.08803014470230415,
         0.09537366780366673,
         -0.09571849582758254,
         0.08938473307446264,
         -0.07720555900037954,
         0.06052345273760027,
         -0.04117589469762557,
         0.02141211618099168,
         -0.12743357579270967,
         0.10923537499252889,
         -0.06677889948137175,
         0.019910177774793574,
         0.02218696378116232,
         -0.05482926930790813,
         0.07587060639169553,
         -0.08480610625948475,
         0.0822701051467927,
         -0.06971234412845517,
         0.04916579168219787,
         -0.02306526272044894,
         -0.005905064195547835,
         0.03494857005134296,
         -0.061287000525739856,
         0.08229322689764818,
         -0.09563449700714975,
         0.09943701375571062,
         -0.09248682790766491,
         0.0744821623216877,
         -0.04625545759106331,
         0.08402721153271485,
         -0.1063875524594453,
         0.10414025856453939,
         -0.0854312507390971,
         0.056687888606481086,
         -0.023325487074914653,
         -0.010120017180008328,
         0.03995395798654039,
         -0.06330911328535092,
         0.07813990223277345,
         -0.08321974751420051,
         0.07813990223277345,
         -0.06330911328535094,
         0.039953957986540396,
         -0.010120017180008328,
         -0.023325487074914657,
         0.05668788860648108,
         -0.08543125073909709,
         0.10414025856453939,
         -0.10638755245944528,
         0.08402721153271484,
         -0.04625545759106331,
         0.0744821623216877,
         -0.09248682790766491,
         0.09943701375571065,
         -0.09563449700714974,
         0.0822932268976482,
         -0.06128700052573987,
         0.03494857005134296,
         -0.005905064195547833,
         -0.023065262720448943,
         0.049165791682197875,
         -0.06971234412845516,
         0.0822701051467927,
         -0.08480610625948475,
         0.07587060639169553,
         -0.05482926930790816,
         0.02218696378116232,
         0.019910177774793578,
         -0.06677889948137176,
         0.10923537499252889,
         -0.12743357579270967,
         0.021412116180991685,
         -0.041175894697625566,
         0.060523452737600285,
         -0.07720555900037951,
         0.0893847330744626,
         -0.09571849582758253,
         0.09537366780366675,
         -0.08803014470230415,
         0.073882162740135,
         -0.05363879507478307,
         0.02852416998937077,
         -0.00027757545274748144,
         -0.02884648722556713,
         0.05607827428951537,
         -0.0781327830029686,
         0.09120974188577186,
         -0.09099360475287942,
         0.07265354696939101,
         -0.030843463038199424,
         -0.0402980349884656,
         0.14714761857543474,
         -0.008011680267506921,
         0.017785335037752228,
         -0.029941650416822528,
         0.043637990506977205,
         -0.05785792792273458,
         0.07149593984086693,
         -0.08341280022543379,
         0.09248387549208818,
         -0.09764582085806361,
         0.09794481029237204,
         -0.09258920241272219,
         0.08101019496649642,
         -0.0629356049324472,
         0.03848509019868584,
         -0.008301601692186725,
         -0.026251969574818457,
         0.0627672826066157,
         -0.09717297154614636,
         0.1222998976175569,
         -0.1231125304617493,
         0.002122345949754486,
         -0.005327046055908229,
         0.010077762226439019,
         -0.016456916802580147,
         0.024442163605569327,
         -0.0339121257268507,
         0.04464738816859452,
         -0.05633072223016297,
         0.06854708804857404,
         -0.08078351798289678,
         0.0924288746692087,
         -0.10277341249192178,
         0.11100797284177627,
         -0.11622242369061708,
         0.1174023770251018,
         -0.1134214717579284,
         0.10302016773904549,
         -0.0847318545736323,
         0.05648790304908819},
        {0.013168810300171915,
         -0.026635230279541067,
         0.04150800846093462,
         -0.05671073587896433,
         0.07126054009500665,
         -0.08431660811776594,
         0.09518855140951343,
         -0.10333862342207956,
         0.1083824626028004,
         -0.11008937804608032,
         0.10838246260280038,
         -0.10333862342207953,
         0.09518855140951343,
         -0.08431660811776594,
         0.07126054009500667,
         -0.05671073587896434,
         0.04150800846093462,
         -0.026635230279541143,
         0.013168810300171913,
         -0.0405889993084109,
         0.06749927690160337,
         -0.08718425636326953,
         0.09851778105506677,
         -0.10119665784422587,
         0.09560604705947066,
         -0.08264680697007198,
         0.06360052616387742,
         -0.040022876753371635,
         0.013654906787036417,
         0.013654906787036417,
         -0.040022876753371635,
         0.06360052616387742,
         -0.08264680697007198,
         0.09560604705947068,
         -0.10119665784422588,
         0.09851778105506677,
         -0.08718425636326953,
         0.06749927690160339,
         -0.04058899930841089,
         0.084027211532715,
         -0.10638755245944541,
         0.10414025856453937,
         -0.08543125073909706,
         0.056687888606481086,
         -0.02332548707491465,
         -0.010120017180008326,
         0.03995395798654041,
         -0.06330911328535092,
         0.07813990223277344,
         -0.0832197475142002,
         0.07813990223277344,
         -0.06330911328535092,
         0.03995395798654041,
         -0.010120017180008326,
         -0.02332548707491465,
         0.05668788860648108,
         -0.08543125073909708,
         0.10414025856453936,
         -0.1063875524594454,
         0.084027211532715,
         -0.1283536857615774,
         0.10134063012139556,
         -0.05147821867385365,
         0.0008968548547208551,
         0.04060036636628163,
         -0.06857398508239204,
         0.08165553750313854,
         -0.08046447870120094,
         0.06697745377628554,
         -0.04410368608079372,
         0.015365464200669414,
         0.015365464200669414,
         -0.04410368608079372,
         0.06697745377628556,
         -0.08046447870120094,
         0.08165553750313854,
         -0.06857398508239204,
         0.04060036636628163,
         0.0008968548547208547,
         -0.05147821867385366,
         0.10134063012139562,
         -0.1283536857615774,
         0.1346184813219938,
         -0.012238043756544493,
         -0.05769363485228274,
         0.08741459826103443,
         -0.08787467509398837,
         0.06873547884314996,
         -0.03837040786826491,
         0.0038646453968048237,
         0.02898484047602787,
         -0.055669296787289456,
         0.07296818570631665,
         -0.0789491845347027,
         0.07296818570631665,
         -0.055669296787289456,
         0.02898484047602787,
         0.0038646453968047686,
         -0.03837040786826491,
         0.06873547884314996,
         -0.08787467509398834,
         0.08741459826103443,
         -0.057693634852282745,
         -0.012238043756544494,
         0.13461848132199378,
         -0.1283536857615774,
         0.10134063012139563,
         -0.05147821867385365,
         0.0008968548547208547,
         0.04060036636628163,
         -0.06857398508239203,
         0.08165553750313857,
         -0.08046447870120094,
         0.06697745377628554,
         -0.044103686080793736,
         0.015365464200669414,
         0.015365464200669414,
         -0.044103686080793736,
         0.06697745377628554,
         -0.08046447870120094,
         0.08165553750313856,
         -0.06857398508239201,
         0.04060036636628163,
         0.0008968548547208547,
         -0.05147821867385365,
         0.10134063012139563,
         -0.12835368576157744,
         0.08402721153271499,
         -0.10638755245944541,
         0.10414025856453941,
         -0.08543125073909709,
         0.056687888606481086,
         -0.023325487074914667,
         -0.010120017180008323,
         0.039953957986540396,
         -0.06330911328535088,
         0.07813990223277344,
         -0.08321974751420023,
         0.07813990223277344,
         -0.06330911328535087,
         0.039953957986540396,
         -0.010120017180008324,
         -0.023325487074914664,
         0.056687888606481086,
         -0.08543125073909708,
         0.10414025856453944,
         -0.10638755245944541,
         0.08402721153271499,
         -0.0405889993084109,
         0.06749927690160334,
         -0.08718425636326954,
         0.09851778105506682,
         -0.10119665784422582,
         0.09560604705947068,
         -0.08264680697007196,
         0.06360052616387739,
         -0.040022876753371635,
         0.013654906787036427,
         0.013654906787036427,
         -0.04002287675337164,
         0.06360052616387739,
         -0.08264680697007196,
         0.0956060470594707,
         -0.10119665784422581,
         0.09851778105506681,
         -0.08718425636326954,
         0.06749927690160334,
         -0.040588999308410895,
         0.013168810300171903,
         -0.026635230279541133,
         0.04150800846093462,
         -0.05671073587896436,
         0.07126054009500662,
         -0.08431660811776596,
         0.09518855140951346,
         -0.10333862342207957,
         0.1083824626028003,
         -0.11008937804608039,
         0.10838246260280028,
         -0.10333862342207957,
         0.09518855140951346,
         -0.08431660811776599,
         0.07126054009500662,
         -0.05671073587896435,
         0.0415080084609346,
         -0.026635230279541133,
         0.013168810300171903},
        {0.010857705699740946,
         -0.022163198951394847,
         0.03489040051253003,
         -0.048208016125592994,
         0.06134074845368548,
         -0.07360889814442283,
         0.08443519693603087,
         -0.09334662244552673,
         0.09997500937109574,
         -0.10405728890205852,
         0.10543559119328262,
         -0.10405728890205852,
         0.09997500937109577,
         -0.09334662244552674,
         0.08443519693603087,
         -0.07360889814442284,
         0.061340748453685465,
         -0.048208016125593,
         0.03489040051253001,
         -0.0221631989513949,
         0.010857705699740946,
         -0.03518298760982299,
         0.059552643431008176,
         -0.07856288953066828,
         0.0911045870486503,
         -0.09670255898167229,
         0.09542381022825085,
         -0.08774763062417393,
         0.07446484433116632,
         -0.056599703549641646,
         0.03534650353774457,
         -0.012015500751749564,
         -0.012015500751749564,
         0.035346503537744565,
         -0.056599703549641646,
         0.07446484433116632,
         -0.08774763062417394,
         0.09542381022825085,
         -0.0967025589816723,
         0.0911045870486503,
         -0.07856288953066831,
         0.059552643431008176,
         -0.03518298760982299,
         0.07639073089438446,
         -0.09980824526939029,
         0.10201982082579464,
         -0.0893943081195657,
         0.06694792544884968,
         -0.03896607552209317,
         0.009120043619356857,
         0.019499473472039636,
         -0.04437017707188239,
         0.06353300966272014,
         -0.07558974640641183,
         0.07970181532357187,
         -0.07558974640641183,
         0.06353300966272016,
         -0.04437017707188239,
         0.019499473472039636,
         0.009120043619356857,
         -0.03896607552209317,
         0.06694792544884968,
         -0.08939430811956568,
         0.10201982082579468,
         -0.0998082452693903,
         0.07639073089438447,
         -0.12211902510406253,
         0.10290982110608535,
         -0.0608334919735113,
         0.01535132092862885,
         0.024631859304272277,
         -0.05470322817122507,
         0.07299387082611918,
         -0.07928220704946341,
         0.07448674253611794,
         -0.060335486711494406,
         0.03912618691327649,
         -0.013536680260577721,
         -0.013536680260577721,
         0.03912618691327649,
         -0.060335486711494406,
         0.07448674253611794,
         -0.07928220704946341,
         0.07299387082611918,
         -0.05470322817122506,
         0.024631859304272277,
         0.01535132092862885,
         -0.0608334919735113,
         0.10290982110608535,
         -0.12211902510406253,
         0.1337746895000691,
         -0.022295781583344842,
         -0.045560944974661524,
         0.07904868015913182,
         -0.08653935776618482,
         0.07552365540287143,
         -0.052610994487182344,
         0.02352954024803655,
         0.006873798274707981,
         -0.034633368230253335,
         0.05666477295688122,
         -0.07076487198191937,
         0.07561178102177922,
         -0.07076487198191937,
         0.05666477295688122,
         -0.034633368230253335,
         0.006873798274707982,
         0.023529540248036548,
         -0.05261099448718234,
         0.07552365540287143,
         -0.08653935776618482,
         0.07904868015913182,
         -0.04556094497466152,
         -0.022295781583344842,
         0.1337746895000691,
         -0.12211902510406251,
         0.10290982110608536,
         -0.0608334919735113,
         0.01535132092862885,
         0.024631859304272277,
         -0.05470322817122507,
         0.07299387082611918,
         -0.07928220704946341,
         0.07448674253611794,
         -0.060335486711494406,
         0.03912618691327649,
         -0.013536680260577723,
         -0.013536680260577723,
         0.03912618691327649,
         -0.060335486711494406,
         0.07448674253611794,
         -0.07928220704946341,
         0.07299387082611918,
         -0.05470322817122506,
         0.024631859304272277,
         0.015351320928628847,
         -0.060833491973511296,
         0.10290982110608535,
         -0.12211902510406254,
         0.07639073089438446,
         -0.0998082452693903,
         0.10201982082579465,
         -0.08939430811956568,
         0.06694792544884968,
         -0.03896607552209316,
         0.009120043619356857,
         0.019499473472039636,
         -0.04437017707188239,
         0.06353300966272014,
         -0.07558974640641183,
         0.07970181532357186,
         -0.07558974640641183,
         0.06353300966272013,
         -0.04437017707188239,
         0.019499473472039636,
         0.009120043619356857,
         -0.03896607552209316,
         0.06694792544884968,
         -0.08939430811956567,
         0.10201982082579467,
         -0.09980824526939029,
         0.07639073089438446,
         -0.03518298760982299,
         0.059552643431008176,
         -0.07856288953066831,
         0.0911045870486503,
         -0.09670255898167229,
         0.09542381022825085,
         -0.08774763062417391,
         0.07446484433116633,
         -0.05659970354964165,
         0.03534650353774457,
         -0.012015500751749564,
         -0.012015500751749564,
         0.03534650353774457,
         -0.05659970354964165,
         0.07446484433116632,
         -0.08774763062417391,
         0.09542381022825085,
         -0.09670255898167229,
         0.0911045870486503,
         -0.07856288953066831,
         0.059552643431008176,
         -0.03518298760982299,
         0.010857705699740946,
         -0.0221631989513949,
         0.03489040051253002,
         -0.04820801612559301,
         0.061340748453685465,
         -0.07360889814442284,
         0.08443519693603087,
         -0.0933466224455267,
         0.09997500937109574,
         -0.10405728890205852,
         0.10543559119328261,
         -0.10405728890205852,
         0.09997500937109574,
         -0.0933466224455267,
         0.08443519693603087,
         -0.07360889814442283,
         0.061340748453685465,
         -0.04820801612559301,
         0.03489040051253001,
         -0.0221631989513949,
         0.010857705699740946},
        {0.08238525545716346,
         -0.1302625264297258,
         0.1521138589340318,
         -0.1469559492086513,
         0.1199890300758524,
         -0.08049108834116175,
         0.03927562949192333,
         -0.1378569000336137,
         0.13537278845914205,
         -0.07025838192242882,
         -0.01756459548060699,
         0.09294310304227144,
         -0.13198793308343748,
         0.12568201437415466,
         -0.08049108834116175,
         0.15918343668810858,
         -0.05627984376737055,
         -0.058957067675360374,
         0.11337897629876954,
         -0.09108032686966383,
         0.013855139762819,
         0.07593288368438497,
         -0.1319879330834375,
         0.1199890300758524,
         -0.1378569000336137,
         -0.05627984376737055,
         0.11756475936692093,
         -0.060845543573612534,
         -0.03702941859881243,
         0.10261893502060682,
         -0.094261510780616,
         0.013855139762819192,
         0.09294310304227145,
         -0.1469559492086513,
         0.08238525545716337,
         0.13537278845914202,
         -0.05895706767536036,
         -0.06084554357361271,
         0.1073214511215487,
         -0.061962068694847584,
         -0.03142050359353933,
         0.10261893502060682,
         -0.09108032686966402,
         -0.017564595480606994,
         0.15211385893403181,
         -0.13026252642972655,
         -0.07025838192242882,
         0.11337897629876975,
         -0.03702941859881243,
         -0.06196206869484751,
         0.10473501197846254,
         -0.06196206869484752,
         -0.037029418598812425,
         0.11337897629876975,
         -0.07025838192242884,
         -0.13026252642972652,
         0.15211385893403181,
         -0.017564595480606994,
         -0.091080326869664,
         0.10261893502060679,
         -0.03142050359353934,
         -0.0619620686948476,
         0.10732145112154876,
         -0.060845543573612694,
         -0.05895706767536036,
         0.135372788459142,
         0.08238525545716334,
         -0.1469559492086512,
         0.09294310304227145,
         0.013855139762819189,
         -0.09426151078061595,
         0.10261893502060677,
         -0.03702941859881243,
         -0.060845543573612534,
         0.11756475936692093,
         -0.05627984376737055,
         -0.1378569000336137,
         0.1199890300758524,
         -0.1319879330834376,
         0.07593288368438494,
         0.013855139762818996,
         -0.09108032686966389,
         0.11337897629876952,
         -0.058957067675360374,
         -0.056279843767370566,
         0.15918343668810855,
         -0.08049108834116177,
         0.1256820143741546,
         -0.1319879330834376,
         0.09294310304227142,
         -0.017564595480606994,
         -0.07025838192242884,
         0.135372788459142,
         -0.13785690003361367,
         0.03927562949192334,
         -0.08049108834116177,
         0.11998903007585246,
         -0.14695594920865124,
         0.15211385893403181,
         -0.13026252642972655,
         0.08238525545716334},
        {0.12441815044835977,
         -0.15238049166965584,
         0.14721354090363745,
         -0.12441815044836005,
         0.09450236920409433,
         -0.06455740830005939,
         0.03892958195801317,
         -0.019740901095970372,
         0.007356999464614976,
         -0.16692446522239693,
         0.07868894753646327,
         0.017595383576944627,
         -0.0861994231841231,
         0.12003413025789071,
         -0.12345737815154025,
         0.10554153581874123,
         -0.07651279443199585,
         0.045613396680612824,
         -0.019740901095970372,
         0.12441815044835978,
         0.07868894753646327,
         -0.12190439333572463,
         0.08063217712313184,
         -0.008452548863005678,
         -0.05976854619341844,
         0.10476945862039957,
         -0.11978135052131979,
         0.10741219218337873,
         -0.07651279443199585,
         0.03892958195801317,
         -0.15238049166965573,
         0.017595383576944627,
         0.08063217712313185,
         -0.10955755484352152,
         0.08018791932289175,
         -0.0180208947262356,
         -0.04954926850428392,
         0.10005519271876406,
         -0.11978135052131976,
         0.10554153581874123,
         -0.06455740830005938,
         0.14721354090363745,
         -0.0861994231841231,
         -0.008452548863005682,
         0.08018791932289175,
         -0.10445902991252058,
         0.0797819019326299,
         -0.020599598500922113,
         -0.04954926850428392,
         0.10476945862039957,
         -0.1234573781515403,
         0.0945023692040943,
         -0.12441815044836005,
         0.12003413025789074,
         -0.05976854619341844,
         -0.0180208947262356,
         0.0797819019326299,
         -0.10299799250461,
         0.07978190193262993,
         -0.018020894726235595,
         -0.059768546193418426,
         0.12003413025789071,
         -0.12441815044836005,
         0.09450236920409433,
         -0.12345737815154027,
         0.10476945862039957,
         -0.049549268504283935,
         -0.02059959850092211,
         0.0797819019326299,
         -0.10445902991252058,
         0.08018791932289177,
         -0.008452548863005682,
         -0.08619942318412309,
         0.14721354090363745,
         -0.06455740830005939,
         0.10554153581874123,
         -0.11978135052131979,
         0.10005519271876401,
         -0.04954926850428394,
         -0.0180208947262356,
         0.08018791932289177,
         -0.10955755484352146,
         0.08063217712313188,
         0.017595383576944637,
         -0.1523804916696558,
         0.03892958195801314,
         -0.07651279443199578,
         0.10741219218337875,
         -0.11978135052131979,
         0.10476945862039953,
         -0.059768546193418426,
         -0.008452548863005682,
         0.08063217712313189,
         -0.12190439333572455,
         0.07868894753646329,
         0.12441815044835978,
         -0.019740901095970372,
         0.04561339668061284,
         -0.07651279443199578,
         0.10554153581874122,
         -0.1234573781515403,
         0.12003413025789074,
         -0.08619942318412309,
         0.01759538357694464,
         0.0786889475364633,
         -0.16692446522239693,
         0.0073569994646149744,
         -0.019740901095970372,
         0.03892958195801314,
         -0.0645574083000594,
         0.09450236920409438,
         -0.12441815044836002,
         0.14721354090363747,
         -0.15238049166965573,
         0.12441815044835978},
        {0.21821789023599225,
         -0.15430334996209227,
         0.10619884881071831,
         -0.07079923254047894,
         0.045431085042425524,
         -0.02782074420373281,
         0.016062314155080862,
         -0.00858566805814888,
         0.004124421526004044,
         -0.001683788037143515,
         0.0005076811950630936,
         -0.15430334996209205,
         0.1583118967153261,
         -0.1371021242767705,
         0.10860106519162163,
         -0.08031157077540439,
         0.05564148840746562,
         -0.03591642632671803,
         0.021298421177270786,
         -0.011295193532261508,
         0.0050768119506309365,
         -0.0016837880371435145,
         0.10619884881071832,
         -0.1371021242767705,
         0.1410769220009914,
         -0.12878502087223284,
         0.10774927898015363,
         -0.0834622326111986,
         0.0597685461934183,
         -0.03912769815840064,
         0.022845653777839228,
         -0.011295193532261508,
         0.004124421526004043,
         -0.07079923254047894,
         0.1086010651916216,
         -0.12878502087223284,
         0.13300859762110198,
         -0.12441815044835994,
         0.10691722576385557,
         -0.08452548863005505,
         0.06092174340757134,
         -0.03912769815840064,
         0.021298421177270783,
         -0.008585668058148881,
         0.04543108504242553,
         -0.08031157077540439,
         0.10774927898015361,
         -0.12441815044835997,
         0.12911481660011867,
         -0.12248907003938808,
         0.10661305096324965,
         -0.08452548863005505,
         0.0597685461934183,
         -0.03591642632671802,
         0.01606231415508087,
         -0.02782074420373281,
         0.05564148840746562,
         -0.0834622326111986,
         0.10691722576385557,
         -0.12248907003938808,
         0.1279356611558996,
         -0.12248907003938808,
         0.10691722576385557,
         -0.0834622326111986,
         0.05564148840746562,
         -0.02782074420373281,
         0.016062314155080862,
         -0.03591642632671802,
         0.0597685461934183,
         -0.08452548863005503,
         0.10661305096324965,
         -0.12248907003938811,
         0.12911481660011867,
         -0.12441815044835994,
         0.10774927898015361,
         -0.08031157077540439,
         0.045431085042425545,
         -0.00858566805814888,
         0.021298421177270783,
         -0.03912769815840063,
         0.06092174340757134,
         -0.08452548863005502,
         0.10691722576385557,
         -0.12441815044835994,
         0.13300859762110204,
         -0.12878502087223287,
         0.1086010651916216,
         -0.07079923254047894,
         0.004124421526004044,
         -0.011295193532261508,
         0.022845653777839228,
         -0.039127698158400635,
         0.0597685461934183,
         -0.08346223261119862,
         0.1077492789801536,
         -0.12878502087223287,
         0.1410769220009914,
         -0.13710212427677054,
         0.1061988488107183,
         -0.001683788037143515,
         0.0050768119506309365,
         -0.011295193532261504,
         0.021298421177270783,
         -0.03591642632671801,
         0.055641488407465606,
         -0.08031157077540439,
         0.1086010651916216,
         -0.13710212427677054,
         0.15831189671532606,
         -0.15430334996209205,
         0.0005076811950630936,
         -0.001683788037143515,
         0.004124421526004047,
         -0.008585668058148876,
         0.01606231415508086,
         -0.027820744203732796,
         0.04543108504242554,
         -0.07079923254047894,
         0.10619884881071828,
         -0.15430334996209208,
         0.21821789023599233},
        {0.06009967640704196,
         -0.1015869944464377,
         0.12911481660011864,
         -0.1394599411179762,
         0.13296983655438352,
         -0.11282864774504556,
         0.08409750872243334,
         -0.05271090315055374,
         0.024400406806973415,
         -0.11403111845120241,
         0.1320630927803686,
         -0.10080252715103372,
         0.040829690013129444,
         0.02659396731087672,
         -0.08325228617793853,
         0.11652892631777725,
         -0.12082812442501636,
         0.09800745695020109,
         -0.056701421522456476,
         0.14721354090363745,
         -0.08619942318412314,
         -0.008452548863005685,
         0.08018791932289175,
         -0.10445902991252064,
         0.07978190193263027,
         -0.020599598500922068,
         -0.04954926850428348,
         0.10476945862039942,
         -0.12345737815154025,
         0.09450236920409423,
         -0.14094623468993903,
         -0.016062314155080883,
         0.10007142007814362,
         -0.09316994283137531,
         0.029611351643955675,
         0.04523208677946033,
         -0.09307888558806855,
         0.09215161895388381,
         -0.04144805787034208,
         -0.038952747435789595,
         0.11137211017068326,
         -0.12795681279052473,
         0.09227096991223654,
         0.11390175809367623,
         -0.08810572749672728,
         -0.007825539631679939,
         0.0814023696856082,
         -0.09496759938082847,
         0.051182725116209256,
         0.02149117099905703,
         -0.08332438926856144,
         0.09788009178014768,
         -0.04666802604230076,
         -0.055844931456940285,
         0.14508938794293275,
         -0.13507086940257568,
         -0.030587528681296057,
         0.10434052842240163,
         -0.07969462908762094,
         0.004569130755567801,
         0.0668521876645099,
         -0.09535761169699086,
         0.0668521876645099,
         0.004569130755567801,
         -0.07969462908762094,
         0.10434052842240163,
         -0.03058752868129605,
         -0.1350708694025757,
         0.14508938794293272,
         -0.05584493145694028,
         -0.04666802604230076,
         0.09788009178014768,
         -0.08332438926856152,
         0.02149117099905702,
         0.05118272511620926,
         -0.09496759938082847,
         0.08140236968560821,
         -0.007825539631679937,
         -0.08810572749672729,
         0.11390175809367623,
         0.09227096991223657,
         -0.1279568127905248,
         0.11137211017068323,
         -0.038952747435789595,
         -0.04144805787034207,
         0.0921516189538838,
         -0.09307888558806852,
         0.04523208677946033,
         0.02961135164395568,
         -0.09316994283137534,
         0.10007142007814358,
         -0.016062314155080883,
         -0.1409462346899391,
         0.09450236920409426,
         -0.12345737815154022,
         0.1047694586203994,
         -0.04954926850428351,
         -0.02059959850092206,
         0.0797819019326303,
         -0.10445902991252062,
         0.08018791932289177,
         -0.008452548863005682,
         -0.0861994231841231,
         0.14721354090363747,
         -0.05670142152245646,
         0.09800745695020105,
         -0.12082812442501636,
         0.11652892631777731,
         -0.08325228617793853,
         0.026593967310876716,
         0.040829690013129416,
         -0.10080252715103374,
         0.13206309278036849,
         -0.11403111845120241,
         0.02440040680697343,
         -0.05271090315055373,
         0.08409750872243336,
         -0.1128286477450456,
         0.13296983655438344,
         -0.13945994111797624,
         0.12911481660011867,
         -0.10158699444643729,
         0.06009967640704204},
        {0.10619884881071816,
         -0.13710212427677093,
         0.1410769220009913,
         -0.1287850208722328,
         0.10774927898015403,
         -0.08346223261119864,
         0.059768546193418266,
         -0.039127698158400614,
         0.022845653777839193,
         -0.011295193532261525,
         0.004124421526004049,
         -0.15751834837626988,
         0.09498713802919564,
         -0.014870813293634861,
         -0.05151400834889302,
         0.09463727629519558,
         -0.1140311184512028,
         0.11356023776749459,
         -0.09898611662409741,
         0.07650167727900095,
         -0.05178348189643557,
         0.029367503183879932,
         -0.012235011472518414,
         0.1286131928826067,
         0.05250611612542332,
         -0.1113491969795632,
         0.09713574567894045,
         -0.04702564066699723,
         -0.012441815044835955,
         0.06390857365872078,
         -0.09775836114008953,
         0.1106768293120748,
         -0.10421076312408828,
         0.08332438926856033,
         -0.05494414769207548,
         0.026430645598479015,
         -0.14850972306422067,
         0.0441139612200555,
         0.048870479336229816,
         -0.09599068705134711,
         0.09637388493048536,
         -0.062113295220916444,
         0.009760162722789454,
         0.04430983768514281,
         -0.08669316068832283,
         0.1086437757435022,
         -0.10694904163296158,
         0.08410179930220324,
         -0.04764852397446646,
         0.13477037766349995,
         -0.10107778324762508,
         0.027820744203732508,
         0.042496888734536435,
         -0.08661285204608495,
         0.09562967390946979,
         -0.0715711656172983,
         0.024177567373938856,
         0.03223675649858456,
         -0.08190205331021533,
         0.11069289661616227,
         -0.10917648393295551,
         0.07533893145222635,
         -0.10654533863443533,
         0.11912130993616657,
         -0.08499377746907322,
         0.026355451575277137,
         0.03450738623384299,
         -0.07910057517959723,
         0.09535761169699077,
         -0.07910057517959725,
         0.03450738623384299,
         0.026355451575277133,
         -0.0849937774690732,
         0.11912130993616654,
         -0.10654533863443533,
         0.07533893145222637,
         -0.10917648393295551,
         0.11069289661616227,
         -0.08190205331021536,
         0.032236756498584554,
         0.024177567373938856,
         -0.07157116561729833,
         0.09562967390946983,
         -0.08661285204608497,
         0.042496888734536435,
         0.027820744203732508,
         -0.10107778324762508,
         0.1347703776635,
         -0.04764852397446644,
         0.08410179930220325,
         -0.10694904163296155,
         0.10864377574350219,
         -0.08669316068832286,
         0.044309837685142815,
         0.009760162722789454,
         -0.062113295220916444,
         0.09637388493048535,
         -0.09599068705134713,
         0.048870479336229816,
         0.0441139612200555,
         -0.14850972306422067,
         0.026430645598479005,
         -0.05494414769207548,
         0.08332438926856033,
         -0.10421076312408831,
         0.1106768293120748,
         -0.09775836114008947,
         0.06390857365872078,
         -0.012441815044835955,
         -0.047025640666997236,
         0.09713574567894047,
         -0.11134919697956326,
         0.05250611612542332,
         0.1286131928826067,
         -0.012235011472518412,
         0.029367503183879932,
         -0.051783481896435585,
         0.076501677279001,
         -0.09898611662409743,
         0.11356023776749462,
         -0.11403111845120277,
         0.09463727629519555,
         -0.051514008348893,
         -0.014870813293634868,
         0.09498713802919564,
         -0.15751834837626982,
         0.004124421526004049,
         -0.011295193532261532,
         0.02284565377783919,
         -0.03912769815840063,
         0.05976854619341821,
         -0.08346223261119863,
         0.10774927898015403,
         -0.1287850208722328,
         0.14107692200099123,
         -0.13710212427677054,
         0.10619884881071809},
        {0.20851441405707516,
         -0.15399810070180342,
         0.11145564251507066,
         -0.07881104062391006,
         0.05424147816551091,
         -0.03616098544367398,
         0.023204104705092418,
         -0.01420955411639771,
         0.008203889894166753,
         -0.0043851636032556035,
         0.0021065644557677486,
         -0.0008600013378191215,
         0.0002593001597045186,
         -0.1405803892788834,
         0.15028675770882582,
         -0.13650472655798723,
         0.11435107643820447,
         -0.090402463609185,
         0.06793466242321536,
         -0.0485348671456553,
         0.03281555957666709,
         -0.02080065734813804,
         0.012162255556028054,
         -0.006377940620434429,
         0.0028404909326971376,
         -0.000934920021550646,
         0.09203146787097742,
         -0.12347317093715568,
         0.1328639443998169,
         -0.1278483901080495,
         0.11392989240510745,
         -0.09532058680268163,
         0.07518989286620494,
         -0.05581402056854051,
         0.03870006020186039,
         -0.024701657806042304,
         0.014131263966244588,
         -0.006870231009332788,
         0.002473565872758151,
         -0.058205810976179134,
         0.09251457600859306,
         -0.11435107643820427,
         0.12403115681897879,
         -0.12305834841250156,
         0.11367643293118153,
         -0.09844667873000153,
         0.07993850061814935,
         -0.060506457425640627,
         0.04213128911535494,
         -0.026310981619533658,
         0.013992601618711246,
         -0.005531061438310828,
         0.035329587287177014,
         -0.06450270634844853,
         0.08986911108647629,
         -0.10852726221660655,
         0.11888565924062691,
         -0.12057206488010479,
         0.11422164676861356,
         -0.10124666855043886,
         0.0836016850603436,
         -0.06354705786845467,
         0.043410904886642586,
         -0.025346507714510642,
         0.01106212287662164,
         -0.020397546730609995,
         0.04197780485613378,
         -0.06511635732996383,
         0.08682180977328498,
         -0.10441847117291617,
         0.11584189289830986,
         -0.11979667378348775,
         0.11584189289830986,
         -0.10441847117291614,
         0.08682180977328498,
         -0.06511635732996383,
         0.04197780485613378,
         -0.020397546730609995,
         0.011062122876621639,
         -0.025346507714510642,
         0.043410904886642586,
         -0.06354705786845467,
         0.08360168506034356,
         -0.10124666855043883,
         0.11422164676861353,
         -0.12057206488010479,
         0.11888565924062691,
         -0.10852726221660654,
         0.08986911108647629,
         -0.06450270634844853,
         0.03532958728717701,
         -0.005531061438310831,
         0.01399260161871125,
         -0.026310981619533658,
         0.04213128911535494,
         -0.0605064574256406,
         0.07993850061814933,
         -0.09844667873000154,
         0.1136764329311815,
         -0.12305834841250153,
         0.12403115681897874,
         -0.11435107643820425,
         0.09251457600859306,
         -0.058205810976179134,
         0.0024735658727581505,
         -0.006870231009332788,
         0.014131263966244588,
         -0.024701657806042304,
         0.03870006020186039,
         -0.055814020568540484,
         0.07518989286620492,
         -0.09532058680268157,
         0.11392989240510745,
         -0.1278483901080495,
         0.13286394439981694,
         -0.12347317093715571,
         0.09203146787097743,
         -0.000934920021550646,
         0.0028404909326971363,
         -0.006377940620434427,
         0.012162255556028059,
         -0.02080065734813804,
         0.0328155595766671,
         -0.04853486714565528,
         0.06793466242321532,
         -0.09040246360918501,
         0.11435107643820447,
         -0.13650472655798723,
         0.1502867577088259,
         -0.1405803892788834,
         0.0002593001597045186,
         -0.0008600013378191215,
         0.0021065644557677486,
         -0.0043851636032556035,
         0.008203889894166752,
         -0.01420955411639771,
         0.02320410470509241,
         -0.03616098544367397,
         0.05424147816551088,
         -0.07881104062391012,
         0.1114556425150706,
         -0.15399810070180342,
         0.20851441405707513},
        {0.04543108504242545,
         -0.08031157077540452,
         0.10774927898015371,
         -0.12441815044836006,
         0.12911481660011875,
         -0.12248907003938785,
         0.1066130509632497,
         -0.08452548863005512,
         0.05976854619341822,
         -0.03591642632671806,
         0.01606231415508088,
         -0.09529704794893284,
         0.12211584951084117,
         -0.11128297681493107,
         0.07360677045181895,
         -0.021824387319616452,
         -0.03162654189033235,
         0.07628608935759211,
         -0.10476945862039949,
         0.11340284304491327,
         -0.10246234135702821,
         0.0760207456341352,
         -0.04126483221471975,
         0.1347703776634998,
         -0.10107778324762512,
         0.027820744203732477,
         0.0424968887345366,
         -0.08661285204608532,
         0.0956296739094693,
         -0.07157116561729826,
         0.024177567373938447,
         0.03223675649858447,
         -0.08190205331021519,
         0.11069289661616241,
         -0.10917648393295563,
         0.07533893145222628,
         -0.14027345645865905,
         0.013754944071573388,
         0.07533893145222668,
         -0.09814236060242501,
         0.06736555159139981,
         -0.009129796236960221,
         -0.04925711225171132,
         0.0859646839962253,
         -0.08840652520072631,
         0.05506020429168042,
         0.00430382722000426,
         -0.06992891524445943,
         0.11508211871897253,
         -0.11089590441845486,
         0.09918831228239357,
         0.0927821703332647,
         -0.09966403833196655,
         0.03075698997074548,
         0.04372448809533671,
         -0.08593424677388921,
         0.08367704274007058,
         -0.043690089153582835,
         -0.015077362259820154,
         0.06818853341511794,
         -0.09245295993866212,
         0.07268427539581755,
         -0.008530454186035373,
         -0.07841524602010483,
         0.13581919019483396,
         -0.13581919019483427,
         0.08423148603968787,
         -0.0934464436691145,
         0.04910487146913739,
         0.015196552749072396,
         -0.0681267684265231,
         0.08828399357537935,
         -0.06812676842652308,
         0.015196552749072396,
         0.0491048714691374,
         -0.09344644366911452,
         0.08423148603968787,
         -0.13581919019483427,
         0.135819190194834,
         -0.07841524602010483,
         -0.008530454186035376,
         0.07268427539581755,
         -0.09245295993866214,
         0.06818853341511795,
         -0.015077362259820157,
         -0.04369008915358284,
         0.08367704274007058,
         -0.08593424677388922,
         0.04372448809533671,
         0.030756989970745486,
         -0.09966403833196655,
         0.09278217033326472,
         0.09918831228239361,
         -0.11089590441845489,
         0.11508211871897255,
         -0.06992891524445943,
         0.004303827220004259,
         0.05506020429168042,
         -0.08840652520072635,
         0.0859646839962253,
         -0.04925711225171131,
         -0.009129796236960227,
         0.06736555159139981,
         -0.09814236060242505,
         0.07533893145222668,
         0.01375494407157339,
         -0.14027345645865905,
         0.07533893145222628,
         -0.10917648393295563,
         0.11069289661616241,
         -0.0819020533102152,
         0.03223675649858447,
         0.024177567373938447,
         -0.07157116561729826,
         0.09562967390946925,
         -0.08661285204608528,
         0.0424968887345366,
         0.02782074420373247,
         -0.10107778324762512,
         0.1347703776634998,
         -0.04126483221471978,
         0.0760207456341352,
         -0.10246234135702821,
         0.11340284304491327,
         -0.1047694586203995,
         0.0762860893575921,
         -0.03162654189033236,
         -0.021824387319616445,
         0.07360677045181895,
         -0.11128297681493106,
         0.12211584951084117,
         -0.09529704794893279,
         0.016062314155080876,
         -0.03591642632671807,
         0.05976854619341823,
         -0.08452548863005512,
         0.10661305096324969,
         -0.12248907003938787,
         0.12911481660011878,
         -0.12441815044836009,
         0.1077492789801537,
         -0.08031157077540443,
         0.04543108504242545},
        {0.09203146787097723,
         -0.12347317093715593,
         0.13286394439981689,
         -0.12784839010804946,
         0.11392989240510762,
         -0.09532058680268161,
         0.0751898928662048,
         -0.05581402056854049,
         0.038700060201860384,
         -0.024701657806042308,
         0.014131263966244586,
         -0.006870231009332793,
         0.0024735658727581484,
         -0.14839628298601534,
         0.10412172002259143,
         -0.03800424013344971,
         -0.02287021528764088,
         0.06863866736536225,
         -0.09667271939940614,
         0.10802999837637263,
         -0.10568153304956393,
         0.0934588425722696,
         -0.07536674115330455,
         0.05511394243215719,
         -0.035790185751984005,
         0.019651120384100332,
         -0.007977010249428516,
         0.13087322008912056,
         0.03128468336924704,
         -0.09753923997762931,
         0.10158221421941817,
         -0.069946070553274,
         0.02273904541681254,
         0.025619765587772847,
         -0.06566529313073659,
         0.09215132710147751,
         -0.10331524099765521,
         0.100142469182892,
         -0.08563034607077265,
         0.06404998550339273,
         -0.040200353001526044,
         0.018613023915333166,
         -0.14336442963229917,
         0.062156363104652675,
         0.021896564076610444,
         -0.07628091845509896,
         0.09488248385497297,
         -0.08246362048564403,
         0.048534867145655226,
         -0.004070269222488043,
         -0.04050962336990095,
         0.07664151273914481,
         -0.09844818126247215,
         0.10320450388799629,
         -0.0914888230838054,
         0.06701796436031522,
         -0.0360439658233229,
         0.12306332036654152,
         -0.10741847254329069,
         0.052371100889135096,
         0.009996797457466426,
         -0.05991274072431762,
         0.08687347405026015,
         -0.08778250653852905,
         0.06528310883815551,
         -0.026141777410322555,
         -0.020351346112441656,
         0.06397469739462751,
         -0.0951621223473311,
         0.10657978897745461,
         -0.09466574985967442,
         0.060925422145741315,
         -0.09172598329214057,
         0.11296853544125325,
         -0.09647259257132891,
         0.055242971158265534,
         -0.0038673507841820434,
         -0.04397701489658042,
         0.07736188867977663,
         -0.08929116868608192,
         0.07736188867977661,
         -0.04397701489658042,
         -0.0038673507841820425,
         0.055242971158265534,
         -0.09647259257132892,
         0.11296853544125325,
         -0.0917259832921406,
         0.060925422145741315,
         -0.09466574985967442,
         0.10657978897745464,
         -0.0951621223473311,
         0.06397469739462752,
         -0.02035134611244166,
         -0.026141777410322555,
         0.06528310883815548,
         -0.08778250653852905,
         0.08687347405026015,
         -0.059912740724317605,
         0.009996797457466422,
         0.052371100889135096,
         -0.10741847254329066,
         0.12306332036654152,
         -0.03604396582332291,
         0.06701796436031522,
         -0.09148882308380536,
         0.10320450388799626,
         -0.09844818126247214,
         0.07664151273914481,
         -0.040509623369900966,
         -0.004070269222488041,
         0.048534867145655226,
         -0.08246362048564403,
         0.09488248385497296,
         -0.07628091845509895,
         0.021896564076610447,
         0.062156363104652675,
         -0.14336442963229915,
         0.018613023915333177,
         -0.040200353001526044,
         0.06404998550339276,
         -0.08563034607077265,
         0.10014246918289206,
         -0.10331524099765522,
         0.0921513271014775,
         -0.06566529313073662,
         0.025619765587772833,
         0.022739045416812532,
         -0.06994607055327398,
         0.10158221421941817,
         -0.09753923997762927,
         0.03128468336924702,
         0.13087322008912053,
         -0.007977010249428517,
         0.019651120384100326,
         -0.035790185751983984,
         0.05511394243215718,
         -0.07536674115330455,
         0.09345884257226962,
         -0.10568153304956387,
         0.10802999837637266,
         -0.09667271939940619,
         0.06863866736536227,
         -0.022870215287640886,
         -0.038004240133449725,
         0.10412172002259139,
         -0.1483962829860154,
         0.002473565872758149,
         -0.006870231009332794,
         0.014131263966244582,
         -0.024701657806042308,
         0.038700060201860384,
         -0.055814020568540464,
         0.0751898928662048,
         -0.09532058680268161,
         0.11392989240510762,
         -0.1278483901080494,
         0.1328639443998168,
         -0.12347317093715576,
         0.0920314678709772},
        {0.19999999999999993,
         -0.15275252316519428,
         0.1148407845545367,
         -0.08481554037632515,
         0.061384981404485235,
         -0.04340573661412157,
         0.029873876758562956,
         -0.01991591783904201,
         0.01277982436499098,
         -0.007826012174154013,
         0.004518350235429099,
         -0.0024151597906321553,
         0.001160205235254625,
         -0.00047365180387992374,
         0.00014281139224951882,
         -0.1290994448735807,
         0.14244246232238397,
         -0.1341051442835814,
         0.11705656662142602,
         -0.09705817768262719,
         0.07713401811504483,
         -0.058912079444714875,
         0.04320369174702119,
         -0.030310014817714993,
         0.02020667654514327,
         -0.012665204790798874,
         0.007337782193312189,
         -0.003818702925826511,
         0.001689767180967374,
         -0.0005531061438310826,
         0.08075728530872497,
         -0.11158222477337247,
         0.12415723806063804,
         -0.12415723806063757,
         0.11570102717256715,
         -0.10203871477778013,
         0.08572966806188383,
         -0.06873665266487698,
         0.05249848564244772,
         -0.03799561437239665,
         0.025812936931247397,
         -0.016201384405132992,
         0.00913881332186118,
         -0.0043901439155968934,
         0.0015644204200756006,
         -0.04869847535576735,
         0.07952427724875451,
         -0.10137396037394057,
         0.1139344955400928,
         -0.11782415888942953,
         0.11430622408251186,
         -0.10499697128489568,
         0.09164887021983592,
         -0.07599122874479333,
         0.059612424343322146,
         -0.04387355637185684,
         0.029847239324145593,
         -0.01827762664372239,
         0.009558766658308059,
         -0.0037240654873736227,
         0.02811607785577672,
         -0.052600365198088896,
         0.07536058523767088,
         -0.09399116347537956,
         0.10692368192314175,
         -0.11340969083593073,
         0.11340969083593073,
         -0.10746782631228284,
         0.09658316614313169,
         -0.0820799081414005,
         0.06547711553283672,
         -0.04835805465577748,
         0.032238703103851685,
         -0.018433183717932674,
         0.007899935879113994,
         -0.015399810070180351,
         0.0323801016030075,
         -0.051481080441621155,
         0.0706314596587654,
         -0.08784676878121829,
         0.10143671120655029,
         -0.11012175251466601,
         0.11310662266161904,
         -0.11012175251466601,
         0.10143671120655029,
         -0.08784676878121828,
         0.07063145965876542,
         -0.05148108044162116,
         0.03238010160300749,
         -0.015399810070180351,
         0.007899935879113992,
         -0.01843318371793267,
         0.03223870310385169,
         -0.04835805465577748,
         0.06547711553283672,
         -0.08207990814140048,
         0.09658316614313169,
         -0.10746782631228284,
         0.11340969083593073,
         -0.11340969083593073,
         0.10692368192314176,
         -0.09399116347537953,
         0.07536058523767088,
         -0.05260036519808891,
         0.02811607785577672,
         -0.0037240654873736236,
         0.009558766658308057,
         -0.018277626643722386,
         0.0298472393241456,
         -0.04387355637185685,
         0.05961242434332213,
         -0.07599122874479328,
         0.09164887021983592,
         -0.10499697128489566,
         0.11430622408251191,
         -0.11782415888942945,
         0.11393449554009275,
         -0.1013739603739406,
         0.0795242772487545,
         -0.04869847535576735,
         0.0015644204200756008,
         -0.004390143915596893,
         0.00913881332186118,
         -0.016201384405132992,
         0.025812936931247397,
         -0.037995614372396645,
         0.05249848564244772,
         -0.068736652664877,
         0.08572966806188383,
         -0.10203871477778013,
         0.11570102717256715,
         -0.1241572380606376,
         0.12415723806063804,
         -0.11158222477337247,
         0.0807572853087249,
         -0.0005531061438310827,
         0.001689767180967373,
         -0.0038187029258265103,
         0.007337782193312189,
         -0.012665204790798872,
         0.020206676545143278,
         -0.030310014817714986,
         0.04320369174702121,
         -0.05891207944471485,
         0.07713401811504488,
         -0.09705817768262716,
         0.11705656662142597,
         -0.1341051442835814,
         0.142442462322384,
         -0.1290994448735807,
         0.0001428113922495188,
         -0.00047365180387992395,
         0.0011602052352546251,
         -0.0024151597906321553,
         0.0045183502354291,
         -0.007826012174154011,
         0.01277982436499098,
         -0.019915917839042032,
         0.02987387675856295,
         -0.04340573661412157,
         0.06138498140448521,
         -0.08481554037632515,
         0.11484078455453661,
         -0.1527525231651946,
         0.1999999999999997},
        {0.03532958728717693,
         -0.06450270634844868,
         0.08986911108647641,
         -0.1085272622166065,
         0.11888565924062702,
         -0.12057206488010469,
         0.1142216467686135,
         -0.10124666855043898,
         0.08360168506034371,
         -0.06354705786845466,
         0.04341090488664257,
         -0.02534650771451065,
         0.011062122876621644,
         -0.08056385440746827,
         0.11059910230759593,
         -0.11194081294969045,
         0.09024278883583448,
         -0.053167283122383426,
         0.008986911108647709,
         0.0345373796217161,
         -0.07093838210974905,
         0.09556468601619399,
         -0.10589546774310203,
         0.10167529258952736,
         -0.08487611570154012,
         0.059468556879522766,
         -0.03089482784856253,
         0.12306332036654141,
         -0.10741847254329072,
         0.05237110088913517,
         0.00999679745746659,
         -0.05991274072431823,
         0.08687347405026052,
         -0.0877825065385285,
         0.06528310883815494,
         -0.02614177741032219,
         -0.020351346112441316,
         0.06397469739462736,
         -0.09516212234733082,
         0.10657978897745461,
         -0.09466574985967456,
         0.06092542214574129,
         -0.13758897493821062,
         0.035525320570495636,
         0.050765382368689285,
         -0.0898702457903116,
         0.08354771593571675,
         -0.046044217834183644,
         -0.004569621242472952,
         0.05115237062597525,
         -0.0803620518174731,
         0.08437222379203242,
         -0.061742665910337134,
         0.017572632358392615,
         0.03704022080094386,
         -0.08629992112956071,
         0.11192714746554605,
         -0.09633155069390267,
         0.10400748880880112,
         0.07354440063088752,
         -0.10132163832639073,
         0.056005012889679136,
         0.009255236019477081,
         -0.06140889866729302,
         0.08407511953748013,
         -0.07411146043826614,
         0.03818250981576568,
         0.010672335937450922,
         -0.056472693597265505,
         0.08373434791085385,
         -0.08091400442626469,
         0.043873556371857234,
         0.02059655189904185,
         -0.09102475948045602,
         0.12612760653351004,
         -0.13427309067911394,
         0.023027645074179478,
         0.06189683644670984,
         -0.09138813321861232,
         0.07270769080103558,
         -0.025684681044277055,
         -0.027477457712141922,
         0.06777843629006344,
         -0.08266755870175564,
         0.06777843629006344,
         -0.027477457712141922,
         -0.025684681044277055,
         0.07270769080103552,
         -0.09138813321861233,
         0.06189683644670984,
         0.02302764507417948,
         -0.13427309067911394,
         0.12612760653351002,
         -0.09102475948045602,
         0.020596551899041853,
         0.04387355637185722,
         -0.08091400442626469,
         0.08373434791085382,
         -0.056472693597265505,
         0.010672335937450922,
         0.03818250981576569,
         -0.07411146043826614,
         0.08407511953748013,
         -0.06140889866729305,
         0.009255236019477081,
         0.056005012889679136,
         -0.10132163832639071,
         0.07354440063088755,
         0.10400748880880113,
         -0.09633155069390266,
         0.11192714746554604,
         -0.08629992112956071,
         0.03704022080094385,
         0.01757263235839261,
         -0.061742665910337134,
         0.08437222379203244,
         -0.08036205181747309,
         0.05115237062597525,
         -0.00456962124247295,
         -0.04604421783418362,
         0.08354771593571673,
         -0.08987024579031164,
         0.0507653823686893,
         0.03552532057049562,
         -0.1375889749382106,
         0.06092542214574129,
         -0.0946657498596745,
         0.1065797889774546,
         -0.09516212234733078,
         0.06397469739462736,
         -0.020351346112441323,
         -0.026141777410322177,
         0.06528310883815495,
         -0.08778250653852852,
         0.08687347405026055,
         -0.05991274072431824,
         0.009996797457466585,
         0.05237110088913518,
         -0.10741847254329076,
         0.12306332036654144,
         -0.030894827848562536,
         0.059468556879522766,
         -0.08487611570154018,
         0.1016752925895274,
         -0.105895467743102,
         0.095564686016194,
         -0.07093838210974908,
         0.03453737962171609,
         0.008986911108647709,
         -0.05316728312238341,
         0.09024278883583446,
         -0.1119408129496905,
         0.11059910230759591,
         -0.08056385440746824,
         0.011062122876621639,
         -0.025346507714510642,
         0.04341090488664257,
         -0.06354705786845465,
         0.0836016850603437,
         -0.10124666855043896,
         0.11422164676861349,
         -0.12057206488010475,
         0.11888565924062702,
         -0.10852726221660652,
         0.08986911108647642,
         -0.06450270634844855,
         0.035329587287176945},
        {0.08075728530872492,
         -0.11158222477337276,
         0.124157238060638,
         -0.12415723806063755,
         0.11570102717256738,
         -0.1020387147777802,
         0.08572966806188387,
         -0.06873665266487691,
         0.05249848564244775,
         -0.037995614372396756,
         0.025812936931247314,
         -0.016201384405132992,
         0.009138813321861184,
         -0.004390143915596897,
         0.0015644204200755995,
         -0.13987572123604733,
         0.1088931012960935,
         -0.05444655064804768,
         0.04503656374612369,
         -0.07713401811504472,
         0.09584868273743259,
         -0.10246655193630477,
         0.09921281229815108,
         -0.08873863701503758,
         0.07376661161823292,
         -0.05683821646559075,
         0.04013355864360304,
         -0.02534650771451075,
         0.013604612300169763,
         -0.005419311303938374,
         0.13187609467915776,
         0.014058038927888697,
         -0.08316847989130695,
         0.09940534656094384,
         -0.08222513958757081,
         0.04699558173768971,
         -0.00540046146837793,
         -0.034155517312101646,
         0.06614187486543445,
         -0.08749747607074627,
         0.09722561406138627,
         -0.09598901763357778,
         0.0857046849146064,
         -0.06913826797888536,
         0.04949707705985326,
         -0.030017582216943173,
         0.01351813744773902,
         -0.1377400886300364,
         0.0743881498489148,
         -0.055860982310605,
         0.0849217590032645,
         -0.08792822152823104,
         0.06999798085659728,
         -0.03818702925826466,
         0.037594946433102225,
         -0.06883449848332676,
         0.08960319530063578,
         -0.09769802392025735,
         0.09293719495320553,
         -0.0771181518147404,
         0.05380787590712593,
         -0.02786835427932282,
         0.11246431142310682,
         -0.10889310129609366,
         0.06841545159580936,
         -0.015578883647402333,
         -0.03337022803474741,
         0.06838861674417954,
         -0.08453059267212557,
         0.08100692202566499,
         -0.06028603244005217,
         0.027209224600339796,
         0.01188856592406265,
         -0.05005534205212135,
         0.08059675775962885,
         -0.09794821133097864,
         0.09853986065216847,
         -0.08163267075084446,
         0.04996358149456986,
         -0.07952427724875458,
         0.10490369244690675,
         -0.10006585446877785,
         0.07265998878159675,
         -0.03223870310385185,
         -0.011398102790696255,
         0.04949604693306616,
         -0.07523463544253393,
         0.08430469899226571,
         -0.07523463544253393,
         0.04949604693306616,
         -0.011398102790696255,
         -0.03223870310385185,
         0.07265998878159674,
         -0.10006585446877785,
         0.10490369244690674,
         -0.0795242772487546,
         0.049963581494569864,
         -0.08163267075084445,
         0.09853986065216847,
         -0.09794821133097865,
         0.08059675775962888,
         -0.050055342052121365,
         0.01188856592406265,
         0.027209224600339796,
         -0.06028603244005217,
         0.08100692202566499,
         -0.08453059267212557,
         0.06838861674417954,
         -0.033370228034747415,
         -0.015578883647402337,
         0.06841545159580938,
         -0.1088931012960936,
         0.11246431142310685,
         -0.027868354279322813,
         0.053807875907125935,
         -0.0771181518147404,
         0.09293719495320553,
         -0.09769802392025735,
         0.08960319530063576,
         -0.0688344984833268,
         0.03759494643310224,
         -0.038187029258264636,
         0.0699979808565973,
         -0.08792822152823104,
         0.08492175900326453,
         -0.055860982310604976,
         0.07438814984891481,
         -0.13774008863003637,
         0.01351813744773902,
         -0.030017582216943173,
         0.049497077059853234,
         -0.06913826797888536,
         0.08570468491460637,
         -0.09598901763357776,
         0.09722561406138631,
         -0.0874974760707463,
         0.06614187486543444,
         -0.03415551731210163,
         -0.005400461468377929,
         0.04699558173768972,
         -0.08222513958757077,
         0.09940534656094385,
         -0.083168479891307,
         0.014058038927888697,
         0.1318760946791578,
         -0.00541931130393837,
         0.013604612300169768,
         -0.02534650771451075,
         0.040133558643603066,
         -0.05683821646559075,
         0.073766611618233,
         -0.0887386370150376,
         0.0992128122981511,
         -0.10246655193630479,
         0.09584868273743256,
         -0.07713401811504475,
         0.045036563746123706,
         -0.05444655064804769,
         0.10889310129609352,
         -0.13987572123604727,
         0.0015644204200755993,
         -0.004390143915596898,
         0.009138813321861186,
         -0.016201384405132992,
         0.02581293693124731,
         -0.03799561437239671,
         0.05249848564244775,
         -0.06873665266487694,
         0.08572966806188385,
         -0.1020387147777802,
         0.11570102717256735,
         -0.1241572380606375,
         0.124157238060638,
         -0.1115822247733726,
         0.08075728530872489},
        {0.028116077855776713,
         -0.05260036519808886,
         0.07536058523767097,
         -0.09399116347537952,
         0.10692368192314192,
         -0.1134096908359307,
         0.1134096908359307,
         -0.10746782631228279,
         0.09658316614313148,
         -0.08207990814140063,
         0.0654771155328369,
         -0.04835805465577748,
         0.03223870310385172,
         -0.018433183717932664,
         0.007899935879113992,
         -0.06887004431501814,
         0.09940534656094278,
         -0.1079336720100257,
         0.0972900971953142,
         -0.07208793164664583,
         0.037803230278643615,
         -0.03622739685948266,
         0.06664871656761527,
         -0.0881679646197709,
         0.09899209386613214,
         -0.09871046571689628,
         0.08828932457345652,
         -0.06997758220226463,
         0.04710611638290243,
         -0.023699807637341985,
         0.11246431142310681,
         -0.10889310129609357,
         0.06841545159580929,
         -0.015578883647402456,
         -0.033370228034747124,
         0.06838861674417994,
         -0.08453059267212595,
         0.0810069220256654,
         -0.06028603244005163,
         0.02720922460034021,
         0.0118885659240623,
         -0.05005534205212103,
         0.08059675775962927,
         -0.09794821133097859,
         0.09853986065216835,
         -0.08163267075084447,
         0.0499635814945698,
         -0.13385930513224523,
         0.05133270023393411,
         0.028846487225566937,
         -0.07601716843978858,
         0.08638220284845607,
         -0.06701796436031512,
         0.029429774857819457,
         0.013943931552574486,
         -0.05188595547760969,
         0.07578428862078722,
         -0.08049293996670907,
         0.06478665213634256,
         -0.03146175271081451,
         -0.01290581002272546,
         0.058570084256388974,
         -0.09365930702206382,
         0.10577045316041461,
         -0.08410123967377728,
         0.10732621239353389,
         0.05656588063376025,
         -0.09756970353778402,
         0.07121775381670145,
         -0.018118054254843502,
         -0.034156512504983194,
         0.06917881720514574,
         -0.07977801580242376,
         0.066149950303455,
         -0.033967331211606666,
         -0.007510459517242094,
         0.04732825806429306,
         -0.07472734887884258,
         0.08104048437503635,
         -0.061593264545702874,
         0.01762185774437505,
         0.041759760962596114,
         -0.09740034096688158,
         0.11679392715865751,
         -0.13144722819486515,
         0.04020808309543447,
         0.04081936903222279,
         -0.08159875687014831,
         0.0817615933808844,
         -0.0523866759380707,
         0.008460897061448687,
         0.03524371548874843,
         -0.06667756258349507,
         0.07805098483231428,
         -0.06667756258349507,
         0.03524371548874843,
         0.008460897061448687,
         -0.052386675938070705,
         0.08176159338088441,
         -0.08159875687014831,
         0.0408193690322228,
         0.040208083095434485,
         -0.13144722819486512,
         0.1167939271586575,
         -0.09740034096688158,
         0.04175976096259613,
         0.017621857744375063,
         -0.061593264545702874,
         0.08104048437503636,
         -0.07472734887884261,
         0.04732825806429305,
         -0.007510459517242096,
         -0.033967331211606666,
         0.06614995030345501,
         -0.07977801580242376,
         0.06917881720514574,
         -0.03415651250498319,
         -0.018118054254843502,
         0.07121775381670145,
         -0.09756970353778402,
         0.056565880633760224,
         0.10732621239353393,
         -0.08410123967377728,
         0.10577045316041465,
         -0.0936593070220638,
         0.058570084256388974,
         -0.01290581002272546,
         -0.031461752710814514,
         0.06478665213634258,
         -0.08049293996670905,
         0.07578428862078725,
         -0.05188595547760969,
         0.013943931552574488,
         0.029429774857819453,
         -0.06701796436031514,
         0.08638220284845612,
         -0.0760171684397886,
         0.028846487225566923,
         0.05133270023393411,
         -0.13385930513224523,
         0.049963581494569795,
         -0.08163267075084446,
         0.09853986065216834,
         -0.09794821133097856,
         0.08059675775962925,
         -0.05005534205212103,
         0.011888565924062308,
         0.027209224600340202,
         -0.060286032440051644,
         0.08100692202566534,
         -0.08453059267212598,
         0.06838861674417994,
         -0.033370228034747124,
         -0.01557888364740245,
         0.06841545159580932,
         -0.10889310129609357,
         0.11246431142310685,
         -0.02369980763734198,
         0.04710611638290238,
         -0.06997758220226463,
         0.08828932457345655,
         -0.09871046571689629,
         0.09899209386613216,
         -0.08816796461977087,
         0.0666487165676153,
         -0.03622739685948264,
         0.037803230278643615,
         -0.07208793164664583,
         0.0972900971953142,
         -0.10793367201002571,
         0.09940534656094278,
         -0.06887004431501816,
         0.00789993587911399,
         -0.018433183717932664,
         0.03223870310385172,
         -0.04835805465577748,
         0.06547711553283693,
         -0.08207990814140066,
         0.09658316614313142,
         -0.10746782631228279,
         0.11340969083593075,
         -0.11340969083593075,
         0.10692368192314196,
         -0.0939911634753795,
         0.07536058523767093,
         -0.052600365198088854,
         0.028116077855776713},
        {0.07161148740394324,
         -0.10127393670836626,
         0.11566298639324861,
         -0.11911637100282924,
         0.11478340719169713,
         -0.10520073039617785,
         0.09242887466920871,
         -0.07811665668645071,
         0.06354705786845438,
         -0.04967702028610168,
         0.03717487798128224,
         -0.026456749946173707,
         0.01772242770746124,
         -0.010990983084856886,
         0.006136161730329624,
         -0.0029213973215408426,
         0.001032869928300871,
         -0.1320450583547048,
         0.11094003924504595,
         -0.06610690305098432,
         0.018008702557141865,
         0.024659431554869424,
         -0.058076320691250224,
         0.08101019496649661,
         -0.09373998802374091,
         0.09743882206496339,
         -0.09377827268452565,
         0.08465523979320312,
         -0.07199507418974833,
         0.057606653220494304,
         -0.043075680527136846,
         0.029688075399779502,
         -0.01837846169452954,
         0.009700182960703555,
         -0.0038090360890283247,
         0.13204505835470468,
         -0.06939779183594888,
         0.09370583990850537,
         -0.08753229869069558,
         0.06277266458155446,
         -0.028846487225567333,
         -0.0070659174574352794,
         0.039786751525913634,
         -0.06590401479674929,
         0.08353477693833267,
         -0.0920884356683677,
         0.09202994824699064,
         -0.08464300761434349,
         0.07179309224485665,
         -0.055690189346334136,
         0.03865051325631696,
         -0.02285421653417003,
         0.010077762226439017,
         -0.13204505835470495,
         0.08259989391589087,
         -0.017436851272654166,
         -0.03690685769237058,
         0.07146982260169718,
         -0.08480610625948425,
         0.07931472674684395,
         -0.059365580946195734,
         0.030165336116619753,
         0.002995637036216116,
         -0.03526718584790866,
         0.0626080973932323,
         -0.08203889894166808,
         0.09180034282827325,
         -0.09142880978191162,
         0.08175246753773416,
         -0.06480466610394554,
         0.04363799050697722,
         -0.0219639735610396,
         0.10302016773904547,
         -0.10760105589705488,
         0.07852393205347283,
         -0.034873702545306834,
         -0.010120017180008514,
         0.04752099733072796,
         -0.0719769416937576,
         0.08115105787059611,
         -0.07518989286620466,
         0.05620313266151081,
         -0.027748073437371946,
         -0.005683821646559048,
         0.039179284532391404,
         -0.06791486505650508,
         0.08766769289178979,
         -0.09532443806172036,
         0.08938473307446324,
         -0.07044142621506132,
         0.04150800846093474,
         -0.06945618292060451,
         0.0964558953020624,
         -0.09925229743774594,
         0.0822932268976475,
         -0.05184965889710795,
         0.014879401432546438,
         0.021901885881058153,
         -0.05268172698716289,
         0.07301001098570263,
         -0.08010178834280156,
         0.07301001098570263,
         -0.052681726987162884,
         0.02190188588105815,
         0.014879401432546438,
         -0.05184965889710795,
         0.08229322689764751,
         -0.09925229743774597,
         0.09645589530206242,
         -0.0694561829206045,
         0.04150800846093475,
         -0.07044142621506132,
         0.08938473307446324,
         -0.09532443806172036,
         0.08766769289178979,
         -0.0679148650565051,
         0.039179284532391404,
         -0.005683821646559048,
         -0.027748073437371946,
         0.05620313266151081,
         -0.07518989286620466,
         0.08115105787059611,
         -0.0719769416937576,
         0.047520997330727954,
         -0.010120017180008514,
         -0.034873702545306834,
         0.07852393205347284,
         -0.10760105589705488,
         0.10302016773904547,
         -0.0219639735610396,
         0.04363799050697721,
         -0.06480466610394554,
         0.08175246753773416,
         -0.09142880978191162,
         0.09180034282827326,
         -0.0820388989416681,
         0.06260809739323228,
         -0.03526718584790868,
         0.002995637036216116,
         0.030165336116619746,
         -0.05936558094619575,
         0.07931472674684394,
         -0.08480610625948425,
         0.0714698226016972,
         -0.03690685769237058,
         -0.017436851272654166,
         0.08259989391589087,
         -0.13204505835470495,
         0.010077762226439019,
         -0.022854216534170028,
         0.03865051325631696,
         -0.05569018934633416,
         0.07179309224485665,
         -0.0846430076143435,
         0.09202994824699064,
         -0.0920884356683677,
         0.08353477693833268,
         -0.0659040147967493,
         0.03978675152591364,
         -0.0070659174574352794,
         -0.02884648722556734,
         0.06277266458155444,
         -0.0875322986906956,
         0.09370583990850535,
         -0.06939779183594888,
         0.1320450583547047,
         -0.0038090360890283255,
         0.009700182960703557,
         -0.018378461694529544,
         0.02968807539977951,
         -0.04307568052713684,
         0.057606653220494304,
         -0.07199507418974833,
         0.08465523979320314,
         -0.09377827268452565,
         0.09743882206496342,
         -0.09373998802374091,
         0.08101019496649661,
         -0.05807632069125021,
         0.024659431554869417,
         0.018008702557141865,
         -0.06610690305098432,
         0.1109400392450459,
         -0.13204505835470476,
         0.001032869928300871,
         -0.002921397321540843,
         0.006136161730329625,
         -0.010990983084856886,
         0.017722427707461238,
         -0.026456749946173697,
         0.03717487798128223,
         -0.04967702028610169,
         0.06354705786845438,
         -0.07811665668645072,
         0.09242887466920871,
         -0.10520073039617783,
         0.11478340719169716,
         -0.11911637100282924,
         0.11566298639324861,
         -0.10127393670836662,
         0.07161148740394321},
        {0.022809048515134087,
         -0.043495148910935866,
         0.0636703784926348,
         -0.08137197260571806,
         0.09518855140951332,
         -0.10427383364646128,
         0.10828582195709809,
         -0.10731462904792415,
         0.10180759621425182,
         -0.092493578124574,
         0.08030691489721395,
         -0.06631125254318927,
         0.051623240090901024,
         -0.037336021623672166,
         0.02444216360556943,
         -0.013754373772675002,
         0.00581228375755129,
         -0.05947872157609835,
         0.08919157275656055,
         -0.1018726055882157,
         0.0987746280566592,
         -0.0826468069700719,
         0.057113130845707794,
         -0.02611952302159452,
         -0.0064713156194209495,
         0.037174877981282384,
         -0.06309829027638272,
         0.08208992949643946,
         -0.09283575356046515,
         0.09490817215125263,
         -0.08876980636543544,
         0.07573127407171745,
         -0.05785792792273483,
         0.03781112838413351,
         -0.018562945705857287,
         0.10302016773904556,
         -0.10760105589705492,
         0.07852393205347265,
         -0.03487370254530688,
         -0.01012001718000815,
         0.047520997330727476,
         -0.07197694169375721,
         0.0811510578705964,
         -0.07518989286620512,
         0.056203132661511224,
         -0.02774807343737221,
         -0.0056838216465587114,
         0.03917928453239173,
         -0.06791486505650517,
         0.08766769289178969,
         -0.09532443806172018,
         0.08938473307446303,
         -0.07044142621506125,
         0.04150800846093475,
         -0.12963086832060247,
         0.06276728260661539,
         0.010167344096841497,
         -0.06048685956800386,
         0.08165553750313836,
         -0.07642958310293889,
         0.051864906554809784,
         -0.016659424835059812,
         -0.02048733827278563,
         0.05195796932972273,
         -0.07194311993890336,
         0.07690681874636551,
         -0.06584085333649321,
         0.040331748336310876,
         -0.004446071570488051,
         -0.03557598191146063,
         0.07184722215478914,
         -0.09563449700715032,
         0.09851778105506694,
         -0.07386404240389627,
         0.10955807990530915,
         0.04178381221571662,
         -0.09099360475287856,
         0.079378494766406,
         -0.038370407868263665,
         -0.009369315315294745,
         0.04884521290360843,
         -0.07162296619473693,
         0.0747246195613263,
         -0.05952373085696661,
         0.030640410006183238,
         0.005163828840491113,
         -0.040091539154291735,
         0.06641540524019336,
         -0.07758545032685166,
         0.06933862755272556,
         -0.0408138451374907,
         -0.0043190409541871795,
         0.056687888606482044,
         -0.09988241553456084,
         0.1081258865553539,
         -0.12793627429597035,
         0.05297065000933543,
         0.022186963781161435,
         -0.0685739850823938,
         0.08175952377611953,
         -0.06732622663881617,
         0.03507287480528855,
         0.004116262424984705,
         -0.04020156092667801,
         0.06523660842094414,
         -0.07415984567549265,
         0.06523660842094414,
         -0.040201560926678065,
         0.004116262424984704,
         0.03507287480528855,
         -0.06732622663881614,
         0.08175952377611957,
         -0.0685739850823938,
         0.022186963781161435,
         0.05297065000933542,
         -0.12793627429597032,
         0.1081258865553539,
         -0.09988241553456084,
         0.056687888606482044,
         -0.004319040954187179,
         -0.04081384513749073,
         0.06933862755272556,
         -0.07758545032685167,
         0.06641540524019332,
         -0.040091539154291735,
         0.005163828840491113,
         0.03064041000618329,
         -0.05952373085696661,
         0.07472461956132635,
         -0.07162296619473695,
         0.04884521290360843,
         -0.009369315315294745,
         -0.03837040786826366,
         0.079378494766406,
         -0.09099360475287856,
         0.041783812215716636,
         0.10955807990530916,
         -0.07386404240389628,
         0.09851778105506692,
         -0.09563449700715032,
         0.07184722215478914,
         -0.03557598191146063,
         -0.004446071570488051,
         0.040331748336310876,
         -0.06584085333649321,
         0.07690681874636551,
         -0.07194311993890334,
         0.05195796932972274,
         -0.020487338272785635,
         -0.016659424835059812,
         0.051864906554809784,
         -0.07642958310293889,
         0.08165553750313836,
         -0.06048685956800386,
         0.010167344096841497,
         0.0627672826066154,
         -0.12963086832060247,
         0.04150800846093476,
         -0.07044142621506125,
         0.08938473307446303,
         -0.09532443806172015,
         0.0876676928917897,
         -0.06791486505650518,
         0.03917928453239173,
         -0.005683821646558712,
         -0.027748073437372213,
         0.05620313266151124,
         -0.0751898928662051,
         0.08115105787059641,
         -0.07197694169375723,
         0.04752099733072747,
         -0.010120017180008151,
         -0.034873702545306876,
         0.07852393205347265,
         -0.10760105589705489,
         0.10302016773904557,
         -0.018562945705857287,
         0.037811128384133516,
         -0.057857927922734836,
         0.07573127407171745,
         -0.08876980636543548,
         0.09490817215125263,
         -0.09283575356046515,
         0.08208992949643946,
         -0.06309829027638271,
         0.037174877981282384,
         -0.006471315619420949,
         -0.026119523021594516,
         0.05711313084570779,
         -0.0826468069700719,
         0.09877462805665921,
         -0.10187260558821573,
         0.08919157275656055,
         -0.05947872157609834,
         0.005812283757551289,
         -0.013754373772675006,
         0.02444216360556943,
         -0.03733602162367216,
         0.051623240090901044,
         -0.06631125254318929,
         0.08030691489721394,
         -0.09249357812457404,
         0.10180759621425182,
         -0.10731462904792416,
         0.1082858219570981,
         -0.10427383364646128,
         0.09518855140951334,
         -0.08137197260571809,
         0.0636703784926348,
         -0.043495148910935984,
         0.02280904851513408},
        {0.018806097925581508,
         -0.03641785203646153,
         0.054229487123435456,
         -0.07064355410890953,
         0.08443519693603072,
         -0.09477827349582374,
         0.10121107640351336,
         -0.1035928393619927,
         0.10205804578387873,
         -0.09697006311368464,
         0.08887453087262072,
         -0.07845264385715758,
         0.06647438010221665,
         -0.05375168497164225,
         0.041091592921256116,
         -0.02924921020805794,
         0.018880284004254674,
         -0.010492131229211448,
         0.004384194184960734,
         -0.05184483412855958,
         0.0801192744802152,
         -0.09508750196339713,
         0.09710047647643555,
         -0.08774763062417346,
         0.06942195962070921,
         -0.044913443152956964,
         0.017107794369616004,
         0.011236221034765476,
         -0.03765251912599382,
         0.060090150323197165,
         -0.07700091358426554,
         0.08739728897453143,
         -0.09088364920319737,
         0.08766206489867966,
         -0.0785125471595587,
         0.06474588681295727,
         -0.048124576670273415,
         0.030740560411731677,
         -0.014802743280434762,
         0.09465528380775269,
         -0.10476420129075359,
         0.08454260414174693,
         -0.04906666373411064,
         0.009120043619356364,
         0.027576419843291,
         -0.05587829932977545,
         0.0728539852021142,
         -0.07745265920798824,
         0.07018267144924603,
         -0.05279396641457401,
         0.027962291695710198,
         0.0010257219536430634,
         -0.030587000610729245,
         0.05715614092736441,
         -0.07749919129942491,
         0.08902686758419763,
         -0.09010636606042072,
         0.08036868015576279,
         -0.0609969987422854,
         0.03489040051253013,
         -0.12521717061677612,
         0.07099146285581423,
         -0.005405197605101483,
         -0.045180862620775634,
         0.07299387082611983,
         -0.07818808654772451,
         0.0648462621076818,
         -0.03889618274188961,
         0.006834080516426774,
         0.025126540165224323,
         -0.05164385257586003,
         0.06865444455609188,
         -0.0736403597478713,
         0.06577952446484665,
         -0.04599101597604245,
         0.016878323495328213,
         0.017433686402626786,
         -0.051580880784422384,
         0.07938558061774498,
         -0.09446803281565304,
         0.09110458704865047,
         -0.06527396240260475,
         0.11099315873061072,
         0.028982143348415444,
         -0.08308019060963544,
         0.08273446937162149,
         -0.05261099448718212,
         0.011286445876239148,
         0.028073686644178877,
         -0.05703694671263463,
         0.07122573762085369,
         -0.06963912307207995,
         0.05397458930381048,
         -0.027949746925361754,
         -0.0033760642569411565,
         0.03428033217972335,
         -0.05905621061911414,
         0.07269187050829333,
         -0.07155084498640638,
         0.05405444311147415,
         -0.02136888219448383,
         -0.02189544802757402,
         0.06694792544885013,
         -0.09993858992820087,
         0.10021504575351603,
         -0.1240941239795353,
         0.062413845846568235,
         0.006223628120270543,
         -0.05470322817122591,
         0.07650539715017438,
         -0.07376665378712918,
         0.052671914129640764,
         -0.021010542071049076,
         -0.013330039578698804,
         0.043360745693756204,
         -0.06366159095029295,
         0.07081692129341906,
         -0.06366159095029296,
         0.043360745693756204,
         -0.013330039578698804,
         -0.021010542071049076,
         0.052671914129640694,
         -0.07376665378712918,
         0.07650539715017439,
         -0.05470322817122591,
         0.006223628120270543,
         0.062413845846568235,
         -0.1240941239795353,
         0.10021504575351603,
         -0.09993858992820089,
         0.06694792544885012,
         -0.021895448027574014,
         -0.021368882194483827,
         0.05405444311147415,
         -0.07155084498640638,
         0.07269187050829333,
         -0.05905621061911414,
         0.03428033217972335,
         -0.003376064256941156,
         -0.02794974692536175,
         0.05397458930381048,
         -0.06963912307207995,
         0.07122573762085369,
         -0.05703694671263465,
         0.028073686644178877,
         0.011286445876239145,
         -0.05261099448718213,
         0.08273446937162149,
         -0.08308019060963545,
         0.02898214334841544,
         0.1109931587306107,
         -0.06527396240260475,
         0.09110458704865047,
         -0.09446803281565305,
         0.07938558061774496,
         -0.05158088078442239,
         0.017433686402626786,
         0.016878323495328213,
         -0.04599101597604246,
         0.06577952446484665,
         -0.0736403597478713,
         0.06865444455609189,
         -0.051643852575860044,
         0.025126540165224323,
         0.006834080516426772,
         -0.03889618274188961,
         0.0648462621076818,
         -0.07818808654772452,
         0.07299387082611983,
         -0.04518086262077563,
         -0.005405197605101483,
         0.07099146285581423,
         -0.12521717061677615,
         0.034890400512530124,
         -0.06099699874228538,
         0.08036868015576278,
         -0.09010636606042072,
         0.08902686758419763,
         -0.07749919129942491,
         0.057156140927364416,
         -0.03058700061072925,
         0.0010257219536430634,
         0.027962291695710205,
         -0.05279396641457401,
         0.07018267144924603,
         -0.07745265920798824,
         0.0728539852021142,
         -0.05587829932977544,
         0.027576419843291004,
         0.009120043619356364,
         -0.04906666373411064,
         0.08454260414174693,
         -0.10476420129075359,
         0.09465528380775272,
         -0.014802743280434762,
         0.030740560411731677,
         -0.048124576670273415,
         0.06474588681295726,
         -0.07851254715955869,
         0.08766206489867967,
         -0.09088364920319739,
         0.08739728897453147,
         -0.07700091358426554,
         0.06009015032319716,
         -0.03765251912599382,
         0.011236221034765476,
         0.017107794369616,
         -0.04491344315295694,
         0.06942195962070921,
         -0.08774763062417347,
         0.09710047647643555,
         -0.09508750196339714,
         0.0801192744802152,
         -0.05184483412855957,
         0.0043841941849607335,
         -0.01049213122921145,
         0.018880284004254677,
         -0.029249210208057944,
         0.041091592921256116,
         -0.05375168497164224,
         0.06647438010221667,
         -0.0784526438571576,
         0.0888745308726207,
         -0.09697006311368461,
         0.10205804578387875,
         -0.1035928393619927,
         0.10121107640351337,
         -0.09477827349582374,
         0.08443519693603073,
         -0.07064355410890952,
         0.05422948712343545,
         -0.03641785203646146,
         0.018806097925581505},
        {0.0511827251162098,
         -0.0957541107531441,
         0.1291148166001187,
         -0.141438195120055,
         0.1291148166001187,
         -0.09575411075314348,
         0.05118272511620988,
         -0.09575411075314348,
         0.12795681279052512,
         -0.1060786463400412,
         0.04082969001312944,
         0.04082969001312944,
         -0.10607864634004119,
         0.12795681279052512,
         -0.09575411075314348,
         0.1291148166001187,
         -0.10607864634004119,
         0.01861190004225793,
         0.06881842847817161,
         -0.10445902991252073,
         0.06881842847817161,
         0.018611900042257937,
         -0.1060786463400412,
         0.1291148166001187,
         -0.141438195120055,
         0.04082969001312945,
         0.06881842847817136,
         -0.10003896272713751,
         0.04523208677946075,
         0.04523208677946075,
         -0.10003896272713748,
         0.06881842847817138,
         0.04082969001312945,
         -0.141438195120055,
         0.1291148166001187,
         0.04082969001312945,
         -0.10445902991252051,
         0.04523208677946075,
         0.05118272511620927,
         -0.09535761169698995,
         0.05118272511620927,
         0.04523208677946075,
         -0.10445902991252051,
         0.04082969001312945,
         0.1291148166001187,
         -0.09575411075314351,
         -0.10607864634004124,
         0.06881842847817138,
         0.04523208677946075,
         -0.09535761169698993,
         0.04652975010564567,
         0.04652975010564571,
         -0.09535761169698993,
         0.04523208677946075,
         0.06881842847817138,
         -0.10607864634004124,
         -0.09575411075314351,
         0.05118272511620989,
         0.1279568127905251,
         0.01861190004225794,
         -0.10003896272713744,
         0.05118272511620923,
         0.0465297501056457,
         -0.09305950021129189,
         0.0465297501056457,
         0.05118272511620923,
         -0.10003896272713744,
         0.018611900042257944,
         0.1279568127905251,
         0.051182725116209894,
         -0.09575411075314354,
         -0.10607864634004122,
         0.06881842847817136,
         0.04523208677946075,
         -0.09535761169698993,
         0.04652975010564567,
         0.046529750105645695,
         -0.09535761169698993,
         0.04523208677946075,
         0.06881842847817136,
         -0.10607864634004127,
         -0.09575411075314352,
         0.1291148166001187,
         0.04082969001312944,
         -0.1044590299125205,
         0.04523208677946076,
         0.05118272511620926,
         -0.09535761169698992,
         0.05118272511620928,
         0.04523208677946076,
         -0.1044590299125205,
         0.04082969001312944,
         0.1291148166001187,
         -0.141438195120055,
         0.04082969001312944,
         0.06881842847817136,
         -0.10003896272713757,
         0.04523208677946075,
         0.04523208677946075,
         -0.10003896272713758,
         0.06881842847817138,
         0.04082969001312944,
         -0.14143819512005504,
         0.1291148166001187,
         -0.1060786463400413,
         0.018611900042257944,
         0.06881842847817164,
         -0.10445902991252072,
         0.06881842847817164,
         0.018611900042257944,
         -0.1060786463400413,
         0.1291148166001187,
         -0.09575411075314358,
         0.1279568127905252,
         -0.1060786463400413,
         0.040829690013129465,
         0.040829690013129465,
         -0.10607864634004131,
         0.12795681279052523,
         -0.09575411075314359,
         0.05118272511620985,
         -0.09575411075314358,
         0.12911481660011873,
         -0.1414381951200551,
         0.12911481660011875,
         -0.09575411075314358,
         0.051182725116209846},
        {0.0697502970338575,
         -0.11028490305013816,
         0.13049085706320465,
         -0.13049085706320504,
         0.11444805263353104,
         -0.08865108037110714,
         0.05976854619341823,
         -0.03350695887416416,
         0.01367915867902046,
         -0.12081105830566204,
         0.12081105830566206,
         -0.06975029703385752,
         0.06268578008992362,
         -0.10236545023241993,
         0.11340284304491326,
         -0.0989861166240973,
         0.06839579339510247,
         -0.03350695887416416,
         0.141076922000991,
         -0.051514008348893074,
         -0.04702564066699714,
         0.09637388493048521,
         -0.08661285204608532,
         0.034507386233842634,
         0.0322367564985844,
         -0.0866931606883228,
         0.11067682931207476,
         -0.0989861166240973,
         0.05976854619341823,
         -0.12081105830566204,
         -0.051514008348893074,
         0.10302801669778601,
         -0.05564148840746556,
         -0.024400406806973116,
         0.08165938002625922,
         -0.08840652520072609,
         0.045725140442621534,
         0.0236276377183084,
         -0.08669316068832279,
         0.11340284304491326,
         -0.08865108037110714,
         0.0697502970338575,
         0.12081105830566206,
         -0.04702564066699714,
         -0.05564148840746554,
         0.0925930336136547,
         -0.05670142152245647,
         -0.015077362259820764,
         0.07507847949045451,
         -0.08829275147367822,
         0.04572514044262153,
         0.0322367564985844,
         -0.10236545023241993,
         0.11444805263353104,
         -0.11028490305013819,
         -0.06975029703385752,
         0.0963738849304852,
         -0.024400406806973116,
         -0.05670142152245651,
         0.08828399357538083,
         -0.056987072809021405,
         -0.012435598799109063,
         0.07507847949045453,
         -0.08840652520072612,
         0.034507386233842634,
         0.06268578008992362,
         -0.13049085706320504,
         0.1304908570632047,
         -0.08661285204608532,
         0.0816593800262592,
         -0.015077362259820764,
         -0.056987072809021405,
         0.08704919159376671,
         -0.056987072809021405,
         -0.015077362259820764,
         0.08165938002625922,
         -0.08661285204608532,
         0.1304908570632047,
         -0.13049085706320504,
         0.06268578008992362,
         0.03450738623384264,
         -0.0884065252007261,
         0.07507847949045453,
         -0.012435598799109064,
         -0.05698707280902139,
         0.08828399357538083,
         -0.05670142152245647,
         -0.024400406806973116,
         0.09637388493048518,
         -0.0697502970338575,
         -0.11028490305013822,
         0.11444805263353101,
         -0.10236545023241989,
         0.0322367564985844,
         0.045725140442621534,
         -0.08829275147367822,
         0.07507847949045453,
         -0.015077362259820757,
         -0.056701421522456524,
         0.09259303361365467,
         -0.05564148840746554,
         -0.047025640666997166,
         0.12081105830566212,
         0.0697502970338575,
         -0.08865108037110718,
         0.11340284304491328,
         -0.08669316068832278,
         0.0236276377183084,
         0.045725140442621534,
         -0.0884065252007261,
         0.0816593800262592,
         -0.024400406806973116,
         -0.05564148840746553,
         0.10302801669778601,
         -0.05151400834889307,
         -0.12081105830566204,
         0.05976854619341827,
         -0.09898611662409733,
         0.11067682931207472,
         -0.0866931606883228,
         0.0322367564985844,
         0.03450738623384264,
         -0.08661285204608532,
         0.0963738849304852,
         -0.04702564066699717,
         -0.05151400834889307,
         0.14107692200099106,
         -0.03350695887416416,
         0.06839579339510245,
         -0.09898611662409731,
         0.11340284304491331,
         -0.10236545023241982,
         0.06268578008992363,
         -0.06975029703385752,
         0.12081105830566218,
         -0.12081105830566206,
         0.013679158679020456,
         -0.03350695887416416,
         0.05976854619341826,
         -0.08865108037110721,
         0.11444805263353104,
         -0.13049085706320496,
         0.13049085706320462,
         -0.11028490305013819,
         0.06975029703385752},
        {0.11145564251507037,
         -0.13650472655798696,
         0.13286394439981675,
         -0.11435107643820411,
         0.08986911108647638,
         -0.06511635732996375,
         0.043410904886642475,
         -0.026310981619533595,
         0.014131263966244555,
         -0.006377940620434424,
         0.002106564455767745,
         -0.150911653367635,
         0.07194430788361933,
         0.012784839010805231,
         -0.07307144138023572,
         0.10408029770032858,
         -0.11021949734918934,
         0.09907138270052242,
         -0.07848503699018546,
         0.05511394243215729,
         -0.0337580194749177,
         0.01720360972210331,
         -0.006377940620434425,
         0.11145564251507034,
         0.07194430788361933,
         -0.10948282038305412,
         0.07344330862347236,
         -0.011875079174487147,
         -0.046183219562736834,
         0.08604312310415801,
         -0.1032688183620779,
         0.10014246918289195,
         -0.08269215848170886,
         0.05828161660957422,
         -0.0337580194749177,
         0.014131263966244555,
         -0.13650472655798707,
         0.01278483901080523,
         0.07344330862347236,
         -0.09756373104039319,
         0.07271971158160861,
         -0.021815913474482404,
         -0.03332435828380803,
         0.07664151273914462,
         -0.09942225482024819,
         0.10006181164896805,
         -0.08269215848170886,
         0.05511394243215729,
         -0.02631098161953359,
         0.13286394439981675,
         -0.07307144138023572,
         -0.011875079174487147,
         0.07271971158160861,
         -0.09198396775536376,
         0.07198884165939984,
         -0.026141777410322187,
         -0.027946735585923428,
         0.07372975595187121,
         -0.09942225482024816,
         0.10014246918289196,
         -0.07848503699018547,
         0.04341090488664248,
         -0.11435107643820419,
         0.10408029770032855,
         -0.04618321956273684,
         -0.021815913474482404,
         0.07198884165939984,
         -0.08929116868608206,
         0.0715922059045617,
         -0.027385337924980997,
         -0.027946735585923435,
         0.07664151273914462,
         -0.10326881836207792,
         0.09907138270052242,
         -0.06511635732996374,
         0.08986911108647638,
         -0.11021949734918934,
         0.08604312310415801,
         -0.033324358283808045,
         -0.026141777410322187,
         0.0715922059045617,
         -0.08847570714224537,
         0.0715922059045617,
         -0.026141777410322187,
         -0.03332435828380805,
         0.08604312310415801,
         -0.11021949734918932,
         0.08986911108647638,
         -0.06511635732996374,
         0.09907138270052242,
         -0.10326881836207791,
         0.07664151273914463,
         -0.027946735585923428,
         -0.027385337924980997,
         0.0715922059045617,
         -0.08929116868608208,
         0.07198884165939987,
         -0.021815913474482404,
         -0.04618321956273686,
         0.10408029770032852,
         -0.11435107643820419,
         0.043410904886642475,
         -0.07848503699018546,
         0.10014246918289196,
         -0.09942225482024819,
         0.07372975595187119,
         -0.027946735585923428,
         -0.026141777410322187,
         0.07198884165939987,
         -0.09198396775536377,
         0.0727197115816086,
         -0.011875079174487147,
         -0.07307144138023573,
         0.13286394439981677,
         -0.02631098161953358,
         0.05511394243215729,
         -0.08269215848170887,
         0.10006181164896805,
         -0.0994222548202482,
         0.07664151273914463,
         -0.033324358283808066,
         -0.02181591347448241,
         0.0727197115816086,
         -0.09756373104039319,
         0.07344330862347236,
         0.012784839010805222,
         -0.13650472655798696,
         0.014131263966244551,
         -0.03375801947491769,
         0.05828161660957422,
         -0.0826921584817089,
         0.10014246918289192,
         -0.10326881836207782,
         0.08604312310415801,
         -0.04618321956273684,
         -0.011875079174487152,
         0.07344330862347236,
         -0.10948282038305412,
         0.07194430788361932,
         0.1114556425150704,
         -0.006377940620434425,
         0.01720360972210332,
         -0.03375801947491768,
         0.05511394243215729,
         -0.07848503699018547,
         0.09907138270052239,
         -0.1102194973491894,
         0.10408029770032848,
         -0.07307144138023573,
         0.01278483901080522,
         0.07194430788361932,
         -0.1509116533676349,
         0.002106564455767745,
         -0.006377940620434426,
         0.014131263966244551,
         -0.0263109816195336,
         0.04341090488664247,
         -0.06511635732996376,
         0.08986911108647638,
         -0.11435107643820411,
         0.13286394439981677,
         -0.13650472655798698,
         0.1114556425150704},
        {0.19999999999999996,
         -0.14142135623730956,
         0.0978019293843654,
         -0.06593804733957864,
         0.043166584730171605,
         -0.027300945311597418,
         0.016571045299983204,
         -0.009567297464698817,
         0.005188595547760938,
         -0.002594297773880473,
         0.0011602052352546216,
         -0.0004385163603255607,
         0.00012162255556028091,
         -0.14142135623730961,
         0.14446302370292313,
         -0.12510864843424466,
         0.09968895725584559,
         -0.07476671794188398,
         0.05314557775992662,
         -0.03579754923025387,
         0.022735286586236313,
         -0.013480366662971444,
         0.007337782193312184,
         -0.003562523752346038,
         0.001459470666723368,
         -0.0004385163603255606,
         0.0978019293843654,
         -0.12510864843424466,
         0.12805278414759436,
         -0.11689566404829538,
         0.09853453834474822,
         -0.07772509203178947,
         0.05759107332751959,
         -0.039989229940569505,
         0.025812936931247383,
         -0.015253815388634557,
         0.008027088666978538,
         -0.003562523752346038,
         0.0011602052352546214,
         -0.06593804733957864,
         0.09968895725584559,
         -0.11689566404829538,
         0.11993242076616976,
         -0.11218650701835503,
         0.09734668131427052,
         -0.0788598249310415,
         0.059612424343322104,
         -0.041774293881872857,
         0.026756962223261786,
         -0.015253815388634557,
         0.007337782193312182,
         -0.0025942977738804725,
         0.043166584730171605,
         -0.07476671794188398,
         0.09853453834474825,
         -0.11218650701835506,
         0.11543896335436787,
         -0.10951501647855437,
         0.09658316614313144,
         -0.07926114978717315,
         0.06020316500233896,
         -0.04177429388187288,
         0.02581293693124738,
         -0.013480366662971446,
         0.005188595547760938,
         -0.027300945311597408,
         0.05314557775992663,
         -0.07772509203178947,
         0.09734668131427053,
         -0.1095150164785544,
         0.11310662266161897,
         -0.10829134660300158,
         0.09632506400374245,
         -0.07926114978717314,
         0.05961242434332209,
         -0.039989229940569505,
         0.022735286586236317,
         -0.009567297464698815,
         0.016571045299983204,
         -0.035797549230253856,
         0.05759107332751959,
         -0.07885982493104152,
         0.09658316614313144,
         -0.10829134660300158,
         0.11237924133769937,
         -0.10829134660300155,
         0.09658316614313144,
         -0.0788598249310415,
         0.05759107332751959,
         -0.03579754923025386,
         0.016571045299983204,
         -0.009567297464698817,
         0.02273528658623631,
         -0.039989229940569505,
         0.05961242434332209,
         -0.07926114978717314,
         0.09632506400374247,
         -0.10829134660300155,
         0.11310662266161897,
         -0.1095150164785544,
         0.09734668131427056,
         -0.07772509203178946,
         0.05314557775992663,
         -0.027300945311597404,
         0.005188595547760938,
         -0.013480366662971444,
         0.025812936931247376,
         -0.04177429388187289,
         0.060203165002338944,
         -0.07926114978717314,
         0.09658316614313148,
         -0.10951501647855438,
         0.11543896335436785,
         -0.11218650701835511,
         0.09853453834474826,
         -0.07476671794188398,
         0.043166584730171605,
         -0.0025942977738804733,
         0.007337782193312181,
         -0.015253815388634554,
         0.026756962223261783,
         -0.04177429388187289,
         0.059612424343322076,
         -0.07885982493104152,
         0.09734668131427059,
         -0.11218650701835511,
         0.11993242076616979,
         -0.11689566404829538,
         0.09968895725584555,
         -0.06593804733957864,
         0.0011602052352546216,
         -0.003562523752346038,
         0.008027088666978542,
         -0.01525381538863455,
         0.025812936931247383,
         -0.039989229940569505,
         0.057591073327519574,
         -0.07772509203178947,
         0.09853453834474828,
         -0.11689566404829538,
         0.12805278414759427,
         -0.1251086484342446,
         0.09780192938436531,
         -0.0004385163603255606,
         0.0014594706667233673,
         -0.003562523752346038,
         0.007337782193312179,
         -0.013480366662971446,
         0.022735286586236327,
         -0.03579754923025389,
         0.05314557775992664,
         -0.07476671794188398,
         0.09968895725584552,
         -0.1251086484342446,
         0.14446302370292316,
         -0.14142135623730961,
         0.00012162255556028096,
         -0.0004385163603255606,
         0.0011602052352546216,
         -0.0025942977738804733,
         0.005188595547760937,
         -0.009567297464698815,
         0.0165710452999832,
         -0.027300945311597408,
         0.043166584730171605,
         -0.06593804733957864,
         0.09780192938436527,
         -0.14142135623730961,
         0.20000000000000007},
        {0.03369259441587495,
         -0.06738518883174993,
         0.09889442034075313,
         -0.12112043412158173,
         0.12911481660011886,
         -0.12112043412158173,
         0.09889442034075312,
         -0.06738518883175007,
         0.03369259441587494,
         -0.0714727859616996,
         0.10917648393295544,
         -0.11444805263353115,
         0.08564508030762916,
         -0.03162654189033223,
         -0.03162654189033223,
         0.08564508030762916,
         -0.11444805263353115,
         0.10917648393295543,
         -0.07147278596169962,
         0.10774927898015375,
         -0.11403111845120259,
         0.06390857365872078,
         0.009760162722789432,
         -0.07157116561729855,
         0.09535761169699049,
         -0.07157116561729854,
         0.009760162722789432,
         0.06390857365872077,
         -0.11403111845120259,
         0.10774927898015375,
         -0.13049085706320487,
         0.07360677045181911,
         0.020414845006564406,
         -0.08334325574014734,
         0.08596468399622514,
         -0.03553768365441673,
         -0.03553768365441673,
         0.08596468399622516,
         -0.08334325574014732,
         0.020414845006564406,
         0.07360677045181911,
         -0.13049085706320487,
         0.13049085706320462,
         -0.08661285204608529,
         0.0816593800262589,
         -0.01507736225982126,
         -0.0569870728090214,
         0.08704919159376578,
         -0.056987072809021384,
         -0.01507736225982126,
         0.08165938002625892,
         -0.08661285204608526,
         0.13049085706320462,
         -0.10520509234399421,
         -0.07719943213509672,
         0.0908403255911861,
         -0.009129796236959923,
         -0.0681267684265236,
         0.0842850173358694,
         -0.03678499732307545,
         -0.03678499732307545,
         0.0842850173358694,
         -0.06812676842652363,
         -0.009129796236959923,
         0.09084032559118607,
         -0.07719943213509674,
         -0.10520509234399421,
         0.060740188384924405,
         0.12148037676984938,
         -0.02336161091727879,
         -0.07475715493529164,
         0.08367704274007018,
         -0.021237828106617007,
         -0.053094570266543586,
         0.08495131242646832,
         -0.053094570266543586,
         -0.021237828106617007,
         0.08367704274007018,
         -0.07475715493529164,
         -0.023361610917278793,
         0.12148037676984941,
         0.060740188384924405,
         -0.10520509234399424,
         -0.07719943213509672,
         0.09084032559118609,
         -0.00912979623695992,
         -0.06812676842652361,
         0.0842850173358694,
         -0.03678499732307546,
         -0.036784997323075455,
         0.0842850173358694,
         -0.06812676842652363,
         -0.009129796236959921,
         0.09084032559118607,
         -0.07719943213509672,
         -0.10520509234399421,
         0.1304908570632046,
         -0.08661285204608529,
         0.0816593800262589,
         -0.01507736225982126,
         -0.056987072809021384,
         0.08704919159376583,
         -0.0569870728090214,
         -0.015077362259821264,
         0.08165938002625892,
         -0.08661285204608529,
         0.13049085706320457,
         -0.13049085706320487,
         0.07360677045181908,
         0.020414845006564403,
         -0.08334325574014734,
         0.08596468399622519,
         -0.03553768365441673,
         -0.03553768365441673,
         0.08596468399622517,
         -0.08334325574014734,
         0.020414845006564403,
         0.07360677045181908,
         -0.13049085706320487,
         0.10774927898015375,
         -0.1140311184512026,
         0.06390857365872075,
         0.009760162722789423,
         -0.07157116561729855,
         0.09535761169699053,
         -0.07157116561729858,
         0.009760162722789423,
         0.06390857365872075,
         -0.1140311184512026,
         0.10774927898015377,
         -0.07147278596169968,
         0.10917648393295544,
         -0.11444805263353106,
         0.08564508030762916,
         -0.031626541890332226,
         -0.031626541890332226,
         0.08564508030762916,
         -0.11444805263353107,
         0.10917648393295543,
         -0.07147278596169966,
         0.03369259441587494,
         -0.06738518883175004,
         0.09889442034075312,
         -0.12112043412158181,
         0.12911481660011892,
         -0.12112043412158181,
         0.09889442034075309,
         -0.06738518883175003,
         0.03369259441587493},
        {0.0542414781655109,
         -0.09040246360918491,
         0.11392989240510755,
         -0.12305834841250156,
         0.118885659240627,
         -0.10441847117291594,
         0.08360168506034367,
         -0.06050645742564065,
         0.03870006020186035,
         -0.020800657348138026,
         0.00820388989416676,
         -0.1038645231208674,
         0.11810128391094858,
         -0.08951177722167256,
         0.03797663080170264,
         0.018344455483280547,
         -0.06563111915333436,
         0.09556468601619393,
         -0.10532822278838763,
         0.09682179075919518,
         -0.07536674115330448,
         0.04810373234882335,
         -0.022216238855871914,
         0.13286394439981633,
         -0.07307144138023562,
         -0.011875079174487088,
         0.07271971158160845,
         -0.09198396775536387,
         0.07198884165939957,
         -0.026141777410321733,
         -0.02794673558592306,
         0.07372975595187105,
         -0.09942225482024801,
         0.10014246918289194,
         -0.07848503699018544,
         0.04341090488664247,
         -0.12368960085073409,
         -0.022870215287640668,
         0.09217192474777214,
         -0.07885982493104096,
         0.02056824047411419,
         0.04215234949613329,
         -0.08036205181747354,
         0.081238040675138,
         -0.047320396518425574,
         -0.007297353333616801,
         0.06250381808025778,
         -0.0984481812624716,
         0.10167529258952737,
         -0.06999798085659713,
         0.07713401811504482,
         0.1068977011957697,
         -0.06994607055327402,
         -0.019248154353244496,
         0.07756769235371538,
         -0.08030691489721367,
         0.038182509815765674,
         0.02143342349212183,
         -0.069057982478457,
         0.08342012976845506,
         -0.05756244213298978,
         0.0007252168048801904,
         0.06397469739462733,
         -0.10601056800554584,
         0.09760752086802052,
         -0.11498460525529376,
         -0.04216248592756396,
         0.09488248385497301,
         -0.057779603744827386,
         -0.012826551483818716,
         0.06777843629006335,
         -0.08069208216640542,
         0.049919602225378945,
         0.006661541718178503,
         -0.06077342787255129,
         0.08461828545024161,
         -0.06174266591033698,
         -0.003867350784181818,
         0.08249341155511036,
         -0.11954431059235548,
         0.1277982436499101,
         -0.029579545671679194,
         -0.05991274072431799,
         0.08772154167723957,
         -0.05647269359726532,
         -0.004356962901720271,
         0.0591590913433582,
         -0.08076690098838078,
         0.0591590913433582,
         -0.004356962901720271,
         -0.05647269359726532,
         0.08772154167723961,
         -0.05991274072431799,
         -0.0295795456716792,
         0.1277982436499101,
         -0.11954431059235548,
         0.08249341155511038,
         -0.003867350784181817,
         -0.061742665910336995,
         0.0846182854502416,
         -0.06077342787255129,
         0.006661541718178448,
         0.04991960222537895,
         -0.08069208216640546,
         0.06777843629006335,
         -0.01282655148381872,
         -0.057779603744827386,
         0.094882483854973,
         -0.04216248592756396,
         -0.11498460525529373,
         0.09760752086802049,
         -0.10601056800554585,
         0.06397469739462733,
         0.0007252168048801905,
         -0.05756244213298978,
         0.08342012976845502,
         -0.06905798247845706,
         0.02143342349212183,
         0.038182509815765674,
         -0.08030691489721367,
         0.0775676923537154,
         -0.0192481543532445,
         -0.06994607055327405,
         0.10689770119576975,
         0.07713401811504482,
         -0.06999798085659713,
         0.10167529258952736,
         -0.09844818126247158,
         0.06250381808025779,
         -0.007297353333616803,
         -0.047320396518425574,
         0.08123804067513801,
         -0.08036205181747351,
         0.0421523494961333,
         0.020568240474114194,
         -0.078859824931041,
         0.09217192474777212,
         -0.022870215287640678,
         -0.12368960085073406,
         0.043410904886642496,
         -0.07848503699018551,
         0.10014246918289195,
         -0.09942225482024798,
         0.07372975595187106,
         -0.02794673558592306,
         -0.026141777410321733,
         0.0719888416593996,
         -0.09198396775536391,
         0.07271971158160846,
         -0.011875079174487086,
         -0.07307144138023562,
         0.13286394439981636,
         -0.022216238855871914,
         0.04810373234882336,
         -0.07536674115330448,
         0.09682179075919518,
         -0.10532822278838758,
         0.09556468601619396,
         -0.06563111915333433,
         0.018344455483280543,
         0.037976630801702646,
         -0.08951177722167254,
         0.11810128391094861,
         -0.1038645231208674,
         0.00820388989416676,
         -0.02080065734813803,
         0.03870006020186037,
         -0.060506457425640606,
         0.08360168506034364,
         -0.10441847117291596,
         0.11888565924062697,
         -0.12305834841250153,
         0.11392989240510759,
         -0.09040246360918489,
         0.05424147816551086},
        {0.0978019293843652,
         -0.12510864843424485,
         0.12805278414759413,
         -0.11689566404829525,
         0.09853453834474828,
         -0.0777250920317894,
         0.0575910733275195,
         -0.039989229940569394,
         0.025812936931247348,
         -0.015253815388634575,
         0.008027088666978504,
         -0.0035625237523460363,
         0.0011602052352546214,
         -0.1439605420980332,
         0.08427009716003807,
         -0.011145564251507168,
         -0.04772245501035485,
         0.08515764918791505,
         -0.10194255765124445,
         0.1021946987370109,
         -0.09111366825519317,
         0.07376661161823289,
         -0.05443464275830639,
         0.036303127454397614,
         -0.021378948290393034,
         0.010562389712157384,
         -0.003818702925826515,
         0.11484078455453654,
         0.0523492880356486,
         -0.1021784181521777,
         0.08589603667957929,
         -0.0396810867483098,
         -0.012526532808040381,
         0.05645859112519731,
         -0.08521521191503234,
         0.09722561406138594,
         -0.09447288560491343,
         0.08098273883499826,
         -0.06157609578784914,
         0.04088498634442505,
         -0.022629442511275306,
         0.009138813321861164,
         -0.13410514428358142,
         0.03318241763650248,
         0.050407710953245664,
         -0.08865980200823516,
         0.08490134266470725,
         -0.05264936337799147,
         0.0073377821933122206,
         0.0375949464331028,
         -0.07250453954955477,
         0.0921127275557967,
         -0.09529847079198923,
         0.08437584962787321,
         -0.06404202147621921,
         0.04013355864360303,
         -0.018277626643722362,
         0.1241572380606378,
         -0.08567663392871554,
         0.01541909600143233,
         0.04632148968405484,
         -0.08086238513640918,
         0.08387783701404444,
         -0.06028603244005246,
         0.02009534414668395,
         0.02496523300703189,
         -0.06407211977304896,
         0.08920166700025049,
         -0.09629676221971667,
         0.08570468491460652,
         -0.061875415149496175,
         0.032238703103851685,
         -0.10137396037394043,
         0.10566581727790988,
         -0.06707306760623011,
         0.010839697814724988,
         0.04153037790314744,
         -0.07523463544253342,
         0.08321996146843944,
         -0.06576665891413686,
         0.029093477918847255,
         0.016662290111758692,
         -0.05981369584695806,
         0.08960319530063497,
         -0.09855931419695876,
         0.08446469899496384,
         -0.05148108044162101,
         0.07536058523767106,
         -0.10190611080391793,
         0.09449021633936161,
         -0.06020884938786156,
         0.011888565924062391,
         0.035947644434590406,
         -0.07047048484647171,
         0.08299757022830163,
         -0.07047048484647171,
         0.035947644434590406,
         0.011888565924062393,
         -0.06020884938786154,
         0.09449021633936161,
         -0.10190611080391793,
         0.07536058523767108,
         -0.051481080441621,
         0.08446469899496382,
         -0.09855931419695876,
         0.08960319530063496,
         -0.05981369584695803,
         0.016662290111758696,
         0.029093477918847255,
         -0.06576665891413686,
         0.08321996146843941,
         -0.07523463544253343,
         0.041530377903147446,
         0.010839697814724984,
         -0.06707306760623014,
         0.10566581727790986,
         -0.10137396037394043,
         0.032238703103851685,
         -0.06187541514949615,
         0.08570468491460655,
         -0.09629676221971663,
         0.08920166700025048,
         -0.06407211977304897,
         0.024965233007031885,
         0.020095344146683965,
         -0.06028603244005248,
         0.08387783701404446,
         -0.08086238513640918,
         0.04632148968405483,
         0.015419096001432334,
         -0.08567663392871551,
         0.12415723806063786,
         -0.01827762664372235,
         0.04013355864360306,
         -0.06404202147621922,
         0.08437584962787321,
         -0.09529847079198925,
         0.09211272755579668,
         -0.07250453954955476,
         0.0375949464331028,
         0.007337782193312217,
         -0.052649363377991476,
         0.08490134266470727,
         -0.08865980200823517,
         0.05040771095324566,
         0.033182417636502475,
         -0.13410514428358133,
         0.009138813321861164,
         -0.022629442511275324,
         0.04088498634442503,
         -0.06157609578784914,
         0.08098273883499826,
         -0.09447288560491346,
         0.09722561406138591,
         -0.08521521191503234,
         0.05645859112519738,
         -0.01252653280804038,
         -0.03968108674830977,
         0.08589603667957925,
         -0.1021784181521777,
         0.0523492880356486,
         0.11484078455453654,
         -0.003818702925826515,
         0.010562389712157392,
         -0.021378948290393038,
         0.036303127454397614,
         -0.054434642758306354,
         0.07376661161823296,
         -0.09111366825519307,
         0.10219469873701092,
         -0.10194255765124438,
         0.085157649187915,
         -0.047722455010354846,
         -0.011145564251507176,
         0.08427009716003805,
         -0.14396054209803325,
         0.0011602052352546212,
         -0.0035625237523460337,
         0.0080270886669785,
         -0.015253815388634578,
         0.025812936931247366,
         -0.0399892299405694,
         0.05759107332751955,
         -0.07772509203178939,
         0.09853453834474826,
         -0.11689566404829528,
         0.12805278414759416,
         -0.12510864843424468,
         0.09780192938436515},
        {0.023204104705092446,
         -0.048534867145654914,
         0.07518989286620487,
         -0.09844667873000142,
         0.11422164676861365,
         -0.11979667378348752,
         0.11422164676861364,
         -0.09844667873000142,
         0.07518989286620484,
         -0.04853486714565532,
         0.02320410470509242,
         -0.054418449200679314,
         0.09042904866007853,
         -0.1074365082797621,
         0.10047672073342073,
         -0.0709383821097495,
         0.025540736667658905,
         0.025540736667658905,
         -0.0709383821097495,
         0.10047672073342075,
         -0.10743650827976212,
         0.09042904866007853,
         -0.05441844920067932,
         0.0898691110864761,
         -0.11021949734918926,
         0.08604312310415767,
         -0.033324358283807975,
         -0.026141777410322187,
         0.07159220590456243,
         -0.08847570714224512,
         0.07159220590456243,
         -0.026141777410322184,
         -0.033324358283807975,
         0.08604312310415767,
         -0.11021949734918926,
         0.08986911108647612,
         -0.11831818268671672,
         0.09024278883583478,
         -0.017403078528819328,
         -0.05090379810712564,
         0.08437222379203234,
         -0.07394011231643222,
         0.02896047322457753,
         0.02896047322457753,
         -0.07394011231643222,
         0.08437222379203234,
         -0.050903798107125656,
         -0.017403078528819328,
         0.09024278883583478,
         -0.11831818268671672,
         0.12779824364990985,
         -0.02957954567167932,
         -0.059912740724317765,
         0.08772154167723918,
         -0.056472693597265186,
         -0.004356962901719777,
         0.05915909134335893,
         -0.08076690098838085,
         0.05915909134335892,
         -0.004356962901719777,
         -0.05647269359726518,
         0.08772154167723918,
         -0.059912740724317765,
         -0.029579545671679315,
         0.12779824364990985,
         -0.11067652555985538,
         -0.05051669136285796,
         0.09392767260827932,
         -0.046044217834183415,
         -0.02747745771214257,
         0.07492836201166224,
         -0.07377362965759902,
         0.03010004682366931,
         0.03010004682366932,
         -0.07377362965759914,
         0.07492836201166228,
         -0.02747745771214252,
         -0.046044217834183415,
         0.09392767260827932,
         -0.05051669136285796,
         -0.11067652555985538,
         0.06831103462420313,
         0.11100543126433007,
         -0.05123327596815258,
         -0.04269439664012711,
         0.08407511953747965,
         -0.061085829038950636,
         0.001313673742773137,
         0.05583113406785992,
         -0.0788204245663884,
         0.055831134067860035,
         0.0013136737427731921,
         -0.061085829038950636,
         0.08407511953747965,
         -0.042694396640127114,
         -0.05123327596815259,
         0.11100543126433009,
         0.06831103462420311,
         -0.11067652555985538,
         -0.05051669136285796,
         0.09392767260827936,
         -0.046044217834183394,
         -0.027477457712142567,
         0.07492836201166227,
         -0.07377362965759904,
         0.03010004682366931,
         0.03010004682366931,
         -0.07377362965759914,
         0.07492836201166228,
         -0.02747745771214252,
         -0.0460442178341834,
         0.09392767260827935,
         -0.05051669136285796,
         -0.11067652555985537,
         0.1277982436499099,
         -0.02957954567167931,
         -0.05991274072431779,
         0.0877215416772392,
         -0.05647269359726516,
         -0.0043569629017197785,
         0.05915909134335893,
         -0.08076690098838085,
         0.05915909134335892,
         -0.0043569629017197785,
         -0.05647269359726516,
         0.0877215416772392,
         -0.05991274072431778,
         -0.029579545671679308,
         0.1277982436499099,
         -0.11831818268671666,
         0.0902427888358348,
         -0.017403078528819334,
         -0.050903798107125676,
         0.0843722237920324,
         -0.07394011231643222,
         0.028960473224577534,
         0.02896047322457753,
         -0.0739401123164322,
         0.08437222379203241,
         -0.05090379810712567,
         -0.017403078528819338,
         0.09024278883583481,
         -0.11831818268671672,
         0.08986911108647606,
         -0.1102194973491892,
         0.08604312310415767,
         -0.03332435828380797,
         -0.026141777410322174,
         0.0715922059045624,
         -0.0884757071422451,
         0.07159220590456239,
         -0.026141777410322174,
         -0.03332435828380797,
         0.08604312310415767,
         -0.11021949734918923,
         0.08986911108647609,
         -0.05441844920067932,
         0.09042904866007849,
         -0.10743650827976207,
         0.10047672073342075,
         -0.07093838210974948,
         0.025540736667658905,
         0.02554073666765891,
         -0.07093838210974948,
         0.10047672073342075,
         -0.10743650827976207,
         0.0904290486600785,
         -0.05441844920067931,
         0.0232041047050924,
         -0.048534867145655324,
         0.0751898928662049,
         -0.09844667873000149,
         0.11422164676861354,
         -0.11979667378348757,
         0.11422164676861354,
         -0.0984466787300015,
         0.07518989286620492,
         -0.04853486714565533,
         0.023204104705092404},
        {0.04316658473017153,
         -0.07476671794188394,
         0.09853453834474833,
         -0.112186507018355,
         0.11543896335436798,
         -0.10951501647855415,
         0.09658316614313138,
         -0.07926114978717297,
         0.0602031650023387,
         -0.04177429388187284,
         0.025812936931247366,
         -0.013480366662971423,
         0.005188595547760939,
         -0.08985841174587227,
         0.11145564251507037,
         -0.09803562608405893,
         0.06193283577302892,
         -0.01570925314744694,
         -0.029806212171660896,
         0.06664871656761581,
         -0.09012551420690461,
         0.09872013756430201,
         -0.09364936778141608,
         0.07818637259205918,
         -0.05683821646559088,
         0.034449825916482484,
         -0.015274811703306045,
         0.12415723806063751,
         -0.08567663392871544,
         0.01541909600143231,
         0.04632148968405478,
         -0.0808623851364091,
         0.08387783701404429,
         -0.060286032440052366,
         0.020095344146683937,
         0.024965233007031854,
         -0.06407211977304889,
         0.08920166700025038,
         -0.09629676221971653,
         0.08570468491460645,
         -0.06187541514949607,
         0.03223870310385164,
         -0.12415723806063766,
         0.07612568693677661,
         -0.08619536702699396,
         0.05019919832851216,
         0.003922209563735393,
         -0.051885955477609096,
         0.07782893321641447,
         -0.07555051792250365,
         0.04766611237375795,
         -0.0034614386137875514,
         -0.0440276094568058,
         0.08130310920032816,
         -0.09769802392025746,
         0.08828932457345663,
         -0.05583907174599959,
         0.08277149204042517,
         0.09254134140073692,
         -0.08222513958757073,
         0.010359393850776059,
         0.05365731452396211,
         -0.08014324344016675,
         0.06614995030345412,
         -0.02445927397770703,
         -0.025439182640552227,
         0.06439011750757957,
         -0.0786342573201663,
         0.06289004514240862,
         -0.021456119843823288,
         -0.03266278681373973,
         0.08059675775962927,
         -0.10237163153433232,
         0.08323997348302885,
         -0.11705656662142597,
         -0.01898908259001579,
         0.0849217590032642,
         -0.07468574845872031,
         0.02227212445972582,
         0.03524371548874881,
         -0.07118447181362773,
         0.07356963923468987,
         -0.04458756536551651,
         -0.00275558529005792,
         0.04961643792592601,
         -0.07706061636236022,
         0.07183826053213477,
         -0.03146175271081493,
         -0.032238703103852136,
         0.09212976800243619,
         -0.10853164706791321,
         0.1230633203665417,
         -0.05024039015844689,
         -0.03337022803474706,
         0.07829399325221208,
         -0.07472734887884264,
         0.0353987932051896,
         0.01703728997676381,
         -0.05959505222453795,
         0.07576606905359988,
         -0.05959505222453795,
         0.01703728997676381,
         0.035398793205189606,
         -0.07472734887884262,
         0.07829399325221208,
         -0.033370228034747075,
         -0.05024039015844689,
         0.1230633203665417,
         -0.10853164706791321,
         0.09212976800243619,
         -0.032238703103852136,
         -0.03146175271081493,
         0.07183826053213475,
         -0.07706061636236022,
         0.04961643792592601,
         -0.002755585290057864,
         -0.04458756536551651,
         0.07356963923468987,
         -0.07118447181362773,
         0.03524371548874881,
         0.02227212445972582,
         -0.07468574845872031,
         0.08492175900326421,
         -0.018989082590015787,
         -0.11705656662142597,
         0.08323997348302886,
         -0.10237163153433232,
         0.08059675775962927,
         -0.03266278681373973,
         -0.021456119843823285,
         0.06289004514240862,
         -0.07863425732016631,
         0.06439011750757957,
         -0.025439182640552224,
         -0.02445927397770703,
         0.06614995030345412,
         -0.08014324344016675,
         0.053657314523962094,
         0.010359393850776059,
         -0.08222513958757074,
         0.09254134140073692,
         0.08277149204042517,
         -0.05583907174599959,
         0.08828932457345665,
         -0.09769802392025746,
         0.08130310920032816,
         -0.0440276094568058,
         -0.003461438613787551,
         0.047666112373757945,
         -0.07555051792250367,
         0.07782893321641447,
         -0.051885955477609096,
         0.003922209563735393,
         0.050199198328512155,
         -0.08619536702699394,
         0.07612568693677663,
         -0.12415723806063766,
         0.03223870310385164,
         -0.06187541514949607,
         0.08570468491460645,
         -0.09629676221971654,
         0.08920166700025038,
         -0.0640721197730489,
         0.024965233007031858,
         0.02009534414668394,
         -0.060286032440052366,
         0.08387783701404429,
         -0.0808623851364091,
         0.046321489684054785,
         0.01541909600143231,
         -0.08567663392871544,
         0.12415723806063748,
         -0.015274811703306048,
         0.034449825916482484,
         -0.05683821646559087,
         0.07818637259205918,
         -0.09364936778141608,
         0.09872013756430201,
         -0.0901255142069046,
         0.06664871656761581,
         -0.029806212171660896,
         -0.01570925314744694,
         0.06193283577302892,
         -0.09803562608405893,
         0.11145564251507037,
         -0.08985841174587227,
         0.005188595547760939,
         -0.013480366662971425,
         0.025812936931247366,
         -0.04177429388187284,
         0.0602031650023387,
         -0.07926114978717297,
         0.0965831661431314,
         -0.10951501647855415,
         0.11543896335436798,
         -0.11218650701835502,
         0.09853453834474836,
         -0.07476671794188391,
         0.043166584730171535},
        {0.08672581807839862,
         -0.11472747344203604,
         0.12198043717391809,
         -0.11630378346515259,
         0.10309228547118106,
         -0.08625319429777686,
         0.06854708804857404,
         -0.05181672802119279,
         0.037174877981282245,
         -0.025167511367299413,
         0.015917331791768876,
         -0.009249357812457382,
         0.004799256110626639,
         -0.002104613029266672,
         0.0006783782037480422,
         -0.13712555853457367,
         0.09198662110077954,
         -0.029298753307495828,
         -0.02600631658685031,
         0.06593804733957895,
         -0.08928053815224017,
         0.09794481029237223,
         -0.09519340784437351,
         0.08465523979320319,
         -0.06975450888115083,
         0.05338835386022097,
         -0.03776760605498233,
         0.0243704478192555,
         -0.013976278608073609,
         0.006756166714923798,
         -0.002398429140396959,
         0.11694106924093711,
         0.03580574370197208,
         -0.09253038911459797,
         0.09072935849374346,
         -0.05807632069125007,
         0.014058038927888476,
         0.02852416998937006,
         -0.062187433520542124,
         0.08353477693833283,
         -0.0921570298111397,
         0.08966917955720563,
         -0.07888115857810614,
         0.06310303076624874,
         -0.04558447887422786,
         0.02908825446989348,
         -0.015596077731254399,
         0.0061361617303296164,
         -0.13074409009212298,
         0.04819291099718647,
         0.02989232164872508,
         -0.0753582258323631,
         0.08615130035281666,
         -0.06971234412845465,
         0.036535720690118005,
         0.002995637036216113,
         -0.04024646998335495,
         0.0690974489870228,
         -0.08616254456774249,
         0.0906355550917335,
         -0.08388229468880197,
         0.06886243160790236,
         -0.04944723661023965,
         0.02968807539977952,
         -0.013064886000502303,
         0.11566298639324835,
         -0.0925413414007361,
         0.03573491130084947,
         0.02205606609727764,
         -0.06330911328535126,
         0.0809502540075189,
         -0.07518989286620552,
         0.050925829615669944,
         -0.015565786643282526,
         -0.0227648705760915,
         0.05664051772236448,
         -0.08038137658673679,
         0.09072964092233571,
         -0.08715573011825727,
         0.07179309224485673,
         -0.04899332250188348,
         0.02444216360556941,
         -0.09004351278571217,
         0.10315780329506226,
         -0.07910259818634151,
         0.034948570051343046,
         0.013219121124473923,
         -0.05268172698716246,
         0.07529425085239753,
         -0.07773375076206002,
         0.061084557728551196,
         -0.029971344804664915,
         -0.008604312310415375,
         0.04659898745925184,
         -0.07632437251238286,
         0.09180034282827337,
         -0.0899504592331623,
         0.07149593984086702,
         -0.041263121318024974,
         0.06367037849263484,
         -0.09232204881431995,
         0.09537366780366706,
         -0.07524157910698445,
         0.039179284532391744,
         0.003161264927297156,
         -0.04193891850702254,
         0.06887034045320337,
         -0.07848340356971194,
         0.06887034045320337,
         -0.04193891850702254,
         0.003161264927297156,
         0.03917928453239174,
         -0.07524157910698444,
         0.09537366780366706,
         -0.09232204881431995,
         0.06367037849263484,
         -0.04126312131802498,
         0.07149593984086702,
         -0.0899504592331623,
         0.09180034282827337,
         -0.07632437251238286,
         0.04659898745925184,
         -0.008604312310415373,
         -0.029971344804664908,
         0.061084557728551196,
         -0.07773375076206002,
         0.07529425085239753,
         -0.05268172698716246,
         0.013219121124473921,
         0.034948570051343046,
         -0.07910259818634151,
         0.10315780329506229,
         -0.09004351278571217,
         0.024442163605569407,
         -0.048993322501883485,
         0.07179309224485672,
         -0.08715573011825725,
         0.09072964092233568,
         -0.08038137658673679,
         0.05664051772236447,
         -0.0227648705760915,
         -0.01556578664328253,
         0.050925829615669944,
         -0.07518989286620552,
         0.0809502540075189,
         -0.06330911328535124,
         0.022056066097277637,
         0.03573491130084948,
         -0.09254134140073611,
         0.11566298639324829,
         -0.013064886000502299,
         0.029688075399779527,
         -0.049447236610239635,
         0.06886243160790237,
         -0.08388229468880197,
         0.09063555509173352,
         -0.08616254456774249,
         0.06909744898702282,
         -0.040246469983354946,
         0.0029956370362161137,
         0.036535720690118005,
         -0.06971234412845465,
         0.08615130035281666,
         -0.07535822583236311,
         0.029892321648725073,
         0.048192910997186464,
         -0.13074409009212293,
         0.006136161730329618,
         -0.015596077731254402,
         0.02908825446989348,
         -0.04558447887422786,
         0.06310303076624874,
         -0.07888115857810614,
         0.08966917955720564,
         -0.0921570298111397,
         0.08353477693833282,
         -0.06218743352054214,
         0.028524169989370053,
         0.014058038927888478,
         -0.05807632069125007,
         0.09072935849374347,
         -0.09253038911459799,
         0.03580574370197208,
         0.11694106924093708,
         -0.002398429140396959,
         0.0067561667149238,
         -0.013976278608073609,
         0.0243704478192555,
         -0.037767606054982326,
         0.053388353860220984,
         -0.06975450888115081,
         0.08465523979320318,
         -0.09519340784437352,
         0.09794481029237224,
         -0.08928053815224017,
         0.06593804733957895,
         -0.026006316586850303,
         -0.029298753307495828,
         0.09198662110077956,
         -0.1371255585345737,
         0.0006783782037480422,
         -0.0021046130292666715,
         0.004799256110626639,
         -0.00924935781245738,
         0.015917331791768876,
         -0.02516751136729942,
         0.03717487798128225,
         -0.0518167280211928,
         0.06854708804857403,
         -0.08625319429777688,
         0.10309228547118106,
         -0.11630378346515256,
         0.12198043717391809,
         -0.11472747344203621,
         0.08672581807839855},
        {0.016571045299983204,
         -0.035797549230253356,
         0.057591073327519664,
         -0.07885982493104153,
         0.09658316614313164,
         -0.10829134660300156,
         0.11237924133769898,
         -0.10829134660300156,
         0.09658316614313164,
         -0.07885982493104153,
         0.05759107332751967,
         -0.03579754923025382,
         0.016571045299983187,
         -0.04224804167262229,
         0.07441611006409113,
         -0.09570110962029066,
         0.10078437832315944,
         -0.0881679646197708,
         0.059983844910854095,
         -0.021237680364689968,
         -0.021237680364689964,
         0.0599838449108541,
         -0.08816796461977082,
         0.10078437832315942,
         -0.09570110962029064,
         0.0744161100640911,
         -0.04224804167262228,
         0.07536058523767093,
         -0.10190611080391765,
         0.09449021633936143,
         -0.0602088493878614,
         0.011888565924062379,
         0.03594764443459039,
         -0.07047048484647217,
         0.08299757022830197,
         -0.07047048484647217,
         0.035947644434590385,
         0.011888565924062379,
         -0.0602088493878614,
         0.09449021633936144,
         -0.10190611080391763,
         0.07536058523767093,
         -0.10657596171148777,
         0.09729009719531466,
         -0.0438735563718573,
         -0.01877304504090701,
         0.06478665213634241,
         -0.08042323099029405,
         0.06409462521293034,
         -0.024230070296513924,
         -0.024230070296513924,
         0.06409462521293034,
         -0.08042323099029404,
         0.06478665213634242,
         -0.01877304504090701,
         -0.0438735563718573,
         0.09729009719531466,
         -0.10657596171148778,
         0.1230633203665416,
         -0.05024039015844696,
         -0.033370228034747,
         0.07829399325221156,
         -0.07472734887884222,
         0.0353987932051894,
         0.017037289976763265,
         -0.05959505222453833,
         0.07576606905359981,
         -0.05959505222453833,
         0.017037289976763265,
         0.03539879320518939,
         -0.07472734887884223,
         0.07829399325221158,
         -0.033370228034747,
         -0.05024039015844696,
         0.1230633203665416,
         -0.11345877531814079,
         -0.027517794987642348,
         0.08718936670447831,
         -0.06701796436031561,
         0.008460897061447632,
         0.04755726576460442,
         -0.07470210938767778,
         0.06470319955806923,
         -0.025255356351199423,
         -0.025255356351199423,
         0.06470319955806925,
         -0.07470210938767782,
         0.04755726576460437,
         0.008460897061447632,
         -0.06701796436031561,
         0.08718936670447831,
         -0.027517794987642348,
         -0.11345877531814079,
         0.07427620373605241,
         0.09903493831473707,
         -0.06845061912930307,
         -0.013107565365185014,
         0.0691788172051465,
         -0.07573259988773931,
         0.04083510748384637,
         0.01198726063311815,
         -0.05668741944259972,
         0.07394011231643258,
         -0.05668741944259972,
         0.011987260633118037,
         0.04083510748384649,
         -0.07573259988773931,
         0.0691788172051465,
         -0.013107565365185014,
         -0.06845061912930307,
         0.09903493831473707,
         0.07427620373605241,
         -0.11345877531814078,
         -0.027517794987642348,
         0.08718936670447831,
         -0.06701796436031561,
         0.00846089706144763,
         0.04755726576460442,
         -0.07470210938767778,
         0.06470319955806923,
         -0.02525535635119942,
         -0.025255356351199423,
         0.06470319955806925,
         -0.07470210938767784,
         0.04755726576460437,
         0.00846089706144763,
         -0.06701796436031561,
         0.08718936670447831,
         -0.027517794987642348,
         -0.11345877531814076,
         0.1230633203665416,
         -0.05024039015844697,
         -0.033370228034747,
         0.07829399325221156,
         -0.07472734887884223,
         0.03539879320518939,
         0.017037289976763265,
         -0.059595052224538314,
         0.07576606905359982,
         -0.059595052224538314,
         0.017037289976763265,
         0.03539879320518939,
         -0.07472734887884223,
         0.07829399325221156,
         -0.03337022803474699,
         -0.05024039015844697,
         0.1230633203665416,
         -0.1065759617114878,
         0.09729009719531466,
         -0.04387355637185731,
         -0.01877304504090701,
         0.06478665213634242,
         -0.08042323099029405,
         0.06409462521293036,
         -0.024230070296513927,
         -0.024230070296513927,
         0.06409462521293036,
         -0.08042323099029405,
         0.06478665213634242,
         -0.01877304504090701,
         -0.04387355637185731,
         0.09729009719531466,
         -0.1065759617114878,
         0.07536058523767095,
         -0.10190611080391763,
         0.09449021633936143,
         -0.060208849387861384,
         0.011888565924062379,
         0.03594764443459039,
         -0.07047048484647216,
         0.08299757022830194,
         -0.07047048484647216,
         0.03594764443459039,
         0.011888565924062379,
         -0.060208849387861384,
         0.09449021633936143,
         -0.10190611080391765,
         0.07536058523767095,
         -0.042248041672622284,
         0.07441611006409111,
         -0.09570110962029063,
         0.10078437832315937,
         -0.08816796461977083,
         0.05998384491085408,
         -0.021237680364689964,
         -0.021237680364689964,
         0.05998384491085408,
         -0.08816796461977083,
         0.10078437832315937,
         -0.09570110962029063,
         0.07441611006409111,
         -0.042248041672622284,
         0.016571045299983187,
         -0.03579754923025383,
         0.057591073327519664,
         -0.07885982493104149,
         0.09658316614313164,
         -0.10829134660300156,
         0.11237924133769897,
         -0.10829134660300156,
         0.09658316614313164,
         -0.07885982493104149,
         0.057591073327519664,
         -0.03579754923025383,
         0.016571045299983184},
        {0.03501870817094916,
         -0.06246515193484292,
         0.08512565307587494,
         -0.10072203103706691,
         0.10838246260280035,
         -0.10838246260280053,
         0.10180759621425196,
         -0.09024278883583442,
         0.07550253410189796,
         -0.05940507615215441,
         0.04359140838822973,
         -0.02938932153992357,
         0.01772242770746119,
         -0.009063396837648412,
         0.003425642009415275,
         -0.07830421195446961,
         0.10345212002237407,
         -0.10016708449412724,
         0.07613869876268771,
         -0.04002287675337144,
         0.03717487798128241,
         -0.06664871656761588,
         0.08561182653805524,
         -0.09320235154040002,
         0.0902427888358347,
         -0.07885982493104156,
         0.06202849697611403,
         -0.043075680527136874,
         0.025173224893529578,
         -0.010832831198108264,
         0.11566298639324828,
         -0.09254134140073593,
         0.03573491130084949,
         0.022056066097277574,
         -0.06330911328535128,
         0.08095025400751879,
         -0.07518989286620525,
         0.050925829615669986,
         -0.015565786643282502,
         -0.022764870576091546,
         0.05664051772236424,
         -0.08038137658673664,
         0.0907296409223357,
         -0.08715573011825709,
         0.07179309224485673,
         -0.04899332250188339,
         0.02444216360556937,
         -0.12313265182013552,
         0.01800870255714201,
         0.05895959558050252,
         -0.08422799368643429,
         0.06697745377628575,
         -0.02580108253937915,
         -0.020487338272785267,
         0.057074551025370616,
         -0.07489092590539703,
         0.07088971082984408,
         -0.0473888570604976,
         0.010800922936755225,
         0.03001758221694385,
         -0.06561199308002938,
         0.08780421839448121,
         -0.09142880978191173,
         0.07573127407171762,
         -0.04506912279879471,
         0.08706793308749983,
         0.0787559087244567,
         -0.08753229869069555,
         0.03262136168320317,
         0.028984840476028145,
         -0.06792248772582396,
         0.07472461956132609,
         -0.053098189807783754,
         0.014209554116396728,
         0.028021618611628246,
         -0.06062002963542941,
         0.07424407039959997,
         -0.064866877471104,
         0.03444937051106516,
         0.009394040761563416,
         -0.05473494098401139,
         0.0876676928917901,
         -0.0956060470594707,
         0.07126054009500704,
         -0.11740237702510203,
         0.07146982260169688,
         -0.08046447870120112,
         0.04637574476164256,
         0.00411626242498504,
         -0.04809161706532931,
         0.0708925877889518,
         -0.06725188466790498,
         0.04041335309028616,
         -0.040870015642724467,
         0.06883449848332683,
         -0.07356871515685542,
         0.05076538236868893,
         -0.004446071570488776,
         -0.0518496588971081,
         0.09560604705947053,
         -0.09822587587698553,
         0.11740237702510224,
         -0.06430393020137422,
         -0.010120017180007993,
         0.06235831903309546,
         -0.07758545032685128,
         0.05881599843352621,
         -0.01896758956378541,
         -0.025442882616229536,
         0.05915909134335835,
         -0.07164521754152041,
         0.05915909134335835,
         -0.025442882616229536,
         -0.01896758956378541,
         0.05881599843352621,
         -0.07758545032685128,
         0.06235831903309546,
         -0.010120017180007993,
         -0.0643039302013742,
         0.11740237702510224,
         -0.09822587587698553,
         0.09560604705947053,
         -0.051849658897108096,
         -0.004446071570488776,
         0.05076538236868893,
         -0.07356871515685542,
         0.06883449848332689,
         -0.04087001564272447,
         0.040413353090286167,
         -0.06725188466790498,
         0.0708925877889518,
         -0.04809161706532931,
         0.0041162624249850965,
         0.04637574476164255,
         -0.08046447870120112,
         0.07146982260169688,
         -0.11740237702510203,
         0.07126054009500704,
         -0.0956060470594707,
         0.0876676928917901,
         -0.05473494098401139,
         0.00939404076156339,
         0.03444937051106517,
         -0.06486687747110399,
         0.07424407039959997,
         -0.06062002963542941,
         0.028021618611628246,
         0.014209554116396728,
         -0.05309818980778373,
         0.0747246195613261,
         -0.06792248772582396,
         0.02898484047602815,
         0.032621361683203176,
         -0.08753229869069555,
         0.07875590872445669,
         0.08706793308749983,
         -0.04506912279879471,
         0.07573127407171762,
         -0.09142880978191173,
         0.08780421839448121,
         -0.06561199308002937,
         0.030017582216943842,
         0.010800922936755225,
         -0.04738885706049759,
         0.07088971082984406,
         -0.07489092590539703,
         0.05707455102537062,
         -0.020487338272785267,
         -0.025801082539379152,
         0.06697745377628576,
         -0.08422799368643427,
         0.05895959558050252,
         0.018008702557142018,
         -0.12313265182013552,
         0.024442163605569365,
         -0.048993322501883395,
         0.07179309224485672,
         -0.08715573011825709,
         0.09072964092233571,
         -0.08038137658673662,
         0.056640517722364246,
         -0.022764870576091542,
         -0.015565786643282498,
         0.05092582961566998,
         -0.07518989286620524,
         0.08095025400751876,
         -0.06330911328535127,
         0.02205606609727757,
         0.035734911300849485,
         -0.09254134140073594,
         0.11566298639324828,
         -0.010832831198108264,
         0.025173224893529574,
         -0.043075680527136874,
         0.06202849697611402,
         -0.07885982493104156,
         0.0902427888358347,
         -0.09320235154040003,
         0.08561182653805526,
         -0.06664871656761588,
         0.03717487798128241,
         -0.04002287675337144,
         0.07613869876268771,
         -0.10016708449412723,
         0.1034521200223741,
         -0.07830421195446963,
         0.003425642009415275,
         -0.009063396837648412,
         0.017722427707461186,
         -0.02938932153992357,
         0.04359140838822973,
         -0.05940507615215438,
         0.07550253410189796,
         -0.09024278883583442,
         0.10180759621425191,
         -0.10838246260280054,
         0.10838246260280032,
         -0.10072203103706692,
         0.08512565307587491,
         -0.06246515193484288,
         0.03501870817094915},
        {0.012191949265990897,
         -0.026988030158424547,
         0.044647388168594426,
         -0.06314094187256222,
         0.08030691489721405,
         -0.09416820481417308,
         0.103156099952978,
         -0.10626703078781481,
         0.103156099952978,
         -0.09416820481417308,
         0.08030691489721406,
         -0.06314094187256222,
         0.044647388168594426,
         -0.0269880301584245,
         0.012191949265990898,
         -0.03338902816470891,
         0.06138498140448493,
         -0.08341280022543408,
         0.0947114128088432,
         -0.09283575356046539,
         0.07775683599555201,
         -0.051578049976489154,
         0.01804855776716644,
         0.01804855776716644,
         -0.051578049976489154,
         0.07775683599555201,
         -0.09283575356046539,
         0.0947114128088432,
         -0.08341280022543407,
         0.061384981404484916,
         -0.03338902816470891,
         0.06367037849263477,
         -0.09232204881431991,
         0.09537366780366689,
         -0.07524157910698413,
         0.03917928453239155,
         0.0031612649272971358,
         -0.0419389185070225,
         0.06887034045320331,
         -0.07848340356971203,
         0.06887034045320331,
         -0.0419389185070225,
         0.0031612649272971353,
         0.03917928453239154,
         -0.07524157910698413,
         0.09537366780366689,
         -0.09232204881431991,
         0.06367037849263474,
         -0.09585863943378384,
         0.09877462805665974,
         -0.06128700052574009,
         0.008033842634236817,
         0.04033174833631078,
         -0.0699775822022637,
         0.07483144342694972,
         -0.05607658637064003,
         0.020682192816872908,
         0.020682192816872908,
         -0.05607658637064002,
         0.07483144342694972,
         -0.06997758220226372,
         0.040331748336310785,
         0.008033842634236817,
         -0.06128700052574008,
         0.09877462805665974,
         -0.09585863943378384,
         0.11740237702510227,
         -0.06430393020137432,
         -0.01012001718000797,
         0.06235831903309533,
         -0.07758545032685123,
         0.0588159984335255,
         -0.018967589563785425,
         -0.025442882616229484,
         0.05915909134335782,
         -0.07164521754152128,
         0.05915909134335782,
         -0.025442882616229484,
         -0.01896758956378542,
         0.0588159984335255,
         -0.07758545032685121,
         0.06235831903309533,
         -0.010120017180007972,
         -0.06430393020137432,
         0.11740237702510227,
         -0.11442968244553961,
         -0.008301601692187285,
         0.07587060639169506,
         -0.07642958310293957,
         0.03507287480528815,
         0.017660796631738532,
         -0.0576396784648554,
         0.07149589595435242,
         -0.05707883895979124,
         0.02160184587350907,
         0.02160184587350907,
         -0.05707883895979124,
         0.07149589595435242,
         -0.05763967846485539,
         0.017660796631738536,
         0.03507287480528815,
         -0.07642958310293957,
         0.07587060639169504,
         -0.008301601692187287,
         -0.1144296824455396,
         0.07896398282214927,
         0.08686038110436453,
         -0.0781327830029682,
         0.011221197558938174,
         0.048845212903609325,
         -0.074257925022376,
         0.06219330411750545,
         -0.02445927703206216,
         -0.02097557190755658,
         0.05657048181128662,
         -0.06991857302518568,
         0.05657048181128662,
         -0.020975571907556684,
         -0.02445927703206216,
         0.06219330411750545,
         -0.07425792502237615,
         0.048845212903609325,
         0.011221197558938174,
         -0.0781327830029682,
         0.08686038110436452,
         0.07896398282214927,
         -0.11442968244553958,
         -0.008301601692187287,
         0.07587060639169506,
         -0.07642958310293957,
         0.03507287480528815,
         0.017660796631738536,
         -0.05763967846485539,
         0.07149589595435242,
         -0.05707883895979124,
         0.02160184587350907,
         0.02160184587350907,
         -0.05707883895979124,
         0.07149589595435242,
         -0.05763967846485539,
         0.017660796631738536,
         0.03507287480528815,
         -0.07642958310293957,
         0.07587060639169506,
         -0.008301601692187287,
         -0.11442968244553961,
         0.11740237702510227,
         -0.06430393020137432,
         -0.01012001718000797,
         0.06235831903309534,
         -0.0775854503268512,
         0.058815998433525515,
         -0.018967589563785425,
         -0.025442882616229488,
         0.05915909134335782,
         -0.07164521754152127,
         0.05915909134335782,
         -0.025442882616229488,
         -0.018967589563785425,
         0.058815998433525515,
         -0.0775854503268512,
         0.06235831903309534,
         -0.01012001718000797,
         -0.06430393020137432,
         0.11740237702510227,
         -0.09585863943378382,
         0.09877462805665974,
         -0.06128700052574008,
         0.008033842634236815,
         0.04033174833631078,
         -0.06997758220226372,
         0.07483144342694974,
         -0.056076586370640016,
         0.02068219281687291,
         0.02068219281687291,
         -0.056076586370640016,
         0.07483144342694974,
         -0.06997758220226372,
         0.04033174833631078,
         0.008033842634236815,
         -0.06128700052574008,
         0.09877462805665974,
         -0.09585863943378382,
         0.06367037849263477,
         -0.09232204881431991,
         0.09537366780366686,
         -0.07524157910698413,
         0.03917928453239155,
         0.0031612649272971358,
         -0.04193891850702251,
         0.06887034045320328,
         -0.07848340356971202,
         0.06887034045320328,
         -0.04193891850702252,
         0.0031612649272971358,
         0.03917928453239155,
         -0.07524157910698413,
         0.09537366780366686,
         -0.09232204881431991,
         0.06367037849263477,
         -0.03338902816470891,
         0.061384981404484916,
         -0.0834128002254341,
         0.0947114128088432,
         -0.09283575356046539,
         0.07775683599555201,
         -0.05157804997648916,
         0.01804855776716644,
         0.01804855776716644,
         -0.05157804997648916,
         0.07775683599555201,
         -0.09283575356046539,
         0.09471141280884318,
         -0.0834128002254341,
         0.061384981404484916,
         -0.03338902816470891,
         0.012191949265990898,
         -0.02698803015842449,
         0.044647388168594426,
         -0.06314094187256224,
         0.08030691489721403,
         -0.09416820481417308,
         0.103156099952978,
         -0.1062670307878148,
         0.103156099952978,
         -0.0941682048141731,
         0.08030691489721403,
         -0.06314094187256224,
         0.044647388168594426,
         -0.026988030158424492,
         0.012191949265990898},
        {0.028872982345285656,
         -0.05271461244320441,
         0.07373494435171958,
         -0.0898492439233977,
         0.09997500937109535,
         -0.10389707743074719,
         0.10205804578387868,
         -0.09535826006183876,
         0.0849768722124838,
         -0.07221645493592294,
         0.05837186557604562,
         -0.04462358602470951,
         0.03195561368527268,
         -0.02109790436916118,
         0.012493261745809843,
         -0.006288137182491055,
         0.0023434503653156627,
         -0.06873144564581296,
         0.09527598084401145,
         -0.09872204783912787,
         0.08384182909988015,
         -0.0565997035496415,
         0.023088239429054722,
         0.011236221034765717,
         -0.04199439561343234,
         0.06609312283193208,
         -0.08176903341128365,
         0.0885122246639691,
         -0.08690255880002021,
         0.07838358775990256,
         -0.0649945456663009,
         0.0490781672200033,
         -0.032980528371842434,
         0.018757364757564617,
         -0.007889229512437342,
         0.10768148053622605,
         -0.09571687158775667,
         0.05048671801410019,
         0.0014131537411960248,
         -0.04437017707188269,
         0.07047184847902473,
         -0.07745265920798873,
         0.06701211251230749,
         -0.04337694766548326,
         0.012078086686240663,
         0.02106655926567907,
         -0.05076658299264431,
         0.07287213405695084,
         -0.08478604639612441,
         0.08567516961092757,
         -0.07648062698354305,
         0.059725660333003465,
         -0.03911484303002254,
         0.018880284004254656,
         -0.12119150788703502,
         0.032104414719576355,
         0.042514090892190534,
         -0.07719157474694134,
         0.0744867425361182,
         -0.046361781707436704,
         0.006834080516427214,
         0.03158417330436676,
         -0.0596191519239452,
         0.07190635564194979,
         -0.06697840871405095,
         0.04679202377061503,
         -0.015942908060139014,
         -0.01932029272155132,
         0.052191597489868735,
         -0.07643045432334718,
         0.08743027654070439,
         -0.08314333821767562,
         0.06474588681295727,
         -0.03680444907221136,
         0.09033081664370407,
         0.06596830121815994,
         -0.08835937053929843,
         0.048525320838742884,
         0.006873798274708092,
         -0.05084015760401655,
         0.07122573762085291,
         -0.06646816592293729,
         0.04187480184436686,
         -0.00645506621368759,
         -0.029698987662141522,
         0.05748386968518533,
         -0.07030763182881343,
         0.0650646663032152,
         -0.04256240682544648,
         0.007400142019712027,
         0.03269948696193152,
         -0.06810453514814947,
         0.08902686758419842,
         -0.08778373333322008,
         0.06134074845368572,
         -0.11661658283679406,
         0.015378939519344902,
         0.057118338664827406,
         -0.0792822070494635,
         0.061030411034481286,
         -0.021010542071048563,
         -0.02237400777212933,
         0.05504015301860633,
         -0.06884509411157173,
         0.06175038133649905,
         -0.03705259186710039,
         0.002005681037365097,
         0.033932825782243846,
         -0.06104538964315841,
         0.0713215333751624,
         -0.06028484021880978,
         0.028502575113366718,
         0.017433686402625423,
         -0.06473365098429058,
         0.09542381022825078,
         -0.08889118957355951,
         0.11143100326584407,
         -0.07360889814442266,
         0.009120043619357272,
         0.04467890659870115,
         -0.07155084498640557,
         0.06914352008707614,
         -0.04381384833980922,
         0.00641950083992933,
         0.03108409694840127,
         -0.058279020176768566,
         0.06816365357953423,
         -0.05827902017676847,
         0.03108409694840127,
         0.006419500839929329,
         -0.04381384833980921,
         0.06914352008707615,
         -0.07155084498640557,
         0.04467890659870115,
         0.009120043619357275,
         -0.07360889814442266,
         0.11143100326584408,
         -0.0888911895735595,
         0.09542381022825076,
         -0.06473365098429056,
         0.01743368640262542,
         0.028502575113366718,
         -0.06028484021880978,
         0.0713215333751624,
         -0.06104538964315839,
         0.033932825782243846,
         0.0020056810373650976,
         -0.03705259186710039,
         0.06175038133649917,
         -0.06884509411157175,
         0.05504015301860633,
         -0.022374007772129334,
         -0.021010542071048573,
         0.061030411034481286,
         -0.0792822070494635,
         0.057118338664827406,
         0.015378939519344902,
         -0.11661658283679406,
         0.061340748453685735,
         -0.08778373333322008,
         0.08902686758419842,
         -0.06810453514814946,
         0.03269948696193152,
         0.007400142019712027,
         -0.04256240682544653,
         0.06506466630321515,
         -0.07030763182881344,
         0.05748386968518533,
         -0.02969898766214153,
         -0.006455066213687591,
         0.04187480184436687,
         -0.06646816592293728,
         0.07122573762085292,
         -0.050840157604016556,
         0.006873798274708092,
         0.048525320838742884,
         -0.08835937053929843,
         0.06596830121815994,
         0.0903308166437041,
         -0.036804449072211344,
         0.06474588681295729,
         -0.08314333821767562,
         0.08743027654070437,
         -0.0764304543233472,
         0.05219159748986874,
         -0.01932029272155132,
         -0.015942908060139014,
         0.046792023770615025,
         -0.06697840871405095,
         0.07190635564194979,
         -0.0596191519239452,
         0.03158417330436676,
         0.006834080516427214,
         -0.046361781707436704,
         0.07448674253611819,
         -0.07719157474694134,
         0.04251409089219054,
         0.03210441471957635,
         -0.12119150788703499,
         0.018880284004254653,
         -0.039114843030022536,
         0.059725660333003465,
         -0.07648062698354305,
         0.08567516961092757,
         -0.0847860463961244,
         0.07287213405695084,
         -0.050766582992644305,
         0.02106655926567907,
         0.012078086686240662,
         -0.043376947665483265,
         0.0670121125123075,
         -0.07745265920798873,
         0.07047184847902468,
         -0.04437017707188269,
         0.0014131537411960246,
         0.050486718014100214,
         -0.09571687158775666,
         0.10768148053622605,
         -0.007889229512437342,
         0.01875736475756462,
         -0.032980528371842434,
         0.0490781672200033,
         -0.0649945456663009,
         0.07838358775990256,
         -0.08690255880002018,
         0.08851222466396909,
         -0.08176903341128365,
         0.06609312283193208,
         -0.04199439561343235,
         0.011236221034765721,
         0.023088239429054715,
         -0.0565997035496415,
         0.08384182909988014,
         -0.09872204783912789,
         0.09527598084401144,
         -0.06873144564581297,
         0.0023434503653156622,
         -0.006288137182491055,
         0.012493261745809843,
         -0.02109790436916118,
         0.03195561368527267,
         -0.044623586024709505,
         0.05837186557604562,
         -0.07221645493592294,
         0.0849768722124838,
         -0.09535826006183874,
         0.1020580457838787,
         -0.10389707743074719,
         0.09997500937109538,
         -0.08984924392339774,
         0.07373494435171955,
         -0.052714612443204564,
         0.02887298234528564},
        {0.009196363306565883,
         -0.020749794066263094,
         0.035073553479685896,
         -0.05082640773017505,
         0.06647438010221647,
         -0.0805044721819548,
         0.09158131742063737,
         -0.09866646109607222,
         0.10110303691029167,
         -0.09866646109607222,
         0.09158131742063737,
         -0.08050447218195479,
         0.06647438010221648,
         -0.05082640773017505,
         0.03507355347968589,
         -0.020749794066263243,
         0.00919636330656588,
         -0.026811776024053137,
         0.05093973319467693,
         -0.07209300451049576,
         0.08626953477235662,
         -0.09088364920319748,
         0.08495554078236504,
         -0.06903201538424888,
         0.0449655342132695,
         -0.015600537286599147,
         -0.015600537286599147,
         0.0449655342132695,
         -0.06903201538424888,
         0.08495554078236503,
         -0.09088364920319747,
         0.08626953477235659,
         -0.07209300451049577,
         0.050939733194676914,
         -0.026811776024053137,
         0.0542294871234356,
         -0.08287276225616404,
         0.0922804000523036,
         -0.08242454667303636,
         0.05715614092736422,
         -0.02269397918257485,
         -0.013834899295148119,
         0.04561461826465648,
         -0.06709410674165418,
         0.07466954133495846,
         -0.06709410674165418,
         0.04561461826465648,
         -0.013834899295148119,
         -0.022693979182574847,
         0.05715614092736423,
         -0.08242454667303638,
         0.09228040005230358,
         -0.08287276225616405,
         0.054229487123435616,
         -0.08631408397995965,
         0.09710047647643577,
         -0.07210027549313483,
         0.028755161234531087,
         0.016878323495327956,
         -0.05248852257724949,
         0.07064526946607375,
         -0.06895046542620609,
         0.049508549092126465,
         -0.017935043699159357,
         -0.017935043699159357,
         0.04950854909212647,
         -0.06895046542620609,
         0.07064526946607376,
         -0.05248852257724949,
         0.016878323495327956,
         0.028755161234531087,
         -0.07210027549313483,
         0.09710047647643574,
         -0.08631408397995965,
         0.11143100326584413,
         -0.07360889814442281,
         0.009120043619357242,
         0.0446789065987011,
         -0.07155084498640546,
         0.06914352008707605,
         -0.043813848339809114,
         0.006419500839928641,
         0.031084096948401158,
         -0.05827902017676838,
         0.0681636535795342,
         -0.05827902017676849,
         0.031084096948401158,
         0.006419500839928697,
         -0.04381384833980911,
         0.06914352008707607,
         -0.07155084498640546,
         0.0446789065987011,
         0.009120043619357244,
         -0.07360889814442281,
         0.11143100326584413,
         -0.11418280042665867,
         0.007512676707597396,
         0.06285556293520264,
         -0.07818808654772619,
         0.052671914129639494,
         -0.008372971221814789,
         -0.034525535816966886,
         0.06192110728808268,
         -0.06715655431346626,
         0.05070029838508621,
         -0.018761428172423857,
         -0.018761428172423735,
         0.050700298385086315,
         -0.06715655431346614,
         0.061921107288082665,
         -0.03452553581696683,
         -0.008372971221814787,
         0.05267191412963949,
         -0.07818808654772619,
         0.06285556293520264,
         0.007512676707597396,
         -0.11418280042665865,
         0.08263944378357056,
         0.07512676707597306,
         -0.08263944378357059,
         0.030050706830389812,
         0.028073686644180605,
         -0.06405545403319653,
         0.06942829712748655,
         -0.04828581066554676,
         0.011652789568129747,
         0.02712006514259698,
         -0.055938041739231045,
         0.06652091450070799,
         -0.055938041739231045,
         0.027120065142596874,
         0.011652789568129745,
         -0.04828581066554676,
         0.06942829712748651,
         -0.06405545403319653,
         0.028073686644180605,
         0.030050706830389812,
         -0.08263944378357059,
         0.07512676707597306,
         0.08263944378357056,
         -0.11418280042665867,
         0.007512676707597397,
         0.06285556293520264,
         -0.07818808654772619,
         0.052671914129639494,
         -0.008372971221814787,
         -0.034525535816966886,
         0.06192110728808268,
         -0.06715655431346626,
         0.05070029838508622,
         -0.018761428172423857,
         -0.01876142817242374,
         0.050700298385086315,
         -0.06715655431346614,
         0.06192110728808268,
         -0.03452553581696684,
         -0.008372971221814787,
         0.05267191412963949,
         -0.07818808654772619,
         0.06285556293520264,
         0.007512676707597397,
         -0.11418280042665868,
         0.11143100326584414,
         -0.0736088981444228,
         0.009120043619357242,
         0.0446789065987011,
         -0.07155084498640549,
         0.06914352008707605,
         -0.04381384833980911,
         0.006419500839928641,
         0.031084096948401165,
         -0.058279020176768385,
         0.0681636535795342,
         -0.05827902017676849,
         0.031084096948401165,
         0.006419500839928696,
         -0.04381384833980911,
         0.06914352008707605,
         -0.07155084498640547,
         0.04467890659870109,
         0.009120043619357242,
         -0.0736088981444228,
         0.11143100326584414,
         -0.08631408397995964,
         0.09710047647643574,
         -0.07210027549313483,
         0.02875516123453108,
         0.016878323495327956,
         -0.05248852257724949,
         0.07064526946607376,
         -0.06895046542620609,
         0.04950854909212648,
         -0.01793504369915936,
         -0.01793504369915936,
         0.04950854909212648,
         -0.0689504654262061,
         0.07064526946607376,
         -0.05248852257724949,
         0.016878323495327956,
         0.02875516123453108,
         -0.07210027549313483,
         0.09710047647643576,
         -0.08631408397995964,
         0.05422948712343561,
         -0.08287276225616402,
         0.09228040005230359,
         -0.08242454667303638,
         0.05715614092736424,
         -0.022693979182574847,
         -0.01383489929514812,
         0.04561461826465648,
         -0.06709410674165418,
         0.07466954133495846,
         -0.06709410674165418,
         0.04561461826465649,
         -0.01383489929514812,
         -0.022693979182574847,
         0.05715614092736424,
         -0.08242454667303638,
         0.09228040005230358,
         -0.08287276225616402,
         0.05422948712343561,
         -0.026811776024053137,
         0.05093973319467693,
         -0.07209300451049576,
         0.08626953477235659,
         -0.09088364920319748,
         0.08495554078236504,
         -0.06903201538424887,
         0.044965534213269494,
         -0.015600537286599143,
         -0.015600537286599143,
         0.044965534213269494,
         -0.06903201538424887,
         0.08495554078236504,
         -0.09088364920319747,
         0.08626953477235659,
         -0.07209300451049577,
         0.05093973319467693,
         -0.026811776024053137,
         0.009196363306565878,
         -0.02074979406626325,
         0.03507355347968589,
         -0.05082640773017506,
         0.06647438010221653,
         -0.0805044721819548,
         0.09158131742063735,
         -0.09866646109607219,
         0.10110303691029167,
         -0.09866646109607219,
         0.09158131742063735,
         -0.0805044721819548,
         0.06647438010221653,
         -0.05082640773017506,
         0.035073553479685896,
         -0.02074979406626325,
         0.009196363306565878},
        {0.007085070638254781,
         -0.016233936251955572,
         0.027913505118346102,
         -0.04123097956171753,
         0.055097214014651896,
         -0.06837384447251448,
         0.07998340216199533,
         -0.08899731407305936,
         0.09470388736980942,
         -0.09665675029751744,
         0.09470388736980942,
         -0.08899731407305936,
         0.07998340216199533,
         -0.06837384447251448,
         0.055097214014651896,
         -0.04123097956171752,
         0.027913505118346105,
         -0.016233936251955825,
         0.007085070638254777,
         -0.021837654327241114,
         0.04258416269471308,
         -0.062186599144793984,
         0.07736533073395609,
         -0.08571115003934314,
         0.08588805662598582,
         -0.07764191552953575,
         0.06170853447480511,
         -0.03965421233743383,
         0.013669328716565735,
         0.013669328716565734,
         -0.03965421233743383,
         0.06170853447480509,
         -0.07764191552953575,
         0.08588805662598582,
         -0.08571115003934311,
         0.0773653307339561,
         -0.062186599144793984,
         0.04258416269471308,
         -0.02183765432724111,
         0.04655803546094003,
         -0.07412822969871002,
         0.08724663689731636,
         -0.0846451027586368,
         0.06811098382819024,
         -0.04153108770011637,
         0.009909000361691934,
         0.021488285238572165,
         -0.04783329457040655,
         0.06528603334907275,
         -0.0713857410440305,
         0.06528603334907275,
         -0.047833294570406554,
         0.02148828523857217,
         0.009909000361691934,
         -0.04153108770011636,
         0.06811098382819025,
         -0.08464510275863683,
         0.08724663689731639,
         -0.07412822969871002,
         0.04655803546094003,
         -0.07790649436824894,
         0.0936962389705569,
         -0.078283621629662,
         0.04406316479705593,
         -0.0033810108738896016,
         -0.033363019904248566,
         0.058801795748038975,
         -0.06899311613903679,
         0.06332464089486782,
         -0.044077563909625424,
         0.015753669987392614,
         0.015753669987392617,
         -0.044077563909625424,
         0.06332464089486782,
         -0.06899311613903679,
         0.05880179574803896,
         -0.033363019904248566,
         -0.003381010873889601,
         0.044063164797055944,
         -0.07828362162966201,
         0.0936962389705569,
         -0.07790649436824894,
         0.10548589203636852,
         -0.07951298285467523,
         0.024559567570090136,
         0.027585548333841223,
         -0.06098230385841402,
         0.07048107283263066,
         -0.05823366245578792,
         0.03082352187956917,
         0.003125492551583715,
         -0.03489451565977581,
         0.057179071390013506,
         -0.06516596775672898,
         0.0571790713900135,
         -0.03489451565977581,
         0.003125492551583715,
         0.030823521879569177,
         -0.05823366245578792,
         0.07048107283263061,
         -0.060982303858414015,
         0.027585548333841223,
         0.02455956757009014,
         -0.07951298285467524,
         0.10548589203636853,
         -0.11312101675424702,
         0.02042725515583418,
         0.04967798001577446,
         -0.0751639173667258,
         0.0629747205074399,
         -0.028670006444359603,
         -0.011608177543222574,
         0.044870977156678496,
         -0.06288825636029097,
         0.06253777866120273,
         -0.04534667929926739,
         0.016499035235335725,
         0.01649903523533561,
         -0.04534667929926739,
         0.06253777866120273,
         -0.06288825636029097,
         0.044870977156678496,
         -0.011608177543222575,
         -0.02867000644435966,
         0.0629747205074399,
         -0.0751639173667258,
         0.04967798001577446,
         0.02042725515583418,
         -0.11312101675424702,
         0.08551145096757372,
         0.06413358822568081,
         -0.08365250638132232,
         0.04402318770168576,
         0.009125727968870801,
         -0.049938011385214476,
         0.06734004527517042,
         -0.06063806084579043,
         0.03570240942207742,
         -0.001738869218237285,
         -0.031353012758550035,
         0.05503454367192415,
         -0.06359547268755508,
         0.05503454367192403,
         -0.031353012758549924,
         -0.0017388692182372853,
         0.03570240942207731,
         -0.06063806084579053,
         0.06734004527517043,
         -0.04993801138521446,
         0.0091257279688708,
         0.04402318770168576,
         -0.08365250638132232,
         0.06413358822568081,
         0.08551145096757373,
         -0.11312101675424702,
         0.02042725515583418,
         0.04967798001577446,
         -0.0751639173667258,
         0.06297472050743991,
         -0.0286700064443596,
         -0.011608177543222575,
         0.044870977156678496,
         -0.06288825636029097,
         0.06253777866120273,
         -0.04534667929926738,
         0.016499035235335722,
         0.016499035235335607,
         -0.04534667929926739,
         0.06253777866120272,
         -0.06288825636029097,
         0.04487097715667849,
         -0.011608177543222575,
         -0.02867000644435966,
         0.06297472050743991,
         -0.0751639173667258,
         0.049677980015774455,
         0.02042725515583418,
         -0.11312101675424702,
         0.10548589203636852,
         -0.07951298285467523,
         0.024559567570090136,
         0.027585548333841223,
         -0.06098230385841401,
         0.07048107283263066,
         -0.05823366245578792,
         0.030823521879569184,
         0.0031254925515837163,
         -0.034894515659775804,
         0.05717907139001349,
         -0.06516596775672896,
         0.0571790713900135,
         -0.034894515659775804,
         0.003125492551583716,
         0.030823521879569184,
         -0.05823366245578792,
         0.07048107283263061,
         -0.06098230385841401,
         0.027585548333841223,
         0.02455956757009014,
         -0.07951298285467523,
         0.10548589203636853,
         -0.07790649436824891,
         0.09369623897055689,
         -0.07828362162966201,
         0.04406316479705595,
         -0.0033810108738896016,
         -0.033363019904248566,
         0.05880179574803896,
         -0.06899311613903679,
         0.06332464089486779,
         -0.04407756390962542,
         0.015753669987392617,
         0.015753669987392617,
         -0.04407756390962542,
         0.06332464089486779,
         -0.0689931161390368,
         0.05880179574803896,
         -0.033363019904248566,
         -0.0033810108738896016,
         0.044063164797055944,
         -0.07828362162966201,
         0.09369623897055689,
         -0.07790649436824891,
         0.046558035460940034,
         -0.07412822969871004,
         0.0872466368973164,
         -0.08464510275863685,
         0.06811098382819024,
         -0.04153108770011637,
         0.009909000361691934,
         0.02148828523857217,
         -0.04783329457040654,
         0.06528603334907276,
         -0.0713857410440305,
         0.06528603334907276,
         -0.04783329457040654,
         0.02148828523857217,
         0.009909000361691934,
         -0.04153108770011637,
         0.06811098382819024,
         -0.08464510275863685,
         0.0872466368973164,
         -0.07412822969871004,
         0.046558035460940034,
         -0.02183765432724111,
         0.04258416269471307,
         -0.06218659914479397,
         0.07736533073395609,
         -0.08571115003934313,
         0.08588805662598584,
         -0.07764191552953575,
         0.06170853447480511,
         -0.039654212337433825,
         0.013669328716565735,
         0.013669328716565735,
         -0.039654212337433825,
         0.06170853447480511,
         -0.07764191552953575,
         0.08588805662598584,
         -0.08571115003934313,
         0.07736533073395609,
         -0.06218659914479397,
         0.04258416269471307,
         -0.02183765432724111,
         0.007085070638254777,
         -0.016233936251955825,
         0.027913505118346112,
         -0.04123097956171752,
         0.0550972140146519,
         -0.0683738444725145,
         0.07998340216199532,
         -0.08899731407305936,
         0.09470388736980943,
         -0.09665675029751745,
         0.09470388736980943,
         -0.08899731407305936,
         0.07998340216199532,
         -0.0683738444725145,
         0.0550972140146519,
         -0.04123097956171752,
         0.027913505118346112,
         -0.01623393625195583,
         0.007085070638254777},
        {0.04183179465772295,
         -0.07826012174154018,
         0.10692368192314171,
         -0.12124005927085983,
         0.11888565924062687,
         -0.10180759621425228,
         0.07518989286620481,
         -0.045824435109918016,
         0.020206676545143274,
         -0.08215601377494217,
         0.11180017391648579,
         -0.09928627607148911,
         0.052913499892347636,
         0.0089869111086476,
         -0.06563111915333433,
         0.10047672073342066,
         -0.10568153304956394,
         0.08371337425845098,
         -0.045824435109918016,
         0.11392989240510742,
         -0.09667271939940619,
         0.02561976558777299,
         0.048534867145655386,
         -0.08778250653852858,
         0.07736188867977609,
         -0.026141777410322198,
         -0.04050962336990127,
         0.09215132710147737,
         -0.10568153304956394,
         0.07518989286620481,
         -0.12595423517110133,
         0.03797663080170268,
         0.056872038674157,
         -0.08820612431193611,
         0.051152370625975614,
         0.01857815223563203,
         -0.07394011231643176,
         0.0812380406751384,
         -0.03486206832513695,
         -0.04050962336990127,
         0.10047672073342066,
         -0.10180759621425227,
         0.11392989240510745,
         0.03797663080170268,
         -0.09198396775536381,
         0.04215234949613339,
         0.03818250981576615,
         -0.08069208216640524,
         0.05915909134335793,
         0.006661541718179065,
         -0.06905798247845775,
         0.0812380406751384,
         -0.026141777410322198,
         -0.06563111915333433,
         0.11888565924062687,
         -0.08215601377494215,
         -0.0966727193994062,
         0.056872038674157,
         0.04215234949613339,
         -0.0826675587017559,
         0.04356962901720373,
         0.030100046823668902,
         -0.0769208580841726,
         0.06106413241664162,
         0.006661541718179732,
         -0.07394011231643212,
         0.07736188867977609,
         0.008986911108647603,
         -0.12124005927085983,
         0.041831794657722965,
         0.11180017391648578,
         0.025619765587772986,
         -0.08820612431193614,
         0.03818250981576615,
         0.04356962901720313,
         -0.0788204245663894,
         0.044061956836459325,
         0.02775642382574572,
         -0.07692085808417348,
         0.05915909134335794,
         0.018578152235632035,
         -0.08778250653852858,
         0.052913499892347615,
         0.10692368192314172,
         -0.07826012174154003,
         -0.09928627607148907,
         0.0485348671456554,
         0.05115237062597499,
         -0.08069208216640442,
         0.030100046823668694,
         0.0440619568364603,
         -0.07771798671209129,
         0.044061956836460296,
         0.030100046823668805,
         -0.08069208216640446,
         0.05115237062597498,
         0.0485348671456554,
         -0.09928627607148907,
         -0.07826012174154004,
         0.10692368192314172,
         0.052913499892347615,
         -0.08778250653852857,
         0.018578152235632032,
         0.05915909134335796,
         -0.07692085808417348,
         0.02775642382574572,
         0.044061956836459325,
         -0.07882042456638938,
         0.04356962901720313,
         0.038182509815766146,
         -0.08820612431193614,
         0.02561976558777299,
         0.11180017391648579,
         0.04183179465772295,
         -0.12124005927085986,
         0.00898691110864761,
         0.07736188867977609,
         -0.07394011231643206,
         0.0066615417181796754,
         0.061064132416641485,
         -0.07692085808417257,
         0.030100046823668805,
         0.043569629017203744,
         -0.0826675587017559,
         0.0421523494961334,
         0.056872038674157015,
         -0.09667271939940618,
         -0.08215601377494214,
         0.11888565924062684,
         -0.06563111915333435,
         -0.02614177741032221,
         0.08123804067513837,
         -0.06905798247845775,
         0.00666154171817901,
         0.05915909134335796,
         -0.08069208216640514,
         0.038182509815766146,
         0.0421523494961334,
         -0.0919839677553639,
         0.03797663080170268,
         0.11392989240510751,
         -0.10180759621425224,
         0.10047672073342073,
         -0.04050962336990129,
         -0.03486206832513697,
         0.08123804067513839,
         -0.07394011231643174,
         0.018578152235632032,
         0.051152370625975635,
         -0.08820612431193611,
         0.05687203867415703,
         0.03797663080170268,
         -0.12595423517110133,
         0.07518989286620481,
         -0.105681533049564,
         0.0921513271014774,
         -0.04050962336990128,
         -0.026141777410322208,
         0.0773618886797761,
         -0.08778250653852852,
         0.04853486714565542,
         0.02561976558777298,
         -0.09667271939940618,
         0.11392989240510752,
         -0.04582443510991799,
         0.08371337425845098,
         -0.10568153304956399,
         0.10047672073342069,
         -0.06563111915333435,
         0.008986911108647608,
         0.05291349989234761,
         -0.09928627607148914,
         0.11180017391648585,
         -0.08215601377494212,
         0.020206676545143278,
         -0.04582443510991799,
         0.0751898928662048,
         -0.10180759621425231,
         0.11888565924062681,
         -0.12124005927085983,
         0.10692368192314167,
         -0.07826012174154004,
         0.04183179465772293},
        {0.061384981404485034,
         -0.09705817768262781,
         0.11570102717256733,
         -0.11782415888942958,
         0.10692368192314214,
         -0.08784676878121818,
         0.06547711553283675,
         -0.04387355637185685,
         0.025812936931247327,
         -0.012665204790798905,
         0.0045183502354290955,
         -0.10882394085641127,
         0.11005362893715089,
         -0.06732809079395956,
         0.008416011349244948,
         0.04582443510991835,
         -0.08306885837244171,
         0.09899209386613186,
         -0.09545666194234181,
         0.07818637259205921,
         -0.05443464275830633,
         0.03098297304294252,
         -0.012665204790798903,
         0.12805278414759366,
         -0.04772245501035454,
         -0.03968108674830995,
         0.08490134266470714,
         -0.08086238513640935,
         0.04153037790314742,
         0.011888565924062318,
         -0.05981369584695783,
         0.08920166700025052,
         -0.09529847079198911,
         0.08098273883499829,
         -0.05443464275830631,
         0.025812936931247324,
         -0.10882394085641126,
         -0.04772245501035453,
         0.09289925365954378,
         -0.05145798439719179,
         -0.01764994303680702,
         0.06874504490624452,
         -0.0804929399667088,
         0.0536413841993994,
         -0.0034614386137878854,
         -0.04914539579371755,
         0.08560039347120672,
         -0.09529847079198911,
         0.07818637259205921,
         -0.04387355637185686,
         0.06138498140448511,
         0.11005362893715089,
         -0.039681086748309946,
         -0.05145798439719178,
         0.08278557097982665,
         -0.05235819233875788,
         -0.0075104595172426495,
         0.05961242434332307,
         -0.07863425732016562,
         0.057812200025107494,
         -0.007894699861903757,
         -0.04914539579371756,
         0.08920166700025053,
         -0.09545666194234181,
         0.06547711553283675,
         -0.09705817768262737,
         -0.06732809079395956,
         0.08490134266470714,
         -0.017649943036807024,
         -0.05235819233875788,
         0.07805098483231472,
         -0.05257321662069437,
         -0.002755585290059365,
         0.055488083397779775,
         -0.07785465021047097,
         0.05781220002510748,
         -0.003461438613787885,
         -0.05981369584695783,
         0.09899209386613185,
         -0.08784676878121817,
         0.11570102717256733,
         0.008416011349244946,
         -0.08086238513640935,
         0.06874504490624452,
         -0.007510459517242648,
         -0.05257321662069437,
         0.07576606905360067,
         -0.05260931220793363,
         -0.0013406094105117255,
         0.05548808339777978,
         -0.07863425732016562,
         0.05364138419939939,
         0.01188856592406232,
         -0.08306885837244173,
         0.10692368192314217,
         -0.11782415888942958,
         0.04582443510991836,
         0.04153037790314742,
         -0.0804929399667088,
         0.059612424343322624,
         -0.0027555852900586434,
         -0.052609312207933634,
         0.07507412698866836,
         -0.052609312207933634,
         -0.002755585290058698,
         0.059612424343322624,
         -0.0804929399667088,
         0.04153037790314742,
         0.04582443510991836,
         -0.11782415888942958,
         0.10692368192314217,
         -0.08306885837244173,
         0.01188856592406232,
         0.05364138419939939,
         -0.07863425732016562,
         0.05548808339777978,
         -0.00134060941051167,
         -0.052609312207933634,
         0.07576606905360067,
         -0.05257321662069437,
         -0.007510459517242648,
         0.06874504490624452,
         -0.08086238513640934,
         0.008416011349244948,
         0.11570102717256733,
         -0.08784676878121819,
         0.09899209386613184,
         -0.05981369584695783,
         -0.003461438613787885,
         0.057812200025107466,
         -0.07785465021047096,
         0.05548808339777978,
         -0.0027555852900593087,
         -0.05257321662069437,
         0.07805098483231473,
         -0.05235819233875788,
         -0.017649943036807024,
         0.08490134266470714,
         -0.06732809079395957,
         -0.09705817768262737,
         0.06547711553283675,
         -0.09545666194234183,
         0.08920166700025053,
         -0.04914539579371756,
         -0.007894699861903758,
         0.057812200025107466,
         -0.07863425732016562,
         0.05961242434332307,
         -0.007510459517242648,
         -0.05235819233875788,
         0.08278557097982663,
         -0.05145798439719179,
         -0.03968108674830994,
         0.11005362893715087,
         0.06138498140448511,
         -0.04387355637185685,
         0.07818637259205921,
         -0.09529847079198914,
         0.08560039347120674,
         -0.049145395793717565,
         -0.0034614386137878854,
         0.0536413841993994,
         -0.08049293996670881,
         0.06874504490624452,
         -0.017649943036807024,
         -0.05145798439719179,
         0.09289925365954375,
         -0.04772245501035453,
         -0.10882394085641128,
         0.02581293693124732,
         -0.054434642758306326,
         0.08098273883499825,
         -0.09529847079198914,
         0.08920166700025053,
         -0.05981369584695783,
         0.01188856592406232,
         0.041530377903147425,
         -0.08086238513640935,
         0.08490134266470711,
         -0.03968108674830994,
         -0.04772245501035453,
         0.12805278414759366,
         -0.012665204790798903,
         0.03098297304294252,
         -0.054434642758306326,
         0.07818637259205921,
         -0.09545666194234181,
         0.09899209386613184,
         -0.08306885837244174,
         0.04582443510991836,
         0.008416011349244948,
         -0.06732809079395956,
         0.11005362893715087,
         -0.10882394085641128,
         0.0045183502354290955,
         -0.012665204790798903,
         0.025812936931247317,
         -0.04387355637185685,
         0.06547711553283675,
         -0.08784676878121819,
         0.10692368192314215,
         -0.11782415888942958,
         0.11570102717256733,
         -0.09705817768262737,
         0.06138498140448511},
        {0.10183501544346303,
         -0.12472191289246459,
         0.12198043717391815,
         -0.10617034287843423,
         0.08512565307587484,
         -0.06370220572706066,
         0.044647388168594246,
         -0.02922857655209428,
         0.01772242770746119,
         -0.009796440513307884,
         0.004799256110626631,
         -0.0019719697114452795,
         0.0005907475902487069,
         -0.1387777332977426,
         0.06666666666666667,
         0.00982946374365938,
         -0.06420578831241004,
         0.09287970209589229,
         -0.10010346614252345,
         0.09248387549208827,
         -0.07653837971759027,
         0.05760665322049436,
         -0.039470983656660324,
         0.024370447819255455,
         -0.01322999006069108,
         0.005991868415379738,
         -0.0019719697114452795,
         0.10183501544346299,
         0.06666666666666667,
         -0.10024125487414767,
         0.06786365036054005,
         -0.01339530113426212,
         -0.03788763307229149,
         0.07388216274013472,
         -0.09126620103193168,
         0.09202994824699037,
         -0.08083472430530711,
         0.06310303076624879,
         -0.0437435791498477,
         0.026414856535406425,
         -0.01322999006069108,
         0.004799256110626631,
         -0.12472191289246476,
         0.00982946374365938,
         0.06786365036054004,
         -0.08885437563234136,
         0.06697650567131218,
         -0.023065262720448603,
         -0.02439191823242274,
         0.0626080973932322,
         -0.0850579824707033,
         0.0906355550917333,
         -0.08215432330459219,
         0.06464466487578717,
         -0.0437435791498477,
         0.024370447819255465,
         -0.009796440513307884,
         0.12198043717391813,
         -0.06420578831241004,
         -0.01339530113426212,
         0.06697650567131218,
         -0.08321974751420083,
         0.06605362682764811,
         -0.027748073437372605,
         -0.017303963990948214,
         0.05664051772236406,
         -0.08198679420542293,
         0.0900468112564812,
         -0.08215432330459219,
         0.06310303076624878,
         -0.03947098365666033,
         0.017722427707461193,
         -0.10617034287843426,
         0.09287970209589229,
         -0.03788763307229148,
         -0.0230652627204486,
         0.06605362682764808,
         -0.0801017883428009,
         0.0654028363080938,
         -0.02997134480466414,
         -0.014200529311348596,
         0.05477074086734467,
         -0.08198679420542293,
         0.09063555509173327,
         -0.08083472430530711,
         0.057606653220494373,
         -0.02922857655209428,
         0.08512565307587486,
         -0.10010346614252345,
         0.07388216274013472,
         -0.024391918232422743,
         -0.02774807343737261,
         0.0654028363080938,
         -0.07848340356971305,
         0.0650750004776942,
         -0.03063448218004057,
         -0.014200529311348596,
         0.05664051772236409,
         -0.0850579824707033,
         0.09202994824699037,
         -0.07653837971759024,
         0.044647388168594246,
         -0.06370220572706065,
         0.0924838754920883,
         -0.0912662010319317,
         0.06260809739323221,
         -0.017303963990948214,
         -0.02997134480466414,
         0.0650750004776942,
         -0.07797868191282875,
         0.0650750004776942,
         -0.02997134480466414,
         -0.017303963990948214,
         0.06260809739323221,
         -0.09126620103193168,
         0.0924838754920883,
         -0.06370220572706065,
         0.044647388168594246,
         -0.07653837971759025,
         0.09202994824699037,
         -0.0850579824707033,
         0.05664051772236409,
         -0.014200529311348596,
         -0.03063448218004057,
         0.0650750004776942,
         -0.07848340356971306,
         0.0654028363080938,
         -0.027748073437372612,
         -0.024391918232422743,
         0.07388216274013472,
         -0.10010346614252345,
         0.08512565307587486,
         -0.02922857655209428,
         0.057606653220494373,
         -0.08083472430530712,
         0.09063555509173328,
         -0.08198679420542293,
         0.05477074086734466,
         -0.014200529311348596,
         -0.02997134480466415,
         0.0654028363080938,
         -0.08010178834280088,
         0.06605362682764811,
         -0.0230652627204486,
         -0.03788763307229149,
         0.0928797020958923,
         -0.10617034287843423,
         0.01772242770746119,
         -0.03947098365666033,
         0.06310303076624878,
         -0.08215432330459219,
         0.0900468112564812,
         -0.08198679420542293,
         0.05664051772236407,
         -0.017303963990948214,
         -0.027748073437372612,
         0.06605362682764808,
         -0.08321974751420085,
         0.06697650567131218,
         -0.01339530113426212,
         -0.06420578831241004,
         0.12198043717391813,
         -0.009796440513307882,
         0.024370447819255465,
         -0.04374357914984772,
         0.06464466487578717,
         -0.0821543233045922,
         0.09063555509173328,
         -0.0850579824707033,
         0.0626080973932322,
         -0.024391918232422743,
         -0.0230652627204486,
         0.06697650567131218,
         -0.08885437563234136,
         0.06786365036054003,
         0.009829463743659382,
         -0.12472191289246473,
         0.004799256110626629,
         -0.01322999006069108,
         0.026414856535406418,
         -0.043743579149847715,
         0.06310303076624879,
         -0.08083472430530712,
         0.09202994824699036,
         -0.09126620103193167,
         0.07388216274013473,
         -0.03788763307229148,
         -0.01339530113426212,
         0.06786365036054003,
         -0.10024125487414767,
         0.0666666666666667,
         0.10183501544346299,
         -0.0019719697114452795,
         0.005991868415379738,
         -0.01322999006069108,
         0.02437044781925546,
         -0.039470983656660324,
         0.05760665322049436,
         -0.07653837971759024,
         0.09248387549208828,
         -0.10010346614252345,
         0.09287970209589229,
         -0.06420578831241004,
         0.009829463743659382,
         0.0666666666666667,
         -0.13877773329774257,
         0.0005907475902487067,
         -0.0019719697114452795,
         0.004799256110626629,
         -0.009796440513307882,
         0.01772242770746119,
         -0.029228576552094272,
         0.044647388168594246,
         -0.06370220572706065,
         0.08512565307587487,
         -0.10617034287843422,
         0.12198043717391813,
         -0.12472191289246473,
         0.10183501544346299},
        {0.029873876758562977,
         -0.05891207944471455,
         0.08572966806188387,
         -0.10499697128489555,
         0.11340969083593082,
         -0.11012175251466583,
         0.09658316614313148,
         -0.07599122874479329,
         0.05249848564244767,
         -0.03031001481771495,
         0.01277982436499099,
         -0.06486337389944213,
         0.09785762207687186,
         -0.10260876789917556,
         0.07937024983852124,
         -0.03622739685948242,
         -0.014490958743793022,
         0.05998384491085399,
         -0.09012551420690484,
         0.09959004868677797,
         -0.08873863701503737,
         0.063187707027388,
         -0.032040715337120676,
         0.09853453834474801,
         -0.10194255765124445,
         0.05645859112519754,
         0.007337782193312029,
         -0.06028603244005216,
         0.08321996146843917,
         -0.07047048484647149,
         0.029093477918847543,
         0.024965233007032184,
         -0.07250453954955478,
         0.09722561406138604,
         -0.09111366825519313,
         0.057591073327519476,
         -0.11842377680205432,
         0.06193283577302911,
         0.02262506452152579,
         -0.075424813975996,
         0.07578428862078813,
         -0.033625942333952524,
         -0.024230070296515027,
         0.06825268836687497,
         -0.07771681300301977,
         0.047666112373757445,
         0.00962407717662284,
         -0.06883449848332628,
         0.10078437832315942,
         -0.08477176461063439,
         0.11570102717256714,
         0.008416011349244978,
         -0.08086238513640934,
         0.06874504490624439,
         -0.007510459517242644,
         -0.05257321662069412,
         0.07576606905359987,
         -0.05260931220793284,
         -0.001340609410511725,
         0.05548808339777991,
         -0.07863425732016642,
         0.05364138419939981,
         0.011888565924062313,
         -0.0830688583724418,
         0.10692368192314222,
         -0.08962163027568891,
         -0.07713401811504479,
         0.07552375519737421,
         0.003922209563735503,
         -0.06667756258349437,
         0.07109196433879081,
         -0.02525535635120062,
         -0.03507287480528889,
         0.07138037007506408,
         -0.06195233797906535,
         0.011694437202673241,
         0.04961643792592573,
         -0.08042323099029411,
         0.049496046933066536,
         0.03780323027864375,
         -0.11712902504162438,
         0.04878383646484586,
         0.10923537499252912,
         -0.005400461468377846,
         -0.0750533700248183,
         0.06614995030345494,
         -0.0026793792195578467,
         -0.05668741944259834,
         0.0719976309692017,
         -0.03764999030801554,
         -0.021615821836995456,
         0.06705143763863103,
         -0.06722907932715409,
         0.01703728997676386,
         0.05300528400277257,
         -0.08453059267212584,
         0.023908862118471125,
         0.11043030384093548,
         -0.0860465995237512,
         -0.08116278541056066,
         0.06999798085659721,
         0.013943931552574918,
         -0.07118447181362746,
         0.06470319955806887,
         -0.011068172298292123,
         -0.04756273058204773,
         0.07224011237680754,
         -0.047562730582047734,
         -0.011068172298292125,
         0.06470319955806887,
         -0.07118447181362741,
         0.013943931552574918,
         0.06999798085659721,
         -0.08116278541056066,
         -0.08604659952375121,
         0.11043030384093548,
         0.023908862118471125,
         -0.08453059267212584,
         0.05300528400277257,
         0.01703728997676386,
         -0.06722907932715409,
         0.06705143763863114,
         -0.021615821836995456,
         -0.03764999030801565,
         0.07199763096920167,
         -0.05668741944259834,
         -0.0026793792195578467,
         0.06614995030345494,
         -0.07505337002481831,
         -0.005400461468377847,
         0.10923537499252911,
         0.04878383646484586,
         -0.11712902504162438,
         0.03780323027864375,
         0.049496046933066536,
         -0.08042323099029411,
         0.04961643792592573,
         0.011694437202673243,
         -0.06195233797906535,
         0.0713803700750642,
         -0.035072874805288895,
         -0.02525535635120062,
         0.07109196433879082,
         -0.06667756258349437,
         0.003922209563735502,
         0.07552375519737421,
         -0.07713401811504476,
         -0.08962163027568892,
         0.10692368192314222,
         -0.0830688583724418,
         0.011888565924062313,
         0.05364138419939981,
         -0.07863425732016645,
         0.05548808339777991,
         -0.0013406094105117249,
         -0.05260931220793274,
         0.07576606905359987,
         -0.05257321662069414,
         -0.0075104595172426425,
         0.06874504490624439,
         -0.08086238513640932,
         0.008416011349244976,
         0.11570102717256717,
         -0.08477176461063439,
         0.10078437832315941,
         -0.06883449848332629,
         0.00962407717662284,
         0.04766611237375745,
         -0.07771681300301977,
         0.06825268836687498,
         -0.024230070296515024,
         -0.033625942333952524,
         0.07578428862078813,
         -0.075424813975996,
         0.022625064521525795,
         0.06193283577302911,
         -0.11842377680205432,
         0.05759107332751947,
         -0.09111366825519315,
         0.09722561406138601,
         -0.07250453954955477,
         0.024965233007032177,
         0.029093477918847543,
         -0.0704704848464715,
         0.08321996146843919,
         -0.06028603244005216,
         0.0073377821933120315,
         0.05645859112519755,
         -0.10194255765124442,
         0.09853453834474801,
         -0.03204071533712067,
         0.06318770702738799,
         -0.08873863701503738,
         0.09959004868677794,
         -0.09012551420690484,
         0.059983844910854005,
         -0.01449095874379302,
         -0.03622739685948242,
         0.07937024983852126,
         -0.10260876789917557,
         0.09785762207687188,
         -0.06486337389944213,
         0.01277982436499099,
         -0.03031001481771495,
         0.05249848564244767,
         -0.07599122874479329,
         0.09658316614313146,
         -0.11012175251466584,
         0.1134096908359308,
         -0.10499697128489553,
         0.08572966806188388,
         -0.05891207944471477,
         0.02987387675856297},
        {0.049798304946286655,
         -0.0822391939658611,
         0.10309228547118117,
         -0.1113523950241608,
         0.10838246260280045,
         -0.09694022157947628,
         0.08030691489721398,
         -0.061647560945578904,
         0.04359140838822972,
         -0.02800382145606106,
         0.015917331791768897,
         -0.007588290192030593,
         0.002641903538680597,
         -0.09597369473202222,
         0.10782582722944131,
         -0.08139569275564824,
         0.03557021781877608,
         0.013654906787036908,
         -0.054959939644026776,
         0.0820899294964398,
         -0.09329056959284258,
         0.09024278883583467,
         -0.07680391001735756,
         0.05776493356705294,
         -0.037767606054982375,
         0.02047627420205757,
         -0.008050532635440552,
         0.12198043717391772,
         -0.06420578831240978,
         -0.013395301134262329,
         0.06697650567131219,
         -0.08321974751420105,
         0.06605362682764815,
         -0.027748073437372626,
         -0.01730396399094815,
         0.05664051772236397,
         -0.08198679420542282,
         0.09004681125648098,
         -0.08215432330459196,
         0.06310303076624861,
         -0.03947098365666023,
         0.01772242770746116,
         -0.11135239502416108,
         -0.026006316586850067,
         0.08544932592822062,
         -0.06917303761390907,
         0.01536546420067002,
         0.0394745922673516,
         -0.0719431199389027,
         0.07341450167644416,
         -0.047388857060496836,
         0.0050459383696807155,
         0.03954894643432804,
         -0.07368930773603004,
         0.08915448902243756,
         -0.08388229468880226,
         0.06202849697611402,
         -0.032356578097103565,
         0.06714802069137818,
         0.10021204279284233,
         -0.058076320691250204,
         -0.024584295005333386,
         0.07296818570631604,
         -0.07032189735230902,
         0.030640410006182593,
         0.020869365797744174,
         -0.06062002963543066,
         0.07382825656597926,
         -0.05711072745607819,
         0.017549787792663845,
         0.03071247714172066,
         -0.07129208201605247,
         0.09072964092233592,
         -0.08292494062794127,
         0.05162324009090105,
         -0.10122945002196446,
         -0.04686012975962793,
         0.08615130035281662,
         -0.04410368608079369,
         -0.02086331512764583,
         0.06523660842094459,
         -0.0705513331897957,
         0.04041335309028687,
         0.007637405851653807,
         -0.051470162688284596,
         0.0726307775522934,
         -0.062158863058927136,
         0.02318156211184569,
         0.030017582216942826,
         -0.07632437251238303,
         0.09490817215125283,
         -0.07373273487173075,
         0.11478340719169716,
         -0.014818474149145831,
         -0.06330911328535126,
         0.07741092613089214,
         -0.0400915391542919,
         -0.01595402049885723,
         0.05915909134335754,
         -0.07055133318979724,
         0.04758256138616625,
         -0.0022216238855872258,
         -0.04483697250598712,
         0.0720090751800377,
         -0.06486687747110285,
         0.02256419997542386,
         0.03917928453239174,
         -0.09030378888782781,
         0.09518855140951353,
         -0.11089130652174368,
         0.06360052616387775,
         0.013219121124473687,
         -0.06584085333649345,
         0.07321197852736622,
         -0.040870015642724244,
         -0.009859848557225681,
         0.053540116026859604,
         -0.07053437169581585,
         0.053540116026859604,
         -0.009859848557225683,
         -0.040870015642724244,
         0.07321197852736616,
         -0.06584085333649345,
         0.013219121124473689,
         0.06360052616387775,
         -0.11089130652174368,
         0.09518855140951353,
         -0.09030378888782781,
         0.039179284532391744,
         0.02256419997542386,
         -0.06486687747110291,
         0.07200907518003763,
         -0.04483697250598712,
         -0.0022216238855872258,
         0.04758256138616623,
         -0.07055133318979724,
         0.05915909134335754,
         -0.01595402049885723,
         -0.0400915391542919,
         0.07741092613089214,
         -0.06330911328535123,
         -0.014818474149145831,
         0.11478340719169718,
         -0.07373273487173075,
         0.09490817215125283,
         -0.076324372512383,
         0.030017582216942826,
         0.02318156211184569,
         -0.062158863058927136,
         0.07263077755229341,
         -0.0514701626882846,
         0.007637405851653807,
         0.040413353090286874,
         -0.07055133318979571,
         0.06523660842094459,
         -0.020863315127645825,
         -0.04410368608079368,
         0.08615130035281664,
         -0.04686012975962793,
         -0.10122945002196447,
         0.051623240090901044,
         -0.0829249406279413,
         0.09072964092233592,
         -0.07129208201605246,
         0.03071247714172066,
         0.0175497877926639,
         -0.05711072745607818,
         0.0738282565659792,
         -0.06062002963543066,
         0.02086936579774417,
         0.030640410006182638,
         -0.07032189735230904,
         0.07296818570631605,
         -0.02458429500533339,
         -0.058076320691250204,
         0.10021204279284233,
         0.06714802069137817,
         -0.03235657809710357,
         0.06202849697611402,
         -0.08388229468880226,
         0.08915448902243756,
         -0.07368930773603007,
         0.03954894643432804,
         0.0050459383696807155,
         -0.047388857060496836,
         0.07341450167644416,
         -0.07194311993890268,
         0.0394745922673516,
         0.015365464200670016,
         -0.06917303761390906,
         0.0854493259282206,
         -0.026006316586850067,
         -0.11135239502416111,
         0.01772242770746116,
         -0.03947098365666024,
         0.06310303076624861,
         -0.08215432330459199,
         0.090046811256481,
         -0.08198679420542286,
         0.056640517722363955,
         -0.017303963990948145,
         -0.02774807343737264,
         0.06605362682764815,
         -0.08321974751420105,
         0.0669765056713122,
         -0.013395301134262327,
         -0.06420578831240979,
         0.1219804371739177,
         -0.008050532635440555,
         0.020476274202057578,
         -0.03776760605498238,
         0.057764933567052944,
         -0.07680391001735755,
         0.09024278883583461,
         -0.0932905695928426,
         0.08208992949643978,
         -0.05495993964402679,
         0.013654906787036908,
         0.03557021781877608,
         -0.08139569275564829,
         0.10782582722944131,
         -0.09597369473202222,
         0.0026419035386805972,
         -0.007588290192030593,
         0.015917331791768897,
         -0.028003821456061066,
         0.043591408388229703,
         -0.06164756094557893,
         0.08030691489721394,
         -0.0969402215794763,
         0.10838246260280046,
         -0.11135239502416082,
         0.10309228547118117,
         -0.08223919396586137,
         0.04979830494628664},
        {0.021979349113192857,
         -0.045044261646144945,
         0.06854708804857412,
         -0.08849391014771374,
         0.10180759621425195,
         -0.10677670772044154,
         0.1031560999529778,
         -0.0920299482469907,
         0.07550253410189811,
         -0.05627626624178017,
         0.03717487798128229,
         -0.020667724684415932,
         0.008437563270190572,
         -0.051879778210431576,
         0.08406510999883719,
         -0.09764582085806364,
         0.08974920561468401,
         -0.0630982902763826,
         0.024336670328567588,
         0.01804855776716713,
         -0.055699058509163665,
         0.08200255938087977,
         -0.09320235154040002,
         0.08891122720762984,
         -0.07199507418974867,
         0.047836487323493916,
         -0.02299692105105881,
         0.08512565307587479,
         -0.10010346614252347,
         0.07388216274013494,
         -0.02439191823242303,
         -0.02774807343737218,
         0.06540283630809336,
         -0.07848340356971287,
         0.06507500047769417,
         -0.03063448218004048,
         -0.014200529311348927,
         0.0566405177223643,
         -0.08505798247070341,
         0.09202994824699057,
         -0.07653837971759025,
         0.044647388168594246,
         -0.10989674556596454,
         0.07613869876268803,
         -0.005905064195547807,
         -0.05322752935488179,
         0.0769068187463662,
         -0.062046578450620025,
         0.02068219281687412,
         0.02774807343737282,
         -0.0638112879390042,
         0.07396309277491184,
         -0.05415869378342494,
         0.010800922936755086,
         0.041057716440746926,
         -0.0820388989416684,
         0.09471141280884321,
         -0.07059371909520604,
         0.1147834071916971,
         -0.014818474149145822,
         -0.06330911328535128,
         0.07741092613089219,
         -0.04009153915429193,
         -0.01595402049885713,
         0.05915909134335725,
         -0.07055133318979684,
         0.04758256138616628,
         -0.0022216238855874504,
         -0.04483697250598715,
         0.07200907518003848,
         -0.06486687747110352,
         0.022564199975424373,
         0.039179284532391855,
         -0.09030378888782764,
         0.0951885514095135,
         -0.09465282238392977,
         -0.05807632069125048,
         0.08227010514679298,
         -0.025801082539379763,
         -0.04020156092667822,
         0.07139100544178838,
         -0.05707883895979066,
         0.011831818268672559,
         0.03791187466544667,
         -0.06698448048894567,
         0.061410559242425306,
         -0.023435328540201434,
         -0.029079770144564962,
         0.06883449848332651,
         -0.06997758220226426,
         0.021901885881058163,
         0.057113130845707724,
         -0.11100797284177627,
         0.05464783248291961,
         0.10368697190241671,
         -0.02884648722556727,
         -0.05507337617264652,
         0.07472461956132728,
         -0.03686952853918808,
         -0.02097557190755635,
         0.061789655697124544,
         -0.06536394893543027,
         0.03286110513581863,
         0.017208624620830778,
         -0.05841911175812028,
         0.06809209357186896,
         -0.038015278251641985,
         -0.018967589563784314,
         0.06969137412271677,
         -0.07197694169375748,
         0.11100797284177617,
         -0.09144331395037858,
         -0.06293560493244721,
         0.07931472674684394,
         -0.016659424835059774,
         -0.048091617065329814,
         0.07149589595435142,
         -0.04792849048273234,
         -0.0022670605696748576,
         0.049113832356464646,
         -0.06787173080950158,
         0.04911383235646454,
         -0.0022670605696749687,
         -0.047928490482732226,
         0.07149589595435148,
         -0.048091617065329814,
         -0.016659424835059774,
         0.07931472674684392,
         -0.06293560493244722,
         -0.0914433139503786,
         0.11100797284177617,
         -0.07197694169375748,
         0.06969137412271674,
         -0.01896758956378431,
         -0.038015278251641985,
         0.06809209357186882,
         -0.05841911175812039,
         0.017208624620830778,
         0.03286110513581863,
         -0.0653639489354304,
         0.061789655697124544,
         -0.020975571907556237,
         -0.03686952853918808,
         0.07472461956132727,
         -0.055073376172646515,
         -0.02884648722556727,
         0.10368697190241669,
         0.05464783248291961,
         -0.11100797284177627,
         0.057113130845707724,
         0.02190188588105816,
         -0.06997758220226424,
         0.06883449848332658,
         -0.02907977014456496,
         -0.023435328540201326,
         0.061410559242425306,
         -0.06698448048894556,
         0.03791187466544667,
         0.011831818268672559,
         -0.05707883895979068,
         0.07139100544178857,
         -0.04020156092667822,
         -0.025801082539379766,
         0.08227010514679298,
         -0.05807632069125048,
         -0.09465282238392977,
         0.09518855140951352,
         -0.09030378888782764,
         0.03917928453239185,
         0.022564199975424377,
         -0.06486687747110359,
         0.07200907518003842,
         -0.04483697250598715,
         -0.0022216238855873385,
         0.04758256138616627,
         -0.07055133318979684,
         0.05915909134335725,
         -0.01595402049885713,
         -0.04009153915429193,
         0.07741092613089219,
         -0.0633091132853513,
         -0.014818474149145826,
         0.11478340719169709,
         -0.07059371909520604,
         0.09471141280884321,
         -0.08203889894166841,
         0.04105771644074694,
         0.010800922936755088,
         -0.05415869378342492,
         0.07396309277491182,
         -0.06381128793900417,
         0.027748073437372824,
         0.020682192816874122,
         -0.06204657845062004,
         0.0769068187463662,
         -0.05322752935488179,
         -0.005905064195547807,
         0.07613869876268801,
         -0.10989674556596457,
         0.044647388168594246,
         -0.07653837971759024,
         0.09202994824699053,
         -0.08505798247070341,
         0.0566405177223643,
         -0.014200529311348927,
         -0.030634482180040487,
         0.06507500047769417,
         -0.07848340356971287,
         0.06540283630809333,
         -0.02774807343737219,
         -0.02439191823242303,
         0.07388216274013495,
         -0.10010346614252347,
         0.0851256530758748,
         -0.0229969210510588,
         0.04783648732349391,
         -0.07199507418974867,
         0.08891122720762988,
         -0.09320235154040002,
         0.08200255938087979,
         -0.055699058509163665,
         0.01804855776716713,
         0.024336670328567594,
         -0.0630982902763826,
         0.089749205614684,
         -0.09764582085806367,
         0.08406510999883722,
         -0.05187977821043157,
         0.008437563270190572,
         -0.02066772468441593,
         0.03717487798128229,
         -0.05627626624178017,
         0.07550253410189811,
         -0.09202994824699069,
         0.10315609995297777,
         -0.10677670772044154,
         0.10180759621425194,
         -0.08849391014771373,
         0.06854708804857412,
         -0.045044261646144994,
         0.021979349113192857},
        {0.04105878413676263,
         -0.07012122325992842,
         0.09130990043641402,
         -0.10301146046034651,
         0.10543559119328287,
         -0.10002498438514941,
         0.08887453087262077,
         -0.07427341365270758,
         0.05837186557604567,
         -0.04296052984075588,
         0.029347628943850824,
         -0.018318431474131435,
         0.010161237533239156,
         -0.0047437715163086615,
         0.0016218088097740366,
         -0.0849997585237563,
         0.10303725437476279,
         -0.08842122519898434,
         0.054069753382871094,
         -0.012015500751749142,
         -0.028178847044087393,
         0.06009015032319744,
         -0.08041028983713365,
         0.08851222466396919,
         -0.08580295507629518,
         0.07499804948216131,
         -0.05941231770891441,
         0.0423336507607623,
         -0.026526510137397073,
         0.013894351874447236,
         -0.005308615452525565,
         0.1154919293811426,
         -0.07485969923457954,
         0.008031423762459603,
         0.04722600034785833,
         -0.0755897464064127,
         0.07540587421385628,
         -0.05279396641457463,
         0.01732268819054103,
         0.021066559265679085,
         -0.054078950326922635,
         0.07619159963915088,
         -0.08504031096481349,
         0.08122043080626774,
         -0.06765341344355813,
         0.04866975616011091,
         -0.028956118659801938,
         0.01249326174580981,
         -0.11223798074405242,
         -0.007858230455371219,
         0.07425200694829204,
         -0.0767281103552495,
         0.039126186913277204,
         0.010798535200915872,
         -0.05164385257585912,
         0.07137889226658865,
         -0.06697840871405102,
         0.04241780176467755,
         -0.005996395783494276,
         -0.0324095326080788,
         0.06376904426367783,
         -0.08173362807773735,
         0.08372713667110769,
         -0.07120643458716906,
         0.049078167220003355,
         -0.02428253608317612,
         0.07178765369081744,
         0.08980101256291832,
         -0.06951884996198439,
         -0.0013406353518480062,
         0.056664772956881215,
         -0.07336252673938105,
         0.05397458930380973,
         -0.013551812562202266,
         -0.029698987662141726,
         0.06050281976333181,
         -0.06983887270682548,
         0.05599843380457866,
         -0.02387939955383746,
         -0.01698149780734767,
         0.05513738537826189,
         -0.08021877599277309,
         0.0856751696109279,
         -0.07075307253414266,
         0.04109159292125622,
         -0.10361655295721292,
         -0.028807393101983072,
         0.08118462676164573,
         -0.06033548671149438,
         0.006667621831579062,
         0.04336074569375678,
         -0.06811684760702556,
         0.061750381336499606,
         -0.030772197324073807,
         -0.011095277724621858,
         0.04827640666066578,
         -0.0679617159417662,
         0.06338931326153577,
         -0.03543702648505142,
         -0.007625486578262923,
         0.052191597489868506,
         -0.08295463124037401,
         0.08766206489867963,
         -0.06204694464740555,
         0.11226570409404772,
         -0.032571584354845785,
         -0.04437017707188264,
         0.07507790715942314,
         -0.05905621061911439,
         0.01563162914624266,
         0.03108409694840052,
         -0.061555102620075935,
         0.06561093748979151,
         -0.04358750392242463,
         0.0047037389734182625,
         0.03645234118558772,
         -0.0644582336498147,
         0.06774370920107924,
         -0.04256240682544679,
         -0.0046168587466287195,
         0.057156140927364596,
         -0.09154720716390957,
         0.08443519693603099,
         -0.10341157441234267,
         0.07446484433116665,
         -0.010216492356522668,
         -0.045991015976042694,
         0.07110762324363996,
         -0.06104538964315827,
         0.02554385011698526,
         0.0184955218602641,
         -0.05354618430899999,
         0.06678646810947764,
         -0.05354618430899999,
         0.0184955218602641,
         0.02554385011698526,
         -0.06104538964315828,
         0.07110762324363995,
         -0.045991015976042694,
         -0.01021649235652267,
         0.07446484433116665,
         -0.10341157441234267,
         0.084435196936031,
         -0.0915472071639096,
         0.057156140927364596,
         -0.0046168587466287195,
         -0.04256240682544679,
         0.06774370920107929,
         -0.0644582336498147,
         0.03645234118558771,
         0.004703738973418152,
         -0.04358750392242463,
         0.06561093748979151,
         -0.061555102620075935,
         0.03108409694840052,
         0.01563162914624266,
         -0.0590562106191144,
         0.07507790715942314,
         -0.04437017707188264,
         -0.03257158435484579,
         0.11226570409404771,
         -0.062046944647405566,
         0.08766206489867963,
         -0.08295463124037401,
         0.052191597489868506,
         -0.0076254865782628654,
         -0.03543702648505142,
         0.06338931326153571,
         -0.06796171594176614,
         0.04827640666066579,
         -0.011095277724621858,
         -0.030772197324073807,
         0.06175038133649972,
         -0.06811684760702556,
         0.04336074569375678,
         0.006667621831579062,
         -0.060335486711494364,
         0.08118462676164576,
         -0.028807393101983072,
         -0.10361655295721292,
         0.04109159292125622,
         -0.07075307253414267,
         0.08567516961092791,
         -0.0802187759927731,
         0.0551373853782619,
         -0.016981497807347673,
         -0.023879399553837465,
         0.055998433804578654,
         -0.06983887270682548,
         0.06050281976333179,
         -0.029698987662141733,
         -0.013551812562202269,
         0.05397458930380973,
         -0.07336252673938105,
         0.05666477295688123,
         -0.001340635351848006,
         -0.0695188499619844,
         0.08980101256291832,
         0.07178765369081744,
         -0.02428253608317612,
         0.049078167220003355,
         -0.07120643458716908,
         0.08372713667110769,
         -0.08173362807773735,
         0.06376904426367783,
         -0.03240953260807879,
         -0.005996395783494275,
         0.04241780176467755,
         -0.06697840871405102,
         0.07137889226658865,
         -0.05164385257585913,
         0.010798535200915872,
         0.03912618691327719,
         -0.0767281103552495,
         0.07425200694829204,
         -0.007858230455371215,
         -0.1122379807440524,
         0.012493261745809808,
         -0.028956118659801938,
         0.04866975616011091,
         -0.06765341344355814,
         0.08122043080626777,
         -0.08504031096481349,
         0.07619159963915087,
         -0.054078950326922635,
         0.02106655926567908,
         0.017322688190541027,
         -0.05279396641457465,
         0.07540587421385628,
         -0.07558974640641271,
         0.04722600034785832,
         0.008031423762459603,
         -0.07485969923457954,
         0.11549192938114257,
         -0.005308615452525564,
         0.013894351874447234,
         -0.026526510137397073,
         0.0423336507607623,
         -0.059412317708914426,
         0.0749980494821613,
         -0.08580295507629519,
         0.08851222466396917,
         -0.08041028983713366,
         0.06009015032319744,
         -0.0281788470440874,
         -0.012015500751749144,
         0.054069753382871094,
         -0.08842122519898434,
         0.10303725437476276,
         -0.0849997585237563,
         0.0016218088097740366,
         -0.004743771516308663,
         0.010161237533239158,
         -0.018318431474131435,
         0.029347628943850824,
         -0.04296052984075587,
         0.05837186557604568,
         -0.07427341365270758,
         0.08887453087262077,
         -0.1000249843851494,
         0.10543559119328287,
         -0.10301146046034648,
         0.09130990043641402,
         -0.07012122325992814,
         0.04105878413676264},
        {0.016578979724809435,
         -0.034991253279883394,
         0.05506194170768978,
         -0.07387334677891498,
         0.08887453087262077,
         -0.09825449077444712,
         0.10110303691029175,
         -0.09742532412875074,
         0.08804288683155242,
         -0.0744098204042681,
         0.05837186557604567,
         -0.0418958556365356,
         0.026796679302121918,
         -0.014487755260003614,
         0.005772059857263723,
         -0.04203538576044161,
         0.07179530328897321,
         -0.08946692778758844,
         0.09119123904718301,
         -0.07700091358426558,
         0.050075125269331375,
         -0.015600537286599148,
         -0.020425897999377808,
         0.052292559508355076,
         -0.07546533156990234,
         0.08720965464588919,
         -0.08690255880002042,
         0.07601769269431372,
         -0.057787394301083796,
         0.036564334703818605,
         -0.01689886090730095,
         0.0737349443517196,
         -0.09490973979528401,
         0.08244539043778537,
         -0.04647245836058311,
         0.001025721953642392,
         0.0402631253745769,
         -0.0670941067416543,
         0.07400888066072057,
         -0.06070325089781079,
         0.031395475672520254,
         0.006490215820571535,
         -0.04406387008551217,
         0.07287213405695063,
         -0.08670022949342264,
         0.0830089381422086,
         -0.06373151034637978,
         0.03507355347968581,
         -0.10133898795372692,
         0.08384182909988064,
         -0.027843372621534235,
         -0.029760897006954664,
         0.06577952446484714,
         -0.07135958763005729,
         0.04950854909212771,
         -0.011025734215928036,
         -0.02997999657233867,
         0.06020333586392382,
         -0.07036889281071965,
         0.05724327887237911,
         -0.02425547622616692,
         -0.019320292721551127,
         0.06053650579019877,
         -0.08607499051519785,
         0.08626953477235681,
         -0.05903758776233247,
         0.11226570409404787,
         -0.032571584354845806,
         -0.04437017707188274,
         0.0750779071594233,
         -0.05905621061911453,
         0.015631629146242693,
         0.031084096948400516,
         -0.06155510262007578,
         0.06561093748979116,
         -0.04358750392242418,
         0.004703738973418126,
         0.03645234118558852,
         -0.06445823364981548,
         0.06774370920108004,
         -0.042562406825446784,
         -0.004616858746628722,
         0.05715614092736469,
         -0.09154720716390972,
         0.08443519693603115,
         -0.09787097179427899,
         -0.04061926006963912,
         0.08159642377652769,
         -0.04636178170743744,
         -0.013330039578698855,
         0.05734794005799235,
         -0.06715655431346487,
         0.04394473910703213,
         -0.0019559921410874327,
         -0.03950341820112238,
         0.06336968202464185,
         -0.06021498531522404,
         0.03101348316361856,
         0.013048055444016523,
         -0.05370214515423738,
         0.07132153337516296,
         -0.05248852257725094,
         -0.0018262930187229983,
         0.069421959620709,
         -0.10409870206718252,
         0.0595623766407538,
         0.09654384635097438,
         -0.04577360358195435,
         -0.03398451120765707,
         0.0712257376208539,
         -0.05682686516377415,
         0.011652789568130848,
         0.03573097932012441,
         -0.06274275865072317,
         0.05936900450905577,
         -0.029151454414747695,
         -0.013919869530240351,
         0.0511046297488753,
         -0.06569766536369302,
         0.04939793736459686,
         -0.006755374521562814,
         -0.043813848339808906,
         0.07396486725826273,
         -0.05587829932977547,
         -0.01900573577640124,
         0.10972966666652512,
         -0.09502867888200922,
         -0.0459032129123955,
         0.08075230855230969,
         -0.03889618274189025,
         -0.022374007772129396,
         0.061921107288082394,
         -0.06374717573765062,
         0.033199169272403226,
         0.011666611459128482,
         -0.049599379085067626,
         0.06426530890205305,
         -0.049599379085067626,
         0.01166661145912848,
         0.03319916927240312,
         -0.06374717573765072,
         0.061921107288082394,
         -0.022374007772129393,
         -0.03889618274189025,
         0.0807523085523097,
         -0.0459032129123955,
         -0.09502867888200922,
         0.10972966666652512,
         -0.019005735776401245,
         -0.05587829932977546,
         0.07396486725826273,
         -0.0438138483398089,
         -0.0067553745215628135,
         0.049397937364596856,
         -0.06569766536369309,
         0.05110462974887552,
         -0.01391986953024024,
         -0.029151454414747695,
         0.05936900450905577,
         -0.06274275865072317,
         0.035730979320124284,
         0.011652789568130848,
         -0.05682686516377416,
         0.07122573762085391,
         -0.03398451120765707,
         -0.045773603581954356,
         0.09654384635097439,
         0.059562376640753825,
         -0.10409870206718252,
         0.069421959620709,
         -0.0018262930187229983,
         -0.05248852257725094,
         0.07132153337516292,
         -0.05370214515423738,
         0.013048055444016406,
         0.031013483163618665,
         -0.06021498531522415,
         0.06336968202464185,
         -0.03950341820112227,
         -0.001955992141087322,
         0.04394473910703213,
         -0.06715655431346484,
         0.057347940057992465,
         -0.013330039578698853,
         -0.04636178170743744,
         0.08159642377652769,
         -0.04061926006963912,
         -0.09787097179427898,
         0.08443519693603117,
         -0.09154720716390971,
         0.05715614092736469,
         -0.004616858746628723,
         -0.042562406825446826,
         0.06774370920108008,
         -0.06445823364981548,
         0.036452341185588516,
         0.004703738973418239,
         -0.04358750392242417,
         0.06561093748979116,
         -0.06155510262007578,
         0.031084096948400516,
         0.01563162914624269,
         -0.059056210619114514,
         0.0750779071594233,
         -0.044370177071882747,
         -0.032571584354845806,
         0.11226570409404787,
         -0.059037587762332464,
         0.08626953477235683,
         -0.08607499051519783,
         0.06053650579019877,
         -0.01932029272155113,
         -0.024255476226166924,
         0.05724327887237911,
         -0.07036889281071966,
         0.06020333586392382,
         -0.029979996572338675,
         -0.011025734215928036,
         0.04950854909212771,
         -0.07135958763005729,
         0.06577952446484714,
         -0.02976089700695466,
         -0.027843372621534246,
         0.08384182909988062,
         -0.10133898795372695,
         0.03507355347968581,
         -0.06373151034637976,
         0.08300893814220861,
         -0.08670022949342264,
         0.0728721340569506,
         -0.04406387008551218,
         0.006490215820571536,
         0.031395475672520254,
         -0.060703250897810805,
         0.07400888066072057,
         -0.0670941067416543,
         0.0402631253745769,
         0.001025721953642392,
         -0.046472458360583106,
         0.08244539043778536,
         -0.09490973979528404,
         0.07373494435171961,
         -0.01689886090730095,
         0.03656433470381861,
         -0.0577873943010838,
         0.07601769269431373,
         -0.08690255880002042,
         0.08720965464588919,
         -0.07546533156990234,
         0.05229255950835507,
         -0.0204258979993778,
         -0.015600537286599145,
         0.050075125269331375,
         -0.07700091358426557,
         0.09119123904718299,
         -0.08946692778758844,
         0.07179530328897318,
         -0.0420353857604416,
         0.005772059857263724,
         -0.014487755260003616,
         0.026796679302121915,
         -0.041895855636535605,
         0.05837186557604566,
         -0.07440982040426812,
         0.08804288683155241,
         -0.09742532412875073,
         0.10110303691029172,
         -0.0982544907744471,
         0.08887453087262076,
         -0.073873346778915,
         0.05506194170768979,
         -0.03499125327988332,
         0.016578979724809432},
        {0.012772792738255977,
         -0.02759238591038138,
         0.04456572362626225,
         -0.06157639613371629,
         0.07660309213780439,
         -0.08801025234082831,
         0.09470388736980938,
         -0.0961953789267286,
         0.0925912672473505,
         -0.08452387616560539,
         0.07303697656714989,
         -0.059440507991221345,
         0.0451483068316209,
         -0.031512725384615456,
         0.019669858223492178,
         -0.010408310636651786,
         0.004068275353607447,
         -0.03447640176588025,
         0.061319541442804375,
         -0.0804596319350663,
         0.08796628019102291,
         -0.08259779206483664,
         0.06551372012506038,
         -0.039654212337433596,
         0.00901941784474379,
         0.02204553982079767,
         -0.04949211414954427,
         0.07008956333942132,
         -0.08179405746072269,
         0.08394602394757245,
         -0.0772867665107775,
         0.06379541107074073,
         -0.04635700159793289,
         0.028281003274112208,
         -0.012679898467306182,
         0.06414407013932796,
         -0.08833028103380558,
         0.08543119732717809,
         -0.060789173000656366,
         0.02371703833478943,
         0.015494465848499143,
         -0.047833294570406915,
         0.06697213198105535,
         -0.06992352344625143,
         0.05707001608030534,
         -0.03170032346670825,
         -0.0008161702392266652,
         0.03408384030861761,
         -0.061831271035673846,
         0.07902461417150564,
         -0.08281028025263462,
         0.0731517440304968,
         -0.053017318904929625,
         0.02791350511834606,
         -0.09319917318823866,
         0.08728902325924974,
         -0.04395461430375991,
         -0.008452365229990785,
         0.049555805925829095,
         -0.0685158885227246,
         0.0633246408948686,
         -0.03875396926424656,
         0.0037229270089670645,
         0.031397330484542,
         -0.057187807776482046,
         0.06705522761832881,
         -0.058419249618319735,
         0.033126366359982874,
         0.00293542977926451,
         -0.0409877704979118,
         0.0711820650465557,
         -0.08491618409734727,
         0.07736533073395609,
         -0.0496724464061764,
         0.10883318688565606,
         -0.045888100743125416,
         -0.026387198747296777,
         0.06670240184124393,
         -0.06738509408128174,
         0.03844207751677736,
         0.00312549255158232,
         -0.0405463557541951,
         0.061684982780555,
         -0.06111679999068974,
         0.04032776579596356,
         -0.0064841570727352605,
         -0.02978460345019685,
         0.05714841275686631,
         -0.06644311778022916,
         0.053200562256591644,
         -0.01940189476064088,
         -0.025984317092581116,
         0.06811098382819124,
         -0.08940584212491944,
         0.07488403052196589,
         -0.09974726340535867,
         -0.025133947898079382,
         0.07654664350915844,
         -0.05917407961361699,
         0.009788971247600238,
         0.03776208063010317,
         -0.06288825636029091,
         0.059403778727690544,
         -0.032593283071871676,
         -0.005379841033049408,
         0.04033253915998383,
         -0.06031955261636601,
         0.05873489711395898,
         -0.03592384131370314,
         -0.0008521043704220402,
         0.039097254265904303,
         -0.06425397465672035,
         0.06403404220271651,
         -0.033363019904250814,
         -0.02090352240350589,
         0.07676650808227257,
         -0.09706079685290388,
         0.06366715593920158,
         0.08866423413809685,
         -0.057489663423347805,
         -0.014424800879599967,
         0.061165536491124814,
         -0.06522011828444632,
         0.03570240942207732,
         0.007509473461290774,
         -0.04448578976285399,
         0.06157187411020915,
         -0.05409239071481446,
         0.026196646316416966,
         0.011391502808964421,
         -0.04495555481310786,
         0.06193636638745413,
         -0.05488630758641825,
         0.024463092594925333,
         0.019302442821815556,
         -0.05823366245578684,
         0.07050959137646598,
         -0.03925560551515992,
         -0.03379223200269118,
         0.10730474833799701,
         -0.09725318712464977,
         -0.0305712774436363,
         0.07734303289297163,
         -0.053588992724346626,
         0.0009457044687096114,
         0.044870977156677316,
         -0.06417361334835157,
         0.05341785905186963,
         -0.021021846648459033,
         -0.018354195802513934,
         0.049482398498522845,
         -0.061212767942005794,
         0.049482398498522845,
         -0.018354195802513934,
         -0.02102184664845892,
         0.05341785905186952,
         -0.06417361334835157,
         0.044870977156677316,
         0.0009457044687096113,
         -0.053588992724346626,
         0.07734303289297165,
         -0.0305712774436363,
         -0.09725318712464977,
         0.10730474833799701,
         -0.03379223200269118,
         -0.03925560551515992,
         0.07050959137646598,
         -0.058233662455786844,
         0.0193024428218155,
         0.024463092594925333,
         -0.05488630758641814,
         0.06193636638745413,
         -0.044955554813107965,
         0.011391502808964308,
         0.02619664631641685,
         -0.05409239071481446,
         0.06157187411020914,
         -0.04448578976285389,
         0.007509473461290882,
         0.03570240942207722,
         -0.06522011828444632,
         0.06116553649112483,
         -0.014424800879599969,
         -0.0574896634233478,
         0.08866423413809685,
         0.06366715593920157,
         -0.09706079685290388,
         0.07676650808227256,
         -0.02090352240350589,
         -0.03336301990425081,
         0.06403404220271655,
         -0.06425397465672035,
         0.03909725426590432,
         -0.0008521043704220403,
         -0.03592384131370314,
         0.05873489711395898,
         -0.060319552616366005,
         0.04033253915998383,
         -0.005379841033049408,
         -0.03259328307187168,
         0.05940377872769043,
         -0.06288825636029091,
         0.03776208063010316,
         0.009788971247600234,
         -0.059174079613617,
         0.07654664350915845,
         -0.025133947898079385,
         -0.09974726340535867,
         0.07488403052196589,
         -0.08940584212491944,
         0.06811098382819124,
         -0.02598431709258112,
         -0.01940189476064088,
         0.053200562256591595,
         -0.06644311778022916,
         0.0571484127568663,
         -0.029784603450196734,
         -0.00648415707273526,
         0.04032776579596357,
         -0.06111679999068975,
         0.061684982780555,
         -0.04054635575419522,
         0.003125492551582319,
         0.038442077516777355,
         -0.06738509408128167,
         0.06670240184124393,
         -0.02638719874729678,
         -0.04588810074312541,
         0.10883318688565606,
         -0.0496724464061764,
         0.07736533073395609,
         -0.08491618409734726,
         0.0711820650465557,
         -0.040987770497911795,
         0.00293542977926451,
         0.033126366359982874,
         -0.058419249618319756,
         0.06705522761832881,
         -0.057187807776482046,
         0.03139733048454201,
         0.003722927008967064,
         -0.03875396926424656,
         0.0633246408948686,
         -0.0685158885227246,
         0.04955580592582909,
         -0.008452365229990787,
         -0.043954614303759916,
         0.08728902325924973,
         -0.09319917318823863,
         0.027913505118346057,
         -0.053017318904929604,
         0.0731517440304968,
         -0.08281028025263462,
         0.07902461417150564,
         -0.06183127103567386,
         0.03408384030861761,
         -0.0008161702392266651,
         -0.03170032346670824,
         0.05707001608030533,
         -0.06992352344625144,
         0.06697213198105534,
         -0.04783329457040691,
         0.015494465848499143,
         0.023717038334789435,
         -0.06078917300065637,
         0.08543119732717805,
         -0.08833028103380558,
         0.06414407013932798,
         -0.012679898467306184,
         0.028281003274112215,
         -0.04635700159793289,
         0.06379541107074073,
         -0.0772867665107775,
         0.08394602394757246,
         -0.08179405746072264,
         0.07008956333942132,
         -0.04949211414954427,
         0.022045539820797672,
         0.009019417844743794,
         -0.03965421233743359,
         0.06551372012506038,
         -0.08259779206483665,
         0.0879662801910229,
         -0.08045963193506632,
         0.06131954144280436,
         -0.03447640176588025,
         0.004068275353607448,
         -0.010408310636651782,
         0.019669858223492175,
         -0.031512725384615456,
         0.0451483068316209,
         -0.05944050799122133,
         0.07303697656714989,
         -0.08452387616560539,
         0.0925912672473505,
         -0.09619537892672861,
         0.09470388736980934,
         -0.0880102523408283,
         0.07660309213780439,
         -0.06157639613371629,
         0.04456572362626225,
         -0.027592385910381375,
         0.012772792738255974},
        {0.02645674994617369,
         -0.05612324188528839,
         0.08572966806188372,
         -0.107467826312283,
         0.115438963354368,
         -0.10746782631228297,
         0.0857296680618837,
         -0.0561232418852887,
         0.02645674994617368,
         -0.0561232418852887,
         0.09259862481160784,
         -0.10246655193630455,
         0.07937024983852127,
         -0.029806212171661076,
         -0.029806212171661076,
         0.07937024983852127,
         -0.10246655193630454,
         0.09259862481160784,
         -0.05612324188528869,
         0.08572966806188372,
         -0.10246655193630454,
         0.06614187486543399,
         -0.060286032440052005,
         0.08430469899226621,
         -0.060286032440052005,
         0.06614187486543399,
         -0.10246655193630452,
         0.0857296680618837,
         -0.107467826312283,
         0.07937024983852127,
         -0.06614187486543419,
         0.07782893321641396,
         -0.03362594233395247,
         -0.03362594233395247,
         0.07782893321641396,
         -0.06614187486543419,
         0.07937024983852127,
         -0.10746782631228297,
         0.11543896335436797,
         -0.029806212171661076,
         -0.060286032440052005,
         0.07782893321641396,
         -0.025439182640552213,
         -0.04458756536551651,
         0.0757660690536001,
         -0.04458756536551651,
         -0.025439182640552213,
         0.07782893321641396,
         -0.060286032440052005,
         -0.02980621217166107,
         0.11543896335436797,
         -0.10746782631228297,
         -0.02980621217166107,
         0.08430469899226621,
         -0.03362594233395246,
         -0.04458756536551651,
         0.07428241331041166,
         -0.03507287480528888,
         -0.03507287480528889,
         0.07428241331041166,
         -0.0445875653655165,
         -0.03362594233395246,
         0.08430469899226621,
         -0.02980621217166107,
         -0.10746782631228297,
         0.08572966806188372,
         0.07937024983852127,
         -0.060286032440052005,
         -0.03362594233395246,
         0.0757660690536001,
         -0.03507287480528888,
         -0.03764999030801776,
         0.07224011237680732,
         -0.037649990308017654,
         -0.03507287480528888,
         0.07576606905360012,
         -0.03362594233395246,
         -0.060286032440052005,
         0.07937024983852128,
         0.08572966806188372,
         -0.0561232418852887,
         -0.10246655193630452,
         0.07782893321641396,
         -0.04458756536551595,
         -0.03507287480528945,
         0.07224011237680675,
         -0.03561485569677283,
         -0.03561485569677283,
         0.07224011237680675,
         -0.03507287480528945,
         -0.04458756536551595,
         0.07782893321641396,
         -0.10246655193630452,
         -0.05612324188528869,
         0.026456749946173676,
         0.09259862481160785,
         0.06614187486543399,
         -0.06614187486543419,
         -0.02543918264055222,
         0.07428241331041166,
         -0.03764999030801765,
         -0.035614855696771724,
         0.07122971139354389,
         -0.035614855696771724,
         -0.037649990308017765,
         0.07428241331041166,
         -0.02543918264055222,
         -0.0661418748654342,
         0.066141874865434,
         0.09259862481160785,
         0.026456749946173676,
         -0.05612324188528869,
         -0.10246655193630452,
         0.07782893321641395,
         -0.04458756536551594,
         -0.03507287480528945,
         0.07224011237680676,
         -0.03561485569677283,
         -0.03561485569677283,
         0.07224011237680676,
         -0.03507287480528945,
         -0.04458756536551594,
         0.07782893321641395,
         -0.10246655193630452,
         -0.05612324188528869,
         0.0857296680618837,
         0.07937024983852127,
         -0.060286032440052005,
         -0.03362594233395246,
         0.0757660690536001,
         -0.03507287480528888,
         -0.037649990308017765,
         0.07224011237680732,
         -0.03764999030801765,
         -0.03507287480528888,
         0.07576606905360009,
         -0.03362594233395246,
         -0.06028603244005202,
         0.07937024983852126,
         0.0857296680618837,
         -0.10746782631228295,
         -0.029806212171661062,
         0.08430469899226621,
         -0.03362594233395246,
         -0.0445875653655165,
         0.07428241331041166,
         -0.03507287480528888,
         -0.03507287480528888,
         0.07428241331041166,
         -0.0445875653655165,
         -0.03362594233395246,
         0.08430469899226621,
         -0.029806212171661062,
         -0.10746782631228295,
         0.115438963354368,
         -0.02980621217166107,
         -0.060286032440052005,
         0.07782893321641395,
         -0.02543918264055222,
         -0.0445875653655165,
         0.0757660690536001,
         -0.0445875653655165,
         -0.02543918264055222,
         0.07782893321641395,
         -0.06028603244005202,
         -0.029806212171661062,
         0.115438963354368,
         -0.10746782631228294,
         0.07937024983852127,
         -0.06614187486543419,
         0.07782893321641395,
         -0.03362594233395246,
         -0.03362594233395246,
         0.07782893321641395,
         -0.06614187486543419,
         0.07937024983852127,
         -0.10746782631228294,
         0.08572966806188372,
         -0.10246655193630452,
         0.06614187486543399,
         -0.06028603244005202,
         0.0843046989922662,
         -0.06028603244005202,
         0.06614187486543399,
         -0.10246655193630452,
         0.08572966806188372,
         -0.05612324188528869,
         0.09259862481160785,
         -0.10246655193630454,
         0.07937024983852127,
         -0.029806212171661062,
         -0.029806212171661062,
         0.07937024983852127,
         -0.10246655193630452,
         0.09259862481160785,
         -0.05612324188528869,
         0.026456749946173676,
         -0.05612324188528869,
         0.08572966806188372,
         -0.10746782631228294,
         0.11543896335436801,
         -0.10746782631228295,
         0.08572966806188372,
         -0.05612324188528869,
         0.026456749946173676},
        {0.035892126803877634,
         -0.06714802069137848,
         0.09242887466920881,
         -0.10672767134232397,
         0.10828582195709824,
         -0.09835548215764368,
         0.08030691489721399,
         -0.05849807516247585,
         0.03717487798128219,
         -0.01959288102661576,
         0.007472431629767143,
         -0.0728972541446915,
         0.10032154423814106,
         -0.09258920241272192,
         0.05660089510980477,
         -0.0064713156194206225,
         -0.04237353030671455,
         0.0777568359955516,
         -0.0932905695928427,
         0.08891122720763006,
         -0.06975450888115069,
         0.04390053582488206,
         -0.01959288102661576,
         0.10309228547118081,
         -0.08928053815224021,
         0.028524169989370133,
         0.036535720690117825,
         -0.07518989286620562,
         0.07529425085239726,
         -0.041938918507022326,
         -0.008604312310415417,
         0.056640517722364,
         -0.08616254456774225,
         0.08966917955720549,
         -0.06975450888115069,
         0.03717487798128219,
         -0.11471050568723815,
         0.03557021781877629,
         0.04916579168219871,
         -0.07951078122567831,
         0.05195796932972379,
         0.005188595547760315,
         -0.05607658637064001,
         0.0748488325079422,
         -0.0541586937834259,
         0.005045938369680274,
         0.04977173210541387,
         -0.08616254456774226,
         0.08891122720763006,
         -0.05849807516247584,
         0.1030922854711808,
         0.03557021781877629,
         -0.08321974751420128,
         0.03947459226735173,
         0.030640410006182704,
         -0.07055133318979602,
         0.059159091343358124,
         -0.009859848557224911,
         -0.04483697250598637,
         0.07263077755229358,
         -0.057110727456077544,
         0.005045938369680273,
         0.05664051772236399,
         -0.09329056959284267,
         0.08030691489721399,
         -0.07289725414469149,
         -0.0892805381522402,
         0.049165791682198694,
         0.03947459226735173,
         -0.07415984567549207,
         0.040823651458040136,
         0.021601845873510724,
         -0.06480553762053184,
         0.06141055924242485,
         -0.01602069108911835,
         -0.04123181024282203,
         0.07263077755229358,
         -0.0541586937834259,
         -0.008604312310415418,
         0.07775683599555161,
         -0.0983554821576437,
         0.03589212680387766,
         0.10032154423814107,
         0.028524169989370133,
         -0.07951078122567828,
         0.030640410006182704,
         0.040823651458040136,
         -0.06991857302518566,
         0.04136438563374791,
         0.017208624620830996,
         -0.0620576256470849,
         0.06191443350378474,
         -0.01602069108911835,
         -0.04483697250598637,
         0.07484883250794223,
         -0.04193891850702232,
         -0.04237353030671454,
         0.10828582195709825,
         -0.06714802069137804,
         -0.09258920241272196,
         0.036535720690117825,
         0.0519579693297238,
         -0.07055133318979603,
         0.0216018458735105,
         0.04136438563374802,
         -0.06787173080950303,
         0.04156277711070411,
         0.01587891721325312,
         -0.062057625647083774,
         0.06141055924242486,
         -0.009859848557224911,
         -0.05607658637064045,
         0.07529425085239724,
         -0.006471315619420623,
         -0.10672767134232396,
         0.09242887466920882,
         0.05660089510980477,
         -0.0751898928662056,
         0.005188595547760315,
         0.059159091343358124,
         -0.06480553762053239,
         0.017208624620831885,
         0.04156277711070323,
         -0.06725188466790405,
         0.04156277711070323,
         0.017208624620831885,
         -0.06480553762053239,
         0.059159091343358124,
         0.005188595547760315,
         -0.07518989286620559,
         0.05660089510980477,
         0.09242887466920884,
         -0.10672767134232396,
         -0.006471315619420623,
         0.07529425085239726,
         -0.05607658637064045,
         -0.009859848557224911,
         0.061410559242424965,
         -0.062057625647083677,
         0.01587891721325312,
         0.04156277711070411,
         -0.06787173080950303,
         0.04136438563374791,
         0.021601845873510616,
         -0.07055133318979603,
         0.05195796932972379,
         0.036535720690117825,
         -0.09258920241272196,
         -0.06714802069137804,
         0.10828582195709827,
         -0.04237353030671455,
         -0.04193891850702231,
         0.0748488325079422,
         -0.04483697250598637,
         -0.01602069108911835,
         0.06191443350378485,
         -0.062057625647084794,
         0.017208624620830996,
         0.04136438563374802,
         -0.06991857302518564,
         0.040823651458040136,
         0.030640410006182704,
         -0.07951078122567828,
         0.028524169989370133,
         0.10032154423814106,
         0.03589212680387766,
         -0.0983554821576437,
         0.07775683599555162,
         -0.008604312310415418,
         -0.05415869378342591,
         0.0726307775522936,
         -0.041231810242822034,
         -0.016020691089118355,
         0.061410559242424965,
         -0.06480553762053173,
         0.02160184587351062,
         0.040823651458040136,
         -0.07415984567549205,
         0.03947459226735173,
         0.0491657916821987,
         -0.08928053815224021,
         -0.0728972541446915,
         0.08030691489721399,
         -0.09329056959284268,
         0.056640517722363996,
         0.005045938369680274,
         -0.05711072745607755,
         0.07263077755229358,
         -0.04483697250598637,
         -0.009859848557224911,
         0.059159091343358124,
         -0.07055133318979602,
         0.030640410006182704,
         0.03947459226735172,
         -0.08321974751420126,
         0.03557021781877629,
         0.10309228547118082,
         -0.05849807516247584,
         0.08891122720763008,
         -0.08616254456774225,
         0.049771732105413864,
         0.005045938369680274,
         -0.05415869378342591,
         0.0748488325079422,
         -0.056076586370639996,
         0.005188595547760315,
         0.05195796932972379,
         -0.07951078122567828,
         0.0491657916821987,
         0.03557021781877629,
         -0.11471050568723813,
         0.03717487798128219,
         -0.06975450888115067,
         0.08966917955720548,
         -0.08616254456774225,
         0.05664051772236399,
         -0.008604312310415418,
         -0.04193891850702231,
         0.07529425085239727,
         -0.07518989286620559,
         0.036535720690117825,
         0.028524169989370133,
         -0.08928053815224021,
         0.10309228547118084,
         -0.01959288102661576,
         0.04390053582488206,
         -0.06975450888115067,
         0.08891122720763008,
         -0.0932905695928427,
         0.07775683599555162,
         -0.042373530306714556,
         -0.006471315619420624,
         0.05660089510980477,
         -0.09258920241272195,
         0.10032154423814106,
         -0.0728972541446915,
         0.0074724316297671445,
         -0.01959288102661576,
         0.03717487798128219,
         -0.05849807516247584,
         0.08030691489721399,
         -0.0983554821576437,
         0.10828582195709825,
         -0.10672767134232394,
         0.09242887466920882,
         -0.06714802069137803,
         0.035892126803877655},
        {0.05536365323582666,
         -0.08753762190648195,
         0.10485467442429909,
         -0.10798535200916104,
         0.09997500937109557,
         -0.08483160849058835,
         0.0664743801022164,
         -0.04811062416561877,
         0.03195561368527263,
         -0.019202933946861612,
         0.010161237533239135,
         -0.004484839140730559,
         0.0014362980234359577,
         -0.0998082452693906,
         0.10170952554312158,
         -0.06453359105519775,
         0.012906718211039718,
         0.035346503537745086,
         -0.06998250655976636,
         0.08739728897453182,
         -0.08883012690738439,
         0.07838358775990246,
         -0.06124825956343909,
         0.0423336507607622,
         -0.025383291496322184,
         0.01256760770506458,
         -0.004484839140730559,
         0.11809470840497749,
         -0.044635604227465694,
         -0.03468042628558104,
         0.07657502725606431,
         -0.07558974640641253,
         0.0438828419175334,
         0.001025721953642647,
         -0.043420883258200316,
         0.07287213405695088,
         -0.08511171727077471,
         0.08122043080626763,
         -0.06588084696899565,
         0.04531520263940438,
         -0.02538329149632218,
         0.010161237533239133,
         -0.09980824526939061,
         -0.04463560422746568,
         0.08530159329748993,
         -0.04805044825192967,
         -0.013536680260577728,
         0.05998500562265811,
         -0.0736403597478709,
         0.055074678682579224,
         -0.015942908060139024,
         -0.028239788846370642,
         0.06376904426367744,
         -0.0822198450538304,
         0.08165354263233433,
         -0.06588084696899565,
         0.042333650760762204,
         -0.019202933946861612,
         0.05536365323582668,
         0.1017095255431216,
         -0.034680426285581045,
         -0.04805044825192967,
         0.07561178102177882,
         -0.04880719477907165,
         -0.003376064256941822,
         0.04982412055452452,
         -0.07030763182881357,
         0.05929549865046078,
         -0.02387939955383756,
         -0.021422639006377912,
         0.060755406391340395,
         -0.0822198450538304,
         0.08122043080626763,
         -0.06124825956343908,
         0.03195561368527263,
         -0.08753762190648177,
         -0.06453359105519775,
         0.07657502725606431,
         -0.013536680260577727,
         -0.04880719477907165,
         0.07081692129341971,
         -0.04892381906667943,
         0.0020056810373657633,
         0.043965150534961354,
         -0.06796171594176507,
         0.06072500902984948,
         -0.026212438927705594,
         -0.021422639006377916,
         0.06376904426367744,
         -0.08511171727077471,
         0.07838358775990246,
         -0.04811062416561877,
         0.10485467442429912,
         0.012906718211039716,
         -0.07558974640641253,
         0.05998500562265812,
         -0.0033760642569418773,
         -0.04892381906667943,
         0.06816365357953336,
         -0.04888268932501105,
         0.004703738973416483,
         0.04127514197933179,
         -0.06714693259563209,
         0.06072500902984948,
         -0.023879399553837558,
         -0.02823978884637064,
         0.07287213405695088,
         -0.0888301269073844,
         0.0664743801022164,
         -0.10798535200916101,
         0.03534650353774508,
         0.043882841917533416,
         -0.07364035974787088,
         0.04982412055452452,
         0.0020056810373657633,
         -0.04888268932501105,
         0.06678646810947947,
         -0.04883740660169768,
         0.005529747390229392,
         0.04127514197933179,
         -0.06796171594176507,
         0.05929549865046078,
         -0.01594290806013902,
         -0.043420883258200316,
         0.08739728897453182,
         -0.08483160849058834,
         0.09997500937109556,
         -0.06998250655976636,
         0.001025721953642647,
         0.05507467868257923,
         -0.07030763182881357,
         0.04396515053496135,
         0.0047037389734164835,
         -0.04883740660169768,
         0.06635696868273958,
         -0.04883740660169768,
         0.0047037389734164835,
         0.04396515053496135,
         -0.07030763182881357,
         0.05507467868257923,
         0.001025721953642647,
         -0.06998250655976636,
         0.09997500937109556,
         -0.08483160849058835,
         0.08739728897453182,
         -0.04342088325820031,
         -0.01594290806013902,
         0.05929549865046078,
         -0.06796171594176507,
         0.04127514197933179,
         0.005529747390229394,
         -0.04883740660169768,
         0.06678646810947947,
         -0.04888268932501106,
         0.002005681037365763,
         0.04982412055452452,
         -0.07364035974787088,
         0.043882841917533416,
         0.03534650353774508,
         -0.10798535200916101,
         0.06647438010221642,
         -0.08883012690738439,
         0.07287213405695085,
         -0.02823978884637064,
         -0.023879399553837558,
         0.06072500902984948,
         -0.06714693259563209,
         0.04127514197933179,
         0.004703738973416483,
         -0.04888268932501105,
         0.06816365357953336,
         -0.04892381906667943,
         -0.003376064256941822,
         0.05998500562265811,
         -0.07558974640641254,
         0.012906718211039716,
         0.10485467442429912,
         -0.04811062416561877,
         0.07838358775990246,
         -0.08511171727077473,
         0.06376904426367744,
         -0.021422639006377912,
         -0.02621243892770559,
         0.060725009029849494,
         -0.06796171594176507,
         0.04396515053496135,
         0.002005681037365763,
         -0.04892381906667943,
         0.07081692129341971,
         -0.04880719477907165,
         -0.013536680260577723,
         0.07657502725606431,
         -0.06453359105519775,
         -0.0875376219064818,
         0.03195561368527263,
         -0.06124825956343911,
         0.08122043080626765,
         -0.08221984505383038,
         0.06075540639134038,
         -0.021422639006377916,
         -0.02387939955383756,
         0.05929549865046078,
         -0.07030763182881357,
         0.04982412055452452,
         -0.0033760642569418777,
         -0.04880719477907165,
         0.0756117810217788,
         -0.04805044825192969,
         -0.03468042628558104,
         0.10170952554312158,
         0.05536365323582667,
         -0.019202933946861615,
         0.04233365076076221,
         -0.06588084696899564,
         0.08165354263233433,
         -0.08221984505383038,
         0.06376904426367742,
         -0.02823978884637064,
         -0.01594290806013902,
         0.05507467868257922,
         -0.07364035974787088,
         0.05998500562265811,
         -0.013536680260577723,
         -0.048050448251929695,
         0.08530159329748993,
         -0.04463560422746568,
         -0.09980824526939061,
         0.010161237533239135,
         -0.025383291496322184,
         0.045315202639404376,
         -0.06588084696899565,
         0.08122043080626765,
         -0.08511171727077474,
         0.07287213405695085,
         -0.04342088325820031,
         0.001025721953642647,
         0.04388284191753342,
         -0.07558974640641254,
         0.07657502725606431,
         -0.03468042628558104,
         -0.04463560422746568,
         0.11809470840497752,
         -0.004484839140730559,
         0.01256760770506458,
         -0.025383291496322184,
         0.04233365076076221,
         -0.06124825956343911,
         0.07838358775990246,
         -0.08883012690738439,
         0.0873972889745318,
         -0.06998250655976636,
         0.03534650353774508,
         0.012906718211039716,
         -0.06453359105519775,
         0.10170952554312158,
         -0.09980824526939061,
         0.0014362980234359577,
         -0.004484839140730559,
         0.010161237533239135,
         -0.019202933946861615,
         0.03195561368527264,
         -0.04811062416561877,
         0.06647438010221642,
         -0.08483160849058834,
         0.09997500937109555,
         -0.10798535200916101,
         0.10485467442429912,
         -0.08753762190648179,
         0.05536365323582666},
        {0.01746741545259169,
         -0.03905832834322509,
         0.06354705786845444,
         -0.08604312310415796,
         0.10180759621425205,
         -0.10746782631228277,
         0.10180759621425206,
         -0.08604312310415796,
         0.06354705786845442,
         -0.03905832834322537,
         0.017467415452591686,
         -0.040964720361109694,
         0.07410796749798179,
         -0.09377827268452565,
         0.0917222774164022,
         -0.06664871656761587,
         0.024336670328567466,
         0.02433667032856747,
         -0.06664871656761587,
         0.0917222774164022,
         -0.09377827268452567,
         0.07410796749798179,
         -0.04096472036110971,
         0.06854708804857385,
         -0.09519340784437323,
         0.08353477693833258,
         -0.04024646998335453,
         -0.01556578664328289,
         0.06108455772855151,
         -0.07848340356971238,
         0.06108455772855151,
         -0.01556578664328289,
         -0.04024646998335454,
         0.08353477693833257,
         -0.09519340784437326,
         0.06854708804857385,
         -0.09341393490359132,
         0.08974920561468411,
         -0.035267185847908354,
         -0.030387633420649332,
         0.07088971082984495,
         -0.06832417009872589,
         0.027748073437372324,
         0.027748073437372324,
         -0.06832417009872589,
         0.07088971082984495,
         -0.030387633420649325,
         -0.03526718584790835,
         0.08974920561468411,
         -0.09341393490359132,
         0.10838246260280043,
         -0.05495993964402692,
         -0.027748073437372685,
         0.07341450167644352,
         -0.06062002963543019,
         0.007637405851653634,
         0.04758256138616708,
         -0.07053437169581597,
         0.04758256138616708,
         0.007637405851653634,
         -0.06062002963543021,
         0.07341450167644352,
         -0.027748073437372685,
         -0.05495993964402693,
         0.10838246260280046,
         -0.10838246260280035,
         0.07301001098570337,
         -0.06204657845061954,
         0.05612324188528869,
         -0.06698448048894765,
         0.029120920287392472,
         0.029120920287392472,
         -0.06698448048894778,
         0.056123241885288694,
         -0.06204657845061954,
         0.07301001098570337,
         -0.10838246260280035,
         0.09242887466920877,
         0.056600895109804795,
         -0.07518989286620575,
         0.005188595547760417,
         0.0591590913433577,
         -0.06480553762053164,
         0.01720862462083097,
         0.04156277711070438,
         -0.06725188466790397,
         0.04156277711070439,
         0.01720862462083097,
         -0.06480553762053175,
         0.05915909134335769,
         0.005188595547760417,
         -0.07518989286620575,
         0.05660089510980478,
         0.09242887466920877,
         -0.06441664532766964,
         -0.09373998802374088,
         0.030165336116620242,
         0.057074551025371095,
         -0.06725188466790319,
         0.011831818268671097,
         0.04911383235646335,
         -0.06597886321927858,
         0.029655293671945568,
         0.029655293671945453,
         -0.06597886321927858,
         0.04911383235646335,
         0.011831818268671097,
         -0.06725188466790319,
         0.057074551025371095,
         0.030165336116620235,
         -0.09373998802374087,
         -0.06441664532766965,
         0.032208322663834756,
         0.09662496799150459,
         0.03978675152591352,
         -0.07673159222854764,
         0.014209554116396702,
         0.05399630564231157,
         -0.0653639489354303,
         0.01989337576295716,
         0.0397867515259141,
         -0.06631125254318923,
         0.0397867515259141,
         0.01989337576295716,
         -0.06536394893543039,
         0.05399630564231157,
         0.014209554116396702,
         -0.07673159222854764,
         0.03978675152591352,
         0.09662496799150459,
         0.032208322663834756,
         -0.06441664532766964,
         -0.09373998802374088,
         0.030165336116620242,
         0.057074551025371095,
         -0.0672518846679032,
         0.011831818268671097,
         0.04911383235646334,
         -0.06597886321927858,
         0.029655293671945568,
         0.029655293671945453,
         -0.06597886321927858,
         0.04911383235646334,
         0.011831818268671098,
         -0.06725188466790319,
         0.0570745510253711,
         0.030165336116620235,
         -0.09373998802374087,
         -0.06441664532766964,
         0.09242887466920877,
         0.05660089510980478,
         -0.07518989286620575,
         0.005188595547760417,
         0.0591590913433577,
         -0.06480553762053164,
         0.017208624620830972,
         0.041562777110704385,
         -0.06725188466790397,
         0.041562777110704385,
         0.017208624620830972,
         -0.06480553762053175,
         0.0591590913433577,
         0.005188595547760417,
         -0.07518989286620575,
         0.056600895109804775,
         0.0924288746692088,
         -0.10838246260280035,
         0.07301001098570337,
         -0.062046578450619554,
         0.056123241885288694,
         -0.06698448048894765,
         0.02912092028739247,
         0.029120920287392472,
         -0.06698448048894777,
         0.056123241885288694,
         -0.06204657845061954,
         0.07301001098570337,
         -0.10838246260280035,
         0.10838246260280043,
         -0.05495993964402693,
         -0.027748073437372688,
         0.07341450167644352,
         -0.06062002963543022,
         0.007637405851653634,
         0.04758256138616707,
         -0.07053437169581599,
         0.04758256138616707,
         0.007637405851653634,
         -0.06062002963543022,
         0.07341450167644352,
         -0.027748073437372688,
         -0.05495993964402693,
         0.10838246260280045,
         -0.09341393490359134,
         0.08974920561468411,
         -0.035267185847908354,
         -0.030387633420649332,
         0.07088971082984494,
         -0.06832417009872589,
         0.027748073437372324,
         0.027748073437372324,
         -0.06832417009872589,
         0.07088971082984494,
         -0.030387633420649332,
         -0.035267185847908354,
         0.08974920561468411,
         -0.09341393490359134,
         0.06854708804857385,
         -0.09519340784437326,
         0.08353477693833257,
         -0.04024646998335454,
         -0.01556578664328289,
         0.06108455772855151,
         -0.0784834035697124,
         0.06108455772855151,
         -0.01556578664328289,
         -0.04024646998335454,
         0.08353477693833257,
         -0.09519340784437326,
         0.06854708804857385,
         -0.04096472036110971,
         0.0741079674979818,
         -0.09377827268452567,
         0.09172227741640221,
         -0.06664871656761588,
         0.024336670328567463,
         0.024336670328567463,
         -0.06664871656761588,
         0.09172227741640221,
         -0.09377827268452567,
         0.0741079674979818,
         -0.04096472036110971,
         0.01746741545259168,
         -0.039058328343225375,
         0.06354705786845442,
         -0.08604312310415795,
         0.10180759621425203,
         -0.10746782631228273,
         0.10180759621425203,
         -0.08604312310415795,
         0.06354705786845442,
         -0.03905832834322538,
         0.01746741545259168},
        {0.02707336052115397,
         -0.0529018024234541,
         0.07657502725606455,
         -0.09378487190853621,
         0.10205804578387875,
         -0.10091769663177906,
         0.09158131742063724,
         -0.07642671213086191,
         0.058371865576045616,
         -0.04028041406859075,
         0.024476136629815536,
         -0.01242210974460566,
         0.004587168028717222,
         -0.05977636149267836,
         0.08946692778758743,
         -0.09387364132917446,
         0.07414345132452914,
         -0.037652519125993364,
         -0.0053789313037134415,
         0.04496553421326989,
         -0.07355577929981173,
         0.0872096546458892,
         -0.08580295507629508,
         0.07242293336872352,
         -0.05219416901927878,
         0.03081436738570671,
         -0.013075440642859626,
         0.09130990043641395,
         -0.09307166861573464,
         0.05122194994259821,
         0.005772059857264167,
         -0.05279396641457479,
         0.07453265846763417,
         -0.0670941067416546,
         0.03620069427100877,
         0.006490215820571238,
         -0.04766042866521398,
         0.07619159963915068,
         -0.08589464478282201,
         0.07667901344931789,
         -0.054017028111060024,
         0.026796679302121807,
         -0.10913620531707714,
         0.05406975338287143,
         0.023267917153933566,
         -0.0693848653302596,
         0.06865444455609314,
         -0.031822186740580495,
         -0.01793504369915814,
         0.05716393957039406,
         -0.07036889281071931,
         0.053708832532516966,
         -0.014512563763441998,
         -0.032409532608078884,
         0.07030161650382545,
         -0.08630256959314819,
         0.07601769269431372,
         -0.045294655049567846,
         0.10485467442429888,
         0.012906718211039905,
         -0.07558974640641275,
         0.05998500562265819,
         -0.003376064256941977,
         -0.0489238190666796,
         0.06816365357953376,
         -0.04888268932501156,
         0.004703738973416578,
         0.04127514197933182,
         -0.06714693259563187,
         0.06072500902984874,
         -0.023879399553837038,
         -0.028239788846371038,
         0.07287213405695085,
         -0.08883012690738445,
         0.06647438010221642,
         -0.07893173141532663,
         -0.07503677814442888,
         0.0647912112054963,
         0.010798535200915385,
         -0.06366159095029261,
         0.062022260762658925,
         -0.01876142817242275,
         -0.03326045725035262,
         0.06336968202464371,
         -0.05680304464961199,
         0.01869395813770312,
         0.030357833001009214,
         -0.06427704459552547,
         0.06338931326153602,
         -0.024255476226168554,
         -0.036187870029854144,
         0.08495554078236503,
         -0.08667198772934501,
         0.041220752355914235,
         0.09942819573870994,
         0.004604510880853309,
         -0.0720719953290747,
         0.053974589303810494,
         0.006915416000714099,
         -0.05593804173923162,
         0.0628459656442742,
         -0.029151454414750057,
         -0.021226132936744337,
         0.05813481676900239,
         -0.06068550369113829,
         0.026944055306555723,
         0.024928245192550744,
         -0.0644582336498145,
         0.06356719672632,
         -0.013834899295147739,
         -0.06035062584378127,
         0.10121107640351343,
         -0.0735281423349815,
         -0.08022578046655733,
         0.05541833340049838,
         0.02512654016522501,
         -0.06811684760702684,
         0.05070029838508645,
         0.0019123418350882587,
         -0.04959937908506634,
         0.06317895267700152,
         -0.03699234286097182,
         -0.011789461048620432,
         0.053818396380602554,
         -0.06303274696568588,
         0.031013483163617486,
         0.02554385011698543,
         -0.06895046542620714,
         0.058760693027081416,
         0.017107794369616163,
         -0.10545952717197757,
         0.09627093655986847,
         0.035153175723992895,
         -0.07745265920798901,
         0.03408956404310584,
         0.031084096948402057,
         -0.06522481047679643,
         0.05110462974887481,
         -0.0042331491045917114,
         -0.04353547014953248,
         0.06326888717473339,
         -0.04353547014953248,
         -0.0042331491045917114,
         0.0511046297488747,
         -0.06522481047679644,
         0.03108409694840217,
         0.03408956404310584,
         -0.07745265920798901,
         0.03515317572399289,
         0.09627093655986847,
         -0.10545952717197754,
         0.017107794369616163,
         0.05876069302708142,
         -0.06895046542620714,
         0.02554385011698543,
         0.031013483163617378,
         -0.06303274696568599,
         0.053818396380602554,
         -0.011789461048620432,
         -0.03699234286097182,
         0.06317895267700152,
         -0.04959937908506634,
         0.0019123418350882587,
         0.05070029838508655,
         -0.06811684760702684,
         0.02512654016522501,
         0.05541833340049838,
         -0.0802257804665573,
         -0.0735281423349815,
         0.10121107640351343,
         -0.06035062584378127,
         -0.01383489929514774,
         0.06356719672632,
         -0.06445823364981451,
         0.024928245192550737,
         0.02694405530655572,
         -0.06068550369113839,
         0.0581348167690024,
         -0.021226132936744337,
         -0.029151454414750057,
         0.0628459656442741,
         -0.05593804173923161,
         0.006915416000714207,
         0.053974589303810494,
         -0.0720719953290747,
         0.004604510880853307,
         0.09942819573870994,
         0.04122075235591424,
         -0.08667198772934502,
         0.084955540782365,
         -0.03618787002985415,
         -0.024255476226168554,
         0.06338931326153595,
         -0.06427704459552547,
         0.03035783300100911,
         0.01869395813770312,
         -0.056803044649612,
         0.06336968202464348,
         -0.033260457250352274,
         -0.018761428172422746,
         0.06202226076265889,
         -0.06366159095029261,
         0.010798535200915385,
         0.06479121120549629,
         -0.0750367781444289,
         -0.07893173141532661,
         0.06647438010221642,
         -0.08883012690738447,
         0.07287213405695087,
         -0.028239788846371038,
         -0.023879399553837034,
         0.060725009029848724,
         -0.06714693259563184,
         0.04127514197933182,
         0.004703738973416467,
         -0.04888268932501156,
         0.06816365357953376,
         -0.04892381906667961,
         -0.0033760642569419766,
         0.059985005622658176,
         -0.07558974640641274,
         0.012906718211039907,
         0.10485467442429885,
         -0.04529465504956782,
         0.07601769269431372,
         -0.08630256959314818,
         0.07030161650382548,
         -0.032409532608078884,
         -0.014512563763441995,
         0.05370883253251696,
         -0.07036889281071933,
         0.05716393957039406,
         -0.017935043699158142,
         -0.031822186740580495,
         0.06865444455609315,
         -0.06938486533025962,
         0.023267917153933563,
         0.05406975338287143,
         -0.10913620531707714,
         0.026796679302121807,
         -0.054017028111059996,
         0.07667901344931788,
         -0.08589464478282202,
         0.07619159963915068,
         -0.047660428665213986,
         0.0064902158205712365,
         0.03620069427100877,
         -0.06709410674165461,
         0.07453265846763417,
         -0.0527939664145748,
         0.005772059857264166,
         0.051221949942598224,
         -0.09307166861573464,
         0.09130990043641393,
         -0.013075440642859627,
         0.03081436738570671,
         -0.05219416901927878,
         0.07242293336872352,
         -0.08580295507629508,
         0.0872096546458892,
         -0.07355577929981175,
         0.044965534213269875,
         -0.005378931303713442,
         -0.03765251912599336,
         0.07414345132452912,
         -0.09387364132917445,
         0.08946692778758744,
         -0.05977636149267836,
         0.00458716802871722,
         -0.012422109744605662,
         0.02447613662981554,
         -0.04028041406859075,
         0.05837186557604562,
         -0.07642671213086188,
         0.09158131742063723,
         -0.10091769663177906,
         0.10205804578387874,
         -0.0937848719085362,
         0.07657502725606458,
         -0.052901802423453985,
         0.027073360521153986},
        {0.01194929914188073,
         -0.02776766194521263,
         0.04724369506511124,
         -0.06742847233187653,
         0.08497687221248407,
         -0.09688854139846427,
         0.10110303691029159,
         -0.09688854139846427,
         0.08497687221248408,
         -0.06742847233187654,
         0.04724369506511124,
         -0.027767661945212786,
         0.011949299141880726,
         -0.03046485474910374,
         0.05878277936239537,
         -0.08108117248015848,
         0.09000673614579585,
         -0.08176903341128361,
         0.057004218834728254,
         -0.02042589799937736,
         -0.02042589799937736,
         0.057004218834728254,
         -0.08176903341128362,
         0.09000673614579587,
         -0.08108117248015848,
         0.05878277936239537,
         -0.03046485474910374,
         0.055061941707689625,
         -0.08457312911974993,
         0.08768287280149506,
         -0.063567970116703,
         0.02106655926567884,
         0.02537037175830946,
         -0.060703250897811194,
         0.07383521859739227,
         -0.060703250897811194,
         0.02537037175830946,
         0.02106655926567884,
         -0.06356797011670301,
         0.08768287280149509,
         -0.08457312911974994,
         0.05506194170768962,
         -0.08060242939383355,
         0.09119123904718311,
         -0.05753193882858296,
         0.0025124954043951406,
         0.046792023770615525,
         -0.07013268378517552,
         0.06020333586392472,
         -0.023460731267274413,
         -0.023460731267274413,
         0.06020333586392472,
         -0.07013268378517552,
         0.046792023770615525,
         0.0025124954043951406,
         -0.05753193882858297,
         0.09119123904718311,
         -0.08060242939383355,
         0.09997500937109569,
         -0.06998250655976648,
         0.0010257219536426482,
         0.055074678682578725,
         -0.07030763182881304,
         0.043965150534960515,
         0.004703738973416711,
         -0.048837406601698066,
         0.06635696868273923,
         -0.048837406601698066,
         0.004703738973416821,
         0.04396515053496052,
         -0.07030763182881299,
         0.05507467868257874,
         0.001025721953642648,
         -0.06998250655976647,
         0.09997500937109569,
         -0.10643152492839751,
         0.023088239429054688,
         0.054437400428556354,
         -0.07135958763005787,
         0.03393282578224471,
         0.022198821182590058,
         -0.06021498531522361,
         0.06011469194167094,
         -0.024729782125904914,
         -0.024729782125904914,
         0.06011469194167095,
         -0.06021498531522361,
         0.022198821182590058,
         0.03393282578224471,
         -0.07135958763005787,
         0.054437400428556354,
         0.023088239429054688,
         -0.10643152492839751,
         0.09627093655986856,
         0.03515317572399294,
         -0.07745265920798908,
         0.03408956404310594,
         0.03108409694840197,
         -0.06522481047679596,
         0.05110462974887404,
         -0.004233149104590509,
         -0.04353547014953367,
         0.06326888717473478,
         -0.04353547014953378,
         -0.004233149104590509,
         0.05110462974887394,
         -0.06522481047679596,
         0.031084096948401856,
         0.03408956404310593,
         -0.07745265920798909,
         0.03515317572399293,
         0.09627093655986856,
         -0.07093130908464904,
         -0.08233436820820082,
         0.05043772234049894,
         0.0315841733043668,
         -0.06884509411157104,
         0.043944739107029944,
         0.011666611459128992,
         -0.05520974264767239,
         0.05973438038717281,
         -0.02523555599037295,
         -0.025235555990372725,
         0.05973438038717281,
         -0.05520974264767228,
         0.011666611459128992,
         0.043944739107029944,
         -0.06884509411157104,
         0.031584173304366796,
         0.05043772234049894,
         -0.08233436820820082,
         -0.07093130908464904,
         0.03738408235414732,
         0.09719861412078318,
         0.0161341829107376,
         -0.07437464805193449,
         0.04187480184436701,
         0.02343738909199719,
         -0.06274275865072322,
         0.05274280597147004,
         -0.0068055233511589396,
         -0.041967393998804926,
         0.06238396405227542,
         -0.04196739399880526,
         -0.0068055233511589396,
         0.05274280597147026,
         -0.0627427586507231,
         0.0234373890919973,
         0.04187480184436701,
         -0.07437464805193449,
         0.0161341829107376,
         0.09719861412078318,
         0.03738408235414732,
         -0.07093130908464904,
         -0.08233436820820082,
         0.05043772234049894,
         0.0315841733043668,
         -0.06884509411157104,
         0.043944739107029944,
         0.011666611459128992,
         -0.05520974264767239,
         0.05973438038717281,
         -0.02523555599037295,
         -0.025235555990372728,
         0.05973438038717281,
         -0.05520974264767228,
         0.011666611459128992,
         0.043944739107029944,
         -0.06884509411157104,
         0.0315841733043668,
         0.05043772234049894,
         -0.08233436820820082,
         -0.07093130908464904,
         0.09627093655986857,
         0.03515317572399293,
         -0.07745265920798908,
         0.03408956404310594,
         0.03108409694840197,
         -0.06522481047679596,
         0.05110462974887404,
         -0.00423314910459051,
         -0.04353547014953367,
         0.0632688871747348,
         -0.04353547014953378,
         -0.00423314910459051,
         0.05110462974887394,
         -0.06522481047679596,
         0.031084096948401856,
         0.03408956404310594,
         -0.07745265920798908,
         0.03515317572399293,
         0.09627093655986858,
         -0.10643152492839748,
         0.023088239429054688,
         0.05443740042855635,
         -0.07135958763005787,
         0.03393282578224471,
         0.022198821182590058,
         -0.0602149853152236,
         0.06011469194167094,
         -0.024729782125904907,
         -0.024729782125904907,
         0.060114691941670934,
         -0.06021498531522361,
         0.022198821182590058,
         0.03393282578224471,
         -0.07135958763005787,
         0.054437400428556354,
         0.023088239429054688,
         -0.10643152492839748,
         0.09997500937109567,
         -0.06998250655976647,
         0.001025721953642648,
         0.055074678682578745,
         -0.07030763182881304,
         0.04396515053496052,
         0.00470373897341671,
         -0.04883740660169805,
         0.06635696868273923,
         -0.04883740660169805,
         0.00470373897341682,
         0.04396515053496052,
         -0.07030763182881297,
         0.055074678682578745,
         0.001025721953642648,
         -0.06998250655976647,
         0.09997500937109567,
         -0.08060242939383355,
         0.09119123904718311,
         -0.05753193882858297,
         0.002512495404395141,
         0.046792023770615525,
         -0.07013268378517554,
         0.06020333586392472,
         -0.02346073126727441,
         -0.02346073126727441,
         0.06020333586392472,
         -0.07013268378517554,
         0.04679202377061553,
         0.002512495404395141,
         -0.05753193882858297,
         0.09119123904718311,
         -0.08060242939383355,
         0.05506194170768961,
         -0.08457312911974993,
         0.08768287280149506,
         -0.063567970116703,
         0.021066559265678846,
         0.025370371758309456,
         -0.06070325089781119,
         0.07383521859739225,
         -0.06070325089781119,
         0.025370371758309456,
         0.021066559265678846,
         -0.063567970116703,
         0.08768287280149506,
         -0.08457312911974993,
         0.05506194170768961,
         -0.030464854749103754,
         0.058782779362395364,
         -0.08108117248015845,
         0.09000673614579585,
         -0.08176903341128362,
         0.05700421883472825,
         -0.020425897999377357,
         -0.020425897999377357,
         0.057004218834728254,
         -0.08176903341128362,
         0.09000673614579585,
         -0.08108117248015845,
         0.058782779362395364,
         -0.030464854749103754,
         0.011949299141880724,
         -0.027767661945212792,
         0.04724369506511122,
         -0.06742847233187653,
         0.08497687221248408,
         -0.09688854139846424,
         0.10110303691029161,
         -0.09688854139846424,
         0.08497687221248408,
         -0.06742847233187652,
         0.047243695065111224,
         -0.027767661945212792,
         0.011949299141880724},
        {0.020857883199368987,
         -0.0421480656795854,
         0.0633746249135948,
         -0.08106909258207892,
         0.09277095161439436,
         -0.09729899490634202,
         0.09470388736980939,
         -0.08603976256060628,
         0.07303697656714991,
         -0.05774079984113501,
         0.04216791808184043,
         -0.02802052418517719,
         0.016485830723228928,
         -0.008136550707214887,
         0.002932209339700775,
         -0.04946881355982449,
         0.0787655552192451,
         -0.09010870215317605,
         0.08190920924413805,
         -0.057494860626474915,
         0.023192737903598874,
         0.01366932871656598,
         -0.04640291067938147,
         0.07008956333942137,
         -0.08216659863804378,
         0.08250403988805817,
         -0.07305673498129969,
         0.057207653781896003,
         -0.03893772315539413,
         0.02196467501623283,
         -0.008978020876612628,
         0.08078223426829574,
         -0.09217969157169206,
         0.06532808426566195,
         -0.01885384384088585,
         -0.02797149435901458,
         0.06056006174179988,
         -0.07138574104403178,
         0.06002954501244436,
         -0.031700323466708265,
         -0.00505126774824762,
         0.04082891111880102,
         -0.0676271046137495,
         0.08046627314199534,
         -0.07821308442067786,
         0.0635002305217949,
         -0.04178398309073593,
         0.019669858223492098,
         -0.10278877062413615,
         0.06615443164140257,
         0.0008388642394788424,
         -0.053093365380525656,
         0.07067906980415706,
         -0.0539511910380216,
         0.015753669987394525,
         0.02649508509090313,
         -0.05718780777648207,
         0.06664622569145717,
         -0.052821193152367836,
         0.0208145319181546,
         0.019280209647197184,
         -0.055558743889494895,
         0.07776416091577994,
         -0.08025966018065721,
         0.06379541107074077,
         -0.035395335939852536,
         0.10474682791109914,
         -0.005819268217282681,
         -0.06326136840653723,
         0.06890387717149218,
         -0.029548652322362222,
         -0.021715728651303737,
         0.05717907139001182,
         -0.06305794441052283,
         0.04032776579596346,
         -0.0008811691165353457,
         -0.03849253840747475,
         0.06232617163698292,
         -0.06141662054549997,
         0.035517837834908396,
         0.006684994537628894,
         -0.050287307234967,
         0.07902461417150597,
         -0.08121964533141593,
         0.05509721401465199,
         -0.08335987467827102,
         -0.06072706821074187,
         0.07244219185475502,
         -0.01321426113421122,
         -0.04533860655394153,
         0.06590026646408209,
         -0.04534667929926518,
         0.0017407635830046662,
         0.04033253915998608,
         -0.06128239750305534,
         0.05303641020940594,
         -0.020388015801970995,
         -0.022006305590564226,
         0.05553103524223175,
         -0.06462165471148078,
         0.04296502220811169,
         0.0029354297792645112,
         -0.05433872171184759,
         0.08588805662598557,
         -0.07594626840823125,
         0.04588810074312536,
         0.0963468002759713,
         -0.014828610620194891,
         -0.05902920887580841,
         0.0648238600816139,
         -0.021146964996877148,
         -0.03135301275855008,
         0.06047027516024331,
         -0.054092390714816495,
         0.019540126419446222,
         0.023916979189255005,
         -0.0549340173468143,
         0.05896912042323581,
         -0.0338342237917024,
         -0.00936322252797377,
         0.050117877385511087,
         -0.0664431177802283,
         0.04493746909564708,
         0.009909000361692413,
         -0.07107197617191943,
         0.09348339412685791,
         -0.0783688515097002,
         -0.06717735753033555,
         0.06624465249756804,
         0.0007721644652689488,
         -0.054872275626056455,
         0.06253777866120369,
         -0.029484913774275444,
         -0.01835419580251228,
         0.05331218463451144,
         -0.05858533628863153,
         0.03338882214910565,
         0.008761095130739135,
         -0.04679097015788891,
         0.06126297815969487,
         -0.04312197702094182,
         -0.0008521043704231509,
         0.04832182379458849,
         -0.0689931161390372,
         0.03971958768585095,
         0.034978283217545286,
         -0.10240592743085189,
         0.0980462109172262,
         0.016191798829170892,
         -0.07222111662496992,
         0.052416262040064915,
         0.0031254925515830988,
         -0.04976456918697434,
         0.06193636638745372,
         -0.03811651913854625,
         -0.005197420216301948,
         0.04441101787467286,
         -0.05997601888052209,
         0.04441101787467274,
         -0.005197420216301948,
         -0.03811651913854625,
         0.061936366387453826,
         -0.049764569186974354,
         0.0031254925515830988,
         0.052416262040064915,
         -0.07222111662496992,
         0.016191798829170892,
         0.09804621091722619,
         -0.10240592743085189,
         0.034978283217545286,
         0.03971958768585095,
         -0.0689931161390372,
         0.04832182379458849,
         -0.0008521043704231509,
         -0.043121977020941935,
         0.06126297815969486,
         -0.04679097015788891,
         0.00876109513073902,
         0.03338882214910576,
         -0.058585336288631516,
         0.05331218463451156,
         -0.01835419580251239,
         -0.029484913774275447,
         0.06253777866120369,
         -0.05487227562605652,
         0.0007721644652689488,
         0.06624465249756807,
         -0.06717735753033555,
         -0.07836885150970022,
         0.09348339412685791,
         -0.07107197617191945,
         0.009909000361692413,
         0.04493746909564708,
         -0.06644311778022831,
         0.050117877385511066,
         -0.009363222527973994,
         -0.0338342237917024,
         0.05896912042323568,
         -0.05493401734681442,
         0.02391697918925501,
         0.01954012641944633,
         -0.0540923907148165,
         0.06047027516024342,
         -0.03135301275854996,
         -0.021146964996877033,
         0.06482386008161387,
         -0.0590292088758084,
         -0.014828610620194893,
         0.0963468002759713,
         0.04588810074312536,
         -0.07594626840823124,
         0.08588805662598556,
         -0.05433872171184759,
         0.0029354297792645112,
         0.04296502220811163,
         -0.06462165471148072,
         0.05553103524223184,
         -0.022006305590564223,
         -0.020388015801971106,
         0.053036410209406054,
         -0.06128239750305533,
         0.04033253915998608,
         0.0017407635830046662,
         -0.04534667929926519,
         0.06590026646408209,
         -0.045338606553941535,
         -0.01321426113421122,
         0.07244219185475503,
         -0.06072706821074186,
         -0.08335987467827102,
         0.055097214014652,
         -0.08121964533141593,
         0.07902461417150597,
         -0.05028730723496699,
         0.006684994537628893,
         0.035517837834908396,
         -0.06141662054549992,
         0.06232617163698292,
         -0.03849253840747474,
         -0.0008811691165353459,
         0.04032776579596348,
         -0.06305794441052281,
         0.05717907139001181,
         -0.02171572865130374,
         -0.029548652322362215,
         0.06890387717149218,
         -0.06326136840653725,
         -0.00581926821728268,
         0.10474682791109916,
         -0.03539533593985254,
         0.06379541107074076,
         -0.08025966018065721,
         0.07776416091577992,
         -0.05555874388949488,
         0.019280209647197184,
         0.020814531918154598,
         -0.052821193152367836,
         0.06664622569145717,
         -0.05718780777648207,
         0.026495085090903127,
         0.01575366998739452,
         -0.0539511910380216,
         0.07067906980415706,
         -0.053093365380525656,
         0.0008388642394788421,
         0.06615443164140257,
         -0.10278877062413616,
         0.0196698582234921,
         -0.04178398309073593,
         0.06350023052179489,
         -0.07821308442067784,
         0.08046627314199535,
         -0.06762710461374952,
         0.04082891111880103,
         -0.005051267748247622,
         -0.031700323466708265,
         0.060029545012444376,
         -0.07138574104403178,
         0.06056006174179988,
         -0.027971494359014585,
         -0.018853843840885853,
         0.06532808426566195,
         -0.09217969157169206,
         0.08078223426829573,
         -0.008978020876612628,
         0.021964675016232837,
         -0.03893772315539413,
         0.05720765378189599,
         -0.07305673498129968,
         0.08250403988805817,
         -0.08216659863804378,
         0.07008956333942136,
         -0.04640291067938147,
         0.013669328716565983,
         0.023192737903598874,
         -0.05749486062647491,
         0.08190920924413804,
         -0.09010870215317604,
         0.0787655552192451,
         -0.049468813559824486,
         0.0029322093397007747,
         -0.008136550707214887,
         0.016485830723228925,
         -0.02802052418517719,
         0.042167918081840436,
         -0.057740799841135025,
         0.07303697656714991,
         -0.08603976256060629,
         0.09470388736980938,
         -0.097298994906342,
         0.09277095161439435,
         -0.08106909258207894,
         0.06337462491359483,
         -0.042148065679585164,
         0.020857883199368998},
        {0.008422130122337527,
         -0.02015560687895268,
         0.035460341202954014,
         -0.05259618575624861,
         0.06931614794453005,
         -0.08330764187721727,
         0.09259126724735055,
         -0.09584106693489054,
         0.09259126724735055,
         -0.08330764187721727,
         0.06931614794453005,
         -0.05259618575624861,
         0.035460341202954014,
         -0.020155606878952924,
         0.008422130122337525,
         -0.023064953251240045,
         0.04668570855838539,
         -0.06842170856271171,
         0.08240238655792373,
         -0.0844647478784352,
         0.07306563537797145,
         -0.04949211414954426,
         0.01749810476520046,
         0.01749810476520046,
         -0.04949211414954426,
         0.07306563537797145,
         -0.0844647478784352,
         0.08240238655792373,
         -0.06842170856271172,
         0.04668570855838539,
         -0.02306495325124005,
         0.04456572362626214,
         -0.07361977118822306,
         0.084983500480599,
         -0.07477133816236949,
         0.04601941554979932,
         -0.006966534989235775,
         -0.0317003234667088,
         0.059767406008871905,
         -0.06999241906080224,
         0.059767406008871905,
         -0.03170032346670881,
         -0.006966534989235775,
         0.04601941554979932,
         -0.07477133816236949,
         0.084983500480599,
         -0.07361977118822308,
         0.04456572362626214,
         -0.06945066417418785,
         0.08796628019102311,
         -0.07002856283757913,
         0.027933045551342836,
         0.01961802714993984,
         -0.055015179965319606,
         0.06705522761832979,
         -0.05338411180754565,
         0.020205070992993197,
         0.020205070992993204,
         -0.05338411180754566,
         0.06705522761832979,
         -0.055015179965319606,
         0.01961802714993984,
         0.027933045551342836,
         -0.07002856283757913,
         0.08796628019102311,
         -0.06945066417418785,
         0.09136839294025623,
         -0.0780273734081564,
         0.023717038334789713,
         0.03278940087481356,
         -0.06430728876905131,
         0.061177415234980194,
         -0.029784603450197396,
         -0.013355665883694539,
         0.049149265094815514,
         -0.0629033792799113,
         0.049149265094815514,
         -0.013355665883694537,
         -0.029784603450197396,
         0.06117741523498021,
         -0.06430728876905124,
         0.03278940087481356,
         0.023717038334789713,
         -0.07802737340815638,
         0.09136839294025623,
         -0.10283173353954381,
         0.040237315962019175,
         0.03435914963476386,
         -0.06851588852272544,
         0.05404098679651686,
         -0.009894475139823038,
         -0.03592384131370147,
         0.06050316917586796,
         -0.05401237726036362,
         0.021367215518619597,
         0.021367215518619597,
         -0.05401237726036351,
         0.06050316917586796,
         -0.03592384131370137,
         -0.00989447513982315,
         0.05404098679651686,
         -0.06851588852272544,
         0.03435914963476386,
         0.040237315962019175,
         -0.10283173353954381,
         0.09804621091722622,
         0.01619179882917088,
         -0.07222111662496991,
         0.05241626204006489,
         0.003125492551582931,
         -0.04976456918697389,
         0.06193636638745304,
         -0.038116519138545246,
         -0.00519742021630339,
         0.04441101787467284,
         -0.05997601888052052,
         0.04441101787467271,
         -0.00519742021630339,
         -0.038116519138545246,
         0.06193636638745304,
         -0.049764569186973896,
         0.003125492551582931,
         0.05241626204006489,
         -0.07222111662496991,
         0.01619179882917088,
         0.09804621091722622,
         -0.07594626840823136,
         -0.06995656643509174,
         0.06271056721051678,
         0.007429306822156256,
         -0.05838934458776864,
         0.059403778727689656,
         -0.02102184664845814,
         -0.027205318395945442,
         0.05698912818098837,
         -0.05401272167784592,
         0.02183784068323631,
         0.02183784068323631,
         -0.05401272167784592,
         0.05698912818098824,
         -0.027205318395945213,
         -0.02102184664845814,
         0.059403778727689566,
         -0.05838934458776864,
         0.007429306822156256,
         0.06271056721051678,
         -0.06995656643509174,
         -0.07594626840823136,
         0.041980879422954274,
         0.09541108959762311,
         -0.003816443583904344,
         -0.06487954092638223,
         0.057648384662144135,
         -0.005423367198178336,
         -0.044485789762854444,
         0.061340764290533915,
         -0.040267615275382286,
         -0.002812116324983883,
         0.04300883791149803,
         -0.05913715212830817,
         0.04300883791149825,
         -0.002812116324983883,
         -0.040267615275382404,
         0.06134076429053402,
         -0.04448578976285434,
         -0.005423367198178336,
         0.057648384662144135,
         -0.06487954092638222,
         -0.003816443583904344,
         0.09541108959762311,
         0.041980879422954274,
         -0.07594626840823136,
         -0.06995656643509175,
         0.06271056721051678,
         0.007429306822156257,
         -0.05838934458776864,
         0.059403778727689656,
         -0.021021846648458145,
         -0.027205318395945442,
         0.05698912818098836,
         -0.05401272167784637,
         0.02183784068323631,
         0.02183784068323631,
         -0.05401272167784615,
         0.056989128180988245,
         -0.027205318395945217,
         -0.021021846648458145,
         0.059403778727689566,
         -0.05838934458776864,
         0.007429306822156257,
         0.06271056721051678,
         -0.06995656643509175,
         -0.07594626840823136,
         0.09804621091722622,
         0.01619179882917088,
         -0.07222111662496991,
         0.05241626204006489,
         0.003125492551582931,
         -0.04976456918697389,
         0.06193636638745303,
         -0.038116519138545246,
         -0.00519742021630339,
         0.04441101787467284,
         -0.0599760188805205,
         0.04441101787467273,
         -0.00519742021630339,
         -0.038116519138545246,
         0.06193636638745303,
         -0.04976456918697389,
         0.003125492551582931,
         0.05241626204006489,
         -0.07222111662496991,
         0.01619179882917088,
         0.09804621091722622,
         -0.10283173353954381,
         0.040237315962019175,
         0.03435914963476385,
         -0.06851588852272544,
         0.05404098679651685,
         -0.009894475139823037,
         -0.03592384131370148,
         0.060503169175867975,
         -0.05401237726036362,
         0.021367215518619597,
         0.021367215518619597,
         -0.0540123772603635,
         0.060503169175867975,
         -0.03592384131370137,
         -0.009894475139823151,
         0.05404098679651686,
         -0.06851588852272544,
         0.03435914963476385,
         0.040237315962019175,
         -0.10283173353954381,
         0.09136839294025623,
         -0.07802737340815638,
         0.023717038334789716,
         0.03278940087481356,
         -0.06430728876905131,
         0.061177415234980215,
         -0.029784603450197396,
         -0.013355665883694535,
         0.04914926509481551,
         -0.06290337927991128,
         0.04914926509481551,
         -0.013355665883694535,
         -0.029784603450197396,
         0.061177415234980215,
         -0.06430728876905127,
         0.03278940087481356,
         0.023717038334789716,
         -0.07802737340815638,
         0.09136839294025624,
         -0.06945066417418787,
         0.08796628019102311,
         -0.07002856283757913,
         0.02793304555134284,
         0.019618027149939845,
         -0.055015179965319606,
         0.06705522761832979,
         -0.053384111807545646,
         0.020205070992993197,
         0.020205070992993197,
         -0.053384111807545646,
         0.06705522761832979,
         -0.055015179965319606,
         0.01961802714993984,
         0.02793304555134284,
         -0.07002856283757913,
         0.08796628019102311,
         -0.06945066417418787,
         0.04456572362626213,
         -0.07361977118822308,
         0.08498350048059898,
         -0.07477133816236949,
         0.04601941554979932,
         -0.006966534989235777,
         -0.031700323466708806,
         0.05976740600887191,
         -0.06999241906080224,
         0.05976740600887191,
         -0.031700323466708806,
         -0.006966534989235777,
         0.04601941554979932,
         -0.07477133816236949,
         0.08498350048059898,
         -0.07361977118822308,
         0.04456572362626213,
         -0.023064953251240056,
         0.04668570855838539,
         -0.06842170856271171,
         0.08240238655792373,
         -0.08446474787843523,
         0.07306563537797146,
         -0.049492114149544277,
         0.01749810476520046,
         0.01749810476520046,
         -0.049492114149544277,
         0.07306563537797146,
         -0.08446474787843523,
         0.08240238655792372,
         -0.06842170856271171,
         0.04668570855838539,
         -0.023064953251240056,
         0.008422130122337524,
         -0.020155606878952924,
         0.03546034120295402,
         -0.05259618575624861,
         0.06931614794453003,
         -0.08330764187721727,
         0.09259126724735055,
         -0.09584106693489054,
         0.09259126724735055,
         -0.08330764187721727,
         0.06931614794453003,
         -0.05259618575624861,
         0.03546034120295402,
         -0.02015560687895292,
         0.008422130122337525},
        {0.006089190018057417,
         -0.014915408491089077,
         0.026934062629837923,
         -0.041142460257971,
         0.05606772240402491,
         -0.07002856283757836,
         0.08139226764089466,
         -0.08880624463059661,
         0.09138087183580082,
         -0.08880624463059661,
         0.08139226764089466,
         -0.07002856283757836,
         0.056067722404024904,
         -0.041142460257971,
         0.02693406262983792,
         -0.014915408491089405,
         0.006089190018057415,
         -0.017752887036932525,
         0.0372885212277235,
         -0.05717808212416544,
         0.07293778639922384,
         -0.08080218788951388,
         0.07849481136563458,
         -0.065587758359133,
         0.04350599706354787,
         -0.015230145305966876,
         -0.015230145305966876,
         0.04350599706354787,
         -0.06558775835913298,
         0.07849481136563458,
         -0.08080218788951385,
         0.07293778639922385,
         -0.05717808212416544,
         0.0372885212277235,
         -0.017752887036932525,
         0.03638259188421788,
         -0.06351465953832966,
         0.07909733203506142,
         -0.0782850472881714,
         0.06102413030411201,
         -0.03147177315758709,
         -0.0034514561662348235,
         0.03584397497363709,
         -0.05857570116350647,
         0.06673515310527567,
         -0.05857570116350647,
         0.03584397497363709,
         -0.003451456166234823,
         -0.03147177315758709,
         0.06102413030411202,
         -0.0782850472881714,
         0.0790973320350614,
         -0.06351465953832967,
         0.03638259188421787,
         -0.05994064546587229,
         0.08250796300936974,
         -0.07586294828615472,
         0.04580198747558339,
         -0.004612990650248746,
         -0.03389841984401211,
         0.05850184046497542,
         -0.06310213964461177,
         0.04766374120128909,
         -0.01765646188223804,
         -0.01765646188223804,
         0.04766374120128909,
         -0.06310213964461177,
         0.05850184046497541,
         -0.03389841984401211,
         -0.004612990650248747,
         0.04580198747558339,
         -0.07586294828615472,
         0.08250796300936976,
         -0.05994064546587229,
         0.08312271950446568,
         -0.08144329952737284,
         0.0404880181754461,
         0.011395640745420398,
         -0.050536829672834176,
         0.06397067047194448,
         -0.050485021395043406,
         0.018230768467805657,
         0.019493710381989843,
         -0.048932040866430514,
         0.05997601888052148,
         -0.048932040866430514,
         0.019493710381989843,
         0.018230768467805778,
         -0.050485021395043406,
         0.06397067047194449,
         -0.05053682967283412,
         0.011395640745420398,
         0.0404880181754461,
         -0.08144329952737285,
         0.08312271950446568,
         -0.09835212807532574,
         0.05257142378828306,
         0.015502467122384941,
         -0.058978044037892016,
         0.06260198269876446,
         -0.033860169989087446,
         -0.008353656383582922,
         0.043952560886289065,
         -0.05887991139492608,
         0.04870101885699147,
         -0.018718149157059574,
         -0.018718149157059574,
         0.04870101885699147,
         -0.05887991139492608,
         0.04395256088628896,
         -0.00835365638358292,
         -0.033860169989087315,
         0.06260198269876441,
         -0.058978044037892016,
         0.015502467122384945,
         0.05257142378828308,
         -0.09835212807532576,
         0.09835212807532595,
         -0.06297131913443157,
         0.06200986848954145,
         -0.019960862148792457,
         -0.028452078973487227,
         0.05684014996039789,
         -0.05471874366125753,
         0.026847478739761583,
         0.012097851004652235,
         -0.04464203696038714,
         0.057184890254464944,
         -0.04464203696038714,
         0.012097851004652235,
         0.026847478739761583,
         -0.05471874366125763,
         0.056840149960397775,
         -0.028452078973487234,
         -0.01996086214879251,
         0.062009868489541466,
         -0.06297131913443156,
         0.09835212807532594,
         -0.07972851170059951,
         -0.057589109378012586,
         0.06898162393156931,
         -0.012970294553958659,
         -0.04245525469956452,
         0.06203026311876576,
         -0.04291818363599142,
         0.0022226259712862908,
         0.03696980796232301,
         -0.05645066247747411,
         0.04893398037576075,
         -0.019153053295578887,
         -0.019153053295578887,
         0.04893398037576075,
         -0.05645066247747433,
         0.036969807962323124,
         0.0022226259712862908,
         -0.04291818363599154,
         0.06203026311876576,
         -0.04245525469956452,
         -0.012970294553958659,
         0.0689816239315693,
         -0.057589109378012586,
         -0.0797285117005995,
         0.04603127769242922,
         0.09206255538485887,
         -0.020013598996708466,
         -0.052035357391441314,
         0.06404351678946796,
         -0.028019038595389022,
         -0.02127761577544646,
         0.05372071309643071,
         -0.05533791103393039,
         0.029196309124610572,
         0.009913857088151547,
         -0.04337312476066957,
         0.0563850621888673,
         -0.04337312476066933,
         0.009913857088151769,
         0.029196309124611016,
         -0.05533791103393073,
         0.053720713096430596,
         -0.02127761577544657,
         -0.028019038595389022,
         0.06404351678946794,
         -0.05203535739144132,
         -0.02001359899670847,
         0.09206255538485886,
         0.046031277692429214,
         -0.0797285117005995,
         -0.057589109378012586,
         0.06898162393156933,
         -0.012970294553958659,
         -0.04245525469956453,
         0.06203026311876576,
         -0.04291818363599142,
         0.0022226259712862903,
         0.03696980796232301,
         -0.05645066247747411,
         0.04893398037576076,
         -0.019153053295578887,
         -0.019153053295578887,
         0.04893398037576076,
         -0.05645066247747433,
         0.036969807962323124,
         0.0022226259712862903,
         -0.04291818363599154,
         0.06203026311876578,
         -0.04245525469956453,
         -0.012970294553958659,
         0.06898162393156933,
         -0.057589109378012586,
         -0.07972851170059948,
         0.09835212807532594,
         -0.06297131913443156,
         0.06200986848954145,
         -0.01996086214879246,
         -0.028452078973487234,
         0.056840149960397886,
         -0.05471874366125753,
         0.02684747873976158,
         0.012097851004652235,
         -0.04464203696038692,
         0.057184890254464944,
         -0.04464203696038736,
         0.012097851004652235,
         0.02684747873976158,
         -0.05471874366125763,
         0.056840149960397775,
         -0.028452078973487234,
         -0.01996086214879251,
         0.06200986848954145,
         -0.06297131913443157,
         0.09835212807532594,
         -0.09835212807532576,
         0.05257142378828306,
         0.015502467122384945,
         -0.058978044037892016,
         0.06260198269876446,
         -0.033860169989087446,
         -0.008353656383582923,
         0.04395256088628907,
         -0.058879911394926085,
         0.04870101885699147,
         -0.018718149157059567,
         -0.018718149157059567,
         0.048701018856991476,
         -0.05887991139492608,
         0.04395256088628896,
         -0.008353656383582923,
         -0.03386016998908732,
         0.06260198269876441,
         -0.05897804403789202,
         0.015502467122384945,
         0.05257142378828306,
         -0.09835212807532576,
         0.08312271950446568,
         -0.08144329952737285,
         0.0404880181754461,
         0.011395640745420401,
         -0.050536829672834176,
         0.06397067047194449,
         -0.05048502139504341,
         0.018230768467805657,
         0.01949371038198984,
         -0.04893204086643049,
         0.05997601888052149,
         -0.04893204086643049,
         0.01949371038198984,
         0.018230768467805775,
         -0.05048502139504341,
         0.06397067047194449,
         -0.05053682967283413,
         0.011395640745420401,
         0.0404880181754461,
         -0.08144329952737285,
         0.08312271950446568,
         -0.0599406454658723,
         0.08250796300936974,
         -0.07586294828615474,
         0.0458019874755834,
         -0.004612990650248747,
         -0.0338984198440121,
         0.058501840464975426,
         -0.06310213964461177,
         0.0476637412012891,
         -0.01765646188223804,
         -0.01765646188223804,
         0.0476637412012891,
         -0.06310213964461177,
         0.058501840464975426,
         -0.0338984198440121,
         -0.004612990650248747,
         0.0458019874755834,
         -0.07586294828615474,
         0.08250796300936974,
         -0.0599406454658723,
         0.03638259188421788,
         -0.06351465953832966,
         0.0790973320350614,
         -0.07828504728817143,
         0.061024130304112016,
         -0.0314717731575871,
         -0.003451456166234824,
         0.03584397497363709,
         -0.05857570116350648,
         0.06673515310527568,
         -0.05857570116350648,
         0.03584397497363709,
         -0.003451456166234824,
         -0.0314717731575871,
         0.061024130304112016,
         -0.07828504728817143,
         0.0790973320350614,
         -0.06351465953832966,
         0.03638259188421788,
         -0.017752887036932525,
         0.037288521227723505,
         -0.05717808212416545,
         0.07293778639922385,
         -0.08080218788951385,
         0.07849481136563459,
         -0.06558775835913297,
         0.04350599706354788,
         -0.015230145305966874,
         -0.015230145305966874,
         0.04350599706354788,
         -0.06558775835913297,
         0.07849481136563459,
         -0.08080218788951385,
         0.07293778639922385,
         -0.05717808212416545,
         0.037288521227723505,
         -0.017752887036932525,
         0.006089190018057414,
         -0.014915408491089409,
         0.02693406262983791,
         -0.041142460257971004,
         0.056067722404024904,
         -0.07002856283757836,
         0.08139226764089465,
         -0.08880624463059658,
         0.09138087183580079,
         -0.08880624463059658,
         0.08139226764089465,
         -0.07002856283757836,
         0.056067722404024904,
         -0.041142460257971004,
         0.026934062629837913,
         -0.014915408491089407,
         0.006089190018057414},
        {0.02203341893441219,
         -0.04673993982374103,
         0.07193124965538134,
         -0.0918252377531346,
         0.10205804578387878,
         -0.10077424567563713,
         0.08887453087262076,
         -0.06954083620946246,
         0.047243695065111085,
         -0.026507662867586858,
         0.010722877595729386,
         -0.048717722302771826,
         0.08128841988566,
         -0.09293160582965491,
         0.07844466088650791,
         -0.04199439561343221,
         -0.005378931303713534,
         0.050075125269331,
         -0.08041028983713354,
         0.09000673614579591,
         -0.07929164850939177,
         0.054805818822617154,
         -0.026507662867586854,
         0.07657502725606441,
         -0.09341196835653676,
         0.06526055370652031,
         -0.010510522358539012,
         -0.043376947665483924,
         0.072871123006985,
         -0.06709410674165414,
         0.030362504514925254,
         0.02106655926567879,
         -0.06620339042282425,
         0.0878154616173133,
         -0.07929164850939176,
         0.047243695065111085,
         -0.09761438955814308,
         0.07414345132452924,
         -0.00524929945167877,
         -0.054827144637468656,
         0.07190635564195073,
         -0.04266856834370647,
         -0.011025734215927962,
         0.05716393957039345,
         -0.07013268378517575,
         0.042417801764678006,
         0.012404897610746132,
         -0.06620339042282425,
         0.09000673614579588,
         -0.06954083620946246,
         0.10543559119328305,
         -0.028178847044087543,
         -0.0527939664145745,
         0.07137889226658914,
         -0.029698987662142434,
         -0.030772197324073693,
         0.06561093748979051,
         -0.05354618430899945,
         0.004703738973417254,
         0.04827640666066645,
         -0.06983887270682645,
         0.042417801764678006,
         0.02106655926567879,
         -0.08041028983713351,
         0.08887453087262076,
         -0.09761438955814307,
         -0.02817884704408754,
         0.07649101732703577,
         -0.03182218674057994,
         -0.03705259186709869,
         0.06664194533929066,
         -0.03950341820112252,
         -0.017594650787090903,
         0.060114691941668914,
         -0.05680304464961335,
         0.009321194249882547,
         0.04827640666066645,
         -0.07013268378517576,
         0.030362504514925254,
         0.05007512526933098,
         -0.10077424567563713,
         0.07657502725606441,
         0.07414345132452924,
         -0.05279396641457449,
         -0.03182218674057995,
         0.06816365357953333,
         -0.03326045725035291,
         -0.029151454414750005,
         0.06317895267700056,
         -0.04353547014953367,
         -0.011789461048620787,
         0.05813481676900283,
         -0.05680304464961279,
         0.004703738973417254,
         0.05716393957039346,
         -0.06709410674165413,
         -0.005378931303713534,
         0.10205804578387877,
         -0.04871772230277182,
         -0.09341196835653678,
         -0.005249299451678769,
         0.07137889226658914,
         -0.03705259186709868,
         -0.03326045725035357,
         0.0642653089020537,
         -0.03390925946933635,
         -0.025235555990373994,
         0.06143148118716719,
         -0.044643614565226857,
         -0.0117894610486219,
         0.06011469194166845,
         -0.05354618430899844,
         -0.011025734215927962,
         0.072871123006985,
         -0.041994395613432205,
         -0.0918252377531346,
         0.022033418934412196,
         0.08128841988566003,
         0.06526055370652031,
         -0.05482714463746865,
         -0.02969898766214244,
         0.06664194533929164,
         -0.02915145441475001,
         -0.033909259469335574,
         0.06238396405227615,
         -0.03416910433802193,
         -0.02403886938127589,
         0.06143148118716742,
         -0.043535470149532234,
         -0.017594650787090896,
         0.06561093748979051,
         -0.042668568343706456,
         -0.04337694766548392,
         0.07844466088650791,
         0.0719312496553813,
         -0.0467399398237409,
         -0.09293160582965489,
         -0.010510522358539012,
         0.07190635564195073,
         -0.030772197324073693,
         -0.03950341820112128,
         0.06317895267699987,
         -0.02523555599037433,
         -0.03416910433802282,
         0.06181423555185168,
         -0.0341691043380226,
         -0.025235555990374223,
         0.0631789526770001,
         -0.039503418201121396,
         -0.030772197324073693,
         0.07190635564195073,
         -0.010510522358539012,
         -0.09293160582965489,
         -0.0467399398237409,
         0.07193124965538131,
         0.07844466088650791,
         -0.04337694766548392,
         -0.04266856834370646,
         0.06561093748979051,
         -0.017594650787090903,
         -0.043535470149532234,
         0.06143148118716743,
         -0.024038869381276112,
         -0.03416910433802216,
         0.06238396405227616,
         -0.03390925946933545,
         -0.02915145441475001,
         0.06664194533929164,
         -0.029698987662142438,
         -0.054827144637468656,
         0.06526055370652033,
         0.08128841988566003,
         0.022033418934412196,
         -0.0918252377531346,
         -0.04199439561343221,
         0.072871123006985,
         -0.011025734215927962,
         -0.05354618430899844,
         0.060114691941668595,
         -0.0117894610486219,
         -0.04464361456522686,
         0.06143148118716719,
         -0.02523555599037411,
         -0.03390925946933647,
         0.0642653089020537,
         -0.03326045725035369,
         -0.03705259186709868,
         0.07137889226658913,
         -0.005249299451678769,
         -0.09341196835653678,
         -0.04871772230277182,
         0.10205804578387878,
         -0.005378931303713534,
         -0.06709410674165413,
         0.057163939570393466,
         0.004703738973417143,
         -0.056803044649612895,
         0.05813481676900286,
         -0.011789461048620787,
         -0.04353547014953368,
         0.06317895267700055,
         -0.02915145441475001,
         -0.0332604572503528,
         0.06816365357953333,
         -0.03182218674057995,
         -0.05279396641457449,
         0.07414345132452925,
         0.07657502725606441,
         -0.10077424567563713,
         0.050075125269330986,
         0.030362504514925254,
         -0.07013268378517576,
         0.04827640666066647,
         0.009321194249882547,
         -0.05680304464961335,
         0.06011469194166893,
         -0.0175946507870909,
         -0.03950341820112241,
         0.06664194533929066,
         -0.03705259186709869,
         -0.03182218674057995,
         0.07649101732703577,
         -0.028178847044087543,
         -0.09761438955814306,
         0.08887453087262075,
         -0.08041028983713351,
         0.02106655926567879,
         0.04241780176467801,
         -0.06983887270682647,
         0.04827640666066646,
         0.004703738973417142,
         -0.05354618430899945,
         0.06561093748979051,
         -0.030772197324073693,
         -0.029698987662142438,
         0.07137889226658913,
         -0.0527939664145745,
         -0.028178847044087543,
         0.10543559119328307,
         -0.06954083620946246,
         0.09000673614579591,
         -0.06620339042282423,
         0.012404897610746132,
         0.04241780176467801,
         -0.07013268378517576,
         0.057163939570393466,
         -0.011025734215927965,
         -0.042668568343706456,
         0.07190635564195073,
         -0.054827144637468656,
         -0.005249299451678769,
         0.07414345132452928,
         -0.09761438955814306,
         0.04724369506511109,
         -0.07929164850939177,
         0.0878154616173133,
         -0.06620339042282423,
         0.02106655926567879,
         0.030362504514925254,
         -0.06709410674165413,
         0.072871123006985,
         -0.04337694766548391,
         -0.010510522358539012,
         0.06526055370652033,
         -0.09341196835653678,
         0.07657502725606438,
         -0.026507662867586844,
         0.054805818822617154,
         -0.07929164850939177,
         0.09000673614579591,
         -0.08041028983713351,
         0.050075125269330986,
         -0.005378931303713534,
         -0.04199439561343221,
         0.07844466088650792,
         -0.09293160582965489,
         0.08128841988566003,
         -0.048717722302771826,
         0.010722877595729388,
         -0.026507662867586844,
         0.04724369506511109,
         -0.06954083620946246,
         0.08887453087262075,
         -0.1007742456756371,
         0.10205804578387878,
         -0.0918252377531346,
         0.07193124965538131,
         -0.0467399398237409,
         0.022033418934412196},
        {0.031757329769164754,
         -0.05941252375750583,
         0.08217513404875056,
         -0.09595988263992565,
         0.09932791513252046,
         -0.0931778437055957,
         0.07998340216199493,
         -0.06293060428844928,
         0.04514830683162077,
         -0.02914310674472166,
         0.016485830723228876,
         -0.007746221910095599,
         0.002631260751056679,
         -0.0661081536143042,
         0.09167551445485511,
         -0.08671857305263907,
         0.05721941885220713,
         -0.014806931353309918,
         -0.028094176940530458,
         0.06170853447480528,
         -0.08061569186038264,
         0.08394602394757224,
         -0.07449090581270326,
         0.05720765378189583,
         -0.03757469545270354,
         0.02017299909143453,
         -0.007746221910095599,
         0.09485595243198258,
         -0.08331293780817693,
         0.02967187228759375,
         0.028767050902699192,
         -0.06584752514593932,
         0.07110229776705593,
         -0.04783329457040646,
         0.007919536912960717,
         0.03408384030861791,
         -0.06587546286780396,
         0.08046627314199536,
         -0.07710631045877533,
         0.06031262388206407,
         -0.03757469545270354,
         0.016485830723228873,
         -0.10605217885419954,
         0.03353664360028178,
         0.04373442081697581,
         -0.07284858567093729,
         0.05110273920200093,
         -0.0023181150224674115,
         -0.044077563909624584,
         0.06677569104403804,
         -0.05841924961832025,
         0.024940124525882738,
         0.019280209647196688,
         -0.05792227266934458,
         0.07869275412841566,
         -0.07710631045877532,
         0.05720765378189583,
         -0.02914310674472166,
         0.0948559524319826,
         0.03353664360028178,
         -0.07660309213780402,
         0.03719111961279091,
         0.02573003253225337,
         -0.0631659759175323,
         0.05717907139001318,
         -0.017908726672952957,
         -0.029784603450197768,
         0.06099315904876375,
         -0.061416620545500615,
         0.03167472854960025,
         0.014704104197081087,
         -0.057922272669344584,
         0.08046627314199534,
         -0.07449090581270326,
         0.04514830683162079,
         -0.0661081536143042,
         -0.08331293780817693,
         0.043734420816975816,
         0.03719111961279091,
         -0.06790138383599553,
         0.03844158875206747,
         0.016499035235336693,
         -0.05640718699340394,
         0.058734897113961806,
         -0.025667690659816837,
         -0.022006305590563352,
         0.05765981092126967,
         -0.061989407694010526,
         0.03167472854960025,
         0.019280209647196688,
         -0.06587546286780396,
         0.08394602394757222,
         -0.06293060428844928,
         0.03175732976916477,
         0.09167551445485511,
         0.029671872287593756,
         -0.0728485856709373,
         0.02573003253225337,
         0.03844158875206736,
         -0.06359547268755564,
         0.038944114508903435,
         0.0113915028089621,
         -0.05223348753037215,
         0.05896912042323505,
         -0.02891493888244871,
         -0.019553878914716483,
         0.05765981092126878,
         -0.06141662054549985,
         0.024940124525882183,
         0.03408384030861791,
         -0.0806156918603826,
         0.07998340216199491,
         -0.05941252375750576,
         -0.08671857305263907,
         0.028767050902699192,
         0.05110273920200093,
         -0.06316597591753241,
         0.016499035235336693,
         0.03894411450890375,
         -0.061212767942002845,
         0.03915181792603558,
         0.008761095130742467,
         -0.05024918301876581,
         0.058958298495492556,
         -0.028914938882448706,
         -0.022006305590562464,
         0.060993159048762846,
         -0.058419249618319576,
         0.007919536912960717,
         0.061708534474805295,
         -0.09317784370559568,
         0.08217513404875057,
         0.057219418852207146,
         -0.06584752514593932,
         -0.0023181150224674115,
         0.05717907139001318,
         -0.05640718699340371,
         0.011391502808961767,
         0.03915181792603569,
         -0.05997601888052378,
         0.039227148955956324,
         0.007945375601228826,
         -0.05024918301876581,
         0.058969120423235044,
         -0.02566769065981772,
         -0.02978460345019688,
         0.06677569104403738,
         -0.04783329457040648,
         -0.028094176940530458,
         0.09932791513252046,
         -0.09595988263992565,
         -0.014806931353309922,
         0.07110229776705594,
         -0.04407756390962458,
         -0.017908726672952954,
         0.058734897113961806,
         -0.05223348753037161,
         0.008761095130741914,
         0.03922714895595654,
         -0.0595903170092212,
         0.03922714895595654,
         0.008761095130742023,
         -0.052233487530371485,
         0.058734897113961806,
         -0.017908726672952954,
         -0.04407756390962458,
         0.07110229776705594,
         -0.014806931353309922,
         -0.09595988263992565,
         0.09932791513252046,
         -0.028094176940530458,
         -0.04783329457040647,
         0.06677569104403738,
         -0.02978460345019688,
         -0.02566769065981772,
         0.058969120423235044,
         -0.05024918301876582,
         0.007945375601228604,
         0.039227148955956324,
         -0.05997601888052379,
         0.03915181792603569,
         0.011391502808961769,
         -0.05640718699340394,
         0.05717907139001318,
         -0.0023181150224674115,
         -0.06584752514593932,
         0.05721941885220714,
         0.08217513404875058,
         -0.09317784370559569,
         0.061708534474805295,
         0.007919536912960717,
         -0.05841924961831959,
         0.060993159048762846,
         -0.02200630559056257,
         -0.02891493888244882,
         0.05895829849549257,
         -0.05024918301876582,
         0.008761095130742356,
         0.039151817926035594,
         -0.061212767942002845,
         0.03894411450890364,
         0.016499035235336693,
         -0.06316597591753231,
         0.05110273920200093,
         0.02876705090269919,
         -0.08671857305263907,
         -0.05941252375750576,
         0.07998340216199491,
         -0.08061569186038263,
         0.03408384030861791,
         0.024940124525882186,
         -0.06141662054549978,
         0.05765981092126857,
         -0.01955387891471637,
         -0.028914938882448813,
         0.05896912042323505,
         -0.052233487530372054,
         0.011391502808962102,
         0.03894411450890354,
         -0.06359547268755565,
         0.03844158875206746,
         0.025730032532253373,
         -0.07284858567093729,
         0.02967187228759375,
         0.09167551445485511,
         0.031757329769164754,
         -0.06293060428844928,
         0.08394602394757224,
         -0.06587546286780396,
         0.01928020964719669,
         0.031674728549600316,
         -0.06198940769401055,
         0.057659810921269455,
         -0.022006305590563463,
         -0.025667690659816833,
         0.05873489711396182,
         -0.05640718699340371,
         0.016499035235336693,
         0.03844158875206736,
         -0.06790138383599555,
         0.0371911196127909,
         0.043734420816975816,
         -0.08331293780817692,
         -0.0661081536143042,
         0.045148306831620785,
         -0.07449090581270325,
         0.08046627314199532,
         -0.057922272669344584,
         0.01470410419708114,
         0.03167472854960031,
         -0.06141662054550058,
         0.06099315904876375,
         -0.029784603450197768,
         -0.017908726672952954,
         0.05717907139001318,
         -0.06316597591753241,
         0.025730032532253373,
         0.0371911196127909,
         -0.07660309213780402,
         0.03353664360028178,
         0.09485595243198258,
         -0.029143106744721668,
         0.05720765378189583,
         -0.07710631045877533,
         0.07869275412841566,
         -0.057922272669344584,
         0.01928020964719669,
         0.02494012452588274,
         -0.058419249618320256,
         0.06677569104403804,
         -0.04407756390962458,
         -0.0023181150224674115,
         0.05110273920200093,
         -0.07284858567093729,
         0.04373442081697582,
         0.03353664360028178,
         -0.10605217885419953,
         0.016485830723228883,
         -0.037574695452703546,
         0.06031262388206407,
         -0.07710631045877533,
         0.08046627314199534,
         -0.06587546286780396,
         0.03408384030861791,
         0.007919536912960717,
         -0.04783329457040647,
         0.07110229776705594,
         -0.06584752514593932,
         0.028767050902699192,
         0.029671872287593742,
         -0.08331293780817692,
         0.09485595243198258,
         -0.007746221910095599,
         0.020172999091434527,
         -0.037574695452703546,
         0.05720765378189583,
         -0.07449090581270325,
         0.08394602394757224,
         -0.08061569186038262,
         0.061708534474805295,
         -0.02809417694053046,
         -0.014806931353309922,
         0.05721941885220714,
         -0.08671857305263908,
         0.09167551445485508,
         -0.0661081536143042,
         0.00263126075105668,
         -0.007746221910095599,
         0.016485830723228883,
         -0.029143106744721665,
         0.04514830683162078,
         -0.06293060428844931,
         0.07998340216199491,
         -0.09317784370559568,
         0.09932791513252046,
         -0.09595988263992565,
         0.08217513404875058,
         -0.05941252375750575,
         0.031757329769164754},
        {0.015529640617599264,
         -0.0344081991238836,
         0.05568441227650829,
         -0.07539705064565595,
         0.0898792498866986,
         -0.09661729050803995,
         0.09470388736980923,
         -0.08489459669968379,
         0.06931614794453005,
         -0.05092178322659555,
         0.032819261743059006,
         -0.017608957296160778,
         0.006854277331423254,
         -0.03732861035752178,
         0.06711386713571244,
         -0.08509615902251523,
         0.08472113529239216,
         -0.06523208909230065,
         0.03126295083540983,
         0.009019417844744065,
         -0.04640291067938101,
         0.07306563537797145,
         -0.08441913317084865,
         0.08000355165271983,
         -0.06328975915244134,
         0.04046023908594883,
         -0.018420316841418174,
         0.06337462491359477,
         -0.08735162683341413,
         0.07707106209520748,
         -0.03934361900306213,
         -0.0093332637583542,
         0.050412321013864426,
         -0.06992352344625248,
         0.0624105359684418,
         -0.03170032346670918,
         -0.011163193022566213,
         0.051929775477304936,
         -0.07787544631078781,
         0.0819300719507619,
         -0.06498759526387901,
         0.03546034120295397,
         -0.08677927909651184,
         0.08190920924413814,
         -0.031735566742805144,
         -0.027152638466902215,
         0.06363523125434828,
         -0.06353534304526182,
         0.03139733048454357,
         0.014944124814718166,
         -0.05338411180754459,
         0.06664622569145771,
         -0.048669768681298985,
         0.006574530675410103,
         0.04224185370794679,
         -0.07700930330005326,
         0.08240238655792383,
         -0.05606772240402487,
         0.10020408029290595,
         -0.04777042092452306,
         -0.027971494359014436,
         0.06748367640711464,
         -0.05481633535345691,
         0.008090338039991773,
         0.04032776579596266,
         -0.062946567324327,
         0.0491492650948144,
         -0.007814235115796332,
         -0.0384925384074757,
         0.06459731886182335,
         -0.05472149220671707,
         0.010879114752101843,
         0.04601941554979972,
         -0.08416385801931357,
         0.07660309213780442,
         -0.09876221979363253,
         -0.005106872809187383,
         0.06871950231045601,
         -0.053951191038022143,
         -0.0035008155527534264,
         0.05210672735179406,
         -0.06031955261636313,
         0.027896660938362267,
         0.021367215518619972,
         -0.05641589686869713,
         0.05619399309174071,
         -0.020388015801969472,
         -0.030206150212460484,
         0.06385025111445435,
         -0.05501517996532083,
         0.0017573954599547823,
         0.06551372012506043,
         -0.0924692566638418,
         0.08217513404875051,
         0.057219418852207354,
         -0.06584752514593908,
         -0.0023181150224668586,
         0.05717907139001269,
         -0.05640718699340334,
         0.011391502808962225,
         0.039151817926035525,
         -0.05997601888052509,
         0.03922714895595482,
         0.007945375601227723,
         -0.05024918301876642,
         0.05896912042323567,
         -0.025667690659817752,
         -0.02978460345019691,
         0.06677569104403745,
         -0.04783329457040608,
         -0.028094176940530586,
         0.09932791513252055,
         -0.05527039603334396,
         -0.08793206442770139,
         0.018785111004190298,
         0.057913564659963127,
         -0.05698099461700039,
         0.001740763583003004,
         0.049482398498523504,
         -0.057547763115759966,
         0.021837840683237016,
         0.02856595837293681,
         -0.05780909176309969,
         0.04595207387300613,
         -0.0007032452814754693,
         -0.04679097015788833,
         0.06050316917586697,
         -0.024481043654438577,
         -0.03875396926424764,
         0.07160566198485589,
         -0.01938682392473084,
         -0.0944796928966853,
         0.026349127455290684,
         0.08541788477880419,
         0.04603249696594666,
         -0.0664201602325926,
         0.0005089909056218396,
         0.0558644342483388,
         -0.054092390714816356,
         0.0067373399939070966,
         0.04300883791149656,
         -0.05806856796755602,
         0.029912575613180673,
         0.019894605077079307,
         -0.055515058583748216,
         0.050232775319310315,
         -0.005197420216302844,
         -0.04731072071256235,
         0.06168498278055536,
         -0.014369312509621843,
         -0.05967515200136581,
         0.06305799683428157,
         0.07801403881463762,
         -0.053293734319150236,
         -0.08826280939772943,
         0.013863458502390886,
         0.06059348648635972,
         -0.053178484617821875,
         -0.0053798410330496435,
         0.05331218463451031,
         -0.054012721677846716,
         0.012722185823143151,
         0.036720136492579804,
         -0.05822024152320729,
         0.03672013649257958,
         0.012722185823142926,
         -0.054012721677846716,
         0.053312184634510436,
         -0.0053798410330496435,
         -0.05317848461782198,
         0.06059348648635972,
         0.013863458502390886,
         -0.08826280939772943,
         -0.053293734319150236,
         0.07801403881463762,
         0.06305799683428157,
         -0.05967515200136582,
         -0.014369312509621843,
         0.06168498278055535,
         -0.04731072071256235,
         -0.005197420216302955,
         0.050232775319310315,
         -0.05551505858374799,
         0.01989460507707908,
         0.029912575613180902,
         -0.0580685679675558,
         0.04300883791149634,
         0.0067373399939070966,
         -0.054092390714816245,
         0.05586443424833879,
         0.0005089909056218396,
         -0.06642016023259258,
         0.04603249696594666,
         0.08541788477880419,
         0.026349127455290684,
         -0.09447969289668531,
         -0.019386823924730838,
         0.07160566198485588,
         -0.038753969264247644,
         -0.02448104365443857,
         0.06050316917586697,
         -0.04679097015788832,
         -0.0007032452814754693,
         0.045952073873005685,
         -0.057809091763099694,
         0.028565958372936802,
         0.021837840683237235,
         -0.05754776311575985,
         0.0494823984985235,
         0.0017407635830030037,
         -0.05698099461700038,
         0.05791356465996315,
         0.018785111004190294,
         -0.0879320644277014,
         -0.055270396033343945,
         0.09932791513252055,
         -0.028094176940530586,
         -0.047833294570406075,
         0.06677569104403745,
         -0.029784603450196914,
         -0.02566769065981775,
         0.058969120423235794,
         -0.05024918301876653,
         0.007945375601227725,
         0.03922714895595482,
         -0.059976018880525186,
         0.03915181792603563,
         0.011391502808962225,
         -0.056407186993403545,
         0.05717907139001269,
         -0.002318115022466858,
         -0.06584752514593908,
         0.05721941885220737,
         0.0821751340487505,
         -0.09246925666384179,
         0.06551372012506045,
         0.0017573954599547823,
         -0.055015179965320835,
         0.06385025111445441,
         -0.03020615021246059,
         -0.020388015801969594,
         0.0561939930917407,
         -0.056415896868697114,
         0.02136721551861986,
         0.02789666093836226,
         -0.060319552616363147,
         0.05210672735179406,
         -0.003500815552753426,
         -0.05395119103802213,
         0.068719502310456,
         -0.005106872809187384,
         -0.09876221979363253,
         0.07660309213780442,
         -0.08416385801931356,
         0.04601941554979972,
         0.010879114752101843,
         -0.054721492206717064,
         0.06459731886182335,
         -0.0384925384074757,
         -0.007814235115796334,
         0.0491492650948144,
         -0.06294656732432702,
         0.04032776579596265,
         0.008090338039991886,
         -0.05481633535345691,
         0.06748367640711465,
         -0.027971494359014443,
         -0.04777042092452306,
         0.10020408029290594,
         -0.05606772240402486,
         0.08240238655792381,
         -0.07700930330005328,
         0.04224185370794678,
         0.006574530675410105,
         -0.048669768681298985,
         0.0666462256914577,
         -0.0533841118075446,
         0.014944124814718162,
         0.03139733048454357,
         -0.0635353430452618,
         0.06363523125434828,
         -0.027152638466902215,
         -0.031735566742805144,
         0.08190920924413814,
         -0.08677927909651183,
         0.03546034120295397,
         -0.06498759526387898,
         0.08193007195076189,
         -0.07787544631078783,
         0.05192977547730494,
         -0.011163193022566211,
         -0.031700323466709174,
         0.06241053596844179,
         -0.06992352344625248,
         0.05041232101386442,
         -0.0093332637583542,
         -0.03934361900306214,
         0.07707106209520748,
         -0.08735162683341414,
         0.06337462491359476,
         -0.018420316841418177,
         0.04046023908594883,
         -0.06328975915244131,
         0.08000355165271983,
         -0.08441913317084865,
         0.07306563537797148,
         -0.04640291067938102,
         0.009019417844744061,
         0.031262950835409836,
         -0.06523208909230067,
         0.08472113529239214,
         -0.08509615902251523,
         0.06711386713571245,
         -0.03732861035752179,
         0.006854277331423254,
         -0.017608957296160778,
         0.032819261743059,
         -0.050921783226595546,
         0.06931614794453006,
         -0.08489459669968376,
         0.09470388736980921,
         -0.09661729050803988,
         0.08987924988669858,
         -0.07539705064565592,
         0.05568441227650829,
         -0.03440819912388295,
         0.015529640617599278},
        {0.011227911616076901,
         -0.025726377438472836,
         0.04324853465571992,
         -0.061162664262881694,
         0.07667145724925824,
         -0.08741891136214364,
         0.09190480983306569,
         -0.08968991062041004,
         0.08139226764089473,
         -0.06850180074864227,
         0.0530612666969419,
         -0.03727554905087321,
         0.023117314165960485,
         -0.011994985329990665,
         0.004533678309003345,
         -0.028990343134503153,
         0.05510072124882422,
         -0.0751004872435221,
         0.08281463890025086,
         -0.07550083190695515,
         0.05421490734440516,
         -0.023157835343711877,
         -0.011578917671856318,
         0.04350599706354791,
         -0.06714519511586516,
         0.07909906620440564,
         -0.07860960302600759,
         0.06752999700069465,
         -0.04973288745032311,
         0.030073019742274026,
         -0.013087601960611296,
         0.05261661542715157,
         -0.07915947023474651,
         0.08048250323112255,
         -0.05729989280950405,
         0.018595559806395223,
         0.022659500235969042,
         -0.05399064616657553,
         0.06687057149012465,
         -0.058575701163506695,
         0.032331940080321975,
         0.004029517691096107,
         -0.04044578432146549,
         0.06741965446240071,
         -0.0785840992616721,
         0.0724193008926762,
         -0.052638313264609306,
         0.02693406262983787,
         -0.07670123835632407,
         0.08371252253615287,
         -0.04976124259106345,
         -0.0015376635500837128,
         0.045197893125348526,
         -0.06441690875972463,
         0.05461272262296392,
         -0.02257415341581083,
         -0.017656461882238062,
         0.05033480459121264,
         -0.06331052514381845,
         0.05174175570179643,
         -0.019403489296950828,
         -0.0226596874573742,
         0.05979119249687376,
         -0.07878181346153933,
         0.07293778639922396,
         -0.045336783090033576,
         0.09393944830629199,
         -0.06063765314036314,
         -0.0053114687800366244,
         0.05436461617234312,
         -0.06367858169297241,
         0.03646889319961347,
         0.007788822901778572,
         -0.04565847338448982,
         0.0599760188805221,
         -0.04558878854856709,
         0.009948289255483345,
         0.03073595496931148,
         -0.058132019344674705,
         0.05903952238642998,
         -0.030990090053475926,
         -0.015756362692306854,
         0.061024130304112474,
         -0.08235835642570842,
         0.06569924042179473,
         -0.09788266416297159,
         0.013751327168227773,
         0.05556710771758651,
         -0.06360892415340892,
         0.023821381286160077,
         0.027182308086170538,
         -0.05715433460694213,
         0.05224901241926615,
         -0.018718149157058148,
         -0.023895017879992434,
         0.05338812248421995,
         -0.05499850903189003,
         0.02764796975156717,
         0.01551391686992732,
         -0.05243030415350679,
         0.06178260076533213,
         -0.0338984198440127,
         -0.021264836190519908,
         0.07366355339321601,
         -0.08384241015893104,
         0.08584877555527085,
         0.040721649763686994,
         -0.07024894786868073,
         0.021625282813895162,
         0.03746519199812212,
         -0.0606879066418228,
         0.039780083452808986,
         0.005188706537323694,
         -0.044642036960390076,
         0.05651768109928385,
         -0.03578734198846288,
         -0.0051147720757939935,
         0.043486551482536814,
         -0.05769029560714162,
         0.03815744962889296,
         0.006342590957905195,
         -0.05048502139504157,
         0.06341168337449389,
         -0.027027135114406107,
         -0.04452744678021799,
         0.09493283551028914,
         -0.06070425135169399,
         -0.08030417630046997,
         0.03668553293236294,
         0.03988474260896552,
         -0.06290991364041951,
         0.029198482696842467,
         0.0231529778623702,
         -0.055075294913102216,
         0.048933980375760126,
         -0.012398515972601358,
         -0.030663120850427338,
         0.0548192373063617,
         -0.04628967148929833,
         0.009690911514001524,
         0.03405260188486991,
         -0.05797923170914359,
         0.04395256088628755,
         0.0039215089268024046,
         -0.05482103576415555,
         0.06297131913443037,
         -0.09493283551028914,
         0.030352125675847018,
         0.08717984370024949,
         0.02776774169323172,
         -0.06883630752005919,
         0.02465305329079326,
         0.035626790174708135,
         -0.05935322146723702,
         0.036609558017347416,
         0.009913857088149335,
         -0.04752701627555357,
         0.0537417844862261,
         -0.026576083648890234,
         -0.016726512515994215,
         0.05003582024243413,
         -0.05258474284177637,
         0.020950916522051912,
         0.02684747873976138,
         -0.058606023936697844,
         0.04625388275163036,
         0.010399371091384266,
         -0.06712765174659167,
         0.047466417755144874,
         0.08221424720519999,
         -0.058776638632275224,
         -0.08129562343212175,
         0.032425736384894877,
         0.04384759850943874,
         -0.06161339006684484,
         0.02308969992432148,
         0.02938800700723934,
         -0.056450662477474815,
         0.043694576509385165,
         -0.003232472356627692,
         -0.038114094822675214,
         0.055245852591130414,
         -0.03811409482267499,
         -0.003232472356627692,
         0.043694576509385595,
         -0.056450662477475266,
         0.029388007007239227,
         0.02308969992432148,
         -0.06161339006684484,
         0.04384759850943874,
         0.03242573638489487,
         -0.08129562343212177,
         -0.058776638632275224,
         0.08221424720519999,
         0.04746641775514487,
         -0.06712765174659167,
         0.010399371091384264,
         0.04625388275163036,
         -0.05860602393669784,
         0.026847478739761503,
         0.020950916522051912,
         -0.05258474284177637,
         0.05003582024243413,
         -0.016726512515994215,
         -0.026576083648890456,
         0.053741784486225644,
         -0.04752701627555379,
         0.009913857088149335,
         0.036609558017347416,
         -0.059353221467237136,
         0.035626790174708135,
         0.02465305329079326,
         -0.06883630752005918,
         0.027767741693231717,
         0.08717984370024948,
         0.030352125675847018,
         -0.09493283551028914,
         0.06297131913443037,
         -0.054821035764155555,
         0.0039215089268024046,
         0.04395256088628744,
         -0.05797923170914359,
         0.0340526018848699,
         0.009690911514001746,
         -0.04628967148929787,
         0.05481923730636171,
         -0.030663120850427345,
         -0.012398515972601137,
         0.048933980375760126,
         -0.055075294913102445,
         0.02315297786237009,
         0.02919848269684236,
         -0.0629099136404195,
         0.039884742608965525,
         0.036685532932362944,
         -0.08030417630046999,
         -0.060704251351694,
         0.09493283551028914,
         -0.044527446780218,
         -0.027027135114406107,
         0.0634116833744939,
         -0.05048502139504156,
         0.006342590957905193,
         0.038157449628893184,
         -0.057690295607141624,
         0.04348655148253681,
         -0.0051147720757939935,
         -0.035787341988462874,
         0.05651768109928407,
         -0.0446420369603903,
         0.005188706537323693,
         0.039780083452808986,
         -0.0606879066418228,
         0.03746519199812212,
         0.021625282813895162,
         -0.07024894786868072,
         0.040721649763687,
         0.08584877555527085,
         -0.08384241015893105,
         0.07366355339321601,
         -0.021264836190519908,
         -0.03389841984401269,
         0.0617826007653321,
         -0.05243030415350666,
         0.01551391686992732,
         0.027647969751567057,
         -0.05499850903188993,
         0.053388122484219834,
         -0.023895017879992327,
         -0.018718149157058148,
         0.05224901241926613,
         -0.05715433460694215,
         0.027182308086170538,
         0.023821381286160074,
         -0.06360892415340892,
         0.05556710771758651,
         0.013751327168227778,
         -0.09788266416297159,
         0.06569924042179472,
         -0.08235835642570843,
         0.06102413030411249,
         -0.015756362692306843,
         -0.03099009005347599,
         0.05903952238643001,
         -0.0581320193446747,
         0.03073595496931148,
         0.009948289255483345,
         -0.04558878854856721,
         0.0599760188805221,
         -0.04565847338448983,
         0.007788822901778574,
         0.036468893199613474,
         -0.06367858169297236,
         0.05436461617234313,
         -0.0053114687800366244,
         -0.06063765314036312,
         0.093939448306292,
         -0.045336783090033576,
         0.07293778639922399,
         -0.07878181346153931,
         0.05979119249687376,
         -0.022659687457374195,
         -0.019403489296950828,
         0.05174175570179643,
         -0.06331052514381849,
         0.050334804591212645,
         -0.017656461882238062,
         -0.022574153415810826,
         0.05461272262296391,
         -0.06441690875972463,
         0.04519789312534852,
         -0.001537663550083713,
         -0.049761242591063445,
         0.08371252253615284,
         -0.07670123835632407,
         0.026934062629837878,
         -0.05263831326460932,
         0.07241930089267619,
         -0.07858409926167212,
         0.06741965446240071,
         -0.04044578432146548,
         0.004029517691096108,
         0.032331940080321975,
         -0.05857570116350668,
         0.06687057149012464,
         -0.053990646166575534,
         0.022659500235969035,
         0.018595559806395226,
         -0.05729989280950405,
         0.08048250323112258,
         -0.07915947023474654,
         0.05261661542715157,
         -0.013087601960611296,
         0.030073019742274026,
         -0.049732887450323116,
         0.06752999700069466,
         -0.07860960302600759,
         0.07909906620440564,
         -0.06714519511586516,
         0.043505997063547915,
         -0.011578917671856322,
         -0.023157835343711877,
         0.054214907344405164,
         -0.07550083190695515,
         0.08281463890025087,
         -0.0751004872435221,
         0.05510072124882422,
         -0.028990343134503157,
         0.004533678309003346,
         -0.011994985329990665,
         0.023117314165960478,
         -0.03727554905087321,
         0.05306126669694191,
         -0.06850180074864225,
         0.08139226764089473,
         -0.08968991062041003,
         0.0919048098330657,
         -0.08741891136214364,
         0.07667145724925824,
         -0.061162664262881694,
         0.0432485346557199,
         -0.0257263774384732,
         0.011227911616076895},
        {0.01408420105401944,
         -0.033030379294147205,
         0.05568441227650814,
         -0.07727756515750796,
         0.0927709516143943,
         -0.09839845347550076,
         0.09277095161439429,
         -0.07727756515750796,
         0.05568441227650815,
         -0.033030379294147365,
         0.014084201054019443,
         -0.03303037929414737,
         0.06337890474308766,
         -0.08386964498510288,
         0.08472113529239221,
         -0.06286446595773473,
         0.023192737903598465,
         0.023192737903598465,
         -0.06286446595773473,
         0.08472113529239221,
         -0.08386964498510287,
         0.06337890474308767,
         -0.033030379294147365,
         0.05568441227650815,
         -0.08386964498510288,
         0.07931629014631975,
         -0.04284825115821157,
         -0.009333263758354242,
         0.05396790115002059,
         -0.07138574104403149,
         0.05396790115002059,
         -0.009333263758354242,
         -0.04284825115821157,
         0.07931629014631975,
         -0.08386964498510288,
         0.05568441227650816,
         -0.07727756515750796,
         0.08472113529239222,
         -0.04284825115821157,
         -0.01816120662228814,
         0.06128213087410702,
         -0.06353534304526194,
         0.026495085090903047,
         0.02649508509090305,
         -0.06353534304526193,
         0.061282130874107006,
         -0.01816120662228814,
         -0.042848251158211566,
         0.08472113529239222,
         -0.07727756515750796,
         0.09277095161439432,
         -0.06286446595773472,
         -0.009333263758354244,
         0.061282130874107006,
         -0.05978154688873396,
         0.013600744415238019,
         0.04032776579596326,
         -0.06361417448848393,
         0.04032776579596327,
         0.013600744415238017,
         -0.05978154688873395,
         0.061282130874107006,
         -0.009333263758354244,
         -0.06286446595773473,
         0.09277095161439435,
         -0.09839845347550079,
         0.023192737903598472,
         0.05396790115002059,
         -0.06353534304526193,
         0.013600744415238017,
         0.043833260401092776,
         -0.06128239750305477,
         0.027896660938361205,
         0.0278966609383612,
         -0.06128239750305477,
         0.04383326040109265,
         0.013600744415238017,
         -0.06353534304526193,
         0.05396790115002059,
         0.023192737903598465,
         -0.09839845347550079,
         0.09277095161439435,
         0.023192737903598472,
         -0.07138574104403146,
         0.02649508509090305,
         0.04032776579596327,
         -0.06128239750305478,
         0.023916979189255207,
         0.03338882214910577,
         -0.05997601888052309,
         0.03338882214910566,
         0.023916979189255207,
         -0.06128239750305478,
         0.04032776579596327,
         0.026495085090903047,
         -0.07138574104403146,
         0.023192737903598465,
         0.09277095161439435,
         -0.07727756515750794,
         -0.06286446595773473,
         0.053967901150020606,
         0.026495085090903054,
         -0.06361417448848283,
         0.027896660938359977,
         0.03338882214910577,
         -0.05929099809041284,
         0.02856595837293442,
         0.0285659583729342,
         -0.05929099809041261,
         0.03338882214910566,
         0.02789666093835998,
         -0.06361417448848283,
         0.02649508509090305,
         0.053967901150020606,
         -0.06286446595773473,
         -0.07727756515750794,
         0.055684412276508145,
         0.08472113529239222,
         -0.009333263758354244,
         -0.06353534304526194,
         0.04032776579596327,
         0.027896660938359977,
         -0.05997601888052154,
         0.02856595837293441,
         0.029912575613182068,
         -0.05822024152321162,
         0.02991257561318228,
         0.028565958372934196,
         -0.05997601888052154,
         0.027896660938359977,
         0.04032776579596328,
         -0.06353534304526193,
         -0.009333263758354244,
         0.08472113529239224,
         0.055684412276508145,
         -0.033030379294147365,
         -0.08386964498510288,
         -0.04284825115821158,
         0.06128213087410699,
         0.013600744415238016,
         -0.06128239750305477,
         0.033388822149104554,
         0.028565958372935747,
         -0.05822024152321028,
         0.028844269341281717,
         0.028844269341281717,
         -0.0582202415232103,
         0.028565958372935976,
         0.033388822149104554,
         -0.06128239750305477,
         0.013600744415238017,
         0.06128213087410699,
         -0.04284825115821158,
         -0.0838696449851029,
         -0.033030379294147365,
         0.014084201054019441,
         0.06337890474308767,
         0.07931629014631975,
         -0.018161206622288144,
         -0.059781546888733945,
         0.04383326040109266,
         0.023916979189255196,
         -0.05929099809041262,
         0.029912575613181173,
         0.028844269341277717,
         -0.057688538682559645,
         0.028844269341277717,
         0.029912575613181173,
         -0.05929099809041307,
         0.023916979189255196,
         0.043833260401092776,
         -0.059781546888733945,
         -0.018161206622288144,
         0.07931629014631973,
         0.06337890474308767,
         0.014084201054019441,
         -0.033030379294147365,
         -0.0838696449851029,
         -0.04284825115821158,
         0.061282130874107006,
         0.013600744415238016,
         -0.06128239750305477,
         0.033388822149104554,
         0.028565958372935744,
         -0.05822024152321028,
         0.028844269341281713,
         0.028844269341281717,
         -0.05822024152321028,
         0.028565958372935973,
         0.033388822149104554,
         -0.06128239750305477,
         0.013600744415238016,
         0.061282130874107006,
         -0.04284825115821158,
         -0.0838696449851029,
         -0.033030379294147365,
         0.055684412276508145,
         0.08472113529239222,
         -0.009333263758354245,
         -0.06353534304526194,
         0.04032776579596328,
         0.027896660938359977,
         -0.05997601888052154,
         0.02856595837293442,
         0.029912575613182075,
         -0.05822024152321163,
         0.029912575613181846,
         0.028565958372934203,
         -0.05997601888052154,
         0.027896660938359977,
         0.04032776579596328,
         -0.06353534304526194,
         -0.009333263758354245,
         0.08472113529239222,
         0.055684412276508145,
         -0.07727756515750794,
         -0.06286446595773472,
         0.0539679011500206,
         0.026495085090903054,
         -0.06361417448848283,
         0.027896660938359977,
         0.03338882214910576,
         -0.059290998090412855,
         0.02856595837293442,
         0.028565958372934203,
         -0.059290998090412626,
         0.03338882214910565,
         0.027896660938359977,
         -0.06361417448848283,
         0.026495085090903054,
         0.0539679011500206,
         -0.06286446595773472,
         -0.07727756515750794,
         0.09277095161439435,
         0.023192737903598465,
         -0.07138574104403148,
         0.026495085090903054,
         0.04032776579596328,
         -0.06128239750305477,
         0.023916979189255196,
         0.03338882214910576,
         -0.05997601888052308,
         0.03338882214910565,
         0.023916979189255196,
         -0.06128239750305477,
         0.04032776579596328,
         0.026495085090903054,
         -0.07138574104403149,
         0.02319273790359847,
         0.09277095161439435,
         -0.09839845347550079,
         0.023192737903598465,
         0.0539679011500206,
         -0.06353534304526193,
         0.013600744415238016,
         0.04383326040109277,
         -0.06128239750305477,
         0.027896660938361205,
         0.027896660938361205,
         -0.06128239750305477,
         0.043833260401092665,
         0.013600744415238016,
         -0.06353534304526193,
         0.0539679011500206,
         0.023192737903598465,
         -0.09839845347550079,
         0.09277095161439437,
         -0.06286446595773472,
         -0.009333263758354244,
         0.061282130874107006,
         -0.059781546888733945,
         0.013600744415238016,
         0.04032776579596328,
         -0.06361417448848393,
         0.04032776579596328,
         0.013600744415238016,
         -0.059781546888733945,
         0.061282130874107006,
         -0.009333263758354244,
         -0.06286446595773473,
         0.09277095161439437,
         -0.07727756515750794,
         0.08472113529239222,
         -0.04284825115821158,
         -0.018161206622288144,
         0.061282130874107006,
         -0.06353534304526193,
         0.026495085090903054,
         0.026495085090903054,
         -0.06353534304526193,
         0.061282130874107006,
         -0.018161206622288144,
         -0.04284825115821158,
         0.08472113529239222,
         -0.07727756515750794,
         0.055684412276508145,
         -0.0838696449851029,
         0.07931629014631973,
         -0.04284825115821158,
         -0.009333263758354245,
         0.0539679011500206,
         -0.07138574104403148,
         0.0539679011500206,
         -0.009333263758354245,
         -0.04284825115821158,
         0.07931629014631972,
         -0.08386964498510288,
         0.055684412276508145,
         -0.033030379294147365,
         0.0633789047430877,
         -0.08386964498510288,
         0.08472113529239222,
         -0.06286446595773473,
         0.023192737903598465,
         0.023192737903598465,
         -0.06286446595773473,
         0.08472113529239222,
         -0.08386964498510288,
         0.0633789047430877,
         -0.033030379294147365,
         0.014084201054019441,
         -0.033030379294147365,
         0.055684412276508145,
         -0.07727756515750794,
         0.09277095161439437,
         -0.09839845347550079,
         0.09277095161439437,
         -0.07727756515750794,
         0.055684412276508145,
         -0.033030379294147365,
         0.014084201054019441},
        {0.019050387675647554,
         -0.04041197492904902,
         0.06249244283759629,
         -0.08067739679127632,
         0.09147956928591319,
         -0.09329122177678702,
         0.0864970693114394,
         -0.0731033661501107,
         0.05606772240402486,
         -0.03852885694326745,
         0.023117314165960405,
         -0.011483355583788293,
         0.00411170086871729,
         -0.0434415677327698,
         0.07304028941419405,
         -0.08526997491064083,
         0.07568210667426624,
         -0.04723984644834282,
         0.008182181419028557,
         0.031260314280411435,
         -0.062030263118767165,
         0.07849481136563448,
         -0.07940178447135857,
         0.06752999700069451,
         -0.04831923013611828,
         0.02795956590727748,
         -0.011483355583788291,
         0.06976325399330749,
         -0.08630964315552947,
         0.06339097737009151,
         -0.01638826988197667,
         -0.03214941041750796,
         0.06283918320376218,
         -0.06588715425689844,
         0.04269215500672774,
         -0.003451456166234832,
         -0.03759426051284391,
         0.06741965446240089,
         -0.07834529739046639,
         0.06994219582997005,
         -0.04831923013611829,
         0.023117314165960405,
         -0.09006397363110617,
         0.06976325399330771,
         -0.00831236801664643,
         -0.04690484881257845,
         0.06632494747343023,
         -0.04593729644828961,
         0.0018752907096606273,
         0.04139708555486188,
         -0.06310213964461177,
         0.05417018594431492,
         -0.019403489296951355,
         -0.02593792400271578,
         0.06321920423410235,
         -0.07834529739046639,
         0.06752999700069451,
         -0.03852885694326744,
         0.09768809516381646,
         -0.026752986660466743,
         -0.04739984852178006,
         0.06619615470969716,
         -0.03145432791002673,
         -0.022004656374441378,
         0.05709384341842987,
         -0.054723460878913485,
         0.019493710381989226,
         0.026796329554519237,
         -0.05813201934467441,
         0.05733382282184487,
         -0.023932729865572638,
         -0.02593792400271577,
         0.06741965446240089,
         -0.07940178447135857,
         0.05606772240402485,
         -0.09006397363110617,
         -0.026752986660466743,
         0.07056158803571776,
         -0.03021266698129155,
         -0.03196742212458975,
         0.0607341079998638,
         -0.04068076721898108,
         -0.007483258989459523,
         0.04870101885699248,
         -0.05670607336961312,
         0.027647969751567324,
         0.019843201212017998,
         -0.056129596585542986,
         0.05733382282184488,
         -0.019403489296951355,
         -0.037594260512843904,
         0.07849481136563446,
         -0.07310336615011073,
         0.0697632539933075,
         0.06976325399330771,
         -0.04739984852178006,
         -0.030212666981291558,
         0.06254616281900927,
         -0.03159058276179876,
         -0.02379043563439052,
         0.056407186993404884,
         -0.04464203696038813,
         0.0005159334806004141,
         0.043486551482535316,
         -0.05687250451488016,
         0.030004808238257193,
         0.019843201212018,
         -0.05813201934467442,
         0.054170185944314934,
         -0.003451456166234832,
         -0.062030263118767165,
         0.08649706931143941,
         -0.04344156773276979,
         -0.0863096431555295,
         -0.008312368016646431,
         0.06619615470969714,
         -0.03196742212458985,
         -0.03159058276179888,
         0.05857984866516222,
         -0.03223939272390446,
         -0.019153053295582048,
         0.05356771137568267,
         -0.046289671489299716,
         0.004074360256449672,
         0.041750100296678465,
         -0.05687250451488016,
         0.027647969751567317,
         0.02679632955451924,
         -0.06310213964461175,
         0.04269215500672774,
         0.031260314280411435,
         -0.09329122177678703,
         0.01905038767564755,
         0.07304028941419405,
         0.0633909773700915,
         -0.04690484881257845,
         -0.031454327910026725,
         0.060734107999863694,
         -0.02379043563439052,
         -0.03223939272390536,
         0.05638506218886877,
         -0.032553930833018774,
         -0.016726512515998236,
         0.052176474428937414,
         -0.04674015212497171,
         0.0040743602564463416,
         0.04348655148253799,
         -0.05670607336961377,
         0.019493710381989226,
         0.04139708555486188,
         -0.06588715425689845,
         0.008182181419028555,
         0.09147956928591319,
         -0.04041197492904914,
         -0.08526997491064081,
         -0.016388269881976666,
         0.06632494747343023,
         -0.022004656374441375,
         -0.04068076721898096,
         0.05640718699340476,
         -0.0191530532955816,
         -0.032553930833015436,
         0.05524585259113005,
         -0.03268388716145126,
         -0.01596816585052277,
         0.05217647442893741,
         -0.04628967148929972,
         0.0005159334806004141,
         0.04870101885699337,
         -0.054723460878913485,
         0.001875290709660627,
         0.06283918320376218,
         -0.047239846448342816,
         -0.08067739679127632,
         0.06249244283759631,
         0.07568210667426625,
         -0.03214941041750796,
         -0.045937296448289616,
         0.057093843418429865,
         -0.0074832589894606345,
         -0.04464203696038503,
         0.053567711375678,
         -0.01672651251599735,
         -0.03268388716145303,
         0.05489057011116853,
         -0.03268388716145303,
         -0.016726512515997126,
         0.05356771137567822,
         -0.04464203696038503,
         -0.0074832589894606345,
         0.057093843418429865,
         -0.04593729644828962,
         -0.03214941041750796,
         0.07568210667426624,
         0.06249244283759629,
         -0.08067739679127632,
         -0.04723984644834282,
         0.06283918320376218,
         0.001875290709660627,
         -0.05472346087891349,
         0.048701018856993475,
         0.0005159334806004141,
         -0.0462896714892995,
         0.05217647442893741,
         -0.015968165850522548,
         -0.03268388716145103,
         0.05524585259113005,
         -0.03255393083301565,
         -0.0191530532955816,
         0.056407186993404884,
         -0.04068076721898106,
         -0.02200465637444137,
         0.06632494747343023,
         -0.016388269881976666,
         -0.08526997491064081,
         -0.04041197492904914,
         0.09147956928591319,
         0.008182181419028557,
         -0.06588715425689845,
         0.041397085554861886,
         0.019493710381989222,
         -0.05670607336961378,
         0.04348655148253776,
         0.00407436025644612,
         -0.04674015212497171,
         0.0521764744289374,
         -0.01672651251599824,
         -0.032553930833018774,
         0.056385062188868774,
         -0.03223939272390513,
         -0.02379043563439052,
         0.060734107999863784,
         -0.031454327910026725,
         -0.046904848812578455,
         0.06339097737009149,
         0.07304028941419403,
         0.019050387675647557,
         -0.09329122177678702,
         0.031260314280411435,
         0.04269215500672774,
         -0.06310213964461175,
         0.026796329554519237,
         0.02764796975156722,
         -0.05687250451488017,
         0.04175010029667825,
         0.004074360256449672,
         -0.0462896714892995,
         0.053567711375682205,
         -0.019153053295582045,
         -0.032239392723904685,
         0.058579848665162214,
         -0.03159058276179876,
         -0.03196742212458975,
         0.06619615470969713,
         -0.008312368016646431,
         -0.08630964315552947,
         -0.04344156773276978,
         0.08649706931143941,
         -0.06203026311876715,
         -0.003451456166234832,
         0.054170185944314934,
         -0.05813201934467441,
         0.019843201212017998,
         0.0300048082382572,
         -0.05687250451488017,
         0.04348655148253532,
         0.0005159334806004141,
         -0.04464203696038837,
         0.05640718699340478,
         -0.02379043563439052,
         -0.03159058276179888,
         0.06254616281900925,
         -0.030212666981291558,
         -0.04739984852178006,
         0.06976325399330771,
         0.06976325399330752,
         -0.07310336615011072,
         0.07849481136563446,
         -0.03759426051284392,
         -0.019403489296951355,
         0.057333822821844814,
         -0.05612959658554299,
         0.019843201212017998,
         0.027647969751567216,
         -0.056706073369613114,
         0.048701018856992365,
         -0.007483258989459523,
         -0.04068076721898096,
         0.060734107999863694,
         -0.03196742212458985,
         -0.03021266698129155,
         0.07056158803571776,
         -0.02675298666046674,
         -0.09006397363110616,
         0.056067722404024856,
         -0.07940178447135857,
         0.0674196544624009,
         -0.025937924002715763,
         -0.023932729865572638,
         0.05733382282184481,
         -0.05813201934467441,
         0.02679632955451924,
         0.019493710381989226,
         -0.05472346087891349,
         0.05709384341842985,
         -0.02200465637444137,
         -0.03145432791002672,
         0.06619615470969713,
         -0.04739984852178006,
         -0.02675298666046674,
         0.09768809516381646,
         -0.03852885694326744,
         0.06752999700069451,
         -0.07834529739046639,
         0.06321920423410234,
         -0.025937924002715766,
         -0.019403489296951355,
         0.05417018594431495,
         -0.06310213964461174,
         0.04139708555486188,
         0.0018752907096606273,
         -0.045937296448289616,
         0.06632494747343023,
         -0.046904848812578455,
         -0.008312368016646431,
         0.0697632539933077,
         -0.09006397363110616,
         0.02311731416596041,
         -0.04831923013611828,
         0.06994219582997005,
         -0.07834529739046639,
         0.0674196544624009,
         -0.03759426051284392,
         -0.003451456166234832,
         0.042692155006727746,
         -0.06588715425689845,
         0.0628391832037622,
         -0.03214941041750796,
         -0.016388269881976666,
         0.0633909773700915,
         -0.08630964315552947,
         0.06976325399330752,
         -0.011483355583788293,
         0.02795956590727748,
         -0.04831923013611828,
         0.06752999700069451,
         -0.07940178447135857,
         0.07849481136563448,
         -0.06203026311876714,
         0.031260314280411435,
         0.008182181419028557,
         -0.047239846448342816,
         0.07568210667426624,
         -0.08526997491064081,
         0.07304028941419405,
         -0.04344156773276978,
         0.004111700868717289,
         -0.011483355583788293,
         0.02311731416596041,
         -0.03852885694326744,
         0.05606772240402485,
         -0.07310336615011072,
         0.08649706931143941,
         -0.09329122177678703,
         0.09147956928591318,
         -0.08067739679127633,
         0.06249244283759629,
         -0.04041197492904914,
         0.019050387675647557},
        {0.009315823350992326,
         -0.022819013743835215,
         0.04045378764062583,
         -0.059546363096536166,
         0.07667145724925822,
         -0.08853257296404032,
         0.09277095161439401,
         -0.08853257296404032,
         0.07667145724925824,
         -0.05954636309653616,
         0.04045378764062582,
         -0.022819013743835655,
         0.009315823350992318,
         -0.02375078252594668,
         0.04885258979255413,
         -0.07085976967251403,
         0.08174601814419348,
         -0.07636659935306048,
         0.05421490734440516,
         -0.019601441118029504,
         -0.019601441118029504,
         0.05421490734440515,
         -0.07636659935306049,
         0.08174601814419348,
         -0.07085976967251402,
         0.04885258979255412,
         -0.02375078252594668,
         0.04324853465571986,
         -0.0722865431258733,
         0.08070772094073689,
         -0.06331710179836085,
         0.025642004978350563,
         0.018804114662064372,
         -0.053990646166575756,
         0.06730312209634842,
         -0.05399064616657575,
         0.018804114662064372,
         0.025642004978350563,
         -0.06331710179836085,
         0.08070772094073689,
         -0.07228654312587332,
         0.04324853465571985,
         -0.0644711089449635,
         0.08281463890025087,
         -0.0614739266510168,
         0.013921103069126894,
         0.035025184200127665,
         -0.062279816187242154,
         0.05662829064333107,
         -0.02257415341580991,
         -0.022574153415809914,
         0.05662829064333107,
         -0.062279816187242154,
         0.03502518420012766,
         0.013921103069126898,
         -0.0614739266510168,
         0.08281463890025088,
         -0.0644711089449635,
         0.08274079614022613,
         -0.07334187695068999,
         0.018595559806395472,
         0.038496466137254014,
         -0.06351645339327835,
         0.04647740969885163,
         -0.0020211151421994813,
         -0.04194693086047573,
         0.0599760188805203,
         -0.04194693086047573,
         -0.0020211151421993707,
         0.04647740969885164,
         -0.06351645339327837,
         0.038496466137254014,
         0.018595559806395472,
         -0.07334187695068999,
         0.08274079614022613,
         -0.09342751289660885,
         0.04338963954825538,
         0.03036642200471774,
         -0.06441690875972572,
         0.04344619497746192,
         0.007668058643393664,
         -0.049884215078096206,
         0.05586347043463874,
         -0.02389501787999213,
         -0.02389501787999213,
         0.05586347043463861,
         -0.04988421507809611,
         0.007668058643393664,
         0.04344619497746192,
         -0.06441690875972572,
         0.03036642200471774,
         0.04338963954825538,
         -0.09342751289660883,
         0.09342751289660894,
         -0.06351592860052989,
         0.04958815948372125,
         0.007788822901780804,
         -0.05266205451813503,
         0.05224951277849926,
         -0.01200585080252197,
         -0.03578734198846403,
         0.05654593287865275,
         -0.035787341988464255,
         -0.012005850802521967,
         0.05224951277849926,
         -0.052662054518135146,
         0.007788822901780804,
         0.04958815948372125,
         -0.06351592860052988,
         0.09342751289660894,
         -0.08227512410891738,
         -0.04426628648202068,
         0.06479920831044636,
         -0.0033132482719443286,
         -0.05228770106760166,
         0.05224901241926454,
         -0.0064523922859995525,
         -0.04192336541228901,
         0.05481923730636355,
         -0.024547809218462866,
         -0.024547809218462644,
         0.05481923730636355,
         -0.04192336541228901,
         -0.006452392285999552,
         0.05224901241926445,
         -0.05228770106760166,
         -0.003313248271944329,
         0.06479920831044637,
         -0.044266286482020675,
         -0.08227512410891738,
         0.06249244283759619,
         0.07568210667426635,
         -0.03214941041750801,
         -0.04593729644828973,
         0.0570938434184304,
         -0.007483258989461743,
         -0.044642036960384796,
         0.053567711375678666,
         -0.016726512515993573,
         -0.03268388716145148,
         0.054890570111173424,
         -0.032683887161451694,
         -0.016726512515993577,
         0.05356771137567888,
         -0.04464203696038502,
         -0.007483258989461743,
         0.0570938434184304,
         -0.04593729644828973,
         -0.032149410417508004,
         0.07568210667426635,
         0.06249244283759619,
         -0.038970885060140105,
         -0.08461516760202502,
         -0.02022689382031325,
         0.06589757820258009,
         -0.01694979990094449,
         -0.04449873194397834,
         0.054329259258782674,
         -0.012398515972605818,
         -0.03811409482267305,
         0.05420009520242189,
         -0.02482519439828854,
         -0.02482519439828876,
         0.05420009520242189,
         -0.03811409482267281,
         -0.012398515972605372,
         0.05432925925878267,
         -0.044498731943978236,
         -0.01694979990094449,
         0.06589757820258009,
         -0.020226893820313254,
         -0.08461516760202502,
         -0.038970885060140105,
         0.017428309627560847,
         0.06971323851024329,
         0.06722347999202019,
         -0.0398361362915664,
         -0.03944301652553213,
         0.05818172537321167,
         -0.011970882287307296,
         -0.041871109198105425,
         0.053741784486225734,
         -0.0181297586218624,
         -0.03172707758824971,
         0.05438927586557589,
         -0.03172707758825016,
         -0.018129758621862627,
         0.053741784486225734,
         -0.041871109198105425,
         -0.011970882287307515,
         0.058181725373211673,
         -0.03944301652553213,
         -0.0398361362915664,
         0.06722347999202019,
         0.06971323851024329,
         0.017428309627560843,
         -0.038970885060140105,
         -0.08461516760202502,
         -0.020226893820313254,
         0.06589757820258009,
         -0.01694979990094449,
         -0.04449873194397835,
         0.05432925925878266,
         -0.012398515972605818,
         -0.03811409482267305,
         0.054200095202421895,
         -0.024825194398288543,
         -0.024825194398288765,
         0.054200095202421895,
         -0.03811409482267283,
         -0.012398515972605372,
         0.054329259258782674,
         -0.04449873194397824,
         -0.01694979990094449,
         0.0658975782025801,
         -0.02022689382031325,
         -0.08461516760202502,
         -0.038970885060140105,
         0.062492442837596175,
         0.07568210667426635,
         -0.03214941041750802,
         -0.04593729644828973,
         0.057093843418430414,
         -0.007483258989461743,
         -0.04464203696038479,
         0.05356771137567865,
         -0.016726512515993577,
         -0.032683887161451486,
         0.05489057011117342,
         -0.032683887161451694,
         -0.016726512515993577,
         0.05356771137567889,
         -0.044642036960385025,
         -0.007483258989461743,
         0.0570938434184304,
         -0.04593729644828973,
         -0.03214941041750802,
         0.07568210667426635,
         0.062492442837596175,
         -0.08227512410891738,
         -0.04426628648202068,
         0.06479920831044636,
         -0.003313248271944328,
         -0.05228770106760165,
         0.05224901241926454,
         -0.0064523922859995525,
         -0.041923365412289026,
         0.05481923730636355,
         -0.02454780921846287,
         -0.024547809218462644,
         0.05481923730636355,
         -0.041923365412289026,
         -0.006452392285999553,
         0.05224901241926444,
         -0.05228770106760165,
         -0.003313248271944328,
         0.06479920831044636,
         -0.04426628648202068,
         -0.08227512410891738,
         0.09342751289660892,
         -0.0635159286005299,
         0.04958815948372126,
         0.007788822901780804,
         -0.05266205451813503,
         0.05224951277849926,
         -0.012005850802521967,
         -0.035787341988464026,
         0.05654593287865276,
         -0.03578734198846426,
         -0.012005850802521967,
         0.05224951277849926,
         -0.05266205451813516,
         0.007788822901780804,
         0.04958815948372125,
         -0.0635159286005299,
         0.09342751289660893,
         -0.09342751289660883,
         0.04338963954825538,
         0.030366422004717737,
         -0.06441690875972572,
         0.04344619497746191,
         0.007668058643393664,
         -0.04988421507809621,
         0.05586347043463872,
         -0.023895017879992125,
         -0.023895017879992125,
         0.05586347043463861,
         -0.04988421507809612,
         0.007668058643393664,
         0.04344619497746191,
         -0.06441690875972572,
         0.030366422004717737,
         0.04338963954825538,
         -0.09342751289660883,
         0.08274079614022611,
         -0.07334187695068999,
         0.018595559806395472,
         0.038496466137254014,
         -0.06351645339327837,
         0.04647740969885164,
         -0.0020211151421994813,
         -0.04194693086047574,
         0.05997601888052028,
         -0.04194693086047574,
         -0.00202111514219937,
         0.04647740969885164,
         -0.06351645339327837,
         0.038496466137254014,
         0.018595559806395472,
         -0.07334187695068999,
         0.08274079614022611,
         -0.0644711089449635,
         0.0828146389002509,
         -0.0614739266510168,
         0.013921103069126894,
         0.03502518420012765,
         -0.062279816187242154,
         0.05662829064333105,
         -0.022574153415809914,
         -0.022574153415809914,
         0.05662829064333105,
         -0.062279816187242154,
         0.03502518420012765,
         0.013921103069126896,
         -0.0614739266510168,
         0.0828146389002509,
         -0.0644711089449635,
         0.04324853465571985,
         -0.07228654312587332,
         0.0807077209407369,
         -0.06331710179836086,
         0.025642004978350563,
         0.018804114662064376,
         -0.053990646166575784,
         0.06730312209634841,
         -0.053990646166575784,
         0.018804114662064376,
         0.025642004978350563,
         -0.06331710179836086,
         0.0807077209407369,
         -0.07228654312587332,
         0.04324853465571985,
         -0.023750782525946684,
         0.048852589792554156,
         -0.07085976967251405,
         0.08174601814419348,
         -0.07636659935306049,
         0.054214907344405164,
         -0.019601441118029504,
         -0.019601441118029504,
         0.054214907344405164,
         -0.07636659935306049,
         0.08174601814419348,
         -0.07085976967251405,
         0.048852589792554156,
         -0.023750782525946684,
         0.00931582335099232,
         -0.022819013743835655,
         0.04045378764062583,
         -0.059546363096536145,
         0.07667145724925821,
         -0.08853257296404034,
         0.09277095161439397,
         -0.08853257296404034,
         0.07667145724925821,
         -0.059546363096536145,
         0.04045378764062583,
         -0.022819013743835655,
         0.00931582335099232},
        {0.006344790738164419,
         -0.016072078408310042,
         0.02959752702676674,
         -0.04550360001602734,
         0.06161216567989988,
         -0.07545918393178637,
         0.08480880122885315,
         -0.08810998070408813,
         0.08480880122885315,
         -0.07545918393178637,
         0.06161216567989988,
         -0.04550360001602734,
         0.029597527026766744,
         -0.016072078408310264,
         0.00634479073816442,
         -0.017375925049712578,
         0.0376478376077105,
         -0.05828688068129256,
         0.07331806078609078,
         -0.07771219150635865,
         0.06888449535061808,
         -0.04740956115949589,
         0.016894317592013038,
         0.016894317592013038,
         -0.04740956115949589,
         0.0688844953506181,
         -0.07771219150635864,
         0.07331806078609075,
         -0.05828688068129256,
         0.0376478376077105,
         -0.017375925049712578,
         0.033824967060311815,
         -0.060989683650045395,
         0.07591656061154323,
         -0.07173713971140479,
         0.04844804939343961,
         -0.012606582145347284,
         -0.02511819911600336,
         0.053442094071812135,
         -0.06392169839846734,
         0.053442094071812135,
         -0.025118199116003364,
         -0.012606582145347281,
         0.04844804939343961,
         -0.07173713971140479,
         0.07591656061154325,
         -0.060989683650045395,
         0.033824967060311815,
         -0.053679684746452655,
         0.0770457583040435,
         -0.07023667195265083,
         0.037216654198436616,
         0.007126083151518785,
         -0.04450237501765612,
         0.06073511418396309,
         -0.05070147386300041,
         0.019571943071040047,
         0.019571943071040047,
         -0.05070147386300041,
         0.060735114183963095,
         -0.04450237501765612,
         0.007126083151518784,
         0.037216654198436616,
         -0.07023667195265082,
         0.0770457583040435,
         -0.053679684746452655,
         0.07307028021668943,
         -0.07706867154122049,
         0.03884090487806596,
         0.013921103069128485,
         -0.0520879981306409,
         0.05876318706129478,
         -0.0343704501282919,
         -0.006373984398046576,
         0.04263404495475365,
         -0.05696272135092201,
         0.04263404495475365,
         -0.006373984398046577,
         -0.0343704501282919,
         0.05876318706129478,
         -0.05208799813064089,
         0.013921103069128485,
         0.03884090487806596,
         -0.0770686715412205,
         0.07307028021668943,
         -0.08722645147887954,
         0.05669817440703059,
         0.007797869593292822,
         -0.05395612349287344,
         0.05705954310287752,
         -0.023294460926399797,
         -0.022151871507867398,
         0.052035357391443784,
         -0.050841677876719185,
         0.020799844947188166,
         0.020799844947188166,
         -0.050841677876719185,
         0.0520353573914438,
         -0.022151871507867394,
         -0.023294460926399793,
         0.05705954310287751,
         -0.05395612349287344,
         0.007797869593292822,
         0.056698174407030594,
         -0.08722645147887954,
         0.09194475296247416,
         -0.01876814410702568,
         -0.049761242591062294,
         0.05964908733516737,
         -0.02004867982818187,
         -0.0300730197422733,
         0.05519379115102071,
         -0.04229728354665029,
         0.002970540500439426,
         0.03710203895885289,
         -0.053704968722770044,
         0.03710203895885268,
         0.0029705405004396483,
         -0.04229728354665029,
         0.05519379115102059,
         -0.030073019742273405,
         -0.02004867982818187,
         0.059649087335167376,
         -0.049761242591062294,
         -0.01876814410702568,
         0.09194475296247416,
         -0.08512430036128048,
         -0.026542163936729687,
         0.06652828571405973,
         -0.026799053946934305,
         -0.03160637410633141,
         0.0567062298413808,
         -0.03584941895096339,
         -0.00956142558514969,
         0.04607960459077729,
         -0.05041174395965994,
         0.021420872180377856,
         0.021420872180377633,
         -0.05041174395965974,
         0.04607960459077707,
         -0.009561425585150135,
         -0.03584941895096317,
         0.056706229841380705,
         -0.0316063741063314,
         -0.02679905394693431,
         0.06652828571405975,
         -0.026542163936729694,
         -0.08512430036128046,
         0.06781235916623692,
         0.06474628603880786,
         -0.047584162167049034,
         -0.024940358767580814,
         0.058873873139906385,
         -0.03385345503215388,
         -0.017186032090609153,
         0.05094232310637511,
         -0.045138916238152235,
         0.0075198011062658,
         0.03430744283401522,
         -0.0521327742053815,
         0.03430744283401501,
         0.0075198011062660225,
         -0.045138916238152235,
         0.05094232310637532,
         -0.017186032090609156,
         -0.03385345503215388,
         0.058873873139906385,
         -0.024940358767580818,
         -0.047584162167049034,
         0.06474628603880786,
         0.06781235916623692,
         -0.044256380431586535,
         -0.08258155274754617,
         -0.00029008262543694853,
         0.06119712210463529,
         -0.0384918256961917,
         -0.02008550020783345,
         0.05406672048262534,
         -0.0402600916482646,
         -0.003969081919263029,
         0.04314237543216658,
         -0.0500945853483735,
         0.021688545061119884,
         0.021688545061119884,
         -0.050094585348373716,
         0.04314237543216658,
         -0.003969081919263252,
         -0.0402600916482646,
         0.05406672048262535,
         -0.02008550020783357,
         -0.0384918256961917,
         0.06119712210463529,
         -0.00029008262543694853,
         -0.0825815527475462,
         -0.044256380431586535,
         0.020672127263040397,
         0.07407512269256193,
         0.05362769246498923,
         -0.05325319740587421,
         -0.01677737864826346,
         0.05714794602065471,
         -0.03741796948527254,
         -0.013099442962446882,
         0.04930720209879489,
         -0.04583819523543906,
         0.008893272140624273,
         0.03344437980542237,
         -0.05165666583807379,
         0.03344437980542282,
         0.008893272140624053,
         -0.04583819523543863,
         0.04930720209879511,
         -0.013099442962446658,
         -0.037417969485272436,
         0.05714794602065471,
         -0.01677737864826346,
         -0.05325319740587421,
         0.05362769246498923,
         0.07407512269256192,
         0.020672127263040393,
         -0.044256380431586535,
         -0.08258155274754618,
         -0.00029008262543694853,
         0.061197122104635286,
         -0.0384918256961917,
         -0.02008550020783345,
         0.05406672048262534,
         -0.0402600916482646,
         -0.003969081919263029,
         0.043142375432166584,
         -0.0500945853483735,
         0.021688545061119884,
         0.021688545061119884,
         -0.05009458534837371,
         0.04314237543216658,
         -0.003969081919263251,
         -0.0402600916482646,
         0.05406672048262534,
         -0.020085500207833566,
         -0.0384918256961917,
         0.061197122104635286,
         -0.0002900826254369486,
         -0.08258155274754618,
         -0.04425638043158653,
         0.06781235916623693,
         0.06474628603880786,
         -0.04758416216704904,
         -0.024940358767580814,
         0.058873873139906385,
         -0.03385345503215388,
         -0.01718603209060916,
         0.05094232310637511,
         -0.04513891623815224,
         0.007519801106265802,
         0.034307442834015225,
         -0.0521327742053815,
         0.034307442834015,
         0.007519801106266022,
         -0.04513891623815224,
         0.05094232310637533,
         -0.01718603209060916,
         -0.03385345503215388,
         0.058873873139906385,
         -0.024940358767580818,
         -0.04758416216704904,
         0.06474628603880786,
         0.06781235916623692,
         -0.08512430036128046,
         -0.026542163936729694,
         0.06652828571405973,
         -0.02679905394693431,
         -0.0316063741063314,
         0.056706229841380795,
         -0.0358494189509634,
         -0.009561425585149691,
         0.04607960459077729,
         -0.05041174395965995,
         0.021420872180377856,
         0.021420872180377633,
         -0.05041174395965973,
         0.04607960459077707,
         -0.009561425585150135,
         -0.035849418950963184,
         0.0567062298413807,
         -0.0316063741063314,
         -0.02679905394693431,
         0.06652828571405973,
         -0.026542163936729694,
         -0.08512430036128048,
         0.09194475296247416,
         -0.018768144107025684,
         -0.049761242591062294,
         0.059649087335167376,
         -0.02004867982818187,
         -0.0300730197422733,
         0.05519379115102071,
         -0.042297283546650286,
         0.002970540500439425,
         0.0371020389588529,
         -0.053704968722770044,
         0.037102038958852675,
         0.002970540500439648,
         -0.042297283546650286,
         0.05519379115102059,
         -0.030073019742273416,
         -0.02004867982818187,
         0.05964908733516738,
         -0.049761242591062294,
         -0.018768144107025684,
         0.09194475296247416,
         -0.08722645147887956,
         0.05669817440703058,
         0.00779786959329282,
         -0.05395612349287345,
         0.05705954310287754,
         -0.023294460926399793,
         -0.02215187150786739,
         0.0520353573914438,
         -0.050841677876719206,
         0.02079984494718817,
         0.02079984494718817,
         -0.050841677876719206,
         0.0520353573914438,
         -0.02215187150786739,
         -0.023294460926399797,
         0.05705954310287754,
         -0.05395612349287345,
         0.00779786959329282,
         0.05669817440703058,
         -0.08722645147887954,
         0.07307028021668945,
         -0.07706867154122049,
         0.038840904878065956,
         0.013921103069128487,
         -0.05208799813064088,
         0.0587631870612948,
         -0.034370450128291895,
         -0.006373984398046578,
         0.04263404495475364,
         -0.05696272135092201,
         0.04263404495475364,
         -0.006373984398046578,
         -0.03437045012829189,
         0.0587631870612948,
         -0.05208799813064088,
         0.013921103069128487,
         0.03884090487806596,
         -0.07706867154122049,
         0.07307028021668945,
         -0.053679684746452655,
         0.07704575830404353,
         -0.07023667195265085,
         0.03721665419843662,
         0.007126083151518784,
         -0.044502375017656116,
         0.06073511418396309,
         -0.05070147386300041,
         0.019571943071040047,
         0.019571943071040047,
         -0.05070147386300041,
         0.060735114183963095,
         -0.044502375017656116,
         0.007126083151518784,
         0.03721665419843662,
         -0.07023667195265085,
         0.07704575830404353,
         -0.053679684746452655,
         0.033824967060311815,
         -0.06098968365004539,
         0.07591656061154324,
         -0.0717371397114048,
         0.04844804939343961,
         -0.012606582145347288,
         -0.025118199116003367,
         0.05344209407181213,
         -0.06392169839846736,
         0.05344209407181213,
         -0.025118199116003367,
         -0.012606582145347288,
         0.04844804939343961,
         -0.0717371397114048,
         0.07591656061154324,
         -0.06098968365004539,
         0.033824967060311815,
         -0.017375925049712578,
         0.037647837607710496,
         -0.058286880681292584,
         0.0733180607860908,
         -0.07771219150635866,
         0.06888449535061808,
         -0.04740956115949588,
         0.016894317592013035,
         0.016894317592013035,
         -0.04740956115949588,
         0.0688844953506181,
         -0.07771219150635866,
         0.0733180607860908,
         -0.058286880681292584,
         0.037647837607710496,
         -0.017375925049712578,
         0.006344790738164419,
         -0.016072078408310268,
         0.02959752702676674,
         -0.04550360001602733,
         0.0616121656798999,
         -0.07545918393178637,
         0.08480880122885312,
         -0.08810998070408811,
         0.08480880122885312,
         -0.07545918393178637,
         0.0616121656798999,
         -0.04550360001602733,
         0.02959752702676674,
         -0.016072078408310268,
         0.006344790738164419},
        {0.011870016566493911,
         -0.027837656386424214,
         0.047156408326486356,
         -0.06618208239773753,
         0.08105616599464442,
         -0.08879258108029989,
         0.08801025234082839,
         -0.07918594054822217,
         0.0644169087597251,
         -0.046797799256487,
         0.0295975270267666,
         -0.015456804380714829,
         0.005804552610137431,
         -0.028854374276504464,
         0.05579022582136511,
         -0.07525595387266105,
         0.07920222557472803,
         -0.06466045181650472,
         0.034562465310195314,
         0.003546034120295127,
         -0.0401187963644755,
         0.06659246890670753,
         -0.07782447619359473,
         0.07331806078609053,
         -0.056951051589336235,
         0.03535500226174589,
         -0.015456804380714829,
         0.04997724226751406,
         -0.07634149857201013,
         0.07502805379311554,
         -0.04607220803524348,
         0.0017501384621548494,
         0.039909297301395856,
         -0.06293586230778313,
         0.05937180886333585,
         -0.03158426401330896,
         -0.009381924422851714,
         0.04844804939343975,
         -0.07232387157820726,
         0.07440381072994344,
         -0.05695105158933625,
         0.029597527026766605,
         -0.07067849382472434,
         0.07902095836969135,
         -0.04359406772149924,
         -0.010353958773578998,
         0.0519174968609637,
         -0.06100431405734506,
         0.036191559188427425,
         0.007238311837687286,
         -0.046234628331921414,
         0.061162664262883124,
         -0.04450237501765656,
         0.00378008507334281,
         0.04221492807372633,
         -0.07232387157820726,
         0.07331806078609052,
         -0.04679779925648699,
         0.08580043727691443,
         -0.059576827050181184,
         -0.005345847577643708,
         0.054166565910499294,
         -0.05753643674591611,
         0.020843708625390252,
         0.02738083334425981,
         -0.0559199811132252,
         0.04841388693809642,
         -0.010606951189000536,
         -0.03437045012829121,
         0.05923501799266921,
         -0.04763065897792288,
         0.0037800850733428096,
         0.048448049393439746,
         -0.07782447619359475,
         0.0644169087597251,
         -0.09134154061450368,
         0.022153577644720264,
         0.048765539300395365,
         -0.059512834736278435,
         0.0168203167212066,
         0.03540574480228731,
         -0.05661865599201083,
         0.03481001415709163,
         0.011456816709430292,
         -0.048991408994002755,
         0.05203535739144256,
         -0.01810069682220655,
         -0.03035586604248843,
         0.05923501799266922,
         -0.04450237501765657,
         -0.009381924422851712,
         0.06659246890670752,
         -0.07918594054822217,
         0.08580043727691443,
         0.022153577644720264,
         -0.06597737573427179,
         0.02532374887526049,
         0.03531228067653048,
         -0.05662562393021714,
         0.026978443642060736,
         0.023328492297248028,
         -0.05312922246309268,
         0.04083818009463346,
         0.0029705405004394254,
         -0.04497072249164899,
         0.05274088711316057,
         -0.01810069682220655,
         -0.034370450128291215,
         0.06116266426288311,
         -0.03158426401330895,
         -0.0401187963644755,
         0.08801025234082839,
         -0.07067849382472434,
         -0.05957682705018118,
         0.048765539300395365,
         0.025323748875259823,
         -0.05848269292008882,
         0.02669357511331609,
         0.02806335501469751,
         -0.05394084539666084,
         0.031971415780665334,
         0.01624526985410264,
         -0.05041174395965505,
         0.04306585266072781,
         0.00033327574794905676,
         -0.04497072249164899,
         0.052035357391442556,
         -0.010606951189000536,
         -0.046234628331921414,
         0.05937180886333585,
         0.0035460341202951267,
         -0.08879258108029987,
         0.04997724226751406,
         0.07902095836969135,
         -0.005345847577643709,
         -0.05951283473627843,
         0.035312280676531256,
         0.026693575113316086,
         -0.05477406041204198,
         0.02738703020601744,
         0.02389251127811202,
         -0.05206111400078679,
         0.034307442834004116,
         0.01297922564436767,
         -0.04943590261265592,
         0.04306585266072781,
         0.0029705405004394254,
         -0.048991408994002755,
         0.04841388693809643,
         0.007238311837687284,
         -0.06293586230778314,
         0.03456246531019532,
         0.08105616599464444,
         -0.028854374276504467,
         -0.0763414985720101,
         -0.04359406772149924,
         0.054166565910499294,
         0.0168203167212066,
         -0.0566256239302178,
         0.028063355014697727,
         0.02738703020601766,
         -0.052721863798635145,
         0.027744080062446136,
         0.021688545061126097,
         -0.051111940606125845,
         0.034993953534807956,
         0.01297922564436767,
         -0.050411743959655045,
         0.04083818009463346,
         0.011456816709430296,
         -0.055919981113225214,
         0.036191559188427425,
         0.03990929730139584,
         -0.06466045181650475,
         -0.06618208239773753,
         0.01187001656649391,
         0.05579022582136509,
         0.07502805379311556,
         -0.010353958773579,
         -0.057536436745916124,
         0.035405744802287434,
         0.026978443642060725,
         -0.05394084539666083,
         0.02389251127811202,
         0.02774408006244614,
         -0.051656665838086216,
         0.02789778805340673,
         0.020996372120875625,
         -0.05111194060612585,
         0.034307442834004116,
         0.01624526985410264,
         -0.053129222463092665,
         0.03481001415709163,
         0.027380833344259812,
         -0.06100431405734505,
         0.0017501384621548492,
         0.07920222557472804,
         0.04715640832648635,
         -0.027837656386424173,
         -0.07525595387266107,
         -0.046072208035243485,
         0.05191749686096371,
         0.020843708625390252,
         -0.05661865599201083,
         0.023328492297248024,
         0.03197141578066355,
         -0.052061114000783455,
         0.021688545061121656,
         0.027897788053406286,
         -0.05132446518436879,
         0.02789778805340673,
         0.021688545061121656,
         -0.05206111400078346,
         0.03197141578066355,
         0.023328492297248024,
         -0.05661865599201083,
         0.020843708625390256,
         0.051917496860963704,
         -0.046072208035243485,
         -0.07525595387266107,
         -0.027837656386424173,
         0.04715640832648635,
         0.07920222557472804,
         0.001750138462154849,
         -0.06100431405734505,
         0.027380833344259812,
         0.03481001415709163,
         -0.053129222463092665,
         0.01624526985410264,
         0.03430744283400434,
         -0.05111194060612629,
         0.020996372120875625,
         0.027897788053406283,
         -0.051656665838086216,
         0.027744080062446136,
         0.02389251127811202,
         -0.05394084539666084,
         0.026978443642060725,
         0.03540574480228731,
         -0.057536436745916124,
         -0.010353958773579,
         0.07502805379311556,
         0.0557902258213651,
         0.01187001656649391,
         -0.06618208239773753,
         -0.06466045181650475,
         0.039909297301395856,
         0.036191559188427425,
         -0.055919981113225214,
         0.011456816709430296,
         0.04083818009463346,
         -0.050411743959655045,
         0.01297922564436767,
         0.03499395353480795,
         -0.05111194060612629,
         0.021688545061126545,
         0.027744080062446136,
         -0.052721863798635145,
         0.027387030206017432,
         0.028063355014697505,
         -0.0566256239302178,
         0.0168203167212066,
         0.054166565910499294,
         -0.04359406772149925,
         -0.07634149857201011,
         -0.028854374276504467,
         0.08105616599464444,
         0.03456246531019533,
         -0.06293586230778316,
         0.007238311837687284,
         0.04841388693809642,
         -0.04899140899400285,
         0.002970540500439425,
         0.04306585266072781,
         -0.04943590261265614,
         0.01297922564436767,
         0.03430744283400434,
         -0.052061114000786786,
         0.02389251127811202,
         0.027387030206017654,
         -0.05477406041204198,
         0.02669357511331608,
         0.03531228067653126,
         -0.05951283473627844,
         -0.005345847577643709,
         0.07902095836969136,
         0.04997724226751406,
         -0.08879258108029989,
         0.003546034120295127,
         0.05937180886333588,
         -0.04623462833192141,
         -0.010606951189000536,
         0.05203535739144245,
         -0.044970722491648546,
         0.0003332757479490568,
         0.04306585266072781,
         -0.05041174395965505,
         0.01624526985410264,
         0.031971415780665334,
         -0.05394084539666085,
         0.02806335501469773,
         0.02669357511331608,
         -0.05848269292008882,
         0.02532374887525982,
         0.048765539300395365,
         -0.05957682705018118,
         -0.07067849382472434,
         0.08801025234082839,
         -0.040118796364475504,
         -0.03158426401330896,
         0.06116266426288311,
         -0.03437045012829111,
         -0.01810069682220644,
         0.052740887113160675,
         -0.044970722491648546,
         0.0029705405004394254,
         0.040838180094633456,
         -0.053129222463092665,
         0.023328492297248024,
         0.026978443642060725,
         -0.05662562393021714,
         0.03531228067653047,
         0.025323748875260493,
         -0.06597737573427179,
         0.022153577644720264,
         0.08580043727691446,
         -0.07918594054822217,
         0.06659246890670752,
         -0.009381924422851715,
         -0.04450237501765655,
         0.059235017992669205,
         -0.03035586604248843,
         -0.01810069682220644,
         0.05203535739144245,
         -0.04899140899400286,
         0.011456816709430296,
         0.03481001415709163,
         -0.05661865599201083,
         0.03540574480228743,
         0.0168203167212066,
         -0.05951283473627844,
         0.048765539300395365,
         0.02215357764472026,
         -0.09134154061450368,
         0.06441690875972508,
         -0.07782447619359475,
         0.04844804939343975,
         0.003780085073342809,
         -0.04763065897792282,
         0.059235017992669205,
         -0.03437045012829111,
         -0.010606951189000536,
         0.048413886938096416,
         -0.055919981113225214,
         0.027380833344259815,
         0.020843708625390252,
         -0.05753643674591613,
         0.05416656591049928,
         -0.00534584757764371,
         -0.05957682705018118,
         0.08580043727691444,
         -0.04679779925648701,
         0.07331806078609052,
         -0.07232387157820724,
         0.042214928073726336,
         0.003780085073342809,
         -0.044502375017656554,
         0.06116266426288311,
         -0.04623462833192141,
         0.007238311837687284,
         0.036191559188427425,
         -0.06100431405734505,
         0.05191749686096372,
         -0.010353958773579,
         -0.04359406772149924,
         0.07902095836969136,
         -0.07067849382472434,
         0.02959752702676661,
         -0.05695105158933625,
         0.07440381072994344,
         -0.07232387157820724,
         0.048448049393439746,
         -0.009381924422851714,
         -0.03158426401330896,
         0.059371808863335866,
         -0.06293586230778316,
         0.039909297301395856,
         0.001750138462154849,
         -0.04607220803524347,
         0.07502805379311554,
         -0.07634149857201011,
         0.049977242267514065,
         -0.015456804380714829,
         0.035355002261745906,
         -0.05695105158933625,
         0.07331806078609052,
         -0.07782447619359477,
         0.06659246890670752,
         -0.040118796364475504,
         0.003546034120295127,
         0.03456246531019533,
         -0.06466045181650475,
         0.07920222557472804,
         -0.07525595387266107,
         0.05579022582136509,
         -0.028854374276504467,
         0.005804552610137431,
         -0.015456804380714829,
         0.02959752702676661,
         -0.04679779925648701,
         0.06441690875972508,
         -0.07918594054822217,
         0.08801025234082839,
         -0.08879258108029989,
         0.08105616599464444,
         -0.06618208239773753,
         0.04715640832648635,
         -0.027837656386424166,
         0.011870016566493915},
        {0.0076413264091301876,
         -0.019481636234942812,
         0.0356456775720244,
         -0.05373788086563253,
         0.07035940192950856,
         -0.08205245760021011,
         0.08626297667839179,
         -0.08205245760021011,
         0.07035940192950857,
         -0.05373788086563253,
         0.035645677572024415,
         -0.01948163623494335,
         0.007641326409130183,
         -0.01948163623494335,
         0.04202729525021599,
         -0.06332346173655805,
         0.0752330332118854,
         -0.07181026388945427,
         0.05170339000040713,
         -0.018824124776235185,
         -0.018824124776235185,
         0.05170339000040712,
         -0.07181026388945427,
         0.07523303321188539,
         -0.06332346173655805,
         0.04202729525021599,
         -0.019481636234943343,
         0.03564567757202441,
         -0.06332346173655805,
         0.0745859903847714,
         -0.061804004750304134,
         0.02800960520681407,
         0.014399470260609178,
         -0.04902681079973406,
         0.062309052222875076,
         -0.04902681079973406,
         0.014399470260609178,
         0.028009605206814076,
         -0.061804004750304134,
         0.0745859903847714,
         -0.06332346173655803,
         0.035645677572024415,
         -0.053737880865632526,
         0.07523303321188536,
         -0.061804004750304134,
         0.02043224235484832,
         0.026938942133121944,
         -0.05618545886391127,
         0.05349278735419257,
         -0.021703194535981025,
         -0.021703194535981025,
         0.05349278735419257,
         -0.05618545886391127,
         0.026938942133121938,
         0.020432242354848317,
         -0.06180400475030412,
         0.07523303321188538,
         -0.05373788086563253,
         0.07035940192950856,
         -0.07181026388945427,
         0.028009605206814073,
         0.02693894213312194,
         -0.057143832276973186,
         0.046682675344687875,
         -0.006028665148883455,
         -0.03709886503035077,
         0.05523107166263579,
         -0.03709886503035077,
         -0.00602866514888334,
         0.046682675344687875,
         -0.05714383227697319,
         0.026938942133121938,
         0.028009605206814073,
         -0.07181026388945427,
         0.07035940192950857,
         -0.08205245760021011,
         0.051703390000407114,
         0.01439947026060918,
         -0.05618545886391127,
         0.04668267534468787,
         -0.00116281054051759,
         -0.04236208106508179,
         0.05220380452638274,
         -0.023012946526097106,
         -0.023012946526097547,
         0.05220380452638286,
         -0.042362081065081804,
         -0.00116281054051759,
         0.04668267534468786,
         -0.05618545886391127,
         0.014399470260609181,
         0.05170339000040711,
         -0.08205245760021011,
         0.08626297667839182,
         -0.01882412477623518,
         -0.04902681079973405,
         0.05349278735419257,
         -0.006028665148883454,
         -0.0423620810650818,
         0.05071777402673019,
         -0.016139152732152166,
         -0.03062128569169388,
         0.0517286380776756,
         -0.0306212856916941,
         -0.016139152732151947,
         0.05071777402673018,
         -0.0423620810650818,
         -0.00602866514888334,
         0.053492787354192564,
         -0.049026810799734054,
         -0.018824124776235178,
         0.08626297667839179,
         -0.08205245760021011,
         -0.018824124776235178,
         0.062309052222875104,
         -0.02170319453598103,
         -0.03709886503035077,
         0.05220380452638274,
         -0.016139152732152166,
         -0.0327597826716315,
         0.05062047373912939,
         -0.02370503995878882,
         -0.023705039958789035,
         0.050620473739129604,
         -0.03275978267163129,
         -0.016139152732151947,
         0.052203804526382874,
         -0.03709886503035077,
         -0.021703194535981025,
         0.06230905222287509,
         -0.018824124776235178,
         -0.08205245760021013,
         0.07035940192950856,
         0.05170339000040711,
         -0.04902681079973406,
         -0.021703194535981025,
         0.05523107166263576,
         -0.0230129465260971,
         -0.03062128569169388,
         0.050620473739129396,
         -0.021455165913059078,
         -0.026863013180803655,
         0.04979054301806719,
         -0.026863013180803655,
         -0.021455165913059078,
         0.050620473739129604,
         -0.0306212856916941,
         -0.023012946526097547,
         0.05523107166263576,
         -0.02170319453598103,
         -0.04902681079973406,
         0.05170339000040711,
         0.07035940192950857,
         -0.05373788086563252,
         -0.07181026388945425,
         0.014399470260609176,
         0.05349278735419257,
         -0.03709886503035077,
         -0.023012946526097547,
         0.05172863807767558,
         -0.02370503995878882,
         -0.026863013180803655,
         0.04941507650389901,
         -0.02407341777314943,
         -0.024073417773148986,
         0.049415076503899445,
         -0.026863013180803655,
         -0.023705039958789042,
         0.05172863807767558,
         -0.0230129465260971,
         -0.03709886503035077,
         0.05349278735419257,
         0.014399470260609174,
         -0.07181026388945423,
         -0.05373788086563252,
         0.03564567757202442,
         0.0752330332118854,
         0.028009605206814076,
         -0.05618545886391127,
         -0.006028665148883341,
         0.052203804526382874,
         -0.0306212856916941,
         -0.023705039958789042,
         0.0497905430180672,
         -0.024073417773149433,
         -0.024864911107061807,
         0.04878456976416204,
         -0.024864911107061807,
         -0.024073417773148982,
         0.04979054301806719,
         -0.02370503995878882,
         -0.030621285691693884,
         0.052203804526382756,
         -0.006028665148883452,
         -0.05618545886391126,
         0.028009605206814076,
         0.0752330332118854,
         0.035645677572024415,
         -0.019481636234943346,
         -0.06332346173655802,
         -0.061804004750304106,
         0.02693894213312194,
         0.04668267534468786,
         -0.04236208106508178,
         -0.01613915273215195,
         0.05062047373912962,
         -0.026863013180803655,
         -0.02407341777314898,
         0.04878456976416204,
         -0.02423541968661881,
         -0.024235419686618364,
         0.04878456976416204,
         -0.024073417773149426,
         -0.026863013180803655,
         0.050620473739129396,
         -0.016139152732152166,
         -0.04236208106508178,
         0.04668267534468787,
         0.026938942133121944,
         -0.061804004750304106,
         -0.06332346173655802,
         -0.019481636234943346,
         0.00764132640913018,
         0.04202729525021601,
         0.0745859903847714,
         0.02043224235484832,
         -0.05714383227697319,
         -0.0011628105405175895,
         0.05071777402673019,
         -0.03275978267163129,
         -0.021455165913059078,
         0.04941507650389945,
         -0.024864911107061807,
         -0.024235419686618364,
         0.04847083937323673,
         -0.02423541968661881,
         -0.024864911107061807,
         0.04941507650389901,
         -0.021455165913059078,
         -0.03275978267163151,
         0.05071777402673019,
         -0.0011628105405175895,
         -0.057143832276973186,
         0.02043224235484832,
         0.0745859903847714,
         0.04202729525021601,
         0.00764132640913018,
         -0.019481636234943343,
         -0.06332346173655802,
         -0.06180400475030409,
         0.026938942133121938,
         0.04668267534468787,
         -0.04236208106508178,
         -0.01613915273215195,
         0.05062047373912961,
         -0.026863013180803655,
         -0.02407341777314898,
         0.04878456976416204,
         -0.02423541968661881,
         -0.024235419686618364,
         0.04878456976416204,
         -0.024073417773149426,
         -0.026863013180803655,
         0.050620473739129396,
         -0.01613915273215217,
         -0.04236208106508178,
         0.04668267534468787,
         0.026938942133121938,
         -0.06180400475030409,
         -0.06332346173655802,
         -0.019481636234943346,
         0.035645677572024415,
         0.07523303321188539,
         0.028009605206814073,
         -0.05618545886391127,
         -0.006028665148883342,
         0.05220380452638288,
         -0.030621285691694106,
         -0.02370503995878904,
         0.04979054301806719,
         -0.024073417773149426,
         -0.024864911107061807,
         0.04878456976416203,
         -0.024864911107061807,
         -0.024073417773148982,
         0.04979054301806719,
         -0.02370503995878882,
         -0.030621285691693888,
         0.052203804526382756,
         -0.006028665148883452,
         -0.05618545886391127,
         0.028009605206814076,
         0.07523303321188539,
         0.03564567757202441,
         -0.05373788086563252,
         -0.07181026388945423,
         0.014399470260609174,
         0.05349278735419257,
         -0.037098865030350765,
         -0.023012946526097547,
         0.0517286380776756,
         -0.023705039958788823,
         -0.026863013180803655,
         0.04941507650389902,
         -0.024073417773149426,
         -0.024073417773148982,
         0.04941507650389946,
         -0.02686301318080366,
         -0.023705039958789042,
         0.0517286380776756,
         -0.0230129465260971,
         -0.037098865030350765,
         0.05349278735419257,
         0.014399470260609174,
         -0.07181026388945423,
         -0.05373788086563252,
         0.07035940192950857,
         0.0517033900004071,
         -0.04902681079973406,
         -0.02170319453598103,
         0.055231071662635765,
         -0.0230129465260971,
         -0.030621285691693884,
         0.050620473739129396,
         -0.021455165913059078,
         -0.026863013180803662,
         0.04979054301806719,
         -0.026863013180803662,
         -0.021455165913059078,
         0.05062047373912961,
         -0.0306212856916941,
         -0.023012946526097547,
         0.05523107166263577,
         -0.02170319453598103,
         -0.04902681079973406,
         0.0517033900004071,
         0.07035940192950857,
         -0.08205245760021013,
         -0.018824124776235178,
         0.06230905222287509,
         -0.02170319453598103,
         -0.037098865030350765,
         0.052203804526382756,
         -0.016139152732152173,
         -0.0327597826716315,
         0.050620473739129396,
         -0.023705039958788823,
         -0.023705039958789042,
         0.05062047373912962,
         -0.03275978267163129,
         -0.01613915273215195,
         0.05220380452638288,
         -0.037098865030350765,
         -0.02170319453598103,
         0.06230905222287509,
         -0.018824124776235178,
         -0.08205245760021014,
         0.0862629766783918,
         -0.018824124776235178,
         -0.04902681079973406,
         0.05349278735419257,
         -0.006028665148883452,
         -0.04236208106508179,
         0.050717774026730195,
         -0.016139152732152173,
         -0.030621285691693884,
         0.0517286380776756,
         -0.0306212856916941,
         -0.01613915273215195,
         0.050717774026730195,
         -0.04236208106508179,
         -0.006028665148883341,
         0.05349278735419257,
         -0.04902681079973406,
         -0.018824124776235178,
         0.0862629766783918,
         -0.08205245760021014,
         0.0517033900004071,
         0.014399470260609176,
         -0.05618545886391127,
         0.04668267534468786,
         -0.0011628105405175897,
         -0.04236208106508178,
         0.052203804526382756,
         -0.023012946526097103,
         -0.023012946526097543,
         0.05220380452638288,
         -0.04236208106508178,
         -0.00116281054051759,
         0.04668267534468786,
         -0.05618545886391127,
         0.014399470260609174,
         0.0517033900004071,
         -0.08205245760021014,
         0.07035940192950857,
         -0.07181026388945423,
         0.028009605206814073,
         0.026938942133121944,
         -0.0571438322769732,
         0.04668267534468787,
         -0.006028665148883452,
         -0.037098865030350765,
         0.05523107166263577,
         -0.037098865030350765,
         -0.006028665148883342,
         0.04668267534468786,
         -0.0571438322769732,
         0.026938942133121944,
         0.028009605206814073,
         -0.07181026388945423,
         0.07035940192950857,
         -0.05373788086563252,
         0.07523303321188539,
         -0.061804004750304106,
         0.020432242354848317,
         0.026938942133121944,
         -0.05618545886391127,
         0.05349278735419257,
         -0.021703194535981032,
         -0.021703194535981032,
         0.05349278735419257,
         -0.05618545886391126,
         0.026938942133121944,
         0.02043224235484832,
         -0.061804004750304106,
         0.07523303321188539,
         -0.05373788086563252,
         0.03564567757202441,
         -0.06332346173655802,
         0.0745859903847714,
         -0.061804004750304106,
         0.028009605206814073,
         0.014399470260609174,
         -0.049026810799734054,
         0.06230905222287509,
         -0.049026810799734054,
         0.014399470260609174,
         0.028009605206814073,
         -0.061804004750304106,
         0.0745859903847714,
         -0.06332346173655802,
         0.03564567757202441,
         -0.019481636234943343,
         0.04202729525021601,
         -0.06332346173655802,
         0.07523303321188539,
         -0.07181026388945423,
         0.0517033900004071,
         -0.01882412477623518,
         -0.01882412477623518,
         0.0517033900004071,
         -0.07181026388945423,
         0.07523303321188539,
         -0.06332346173655802,
         0.04202729525021601,
         -0.019481636234943343,
         0.00764132640913018,
         -0.019481636234943343,
         0.03564567757202441,
         -0.05373788086563252,
         0.07035940192950857,
         -0.08205245760021014,
         0.08626297667839182,
         -0.08205245760021013,
         0.07035940192950857,
         -0.05373788086563252,
         0.03564567757202441,
         -0.019481636234943343,
         0.00764132640913018}
    };

    m_array_all = {
        {
        {0, 0, 0}
        },
        {
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1}
        },
        {
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2}
        },
        {
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3}
        },
        {
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4}
        },
        {
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5}
        },
        {
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6}
        },
        {
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7}
        },
        {
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8}
        },
        {
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9}
        },
        {
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10}
        },
        {
        {0, -11, 11},
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10},
        {0, 11, -11}
        },
        {
        {0, -12, 12},
        {0, -11, 11},
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10},
        {0, 11, -11},
        {0, 12, -12}
        },
        {
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2}
        },
        {
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3}
        },
        {
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4}
        },
        {
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5}
        },
        {
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6}
        },
        {
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7}
        },
        {
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8}
        },
        {
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9}
        },
        {
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10}
        },
        {
        {-1, -10, 11},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {-1, 10, -9},
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10},
        {1, -10, 9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {1, 10, -11}
        },
        {
        {-1, -11, 12},
        {-1, -10, 11},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {-1, 10, -9},
        {-1, 11, -10},
        {0, -11, 11},
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10},
        {0, 11, -11},
        {1, -11, 10},
        {1, -10, 9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {1, 10, -11},
        {1, 11, -12}
        },
        {
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2}
        },
        {
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4}
        },
        {
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {0, -3, 3},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 3, -3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3}
        },
        {
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5}
        },
        {
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4}
        },
        {
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6}
        },
        {
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5}
        },
        {
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7}
        },
        {
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6}
        },
        {
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8}
        },
        {
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7}
        },
        {
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9}
        },
        {
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8}
        },
        {
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10}
        },
        {
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9}
        },
        {
        {-2, -9, 11},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {2, 9, -11}
        },
        {
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-2, 10, -8},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {-1, 10, -9},
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10},
        {1, -10, 9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {2, -10, 8},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10}
        },
        {
        {-2, -10, 12},
        {-2, -9, 11},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-2, 10, -8},
        {-1, -10, 11},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {-1, 10, -9},
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10},
        {1, -10, 9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {1, 10, -11},
        {2, -10, 8},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {2, 9, -11},
        {2, 10, -12}
        },
        {
        {-2, -9, 11},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-2, 10, -8},
        {-2, 11, -9},
        {-1, -10, 11},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {-1, 10, -9},
        {-1, 11, -10},
        {0, -11, 11},
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10},
        {0, 11, -11},
        {1, -11, 10},
        {1, -10, 9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {1, 10, -11},
        {2, -11, 9},
        {2, -10, 8},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {2, 9, -11}
        },
        {
        {-2, -10, 12},
        {-2, -9, 11},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-2, 10, -8},
        {-2, 11, -9},
        {-2, 12, -10},
        {-1, -11, 12},
        {-1, -10, 11},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {-1, 10, -9},
        {-1, 11, -10},
        {-1, 12, -11},
        {0, -12, 12},
        {0, -11, 11},
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10},
        {0, 11, -11},
        {0, 12, -12},
        {1, -12, 11},
        {1, -11, 10},
        {1, -10, 9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {1, 10, -11},
        {1, 11, -12},
        {2, -12, 10},
        {2, -11, 9},
        {2, -10, 8},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {2, 9, -11},
        {2, 10, -12}
        },
        {
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4}
        },
        {
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6}
        },
        {
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5}
        },
        {
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7}
        },
        {
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-1, -5, 6},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 5, -6},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6}
        },
        {
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8}
        },
        {
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7}
        },
        {
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9}
        },
        {
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8}
        },
        {
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10}
        },
        {
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9}
        },
        {
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11}
        },
        {
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10}
        },
        {
        {-3, -9, 12},
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-2, -9, 11},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {2, 9, -11},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11},
        {3, 9, -12}
        },
        {
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-3, 10, -7},
        {-2, -9, 11},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-2, 10, -8},
        {-1, -10, 11},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {-1, 10, -9},
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10},
        {1, -10, 9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {1, 10, -11},
        {2, -10, 8},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {2, 9, -11},
        {3, -10, 7},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11}
        },
        {
        {-3, -9, 12},
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-3, 10, -7},
        {-3, 11, -8},
        {-2, -10, 12},
        {-2, -9, 11},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-2, 10, -8},
        {-2, 11, -9},
        {-1, -11, 12},
        {-1, -10, 11},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {-1, 10, -9},
        {-1, 11, -10},
        {0, -11, 11},
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10},
        {0, 11, -11},
        {1, -11, 10},
        {1, -10, 9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {1, 10, -11},
        {1, 11, -12},
        {2, -11, 9},
        {2, -10, 8},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {2, 9, -11},
        {2, 10, -12},
        {3, -11, 8},
        {3, -10, 7},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11},
        {3, 9, -12}
        },
        {
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4}
        },
        {
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {0, -4, 4},
        {0, -3, 3},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 3, -3},
        {0, 4, -4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6}
        },
        {
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8}
        },
        {
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 4, -2},
        {-2, 5, -3},
        {-1, -4, 5},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 5, -4},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {1, -5, 4},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 4, -5},
        {2, -5, 3},
        {2, -4, 2},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 2, -4},
        {2, 3, -5},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5}
        },
        {
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7}
        },
        {
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9}
        },
        {
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6}
        },
        {
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8}
        },
        {
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10}
        },
        {
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7}
        },
        {
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-2, -7, 9},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 7, -9},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9}
        },
        {
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11}
        },
        {
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 7, -6},
        {-1, 8, -7},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 6, -7},
        {1, 7, -8},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8}
        },
        {
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10}
        },
        {
        {-4, -8, 12},
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11},
        {4, 8, -12}
        },
        {
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9}
        },
        {
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-2, -9, 11},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {2, 9, -11},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11}
        },
        {
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-4, 10, -6},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-3, 10, -7},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-2, 10, -8},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {-1, 10, -9},
        {0, -10, 10},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 10, -10},
        {1, -10, 9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {2, -10, 8},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {3, -10, 7},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {4, -10, 6},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10}
        },
        {
        {-4, -8, 12},
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-4, 10, -6},
        {-3, -9, 12},
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-3, 10, -7},
        {-2, -10, 12},
        {-2, -9, 11},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-2, 10, -8},
        {-1, -10, 11},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {-1, 10, -9},
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10},
        {1, -10, 9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {1, 10, -11},
        {2, -10, 8},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {2, 9, -11},
        {2, 10, -12},
        {3, -10, 7},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11},
        {3, 9, -12},
        {4, -10, 6},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11},
        {4, 8, -12}
        },
        {
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-4, 10, -6},
        {-4, 11, -7},
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-3, 10, -7},
        {-3, 11, -8},
        {-2, -9, 11},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-2, 10, -8},
        {-2, 11, -9},
        {-1, -10, 11},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {-1, 10, -9},
        {-1, 11, -10},
        {0, -11, 11},
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10},
        {0, 11, -11},
        {1, -11, 10},
        {1, -10, 9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {1, 10, -11},
        {2, -11, 9},
        {2, -10, 8},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {2, 9, -11},
        {3, -11, 8},
        {3, -10, 7},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11},
        {4, -11, 7},
        {4, -10, 6},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11}
        },
        {
        {-4, -8, 12},
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-4, 10, -6},
        {-4, 11, -7},
        {-4, 12, -8},
        {-3, -9, 12},
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-3, 10, -7},
        {-3, 11, -8},
        {-3, 12, -9},
        {-2, -10, 12},
        {-2, -9, 11},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-2, 10, -8},
        {-2, 11, -9},
        {-2, 12, -10},
        {-1, -11, 12},
        {-1, -10, 11},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {-1, 10, -9},
        {-1, 11, -10},
        {-1, 12, -11},
        {0, -12, 12},
        {0, -11, 11},
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10},
        {0, 11, -11},
        {0, 12, -12},
        {1, -12, 11},
        {1, -11, 10},
        {1, -10, 9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {1, 10, -11},
        {1, 11, -12},
        {2, -12, 10},
        {2, -11, 9},
        {2, -10, 8},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {2, 9, -11},
        {2, 10, -12},
        {3, -12, 9},
        {3, -11, 8},
        {3, -10, 7},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11},
        {3, 9, -12},
        {4, -12, 8},
        {4, -11, 7},
        {4, -10, 6},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11},
        {4, 8, -12}
        },
        {
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6}
        },
        {
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8}
        },
        {
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10}
        },
        {
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7}
        },
        {
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9}
        },
        {
        {-5, -6, 11},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {5, 6, -11}
        },
        {
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {0, -7, 7},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 7, -7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8}
        },
        {
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10}
        },
        {
        {-5, -7, 12},
        {-5, -6, 11},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {5, 6, -11},
        {5, 7, -12}
        },
        {
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9}
        },
        {
        {-5, -6, 11},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 7, -9},
        {2, 8, -10},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {5, 6, -11}
        },
        {
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-5, 9, -4},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {5, -9, 4},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10}
        },
        {
        {-5, -7, 12},
        {-5, -6, 11},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-5, 9, -4},
        {-4, -8, 12},
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-3, -9, 12},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-2, -9, 11},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {2, 9, -11},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 9, -12},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11},
        {4, 8, -12},
        {5, -9, 4},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {5, 6, -11},
        {5, 7, -12}
        },
        {
        {-5, -6, 11},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-5, 9, -4},
        {-5, 10, -5},
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-4, 10, -6},
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-3, 10, -7},
        {-2, -9, 11},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-2, 10, -8},
        {-1, -10, 11},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {-1, 10, -9},
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10},
        {1, -10, 9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {1, 10, -11},
        {2, -10, 8},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {2, 9, -11},
        {3, -10, 7},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11},
        {4, -10, 6},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11},
        {5, -10, 5},
        {5, -9, 4},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {5, 6, -11}
        },
        {
        {-5, -7, 12},
        {-5, -6, 11},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-5, 9, -4},
        {-5, 10, -5},
        {-5, 11, -6},
        {-4, -8, 12},
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-4, 10, -6},
        {-4, 11, -7},
        {-3, -9, 12},
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-3, 10, -7},
        {-3, 11, -8},
        {-2, -10, 12},
        {-2, -9, 11},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-2, 10, -8},
        {-2, 11, -9},
        {-1, -11, 12},
        {-1, -10, 11},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {-1, 10, -9},
        {-1, 11, -10},
        {0, -11, 11},
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10},
        {0, 11, -11},
        {1, -11, 10},
        {1, -10, 9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {1, 10, -11},
        {1, 11, -12},
        {2, -11, 9},
        {2, -10, 8},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {2, 9, -11},
        {2, 10, -12},
        {3, -11, 8},
        {3, -10, 7},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11},
        {3, 9, -12},
        {4, -11, 7},
        {4, -10, 6},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11},
        {4, 8, -12},
        {5, -11, 6},
        {5, -10, 5},
        {5, -9, 4},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {5, 6, -11},
        {5, 7, -12}
        },
        {
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6}
        },
        {
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {0, -6, 6},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 6, -6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8}
        },
        {
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {6, 4, -10}
        },
        {
        {-6, -6, 12},
        {-6, -5, 11},
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-5, -6, 11},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {5, 6, -11},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {6, 4, -10},
        {6, 5, -11},
        {6, 6, -12}
        },
        {
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-2, -5, 7},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 7, -5},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {2, -7, 5},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 5, -7},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7}
        },
        {
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9}
        },
        {
        {-6, -5, 11},
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-5, -6, 11},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {5, 6, -11},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {6, 4, -10},
        {6, 5, -11}
        },
        {
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8}
        },
        {
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-3, -7, 10},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 7, -10},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {6, 4, -10}
        },
        {
        {-6, -6, 12},
        {-6, -5, 11},
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-5, -7, 12},
        {-5, -6, 11},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-4, -8, 12},
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11},
        {4, 8, -12},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {5, 6, -11},
        {5, 7, -12},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {6, 4, -10},
        {6, 5, -11},
        {6, 6, -12}
        },
        {
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-6, 9, -3},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-5, 9, -4},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {5, -9, 4},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {6, -9, 3},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9}
        },
        {
        {-6, -5, 11},
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-6, 9, -3},
        {-5, -6, 11},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-5, 9, -4},
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-2, -9, 11},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-1, -9, 10},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 9, -10},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {2, 9, -11},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11},
        {5, -9, 4},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {5, 6, -11},
        {6, -9, 3},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {6, 4, -10},
        {6, 5, -11}
        },
        {
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-6, 9, -3},
        {-6, 10, -4},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-5, 9, -4},
        {-5, 10, -5},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-4, 10, -6},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-3, 10, -7},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-2, 10, -8},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {-1, 10, -9},
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10},
        {1, -10, 9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {2, -10, 8},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {3, -10, 7},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {4, -10, 6},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {5, -10, 5},
        {5, -9, 4},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {6, -10, 4},
        {6, -9, 3},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {6, 4, -10}
        },
        {
        {-6, -6, 12},
        {-6, -5, 11},
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-6, 9, -3},
        {-6, 10, -4},
        {-5, -7, 12},
        {-5, -6, 11},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-5, 9, -4},
        {-5, 10, -5},
        {-4, -8, 12},
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-4, 10, -6},
        {-3, -9, 12},
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-3, 10, -7},
        {-2, -10, 12},
        {-2, -9, 11},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-2, 10, -8},
        {-1, -10, 11},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {-1, 10, -9},
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10},
        {1, -10, 9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {1, 10, -11},
        {2, -10, 8},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {2, 9, -11},
        {2, 10, -12},
        {3, -10, 7},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11},
        {3, 9, -12},
        {4, -10, 6},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11},
        {4, 8, -12},
        {5, -10, 5},
        {5, -9, 4},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {5, 6, -11},
        {5, 7, -12},
        {6, -10, 4},
        {6, -9, 3},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {6, 4, -10},
        {6, 5, -11},
        {6, 6, -12}
        },
        {
        {-6, -5, 11},
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-6, 9, -3},
        {-6, 10, -4},
        {-6, 11, -5},
        {-5, -6, 11},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-5, 9, -4},
        {-5, 10, -5},
        {-5, 11, -6},
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-4, 10, -6},
        {-4, 11, -7},
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-3, 10, -7},
        {-3, 11, -8},
        {-2, -9, 11},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-2, 10, -8},
        {-2, 11, -9},
        {-1, -10, 11},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {-1, 10, -9},
        {-1, 11, -10},
        {0, -11, 11},
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10},
        {0, 11, -11},
        {1, -11, 10},
        {1, -10, 9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {1, 10, -11},
        {2, -11, 9},
        {2, -10, 8},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {2, 9, -11},
        {3, -11, 8},
        {3, -10, 7},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11},
        {4, -11, 7},
        {4, -10, 6},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11},
        {5, -11, 6},
        {5, -10, 5},
        {5, -9, 4},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {5, 6, -11},
        {6, -11, 5},
        {6, -10, 4},
        {6, -9, 3},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {6, 4, -10},
        {6, 5, -11}
        },
        {
        {-6, -6, 12},
        {-6, -5, 11},
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-6, 9, -3},
        {-6, 10, -4},
        {-6, 11, -5},
        {-6, 12, -6},
        {-5, -7, 12},
        {-5, -6, 11},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-5, 9, -4},
        {-5, 10, -5},
        {-5, 11, -6},
        {-5, 12, -7},
        {-4, -8, 12},
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-4, 10, -6},
        {-4, 11, -7},
        {-4, 12, -8},
        {-3, -9, 12},
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-3, 10, -7},
        {-3, 11, -8},
        {-3, 12, -9},
        {-2, -10, 12},
        {-2, -9, 11},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-2, 10, -8},
        {-2, 11, -9},
        {-2, 12, -10},
        {-1, -11, 12},
        {-1, -10, 11},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {-1, 10, -9},
        {-1, 11, -10},
        {-1, 12, -11},
        {0, -12, 12},
        {0, -11, 11},
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10},
        {0, 11, -11},
        {0, 12, -12},
        {1, -12, 11},
        {1, -11, 10},
        {1, -10, 9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {1, 10, -11},
        {1, 11, -12},
        {2, -12, 10},
        {2, -11, 9},
        {2, -10, 8},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {2, 9, -11},
        {2, 10, -12},
        {3, -12, 9},
        {3, -11, 8},
        {3, -10, 7},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11},
        {3, 9, -12},
        {4, -12, 8},
        {4, -11, 7},
        {4, -10, 6},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11},
        {4, 8, -12},
        {5, -12, 7},
        {5, -11, 6},
        {5, -10, 5},
        {5, -9, 4},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {5, 6, -11},
        {5, 7, -12},
        {6, -12, 6},
        {6, -11, 5},
        {6, -10, 4},
        {6, -9, 3},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {6, 4, -10},
        {6, 5, -11},
        {6, 6, -12}
        },
        {
        {-7, -1, 8},
        {-7, 0, 7},
        {-7, 1, 6},
        {-7, 2, 5},
        {-7, 3, 4},
        {-7, 4, 3},
        {-7, 5, 2},
        {-7, 6, 1},
        {-7, 7, 0},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {7, -7, 0},
        {7, -6, -1},
        {7, -5, -2},
        {7, -4, -3},
        {7, -3, -4},
        {7, -2, -5},
        {7, -1, -6},
        {7, 0, -7},
        {7, 1, -8}
        },
        {
        {-7, -3, 10},
        {-7, -2, 9},
        {-7, -1, 8},
        {-7, 0, 7},
        {-7, 1, 6},
        {-7, 2, 5},
        {-7, 3, 4},
        {-7, 4, 3},
        {-7, 5, 2},
        {-7, 6, 1},
        {-7, 7, 0},
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {6, 4, -10},
        {7, -7, 0},
        {7, -6, -1},
        {7, -5, -2},
        {7, -4, -3},
        {7, -3, -4},
        {7, -2, -5},
        {7, -1, -6},
        {7, 0, -7},
        {7, 1, -8},
        {7, 2, -9},
        {7, 3, -10}
        },
        {
        {-7, -5, 12},
        {-7, -4, 11},
        {-7, -3, 10},
        {-7, -2, 9},
        {-7, -1, 8},
        {-7, 0, 7},
        {-7, 1, 6},
        {-7, 2, 5},
        {-7, 3, 4},
        {-7, 4, 3},
        {-7, 5, 2},
        {-7, 6, 1},
        {-7, 7, 0},
        {-6, -6, 12},
        {-6, -5, 11},
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-5, -7, 12},
        {-5, -6, 11},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {5, 6, -11},
        {5, 7, -12},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {6, 4, -10},
        {6, 5, -11},
        {6, 6, -12},
        {7, -7, 0},
        {7, -6, -1},
        {7, -5, -2},
        {7, -4, -3},
        {7, -3, -4},
        {7, -2, -5},
        {7, -1, -6},
        {7, 0, -7},
        {7, 1, -8},
        {7, 2, -9},
        {7, 3, -10},
        {7, 4, -11},
        {7, 5, -12}
        },
        {
        {-7, -2, 9},
        {-7, -1, 8},
        {-7, 0, 7},
        {-7, 1, 6},
        {-7, 2, 5},
        {-7, 3, 4},
        {-7, 4, 3},
        {-7, 5, 2},
        {-7, 6, 1},
        {-7, 7, 0},
        {-7, 8, -1},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {7, -8, 1},
        {7, -7, 0},
        {7, -6, -1},
        {7, -5, -2},
        {7, -4, -3},
        {7, -3, -4},
        {7, -2, -5},
        {7, -1, -6},
        {7, 0, -7},
        {7, 1, -8},
        {7, 2, -9}
        },
        {
        {-7, -4, 11},
        {-7, -3, 10},
        {-7, -2, 9},
        {-7, -1, 8},
        {-7, 0, 7},
        {-7, 1, 6},
        {-7, 2, 5},
        {-7, 3, 4},
        {-7, 4, 3},
        {-7, 5, 2},
        {-7, 6, 1},
        {-7, 7, 0},
        {-7, 8, -1},
        {-6, -5, 11},
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-5, -6, 11},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {5, 6, -11},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {6, 4, -10},
        {6, 5, -11},
        {7, -8, 1},
        {7, -7, 0},
        {7, -6, -1},
        {7, -5, -2},
        {7, -4, -3},
        {7, -3, -4},
        {7, -2, -5},
        {7, -1, -6},
        {7, 0, -7},
        {7, 1, -8},
        {7, 2, -9},
        {7, 3, -10},
        {7, 4, -11}
        },
        {
        {-7, -3, 10},
        {-7, -2, 9},
        {-7, -1, 8},
        {-7, 0, 7},
        {-7, 1, 6},
        {-7, 2, 5},
        {-7, 3, 4},
        {-7, 4, 3},
        {-7, 5, 2},
        {-7, 6, 1},
        {-7, 7, 0},
        {-7, 8, -1},
        {-7, 9, -2},
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-6, 9, -3},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-5, 9, -4},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 9, -8},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {1, -9, 8},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {5, -9, 4},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {6, -9, 3},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {6, 4, -10},
        {7, -9, 2},
        {7, -8, 1},
        {7, -7, 0},
        {7, -6, -1},
        {7, -5, -2},
        {7, -4, -3},
        {7, -3, -4},
        {7, -2, -5},
        {7, -1, -6},
        {7, 0, -7},
        {7, 1, -8},
        {7, 2, -9},
        {7, 3, -10}
        },
        {
        {-7, -5, 12},
        {-7, -4, 11},
        {-7, -3, 10},
        {-7, -2, 9},
        {-7, -1, 8},
        {-7, 0, 7},
        {-7, 1, 6},
        {-7, 2, 5},
        {-7, 3, 4},
        {-7, 4, 3},
        {-7, 5, 2},
        {-7, 6, 1},
        {-7, 7, 0},
        {-7, 8, -1},
        {-7, 9, -2},
        {-6, -6, 12},
        {-6, -5, 11},
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-6, 9, -3},
        {-5, -7, 12},
        {-5, -6, 11},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-5, 9, -4},
        {-4, -8, 12},
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-3, -9, 12},
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-2, -9, 11},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {2, 9, -11},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11},
        {3, 9, -12},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11},
        {4, 8, -12},
        {5, -9, 4},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {5, 6, -11},
        {5, 7, -12},
        {6, -9, 3},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {6, 4, -10},
        {6, 5, -11},
        {6, 6, -12},
        {7, -9, 2},
        {7, -8, 1},
        {7, -7, 0},
        {7, -6, -1},
        {7, -5, -2},
        {7, -4, -3},
        {7, -3, -4},
        {7, -2, -5},
        {7, -1, -6},
        {7, 0, -7},
        {7, 1, -8},
        {7, 2, -9},
        {7, 3, -10},
        {7, 4, -11},
        {7, 5, -12}
        },
        {
        {-7, -4, 11},
        {-7, -3, 10},
        {-7, -2, 9},
        {-7, -1, 8},
        {-7, 0, 7},
        {-7, 1, 6},
        {-7, 2, 5},
        {-7, 3, 4},
        {-7, 4, 3},
        {-7, 5, 2},
        {-7, 6, 1},
        {-7, 7, 0},
        {-7, 8, -1},
        {-7, 9, -2},
        {-7, 10, -3},
        {-6, -5, 11},
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-6, 9, -3},
        {-6, 10, -4},
        {-5, -6, 11},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-5, 9, -4},
        {-5, 10, -5},
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-4, 10, -6},
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-3, 10, -7},
        {-2, -9, 11},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-2, 10, -8},
        {-1, -10, 11},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {-1, 10, -9},
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10},
        {1, -10, 9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {1, 10, -11},
        {2, -10, 8},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {2, 9, -11},
        {3, -10, 7},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11},
        {4, -10, 6},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11},
        {5, -10, 5},
        {5, -9, 4},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {5, 6, -11},
        {6, -10, 4},
        {6, -9, 3},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {6, 4, -10},
        {6, 5, -11},
        {7, -10, 3},
        {7, -9, 2},
        {7, -8, 1},
        {7, -7, 0},
        {7, -6, -1},
        {7, -5, -2},
        {7, -4, -3},
        {7, -3, -4},
        {7, -2, -5},
        {7, -1, -6},
        {7, 0, -7},
        {7, 1, -8},
        {7, 2, -9},
        {7, 3, -10},
        {7, 4, -11}
        },
        {
        {-7, -5, 12},
        {-7, -4, 11},
        {-7, -3, 10},
        {-7, -2, 9},
        {-7, -1, 8},
        {-7, 0, 7},
        {-7, 1, 6},
        {-7, 2, 5},
        {-7, 3, 4},
        {-7, 4, 3},
        {-7, 5, 2},
        {-7, 6, 1},
        {-7, 7, 0},
        {-7, 8, -1},
        {-7, 9, -2},
        {-7, 10, -3},
        {-7, 11, -4},
        {-6, -6, 12},
        {-6, -5, 11},
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-6, 9, -3},
        {-6, 10, -4},
        {-6, 11, -5},
        {-5, -7, 12},
        {-5, -6, 11},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-5, 9, -4},
        {-5, 10, -5},
        {-5, 11, -6},
        {-4, -8, 12},
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-4, 10, -6},
        {-4, 11, -7},
        {-3, -9, 12},
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-3, 10, -7},
        {-3, 11, -8},
        {-2, -10, 12},
        {-2, -9, 11},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-2, 10, -8},
        {-2, 11, -9},
        {-1, -11, 12},
        {-1, -10, 11},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {-1, 10, -9},
        {-1, 11, -10},
        {0, -11, 11},
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10},
        {0, 11, -11},
        {1, -11, 10},
        {1, -10, 9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {1, 10, -11},
        {1, 11, -12},
        {2, -11, 9},
        {2, -10, 8},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {2, 9, -11},
        {2, 10, -12},
        {3, -11, 8},
        {3, -10, 7},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11},
        {3, 9, -12},
        {4, -11, 7},
        {4, -10, 6},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11},
        {4, 8, -12},
        {5, -11, 6},
        {5, -10, 5},
        {5, -9, 4},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {5, 6, -11},
        {5, 7, -12},
        {6, -11, 5},
        {6, -10, 4},
        {6, -9, 3},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {6, 4, -10},
        {6, 5, -11},
        {6, 6, -12},
        {7, -11, 4},
        {7, -10, 3},
        {7, -9, 2},
        {7, -8, 1},
        {7, -7, 0},
        {7, -6, -1},
        {7, -5, -2},
        {7, -4, -3},
        {7, -3, -4},
        {7, -2, -5},
        {7, -1, -6},
        {7, 0, -7},
        {7, 1, -8},
        {7, 2, -9},
        {7, 3, -10},
        {7, 4, -11},
        {7, 5, -12}
        },
        {
        {-8, 0, 8},
        {-8, 1, 7},
        {-8, 2, 6},
        {-8, 3, 5},
        {-8, 4, 4},
        {-8, 5, 3},
        {-8, 6, 2},
        {-8, 7, 1},
        {-8, 8, 0},
        {-7, -1, 8},
        {-7, 0, 7},
        {-7, 1, 6},
        {-7, 2, 5},
        {-7, 3, 4},
        {-7, 4, 3},
        {-7, 5, 2},
        {-7, 6, 1},
        {-7, 7, 0},
        {-7, 8, -1},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 7, -2},
        {-5, 8, -3},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 7, -6},
        {-1, 8, -7},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 6, -7},
        {1, 7, -8},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {5, -8, 3},
        {5, -7, 2},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 2, -7},
        {5, 3, -8},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {7, -8, 1},
        {7, -7, 0},
        {7, -6, -1},
        {7, -5, -2},
        {7, -4, -3},
        {7, -3, -4},
        {7, -2, -5},
        {7, -1, -6},
        {7, 0, -7},
        {7, 1, -8},
        {8, -8, 0},
        {8, -7, -1},
        {8, -6, -2},
        {8, -5, -3},
        {8, -4, -4},
        {8, -3, -5},
        {8, -2, -6},
        {8, -1, -7},
        {8, 0, -8}
        },
        {
        {-8, -2, 10},
        {-8, -1, 9},
        {-8, 0, 8},
        {-8, 1, 7},
        {-8, 2, 6},
        {-8, 3, 5},
        {-8, 4, 4},
        {-8, 5, 3},
        {-8, 6, 2},
        {-8, 7, 1},
        {-8, 8, 0},
        {-7, -3, 10},
        {-7, -2, 9},
        {-7, -1, 8},
        {-7, 0, 7},
        {-7, 1, 6},
        {-7, 2, 5},
        {-7, 3, 4},
        {-7, 4, 3},
        {-7, 5, 2},
        {-7, 6, 1},
        {-7, 7, 0},
        {-7, 8, -1},
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {6, 4, -10},
        {7, -8, 1},
        {7, -7, 0},
        {7, -6, -1},
        {7, -5, -2},
        {7, -4, -3},
        {7, -3, -4},
        {7, -2, -5},
        {7, -1, -6},
        {7, 0, -7},
        {7, 1, -8},
        {7, 2, -9},
        {7, 3, -10},
        {8, -8, 0},
        {8, -7, -1},
        {8, -6, -2},
        {8, -5, -3},
        {8, -4, -4},
        {8, -3, -5},
        {8, -2, -6},
        {8, -1, -7},
        {8, 0, -8},
        {8, 1, -9},
        {8, 2, -10}
        },
        {
        {-8, -4, 12},
        {-8, -3, 11},
        {-8, -2, 10},
        {-8, -1, 9},
        {-8, 0, 8},
        {-8, 1, 7},
        {-8, 2, 6},
        {-8, 3, 5},
        {-8, 4, 4},
        {-8, 5, 3},
        {-8, 6, 2},
        {-8, 7, 1},
        {-8, 8, 0},
        {-7, -5, 12},
        {-7, -4, 11},
        {-7, -3, 10},
        {-7, -2, 9},
        {-7, -1, 8},
        {-7, 0, 7},
        {-7, 1, 6},
        {-7, 2, 5},
        {-7, 3, 4},
        {-7, 4, 3},
        {-7, 5, 2},
        {-7, 6, 1},
        {-7, 7, 0},
        {-7, 8, -1},
        {-6, -6, 12},
        {-6, -5, 11},
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-5, -7, 12},
        {-5, -6, 11},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-4, -8, 12},
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11},
        {4, 8, -12},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {5, 6, -11},
        {5, 7, -12},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {6, 4, -10},
        {6, 5, -11},
        {6, 6, -12},
        {7, -8, 1},
        {7, -7, 0},
        {7, -6, -1},
        {7, -5, -2},
        {7, -4, -3},
        {7, -3, -4},
        {7, -2, -5},
        {7, -1, -6},
        {7, 0, -7},
        {7, 1, -8},
        {7, 2, -9},
        {7, 3, -10},
        {7, 4, -11},
        {7, 5, -12},
        {8, -8, 0},
        {8, -7, -1},
        {8, -6, -2},
        {8, -5, -3},
        {8, -4, -4},
        {8, -3, -5},
        {8, -2, -6},
        {8, -1, -7},
        {8, 0, -8},
        {8, 1, -9},
        {8, 2, -10},
        {8, 3, -11},
        {8, 4, -12}
        },
        {
        {-8, -1, 9},
        {-8, 0, 8},
        {-8, 1, 7},
        {-8, 2, 6},
        {-8, 3, 5},
        {-8, 4, 4},
        {-8, 5, 3},
        {-8, 6, 2},
        {-8, 7, 1},
        {-8, 8, 0},
        {-8, 9, -1},
        {-7, -2, 9},
        {-7, -1, 8},
        {-7, 0, 7},
        {-7, 1, 6},
        {-7, 2, 5},
        {-7, 3, 4},
        {-7, 4, 3},
        {-7, 5, 2},
        {-7, 6, 1},
        {-7, 7, 0},
        {-7, 8, -1},
        {-7, 9, -2},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-6, 9, -3},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-5, 9, -4},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-3, -6, 9},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 9, -6},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {3, -9, 6},
        {3, -7, 4},
        {3, -6, 3},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 3, -6},
        {3, 4, -7},
        {3, 6, -9},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {5, -9, 4},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {6, -9, 3},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {7, -9, 2},
        {7, -8, 1},
        {7, -7, 0},
        {7, -6, -1},
        {7, -5, -2},
        {7, -4, -3},
        {7, -3, -4},
        {7, -2, -5},
        {7, -1, -6},
        {7, 0, -7},
        {7, 1, -8},
        {7, 2, -9},
        {8, -9, 1},
        {8, -8, 0},
        {8, -7, -1},
        {8, -6, -2},
        {8, -5, -3},
        {8, -4, -4},
        {8, -3, -5},
        {8, -2, -6},
        {8, -1, -7},
        {8, 0, -8},
        {8, 1, -9}
        },
        {
        {-8, -3, 11},
        {-8, -2, 10},
        {-8, -1, 9},
        {-8, 0, 8},
        {-8, 1, 7},
        {-8, 2, 6},
        {-8, 3, 5},
        {-8, 4, 4},
        {-8, 5, 3},
        {-8, 6, 2},
        {-8, 7, 1},
        {-8, 8, 0},
        {-8, 9, -1},
        {-7, -4, 11},
        {-7, -3, 10},
        {-7, -2, 9},
        {-7, -1, 8},
        {-7, 0, 7},
        {-7, 1, 6},
        {-7, 2, 5},
        {-7, 3, 4},
        {-7, 4, 3},
        {-7, 5, 2},
        {-7, 6, 1},
        {-7, 7, 0},
        {-7, 8, -1},
        {-7, 9, -2},
        {-6, -5, 11},
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-6, 9, -3},
        {-5, -6, 11},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-5, 9, -4},
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-2, -9, 11},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {2, 9, -11},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11},
        {5, -9, 4},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {5, 6, -11},
        {6, -9, 3},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {6, 4, -10},
        {6, 5, -11},
        {7, -9, 2},
        {7, -8, 1},
        {7, -7, 0},
        {7, -6, -1},
        {7, -5, -2},
        {7, -4, -3},
        {7, -3, -4},
        {7, -2, -5},
        {7, -1, -6},
        {7, 0, -7},
        {7, 1, -8},
        {7, 2, -9},
        {7, 3, -10},
        {7, 4, -11},
        {8, -9, 1},
        {8, -8, 0},
        {8, -7, -1},
        {8, -6, -2},
        {8, -5, -3},
        {8, -4, -4},
        {8, -3, -5},
        {8, -2, -6},
        {8, -1, -7},
        {8, 0, -8},
        {8, 1, -9},
        {8, 2, -10},
        {8, 3, -11}
        },
        {
        {-8, -2, 10},
        {-8, -1, 9},
        {-8, 0, 8},
        {-8, 1, 7},
        {-8, 2, 6},
        {-8, 3, 5},
        {-8, 4, 4},
        {-8, 5, 3},
        {-8, 6, 2},
        {-8, 7, 1},
        {-8, 8, 0},
        {-8, 9, -1},
        {-8, 10, -2},
        {-7, -3, 10},
        {-7, -2, 9},
        {-7, -1, 8},
        {-7, 0, 7},
        {-7, 1, 6},
        {-7, 2, 5},
        {-7, 3, 4},
        {-7, 4, 3},
        {-7, 5, 2},
        {-7, 6, 1},
        {-7, 7, 0},
        {-7, 8, -1},
        {-7, 9, -2},
        {-7, 10, -3},
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-6, 9, -3},
        {-6, 10, -4},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-5, 9, -4},
        {-5, 10, -5},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-4, 10, -6},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-3, 10, -7},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-2, 10, -8},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {-1, 10, -9},
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10},
        {1, -10, 9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {2, -10, 8},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {3, -10, 7},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {4, -10, 6},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {5, -10, 5},
        {5, -9, 4},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {6, -10, 4},
        {6, -9, 3},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {6, 4, -10},
        {7, -10, 3},
        {7, -9, 2},
        {7, -8, 1},
        {7, -7, 0},
        {7, -6, -1},
        {7, -5, -2},
        {7, -4, -3},
        {7, -3, -4},
        {7, -2, -5},
        {7, -1, -6},
        {7, 0, -7},
        {7, 1, -8},
        {7, 2, -9},
        {7, 3, -10},
        {8, -10, 2},
        {8, -9, 1},
        {8, -8, 0},
        {8, -7, -1},
        {8, -6, -2},
        {8, -5, -3},
        {8, -4, -4},
        {8, -3, -5},
        {8, -2, -6},
        {8, -1, -7},
        {8, 0, -8},
        {8, 1, -9},
        {8, 2, -10}
        },
        {
        {-8, -4, 12},
        {-8, -3, 11},
        {-8, -2, 10},
        {-8, -1, 9},
        {-8, 0, 8},
        {-8, 1, 7},
        {-8, 2, 6},
        {-8, 3, 5},
        {-8, 4, 4},
        {-8, 5, 3},
        {-8, 6, 2},
        {-8, 7, 1},
        {-8, 8, 0},
        {-8, 9, -1},
        {-8, 10, -2},
        {-7, -5, 12},
        {-7, -4, 11},
        {-7, -3, 10},
        {-7, -2, 9},
        {-7, -1, 8},
        {-7, 0, 7},
        {-7, 1, 6},
        {-7, 2, 5},
        {-7, 3, 4},
        {-7, 4, 3},
        {-7, 5, 2},
        {-7, 6, 1},
        {-7, 7, 0},
        {-7, 8, -1},
        {-7, 9, -2},
        {-7, 10, -3},
        {-6, -6, 12},
        {-6, -5, 11},
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-6, 9, -3},
        {-6, 10, -4},
        {-5, -7, 12},
        {-5, -6, 11},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-5, 9, -4},
        {-5, 10, -5},
        {-4, -8, 12},
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-4, 10, -6},
        {-3, -9, 12},
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-3, 10, -7},
        {-2, -10, 12},
        {-2, -9, 11},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-2, 10, -8},
        {-1, -10, 11},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {-1, 10, -9},
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10},
        {1, -10, 9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {1, 10, -11},
        {2, -10, 8},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {2, 9, -11},
        {2, 10, -12},
        {3, -10, 7},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11},
        {3, 9, -12},
        {4, -10, 6},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11},
        {4, 8, -12},
        {5, -10, 5},
        {5, -9, 4},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {5, 6, -11},
        {5, 7, -12},
        {6, -10, 4},
        {6, -9, 3},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {6, 4, -10},
        {6, 5, -11},
        {6, 6, -12},
        {7, -10, 3},
        {7, -9, 2},
        {7, -8, 1},
        {7, -7, 0},
        {7, -6, -1},
        {7, -5, -2},
        {7, -4, -3},
        {7, -3, -4},
        {7, -2, -5},
        {7, -1, -6},
        {7, 0, -7},
        {7, 1, -8},
        {7, 2, -9},
        {7, 3, -10},
        {7, 4, -11},
        {7, 5, -12},
        {8, -10, 2},
        {8, -9, 1},
        {8, -8, 0},
        {8, -7, -1},
        {8, -6, -2},
        {8, -5, -3},
        {8, -4, -4},
        {8, -3, -5},
        {8, -2, -6},
        {8, -1, -7},
        {8, 0, -8},
        {8, 1, -9},
        {8, 2, -10},
        {8, 3, -11},
        {8, 4, -12}
        },
        {
        {-8, -3, 11},
        {-8, -2, 10},
        {-8, -1, 9},
        {-8, 0, 8},
        {-8, 1, 7},
        {-8, 2, 6},
        {-8, 3, 5},
        {-8, 4, 4},
        {-8, 5, 3},
        {-8, 6, 2},
        {-8, 7, 1},
        {-8, 8, 0},
        {-8, 9, -1},
        {-8, 10, -2},
        {-8, 11, -3},
        {-7, -4, 11},
        {-7, -3, 10},
        {-7, -2, 9},
        {-7, -1, 8},
        {-7, 0, 7},
        {-7, 1, 6},
        {-7, 2, 5},
        {-7, 3, 4},
        {-7, 4, 3},
        {-7, 5, 2},
        {-7, 6, 1},
        {-7, 7, 0},
        {-7, 8, -1},
        {-7, 9, -2},
        {-7, 10, -3},
        {-7, 11, -4},
        {-6, -5, 11},
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-6, 9, -3},
        {-6, 10, -4},
        {-6, 11, -5},
        {-5, -6, 11},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-5, 9, -4},
        {-5, 10, -5},
        {-5, 11, -6},
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-4, 10, -6},
        {-4, 11, -7},
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-3, 10, -7},
        {-3, 11, -8},
        {-2, -9, 11},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-2, 10, -8},
        {-2, 11, -9},
        {-1, -10, 11},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {-1, 10, -9},
        {-1, 11, -10},
        {0, -11, 11},
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10},
        {0, 11, -11},
        {1, -11, 10},
        {1, -10, 9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {1, 10, -11},
        {2, -11, 9},
        {2, -10, 8},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {2, 9, -11},
        {3, -11, 8},
        {3, -10, 7},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11},
        {4, -11, 7},
        {4, -10, 6},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11},
        {5, -11, 6},
        {5, -10, 5},
        {5, -9, 4},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {5, 6, -11},
        {6, -11, 5},
        {6, -10, 4},
        {6, -9, 3},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {6, 4, -10},
        {6, 5, -11},
        {7, -11, 4},
        {7, -10, 3},
        {7, -9, 2},
        {7, -8, 1},
        {7, -7, 0},
        {7, -6, -1},
        {7, -5, -2},
        {7, -4, -3},
        {7, -3, -4},
        {7, -2, -5},
        {7, -1, -6},
        {7, 0, -7},
        {7, 1, -8},
        {7, 2, -9},
        {7, 3, -10},
        {7, 4, -11},
        {8, -11, 3},
        {8, -10, 2},
        {8, -9, 1},
        {8, -8, 0},
        {8, -7, -1},
        {8, -6, -2},
        {8, -5, -3},
        {8, -4, -4},
        {8, -3, -5},
        {8, -2, -6},
        {8, -1, -7},
        {8, 0, -8},
        {8, 1, -9},
        {8, 2, -10},
        {8, 3, -11}
        },
        {
        {-8, -4, 12},
        {-8, -3, 11},
        {-8, -2, 10},
        {-8, -1, 9},
        {-8, 0, 8},
        {-8, 1, 7},
        {-8, 2, 6},
        {-8, 3, 5},
        {-8, 4, 4},
        {-8, 5, 3},
        {-8, 6, 2},
        {-8, 7, 1},
        {-8, 8, 0},
        {-8, 9, -1},
        {-8, 10, -2},
        {-8, 11, -3},
        {-8, 12, -4},
        {-7, -5, 12},
        {-7, -4, 11},
        {-7, -3, 10},
        {-7, -2, 9},
        {-7, -1, 8},
        {-7, 0, 7},
        {-7, 1, 6},
        {-7, 2, 5},
        {-7, 3, 4},
        {-7, 4, 3},
        {-7, 5, 2},
        {-7, 6, 1},
        {-7, 7, 0},
        {-7, 8, -1},
        {-7, 9, -2},
        {-7, 10, -3},
        {-7, 11, -4},
        {-7, 12, -5},
        {-6, -6, 12},
        {-6, -5, 11},
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-6, 9, -3},
        {-6, 10, -4},
        {-6, 11, -5},
        {-6, 12, -6},
        {-5, -7, 12},
        {-5, -6, 11},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-5, 9, -4},
        {-5, 10, -5},
        {-5, 11, -6},
        {-5, 12, -7},
        {-4, -8, 12},
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-4, 10, -6},
        {-4, 11, -7},
        {-4, 12, -8},
        {-3, -9, 12},
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-3, 10, -7},
        {-3, 11, -8},
        {-3, 12, -9},
        {-2, -10, 12},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-2, 10, -8},
        {-2, 12, -10},
        {-1, -11, 12},
        {-1, -10, 11},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {-1, 10, -9},
        {-1, 11, -10},
        {-1, 12, -11},
        {0, -12, 12},
        {0, -11, 11},
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10},
        {0, 11, -11},
        {0, 12, -12},
        {1, -12, 11},
        {1, -11, 10},
        {1, -10, 9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {1, 10, -11},
        {1, 11, -12},
        {2, -12, 10},
        {2, -10, 8},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {2, 10, -12},
        {3, -12, 9},
        {3, -11, 8},
        {3, -10, 7},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11},
        {3, 9, -12},
        {4, -12, 8},
        {4, -11, 7},
        {4, -10, 6},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11},
        {4, 8, -12},
        {5, -12, 7},
        {5, -11, 6},
        {5, -10, 5},
        {5, -9, 4},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {5, 6, -11},
        {5, 7, -12},
        {6, -12, 6},
        {6, -11, 5},
        {6, -10, 4},
        {6, -9, 3},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {6, 4, -10},
        {6, 5, -11},
        {6, 6, -12},
        {7, -12, 5},
        {7, -11, 4},
        {7, -10, 3},
        {7, -9, 2},
        {7, -8, 1},
        {7, -7, 0},
        {7, -6, -1},
        {7, -5, -2},
        {7, -4, -3},
        {7, -3, -4},
        {7, -2, -5},
        {7, -1, -6},
        {7, 0, -7},
        {7, 1, -8},
        {7, 2, -9},
        {7, 3, -10},
        {7, 4, -11},
        {7, 5, -12},
        {8, -12, 4},
        {8, -11, 3},
        {8, -10, 2},
        {8, -9, 1},
        {8, -8, 0},
        {8, -7, -1},
        {8, -6, -2},
        {8, -5, -3},
        {8, -4, -4},
        {8, -3, -5},
        {8, -2, -6},
        {8, -1, -7},
        {8, 0, -8},
        {8, 1, -9},
        {8, 2, -10},
        {8, 3, -11},
        {8, 4, -12}
        },
        {
        {-9, -1, 10},
        {-9, 0, 9},
        {-9, 1, 8},
        {-9, 2, 7},
        {-9, 3, 6},
        {-9, 4, 5},
        {-9, 5, 4},
        {-9, 6, 3},
        {-9, 7, 2},
        {-9, 8, 1},
        {-9, 9, 0},
        {-8, -2, 10},
        {-8, -1, 9},
        {-8, 0, 8},
        {-8, 1, 7},
        {-8, 2, 6},
        {-8, 3, 5},
        {-8, 4, 4},
        {-8, 5, 3},
        {-8, 6, 2},
        {-8, 7, 1},
        {-8, 8, 0},
        {-8, 9, -1},
        {-7, -3, 10},
        {-7, -2, 9},
        {-7, -1, 8},
        {-7, 0, 7},
        {-7, 1, 6},
        {-7, 2, 5},
        {-7, 3, 4},
        {-7, 4, 3},
        {-7, 5, 2},
        {-7, 6, 1},
        {-7, 7, 0},
        {-7, 8, -1},
        {-7, 9, -2},
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-6, 9, -3},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-5, 9, -4},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {5, -9, 4},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {6, -9, 3},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {6, 4, -10},
        {7, -9, 2},
        {7, -8, 1},
        {7, -7, 0},
        {7, -6, -1},
        {7, -5, -2},
        {7, -4, -3},
        {7, -3, -4},
        {7, -2, -5},
        {7, -1, -6},
        {7, 0, -7},
        {7, 1, -8},
        {7, 2, -9},
        {7, 3, -10},
        {8, -9, 1},
        {8, -8, 0},
        {8, -7, -1},
        {8, -6, -2},
        {8, -5, -3},
        {8, -4, -4},
        {8, -3, -5},
        {8, -2, -6},
        {8, -1, -7},
        {8, 0, -8},
        {8, 1, -9},
        {8, 2, -10},
        {9, -9, 0},
        {9, -8, -1},
        {9, -7, -2},
        {9, -6, -3},
        {9, -5, -4},
        {9, -4, -5},
        {9, -3, -6},
        {9, -2, -7},
        {9, -1, -8},
        {9, 0, -9},
        {9, 1, -10}
        },
        {
        {-9, -3, 12},
        {-9, -2, 11},
        {-9, -1, 10},
        {-9, 0, 9},
        {-9, 1, 8},
        {-9, 2, 7},
        {-9, 3, 6},
        {-9, 4, 5},
        {-9, 5, 4},
        {-9, 6, 3},
        {-9, 7, 2},
        {-9, 8, 1},
        {-9, 9, 0},
        {-8, -4, 12},
        {-8, -3, 11},
        {-8, -2, 10},
        {-8, -1, 9},
        {-8, 0, 8},
        {-8, 1, 7},
        {-8, 2, 6},
        {-8, 3, 5},
        {-8, 4, 4},
        {-8, 5, 3},
        {-8, 6, 2},
        {-8, 7, 1},
        {-8, 8, 0},
        {-8, 9, -1},
        {-7, -5, 12},
        {-7, -4, 11},
        {-7, -3, 10},
        {-7, -2, 9},
        {-7, -1, 8},
        {-7, 0, 7},
        {-7, 1, 6},
        {-7, 2, 5},
        {-7, 3, 4},
        {-7, 4, 3},
        {-7, 5, 2},
        {-7, 6, 1},
        {-7, 7, 0},
        {-7, 8, -1},
        {-7, 9, -2},
        {-6, -6, 12},
        {-6, -5, 11},
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-6, 9, -3},
        {-5, -7, 12},
        {-5, -6, 11},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-5, 9, -4},
        {-4, -8, 12},
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-3, -9, 12},
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-2, -9, 11},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {2, 9, -11},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11},
        {3, 9, -12},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11},
        {4, 8, -12},
        {5, -9, 4},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {5, 6, -11},
        {5, 7, -12},
        {6, -9, 3},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {6, 4, -10},
        {6, 5, -11},
        {6, 6, -12},
        {7, -9, 2},
        {7, -8, 1},
        {7, -7, 0},
        {7, -6, -1},
        {7, -5, -2},
        {7, -4, -3},
        {7, -3, -4},
        {7, -2, -5},
        {7, -1, -6},
        {7, 0, -7},
        {7, 1, -8},
        {7, 2, -9},
        {7, 3, -10},
        {7, 4, -11},
        {7, 5, -12},
        {8, -9, 1},
        {8, -8, 0},
        {8, -7, -1},
        {8, -6, -2},
        {8, -5, -3},
        {8, -4, -4},
        {8, -3, -5},
        {8, -2, -6},
        {8, -1, -7},
        {8, 0, -8},
        {8, 1, -9},
        {8, 2, -10},
        {8, 3, -11},
        {8, 4, -12},
        {9, -9, 0},
        {9, -8, -1},
        {9, -7, -2},
        {9, -6, -3},
        {9, -5, -4},
        {9, -4, -5},
        {9, -3, -6},
        {9, -2, -7},
        {9, -1, -8},
        {9, 0, -9},
        {9, 1, -10},
        {9, 2, -11},
        {9, 3, -12}
        },
        {
        {-9, -2, 11},
        {-9, -1, 10},
        {-9, 0, 9},
        {-9, 1, 8},
        {-9, 2, 7},
        {-9, 3, 6},
        {-9, 4, 5},
        {-9, 5, 4},
        {-9, 6, 3},
        {-9, 7, 2},
        {-9, 8, 1},
        {-9, 9, 0},
        {-9, 10, -1},
        {-8, -3, 11},
        {-8, -2, 10},
        {-8, -1, 9},
        {-8, 0, 8},
        {-8, 1, 7},
        {-8, 2, 6},
        {-8, 3, 5},
        {-8, 4, 4},
        {-8, 5, 3},
        {-8, 6, 2},
        {-8, 7, 1},
        {-8, 8, 0},
        {-8, 9, -1},
        {-8, 10, -2},
        {-7, -4, 11},
        {-7, -3, 10},
        {-7, -2, 9},
        {-7, -1, 8},
        {-7, 0, 7},
        {-7, 1, 6},
        {-7, 2, 5},
        {-7, 3, 4},
        {-7, 4, 3},
        {-7, 5, 2},
        {-7, 6, 1},
        {-7, 7, 0},
        {-7, 8, -1},
        {-7, 9, -2},
        {-7, 10, -3},
        {-6, -5, 11},
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-6, 9, -3},
        {-6, 10, -4},
        {-5, -6, 11},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-5, 9, -4},
        {-5, 10, -5},
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-4, 10, -6},
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-3, 10, -7},
        {-2, -9, 11},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-2, 10, -8},
        {-1, -10, 11},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {-1, 10, -9},
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10},
        {1, -10, 9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {1, 10, -11},
        {2, -10, 8},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {2, 9, -11},
        {3, -10, 7},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11},
        {4, -10, 6},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11},
        {5, -10, 5},
        {5, -9, 4},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {5, 6, -11},
        {6, -10, 4},
        {6, -9, 3},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {6, 4, -10},
        {6, 5, -11},
        {7, -10, 3},
        {7, -9, 2},
        {7, -8, 1},
        {7, -7, 0},
        {7, -6, -1},
        {7, -5, -2},
        {7, -4, -3},
        {7, -3, -4},
        {7, -2, -5},
        {7, -1, -6},
        {7, 0, -7},
        {7, 1, -8},
        {7, 2, -9},
        {7, 3, -10},
        {7, 4, -11},
        {8, -10, 2},
        {8, -9, 1},
        {8, -8, 0},
        {8, -7, -1},
        {8, -6, -2},
        {8, -5, -3},
        {8, -4, -4},
        {8, -3, -5},
        {8, -2, -6},
        {8, -1, -7},
        {8, 0, -8},
        {8, 1, -9},
        {8, 2, -10},
        {8, 3, -11},
        {9, -10, 1},
        {9, -9, 0},
        {9, -8, -1},
        {9, -7, -2},
        {9, -6, -3},
        {9, -5, -4},
        {9, -4, -5},
        {9, -3, -6},
        {9, -2, -7},
        {9, -1, -8},
        {9, 0, -9},
        {9, 1, -10},
        {9, 2, -11}
        },
        {
        {-9, -3, 12},
        {-9, -2, 11},
        {-9, -1, 10},
        {-9, 0, 9},
        {-9, 1, 8},
        {-9, 2, 7},
        {-9, 3, 6},
        {-9, 4, 5},
        {-9, 5, 4},
        {-9, 6, 3},
        {-9, 7, 2},
        {-9, 8, 1},
        {-9, 9, 0},
        {-9, 10, -1},
        {-9, 11, -2},
        {-8, -4, 12},
        {-8, -3, 11},
        {-8, -2, 10},
        {-8, -1, 9},
        {-8, 0, 8},
        {-8, 1, 7},
        {-8, 2, 6},
        {-8, 3, 5},
        {-8, 4, 4},
        {-8, 5, 3},
        {-8, 6, 2},
        {-8, 7, 1},
        {-8, 8, 0},
        {-8, 9, -1},
        {-8, 10, -2},
        {-8, 11, -3},
        {-7, -5, 12},
        {-7, -4, 11},
        {-7, -3, 10},
        {-7, -2, 9},
        {-7, -1, 8},
        {-7, 0, 7},
        {-7, 1, 6},
        {-7, 2, 5},
        {-7, 3, 4},
        {-7, 4, 3},
        {-7, 5, 2},
        {-7, 6, 1},
        {-7, 7, 0},
        {-7, 8, -1},
        {-7, 9, -2},
        {-7, 10, -3},
        {-7, 11, -4},
        {-6, -6, 12},
        {-6, -5, 11},
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-6, 9, -3},
        {-6, 10, -4},
        {-6, 11, -5},
        {-5, -7, 12},
        {-5, -6, 11},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-5, 9, -4},
        {-5, 10, -5},
        {-5, 11, -6},
        {-4, -8, 12},
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-4, 10, -6},
        {-4, 11, -7},
        {-3, -9, 12},
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-3, 10, -7},
        {-3, 11, -8},
        {-2, -10, 12},
        {-2, -9, 11},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-2, 11, -9},
        {-1, -11, 12},
        {-1, -10, 11},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {-1, 10, -9},
        {-1, 11, -10},
        {0, -11, 11},
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10},
        {0, 11, -11},
        {1, -11, 10},
        {1, -10, 9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {1, 10, -11},
        {1, 11, -12},
        {2, -11, 9},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {2, 9, -11},
        {2, 10, -12},
        {3, -11, 8},
        {3, -10, 7},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11},
        {3, 9, -12},
        {4, -11, 7},
        {4, -10, 6},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11},
        {4, 8, -12},
        {5, -11, 6},
        {5, -10, 5},
        {5, -9, 4},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {5, 6, -11},
        {5, 7, -12},
        {6, -11, 5},
        {6, -10, 4},
        {6, -9, 3},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {6, 4, -10},
        {6, 5, -11},
        {6, 6, -12},
        {7, -11, 4},
        {7, -10, 3},
        {7, -9, 2},
        {7, -8, 1},
        {7, -7, 0},
        {7, -6, -1},
        {7, -5, -2},
        {7, -4, -3},
        {7, -3, -4},
        {7, -2, -5},
        {7, -1, -6},
        {7, 0, -7},
        {7, 1, -8},
        {7, 2, -9},
        {7, 3, -10},
        {7, 4, -11},
        {7, 5, -12},
        {8, -11, 3},
        {8, -10, 2},
        {8, -9, 1},
        {8, -8, 0},
        {8, -7, -1},
        {8, -6, -2},
        {8, -5, -3},
        {8, -4, -4},
        {8, -3, -5},
        {8, -2, -6},
        {8, -1, -7},
        {8, 0, -8},
        {8, 1, -9},
        {8, 2, -10},
        {8, 3, -11},
        {8, 4, -12},
        {9, -11, 2},
        {9, -10, 1},
        {9, -9, 0},
        {9, -8, -1},
        {9, -7, -2},
        {9, -6, -3},
        {9, -5, -4},
        {9, -4, -5},
        {9, -3, -6},
        {9, -2, -7},
        {9, -1, -8},
        {9, 0, -9},
        {9, 1, -10},
        {9, 2, -11},
        {9, 3, -12}
        },
        {
        {-10, 0, 10},
        {-10, 1, 9},
        {-10, 2, 8},
        {-10, 3, 7},
        {-10, 4, 6},
        {-10, 5, 5},
        {-10, 6, 4},
        {-10, 7, 3},
        {-10, 8, 2},
        {-10, 9, 1},
        {-10, 10, 0},
        {-9, -1, 10},
        {-9, 0, 9},
        {-9, 1, 8},
        {-9, 2, 7},
        {-9, 3, 6},
        {-9, 4, 5},
        {-9, 5, 4},
        {-9, 6, 3},
        {-9, 7, 2},
        {-9, 8, 1},
        {-9, 9, 0},
        {-9, 10, -1},
        {-8, -2, 10},
        {-8, -1, 9},
        {-8, 0, 8},
        {-8, 1, 7},
        {-8, 2, 6},
        {-8, 3, 5},
        {-8, 4, 4},
        {-8, 5, 3},
        {-8, 6, 2},
        {-8, 7, 1},
        {-8, 8, 0},
        {-8, 9, -1},
        {-8, 10, -2},
        {-7, -3, 10},
        {-7, -2, 9},
        {-7, -1, 8},
        {-7, 0, 7},
        {-7, 1, 6},
        {-7, 2, 5},
        {-7, 3, 4},
        {-7, 4, 3},
        {-7, 5, 2},
        {-7, 6, 1},
        {-7, 7, 0},
        {-7, 8, -1},
        {-7, 9, -2},
        {-7, 10, -3},
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-6, 9, -3},
        {-6, 10, -4},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-5, 9, -4},
        {-5, 10, -5},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-4, 10, -6},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-3, 10, -7},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-2, 10, -8},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {-1, 10, -9},
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10},
        {1, -10, 9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {2, -10, 8},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {3, -10, 7},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {4, -10, 6},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {5, -10, 5},
        {5, -9, 4},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {6, -10, 4},
        {6, -9, 3},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {6, 4, -10},
        {7, -10, 3},
        {7, -9, 2},
        {7, -8, 1},
        {7, -7, 0},
        {7, -6, -1},
        {7, -5, -2},
        {7, -4, -3},
        {7, -3, -4},
        {7, -2, -5},
        {7, -1, -6},
        {7, 0, -7},
        {7, 1, -8},
        {7, 2, -9},
        {7, 3, -10},
        {8, -10, 2},
        {8, -9, 1},
        {8, -8, 0},
        {8, -7, -1},
        {8, -6, -2},
        {8, -5, -3},
        {8, -4, -4},
        {8, -3, -5},
        {8, -2, -6},
        {8, -1, -7},
        {8, 0, -8},
        {8, 1, -9},
        {8, 2, -10},
        {9, -10, 1},
        {9, -9, 0},
        {9, -8, -1},
        {9, -7, -2},
        {9, -6, -3},
        {9, -5, -4},
        {9, -4, -5},
        {9, -3, -6},
        {9, -2, -7},
        {9, -1, -8},
        {9, 0, -9},
        {9, 1, -10},
        {10, -10, 0},
        {10, -9, -1},
        {10, -8, -2},
        {10, -7, -3},
        {10, -6, -4},
        {10, -5, -5},
        {10, -4, -6},
        {10, -3, -7},
        {10, -2, -8},
        {10, -1, -9},
        {10, 0, -10}
        },
        {
        {-10, -2, 12},
        {-10, -1, 11},
        {-10, 0, 10},
        {-10, 1, 9},
        {-10, 2, 8},
        {-10, 3, 7},
        {-10, 4, 6},
        {-10, 5, 5},
        {-10, 6, 4},
        {-10, 7, 3},
        {-10, 8, 2},
        {-10, 9, 1},
        {-10, 10, 0},
        {-9, -3, 12},
        {-9, -2, 11},
        {-9, -1, 10},
        {-9, 0, 9},
        {-9, 1, 8},
        {-9, 2, 7},
        {-9, 3, 6},
        {-9, 4, 5},
        {-9, 5, 4},
        {-9, 6, 3},
        {-9, 7, 2},
        {-9, 8, 1},
        {-9, 9, 0},
        {-9, 10, -1},
        {-8, -4, 12},
        {-8, -3, 11},
        {-8, -2, 10},
        {-8, -1, 9},
        {-8, 0, 8},
        {-8, 1, 7},
        {-8, 2, 6},
        {-8, 3, 5},
        {-8, 4, 4},
        {-8, 5, 3},
        {-8, 6, 2},
        {-8, 7, 1},
        {-8, 8, 0},
        {-8, 9, -1},
        {-8, 10, -2},
        {-7, -5, 12},
        {-7, -4, 11},
        {-7, -3, 10},
        {-7, -2, 9},
        {-7, -1, 8},
        {-7, 0, 7},
        {-7, 1, 6},
        {-7, 2, 5},
        {-7, 3, 4},
        {-7, 4, 3},
        {-7, 5, 2},
        {-7, 6, 1},
        {-7, 7, 0},
        {-7, 8, -1},
        {-7, 9, -2},
        {-7, 10, -3},
        {-6, -6, 12},
        {-6, -5, 11},
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-6, 9, -3},
        {-6, 10, -4},
        {-5, -7, 12},
        {-5, -6, 11},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-5, 9, -4},
        {-5, 10, -5},
        {-4, -8, 12},
        {-4, -7, 11},
        {-4, -6, 10},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-4, 10, -6},
        {-3, -9, 12},
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-3, 10, -7},
        {-2, -10, 12},
        {-2, -9, 11},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-2, 10, -8},
        {-1, -10, 11},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {-1, 10, -9},
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10},
        {1, -10, 9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {1, 10, -11},
        {2, -10, 8},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {2, 9, -11},
        {2, 10, -12},
        {3, -10, 7},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11},
        {3, 9, -12},
        {4, -10, 6},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 6, -10},
        {4, 7, -11},
        {4, 8, -12},
        {5, -10, 5},
        {5, -9, 4},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {5, 6, -11},
        {5, 7, -12},
        {6, -10, 4},
        {6, -9, 3},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
        {6, 1, -7},
        {6, 2, -8},
        {6, 3, -9},
        {6, 4, -10},
        {6, 5, -11},
        {6, 6, -12},
        {7, -10, 3},
        {7, -9, 2},
        {7, -8, 1},
        {7, -7, 0},
        {7, -6, -1},
        {7, -5, -2},
        {7, -4, -3},
        {7, -3, -4},
        {7, -2, -5},
        {7, -1, -6},
        {7, 0, -7},
        {7, 1, -8},
        {7, 2, -9},
        {7, 3, -10},
        {7, 4, -11},
        {7, 5, -12},
        {8, -10, 2},
        {8, -9, 1},
        {8, -8, 0},
        {8, -7, -1},
        {8, -6, -2},
        {8, -5, -3},
        {8, -4, -4},
        {8, -3, -5},
        {8, -2, -6},
        {8, -1, -7},
        {8, 0, -8},
        {8, 1, -9},
        {8, 2, -10},
        {8, 3, -11},
        {8, 4, -12},
        {9, -10, 1},
        {9, -9, 0},
        {9, -8, -1},
        {9, -7, -2},
        {9, -6, -3},
        {9, -5, -4},
        {9, -4, -5},
        {9, -3, -6},
        {9, -2, -7},
        {9, -1, -8},
        {9, 0, -9},
        {9, 1, -10},
        {9, 2, -11},
        {9, 3, -12},
        {10, -10, 0},
        {10, -9, -1},
        {10, -8, -2},
        {10, -7, -3},
        {10, -6, -4},
        {10, -5, -5},
        {10, -4, -6},
        {10, -3, -7},
        {10, -2, -8},
        {10, -1, -9},
        {10, 0, -10},
        {10, 1, -11},
        {10, 2, -12}
        },
        {
        {-10, -1, 11},
        {-10, 0, 10},
        {-10, 1, 9},
        {-10, 2, 8},
        {-10, 3, 7},
        {-10, 4, 6},
        {-10, 5, 5},
        {-10, 6, 4},
        {-10, 7, 3},
        {-10, 8, 2},
        {-10, 9, 1},
        {-10, 10, 0},
        {-10, 11, -1},
        {-9, -2, 11},
        {-9, -1, 10},
        {-9, 0, 9},
        {-9, 1, 8},
        {-9, 2, 7},
        {-9, 3, 6},
        {-9, 4, 5},
        {-9, 5, 4},
        {-9, 6, 3},
        {-9, 7, 2},
        {-9, 8, 1},
        {-9, 9, 0},
        {-9, 10, -1},
        {-9, 11, -2},
        {-8, -3, 11},
        {-8, -2, 10},
        {-8, -1, 9},
        {-8, 0, 8},
        {-8, 1, 7},
        {-8, 2, 6},
        {-8, 3, 5},
        {-8, 4, 4},
        {-8, 5, 3},
        {-8, 6, 2},
        {-8, 7, 1},
        {-8, 8, 0},
        {-8, 9, -1},
        {-8, 10, -2},
        {-8, 11, -3},
        {-7, -4, 11},
        {-7, -3, 10},
        {-7, -2, 9},
        {-7, -1, 8},
        {-7, 0, 7},
        {-7, 1, 6},
        {-7, 2, 5},
        {-7, 3, 4},
        {-7, 4, 3},
        {-7, 5, 2},
        {-7, 6, 1},
        {-7, 7, 0},
        {-7, 8, -1},
        {-7, 9, -2},
        {-7, 10, -3},
        {-7, 11, -4},
        {-6, -5, 11},
        {-6, -4, 10},
        {-6, -3, 9},
        {-6, -2, 8},
        {-6, -1, 7},
        {-6, 0, 6},
        {-6, 1, 5},
        {-6, 2, 4},
        {-6, 3, 3},
        {-6, 4, 2},
        {-6, 5, 1},
        {-6, 6, 0},
        {-6, 7, -1},
        {-6, 8, -2},
        {-6, 9, -3},
        {-6, 10, -4},
        {-6, 11, -5},
        {-5, -6, 11},
        {-5, -5, 10},
        {-5, -4, 9},
        {-5, -3, 8},
        {-5, -2, 7},
        {-5, -1, 6},
        {-5, 0, 5},
        {-5, 1, 4},
        {-5, 2, 3},
        {-5, 3, 2},
        {-5, 4, 1},
        {-5, 5, 0},
        {-5, 6, -1},
        {-5, 7, -2},
        {-5, 8, -3},
        {-5, 9, -4},
        {-5, 10, -5},
        {-5, 11, -6},
        {-4, -7, 11},
        {-4, -5, 9},
        {-4, -4, 8},
        {-4, -3, 7},
        {-4, -2, 6},
        {-4, -1, 5},
        {-4, 0, 4},
        {-4, 1, 3},
        {-4, 2, 2},
        {-4, 3, 1},
        {-4, 4, 0},
        {-4, 5, -1},
        {-4, 6, -2},
        {-4, 7, -3},
        {-4, 8, -4},
        {-4, 9, -5},
        {-4, 11, -7},
        {-3, -8, 11},
        {-3, -7, 10},
        {-3, -6, 9},
        {-3, -5, 8},
        {-3, -4, 7},
        {-3, -3, 6},
        {-3, -2, 5},
        {-3, -1, 4},
        {-3, 0, 3},
        {-3, 1, 2},
        {-3, 2, 1},
        {-3, 3, 0},
        {-3, 4, -1},
        {-3, 5, -2},
        {-3, 6, -3},
        {-3, 7, -4},
        {-3, 8, -5},
        {-3, 9, -6},
        {-3, 10, -7},
        {-3, 11, -8},
        {-2, -9, 11},
        {-2, -8, 10},
        {-2, -7, 9},
        {-2, -6, 8},
        {-2, -5, 7},
        {-2, -4, 6},
        {-2, -3, 5},
        {-2, -2, 4},
        {-2, -1, 3},
        {-2, 0, 2},
        {-2, 1, 1},
        {-2, 2, 0},
        {-2, 3, -1},
        {-2, 4, -2},
        {-2, 5, -3},
        {-2, 6, -4},
        {-2, 7, -5},
        {-2, 8, -6},
        {-2, 9, -7},
        {-2, 10, -8},
        {-2, 11, -9},
        {-1, -10, 11},
        {-1, -9, 10},
        {-1, -8, 9},
        {-1, -7, 8},
        {-1, -6, 7},
        {-1, -5, 6},
        {-1, -4, 5},
        {-1, -3, 4},
        {-1, -2, 3},
        {-1, -1, 2},
        {-1, 0, 1},
        {-1, 1, 0},
        {-1, 2, -1},
        {-1, 3, -2},
        {-1, 4, -3},
        {-1, 5, -4},
        {-1, 6, -5},
        {-1, 7, -6},
        {-1, 8, -7},
        {-1, 9, -8},
        {-1, 10, -9},
        {-1, 11, -10},
        {0, -11, 11},
        {0, -10, 10},
        {0, -9, 9},
        {0, -8, 8},
        {0, -7, 7},
        {0, -6, 6},
        {0, -5, 5},
        {0, -4, 4},
        {0, -3, 3},
        {0, -2, 2},
        {0, -1, 1},
        {0, 0, 0},
        {0, 1, -1},
        {0, 2, -2},
        {0, 3, -3},
        {0, 4, -4},
        {0, 5, -5},
        {0, 6, -6},
        {0, 7, -7},
        {0, 8, -8},
        {0, 9, -9},
        {0, 10, -10},
        {0, 11, -11},
        {1, -11, 10},
        {1, -10, 9},
        {1, -9, 8},
        {1, -8, 7},
        {1, -7, 6},
        {1, -6, 5},
        {1, -5, 4},
        {1, -4, 3},
        {1, -3, 2},
        {1, -2, 1},
        {1, -1, 0},
        {1, 0, -1},
        {1, 1, -2},
        {1, 2, -3},
        {1, 3, -4},
        {1, 4, -5},
        {1, 5, -6},
        {1, 6, -7},
        {1, 7, -8},
        {1, 8, -9},
        {1, 9, -10},
        {1, 10, -11},
        {2, -11, 9},
        {2, -10, 8},
        {2, -9, 7},
        {2, -8, 6},
        {2, -7, 5},
        {2, -6, 4},
        {2, -5, 3},
        {2, -4, 2},
        {2, -3, 1},
        {2, -2, 0},
        {2, -1, -1},
        {2, 0, -2},
        {2, 1, -3},
        {2, 2, -4},
        {2, 3, -5},
        {2, 4, -6},
        {2, 5, -7},
        {2, 6, -8},
        {2, 7, -9},
        {2, 8, -10},
        {2, 9, -11},
        {3, -11, 8},
        {3, -10, 7},
        {3, -9, 6},
        {3, -8, 5},
        {3, -7, 4},
        {3, -6, 3},
        {3, -5, 2},
        {3, -4, 1},
        {3, -3, 0},
        {3, -2, -1},
        {3, -1, -2},
        {3, 0, -3},
        {3, 1, -4},
        {3, 2, -5},
        {3, 3, -6},
        {3, 4, -7},
        {3, 5, -8},
        {3, 6, -9},
        {3, 7, -10},
        {3, 8, -11},
        {4, -11, 7},
        {4, -9, 5},
        {4, -8, 4},
        {4, -7, 3},
        {4, -6, 2},
        {4, -5, 1},
        {4, -4, 0},
        {4, -3, -1},
        {4, -2, -2},
        {4, -1, -3},
        {4, 0, -4},
        {4, 1, -5},
        {4, 2, -6},
        {4, 3, -7},
        {4, 4, -8},
        {4, 5, -9},
        {4, 7, -11},
        {5, -11, 6},
        {5, -10, 5},
        {5, -9, 4},
        {5, -8, 3},
        {5, -7, 2},
        {5, -6, 1},
        {5, -5, 0},
        {5, -4, -1},
        {5, -3, -2},
        {5, -2, -3},
        {5, -1, -4},
        {5, 0, -5},
        {5, 1, -6},
        {5, 2, -7},
        {5, 3, -8},
        {5, 4, -9},
        {5, 5, -10},
        {5, 6, -11},
        {6, -11, 5},
        {6, -10, 4},
        {6, -9, 3},
        {6, -8, 2},
        {6, -7, 1},
        {6, -6, 0},
        {6, -5, -1},
        {6, -4, -2},
        {6, -3, -3},
        {6, -2, -4},
        {6, -1, -5},
        {6, 0, -6},
  