/****************************************************************************

        Copyright (C) 2024 Atsuto Seko
                seko@cms.mtl.kyoto-u.ac.jp

*****************************************************************************/

#include "polymlp_gtinv_data_ver2_order6.h"

GtinvDataVer2Order6::GtinvDataVer2Order6(){

    set_gtinv_info();
}

GtinvDataVer2Order6::~GtinvDataVer2Order6(){}

const vector2i& GtinvDataVer2Order6::get_l_array() const{ return l_array_all; }
const vector3i& GtinvDataVer2Order6::get_m_array() const{ return m_array_all; }
const vector2d& GtinvDataVer2Order6::get_coeffs() const{ return coeffs_all; }

void GtinvDataVer2Order6::set_gtinv_info(){

    l_array_all = {
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, 1},
        {0, 0, 1, 1, 1, 1},
        {0, 0, 1, 1, 1, 1},
        {0, 0, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 1, 1}
    };

    coeffs_all = {
        {1.0},
        {0.5773502691896258,
         -0.5773502691896255,
         0.5773502691896256},
        {0.2883343901782501,
         -0.28833439017824986,
         -0.30452544836356005,
         0.01619105818531022,
         0.27214333199293966,
         -0.2883343901782499,
         0.28833439017824997,
         0.01619105818531017,
         -0.016191058185310206,
         0.0161910581853102,
         0.28833439017824997,
         -0.28833439017824997,
         0.27214333199293966,
         0.01619105818531017,
         -0.3045254483635601,
         -0.28833439017824986,
         0.2883343901782499},
        {-0.01402186770263054,
         0.014021867702630616,
         -0.3189180078694474,
         0.3329398755720785,
         -0.346961743274709,
         0.014021867702630674,
         -0.01402186770263067,
         0.33293987557207827,
         -0.3329398755720783,
         0.33293987557207827,
         -0.014021867702630704,
         0.014021867702630681,
         -0.346961743274709,
         0.3329398755720783,
         -0.31891800786944763,
         0.014021867702630626,
         -0.014021867702630586},
        {0.44721359549995787,
         -0.22360679774997927,
         -0.223606797749979,
         0.07453559924999308,
         0.14907119849998607,
         0.07453559924999309,
         -0.223606797749979,
         -0.223606797749979,
         0.1490711984999861,
         0.29814239699997214,
         0.14907119849998607,
         -0.223606797749979,
         -0.22360679774997896,
         0.07453559924999308,
         0.14907119849998604,
         0.0745355992499931,
         -0.223606797749979,
         -0.22360679774997894,
         0.44721359549995815},
        {0.0014796470886098306,
         -0.0026905075065293176,
         0.001210860417919474,
         -0.011051811169312274,
         0.012841344410189304,
         -0.003269180329486747,
         -0.0010917364510918404,
         -0.009059100452567803,
         0.011117420364134878,
         0.005491445915511317,
         0.00172234530221832,
         -0.0072137912177294705,
         0.00044490846795586236,
         0.13145814673031891,
         -0.13887414820239583,
         -0.11011400140012842,
         -0.020375983125879432,
         0.16525306212808516,
         -0.15305493278550525,
         0.1636618354868617,
         -0.018523479324824753,
         0.02727892096982174,
         -0.04879742792480091,
         0.12972921717604521,
         -0.1275730545674195,
         -0.005207056090387878,
         -0.11826213121839306,
         0.11797774139326969,
         0.0838741824282419,
         0.032665603487932904,
         -0.14342955366347312,
         -0.0020455473470713773,
         0.006807694969503368,
         -0.006561239100001279,
         -0.004589229064853217,
         0.018677940904475998,
         0.03280105807188776,
         -0.04050144936908803,
         0.18618812935721255,
         -0.031087649224635947,
         -0.1393818812317291,
         -0.1611034109323865,
         0.16950136825205403,
         -0.0014268643155464357,
         -0.0069710930041210276,
         0.0009681622043110443,
         0.006002930799809979,
         0.009127255612746694,
         -0.1430886307225887,
         0.13945282102535325,
         0.11389624535774977,
         0.0309147306670572,
         -0.17758134291013988,
         0.1512653995446283,
         -0.1493408439880626,
         0.006773871365727417,
         -0.027791984597956284,
         0.04094918789015239,
         -0.11957838027238522,
         0.12551473465585236,
         -0.000729298293079242,
         -0.020409806729655335,
         0.022618752111344363,
         0.024517473669668263,
         -0.006798174446542232,
         -0.014609717246882566,
         0.0231974249343018,
         -0.0320402907219251,
         0.003740573094635538,
         0.005102292692987818,
         0.003740573094635533,
         -0.03204029072192511,
         0.023197424934301797,
         -0.014609717246882536,
         -0.006798174446542254,
         0.02451747366966827,
         0.022618752111344353,
         -0.02040980672965534,
         -0.0007292982930792391,
         0.1255147346558523,
         -0.11957838027238521,
         0.04094918789015241,
         -0.027791984597956277,
         0.006773871365727434,
         -0.14934084398806263,
         0.15126539954462825,
         -0.17758134291013994,
         0.030914730667057192,
         0.11389624535774973,
         0.1394528210253532,
         -0.1430886307225887,
         0.009127255612746703,
         0.00600293079980997,
         0.0009681622043110739,
         -0.0069710930041210085,
         -0.0014268643155464504,
         0.16950136825205397,
         -0.1611034109323865,
         -0.13938188123172907,
         -0.031087649224635933,
         0.18618812935721255,
         -0.040501449369088054,
         0.03280105807188777,
         0.018677940904475974,
         -0.00458922906485321,
         -0.006561239100001283,
         0.00680769496950337,
         -0.0020455473470713716,
         -0.14342955366347318,
         0.03266560348793293,
         0.08387418242824192,
         0.11797774139326973,
         -0.11826213121839306,
         -0.005207056090387876,
         -0.12757305456741955,
         0.12972921717604521,
         -0.04879742792480094,
         0.027278920969821728,
         -0.01852347932482473,
         0.16366183548686167,
         -0.15305493278550525,
         0.16525306212808524,
         -0.02037598312587939,
         -0.11011400140012839,
         -0.13887414820239577,
         0.13145814673031897,
         0.0004449084679559255,
         -0.007213791217729489,
         0.0017223453022182195,
         0.00549144591551125,
         0.011117420364135124,
         -0.009059100452568027,
         -0.0010917364510919724,
         -0.0032691803294866853,
         0.012841344410189238,
         -0.011051811169312383,
         0.0012108604179194833,
         -0.0026905075065292933,
         0.0014796470886098152},
        {-0.014623054612333599,
         0.059393565067565046,
         -0.04477051045523138,
         0.0014109609339202924,
         -0.022990808872795074,
         0.03620290255120832,
         -0.004675079576336468,
         -0.03172767661843349,
         0.04029528452245653,
         0.12475639590251768,
         -0.1126090375539703,
         -0.012147358348547221,
         0.11097816062572174,
         -0.11064307878885553,
         -0.11046842312704999,
         0.0482830680011781,
         0.11557548327408287,
         0.05181080865674585,
         -0.10322684174963716,
         -0.009162279810004677,
         0.11280912782944501,
         0.12405160158184289,
         -0.0406238011959966,
         -0.15641711625428661,
         -0.051482291983205565,
         -0.22602092921949765,
         0.03119473218689839,
         0.07006980113008124,
         0.07263321887545775,
         0.008781086491613755,
         -0.06670352927314777,
         0.15191151295341612,
         -0.0368687443596402,
         -0.06795356518468827,
         -0.004509601166771023,
         0.08177696752338001,
         -0.052962721691947566,
         -0.06688424690697797,
         -0.036622365044756904,
         -0.012062306159021952,
         0.05809333032866694,
         -0.008233197599999709,
         -0.09924649665605031,
         0.21761303554623387,
         -0.11013334129018398,
         0.05321547248640538,
         0.05691786880377858,
         -0.09776606694730834,
         0.08886337720641924,
         0.13365908564340653,
         -0.1030015534924067,
         -0.09847086126798293,
         -0.04733558272397097,
         0.12480668968851207,
         -0.02845158367512397,
         -0.08514323938031348,
         -0.10553601864182285,
         -0.03587438587766827,
         0.1928198724490565,
         0.04291468407918266,
         -0.009713627308741658,
         0.06730098825340955,
         -0.07221041555700156,
         -0.008307249322665498,
         0.0003998261368209827,
         0.027040078964949227,
         -0.04901975304064494,
         0.04552128667097325,
         0.017504448142920882,
         -0.014005981773249158,
         0.017504448142920872,
         0.04552128667097327,
         -0.04901975304064497,
         0.02704007896494922,
         0.00039982613682095934,
         -0.008307249322665501,
         -0.07221041555700156,
         0.06730098825340956,
         -0.009713627308741708,
         0.04291468407918261,
         0.19281987244905657,
         -0.03587438587766828,
         -0.10553601864182281,
         -0.08514323938031351,
         -0.02845158367512396,
         0.12480668968851202,
         -0.04733558272397093,
         -0.09847086126798292,
         -0.10300155349240675,
         0.13365908564340662,
         0.08886337720641924,
         -0.09776606694730834,
         0.056917868803778575,
         0.05321547248640533,
         -0.1101333412901839,
         0.217613035546234,
         -0.0992464966560503,
         -0.008233197599999718,
         0.058093330328666905,
         -0.01206230615902194,
         -0.03662236504475688,
         -0.06688424690697797,
         -0.05296272169194761,
         0.08177696752338001,
         -0.004509601166771033,
         -0.06795356518468827,
         -0.03686874435964019,
         0.1519115129534161,
         -0.06670352927314781,
         0.008781086491613736,
         0.07263321887545776,
         0.07006980113008127,
         0.03119473218689884,
         -0.22602092921949754,
         -0.05148229198320561,
         -0.15641711625428667,
         -0.04062380119599664,
         0.12405160158184303,
         0.11280912782944498,
         -0.009162279810004663,
         -0.1032268417496372,
         0.05181080865674581,
         0.11557548327408286,
         0.04828306800117815,
         -0.11046842312704992,
         -0.11064307878885558,
         0.1109781606257217,
         -0.012147358348547237,
         -0.11260903755397034,
         0.12475639590251762,
         0.04029528452245649,
         -0.03172767661843357,
         -0.00467507957633639,
         0.036202902551208394,
         -0.022990808872795077,
         0.0014109609339202228,
         -0.04477051045523145,
         0.05939356506756501,
         -0.014623054612333606},
        {-0.0009789311842293704,
         0.04848892491689613,
         -0.04750999373266679,
         0.002366851714404161,
         0.04798662895000139,
         -0.049374549480176125,
         -0.08960654835526574,
         -0.006869005511631818,
         0.10375354872447452,
         0.01745889670885767,
         -0.10219447761221577,
         0.08473558090335813,
         0.0604513066453814,
         -0.06224194805959999,
         -0.01468932411040955,
         0.08996596785038297,
         0.025981532904536753,
         -0.048517795964818644,
         0.012135716313445621,
         -0.0749538746732313,
         -0.057087062511126475,
         0.0592066653072794,
         0.07981108295653758,
         0.056727643016009126,
         -0.13504683571619347,
         -0.11597387457744406,
         0.23054563804278067,
         -0.13203066017419438,
         -0.09476919531947543,
         -0.03358196511108952,
         0.08087704438192583,
         -0.15273405596868742,
         0.20825662390074992,
         -0.001586360522469302,
         -0.013983273492023964,
         -0.04755336612412212,
         0.006389587991561713,
         0.015194117707014952,
         0.16204617551814596,
         -0.021447835862904285,
         -0.11185491336461452,
         -0.10337275248455037,
         0.07959719653219909,
         0.04025552147697946,
         -0.01647996552462829,
         0.05370555269531969,
         -0.037225587170691424,
         -0.061839227175556157,
         -0.03325467462306793,
         0.11255279850748177,
         -0.04884834441201343,
         -0.0200914585771344,
         -0.007725759026989323,
         -0.06248919697785123,
         0.12196157243900321,
         0.09870698191639068,
         -0.05094973926547286,
         -0.13419008220083606,
         0.03974791085088837,
         0.03816229250335071,
         0.03806367122320497,
         -0.08356810907982251,
         0.04452550667238824,
         0.10699770508130821,
         0.02505932891541039,
         -0.11709482932046522,
         0.14238898106946035,
         -0.17906473176249058,
         0.030949403242812815,
         0.005726347450217393,
         0.030949403242812822,
         -0.17906473176249058,
         0.1423889810694604,
         -0.11709482932046525,
         0.02505932891541038,
         0.10699770508130815,
         0.04452550667238818,
         -0.08356810907982251,
         0.03806367122320496,
         0.038162292503350716,
         0.03974791085088835,
         -0.1341900822008361,
         -0.05094973926547289,
         0.09870698191639062,
         0.12196157243900317,
         -0.062489196977851214,
         -0.0077257590269893765,
         -0.020091458577134375,
         -0.04884834441201344,
         0.11255279850748172,
         -0.03325467462306793,
         -0.06183922717555618,
         -0.03722558717069143,
         0.053705552695319694,
         -0.01647996552462829,
         0.040255521476979424,
         0.07959719653219906,
         -0.10337275248455029,
         -0.11185491336461452,
         -0.02144783586290428,
         0.16204617551814596,
         0.015194117707014912,
         0.0063895879915617255,
         -0.0475533661241221,
         -0.013983273492023952,
         -0.001586360522469286,
         0.20825662390074992,
         -0.1527340559686874,
         0.0808770443819258,
         -0.033581965111089546,
         -0.09476919531947546,
         -0.1320306601741944,
         0.23054563804278064,
         -0.11597387457744404,
         -0.13504683571619366,
         0.056727643016009084,
         0.07981108295653741,
         0.05920666530727942,
         -0.057087062511126455,
         -0.0749538746732313,
         0.012135716313445755,
         -0.048517795964818644,
         0.025981532904536836,
         0.08996596785038298,
         -0.014689324110409623,
         -0.062241948059600066,
         0.06045130664538141,
         0.08473558090335813,
         -0.10219447761221577,
         0.01745889670885767,
         0.10375354872447472,
         -0.00686900551163182,
         -0.0896065483552657,
         -0.04937454948017613,
         0.047986628950001387,
         0.002366851714404165,
         -0.04750999373266667,
         0.048488924916896096,
         -0.000978931184229353},
        {-0.005721708155861641,
         -0.04769575937420897,
         0.05341746753007056,
         0.004915394289247481,
         -0.01952393002076234,
         0.02033024388737654,
         0.05402402588316434,
         0.013195663511807013,
         -0.08694337492925401,
         0.06361736830980375,
         0.009799925950832884,
         -0.07341729426063645,
         -0.03436357783201967,
         0.015783601160652288,
         -0.039315683482574984,
         -0.09673394530332076,
         0.11884617756604464,
         -0.059530667352903466,
         -0.027252653062841192,
         0.05670083660561367,
         0.1403090545454948,
         -0.10931607262254311,
         0.07160067561212768,
         -0.0975991351253381,
         0.07487336667002997,
         0.06491346332863208,
         -0.00832158312738888,
         -0.1202092485110468,
         0.013172547369638169,
         -0.014650890193082038,
         0.2082774329647654,
         -0.055466224948660305,
         0.02491633945204778,
         0.0001365803280011,
         0.04786762658739586,
         0.0867409659541781,
         0.08342481760568157,
         -0.2354877315660398,
         -0.03772693013142788,
         0.1204458081429298,
         -0.20206298420059118,
         -0.10271870474206786,
         0.043721342634285405,
         0.11689302226172452,
         -0.05789566015394204,
         0.03789583342337602,
         0.01999982673056599,
         0.035169891698633805,
         0.057157796390180426,
         -0.028710319779010535,
         0.09040567879436535,
         -0.1377635492337131,
         0.0930565747520871,
         0.04186118879435643,
         -0.08194647478223763,
         -0.17480915040789655,
         0.09531409524412192,
         -0.004987544570250185,
         0.03037944573036705,
         -0.001125655252582873,
         -0.09416725380641625,
         -0.08087931229389993,
         0.1693248579444544,
         0.07376147198284987,
         -0.040577919063158704,
         -0.07532947135122521,
         0.10129885468286899,
         -0.007937914743067069,
         -0.059495290730827335,
         -0.033865649208974676,
         -0.059495290730827356,
         -0.007937914743067095,
         0.10129885468286895,
         -0.0753294713512253,
         -0.04057791906315877,
         0.07376147198284984,
         0.16932485794445445,
         -0.08087931229389986,
         -0.09416725380641623,
         -0.0011256552525828471,
         0.03037944573036708,
         -0.004987544570250204,
         0.09531409524412199,
         -0.17480915040789655,
         -0.08194647478223761,
         0.04186118879435641,
         0.09305657475208717,
         -0.13776354923371303,
         0.09040567879436537,
         -0.028710319779010573,
         0.05715779639018041,
         0.03516989169863381,
         0.019999826730565974,
         0.037895833423376026,
         -0.05789566015394199,
         0.11689302226172445,
         0.043721342634285475,
         -0.10271870474206786,
         -0.20206298420059116,
         0.12044580814292975,
         -0.037726930131427826,
         -0.2354877315660398,
         0.08342481760568148,
         0.08674096595417811,
         0.04786762658739581,
         0.00013658032800105464,
         0.024916339452047787,
         -0.05546622494866029,
         0.20827743296476536,
         -0.014650890193082022,
         0.013172547369638118,
         -0.12020924851104679,
         -0.008321583127388862,
         0.06491346332863207,
         0.07487336667002994,
         -0.09759913512533816,
         0.07160067561212764,
         -0.10931607262254309,
         0.14030905454549475,
         0.05670083660561368,
         -0.027252653062841612,
         -0.05953066735290361,
         0.11884617756604438,
         -0.09673394530332072,
         -0.03931568348257477,
         0.015783601160652343,
         -0.03436357783201954,
         -0.07341729426063645,
         0.009799925950832823,
         0.06361736830980372,
         -0.08694337492925401,
         0.013195663511806949,
         0.05402402588316419,
         0.020330243887376632,
         -0.019523930020762317,
         0.004915394289247445,
         0.05341746753007042,
         -0.0476957593742088,
         -0.005721708155861726},
        {-0.06065404009416669,
         -0.03843651096000217,
         0.09909055105416872,
         0.09756926683137837,
         0.20598492160074233,
         -0.24290014833795412,
         -0.14312607871221938,
         -0.02442233192852089,
         0.16823192921230606,
         0.02116224117906504,
         0.02483081473780438,
         -0.04599305591686964,
         -0.031790293576124284,
         -0.04565876581164821,
         0.11694085830287404,
         0.07032343438289014,
         -0.011058972349044169,
         -0.15897938109112922,
         -0.1930548010190151,
         0.12727582776376098,
         0.03161420670637004,
         0.0011144385235510319,
         -0.0024309762522320196,
         0.04118843762295884,
         -0.0068215718689448234,
         0.025404387158379605,
         -0.022399410349535284,
         -0.024167217987909398,
         -0.008270288614975058,
         0.005838884226705909,
         0.06432138967807298,
         0.1339830486059961,
         -0.12759714218825136,
         -0.046429496413369624,
         -0.019495376031442954,
         0.05431887790472954,
         -0.015623649354545533,
         0.04033911350832675,
         0.02078954698271932,
         0.038282205430299754,
         -0.03796089100580941,
         -0.005974257275719727,
         -0.01392701064668813,
         -0.01959053099269369,
         0.03949179891510162,
         0.01360569622219784,
         -0.053097495137299396,
         -0.005124933161087525,
         -0.061235604734925154,
         0.08752277907507772,
         0.11123915528933115,
         -0.02517273581660157,
         -0.10834309917534561,
         -0.11049938741310546,
         0.018055053742814676,
         -0.09447304959489312,
         0.060223120142181646,
         0.07709919537787997,
         0.1263599730177811,
         -0.1369880254148404,
         -0.014776334761320358,
         0.02206512024431406,
         -0.06794282557716029,
         -0.0868839605057196,
         0.026382329301403343,
         0.14065104732992584,
         0.13652081180079162,
         -0.08482925030225948,
         -0.00984937886424237,
         -0.04184218263428978,
         -0.009849378864242348,
         -0.08482925030225948,
         0.13652081180079165,
         0.1406510473299259,
         0.026382329301403346,
         -0.08688396050571959,
         -0.06794282557716029,
         0.02206512024431403,
         -0.01477633476132038,
         -0.13698802541484037,
         0.1263599730177811,
         0.07709919537787996,
         0.060223120142181626,
         -0.09447304959489311,
         0.018055053742814606,
         -0.11049938741310547,
         -0.10834309917534565,
         -0.025172735816601614,
         0.11123915528933112,
         0.08752277907507772,
         -0.06123560473492519,
         -0.005124933161087526,
         -0.05309749513729938,
         0.013605696222197766,
         0.03949179891510157,
         -0.019590530992693676,
         -0.013927010646688205,
         -0.005974257275719703,
         -0.037960891005809405,
         0.03828220543029976,
         0.020789546982719356,
         0.04033911350832678,
         -0.015623649354545539,
         0.05431887790472957,
         -0.01949537603144293,
         -0.04642949641336962,
         -0.12759714218825138,
         0.13398304860599608,
         0.064321389678073,
         0.005838884226705909,
         -0.008270288614975137,
         -0.02416721798790939,
         -0.02239941034953525,
         0.025404387158379633,
         -0.006821571868944846,
         0.04118843762295882,
         -0.0024309762522321267,
         0.001114438523551012,
         0.03161420670637003,
         0.12727582776376098,
         -0.19305480101901507,
         -0.15897938109112922,
         -0.011058972349044216,
         0.0703234343828902,
         0.11694085830287397,
         -0.04565876581164824,
         -0.03179029357612433,
         -0.045993055916869544,
         0.024830814737804442,
         0.021162241179065046,
         0.1682319292123061,
         -0.024422331928520905,
         -0.1431260787122192,
         -0.2429001483379541,
         0.20598492160074236,
         0.09756926683137844,
         0.09909055105416893,
         -0.03843651096000226,
         -0.06065404009416661},
        {-0.1005712673220917,
         -0.07119180437106198,
         0.1717630716931534,
         0.13026595027649715,
         -0.008352141196024565,
         -0.021342541758380643,
         0.10916312280936533,
         -0.02961917724227874,
         -0.12080135269249409,
         0.08094944080013372,
         0.05453843308635122,
         -0.1354878738864848,
         -0.021547586237177008,
         0.03873389732395144,
         0.0024355154351833885,
         0.08735746240782476,
         -0.10943798844706559,
         0.07072727520521375,
         -0.06386018422550539,
         -0.04485817981381462,
         -0.09410400778703613,
         0.12758243588461501,
         -0.06381722974760302,
         -0.102416577430154,
         0.11389130723488337,
         -0.09264805730895675,
         0.022300877943214233,
         -0.010602261434391164,
         -0.1933828499772449,
         0.11654353894767956,
         0.029546596373196492,
         0.03381795666585309,
         0.08037768688028059,
         -0.034879152164446973,
         -0.059973579768571816,
         -0.012237361112500988,
         0.14090453973386713,
         -0.0880365104659093,
         0.12275018970446692,
         -0.09270796214481465,
         0.05718845507834872,
         0.0062329702470162165,
         0.01886613578175523,
         -0.04472093255072936,
         0.019621826521957847,
         0.01665337128471061,
         -0.03627519780666846,
         -0.008147096717228573,
         0.1413813155652267,
         -0.05228477804786459,
         -0.12532878084612836,
         0.03848589836725282,
         -0.12168899420587304,
         -0.05805362485496679,
         -0.06406522870430173,
         -0.0067069738263044396,
         -0.06826857568793077,
         0.20596112419847767,
         0.02287263186306729,
         0.03652922269988946,
         0.033246202746000014,
         -0.19652264915365059,
         0.06270517908555903,
         0.051486954483068975,
         0.0738438902995198,
         0.035214002308074685,
         0.012855916472877768,
         -0.016407436264472247,
         0.0028918002197069062,
         0.0006597195718875833,
         0.002891800219706889,
         -0.01640743626447226,
         0.012855916472877751,
         0.03521400230807467,
         0.07384389029951978,
         0.05148695448306901,
         0.06270517908555903,
         -0.19652264915365059,
         0.03324620274600004,
         0.03652922269988947,
         0.022872631863067313,
         0.20596112419847765,
         -0.06826857568793077,
         -0.006706973826304426,
         -0.0640652287043017,
         -0.05805362485496678,
         -0.12168899420587302,
         0.03848589836725283,
         -0.12532878084612836,
         -0.052284778047864584,
         0.1413813155652267,
         -0.008147096717228538,
         -0.036275197806668456,
         0.016653371284710627,
         0.01962182652195785,
         -0.044720932550729404,
         0.018866135781755246,
         0.006232970247016212,
         0.057188455078348764,
         -0.09270796214481462,
         0.12275018970446692,
         -0.08803651046590931,
         0.1409045397338671,
         -0.012237361112500986,
         -0.05997357976857184,
         -0.03487915216444699,
         0.08037768688028062,
         0.03381795666585309,
         0.029546596373196492,
         0.11654353894767955,
         -0.19338284997724492,
         -0.010602261434391155,
         0.022300877943214222,
         -0.0926480573089568,
         0.11389130723488342,
         -0.102416577430154,
         -0.063817229747603,
         0.127582435884615,
         -0.09410400778703612,
         -0.04485817981381464,
         -0.06386018422550543,
         0.0707272752052138,
         -0.10943798844706557,
         0.08735746240782476,
         0.0024355154351833387,
         0.03873389732395144,
         -0.02154758623717692,
         -0.13548787388648484,
         0.054538433086351194,
         0.08094944080013367,
         -0.12080135269249405,
         -0.02961917724227868,
         0.10916312280936546,
         -0.021342541758380615,
         -0.008352141196024919,
         0.1302659502764971,
         0.17176307169315336,
         -0.0711918043710618,
         -0.10057126732209155},
        {0.02428173188691718,
         -0.05455963279423232,
         0.030277900907315067,
         0.019998817009450016,
         -0.017175352867095015,
         -0.02710519602927234,
         -0.03308911186522159,
         0.1048240975265487,
         -0.10799680240459174,
         0.052199972241190856,
         -0.17664766277670843,
         0.12444769053551763,
         -0.11613529872743422,
         0.12577570661562618,
         -0.08612211201630027,
         0.15229153086771893,
         -0.046859941912404564,
         -0.02174353751412776,
         -0.000951568562041899,
         0.09708805028002579,
         -0.054311583869386504,
         -0.05333720131710308,
         0.06947645908264943,
         -0.06489083513311093,
         0.06026388083606979,
         0.07090947851144883,
         -0.008449164719195856,
         -0.11466028603344369,
         0.14795906368329376,
         0.03713776381261058,
         -0.04692516831468432,
         -0.005369137834226016,
         0.05059495805021135,
         -0.20513543831531206,
         0.09317803425310765,
         0.05700940574642502,
         -0.09511515623570077,
         0.011659300082387213,
         0.11104213713813356,
         -0.10472143074186599,
         -0.042961577588371186,
         0.14840488504656493,
         -0.08352428724070358,
         0.01160110632224665,
         -0.07648170412810812,
         0.23120729557094072,
         -0.15472559144283263,
         0.07185474983106689,
         -0.07832245284121622,
         0.05866767525134014,
         -0.06464278620826511,
         -0.033682423727227004,
         0.0994624390114044,
         -0.0018718955803133405,
         -0.0899816712602036,
         0.10457604860170314,
         -0.007206347313078472,
         0.06562553935121417,
         -0.006844150528216348,
         -0.05709117595802692,
         -0.006974152025205475,
         0.007121148639087198,
         0.024134735273035585,
         -0.12360293177430443,
         0.061922150340984895,
         -0.05577898470670543,
         -0.0033197014919244803,
         0.054574402413497265,
         -0.018620215298646776,
         -0.03263448562292599,
         -0.018620215298646773,
         0.054574402413497244,
         -0.0033197014919244504,
         -0.05577898470670537,
         0.061922150340984944,
         -0.1236029317743044,
         0.02413473527303557,
         0.007121148639087146,
         -0.006974152025205465,
         -0.05709117595802695,
         -0.006844150528216355,
         0.06562553935121411,
         -0.0072063473130785285,
         0.10457604860170314,
         -0.08998167126020354,
         -0.0018718955803133685,
         0.0994624390114044,
         -0.03368242372722702,
         -0.06464278620826512,
         0.058667675251340166,
         -0.07832245284121618,
         0.07185474983106682,
         -0.15472559144283266,
         0.2312072955709408,
         -0.07648170412810812,
         0.011601106322246675,
         -0.08352428724070354,
         0.14840488504656493,
         -0.04296157758837122,
         -0.10472143074186595,
         0.11104213713813357,
         0.011659300082387225,
         -0.09511515623570069,
         0.05700940574642502,
         0.0931780342531076,
         -0.2051354383153121,
         0.05059495805021139,
         -0.005369137834225993,
         -0.046925168314684323,
         0.03713776381261059,
         0.14795906368329376,
         -0.11466028603344369,
         -0.00844916471919589,
         0.0709094785114488,
         0.06026388083606971,
         -0.06489083513311093,
         0.06947645908264985,
         -0.05333720131710308,
         -0.054311583869386566,
         0.0970880502800258,
         -0.0009515685620417201,
         -0.02174353751412783,
         -0.046859941912404605,
         0.15229153086771904,
         -0.08612211201630021,
         0.1257757066156262,
         -0.11613529872743415,
         0.12444769053551769,
         -0.17664766277670851,
         0.052199972241190856,
         -0.10799680240459172,
         0.10482409752654902,
         -0.0330891118652217,
         -0.027105196029272284,
         -0.017175352867094932,
         0.019998817009450078,
         0.03027790090731506,
         -0.05455963279423224,
         0.02428173188691727},
        {0.016777236592178578,
         -0.046124448394688676,
         0.02934721180251051,
         0.024288175296881927,
         0.02727309029258229,
         -0.0683385021816432,
         -0.04441852488818652,
         0.06326988299029268,
         -0.02427859261115976,
         0.06307676218605043,
         0.03825633298231994,
         -0.10133309516837027,
         -0.03726430514370706,
         -0.05241862309151357,
         0.00982892945699135,
         0.08981436280340016,
         -0.02952762429951683,
         0.09168457820838723,
         0.06169362581601803,
         -0.04871749596919332,
         -0.08646093984989515,
         0.04991284683280885,
         0.05731422186103626,
         0.04106510193468111,
         -0.12472020745826379,
         0.1376609809962019,
         -0.14503289488327675,
         -0.055704848298975054,
         -0.06059483661438874,
         0.16737139851534577,
         -0.010333455048000834,
         -0.07835700319205578,
         -0.02203967266043942,
         0.17032485856589957,
         0.1054836626009465,
         -0.03756807109852317,
         -0.1995443847549109,
         -0.04378305206186283,
         0.0047853420258937955,
         0.011878035350144367,
         0.058879133279488446,
         -0.088649260741898,
         -0.07862528404200131,
         0.24712854356212824,
         -0.07985399877822871,
         0.00786811541236865,
         0.07198588336586009,
         -0.0038011067453543055,
         0.054492744601440914,
         0.012385124329963155,
         0.0007286104794743249,
         -0.016965022098595472,
         -0.09675319739973774,
         -0.11325489140548216,
         0.09276782285395423,
         0.10360637444549896,
         -0.07211731793404022,
         0.0353028729317661,
         -0.059916460036787196,
         0.08572891707913063,
         -0.1634734380385455,
         0.09611842280642033,
         0.0841322518243035,
         -0.06747585917133134,
         -0.07476701202977744,
         0.0199819720079838,
         0.10634630561125812,
         0.09819254431634791,
         -0.12125965842789126,
         -0.08327919149971487,
         -0.12125965842789126,
         0.09819254431634776,
         0.10634630561125807,
         0.019981972007983854,
         -0.07476701202977751,
         -0.06747585917133136,
         0.08413225182430356,
         0.09611842280642041,
         -0.16347343803854547,
         0.08572891707913065,
         -0.05991646003678721,
         0.03530287293176616,
         -0.07211731793404026,
         0.10360637444549894,
         0.09276782285395442,
         -0.11325489140548219,
         -0.09675319739973759,
         -0.016965022098595472,
         0.0007286104794743566,
         0.01238512432996311,
         0.05449274460144108,
         -0.003801106745354319,
         0.07198588336586013,
         0.007868115412368714,
         -0.07985399877822852,
         0.24712854356212813,
         -0.07862528404200113,
         -0.08864926074189808,
         0.058879133279488544,
         0.011878035350144414,
         0.004785342025893853,
         -0.04378305206186276,
         -0.19954438475491115,
         -0.03756807109852329,
         0.10548366260094644,
         0.17032485856589938,
         -0.022039672660439442,
         -0.0783570031920556,
         -0.01033345504800069,
         0.1673713985153459,
         -0.06059483661438906,
         -0.05570484829897497,
         -0.14503289488327675,
         0.137660980996202,
         -0.12472020745826376,
         0.04106510193468101,
         0.05731422186103626,
         0.049912846832808624,
         -0.08646093984989513,
         -0.048717495969193024,
         0.06169362581601749,
         0.09168457820838684,
         -0.029527624299518114,
         0.08981436280340031,
         0.00982892945699146,
         -0.05241862309151345,
         -0.0372643051437064,
         -0.10133309516837,
         0.038256332982320077,
         0.06307676218604992,
         -0.02427859261115921,
         0.06326988299029265,
         -0.044418524888186324,
         -0.06833850218164318,
         0.027273090292582177,
         0.024288175296882215,
         0.029347211802509654,
         -0.04612444839468862,
         0.016777236592178765},
        {0.004386822726241587,
         0.14587899545674604,
         -0.15026581818298768,
         0.08119246228756914,
         -0.11636119772370301,
         0.030781912709892528,
         -0.06907061538665116,
         0.03955281765360805,
         0.07993108781948717,
         -0.08191381624110738,
         -0.051522203534693695,
         0.13343601977580108,
         -0.028035190646620467,
         0.009475238437986533,
         0.09608694572349963,
         0.01693898315803126,
         -0.12077101351806997,
         0.04151386620175682,
         -0.048121782016283365,
         -0.005035489624665241,
         0.09377244458521344,
         0.061235296716786555,
         -0.1830686655255134,
         -0.041640812356593906,
         0.061623711504269346,
         0.16901999301093093,
         0.05221536847134275,
         -0.1393215452411664,
         -0.0958914862958536,
         0.0951983213592047,
         -0.08931279589383936,
         -0.04012774450490922,
         -0.10085705785940127,
         -0.02867954717162281,
         0.007116684767202808,
         0.13697497260986524,
         0.10763205030944521,
         -0.08917604291778271,
         0.039986427514788474,
         0.04826309900640406,
         0.057629448477662486,
         -0.10507932492837908,
         -0.011535755562014336,
         0.03908808697552778,
         0.07752699351486574,
         -0.09435679192205221,
         0.016829798407186552,
         -0.05754409436719023,
         -0.04337985889727092,
         0.019010137023353888,
         -0.09374736322812637,
         0.08560501859070363,
         0.02882086416174355,
         0.08329051745241745,
         -0.10693888537279626,
         0.0916593685251405,
         -0.01520882935658383,
         0.0723556649961337,
         0.07115861008963678,
         -0.18110761697736447,
         -0.05907098612320322,
         0.07174541286647179,
         -0.008287604017027056,
         0.13047470667251612,
         -0.05634112408224201,
         -0.08563709008371863,
         0.10680947872982649,
         0.03784079240718735,
         -0.0915071190096084,
         -0.053143152127405564,
         -0.09150711900960835,
         0.03784079240718735,
         0.1068094787298265,
         -0.08563709008371861,
         -0.05634112408224202,
         0.13047470667251612,
         -0.008287604017027063,
         0.07174541286647178,
         -0.0590709861232032,
         -0.18110761697736444,
         0.07115861008963678,
         0.07235566499613372,
         -0.01520882935658383,
         0.0916593685251405,
         -0.10693888537279621,
         0.08329051745241746,
         0.028820864161743523,
         0.08560501859070364,
         -0.09374736322812635,
         0.019010137023353833,
         -0.04337985889727089,
         -0.05754409436719024,
         0.0168297984071865,
         -0.09435679192205226,
         0.07752699351486572,
         0.03908808697552781,
         -0.011535755562014324,
         -0.1050793249283791,
         0.05762944847766251,
         0.04826309900640402,
         0.03998642751478849,
         -0.08917604291778275,
         0.10763205030944521,
         0.13697497260986521,
         0.007116684767202848,
         -0.028679547171622834,
         -0.10085705785940127,
         -0.040127744504909184,
         -0.08931279589383939,
         0.09519832135920467,
         -0.09589148629585366,
         -0.13932154524116644,
         0.052215368471342706,
         0.16901999301093107,
         0.06162371150426933,
         -0.041640812356593865,
         -0.18306866552551343,
         0.06123529671678657,
         0.09377244458521344,
         -0.005035489624665271,
         -0.048121782016283365,
         0.04151386620175682,
         -0.12077101351806996,
         0.01693898315803123,
         0.09608694572349946,
         0.009475238437986495,
         -0.028035190646620394,
         0.13343601977580097,
         -0.05152220353469378,
         -0.08191381624110733,
         0.07993108781948723,
         0.03955281765360797,
         -0.06907061538665081,
         0.030781912709892403,
         -0.1163611977237031,
         0.0811924622875692,
         -0.15026581818298762,
         0.14587899545674612,
         0.004386822726241579},
        {0.24191562996288926,
         -0.16933489666143867,
         -0.07258073330145043,
         -0.018310434676588147,
         -0.08220734774342794,
         -0.14139784754287288,
         0.208108975412855,
         0.04343326899201158,
         0.17054531185231156,
         -0.09955693745455214,
         0.07608760340601399,
         0.0234693340485381,
         -0.12525999767432583,
         -0.006365460272298118,
         -0.010733234561712796,
         0.004871531703467603,
         0.09474122182425501,
         -0.034896588009629984,
         0.04924229771485142,
         0.09432813463606268,
         -0.06319888900317039,
         0.10252939930404503,
         -0.04472645183552214,
         -0.1497816181131523,
         -0.09092227200715941,
         0.05461388196503901,
         0.02597953524261979,
         0.018963520246893417,
         -0.054039575934287744,
         -0.04802756271434617,
         0.005594708418914574,
         0.042462891629504965,
         0.02818322407978197,
         0.012481053165584597,
         -0.07455801976541125,
         0.038144510000448634,
         0.036686991065235514,
         -0.00884263040973325,
         0.008124045746141685,
         -0.09982923509049813,
         -0.022682123625346603,
         0.04259379009144414,
         0.029264065460420104,
         0.07050083695647263,
         -0.1423586925083369,
         0.09324729325542454,
         0.049111399252912254,
         -0.0983451976119748,
         0.015992074714275734,
         -0.017203814556853034,
         -0.04364561045488402,
         0.10374113914662225,
         -0.06306799054123122,
         0.051275484705164784,
         0.06538014758339834,
         -0.06270273866625668,
         0.07764252699024413,
         0.015578987526083322,
         -0.10176062629171434,
         -0.1230563088371636,
         0.17020305316383916,
         0.003855259078216397,
         0.06785731772083343,
         -0.026919559175193983,
         -0.14627059656446117,
         0.0058325455421772785,
         0.03992026860226761,
         0.01348187352019406,
         0.052211764406416346,
         -0.10561390652887799,
         0.05221176440641634,
         0.013481873520194074,
         0.039920268602267626,
         0.005832545542177272,
         -0.14627059656446126,
         -0.02691955917519399,
         0.06785731772083345,
         0.0038552590782164023,
         0.17020305316383919,
         -0.12305630883716372,
         -0.10176062629171431,
         0.015578987526083356,
         0.0776425269902441,
         -0.06270273866625668,
         0.06538014758339833,
         0.05127548470516477,
         -0.06306799054123123,
         0.10374113914662224,
         -0.04364561045488402,
         -0.017203814556853006,
         0.01599207471427574,
         -0.09834519761197484,
         0.0491113992529123,
         0.09324729325542457,
         -0.14235869250833685,
         0.07050083695647263,
         0.02926406546042007,
         0.04259379009144414,
         -0.02268212362534657,
         -0.09982923509049811,
         0.008124045746141652,
         -0.008842630409733234,
         0.036686991065235534,
         0.03814451000044863,
         -0.07455801976541125,
         0.012481053165584581,
         0.028183224079781983,
         0.042462891629504985,
         0.005594708418914612,
         -0.04802756271434616,
         -0.05403957593428776,
         0.01896352024689342,
         0.02597953524261975,
         0.05461388196503903,
         -0.09092227200715942,
         -0.1497816181131522,
         -0.04472645183552221,
         0.10252939930404499,
         -0.06319888900317037,
         0.0943281346360627,
         0.04924229771485144,
         -0.03489658800962998,
         0.094741221824255,
         0.004871531703467578,
         -0.010733234561712802,
         -0.006365460272298114,
         -0.12525999767432588,
         0.02346933404853813,
         0.07608760340601402,
         -0.0995569374545522,
         0.17054531185231173,
         0.04343326899201157,
         0.20810897541285514,
         -0.14139784754287266,
         -0.08220734774342794,
         -0.018310434676588206,
         -0.07258073330145018,
         -0.16933489666143875,
         0.24191562996288918},
        {0.3779644730092273,
         -0.12598815766974247,
         -0.1259881576697424,
         -0.12598815766974236,
         0.025197631533948495,
         0.05039526306789691,
         0.05039526306789696,
         0.025197631533948463,
         0.05039526306789697,
         0.025197631533948522,
         -0.1259881576697424,
         -0.12598815766974233,
         -0.12598815766974233,
         0.05039526306789693,
         0.10079052613579387,
         0.10079052613579388,
         0.050395263067896934,
         0.1007905261357939,
         0.05039526306789695,
         -0.03779644730092265,
         -0.037796447300922666,
         -0.0377964473009227,
         -0.07559289460184533,
         -0.037796447300922686,
         -0.0377964473009227,
         -0.0377964473009227,
         0.025197631533948484,
         0.05039526306789695,
         0.050395263067896955,
         0.025197631533948484,
         0.050395263067896934,
         0.02519763153394847,
         -0.03779644730092268,
         -0.03779644730092269,
         -0.03779644730092269,
         -0.0755928946018454,
         -0.0377964473009227,
         -0.03779644730092268,
         -0.03779644730092269,
         0.025197631533948453,
         0.05039526306789696,
         0.025197631533948474,
         0.050395263067896955,
         0.05039526306789694,
         0.025197631533948505,
         -0.1259881576697424,
         -0.1259881576697423,
         -0.12598815766974233,
         0.05039526306789691,
         0.10079052613579387,
         0.10079052613579388,
         0.05039526306789694,
         0.1007905261357939,
         0.050395263067896955,
         -0.037796447300922645,
         -0.03779644730092265,
         -0.03779644730092268,
         -0.07559289460184535,
         -0.03779644730092269,
         -0.037796447300922714,
         -0.03779644730092271,
         0.05039526306789697,
         0.1007905261357939,
         0.1007905261357939,
         0.05039526306789696,
         0.10079052613579395,
         0.050395263067896975,
         -0.07559289460184536,
         -0.07559289460184535,
         -0.07559289460184541,
         -0.15118578920369077,
         -0.07559289460184541,
         -0.07559289460184537,
         -0.07559289460184536,
         0.050395263067896975,
         0.10079052613579394,
         0.05039526306789694,
         0.1007905261357939,
         0.1007905261357939,
         0.05039526306789697,
         -0.03779644730092271,
         -0.03779644730092271,
         -0.037796447300922686,
         -0.07559289460184532,
         -0.03779644730092268,
         -0.03779644730092264,
         -0.037796447300922624,
         0.050395263067896955,
         0.10079052613579388,
         0.05039526306789694,
         0.10079052613579387,
         0.10079052613579387,
         0.05039526306789692,
         -0.1259881576697424,
         -0.1259881576697424,
         -0.1259881576697424,
         0.025197631533948512,
         0.05039526306789697,
         0.050395263067896955,
         0.02519763153394846,
         0.05039526306789698,
         0.02519763153394846,
         -0.03779644730092271,
         -0.037796447300922686,
         -0.03779644730092268,
         -0.07559289460184539,
         -0.03779644730092268,
         -0.037796447300922666,
         -0.037796447300922686,
         0.025197631533948467,
         0.050395263067896975,
         0.02519763153394845,
         0.05039526306789696,
         0.050395263067896955,
         0.0251976315339485,
         -0.0377964473009227,
         -0.03779644730092271,
         -0.037796447300922686,
         -0.07559289460184532,
         -0.03779644730092268,
         -0.0377964473009226,
         -0.037796447300922596,
         0.050395263067896955,
         0.10079052613579385,
         0.050395263067896955,
         0.10079052613579387,
         0.1007905261357939,
         0.05039526306789692,
         -0.1259881576697424,
         -0.1259881576697424,
         -0.12598815766974233,
         0.025197631533948498,
         0.05039526306789696,
         0.025197631533948515,
         0.05039526306789697,
         0.050395263067896975,
         0.025197631533948484,
         -0.1259881576697423,
         -0.12598815766974228,
         -0.12598815766974222,
         0.37796447300922764},
        {0.06679750003993737,
         -0.033726846563208596,
         -0.0330706534767288,
         -0.025441565176089496,
         -0.0021585901885729647,
         -0.03919734467527468,
         -0.14426768360150188,
         0.1801531203532831,
         -0.10788512220127955,
         0.008191871983569743,
         -0.001969532457437806,
         -0.0062223395261317704,
         -0.04558188107279906,
         -0.025949678621901583,
         -0.0034578123288063617,
         0.09782960264365763,
         -0.03618354500110953,
         0.07893435033277647,
         0.024875062474333114,
         0.04614838377455536,
         0.07643935587375925,
         -0.07320614953761774,
         0.06971292276714353,
         -0.030001274915915414,
         -0.040762150898640395,
         -0.08745586542868632,
         0.04143391514381268,
         0.03783007830130384,
         -0.17288012987765963,
         0.13341574719128493,
         -0.16502348596645697,
         0.07752779753823667,
         0.055509948963248616,
         0.05407667062443612,
         -0.14708870468458393,
         0.057206489748837755,
         0.02097385660956585,
         0.02888264588484262,
         -0.19362589350790468,
         0.09122303349533482,
         -0.1928813662331388,
         0.06310986700970922,
         0.06596195371715749,
         -0.0540824487033598,
         -0.07498937202350708,
         0.035696379020646464,
         0.03929299300286056,
         0.004225946208951224,
         -0.004962384666254081,
         0.008928310440872644,
         0.08016492752105238,
         -0.07717207531223623,
         0.06202142534523183,
         0.0027250928903293672,
         0.01849052607680883,
         0.06998691791631528,
         -0.0655910359518175,
         0.07736954410941084,
         -0.0058841618358661365,
         -0.03150584725336306,
         0.12484587451791561,
         -0.021706576048042898,
         -0.03634179842993539,
         0.07702005969143987,
         -0.08904033020660565,
         0.09231147515981224,
         -0.03087130031786915,
         -0.05261863933619861,
         -0.20239595051995138,
         0.2858858901740191,
         -0.20239595051995138,
         -0.05261863933619859,
         -0.03087130031786917,
         0.09231147515981218,
         -0.08904033020660565,
         0.07702005969143991,
         -0.03634179842993541,
         -0.021706576048042908,
         0.12484587451791564,
         -0.031505847253363035,
         -0.005884161835866113,
         0.07736954410941084,
         -0.0655910359518175,
         0.06998691791631526,
         0.018490526076808806,
         0.0027250928903293534,
         0.06202142534523182,
         -0.07717207531223623,
         0.08016492752105238,
         0.008928310440872628,
         -0.004962384666254096,
         0.004225946208951227,
         0.03929299300286055,
         0.03569637902064646,
         -0.07498937202350704,
         -0.05408244870335979,
         0.0659619537171575,
         0.06310986700970922,
         -0.19288136623313892,
         0.09122303349533477,
         -0.19362589350790468,
         0.02888264588484262,
         0.02097385660956585,
         0.05720648974883779,
         -0.14708870468458393,
         0.054076670624436114,
         0.055509948963248595,
         0.07752779753823665,
         -0.16502348596645702,
         0.13341574719128488,
         -0.1728801298776597,
         0.037830078301303804,
         0.04143391514381268,
         -0.08745586542868634,
         -0.04076215089864038,
         -0.030001274915915407,
         0.06971292276714346,
         -0.0732061495376177,
         0.07643935587375923,
         0.04614838377455535,
         0.02487506247433307,
         0.07893435033277646,
         -0.03618354500110949,
         0.09782960264365764,
         -0.0034578123288064753,
         -0.025949678621901617,
         -0.045581881072799035,
         -0.006222339526131796,
         -0.0019695324574379486,
         0.008191871983569804,
         -0.10788512220127962,
         0.18015312035328315,
         -0.1442676836015017,
         -0.039197344675274776,
         -0.0021585901885730085,
         -0.025441565176089444,
         -0.03307065347672875,
         -0.033726846563208526,
         0.06679750003993727},
        {0.07401837401723489,
         -0.015123614821836552,
         -0.05889475919539844,
         0.03213607118792175,
         -0.047712787147255624,
         -0.0584416580579009,
         -0.14493398176426708,
         0.20777038373335924,
         -0.09043396648005986,
         -0.05412744433046438,
         0.10356595569975434,
         -0.04943851136929002,
         -0.01444858943729331,
         -0.05916753005358044,
         0.05372518980410303,
         0.03310525281381891,
         -0.06238006363815637,
         0.11698814439874133,
         -0.016804017523036174,
         -0.0008834642275922511,
         0.15747786936444141,
         -0.033793534640569,
         0.03939346712195868,
         -0.04564914041399318,
         -0.06594764504064059,
         -0.01935026627745265,
         0.012471773515319577,
         0.061005937092597426,
         0.019259273620563615,
         -0.1352970028356375,
         0.12372957711232987,
         0.058267264974791864,
         -0.024468409260045933,
         -0.14121320455188496,
         0.12964169611535395,
         -0.21990441375200875,
         0.08884867811750238,
         -0.020813307759062594,
         0.05060535830037634,
         -0.09206860575213202,
         0.11742047923977003,
         -0.0668700231129327,
         0.06309046739027972,
         0.0236704854094235,
         -0.01989092968677053,
         -0.08844234087791779,
         0.10833327056468836,
         -0.0917058557678633,
         0.047985558005437676,
         -0.010407146568038782,
         0.1269523437722846,
         -0.07137194607796796,
         0.03234058127671674,
         0.03238073348237012,
         0.027189051097571443,
         0.035168899547081287,
         -0.06782240388763353,
         0.10948215741600179,
         -0.01718726155509892,
         -0.05138877221265872,
         0.08792630004521035,
         -0.0027427548310290303,
         -0.011165171196946336,
         -0.1559304821341369,
         0.1435496221433294,
         -0.19127921014178143,
         0.03215287203911807,
         -0.01392472687917182,
         0.00979761242720509,
         -0.028025757587151392,
         0.009797612427205114,
         -0.013924726879171826,
         0.032152872039118076,
         -0.19127921014178154,
         0.14354962214332945,
         -0.1559304821341369,
         -0.01116517119694636,
         -0.002742754831029079,
         0.08792630004521038,
         -0.051388772212658716,
         -0.017187261555098907,
         0.10948215741600177,
         -0.06782240388763355,
         0.03516889954708129,
         0.02718905109757147,
         0.032380733482370166,
         0.03234058127671674,
         -0.07137194607796798,
         0.1269523437722846,
         -0.010407146568038754,
         0.04798555800543773,
         -0.09170585576786328,
         0.1083332705646883,
         -0.08844234087791789,
         -0.01989092968677052,
         0.0236704854094235,
         0.06309046739027971,
         -0.06687002311293264,
         0.11742047923977003,
         -0.09206860575213201,
         0.050605358300376324,
         -0.020813307759062663,
         0.08884867811750233,
         -0.21990441375200875,
         0.12964169611535398,
         -0.141213204551885,
         -0.024468409260045912,
         0.05826726497479186,
         0.12372957711232994,
         -0.1352970028356375,
         0.01925927362056362,
         0.06100593709259744,
         0.012471773515319542,
         -0.019350266277452677,
         -0.06594764504064057,
         -0.04564914041399318,
         0.039393467121958986,
         -0.03379353464056903,
         0.15747786936444133,
         -0.0008834642275921886,
         -0.01680401752303618,
         0.11698814439874146,
         -0.06238006363815635,
         0.03310525281381882,
         0.05372518980410314,
         -0.059167530053580386,
         -0.014448589437293269,
         -0.04943851136928998,
         0.10356595569975438,
         -0.054127444330464416,
         -0.09043396648005984,
         0.20777038373335938,
         -0.14493398176426714,
         -0.05844165805790094,
         -0.04771278714725559,
         0.03213607118792176,
         -0.058894759195398355,
         -0.015123614821836495,
         0.07401837401723493},
        {0.02725030107691393,
         -0.1178955954675676,
         0.09064529439065386,
         -0.016570390881338687,
         0.025928981109217555,
         -0.0366088913047927,
         0.0394995872762732,
         0.05246702708207684,
         -0.10650343016793776,
         -0.18607615265770183,
         0.09161120542279792,
         0.0944649472349038,
         0.19160753336753808,
         0.052547423443361226,
         -0.08532910523011143,
         0.027987851267584088,
         -0.054250884666175725,
         -0.04553025172927043,
         -0.11979069159527031,
         -0.05524645089092891,
         -0.003931162523732598,
         0.04524544956642417,
         0.13193899785940869,
         -0.0635562760201246,
         0.020094684037799397,
         0.025783691787234428,
         0.0639657330557663,
         0.09632672781470097,
         -0.06049111503777582,
         -0.09508582344078864,
         -0.09570585160881628,
         -0.12369114389106224,
         -0.09370008126371014,
         -0.014647941631312495,
         0.02182592902324708,
         0.06087652965587337,
         0.047151205401503964,
         0.08035957368221337,
         0.07695069801582015,
         0.16653113747051249,
         -0.017584605315873445,
         -0.05837159386077508,
         -0.1752309221994086,
         0.07477666447939599,
         0.15882585158078796,
         0.026284390044769634,
         -0.1851102416255575,
         -0.20228744356311323,
         0.012168889838074912,
         0.004042401067336541,
         0.05040815692371025,
         0.029034158661012836,
         0.061388387506554454,
         0.1104321013673916,
         0.10842573307706038,
         -0.06149740586175819,
         -0.08703256645292594,
         0.011173323613321713,
         -0.028410338338225267,
         0.03394171904806146,
         -0.03131507249707064,
         -0.022048209264223736,
         0.08061358283820821,
         -0.05910794165260646,
         -0.03673944455073742,
         0.04677115610318285,
         -0.000673121324566579,
         0.04266810401721236,
         -0.06195617055590024,
         0.01996118786325447,
         -0.061956170555900254,
         0.0426681040172124,
         -0.0006731213245665632,
         0.04677115610318287,
         -0.036739444550737355,
         -0.05910794165260648,
         0.0806135828382082,
         -0.022048209264223705,
         -0.0313150724970706,
         0.033941719048061425,
         -0.02841033833822529,
         0.011173323613321757,
         -0.08703256645292588,
         -0.06149740586175817,
         0.10842573307706033,
         0.1104321013673915,
         0.06138838750655448,
         0.029034158661012784,
         0.05040815692371024,
         0.00404240106733655,
         0.01216888983807493,
         -0.20228744356311323,
         -0.1851102416255575,
         0.02628439004476958,
         0.15882585158078794,
         0.07477666447939597,
         -0.17523092219940864,
         -0.058371593860775096,
         -0.01758460531587337,
         0.16653113747051257,
         0.07695069801582016,
         0.08035957368221334,
         0.04715120540150394,
         0.06087652965587337,
         0.021825929023247096,
         -0.014647941631312372,
         -0.09370008126371011,
         -0.12369114389106221,
         -0.09570585160881627,
         -0.09508582344078867,
         -0.06049111503777562,
         0.09632672781470102,
         0.06396573305576633,
         0.025783691787234414,
         0.020094684037799466,
         -0.06355627602012476,
         0.13193899785940877,
         0.045245449566424255,
         -0.003931162523732601,
         -0.055246450890928896,
         -0.11979069159527037,
         -0.04553025172927043,
         -0.05425088466617582,
         0.027987851267584105,
         -0.08532910523011124,
         0.052547423443361184,
         0.1916075333675379,
         0.09446494723490384,
         0.09161120542279792,
         -0.18607615265770192,
         -0.10650343016793781,
         0.052467027082076866,
         0.03949958727627318,
         -0.03660889130479276,
         0.025928981109217535,
         -0.016570390881338663,
         0.09064529439065373,
         -0.1178955954675677,
         0.027250301076913924},
        {0.06891283007243235,
         -0.06210919941805212,
         -0.006803630654380277,
         -0.3251267628271726,
         0.17903917454911583,
         0.07717475820562442,
         -0.06574459721958859,
         -0.05118537791147586,
         -0.01918574963976849,
         -0.031555440876748386,
         0.04289712584302857,
         -0.011341684966280255,
         0.11508146464822357,
         -0.11265543340446704,
         -0.03978342043944014,
         0.12131748104905442,
         0.01055002593043612,
         0.04737871012966453,
         0.0567010204664482,
         0.1533442777125006,
         -0.05994503468130384,
         -0.06313972692979312,
         -0.12759588854889173,
         0.004372150851837323,
         0.0994029280589955,
         -0.00010812323125264803,
         0.05071821285819857,
         -0.019054648750197516,
         -0.10814348315194305,
         0.014528144450715845,
         0.01586818926576181,
         -0.021578289119194575,
         -0.0933950522977763,
         -0.01218160968929112,
         0.09569711935475436,
         0.056536002132659705,
         -0.0009923882078202422,
         -0.11978290152808604,
         0.055149228644001715,
         -0.09027195999125545,
         0.030322734576531018,
         0.01697741572659328,
         0.040737151839700954,
         -0.02035717837061044,
         -0.03735738919568382,
         0.019212073575023393,
         0.018145315620660414,
         0.1411324681065167,
         -0.07318737179902886,
         -0.09950053718423611,
         0.0065363155885855544,
         0.10954818205347198,
         -0.021389329835515974,
         0.08938656781160832,
         0.09460772690904733,
         -0.05334954264822407,
         -0.14188882791347115,
         0.0696068799830356,
         0.11255782427922642,
         -0.02903180050775138,
         -0.0834179005402226,
         0.05059553557998835,
         0.10173519503266634,
         -0.05607112374014008,
         -0.056633611257900424,
         -0.051905214429146126,
         -0.03754876259101009,
         -0.13524726962350772,
         0.06346459672600775,
         0.10933143548851015,
         0.06346459672600775,
         -0.13524726962350772,
         -0.03754876259101008,
         -0.05190521442914615,
         -0.05663361125790042,
         -0.05607112374014008,
         0.10173519503266633,
         0.05059553557998839,
         -0.08341790054022262,
         -0.029031800507751344,
         0.11255782427922638,
         0.06960687998303565,
         -0.14188882791347124,
         -0.053349542648224065,
         0.09460772690904735,
         0.08938656781160831,
         -0.021389329835515974,
         0.10954818205347196,
         0.006536315588585565,
         -0.09950053718423614,
         -0.07318737179902884,
         0.14113246810651672,
         0.01814531562066039,
         0.01921207357502336,
         -0.03735738919568379,
         -0.020357178370610445,
         0.04073715183970092,
         0.0169774157265933,
         0.030322734576531042,
         -0.09027195999125542,
         0.05514922864400172,
         -0.11978290152808603,
         -0.000992388207820231,
         0.05653600213265974,
         0.09569711935475442,
         -0.012181609689291129,
         -0.09339505229777627,
         -0.021578289119194557,
         0.01586818926576182,
         0.014528144450715878,
         -0.1081434831519431,
         -0.01905464875019752,
         0.050718212858198546,
         -0.00010812323125263353,
         0.09940292805899555,
         0.004372150851837346,
         -0.1275958885488917,
         -0.06313972692979321,
         -0.059945034681303855,
         0.15334427771250062,
         0.05670102046644821,
         0.047378710129664534,
         0.01055002593043604,
         0.12131748104905439,
         -0.03978342043944019,
         -0.11265543340446706,
         0.11508146464822352,
         -0.011341684966280281,
         0.04289712584302862,
         -0.03155544087674842,
         -0.019185749639768403,
         -0.051185377911475885,
         -0.06574459721958825,
         0.07717475820562443,
         0.17903917454911591,
         -0.3251267628271727,
         -0.006803630654380258,
         -0.06210919941805207,
         0.06891283007243236}
    };

    m_array_all = {
        {
        {0, 0, 0, 0, 0, 0}
        },
        {
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1}
        },
        {
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1}
        },
        {
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1}
        },
        {
        {0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1}
        },
        {
        {-1, -1, 0, 0, 1, 1},
        {-1, -1, 0, 1, 0, 1},
        {-1, -1, 0, 1, 1, 0},
        {-1, -1, 1, -1, 1, 1},
        {-1, -1, 1, 0, 0, 1},
        {-1, -1, 1, 0, 1, 0},
        {-1, -1, 1, 1, -1, 1},
        {-1, -1, 1, 1, 0, 0},
        {-1, -1, 1, 1, 1, -1},
        {-1, 0, -1, 0, 1, 1},
        {-1, 0, -1, 1, 0, 1},
        {-1, 0, -1, 1, 1, 0},
        {-1, 0, 0, -1, 1, 1},
        {-1, 0, 0, 0, 0, 1},
        {-1, 0, 0, 0, 1, 0},
        {-1, 0, 0, 1, -1, 1},
        {-1, 0, 0, 1, 0, 0},
        {-1, 0, 0, 1, 1, -1},
        {-1, 0, 1, -1, 0, 1},
        {-1, 0, 1, -1, 1, 0},
        {-1, 0, 1, 0, -1, 1},
        {-1, 0, 1, 0, 0, 0},
        {-1, 0, 1, 0, 1, -1},
        {-1, 0, 1, 1, -1, 0},
        {-1, 0, 1, 1, 0, -1},
        {-1, 1, -1, -1, 1, 1},
        {-1, 1, -1, 0, 0, 1},
        {-1, 1, -1, 0, 1, 0},
        {-1, 1, -1, 1, -1, 1},
        {-1, 1, -1, 1, 0, 0},
        {-1, 1, -1, 1, 1, -1},
        {-1, 1, 0, -1, 0, 1},
        {-1, 1, 0, -1, 1, 0},
        {-1, 1, 0, 0, -1, 1},
        {-1, 1, 0, 0, 0, 0},
        {-1, 1, 0, 0, 1, -1},
        {-1, 1, 0, 1, -1, 0},
        {-1, 1, 0, 1, 0, -1},
        {-1, 1, 1, -1, -1, 1},
        {-1, 1, 1, -1, 0, 0},
        {-1, 1, 1, -1, 1, -1},
        {-1, 1, 1, 0, -1, 0},
        {-1, 1, 1, 0, 0, -1},
        {-1, 1, 1, 1, -1, -1},
        {0, -1, -1, 0, 1, 1},
        {0, -1, -1, 1, 0, 1},
        {0, -1, -1, 1, 1, 0},
        {0, -1, 0, -1, 1, 1},
        {0, -1, 0, 0, 0, 1},
        {0, -1, 0, 0, 1, 0},
        {0, -1, 0, 1, -1, 1},
        {0, -1, 0, 1, 0, 0},
        {0, -1, 0, 1, 1, -1},
        {0, -1, 1, -1, 0, 1},
        {0, -1, 1, -1, 1, 0},
        {0, -1, 1, 0, -1, 1},
        {0, -1, 1, 0, 0, 0},
        {0, -1, 1, 0, 1, -1},
        {0, -1, 1, 1, -1, 0},
        {0, -1, 1, 1, 0, -1},
        {0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1},
        {0, 1, -1, -1, 0, 1},
        {0, 1, -1, -1, 1, 0},
        {0, 1, -1, 0, -1, 1},
        {0, 1, -1, 0, 0, 0},
        {0, 1, -1, 0, 1, -1},
        {0, 1, -1, 1, -1, 0},
        {0, 1, -1, 1, 0, -1},
        {0, 1, 0, -1, -1, 1},
        {0, 1, 0, -1, 0, 0},
        {0, 1, 0, -1, 1, -1},
        {0, 1, 0, 0, -1, 0},
        {0, 1, 0, 0, 0, -1},
        {0, 1, 0, 1, -1, -1},
        {0, 1, 1, -1, -1, 0},
        {0, 1, 1, -1, 0, -1},
        {0, 1, 1, 0, -1, -1},
        {1, -1, -1, -1, 1, 1},
        {1, -1, -1, 0, 0, 1},
        {1, -1, -1, 0, 1, 0},
        {1, -1, -1, 1, -1, 1},
        {1, -1, -1, 1, 0, 0},
        {1, -1, -1, 1, 1, -1},
        {1, -1, 0, -1, 0, 1},
        {1, -1, 0, -1, 1, 0},
        {1, -1, 0, 0, -1, 1},
        {1, -1, 0, 0, 0, 0},
        {1, -1, 0, 0, 1, -1},
        {1, -1, 0, 1, -1, 0},
        {1, -1, 0, 1, 0, -1},
        {1, -1, 1, -1, -1, 1},
        {1, -1, 1, -1, 0, 0},
        {1, -1, 1, -1, 1, -1},
        {1, -1, 1, 0, -1, 0},
        {1, -1, 1, 0, 0, -1},
        {1, -1, 1, 1, -1, -1},
        {1, 0, -1, -1, 0, 1},
        {1, 0, -1, -1, 1, 0},
        {1, 0, -1, 0, -1, 1},
        {1, 0, -1, 0, 0, 0},
        {1, 0, -1, 0, 1, -1},
        {1, 0, -1, 1, -1, 0},
        {1, 0, -1, 1, 0, -1},
        {1, 0, 0, -1, -1, 1},
        {1, 0, 0, -1, 0, 0},
        {1, 0, 0, -1, 1, -1},
        {1, 0, 0, 0, -1, 0},
        {1, 0, 0, 0, 0, -1},
        {1, 0, 0, 1, -1, -1},
        {1, 0, 1, -1, -1, 0},
        {1, 0, 1, -1, 0, -1},
        {1, 0, 1, 0, -1, -1},
        {1, 1, -1, -1, -1, 1},
        {1, 1, -1, -1, 0, 0},
        {1, 1, -1, -1, 1, -1},
        {1, 1, -1, 0, -1, 0},
        {1, 1, -1, 0, 0, -1},
        {1, 1, -1, 1, -1, -1},
        {1, 1, 0, -1, -1, 0},
        {1, 1, 0, -1, 0, -1},
        {1, 1, 0, 0, -1, -1}
        },
        {
        {-1, -1, 0, 0, 1, 1},
        {-1, -1, 0, 1, 0, 1},
        {-1, -1, 0, 1, 1, 0},
        {-1, -1, 1, -1, 1, 1},
        {-1, -1, 1, 0, 0, 1},
        {-1, -1, 1, 0, 1, 0},
        {-1, -1, 1, 1, -1, 1},
        {-1, -1, 1, 1, 0, 0},
        {-1, -1, 1, 1, 1, -1},
        {-1, 0, -1, 0, 1, 1},
        {-1, 0, -1, 1, 0, 1},
        {-1, 0, -1, 1, 1, 0},
        {-1, 0, 0, -1, 1, 1},
        {-1, 0, 0, 0, 0, 1},
        {-1, 0, 0, 0, 1, 0},
        {-1, 0, 0, 1, -1, 1},
        {-1, 0, 0, 1, 0, 0},
        {-1, 0, 0, 1, 1, -1},
        {-1, 0, 1, -1, 0, 1},
        {-1, 0, 1, -1, 1, 0},
        {-1, 0, 1, 0, -1, 1},
        {-1, 0, 1, 0, 0, 0},
        {-1, 0, 1, 0, 1, -1},
        {-1, 0, 1, 1, -1, 0},
        {-1, 0, 1, 1, 0, -1},
        {-1, 1, -1, -1, 1, 1},
        {-1, 1, -1, 0, 0, 1},
        {-1, 1, -1, 0, 1, 0},
        {-1, 1, -1, 1, -1, 1},
        {-1, 1, -1, 1, 0, 0},
        {-1, 1, -1, 1, 1, -1},
        {-1, 1, 0, -1, 0, 1},
        {-1, 1, 0, -1, 1, 0},
        {-1, 1, 0, 0, -1, 1},
        {-1, 1, 0, 0, 0, 0},
        {-1, 1, 0, 0, 1, -1},
        {-1, 1, 0, 1, -1, 0},
        {-1, 1, 0, 1, 0, -1},
        {-1, 1, 1, -1, -1, 1},
        {-1, 1, 1, -1, 0, 0},
        {-1, 1, 1, -1, 1, -1},
        {-1, 1, 1, 0, -1, 0},
        {-1, 1, 1, 0, 0, -1},
        {-1, 1, 1, 1, -1, -1},
        {0, -1, -1, 0, 1, 1},
        {0, -1, -1, 1, 0, 1},
        {0, -1, -1, 1, 1, 0},
        {0, -1, 0, -1, 1, 1},
        {0, -1, 0, 0, 0, 1},
        {0, -1, 0, 0, 1, 0},
        {0, -1, 0, 1, -1, 1},
        {0, -1, 0, 1, 0, 0},
        {0, -1, 0, 1, 1, -1},
        {0, -1, 1, -1, 0, 1},
        {0, -1, 1, -1, 1, 0},
        {0, -1, 1, 0, -1, 1},
        {0, -1, 1, 0, 0, 0},
        {0, -1, 1, 0, 1, -1},
        {0, -1, 1, 1, -1, 0},
        {0, -1, 1, 1, 0, -1},
        {0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1},
        {0, 1, -1, -1, 0, 1},
        {0, 1, -1, -1, 1, 0},
        {0, 1, -1, 0, -1, 1},
        {0, 1, -1, 0, 0, 0},
        {0, 1, -1, 0, 1, -1},
        {0, 1, -1, 1, -1, 0},
        {0, 1, -1, 1, 0, -1},
        {0, 1, 0, -1, -1, 1},
        {0, 1, 0, -1, 0, 0},
        {0, 1, 0, -1, 1, -1},
        {0, 1, 0, 0, -1, 0},
        {0, 1, 0, 0, 0, -1},
        {0, 1, 0, 1, -1, -1},
        {0, 1, 1, -1, -1, 0},
        {0, 1, 1, -1, 0, -1},
        {0, 1, 1, 0, -1, -1},
        {1, -1, -1, -1, 1, 1},
        {1, -1, -1, 0, 0, 1},
        {1, -1, -1, 0, 1, 0},
        {1, -1, -1, 1, -1, 1},
        {1, -1, -1, 1, 0, 0},
        {1, -1, -1, 1, 1, -1},
        {1, -1, 0, -1, 0, 1},
        {1, -1, 0, -1, 1, 0},
        {1, -1, 0, 0, -1, 1},
        {1, -1, 0, 0, 0, 0},
        {1, -1, 0, 0, 1, -1},
        {1, -1, 0, 1, -1, 0},
        {1, -1, 0, 1, 0, -1},
        {1, -1, 1, -1, -1, 1},
        {1, -1, 1, -1, 0, 0},
        {1, -1, 1, -1, 1, -1},
        {1, -1, 1, 0, -1, 0},
        {1, -1, 1, 0, 0, -1},
        {1, -1, 1, 1, -1, -1},
        {1, 0, -1, -1, 0, 1},
        {1, 0, -1, -1, 1, 0},
        {1, 0, -1, 0, -1, 1},
        {1, 0, -1, 0, 0, 0},
        {1, 0, -1, 0, 1, -1},
        {1, 0, -1, 1, -1, 0},
        {1, 0, -1, 1, 0, -1},
        {1, 0, 0, -1, -1, 1},
        {1, 0, 0, -1, 0, 0},
        {1, 0, 0, -1, 1, -1},
        {1, 0, 0, 0, -1, 0},
        {1, 0, 0, 0, 0, -1},
        {1, 0, 0, 1, -1, -1},
        {1, 0, 1, -1, -1, 0},
        {1, 0, 1, -1, 0, -1},
        {1, 0, 1, 0, -1, -1},
        {1, 1, -1, -1, -1, 1},
        {1, 1, -1, -1, 0, 0},
        {1, 1, -1, -1, 1, -1},
        {1, 1, -1, 0, -1, 0},
        {1, 1, -1, 0, 0, -1},
        {1, 1, -1, 1, -1, -1},
        {1, 1, 0, -1, -1, 0},
        {1, 1, 0, -1, 0, -1},
        {1, 1, 0, 0, -1, -1}
        },
        {
        {-1, -1, 0, 0, 1, 1},
        {-1, -1, 0, 1, 0, 1},
        {-1, -1, 0, 1, 1, 0},
        {-1, -1, 1, -1, 1, 1},
        {-1, -1, 1, 0, 0, 1},
        {-1, -1, 1, 0, 1, 0},
        {-1, -1, 1, 1, -1, 1},
        {-1, -1, 1, 1, 0, 0},
        {-1, -1, 1, 1, 1, -1},
        {-1, 0, -1, 0, 1, 1},
        {-1, 0, -1, 1, 0, 1},
        {-1, 0, -1, 1, 1, 0},
        {-1, 0, 0, -1, 1, 1},
        {-1, 0, 0, 0, 0, 1},
        {-1, 0, 0, 0, 1, 0},
        {-1, 0, 0, 1, -1, 1},
        {-1, 0, 0, 1, 0, 0},
        {-1, 0, 0, 1, 1, -1},
        {-1, 0, 1, -1, 0, 1},
        {-1, 0, 1, -1, 1, 0},
        {-1, 0, 1, 0, -1, 1},
        {-1, 0, 1, 0, 0, 0},
        {-1, 0, 1, 0, 1, -1},
        {-1, 0, 1, 1, -1, 0},
        {-1, 0, 1, 1, 0, -1},
        {-1, 1, -1, -1, 1, 1},
        {-1, 1, -1, 0, 0, 1},
        {-1, 1, -1, 0, 1, 0},
        {-1, 1, -1, 1, -1, 1},
        {-1, 1, -1, 1, 0, 0},
        {-1, 1, -1, 1, 1, -1},
        {-1, 1, 0, -1, 0, 1},
        {-1, 1, 0, -1, 1, 0},
        {-1, 1, 0, 0, -1, 1},
        {-1, 1, 0, 0, 0, 0},
        {-1, 1, 0, 0, 1, -1},
        {-1, 1, 0, 1, -1, 0},
        {-1, 1, 0, 1, 0, -1},
        {-1, 1, 1, -1, -1, 1},
        {-1, 1, 1, -1, 0, 0},
        {-1, 1, 1, -1, 1, -1},
        {-1, 1, 1, 0, -1, 0},
        {-1, 1, 1, 0, 0, -1},
        {-1, 1, 1, 1, -1, -1},
        {0, -1, -1, 0, 1, 1},
        {0, -1, -1, 1, 0, 1},
        {0, -1, -1, 1, 1, 0},
        {0, -1, 0, -1, 1, 1},
        {0, -1, 0, 0, 0, 1},
        {0, -1, 0, 0, 1, 0},
        {0, -1, 0, 1, -1, 1},
        {0, -1, 0, 1, 0, 0},
        {0, -1, 0, 1, 1, -1},
        {0, -1, 1, -1, 0, 1},
        {0, -1, 1, -1, 1, 0},
        {0, -1, 1, 0, -1, 1},
        {0, -1, 1, 0, 0, 0},
        {0, -1, 1, 0, 1, -1},
        {0, -1, 1, 1, -1, 0},
        {0, -1, 1, 1, 0, -1},
        {0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1},
        {0, 1, -1, -1, 0, 1},
        {0, 1, -1, -1, 1, 0},
        {0, 1, -1, 0, -1, 1},
        {0, 1, -1, 0, 0, 0},
        {0, 1, -1, 0, 1, -1},
        {0, 1, -1, 1, -1, 0},
        {0, 1, -1, 1, 0, -1},
        {0, 1, 0, -1, -1, 1},
        {0, 1, 0, -1, 0, 0},
        {0, 1, 0, -1, 1, -1},
        {0, 1, 0, 0, -1, 0},
        {0, 1, 0, 0, 0, -1},
        {0, 1, 0, 1, -1, -1},
        {0, 1, 1, -1, -1, 0},
        {0, 1, 1, -1, 0, -1},
        {0, 1, 1, 0, -1, -1},
        {1, -1, -1, -1, 1, 1},
        {1, -1, -1, 0, 0, 1},
        {1, -1, -1, 0, 1, 0},
        {1, -1, -1, 1, -1, 1},
        {1, -1, -1, 1, 0, 0},
        {1, -1, -1, 1, 1, -1},
        {1, -1, 0, -1, 0, 1},
        {1, -1, 0, -1, 1, 0},
        {1, -1, 0, 0, -1, 1},
        {1, -1, 0, 0, 0, 0},
        {1, -1, 0, 0, 1, -1},
        {1, -1, 0, 1, -1, 0},
        {1, -1, 0, 1, 0, -1},
        {1, -1, 1, -1, -1, 1},
        {1, -1, 1, -1, 0, 0},
        {1, -1, 1, -1, 1, -1},
        {1, -1, 1, 0, -1, 0},
        {1, -1, 1, 0, 0, -1},
        {1, -1, 1, 1, -1, -1},
        {1, 0, -1, -1, 0, 1},
        {1, 0, -1, -1, 1, 0},
        {1, 0, -1, 0, -1, 1},
        {1, 0, -1, 0, 0, 0},
        {1, 0, -1, 0, 1, -1},
        {1, 0, -1, 1, -1, 0},
        {1, 0, -1, 1, 0, -1},
        {1, 0, 0, -1, -1, 1},
        {1, 0, 0, -1, 0, 0},
        {1, 0, 0, -1, 1, -1},
        {1, 0, 0, 0, -1, 0},
        {1, 0, 0, 0, 0, -1},
        {1, 0, 0, 1, -1, -1},
        {1, 0, 1, -1, -1, 0},
        {1, 0, 1, -1, 0, -1},
        {1, 0, 1, 0, -1, -1},
        {1, 1, -1, -1, -1, 1},
        {1, 1, -1, -1, 0, 0},
        {1, 1, -1, -1, 1, -1},
        {1, 1, -1, 0, -1, 0},
        {1, 1, -1, 0, 0, -1},
        {1, 1, -1, 1, -1, -1},
        {1, 1, 0, -1, -1, 0},
        {1, 1, 0, -1, 0, -1},
        {1, 1, 0, 0, -1, -1}
        },
        {
        {-1, -1, 0, 0, 1, 1},
        {-1, -1, 0, 1, 0, 1},
        {-1, -1, 0, 1, 1, 0},
        {-1, -1, 1, -1, 1, 1},
        {-1, -1, 1, 0, 0, 1},
        {-1, -1, 1, 0, 1, 0},
        {-1, -1, 1, 1, -1, 1},
        {-1, -1, 1, 1, 0, 0},
        {-1, -1, 1, 1, 1, -1},
        {-1, 0, -1, 0, 1, 1},
        {-1, 0, -1, 1, 0, 1},
        {-1, 0, -1, 1, 1, 0},
        {-1, 0, 0, -1, 1, 1},
        {-1, 0, 0, 0, 0, 1},
        {-1, 0, 0, 0, 1, 0},
        {-1, 0, 0, 1, -1, 1},
        {-1, 0, 0, 1, 0, 0},
        {-1, 0, 0, 1, 1, -1},
        {-1, 0, 1, -1, 0, 1},
        {-1, 0, 1, -1, 1, 0},
        {-1, 0, 1, 0, -1, 1},
        {-1, 0, 1, 0, 0, 0},
        {-1, 0, 1, 0, 1, -1},
        {-1, 0, 1, 1, -1, 0},
        {-1, 0, 1, 1, 0, -1},
        {-1, 1, -1, -1, 1, 1},
        {-1, 1, -1, 0, 0, 1},
        {-1, 1, -1, 0, 1, 0},
        {-1, 1, -1, 1, -1, 1},
        {-1, 1, -1, 1, 0, 0},
        {-1, 1, -1, 1, 1, -1},
        {-1, 1, 0, -1, 0, 1},
        {-1, 1, 0, -1, 1, 0},
        {-1, 1, 0, 0, -1, 1},
        {-1, 1, 0, 0, 0, 0},
        {-1, 1, 0, 0, 1, -1},
        {-1, 1, 0, 1, -1, 0},
        {-1, 1, 0, 1, 0, -1},
        {-1, 1, 1, -1, -1, 1},
        {-1, 1, 1, -1, 0, 0},
        {-1, 1, 1, -1, 1, -1},
        {-1, 1, 1, 0, -1, 0},
        {-1, 1, 1, 0, 0, -1},
        {-1, 1, 1, 1, -1, -1},
        {0, -1, -1, 0, 1, 1},
        {0, -1, -1, 1, 0, 1},
        {0, -1, -1, 1, 1, 0},
        {0, -1, 0, -1, 1, 1},
        {0, -1, 0, 0, 0, 1},
        {0, -1, 0, 0, 1, 0},
        {0, -1, 0, 1, -1, 1},
        {0, -1, 0, 1, 0, 0},
        {0, -1, 0, 1, 1, -1},
        {0, -1, 1, -1, 0, 1},
        {0, -1, 1, -1, 1, 0},
        {0, -1, 1, 0, -1, 1},
        {0, -1, 1, 0, 0, 0},
        {0, -1, 1, 0, 1, -1},
        {0, -1, 1, 1, -1, 0},
        {0, -1, 1, 1, 0, -1},
        {0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1},
        {0, 1, -1, -1, 0, 1},
        {0, 1, -1, -1, 1, 0},
        {0, 1, -1, 0, -1, 1},
        {0, 1, -1, 0, 0, 0},
        {0, 1, -1, 0, 1, -1},
        {0, 1, -1, 1, -1, 0},
        {0, 1, -1, 1, 0, -1},
        {0, 1, 0, -1, -1, 1},
        {0, 1, 0, -1, 0, 0},
        {0, 1, 0, -1, 1, -1},
        {0, 1, 0, 0, -1, 0},
        {0, 1, 0, 0, 0, -1},
        {0, 1, 0, 1, -1, -1},
        {0, 1, 1, -1, -1, 0},
        {0, 1, 1, -1, 0, -1},
        {0, 1, 1, 0, -1, -1},
        {1, -1, -1, -1, 1, 1},
        {1, -1, -1, 0, 0, 1},
        {1, -1, -1, 0, 1, 0},
        {1, -1, -1, 1, -1, 1},
        {1, -1, -1, 1, 0, 0},
        {1, -1, -1, 1, 1, -1},
        {1, -1, 0, -1, 0, 1},
        {1, -1, 0, -1, 1, 0},
        {1, -1, 0, 0, -1, 1},
        {1, -1, 0, 0, 0, 0},
        {1, -1, 0, 0, 1, -1},
        {1, -1, 0, 1, -1, 0},
        {1, -1, 0, 1, 0, -1},
        {1, -1, 1, -1, -1, 1},
        {1, -1, 1, -1, 0, 0},
        {1, -1, 1, -1, 1, -1},
        {1, -1, 1, 0, -1, 0},
        {1, -1, 1, 0, 0, -1},
        {1, -1, 1, 1, -1, -1},
        {1, 0, -1, -1, 0, 1},
        {1, 0, -1, -1, 1, 0},
        {1, 0, -1, 0, -1, 1},
        {1, 0, -1, 0, 0, 0},
        {1, 0, -1, 0, 1, -1},
        {1, 0, -1, 1, -1, 0},
        {1, 0, -1, 1, 0, -1},
        {1, 0, 0, -1, -1, 1},
        {1, 0, 0, -1, 0, 0},
        {1, 0, 0, -1, 1, -1},
        {1, 0, 0, 0, -1, 0},
        {1, 0, 0, 0, 0, -1},
        {1, 0, 0, 1, -1, -1},
        {1, 0, 1, -1, -1, 0},
        {1, 0, 1, -1, 0, -1},
        {1, 0, 1, 0, -1, -1},
        {1, 1, -1, -1, -1, 1},
        {1, 1, -1, -1, 0, 0},
        {1, 1, -1, -1, 1, -1},
        {1, 1, -1, 0, -1, 0},
        {1, 1, -1, 0, 0, -1},
        {1, 1, -1, 1, -1, -1},
        {1, 1, 0, -1, -1, 0},
        {1, 1, 0, -1, 0, -1},
        {1, 1, 0, 0, -1, -1}
        },
        {
        {-1, -1, 0, 0, 1, 1},
        {-1, -1, 0, 1, 0, 1},
        {-1, -1, 0, 1, 1, 0},
        {-1, -1, 1, -1, 1, 1},
        {-1, -1, 1, 0, 0, 1},
        {-1, -1, 1, 0, 1, 0},
        {-1, -1, 1, 1, -1, 1},
        {-1, -1, 1, 1, 0, 0},
        {-1, -1, 1, 1, 1, -1},
        {-1, 0, -1, 0, 1, 1},
        {-1, 0, -1, 1, 0, 1},
        {-1, 0, -1, 1, 1, 0},
        {-1, 0, 0, -1, 1, 1},
        {-1, 0, 0, 0, 0, 1},
        {-1, 0, 0, 0, 1, 0},
        {-1, 0, 0, 1, -1, 1},
        {-1, 0, 0, 1, 0, 0},
        {-1, 0, 0, 1, 1, -1},
        {-1, 0, 1, -1, 0, 1},
        {-1, 0, 1, -1, 1, 0},
        {-1, 0, 1, 0, -1, 1},
        {-1, 0, 1, 0, 0, 0},
        {-1, 0, 1, 0, 1, -1},
        {-1, 0, 1, 1, -1, 0},
        {-1, 0, 1, 1, 0, -1},
        {-1, 1, -1, -1, 1, 1},
        {-1, 1, -1, 0, 0, 1},
        {-1, 1, -1, 0, 1, 0},
        {-1, 1, -1, 1, -1, 1},
        {-1, 1, -1, 1, 0, 0},
        {-1, 1, -1, 1, 1, -1},
        {-1, 1, 0, -1, 0, 1},
        {-1, 1, 0, -1, 1, 0},
        {-1, 1, 0, 0, -1, 1},
        {-1, 1, 0, 0, 0, 0},
        {-1, 1, 0, 0, 1, -1},
        {-1, 1, 0, 1, -1, 0},
        {-1, 1, 0, 1, 0, -1},
        {-1, 1, 1, -1, -1, 1},
        {-1, 1, 1, -1, 0, 0},
        {-1, 1, 1, -1, 1, -1},
        {-1, 1, 1, 0, -1, 0},
        {-1, 1, 1, 0, 0, -1},
        {-1, 1, 1, 1, -1, -1},
        {0, -1, -1, 0, 1, 1},
        {0, -1, -1, 1, 0, 1},
        {0, -1, -1, 1, 1, 0},
        {0, -1, 0, -1, 1, 1},
        {0, -1, 0, 0, 0, 1},
        {0, -1, 0, 0, 1, 0},
        {0, -1, 0, 1, -1, 1},
        {0, -1, 0, 1, 0, 0},
        {0, -1, 0, 1, 1, -1},
        {0, -1, 1, -1, 0, 1},
        {0, -1, 1, -1, 1, 0},
        {0, -1, 1, 0, -1, 1},
        {0, -1, 1, 0, 0, 0},
        {0, -1, 1, 0, 1, -1},
        {0, -1, 1, 1, -1, 0},
        {0, -1, 1, 1, 0, -1},
        {0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1},
        {0, 1, -1, -1, 0, 1},
        {0, 1, -1, -1, 1, 0},
        {0, 1, -1, 0, -1, 1},
        {0, 1, -1, 0, 0, 0},
        {0, 1, -1, 0, 1, -1},
        {0, 1, -1, 1, -1, 0},
        {0, 1, -1, 1, 0, -1},
        {0, 1, 0, -1, -1, 1},
        {0, 1, 0, -1, 0, 0},
        {0, 1, 0, -1, 1, -1},
        {0, 1, 0, 0, -1, 0},
        {0, 1, 0, 0, 0, -1},
        {0, 1, 0, 1, -1, -1},
        {0, 1, 1, -1, -1, 0},
        {0, 1, 1, -1, 0, -1},
        {0, 1, 1, 0, -1, -1},
        {1, -1, -1, -1, 1, 1},
        {1, -1, -1, 0, 0, 1},
        {1, -1, -1, 0, 1, 0},
        {1, -1, -1, 1, -1, 1},
        {1, -1, -1, 1, 0, 0},
        {1, -1, -1, 1, 1, -1},
        {1, -1, 0, -1, 0, 1},
        {1, -1, 0, -1, 1, 0},
        {1, -1, 0, 0, -1, 1},
        {1, -1, 0, 0, 0, 0},
        {1, -1, 0, 0, 1, -1},
        {1, -1, 0, 1, -1, 0},
        {1, -1, 0, 1, 0, -1},
        {1, -1, 1, -1, -1, 1},
        {1, -1, 1, -1, 0, 0},
        {1, -1, 1, -1, 1, -1},
        {1, -1, 1, 0, -1, 0},
        {1, -1, 1, 0, 0, -1},
        {1, -1, 1, 1, -1, -1},
        {1, 0, -1, -1, 0, 1},
        {1, 0, -1, -1, 1, 0},
        {1, 0, -1, 0, -1, 1},
        {1, 0, -1, 0, 0, 0},
        {1, 0, -1, 0, 1, -1},
        {1, 0, -1, 1, -1, 0},
        {1, 0, -1, 1, 0, -1},
        {1, 0, 0, -1, -1, 1},
        {1, 0, 0, -1, 0, 0},
        {1, 0, 0, -1, 1, -1},
        {1, 0, 0, 0, -1, 0},
        {1, 0, 0, 0, 0, -1},
        {1, 0, 0, 1, -1, -1},
        {1, 0, 1, -1, -1, 0},
        {1, 0, 1, -1, 0, -1},
        {1, 0, 1, 0, -1, -1},
        {1, 1, -1, -1, -1, 1},
        {1, 1, -1, -1, 0, 0},
        {1, 1, -1, -1, 1, -1},
        {1, 1, -1, 0, -1, 0},
        {1, 1, -1, 0, 0, -1},
        {1, 1, -1, 1, -1, -1},
        {1, 1, 0, -1, -1, 0},
        {1, 1, 0, -1, 0, -1},
        {1, 1, 0, 0, -1, -1}
        },
        {
        {-1, -1, 0, 0, 1, 1},
        {-1, -1, 0, 1, 0, 1},
        {-1, -1, 0, 1, 1, 0},
        {-1, -1, 1, -1, 1, 1},
        {-1, -1, 1, 0, 0, 1},
        {-1, -1, 1, 0, 1, 0},
        {-1, -1, 1, 1, -1, 1},
        {-1, -1, 1, 1, 0, 0},
        {-1, -1, 1, 1, 1, -1},
        {-1, 0, -1, 0, 1, 1},
        {-1, 0, -1, 1, 0, 1},
        {-1, 0, -1, 1, 1, 0},
        {-1, 0, 0, -1, 1, 1},
        {-1, 0, 0, 0, 0, 1},
        {-1, 0, 0, 0, 1, 0},
        {-1, 0, 0, 1, -1, 1},
        {-1, 0, 0, 1, 0, 0},
        {-1, 0, 0, 1, 1, -1},
        {-1, 0, 1, -1, 0, 1},
        {-1, 0, 1, -1, 1, 0},
        {-1, 0, 1, 0, -1, 1},
        {-1, 0, 1, 0, 0, 0},
        {-1, 0, 1, 0, 1, -1},
        {-1, 0, 1, 1, -1, 0},
        {-1, 0, 1, 1, 0, -1},
        {-1, 1, -1, -1, 1, 1},
        {-1, 1, -1, 0, 0, 1},
        {-1, 1, -1, 0, 1, 0},
        {-1, 1, -1, 1, -1, 1},
        {-1, 1, -1, 1, 0, 0},
        {-1, 1, -1, 1, 1, -1},
        {-1, 1, 0, -1, 0, 1},
        {-1, 1, 0, -1, 1, 0},
        {-1, 1, 0, 0, -1, 1},
        {-1, 1, 0, 0, 0, 0},
        {-1, 1, 0, 0, 1, -1},
        {-1, 1, 0, 1, -1, 0},
        {-1, 1, 0, 1, 0, -1},
        {-1, 1, 1, -1, -1, 1},
        {-1, 1, 1, -1, 0, 0},
        {-1, 1, 1, -1, 1, -1},
        {-1, 1, 1, 0, -1, 0},
        {-1, 1, 1, 0, 0, -1},
        {-1, 1, 1, 1, -1, -1},
        {0, -1, -1, 0, 1, 1},
        {0, -1, -1, 1, 0, 1},
        {0, -1, -1, 1, 1, 0},
        {0, -1, 0, -1, 1, 1},
        {0, -1, 0, 0, 0, 1},
        {0, -1, 0, 0, 1, 0},
        {0, -1, 0, 1, -1, 1},
        {0, -1, 0, 1, 0, 0},
        {0, -1, 0, 1, 1, -1},
        {0, -1, 1, -1, 0, 1},
        {0, -1, 1, -1, 1, 0},
        {0, -1, 1, 0, -1, 1},
        {0, -1, 1, 0, 0, 0},
        {0, -1, 1, 0, 1, -1},
        {0, -1, 1, 1, -1, 0},
        {0, -1, 1, 1, 0, -1},
        {0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1},
        {0, 1, -1, -1, 0, 1},
        {0, 1, -1, -1, 1, 0},
        {0, 1, -1, 0, -1, 1},
        {0, 1, -1, 0, 0, 0},
        {0, 1, -1, 0, 1, -1},
        {0, 1, -1, 1, -1, 0},
        {0, 1, -1, 1, 0, -1},
        {0, 1, 0, -1, -1, 1},
        {0, 1, 0, -1, 0, 0},
        {0, 1, 0, -1, 1, -1},
        {0, 1, 0, 0, -1, 0},
        {0, 1, 0, 0, 0, -1},
        {0, 1, 0, 1, -1, -1},
        {0, 1, 1, -1, -1, 0},
        {0, 1, 1, -1, 0, -1},
        {0, 1, 1, 0, -1, -1},
        {1, -1, -1, -1, 1, 1},
        {1, -1, -1, 0, 0, 1},
        {1, -1, -1, 0, 1, 0},
        {1, -1, -1, 1, -1, 1},
        {1, -1, -1, 1, 0, 0},
        {1, -1, -1, 1, 1, -1},
        {1, -1, 0, -1, 0, 1},
        {1, -1, 0, -1, 1, 0},
        {1, -1, 0, 0, -1, 1},
        {1, -1, 0, 0, 0, 0},
        {1, -1, 0, 0, 1, -1},
        {1, -1, 0, 1, -1, 0},
        {1, -1, 0, 1, 0, -1},
        {1, -1, 1, -1, -1, 1},
        {1, -1, 1, -1, 0, 0},
        {1, -1, 1, -1, 1, -1},
        {1, -1, 1, 0, -1, 0},
        {1, -1, 1, 0, 0, -1},
        {1, -1, 1, 1, -1, -1},
        {1, 0, -1, -1, 0, 1},
        {1, 0, -1, -1, 1, 0},
        {1, 0, -1, 0, -1, 1},
        {1, 0, -1, 0, 0, 0},
        {1, 0, -1, 0, 1, -1},
        {1, 0, -1, 1, -1, 0},
        {1, 0, -1, 1, 0, -1},
        {1, 0, 0, -1, -1, 1},
        {1, 0, 0, -1, 0, 0},
        {1, 0, 0, -1, 1, -1},
        {1, 0, 0, 0, -1, 0},
        {1, 0, 0, 0, 0, -1},
        {1, 0, 0, 1, -1, -1},
        {1, 0, 1, -1, -1, 0},
        {1, 0, 1, -1, 0, -1},
        {1, 0, 1, 0, -1, -1},
        {1, 1, -1, -1, -1, 1},
        {1, 1, -1, -1, 0, 0},
        {1, 1, -1, -1, 1, -1},
        {1, 1, -1, 0, -1, 0},
        {1, 1, -1, 0, 0, -1},
        {1, 1, -1, 1, -1, -1},
        {1, 1, 0, -1, -1, 0},
        {1, 1, 0, -1, 0, -1},
        {1, 1, 0, 0, -1, -1}
        },
        {
        {-1, -1, 0, 0, 1, 1},
        {-1, -1, 0, 1, 0, 1},
        {-1, -1, 0, 1, 1, 0},
        {-1, -1, 1, -1, 1, 1},
        {-1, -1, 1, 0, 0, 1},
        {-1, -1, 1, 0, 1, 0},
        {-1, -1, 1, 1, -1, 1},
        {-1, -1, 1, 1, 0, 0},
        {-1, -1, 1, 1, 1, -1},
        {-1, 0, -1, 0, 1, 1},
        {-1, 0, -1, 1, 0, 1},
        {-1, 0, -1, 1, 1, 0},
        {-1, 0, 0, -1, 1, 1},
        {-1, 0, 0, 0, 0, 1},
        {-1, 0, 0, 0, 1, 0},
        {-1, 0, 0, 1, -1, 1},
        {-1, 0, 0, 1, 0, 0},
        {-1, 0, 0, 1, 1, -1},
        {-1, 0, 1, -1, 0, 1},
        {-1, 0, 1, -1, 1, 0},
        {-1, 0, 1, 0, -1, 1},
        {-1, 0, 1, 0, 0, 0},
        {-1, 0, 1, 0, 1, -1},
        {-1, 0, 1, 1, -1, 0},
        {-1, 0, 1, 1, 0, -1},
        {-1, 1, -1, -1, 1, 1},
        {-1, 1, -1, 0, 0, 1},
        {-1, 1, -1, 0, 1, 0},
        {-1, 1, -1, 1, -1, 1},
        {-1, 1, -1, 1, 0, 0},
        {-1, 1, -1, 1, 1, -1},
        {-1, 1, 0, -1, 0, 1},
        {-1, 1, 0, -1, 1, 0},
        {-1, 1, 0, 0, -1, 1},
        {-1, 1, 0, 0, 0, 0},
        {-1, 1, 0, 0, 1, -1},
        {-1, 1, 0, 1, -1, 0},
        {-1, 1, 0, 1, 0, -1},
        {-1, 1, 1, -1, -1, 1},
        {-1, 1, 1, -1, 0, 0},
        {-1, 1, 1, -1, 1, -1},
        {-1, 1, 1, 0, -1, 0},
        {-1, 1, 1, 0, 0, -1},
        {-1, 1, 1, 1, -1, -1},
        {0, -1, -1, 0, 1, 1},
        {0, -1, -1, 1, 0, 1},
        {0, -1, -1, 1, 1, 0},
        {0, -1, 0, -1, 1, 1},
        {0, -1, 0, 0, 0, 1},
        {0, -1, 0, 0, 1, 0},
        {0, -1, 0, 1, -1, 1},
        {0, -1, 0, 1, 0, 0},
        {0, -1, 0, 1, 1, -1},
        {0, -1, 1, -1, 0, 1},
        {0, -1, 1, -1, 1, 0},
        {0, -1, 1, 0, -1, 1},
        {0, -1, 1, 0, 0, 0},
        {0, -1, 1, 0, 1, -1},
        {0, -1, 1, 1, -1, 0},
        {0, -1, 1, 1, 0, -1},
        {0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1},
        {0, 1, -1, -1, 0, 1},
        {0, 1, -1, -1, 1, 0},
        {0, 1, -1, 0, -1, 1},
        {0, 1, -1, 0, 0, 0},
        {0, 1, -1, 0, 1, -1},
        {0, 1, -1, 1, -1, 0},
        {0, 1, -1, 1, 0, -1},
        {0, 1, 0, -1, -1, 1},
        {0, 1, 0, -1, 0, 0},
        {0, 1, 0, -1, 1, -1},
        {0, 1, 0, 0, -1, 0},
        {0, 1, 0, 0, 0, -1},
        {0, 1, 0, 1, -1, -1},
        {0, 1, 1, -1, -1, 0},
        {0, 1, 1, -1, 0, -1},
        {0, 1, 1, 0, -1, -1},
        {1, -1, -1, -1, 1, 1},
        {1, -1, -1, 0, 0, 1},
        {1, -1, -1, 0, 1, 0},
        {1, -1, -1, 1, -1, 1},
        {1, -1, -1, 1, 0, 0},
        {1, -1, -1, 1, 1, -1},
        {1, -1, 0, -1, 0, 1},
        {1, -1, 0, -1, 1, 0},
        {1, -1, 0, 0, -1, 1},
        {1, -1, 0, 0, 0, 0},
        {1, -1, 0, 0, 1, -1},
        {1, -1, 0, 1, -1, 0},
        {1, -1, 0, 1, 0, -1},
        {1, -1, 1, -1, -1, 1},
        {1, -1, 1, -1, 0, 0},
        {1, -1, 1, -1, 1, -1},
        {1, -1, 1, 0, -1, 0},
        {1, -1, 1, 0, 0, -1},
        {1, -1, 1, 1, -1, -1},
        {1, 0, -1, -1, 0, 1},
        {1, 0, -1, -1, 1, 0},
        {1, 0, -1, 0, -1, 1},
        {1, 0, -1, 0, 0, 0},
        {1, 0, -1, 0, 1, -1},
        {1, 0, -1, 1, -1, 0},
        {1, 0, -1, 1, 0, -1},
        {1, 0, 0, -1, -1, 1},
        {1, 0, 0, -1, 0, 0},
        {1, 0, 0, -1, 1, -1},
        {1, 0, 0, 0, -1, 0},
        {1, 0, 0, 0, 0, -1},
        {1, 0, 0, 1, -1, -1},
        {1, 0, 1, -1, -1, 0},
        {1, 0, 1, -1, 0, -1},
        {1, 0, 1, 0, -1, -1},
        {1, 1, -1, -1, -1, 1},
        {1, 1, -1, -1, 0, 0},
        {1, 1, -1, -1, 1, -1},
        {1, 1, -1, 0, -1, 0},
        {1, 1, -1, 0, 0, -1},
        {1, 1, -1, 1, -1, -1},
        {1, 1, 0, -1, -1, 0},
        {1, 1, 0, -1, 0, -1},
        {1, 1, 0, 0, -1, -1}
        },
        {
        {-1, -1, 0, 0, 1, 1},
        {-1, -1, 0, 1, 0, 1},
        {-1, -1, 0, 1, 1, 0},
        {-1, -1, 1, -1, 1, 1},
        {-1, -1, 1, 0, 0, 1},
        {-1, -1, 1, 0, 1, 0},
        {-1, -1, 1, 1, -1, 1},
        {-1, -1, 1, 1, 0, 0},
        {-1, -1, 1, 1, 1, -1},
        {-1, 0, -1, 0, 1, 1},
        {-1, 0, -1, 1, 0, 1},
        {-1, 0, -1, 1, 1, 0},
        {-1, 0, 0, -1, 1, 1},
        {-1, 0, 0, 0, 0, 1},
        {-1, 0, 0, 0, 1, 0},
        {-1, 0, 0, 1, -1, 1},
        {-1, 0, 0, 1, 0, 0},
        {-1, 0, 0, 1, 1, -1},
        {-1, 0, 1, -1, 0, 1},
        {-1, 0, 1, -1, 1, 0},
        {-1, 0, 1, 0, -1, 1},
        {-1, 0, 1, 0, 0, 0},
        {-1, 0, 1, 0, 1, -1},
        {-1, 0, 1, 1, -1, 0},
        {-1, 0, 1, 1, 0, -1},
        {-1, 1, -1, -1, 1, 1},
        {-1, 1, -1, 0, 0, 1},
        {-1, 1, -1, 0, 1, 0},
        {-1, 1, -1, 1, -1, 1},
        {-1, 1, -1, 1, 0, 0},
        {-1, 1, -1, 1, 1, -1},
        {-1, 1, 0, -1, 0, 1},
        {-1, 1, 0, -1, 1, 0},
        {-1, 1, 0, 0, -1, 1},
        {-1, 1, 0, 0, 0, 0},
        {-1, 1, 0, 0, 1, -1},
        {-1, 1, 0, 1, -1, 0},
        {-1, 1, 0, 1, 0, -1},
        {-1, 1, 1, -1, -1, 1},
        {-1, 1, 1, -1, 0, 0},
        {-1, 1, 1, -1, 1, -1},
        {-1, 1, 1, 0, -1, 0},
        {-1, 1, 1, 0, 0, -1},
        {-1, 1, 1, 1, -1, -1},
        {0, -1, -1, 0, 1, 1},
        {0, -1, -1, 1, 0, 1},
        {0, -1, -1, 1, 1, 0},
        {0, -1, 0, -1, 1, 1},
        {0, -1, 0, 0, 0, 1},
        {0, -1, 0, 0, 1, 0},
        {0, -1, 0, 1, -1, 1},
        {0, -1, 0, 1, 0, 0},
        {0, -1, 0, 1, 1, -1},
        {0, -1, 1, -1, 0, 1},
        {0, -1, 1, -1, 1, 0},
        {0, -1, 1, 0, -1, 1},
        {0, -1, 1, 0, 0, 0},
        {0, -1, 1, 0, 1, -1},
        {0, -1, 1, 1, -1, 0},
        {0, -1, 1, 1, 0, -1},
        {0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1},
        {0, 1, -1, -1, 0, 1},
        {0, 1, -1, -1, 1, 0},
        {0, 1, -1, 0, -1, 1},
        {0, 1, -1, 0, 0, 0},
        {0, 1, -1, 0, 1, -1},
        {0, 1, -1, 1, -1, 0},
        {0, 1, -1, 1, 0, -1},
        {0, 1, 0, -1, -1, 1},
        {0, 1, 0, -1, 0, 0},
        {0, 1, 0, -1, 1, -1},
        {0, 1, 0, 0, -1, 0},
        {0, 1, 0, 0, 0, -1},
        {0, 1, 0, 1, -1, -1},
        {0, 1, 1, -1, -1, 0},
        {0, 1, 1, -1, 0, -1},
        {0, 1, 1, 0, -1, -1},
        {1, -1, -1, -1, 1, 1},
        {1, -1, -1, 0, 0, 1},
        {1, -1, -1, 0, 1, 0},
        {1, -1, -1, 1, -1, 1},
        {1, -1, -1, 1, 0, 0},
        {1, -1, -1, 1, 1, -1},
        {1, -1, 0, -1, 0, 1},
        {1, -1, 0, -1, 1, 0},
        {1, -1, 0, 0, -1, 1},
        {1, -1, 0, 0, 0, 0},
        {1, -1, 0, 0, 1, -1},
        {1, -1, 0, 1, -1, 0},
        {1, -1, 0, 1, 0, -1},
        {1, -1, 1, -1, -1, 1},
        {1, -1, 1, -1, 0, 0},
        {1, -1, 1, -1, 1, -1},
        {1, -1, 1, 0, -1, 0},
        {1, -1, 1, 0, 0, -1},
        {1, -1, 1, 1, -1, -1},
        {1, 0, -1, -1, 0, 1},
        {1, 0, -1, -1, 1, 0},
        {1, 0, -1, 0, -1, 1},
        {1, 0, -1, 0, 0, 0},
        {1, 0, -1, 0, 1, -1},
        {1, 0, -1, 1, -1, 0},
        {1, 0, -1, 1, 0, -1},
        {1, 0, 0, -1, -1, 1},
        {1, 0, 0, -1, 0, 0},
        {1, 0, 0, -1, 1, -1},
        {1, 0, 0, 0, -1, 0},
        {1, 0, 0, 0, 0, -1},
        {1, 0, 0, 1, -1, -1},
        {1, 0, 1, -1, -1, 0},
        {1, 0, 1, -1, 0, -1},
        {1, 0, 1, 0, -1, -1},
        {1, 1, -1, -1, -1, 1},
        {1, 1, -1, -1, 0, 0},
        {1, 1, -1, -1, 1, -1},
        {1, 1, -1, 0, -1, 0},
        {1, 1, -1, 0, 0, -1},
        {1, 1, -1, 1, -1, -1},
        {1, 1, 0, -1, -1, 0},
        {1, 1, 0, -1, 0, -1},
        {1, 1, 0, 0, -1, -1}
        },
        {
        {-1, -1, 0, 0, 1, 1},
        {-1, -1, 0, 1, 0, 1},
        {-1, -1, 0, 1, 1, 0},
        {-1, -1, 1, -1, 1, 1},
        {-1, -1, 1, 0, 0, 1},
        {-1, -1, 1, 0, 1, 0},
        {-1, -1, 1, 1, -1, 1},
        {-1, -1, 1, 1, 0, 0},
        {-1, -1, 1, 1, 1, -1},
        {-1, 0, -1, 0, 1, 1},
        {-1, 0, -1, 1, 0, 1},
        {-1, 0, -1, 1, 1, 0},
        {-1, 0, 0, -1, 1, 1},
        {-1, 0, 0, 0, 0, 1},
        {-1, 0, 0, 0, 1, 0},
        {-1, 0, 0, 1, -1, 1},
        {-1, 0, 0, 1, 0, 0},
        {-1, 0, 0, 1, 1, -1},
        {-1, 0, 1, -1, 0, 1},
        {-1, 0, 1, -1, 1, 0},
        {-1, 0, 1, 0, -1, 1},
        {-1, 0, 1, 0, 0, 0},
        {-1, 0, 1, 0, 1, -1},
        {-1, 0, 1, 1, -1, 0},
        {-1, 0, 1, 1, 0, -1},
        {-1, 1, -1, -1, 1, 1},
        {-1, 1, -1, 0, 0, 1},
        {-1, 1, -1, 0, 1, 0},
        {-1, 1, -1, 1, -1, 1},
        {-1, 1, -1, 1, 0, 0},
        {-1, 1, -1, 1, 1, -1},
        {-1, 1, 0, -1, 0, 1},
        {-1, 1, 0, -1, 1, 0},
        {-1, 1, 0, 0, -1, 1},
        {-1, 1, 0, 0, 0, 0},
        {-1, 1, 0, 0, 1, -1},
        {-1, 1, 0, 1, -1, 0},
        {-1, 1, 0, 1, 0, -1},
        {-1, 1, 1, -1, -1, 1},
        {-1, 1, 1, -1, 0, 0},
        {-1, 1, 1, -1, 1, -1},
        {-1, 1, 1, 0, -1, 0},
        {-1, 1, 1, 0, 0, -1},
        {-1, 1, 1, 1, -1, -1},
        {0, -1, -1, 0, 1, 1},
        {0, -1, -1, 1, 0, 1},
        {0, -1, -1, 1, 1, 0},
        {0, -1, 0, -1, 1, 1},
        {0, -1, 0, 0, 0, 1},
        {0, -1, 0, 0, 1, 0},
        {0, -1, 0, 1, -1, 1},
        {0, -1, 0, 1, 0, 0},
        {0, -1, 0, 1, 1, -1},
        {0, -1, 1, -1, 0, 1},
        {0, -1, 1, -1, 1, 0},
        {0, -1, 1, 0, -1, 1},
        {0, -1, 1, 0, 0, 0},
        {0, -1, 1, 0, 1, -1},
        {0, -1, 1, 1, -1, 0},
        {0, -1, 1, 1, 0, -1},
        {0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1},
        {0, 1, -1, -1, 0, 1},
        {0, 1, -1, -1, 1, 0},
        {0, 1, -1, 0, -1, 1},
        {0, 1, -1, 0, 0, 0},
        {0, 1, -1, 0, 1, -1},
        {0, 1, -1, 1, -1, 0},
        {0, 1, -1, 1, 0, -1},
        {0, 1, 0, -1, -1, 1},
        {0, 1, 0, -1, 0, 0},
        {0, 1, 0, -1, 1, -1},
        {0, 1, 0, 0, -1, 0},
        {0, 1, 0, 0, 0, -1},
        {0, 1, 0, 1, -1, -1},
        {0, 1, 1, -1, -1, 0},
        {0, 1, 1, -1, 0, -1},
        {0, 1, 1, 0, -1, -1},
        {1, -1, -1, -1, 1, 1},
        {1, -1, -1, 0, 0, 1},
        {1, -1, -1, 0, 1, 0},
        {1, -1, -1, 1, -1, 1},
        {1, -1, -1, 1, 0, 0},
        {1, -1, -1, 1, 1, -1},
        {1, -1, 0, -1, 0, 1},
        {1, -1, 0, -1, 1, 0},
        {1, -1, 0, 0, -1, 1},
        {1, -1, 0, 0, 0, 0},
        {1, -1, 0, 0, 1, -1},
        {1, -1, 0, 1, -1, 0},
        {1, -1, 0, 1, 0, -1},
        {1, -1, 1, -1, -1, 1},
        {1, -1, 1, -1, 0, 0},
        {1, -1, 1, -1, 1, -1},
        {1, -1, 1, 0, -1, 0},
        {1, -1, 1, 0, 0, -1},
        {1, -1, 1, 1, -1, -1},
        {1, 0, -1, -1, 0, 1},
        {1, 0, -1, -1, 1, 0},
        {1, 0, -1, 0, -1, 1},
        {1, 0, -1, 0, 0, 0},
        {1, 0, -1, 0, 1, -1},
        {1, 0, -1, 1, -1, 0},
        {1, 0, -1, 1, 0, -1},
        {1, 0, 0, -1, -1, 1},
        {1, 0, 0, -1, 0, 0},
        {1, 0, 0, -1, 1, -1},
        {1, 0, 0, 0, -1, 0},
        {1, 0, 0, 0, 0, -1},
        {1, 0, 0, 1, -1, -1},
        {1, 0, 1, -1, -1, 0},
        {1, 0, 1, -1, 0, -1},
        {1, 0, 1, 0, -1, -1},
        {1, 1, -1, -1, -1, 1},
        {1, 1, -1, -1, 0, 0},
        {1, 1, -1, -1, 1, -1},
        {1, 1, -1, 0, -1, 0},
        {1, 1, -1, 0, 0, -1},
        {1, 1, -1, 1, -1, -1},
        {1, 1, 0, -1, -1, 0},
        {1, 1, 0, -1, 0, -1},
        {1, 1, 0, 0, -1, -1}
        },
        {
        {-1, -1, 0, 0, 1, 1},
        {-1, -1, 0, 1, 0, 1},
        {-1, -1, 0, 1, 1, 0},
        {-1, -1, 1, -1, 1, 1},
        {-1, -1, 1, 0, 0, 1},
        {-1, -1, 1, 0, 1, 0},
        {-1, -1, 1, 1, -1, 1},
        {-1, -1, 1, 1, 0, 0},
        {-1, -1, 1, 1, 1, -1},
        {-1, 0, -1, 0, 1, 1},
        {-1, 0, -1, 1, 0, 1},
        {-1, 0, -1, 1, 1, 0},
        {-1, 0, 0, -1, 1, 1},
        {-1, 0, 0, 0, 0, 1},
        {-1, 0, 0, 0, 1, 0},
        {-1, 0, 0, 1, -1, 1},
        {-1, 0, 0, 1, 0, 0},
        {-1, 0, 0, 1, 1, -1},
        {-1, 0, 1, -1, 0, 1},
        {-1, 0, 1, -1, 1, 0},
        {-1, 0, 1, 0, -1, 1},
        {-1, 0, 1, 0, 0, 0},
        {-1, 0, 1, 0, 1, -1},
        {-1, 0, 1, 1, -1, 0},
        {-1, 0, 1, 1, 0, -1},
        {-1, 1, -1, -1, 1, 1},
        {-1, 1, -1, 0, 0, 1},
        {-1, 1, -1, 0, 1, 0},
        {-1, 1, -1, 1, -1, 1},
        {-1, 1, -1, 1, 0, 0},
        {-1, 1, -1, 1, 1, -1},
        {-1, 1, 0, -1, 0, 1},
        {-1, 1, 0, -1, 1, 0},
        {-1, 1, 0, 0, -1, 1},
        {-1, 1, 0, 0, 0, 0},
        {-1, 1, 0, 0, 1, -1},
        {-1, 1, 0, 1, -1, 0},
        {-1, 1, 0, 1, 0, -1},
        {-1, 1, 1, -1, -1, 1},
        {-1, 1, 1, -1, 0, 0},
        {-1, 1, 1, -1, 1, -1},
        {-1, 1, 1, 0, -1, 0},
        {-1, 1, 1, 0, 0, -1},
        {-1, 1, 1, 1, -1, -1},
        {0, -1, -1, 0, 1, 1},
        {0, -1, -1, 1, 0, 1},
        {0, -1, -1, 1, 1, 0},
        {0, -1, 0, -1, 1, 1},
        {0, -1, 0, 0, 0, 1},
        {0, -1, 0, 0, 1, 0},
        {0, -1, 0, 1, -1, 1},
        {0, -1, 0, 1, 0, 0},
        {0, -1, 0, 1, 1, -1},
        {0, -1, 1, -1, 0, 1},
        {0, -1, 1, -1, 1, 0},
        {0, -1, 1, 0, -1, 1},
        {0, -1, 1, 0, 0, 0},
        {0, -1, 1, 0, 1, -1},
        {0, -1, 1, 1, -1, 0},
        {0, -1, 1, 1, 0, -1},
        {0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1},
        {0, 1, -1, -1, 0, 1},
        {0, 1, -1, -1, 1, 0},
        {0, 1, -1, 0, -1, 1},
        {0, 1, -1, 0, 0, 0},
        {0, 1, -1, 0, 1, -1},
        {0, 1, -1, 1, -1, 0},
        {0, 1, -1, 1, 0, -1},
        {0, 1, 0, -1, -1, 1},
        {0, 1, 0, -1, 0, 0},
        {0, 1, 0, -1, 1, -1},
        {0, 1, 0, 0, -1, 0},
        {0, 1, 0, 0, 0, -1},
        {0, 1, 0, 1, -1, -1},
        {0, 1, 1, -1, -1, 0},
        {0, 1, 1, -1, 0, -1},
        {0, 1, 1, 0, -1, -1},
        {1, -1, -1, -1, 1, 1},
        {1, -1, -1, 0, 0, 1},
        {1, -1, -1, 0, 1, 0},
        {1, -1, -1, 1, -1, 1},
        {1, -1, -1, 1, 0, 0},
        {1, -1, -1, 1, 1, -1},
        {1, -1, 0, -1, 0, 1},
        {1, -1, 0, -1, 1, 0},
        {1, -1, 0, 0, -1, 1},
        {1, -1, 0, 0, 0, 0},
        {1, -1, 0, 0, 1, -1},
        {1, -1, 0, 1, -1, 0},
        {1, -1, 0, 1, 0, -1},
        {1, -1, 1, -1, -1, 1},
        {1, -1, 1, -1, 0, 0},
        {1, -1, 1, -1, 1, -1},
        {1, -1, 1, 0, -1, 0},
        {1, -1, 1, 0, 0, -1},
        {1, -1, 1, 1, -1, -1},
        {1, 0, -1, -1, 0, 1},
        {1, 0, -1, -1, 1, 0},
        {1, 0, -1, 0, -1, 1},
        {1, 0, -1, 0, 0, 0},
        {1, 0, -1, 0, 1, -1},
        {1, 0, -1, 1, -1, 0},
        {1, 0, -1, 1, 0, -1},
        {1, 0, 0, -1, -1, 1},
        {1, 0, 0, -1, 0, 0},
        {1, 0, 0, -1, 1, -1},
        {1, 0, 0, 0, -1, 0},
        {1, 0, 0, 0, 0, -1},
        {1, 0, 0, 1, -1, -1},
        {1, 0, 1, -1, -1, 0},
        {1, 0, 1, -1, 0, -1},
        {1, 0, 1, 0, -1, -1},
        {1, 1, -1, -1, -1, 1},
        {1, 1, -1, -1, 0, 0},
        {1, 1, -1, -1, 1, -1},
        {1, 1, -1, 0, -1, 0},
        {1, 1, -1, 0, 0, -1},
        {1, 1, -1, 1, -1, -1},
        {1, 1, 0, -1, -1, 0},
        {1, 1, 0, -1, 0, -1},
        {1, 1, 0, 0, -1, -1}
        },
        {
        {-1, -1, -1, 1, 1, 1},
        {-1, -1, 0, 0, 1, 1},
        {-1, -1, 0, 1, 0, 1},
        {-1, -1, 0, 1, 1, 0},
        {-1, -1, 1, -1, 1, 1},
        {-1, -1, 1, 0, 0, 1},
        {-1, -1, 1, 0, 1, 0},
        {-1, -1, 1, 1, -1, 1},
        {-1, -1, 1, 1, 0, 0},
        {-1, -1, 1, 1, 1, -1},
        {-1, 0, -1, 0, 1, 1},
        {-1, 0, -1, 1, 0, 1},
        {-1, 0, -1, 1, 1, 0},
        {-1, 0, 0, -1, 1, 1},
        {-1, 0, 0, 0, 0, 1},
        {-1, 0, 0, 0, 1, 0},
        {-1, 0, 0, 1, -1, 1},
        {-1, 0, 0, 1, 0, 0},
        {-1, 0, 0, 1, 1, -1},
        {-1, 0, 1, -1, 0, 1},
        {-1, 0, 1, -1, 1, 0},
        {-1, 0, 1, 0, -1, 1},
        {-1, 0, 1, 0, 0, 0},
        {-1, 0, 1, 0, 1, -1},
        {-1, 0, 1, 1, -1, 0},
        {-1, 0, 1, 1, 0, -1},
        {-1, 1, -1, -1, 1, 1},
        {-1, 1, -1, 0, 0, 1},
        {-1, 1, -1, 0, 1, 0},
        {-1, 1, -1, 1, -1, 1},
        {-1, 1, -1, 1, 0, 0},
        {-1, 1, -1, 1, 1, -1},
        {-1, 1, 0, -1, 0, 1},
        {-1, 1, 0, -1, 1, 0},
        {-1, 1, 0, 0, -1, 1},
        {-1, 1, 0, 0, 0, 0},
        {-1, 1, 0, 0, 1, -1},
        {-1, 1, 0, 1, -1, 0},
        {-1, 1, 0, 1, 0, -1},
        {-1, 1, 1, -1, -1, 1},
        {-1, 1, 1, -1, 0, 0},
        {-1, 1, 1, -1, 1, -1},
        {-1, 1, 1, 0, -1, 0},
        {-1, 1, 1, 0, 0, -1},
        {-1, 1, 1, 1, -1, -1},
        {0, -1, -1, 0, 1, 1},
        {0, -1, -1, 1, 0, 1},
        {0, -1, -1, 1, 1, 0},
        {0, -1, 0, -1, 1, 1},
        {0, -1, 0, 0, 0, 1},
        {0, -1, 0, 0, 1, 0},
        {0, -1, 0, 1, -1, 1},
        {0, -1, 0, 1, 0, 0},
        {0, -1, 0, 1, 1, -1},
        {0, -1, 1, -1, 0, 1},
        {0, -1, 1, -1, 1, 0},
        {0, -1, 1, 0, -1, 1},
        {0, -1, 1, 0, 0, 0},
        {0, -1, 1, 0, 1, -1},
        {0, -1, 1, 1, -1, 0},
        {0, -1, 1, 1, 0, -1},
        {0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1},
        {0, 1, -1, -1, 0, 1},
        {0, 1, -1, -1, 1, 0},
        {0, 1, -1, 0, -1, 1},
        {0, 1, -1, 0, 0, 0},
        {0, 1, -1, 0, 1, -1},
        {0, 1, -1, 1, -1, 0},
        {0, 1, -1, 1, 0, -1},
        {0, 1, 0, -1, -1, 1},
        {0, 1, 0, -1, 0, 0},
        {0, 1, 0, -1, 1, -1},
        {0, 1, 0, 0, -1, 0},
        {0, 1, 0, 0, 0, -1},
        {0, 1, 0, 1, -1, -1},
        {0, 1, 1, -1, -1, 0},
        {0, 1, 1, -1, 0, -1},
        {0, 1, 1, 0, -1, -1},
        {1, -1, -1, -1, 1, 1},
        {1, -1, -1, 0, 0, 1},
        {1, -1, -1, 0, 1, 0},
        {1, -1, -1, 1, -1, 1},
        {1, -1, -1, 1, 0, 0},
        {1, -1, -1, 1, 1, -1},
        {1, -1, 0, -1, 0, 1},
        {1, -1, 0, -1, 1, 0},
        {1, -1, 0, 0, -1, 1},
        {1, -1, 0, 0, 0, 0},
        {1, -1, 0, 0, 1, -1},
        {1, -1, 0, 1, -1, 0},
        {1, -1, 0, 1, 0, -1},
        {1, -1, 1, -1, -1, 1},
        {1, -1, 1, -1, 0, 0},
        {1, -1, 1, -1, 1, -1},
        {1, -1, 1, 0, -1, 0},
        {1, -1, 1, 0, 0, -1},
        {1, -1, 1, 1, -1, -1},
        {1, 0, -1, -1, 0, 1},
        {1, 0, -1, -1, 1, 0},
        {1, 0, -1, 0, -1, 1},
        {1, 0, -1, 0, 0, 0},
        {1, 0, -1, 0, 1, -1},
        {1, 0, -1, 1, -1, 0},
        {1, 0, -1, 1, 0, -1},
        {1, 0, 0, -1, -1, 1},
        {1, 0, 0, -1, 0, 0},
        {1, 0, 0, -1, 1, -1},
        {1, 0, 0, 0, -1, 0},
        {1, 0, 0, 0, 0, -1},
        {1, 0, 0, 1, -1, -1},
        {1, 0, 1, -1, -1, 0},
        {1, 0, 1, -1, 0, -1},
        {1, 0, 1, 0, -1, -1},
        {1, 1, -1, -1, -1, 1},
        {1, 1, -1, -1, 0, 0},
        {1, 1, -1, -1, 1, -1},
        {1, 1, -1, 0, -1, 0},
        {1, 1, -1, 0, 0, -1},
        {1, 1, -1, 1, -1, -1},
        {1, 1, 0, -1, -1, 0},
        {1, 1, 0, -1, 0, -1},
        {1, 1, 0, 0, -1, -1},
        {1, 1, 1, -1, -1, -1}
        },
        {
        {-1, -1, 0, 0, 1, 1},
        {-1, -1, 0, 1, 0, 1},
        {-1, -1, 0, 1, 1, 0},
        {-1, -1, 1, -1, 1, 1},
        {-1, -1, 1, 0, 0, 1},
        {-1, -1, 1, 0, 1, 0},
        {-1, -1, 1, 1, -1, 1},
        {-1, -1, 1, 1, 0, 0},
        {-1, -1, 1, 1, 1, -1},
        {-1, 0, -1, 0, 1, 1},
        {-1, 0, -1, 1, 0, 1},
        {-1, 0, -1, 1, 1, 0},
        {-1, 0, 0, -1, 1, 1},
        {-1, 0, 0, 0, 0, 1},
        {-1, 0, 0, 0, 1, 0},
        {-1, 0, 0, 1, -1, 1},
        {-1, 0, 0, 1, 0, 0},
        {-1, 0, 0, 1, 1, -1},
        {-1, 0, 1, -1, 0, 1},
        {-1, 0, 1, -1, 1, 0},
        {-1, 0, 1, 0, -1, 1},
        {-1, 0, 1, 0, 0, 0},
        {-1, 0, 1, 0, 1, -1},
        {-1, 0, 1, 1, -1, 0},
        {-1, 0, 1, 1, 0, -1},
        {-1, 1, -1, -1, 1, 1},
        {-1, 1, -1, 0, 0, 1},
        {-1, 1, -1, 0, 1, 0},
        {-1, 1, -1, 1, -1, 1},
        {-1, 1, -1, 1, 0, 0},
        {-1, 1, -1, 1, 1, -1},
        {-1, 1, 0, -1, 0, 1},
        {-1, 1, 0, -1, 1, 0},
        {-1, 1, 0, 0, -1, 1},
        {-1, 1, 0, 0, 0, 0},
        {-1, 1, 0, 0, 1, -1},
        {-1, 1, 0, 1, -1, 0},
        {-1, 1, 0, 1, 0, -1},
        {-1, 1, 1, -1, -1, 1},
        {-1, 1, 1, -1, 0, 0},
        {-1, 1, 1, -1, 1, -1},
        {-1, 1, 1, 0, -1, 0},
        {-1, 1, 1, 0, 0, -1},
        {-1, 1, 1, 1, -1, -1},
        {0, -1, -1, 0, 1, 1},
        {0, -1, -1, 1, 0, 1},
        {0, -1, -1, 1, 1, 0},
        {0, -1, 0, -1, 1, 1},
        {0, -1, 0, 0, 0, 1},
        {0, -1, 0, 0, 1, 0},
        {0, -1, 0, 1, -1, 1},
        {0, -1, 0, 1, 0, 0},
        {0, -1, 0, 1, 1, -1},
        {0, -1, 1, -1, 0, 1},
        {0, -1, 1, -1, 1, 0},
        {0, -1, 1, 0, -1, 1},
        {0, -1, 1, 0, 0, 0},
        {0, -1, 1, 0, 1, -1},
        {0, -1, 1, 1, -1, 0},
        {0, -1, 1, 1, 0, -1},
        {0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1},
        {0, 1, -1, -1, 0, 1},
        {0, 1, -1, -1, 1, 0},
        {0, 1, -1, 0, -1, 1},
        {0, 1, -1, 0, 0, 0},
        {0, 1, -1, 0, 1, -1},
        {0, 1, -1, 1, -1, 0},
        {0, 1, -1, 1, 0, -1},
        {0, 1, 0, -1, -1, 1},
        {0, 1, 0, -1, 0, 0},
        {0, 1, 0, -1, 1, -1},
        {0, 1, 0, 0, -1, 0},
        {0, 1, 0, 0, 0, -1},
        {0, 1, 0, 1, -1, -1},
        {0, 1, 1, -1, -1, 0},
        {0, 1, 1, -1, 0, -1},
        {0, 1, 1, 0, -1, -1},
        {1, -1, -1, -1, 1, 1},
        {1, -1, -1, 0, 0, 1},
        {1, -1, -1, 0, 1, 0},
        {1, -1, -1, 1, -1, 1},
        {1, -1, -1, 1, 0, 0},
        {1, -1, -1, 1, 1, -1},
        {1, -1, 0, -1, 0, 1},
        {1, -1, 0, -1, 1, 0},
        {1, -1, 0, 0, -1, 1},
        {1, -1, 0, 0, 0, 0},
        {1, -1, 0, 0, 1, -1},
        {1, -1, 0, 1, -1, 0},
        {1, -1, 0, 1, 0, -1},
        {1, -1, 1, -1, -1, 1},
        {1, -1, 1, -1, 0, 0},
        {1, -1, 1, -1, 1, -1},
        {1, -1, 1, 0, -1, 0},
        {1, -1, 1, 0, 0, -1},
        {1, -1, 1, 1, -1, -1},
        {1, 0, -1, -1, 0, 1},
        {1, 0, -1, -1, 1, 0},
        {1, 0, -1, 0, -1, 1},
        {1, 0, -1, 0, 0, 0},
        {1, 0, -1, 0, 1, -1},
        {1, 0, -1, 1, -1, 0},
        {1, 0, -1, 1, 0, -1},
        {1, 0, 0, -1, -1, 1},
        {1, 0, 0, -1, 0, 0},
        {1, 0, 0, -1, 1, -1},
        {1, 0, 0, 0, -1, 0},
        {1, 0, 0, 0, 0, -1},
        {1, 0, 0, 1, -1, -1},
        {1, 0, 1, -1, -1, 0},
        {1, 0, 1, -1, 0, -1},
        {1, 0, 1, 0, -1, -1},
        {1, 1, -1, -1, -1, 1},
        {1, 1, -1, -1, 0, 0},
        {1, 1, -1, -1, 1, -1},
        {1, 1, -1, 0, -1, 0},
        {1, 1, -1, 0, 0, -1},
        {1, 1, -1, 1, -1, -1},
        {1, 1, 0, -1, -1, 0},
        {1, 1, 0, -1, 0, -1},
        {1, 1, 0, 0, -1, -1}
        },
        {
        {-1, -1, 0, 0, 1, 1},
        {-1, -1, 0, 1, 0, 1},
        {-1, -1, 0, 1, 1, 0},
        {-1, -1, 1, -1, 1, 1},
        {-1, -1, 1, 0, 0, 1},
        {-1, -1, 1, 0, 1, 0},
        {-1, -1, 1, 1, -1, 1},
        {-1, -1, 1, 1, 0, 0},
        {-1, -1, 1, 1, 1, -1},
        {-1, 0, -1, 0, 1, 1},
        {-1, 0, -1, 1, 0, 1},
        {-1, 0, -1, 1, 1, 0},
        {-1, 0, 0, -1, 1, 1},
        {-1, 0, 0, 0, 0, 1},
        {-1, 0, 0, 0, 1, 0},
        {-1, 0, 0, 1, -1, 1},
        {-1, 0, 0, 1, 0, 0},
        {-1, 0, 0, 1, 1, -1},
        {-1, 0, 1, -1, 0, 1},
        {-1, 0, 1, -1, 1, 0},
        {-1, 0, 1, 0, -1, 1},
        {-1, 0, 1, 0, 0, 0},
        {-1, 0, 1, 0, 1, -1},
        {-1, 0, 1, 1, -1, 0},
        {-1, 0, 1, 1, 0, -1},
        {-1, 1, -1, -1, 1, 1},
        {-1, 1, -1, 0, 0, 1},
        {-1, 1, -1, 0, 1, 0},
        {-1, 1, -1, 1, -1, 1},
        {-1, 1, -1, 1, 0, 0},
        {-1, 1, -1, 1, 1, -1},
        {-1, 1, 0, -1, 0, 1},
        {-1, 1, 0, -1, 1, 0},
        {-1, 1, 0, 0, -1, 1},
        {-1, 1, 0, 0, 0, 0},
        {-1, 1, 0, 0, 1, -1},
        {-1, 1, 0, 1, -1, 0},
        {-1, 1, 0, 1, 0, -1},
        {-1, 1, 1, -1, -1, 1},
        {-1, 1, 1, -1, 0, 0},
        {-1, 1, 1, -1, 1, -1},
        {-1, 1, 1, 0, -1, 0},
        {-1, 1, 1, 0, 0, -1},
        {-1, 1, 1, 1, -1, -1},
        {0, -1, -1, 0, 1, 1},
        {0, -1, -1, 1, 0, 1},
        {0, -1, -1, 1, 1, 0},
        {0, -1, 0, -1, 1, 1},
        {0, -1, 0, 0, 0, 1},
        {0, -1, 0, 0, 1, 0},
        {0, -1, 0, 1, -1, 1},
        {0, -1, 0, 1, 0, 0},
        {0, -1, 0, 1, 1, -1},
        {0, -1, 1, -1, 0, 1},
        {0, -1, 1, -1, 1, 0},
        {0, -1, 1, 0, -1, 1},
        {0, -1, 1, 0, 0, 0},
        {0, -1, 1, 0, 1, -1},
        {0, -1, 1, 1, -1, 0},
        {0, -1, 1, 1, 0, -1},
        {0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1},
        {0, 1, -1, -1, 0, 1},
        {0, 1, -1, -1, 1, 0},
        {0, 1, -1, 0, -1, 1},
        {0, 1, -1, 0, 0, 0},
        {0, 1, -1, 0, 1, -1},
        {0, 1, -1, 1, -1, 0},
        {0, 1, -1, 1, 0, -1},
        {0, 1, 0, -1, -1, 1},
        {0, 1, 0, -1, 0, 0},
        {0, 1, 0, -1, 1, -1},
        {0, 1, 0, 0, -1, 0},
        {0, 1, 0, 0, 0, -1},
        {0, 1, 0, 1, -1, -1},
        {0, 1, 1, -1, -1, 0},
        {0, 1, 1, -1, 0, -1},
        {0, 1, 1, 0, -1, -1},
        {1, -1, -1, -1, 1, 1},
        {1, -1, -1, 0, 0, 1},
        {1, -1, -1, 0, 1, 0},
        {1, -1, -1, 1, -1, 1},
        {1, -1, -1, 1, 0, 0},
        {1, -1, -1, 1, 1, -1},
        {1, -1, 0, -1, 0, 1},
        {1, -1, 0, -1, 1, 0},
        {1, -1, 0, 0, -1, 1},
        {1, -1, 0, 0, 0, 0},
        {1, -1, 0, 0, 1, -1},
        {1, -1, 0, 1, -1, 0},
        {1, -1, 0, 1, 0, -1},
        {1, -1, 1, -1, -1, 1},
        {1, -1, 1, -1, 0, 0},
        {1, -1, 1, -1, 1, -1},
        {1, -1, 1, 0, -1, 0},
        {1, -1, 1, 0, 0, -1},
        {1, -1, 1, 1, -1, -1},
        {1, 0, -1, -1, 0, 1},
        {1, 0, -1, -1, 1, 0},
        {1, 0, -1, 0, -1, 1},
        {1, 0, -1, 0, 0, 0},
        {1, 0, -1, 0, 1, -1},
        {1, 0, -1, 1, -1, 0},
        {1, 0, -1, 1, 0, -1},
        {1, 0, 0, -1, -1, 1},
        {1, 0, 0, -1, 0, 0},
        {1, 0, 0, -1, 1, -1},
        {1, 0, 0, 0, -1, 0},
        {1, 0, 0, 0, 0, -1},
        {1, 0, 0, 1, -1, -1},
        {1, 0, 1, -1, -1, 0},
        {1, 0, 1, -1, 0, -1},
        {1, 0, 1, 0, -1, -1},
        {1, 1, -1, -1, -1, 1},
        {1, 1, -1, -1, 0, 0},
        {1, 1, -1, -1, 1, -1},
        {1, 1, -1, 0, -1, 0},
        {1, 1, -1, 0, 0, -1},
        {1, 1, -1, 1, -1, -1},
        {1, 1, 0, -1, -1, 0},
        {1, 1, 0, -1, 0, -1},
        {1, 1, 0, 0, -1, -1}
        },
        {
        {-1, -1, 0, 0, 1, 1},
        {-1, -1, 0, 1, 0, 1},
        {-1, -1, 0, 1, 1, 0},
        {-1, -1, 1, -1, 1, 1},
        {-1, -1, 1, 0, 0, 1},
        {-1, -1, 1, 0, 1, 0},
        {-1, -1, 1, 1, -1, 1},
        {-1, -1, 1, 1, 0, 0},
        {-1, -1, 1, 1, 1, -1},
        {-1, 0, -1, 0, 1, 1},
        {-1, 0, -1, 1, 0, 1},
        {-1, 0, -1, 1, 1, 0},
        {-1, 0, 0, -1, 1, 1},
        {-1, 0, 0, 0, 0, 1},
        {-1, 0, 0, 0, 1, 0},
        {-1, 0, 0, 1, -1, 1},
        {-1, 0, 0, 1, 0, 0},
        {-1, 0, 0, 1, 1, -1},
        {-1, 0, 1, -1, 0, 1},
        {-1, 0, 1, -1, 1, 0},
        {-1, 0, 1, 0, -1, 1},
        {-1, 0, 1, 0, 0, 0},
        {-1, 0, 1, 0, 1, -1},
        {-1, 0, 1, 1, -1, 0},
        {-1, 0, 1, 1, 0, -1},
        {-1, 1, -1, -1, 1, 1},
        {-1, 1, -1, 0, 0, 1},
        {-1, 1, -1, 0, 1, 0},
        {-1, 1, -1, 1, -1, 1},
        {-1, 1, -1, 1, 0, 0},
        {-1, 1, -1, 1, 1, -1},
        {-1, 1, 0, -1, 0, 1},
        {-1, 1, 0, -1, 1, 0},
        {-1, 1, 0, 0, -1, 1},
        {-1, 1, 0, 0, 0, 0},
        {-1, 1, 0, 0, 1, -1},
        {-1, 1, 0, 1, -1, 0},
        {-1, 1, 0, 1, 0, -1},
        {-1, 1, 1, -1, -1, 1},
        {-1, 1, 1, -1, 0, 0},
        {-1, 1, 1, -1, 1, -1},
        {-1, 1, 1, 0, -1, 0},
        {-1, 1, 1, 0, 0, -1},
        {-1, 1, 1, 1, -1, -1},
        {0, -1, -1, 0, 1, 1},
        {0, -1, -1, 1, 0, 1},
        {0, -1, -1, 1, 1, 0},
        {0, -1, 0, -1, 1, 1},
        {0, -1, 0, 0, 0, 1},
        {0, -1, 0, 0, 1, 0},
        {0, -1, 0, 1, -1, 1},
        {0, -1, 0, 1, 0, 0},
        {0, -1, 0, 1, 1, -1},
        {0, -1, 1, -1, 0, 1},
        {0, -1, 1, -1, 1, 0},
        {0, -1, 1, 0, -1, 1},
        {0, -1, 1, 0, 0, 0},
        {0, -1, 1, 0, 1, -1},
        {0, -1, 1, 1, -1, 0},
        {0, -1, 1, 1, 0, -1},
        {0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1},
        {0, 1, -1, -1, 0, 1},
        {0, 1, -1, -1, 1, 0},
        {0, 1, -1, 0, -1, 1},
        {0, 1, -1, 0, 0, 0},
        {0, 1, -1, 0, 1, -1},
        {0, 1, -1, 1, -1, 0},
        {0, 1, -1, 1, 0, -1},
        {0, 1, 0, -1, -1, 1},
        {0, 1, 0, -1, 0, 0},
        {0, 1, 0, -1, 1, -1},
        {0, 1, 0, 0, -1, 0},
        {0, 1, 0, 0, 0, -1},
        {0, 1, 0, 1, -1, -1},
        {0, 1, 1, -1, -1, 0},
        {0, 1, 1, -1, 0, -1},
        {0, 1, 1, 0, -1, -1},
        {1, -1, -1, -1, 1, 1},
        {1, -1, -1, 0, 0, 1},
        {1, -1, -1, 0, 1, 0},
        {1, -1, -1, 1, -1, 1},
        {1, -1, -1, 1, 0, 0},
        {1, -1, -1, 1, 1, -1},
        {1, -1, 0, -1, 0, 1},
        {1, -1, 0, -1, 1, 0},
        {1, -1, 0, 0, -1, 1},
        {1, -1, 0, 0, 0, 0},
        {1, -1, 0, 0, 1, -1},
        {1, -1, 0, 1, -1, 0},
        {1, -1, 0, 1, 0, -1},
        {1, -1, 1, -1, -1, 1},
        {1, -1, 1, -1, 0, 0},
        {1, -1, 1, -1, 1, -1},
        {1, -1, 1, 0, -1, 0},
        {1, -1, 1, 0, 0, -1},
        {1, -1, 1, 1, -1, -1},
        {1, 0, -1, -1, 0, 1},
        {1, 0, -1, -1, 1, 0},
        {1, 0, -1, 0, -1, 1},
        {1, 0, -1, 0, 0, 0},
        {1, 0, -1, 0, 1, -1},
        {1, 0, -1, 1, -1, 0},
        {1, 0, -1, 1, 0, -1},
        {1, 0, 0, -1, -1, 1},
        {1, 0, 0, -1, 0, 0},
        {1, 0, 0, -1, 1, -1},
        {1, 0, 0, 0, -1, 0},
        {1, 0, 0, 0, 0, -1},
        {1, 0, 0, 1, -1, -1},
        {1, 0, 1, -1, -1, 0},
        {1, 0, 1, -1, 0, -1},
        {1, 0, 1, 0, -1, -1},
        {1, 1, -1, -1, -1, 1},
        {1, 1, -1, -1, 0, 0},
        {1, 1, -1, -1, 1, -1},
        {1, 1, -1, 0, -1, 0},
        {1, 1, -1, 0, 0, -1},
        {1, 1, -1, 1, -1, -1},
        {1, 1, 0, -1, -1, 0},
        {1, 1, 0, -1, 0, -1},
        {1, 1, 0, 0, -1, -1}
        },
        {
        {-1, -1, 0, 0, 1, 1},
        {-1, -1, 0, 1, 0, 1},
        {-1, -1, 0, 1, 1, 0},
        {-1, -1, 1, -1, 1, 1},
        {-1, -1, 1, 0, 0, 1},
        {-1, -1, 1, 0, 1, 0},
        {-1, -1, 1, 1, -1, 1},
        {-1, -1, 1, 1, 0, 0},
        {-1, -1, 1, 1, 1, -1},
        {-1, 0, -1, 0, 1, 1},
        {-1, 0, -1, 1, 0, 1},
        {-1, 0, -1, 1, 1, 0},
        {-1, 0, 0, -1, 1, 1},
        {-1, 0, 0, 0, 0, 1},
        {-1, 0, 0, 0, 1, 0},
        {-1, 0, 0, 1, -1, 1},
        {-1, 0, 0, 1, 0, 0},
        {-1, 0, 0, 1, 1, -1},
        {-1, 0, 1, -1, 0, 1},
        {-1, 0, 1, -1, 1, 0},
        {-1, 0, 1, 0, -1, 1},
        {-1, 0, 1, 0, 0, 0},
        {-1, 0, 1, 0, 1, -1},
        {-1, 0, 1, 1, -1, 0},
        {-1, 0, 1, 1, 0, -1},
        {-1, 1, -1, -1, 1, 1},
        {-1, 1, -1, 0, 0, 1},
        {-1, 1, -1, 0, 1, 0},
        {-1, 1, -1, 1, -1, 1},
        {-1, 1, -1, 1, 0, 0},
        {-1, 1, -1, 1, 1, -1},
        {-1, 1, 0, -1, 0, 1},
        {-1, 1, 0, -1, 1, 0},
        {-1, 1, 0, 0, -1, 1},
        {-1, 1, 0, 0, 0, 0},
        {-1, 1, 0, 0, 1, -1},
        {-1, 1, 0, 1, -1, 0},
        {-1, 1, 0, 1, 0, -1},
        {-1, 1, 1, -1, -1, 1},
        {-1, 1, 1, -1, 0, 0},
        {-1, 1, 1, -1, 1, -1},
        {-1, 1, 1, 0, -1, 0},
        {-1, 1, 1, 0, 0, -1},
        {-1, 1, 1, 1, -1, -1},
        {0, -1, -1, 0, 1, 1},
        {0, -1, -1, 1, 0, 1},
        {0, -1, -1, 1, 1, 0},
        {0, -1, 0, -1, 1, 1},
        {0, -1, 0, 0, 0, 1},
        {0, -1, 0, 0, 1, 0},
        {0, -1, 0, 1, -1, 1},
        {0, -1, 0, 1, 0, 0},
        {0, -1, 0, 1, 1, -1},
        {0, -1, 1, -1, 0, 1},
        {0, -1, 1, -1, 1, 0},
        {0, -1, 1, 0, -1, 1},
        {0, -1, 1, 0, 0, 0},
        {0, -1, 1, 0, 1, -1},
        {0, -1, 1, 1, -1, 0},
        {0, -1, 1, 1, 0, -1},
        {0, 0, -1, -1, 1, 1},
        {0, 0, -1, 0, 0, 1},
        {0, 0, -1, 0, 1, 0},
        {0, 0, -1, 1, -1, 1},
        {0, 0, -1, 1, 0, 0},
        {0, 0, -1, 1, 1, -1},
        {0, 0, 0, -1, 0, 1},
        {0, 0, 0, -1, 1, 0},
        {0, 0, 0, 0, -1, 1},
        {0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, -1},
        {0, 0, 0, 1, -1, 0},
        {0, 0, 0, 1, 0, -1},
        {0, 0, 1, -1, -1, 1},
        {0, 0, 1, -1, 0, 0},
        {0, 0, 1, -1, 1, -1},
        {0, 0, 1, 0, -1, 0},
        {0, 0, 1, 0, 0, -1},
        {0, 0, 1, 1, -1, -1},
        {0, 1, -1, -1, 0, 1},
        {0, 1, -1, -1, 1, 0},
        {0, 1, -1, 0, -1, 1},
        {0, 1, -1, 0, 0, 0},
        {0, 1, -1, 0, 1, -1},
        {0, 1, -1, 1, -1, 0},
        {0, 1, -1, 1, 0, -1},
        {0, 1, 0, -1, -1, 1},
        {0, 1, 0, -1, 0, 0},
        {0, 1, 0, -1, 1, -1},
        {0, 1, 0, 0, -1, 0},
        {0, 1, 0, 0, 0, -1},
        {0, 1, 0, 1, -1, -1},
        {0, 1, 1, -1, -1, 0},
        {0, 1, 1, -1, 0, -1},
        {0, 1, 1, 0, -1, -1},
        {1, -1, -1, -1, 1, 1},
        {1, -1, -1, 0, 0, 1},
        {1, -1, -1, 0, 1, 0},
        {1, -1, -1, 1, -1, 1},
        {1, -1, -1, 1, 0, 0},
        {1, -1, -1, 1, 1, -1},
        {1, -1, 0, -1, 0, 1},
        {1, -1, 0, -1, 1, 0},
        {1, -1, 0, 0, -1, 1},
        {1, -1, 0, 0, 0, 0},
        {1, -1, 0, 0, 1, -1},
        {1, -1, 0, 1, -1, 0},
        {1, -1, 0, 1, 0, -1},
        {1, -1, 1, -1, -1, 1},
        {1, -1, 1, -1, 0, 0},
        {1, -1, 1, -1, 1, -1},
        {1, -1, 1, 0, -1, 0},
        {1, -1, 1, 0, 0, -1},
        {1, -1, 1, 1, -1, -1},
        {1, 0, -1, -1, 0, 1},
        {1, 0, -1, -1, 1, 0},
        {1, 0, -1, 0, -1, 1},
        {1, 0, -1, 0, 0, 0},
        {1, 0, -1, 0, 1, -1},
        {1, 0, -1, 1, -1, 0},
        {1, 0, -1, 1, 0, -1},
        {1, 0, 0, -1, -1, 1},
        {1, 0, 0, -1, 0, 0},
        {1, 0, 0, -1, 1, -1},
        {1, 0, 0, 0, -1, 0},
        {1, 0, 0, 0, 0, -1},
        {1, 0, 0, 1, -1, -1},
        {1, 0, 1, -1, -1, 0},
        {1, 0, 1, -1, 0, -1},
        {1, 0, 1, 0, -1, -1},
        {1, 1, -1, -1, -1, 1},
        {1, 1, -1, -1, 0, 0},
        {1, 1, -1, -1, 1, -1},
        {1, 1, -1, 0, -1, 0},
        {1, 1, -1, 0, 0, -1},
        {1, 1, -1, 1, -1, -1},
        {1, 1, 0, -1, -1, 0},
        {1, 1, 0, -1, 0, -1},
        {1, 1, 0, 0, -1, -1}
        }
    };

}
