import unittest
from rdkit import Chem
from synkit.Chem.Reaction.fix_aam import FixAAM


class TestFixAAM(unittest.TestCase):

    def setUp(self) -> None:
        self.rsmi = (
            "[C:9]([C:8]([C:32]1([C:33]([C:34]([C:35]([C:36]([C:37]1"
            + "([H:70])[H:69])([H:67])[H:68])([H:66])[H:65])([H:63])[H:64])"
            + "([H:62])[H:61])[H:60])([H:49])[N:7]([C:5]([O:4][C:1]([C:0]"
            + "([H:39])([H:41])[H:40])([C:2]([H:44])([H:43])[H:42])[C:3]"
            + "([H:46])([H:45])[H:47])=[O:6])[H:48])([N:11]([C:12]2:[C:13]"
            + "(:[C:14]3:[C:15]4:[C:25](:[C:26]:2[H:57]):[N:24](:[C:17]"
            + "([C:18]5:[C:19](:[C:20](:[C:21](:[C:22](:[C:23]:5[H:56])"
            + "[H:55])[H:54])[H:53])[H:52]):[C:16]:4[C:27]([H:58])=[N:28]"
            + "[N:29]([C:30]3=[O:31])[H:59])[H:38])[H:51])[H:50])=[O:10]."
            + "[H:73][O:71][H:72]>>[C:5]([O:71][H:73])([O:4][C:1]([C:2]"
            + "([H:44])([H:42])[H:43])([C:0]([H:39])([H:40])[H:41])[C:3]"
            + "([H:46])([H:47])[H:45])=[O:6].[C:9]([C:8]([C:32]1([C:33]"
            + "([C:34]([C:35]([C:36]([C:37]1([H:70])[H:69])([H:67])[H:68])"
            + "([H:66])[H:65])([H:63])[H:64])([H:61])[H:62])[H:60])([H:49])"
            + "[N:7]([H:48])[H:72])([N:11]([C:12]2:[C:13](:[C:14]3:[C:15]4:"
            + "[C:25](:[C:26]:2[H:57]):[N:24](:[C:17]([C:18]5:[C:19](:[C:20]"
            + "(:[C:21](:[C:22](:[C:23]:5[H:56])[H:55])[H:54])[H:53])[H:52])"
            + ":[C:16]:4[C:27]([H:58])=[N:28][N:29]([C:30]3=[O:31])[H:59])"
            + "[H:38])[H:51])[H:50])=[O:10]"
        )

        self.expect = (
            "[C:1]([C:2]([C:3]([H:43])([H:44])[H:45])([C:4]([H:46])"
            + "([H:47])[H:48])[O:5][C:6](=[O:7])[N:8]([C:9]([C:10](=[O:11])"
            + "[N:12]([c:13]1[c:14]([H:52])[c:15]2[c:16]3[c:17]([c:18]"
            + "(-[c:19]4[c:20]([H:53])[c:21]([H:54])[c:22]([H:55])[c:23]"
            + "([H:56])[c:24]4[H:57])[n:25]([H:39])[c:26]3[c:27]1[H:58])"
            + "[C:28]([H:59])=[N:29][N:30]([H:60])[C:31]2=[O:32])[H:51])"
            + "([C:33]1([H:61])[C:34]([H:62])([H:63])[C:35]([H:64])([H:65])"
            + "[C:36]([H:66])([H:67])[C:37]([H:68])([H:69])[C:38]1([H:70])"
            + "[H:71])[H:50])[H:49])([H:40])([H:41])[H:42].[O:72]([H:73])[H:74]"
            + ">>[C:1]([C:2]([C:3]([H:43])([H:44])[H:45])([C:4]([H:46])([H:47])"
            + "[H:48])[O:5][C:6](=[O:7])[O:72][H:74])([H:40])([H:41])[H:42]."
            + "[N:8]([C:9]([C:10](=[O:11])[N:12]([c:13]1[c:14]([H:52])[c:15]2"
            + "[c:16]3[c:17]([c:18](-[c:19]4[c:20]([H:53])[c:21]([H:54])[c:22]"
            + "([H:55])[c:23]([H:56])[c:24]4[H:57])[n:25]([H:39])[c:26]3[c:27]1"
            + "[H:58])[C:28]([H:59])=[N:29][N:30]([H:60])[C:31]2=[O:32])[H:51])"
            + "([C:33]1([H:61])[C:34]([H:62])([H:63])[C:35]([H:64])([H:65])[C:36]"
            + "([H:66])([H:67])[C:37]([H:68])([H:69])[C:38]1([H:70])[H:71])"
            + "[H:50])([H:49])[H:73]"
        )

    def test_increment_atom_mapping(self):
        smi = "[CH3:0][CH3:1]"
        mol = Chem.MolFromSmiles(smi)
        new_mol = FixAAM().increment_atom_mapping(mol)
        new_smiles = Chem.MolToSmiles(new_mol)
        self.assertEqual(new_smiles, "[CH3:1][CH3:2]")

    def test_fix_aam_smi(self):
        smi = "[CH3:0][CH3:1]"
        new_smiles = FixAAM().fix_aam_smiles(smi)
        self.assertEqual(new_smiles, "[CH3:1][CH3:2]")

    def test_fit(self):
        new_rsmi = FixAAM().fix_aam_rsmi(self.rsmi)
        self.assertEqual(new_rsmi, self.expect)
