import logging

from django.conf import settings
from django.contrib import admin
from django.utils.translation import ugettext_lazy

logger = logging.getLogger(__name__)


class OpenwispAdminSite(admin.AdminSite):
    # <title>
    site_title = getattr(settings,
                         'OPENWISP_ADMIN_SITE_TITLE',
                         'OpenWISP Admin')
    # h1 text
    site_header = getattr(settings,
                          'OPENWISP_ADMIN_SITE_HEADER',
                          'OpenWISP')
    # text at the top of the admin index page
    index_title = ugettext_lazy(
        getattr(settings,
                'OPENWISP_ADMIN_INDEX_TITLE',
                'Network administration')
    )


def openwisp_admin(site_url=None):  # pragma: no-cover
    """
    openwisp_admin function is deprecated
    """
    logger.warning(
        'WARNING! Calling openwisp_utils.admin_theme.admin.openwisp_admin() '
        'is not necessary anymore and is therefore deprecated.\nThis function '
        'will be removed in future versions of openwisp-utils and therefore '
        'it is recommended to remove any reference to it.\n'
    )
