# LaraKit

**LaraKit** provides common Python components and utilities for the Lara project.  
It is designed to keep shared functionality consistent and reusable across Lara’s ecosystem.

## Installation

Clone the repository and install dependencies:

```bash
pip install -r requirements.txt
````

Set up pre-commit hooks (recommended):

```bash
pre-commit install
```

## 🧪 Development

Run tests with:

```bash
python tests
```

Lint and format the code with:

```bash
pylint src
```

## 📂 Project Layout

```
larakit/
├── src/larakit/       # Source code
├── tests/             # Unit tests
├── requirements.txt   # Development dependencies
└── pyproject.toml     # Project configuration
```

## 📜 License

This project is licensed under the MIT License – see the [LICENSE](LICENSE) file for details.