# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'FirewallApplyToArgs',
    'FirewallApplyToArgsDict',
    'FirewallRuleArgs',
    'FirewallRuleArgsDict',
    'LoadBalancerAlgorithmArgs',
    'LoadBalancerAlgorithmArgsDict',
    'LoadBalancerServiceHealthCheckArgs',
    'LoadBalancerServiceHealthCheckArgsDict',
    'LoadBalancerServiceHealthCheckHttpArgs',
    'LoadBalancerServiceHealthCheckHttpArgsDict',
    'LoadBalancerServiceHttpArgs',
    'LoadBalancerServiceHttpArgsDict',
    'LoadBalancerTargetArgs',
    'LoadBalancerTargetArgsDict',
    'ServerNetworkArgs',
    'ServerNetworkArgsDict',
    'ServerPublicNetArgs',
    'ServerPublicNetArgsDict',
    'GetFirewallApplyToArgs',
    'GetFirewallApplyToArgsDict',
    'GetFirewallRuleArgs',
    'GetFirewallRuleArgsDict',
    'GetServerNetworkArgs',
    'GetServerNetworkArgsDict',
]

MYPY = False

if not MYPY:
    class FirewallApplyToArgsDict(TypedDict):
        label_selector: NotRequired[pulumi.Input[_builtins.str]]
        """
        Label Selector to select servers the firewall should be applied to (only one
        of `server` and `label_selector`can be applied in one block)
        """
        server: NotRequired[pulumi.Input[_builtins.int]]
        """
        ID of the server you want to apply the firewall to (only one of `server`
        and `label_selector`can be applied in one block)
        """
elif False:
    FirewallApplyToArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FirewallApplyToArgs:
    def __init__(__self__, *,
                 label_selector: Optional[pulumi.Input[_builtins.str]] = None,
                 server: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] label_selector: Label Selector to select servers the firewall should be applied to (only one
               of `server` and `label_selector`can be applied in one block)
        :param pulumi.Input[_builtins.int] server: ID of the server you want to apply the firewall to (only one of `server`
               and `label_selector`can be applied in one block)
        """
        if label_selector is not None:
            pulumi.set(__self__, "label_selector", label_selector)
        if server is not None:
            pulumi.set(__self__, "server", server)

    @_builtins.property
    @pulumi.getter(name="labelSelector")
    def label_selector(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Label Selector to select servers the firewall should be applied to (only one
        of `server` and `label_selector`can be applied in one block)
        """
        return pulumi.get(self, "label_selector")

    @label_selector.setter
    def label_selector(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label_selector", value)

    @_builtins.property
    @pulumi.getter
    def server(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        ID of the server you want to apply the firewall to (only one of `server`
        and `label_selector`can be applied in one block)
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "server", value)


if not MYPY:
    class FirewallRuleArgsDict(TypedDict):
        direction: pulumi.Input[_builtins.str]
        """
        Direction of the Firewall Rule. `in`
        """
        protocol: pulumi.Input[_builtins.str]
        """
        Protocol of the Firewall Rule. `tcp`, `icmp`, `udp`, `gre`, `esp`
        """
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        Description of the firewall rule
        """
        destination_ips: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        List of IPs or CIDRs that are allowed within this Firewall Rule (when `direction`
        is `out`)
        """
        port: NotRequired[pulumi.Input[_builtins.str]]
        """
        Port of the Firewall Rule. Required when `protocol` is `tcp` or `udp`. You can use `any`
        to allow all ports for the specific protocol. Port ranges are also possible: `80-85` allows all ports between 80 and 85.
        """
        source_ips: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        List of IPs or CIDRs that are allowed within this Firewall Rule (when `direction`
        is `in`)
        """
elif False:
    FirewallRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FirewallRuleArgs:
    def __init__(__self__, *,
                 direction: pulumi.Input[_builtins.str],
                 protocol: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 source_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] direction: Direction of the Firewall Rule. `in`
        :param pulumi.Input[_builtins.str] protocol: Protocol of the Firewall Rule. `tcp`, `icmp`, `udp`, `gre`, `esp`
        :param pulumi.Input[_builtins.str] description: Description of the firewall rule
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] destination_ips: List of IPs or CIDRs that are allowed within this Firewall Rule (when `direction`
               is `out`)
        :param pulumi.Input[_builtins.str] port: Port of the Firewall Rule. Required when `protocol` is `tcp` or `udp`. You can use `any`
               to allow all ports for the specific protocol. Port ranges are also possible: `80-85` allows all ports between 80 and 85.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] source_ips: List of IPs or CIDRs that are allowed within this Firewall Rule (when `direction`
               is `in`)
        """
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "protocol", protocol)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_ips is not None:
            pulumi.set(__self__, "destination_ips", destination_ips)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if source_ips is not None:
            pulumi.set(__self__, "source_ips", source_ips)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> pulumi.Input[_builtins.str]:
        """
        Direction of the Firewall Rule. `in`
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "direction", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.str]:
        """
        Protocol of the Firewall Rule. `tcp`, `icmp`, `udp`, `gre`, `esp`
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the firewall rule
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationIps")
    def destination_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of IPs or CIDRs that are allowed within this Firewall Rule (when `direction`
        is `out`)
        """
        return pulumi.get(self, "destination_ips")

    @destination_ips.setter
    def destination_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "destination_ips", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Port of the Firewall Rule. Required when `protocol` is `tcp` or `udp`. You can use `any`
        to allow all ports for the specific protocol. Port ranges are also possible: `80-85` allows all ports between 80 and 85.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="sourceIps")
    def source_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of IPs or CIDRs that are allowed within this Firewall Rule (when `direction`
        is `in`)
        """
        return pulumi.get(self, "source_ips")

    @source_ips.setter
    def source_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "source_ips", value)


if not MYPY:
    class LoadBalancerAlgorithmArgsDict(TypedDict):
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Type of the Load Balancer Algorithm. `round_robin` or `least_connections`
        """
elif False:
    LoadBalancerAlgorithmArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadBalancerAlgorithmArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Type of the Load Balancer Algorithm. `round_robin` or `least_connections`
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the Load Balancer Algorithm. `round_robin` or `least_connections`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class LoadBalancerServiceHealthCheckArgsDict(TypedDict):
        interval: pulumi.Input[_builtins.int]
        """
        Interval how often the health check will be performed, in seconds.
        """
        port: pulumi.Input[_builtins.int]
        """
        Port the health check tries to connect to, required if protocol is `tcp`. Can be everything between `1` and `65535`. Must be unique per Load Balancer.
        """
        protocol: pulumi.Input[_builtins.str]
        """
        Protocol the health check uses. `http` or `tcp`
        """
        timeout: pulumi.Input[_builtins.int]
        """
        Timeout when a health check try will be canceled if there is no response, in seconds.
        """
        http: NotRequired[pulumi.Input['LoadBalancerServiceHealthCheckHttpArgsDict']]
        """
        HTTP configuration. Required if `protocol` is `http`.
        """
        retries: NotRequired[pulumi.Input[_builtins.int]]
        """
        Number of tries a health check will be performed until a target will be listed as `unhealthy`.
        """
elif False:
    LoadBalancerServiceHealthCheckArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadBalancerServiceHealthCheckArgs:
    def __init__(__self__, *,
                 interval: pulumi.Input[_builtins.int],
                 port: pulumi.Input[_builtins.int],
                 protocol: pulumi.Input[_builtins.str],
                 timeout: pulumi.Input[_builtins.int],
                 http: Optional[pulumi.Input['LoadBalancerServiceHealthCheckHttpArgs']] = None,
                 retries: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] interval: Interval how often the health check will be performed, in seconds.
        :param pulumi.Input[_builtins.int] port: Port the health check tries to connect to, required if protocol is `tcp`. Can be everything between `1` and `65535`. Must be unique per Load Balancer.
        :param pulumi.Input[_builtins.str] protocol: Protocol the health check uses. `http` or `tcp`
        :param pulumi.Input[_builtins.int] timeout: Timeout when a health check try will be canceled if there is no response, in seconds.
        :param pulumi.Input['LoadBalancerServiceHealthCheckHttpArgs'] http: HTTP configuration. Required if `protocol` is `http`.
        :param pulumi.Input[_builtins.int] retries: Number of tries a health check will be performed until a target will be listed as `unhealthy`.
        """
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "timeout", timeout)
        if http is not None:
            pulumi.set(__self__, "http", http)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> pulumi.Input[_builtins.int]:
        """
        Interval how often the health check will be performed, in seconds.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "interval", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Input[_builtins.int]:
        """
        Port the health check tries to connect to, required if protocol is `tcp`. Can be everything between `1` and `65535`. Must be unique per Load Balancer.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.str]:
        """
        Protocol the health check uses. `http` or `tcp`
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> pulumi.Input[_builtins.int]:
        """
        Timeout when a health check try will be canceled if there is no response, in seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter
    def http(self) -> Optional[pulumi.Input['LoadBalancerServiceHealthCheckHttpArgs']]:
        """
        HTTP configuration. Required if `protocol` is `http`.
        """
        return pulumi.get(self, "http")

    @http.setter
    def http(self, value: Optional[pulumi.Input['LoadBalancerServiceHealthCheckHttpArgs']]):
        pulumi.set(self, "http", value)

    @_builtins.property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of tries a health check will be performed until a target will be listed as `unhealthy`.
        """
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retries", value)


if not MYPY:
    class LoadBalancerServiceHealthCheckHttpArgsDict(TypedDict):
        domain: NotRequired[pulumi.Input[_builtins.str]]
        """
        Domain we try to access when performing the Health Check.
        """
        path: NotRequired[pulumi.Input[_builtins.str]]
        """
        Path we try to access when performing the Health Check.
        """
        response: NotRequired[pulumi.Input[_builtins.str]]
        """
        Response we expect to be included in the Target response when a Health Check was performed.
        """
        status_codes: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        We expect that the target answers with these status codes. If not the target is marked as `unhealthy`.
        """
        tls: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enable TLS certificate checking.
        """
elif False:
    LoadBalancerServiceHealthCheckHttpArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadBalancerServiceHealthCheckHttpArgs:
    def __init__(__self__, *,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 response: Optional[pulumi.Input[_builtins.str]] = None,
                 status_codes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tls: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] domain: Domain we try to access when performing the Health Check.
        :param pulumi.Input[_builtins.str] path: Path we try to access when performing the Health Check.
        :param pulumi.Input[_builtins.str] response: Response we expect to be included in the Target response when a Health Check was performed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] status_codes: We expect that the target answers with these status codes. If not the target is marked as `unhealthy`.
        :param pulumi.Input[_builtins.bool] tls: Enable TLS certificate checking.
        """
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if response is not None:
            pulumi.set(__self__, "response", response)
        if status_codes is not None:
            pulumi.set(__self__, "status_codes", status_codes)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Domain we try to access when performing the Health Check.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path we try to access when performing the Health Check.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter
    def response(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Response we expect to be included in the Target response when a Health Check was performed.
        """
        return pulumi.get(self, "response")

    @response.setter
    def response(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "response", value)

    @_builtins.property
    @pulumi.getter(name="statusCodes")
    def status_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        We expect that the target answers with these status codes. If not the target is marked as `unhealthy`.
        """
        return pulumi.get(self, "status_codes")

    @status_codes.setter
    def status_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "status_codes", value)

    @_builtins.property
    @pulumi.getter
    def tls(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable TLS certificate checking.
        """
        return pulumi.get(self, "tls")

    @tls.setter
    def tls(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tls", value)


if not MYPY:
    class LoadBalancerServiceHttpArgsDict(TypedDict):
        certificates: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]
        """
        List of IDs from certificates which the Load Balancer has.
        """
        cookie_lifetime: NotRequired[pulumi.Input[_builtins.int]]
        """
        Lifetime of the cookie for sticky session (in seconds). Default: `300`
        """
        cookie_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Name of the cookie for sticky session. Default: `HCLBSTICKY`
        """
        redirect_http: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Redirect HTTP to HTTPS traffic. Only supported for services with `protocol` `https` using the default HTTP port `80`.
        """
        sticky_sessions: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enable sticky sessions
        """
elif False:
    LoadBalancerServiceHttpArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadBalancerServiceHttpArgs:
    def __init__(__self__, *,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 cookie_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 cookie_name: Optional[pulumi.Input[_builtins.str]] = None,
                 redirect_http: Optional[pulumi.Input[_builtins.bool]] = None,
                 sticky_sessions: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] certificates: List of IDs from certificates which the Load Balancer has.
        :param pulumi.Input[_builtins.int] cookie_lifetime: Lifetime of the cookie for sticky session (in seconds). Default: `300`
        :param pulumi.Input[_builtins.str] cookie_name: Name of the cookie for sticky session. Default: `HCLBSTICKY`
        :param pulumi.Input[_builtins.bool] redirect_http: Redirect HTTP to HTTPS traffic. Only supported for services with `protocol` `https` using the default HTTP port `80`.
        :param pulumi.Input[_builtins.bool] sticky_sessions: Enable sticky sessions
        """
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if cookie_lifetime is not None:
            pulumi.set(__self__, "cookie_lifetime", cookie_lifetime)
        if cookie_name is not None:
            pulumi.set(__self__, "cookie_name", cookie_name)
        if redirect_http is not None:
            pulumi.set(__self__, "redirect_http", redirect_http)
        if sticky_sessions is not None:
            pulumi.set(__self__, "sticky_sessions", sticky_sessions)

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        List of IDs from certificates which the Load Balancer has.
        """
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "certificates", value)

    @_builtins.property
    @pulumi.getter(name="cookieLifetime")
    def cookie_lifetime(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Lifetime of the cookie for sticky session (in seconds). Default: `300`
        """
        return pulumi.get(self, "cookie_lifetime")

    @cookie_lifetime.setter
    def cookie_lifetime(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cookie_lifetime", value)

    @_builtins.property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the cookie for sticky session. Default: `HCLBSTICKY`
        """
        return pulumi.get(self, "cookie_name")

    @cookie_name.setter
    def cookie_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cookie_name", value)

    @_builtins.property
    @pulumi.getter(name="redirectHttp")
    def redirect_http(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Redirect HTTP to HTTPS traffic. Only supported for services with `protocol` `https` using the default HTTP port `80`.
        """
        return pulumi.get(self, "redirect_http")

    @redirect_http.setter
    def redirect_http(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "redirect_http", value)

    @_builtins.property
    @pulumi.getter(name="stickySessions")
    def sticky_sessions(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable sticky sessions
        """
        return pulumi.get(self, "sticky_sessions")

    @sticky_sessions.setter
    def sticky_sessions(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sticky_sessions", value)


if not MYPY:
    class LoadBalancerTargetArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        (string) Type of the Load Balancer Algorithm. `round_robin` or `least_connections`
        """
        server_id: NotRequired[pulumi.Input[_builtins.int]]
        use_private_ip: NotRequired[pulumi.Input[_builtins.bool]]
elif False:
    LoadBalancerTargetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadBalancerTargetArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 server_id: Optional[pulumi.Input[_builtins.int]] = None,
                 use_private_ip: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] type: (string) Type of the Load Balancer Algorithm. `round_robin` or `least_connections`
        """
        pulumi.set(__self__, "type", type)
        if server_id is not None:
            pulumi.set(__self__, "server_id", server_id)
        if use_private_ip is not None:
            warnings.warn("""Does not work. Use the LoadBalancerTarget resource instead.""", DeprecationWarning)
            pulumi.log.warn("""use_private_ip is deprecated: Does not work. Use the LoadBalancerTarget resource instead.""")
        if use_private_ip is not None:
            pulumi.set(__self__, "use_private_ip", use_private_ip)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        (string) Type of the Load Balancer Algorithm. `round_robin` or `least_connections`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "server_id", value)

    @_builtins.property
    @pulumi.getter(name="usePrivateIp")
    @_utilities.deprecated("""Does not work. Use the LoadBalancerTarget resource instead.""")
    def use_private_ip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "use_private_ip")

    @use_private_ip.setter
    def use_private_ip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_private_ip", value)


if not MYPY:
    class ServerNetworkArgsDict(TypedDict):
        network_id: pulumi.Input[_builtins.int]
        """
        ID of the network
        """
        alias_ips: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specify the IP the server should get in the network
        """
        mac_address: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Optional, string) The MAC address the private interface of the server has
        """
elif False:
    ServerNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerNetworkArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[_builtins.int],
                 alias_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 mac_address: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] network_id: ID of the network
        :param pulumi.Input[_builtins.str] ip: Specify the IP the server should get in the network
        :param pulumi.Input[_builtins.str] mac_address: (Optional, string) The MAC address the private interface of the server has
        """
        pulumi.set(__self__, "network_id", network_id)
        if alias_ips is not None:
            pulumi.set(__self__, "alias_ips", alias_ips)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[_builtins.int]:
        """
        ID of the network
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="aliasIps")
    def alias_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "alias_ips")

    @alias_ips.setter
    def alias_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "alias_ips", value)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the IP the server should get in the network
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Optional, string) The MAC address the private interface of the server has
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mac_address", value)


if not MYPY:
    class ServerPublicNetArgsDict(TypedDict):
        ipv4: NotRequired[pulumi.Input[_builtins.int]]
        ipv4_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        ipv6: NotRequired[pulumi.Input[_builtins.int]]
        ipv6_enabled: NotRequired[pulumi.Input[_builtins.bool]]
elif False:
    ServerPublicNetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerPublicNetArgs:
    def __init__(__self__, *,
                 ipv4: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv4_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        if ipv4 is not None:
            pulumi.set(__self__, "ipv4", ipv4)
        if ipv4_enabled is not None:
            pulumi.set(__self__, "ipv4_enabled", ipv4_enabled)
        if ipv6 is not None:
            pulumi.set(__self__, "ipv6", ipv6)
        if ipv6_enabled is not None:
            pulumi.set(__self__, "ipv6_enabled", ipv6_enabled)

    @_builtins.property
    @pulumi.getter
    def ipv4(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "ipv4")

    @ipv4.setter
    def ipv4(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipv4", value)

    @_builtins.property
    @pulumi.getter(name="ipv4Enabled")
    def ipv4_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "ipv4_enabled")

    @ipv4_enabled.setter
    def ipv4_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ipv4_enabled", value)

    @_builtins.property
    @pulumi.getter
    def ipv6(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "ipv6")

    @ipv6.setter
    def ipv6(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipv6", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Enabled")
    def ipv6_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "ipv6_enabled")

    @ipv6_enabled.setter
    def ipv6_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ipv6_enabled", value)


if not MYPY:
    class GetFirewallApplyToArgsDict(TypedDict):
        label_selector: _builtins.str
        """
        (string) Label Selector to select servers the firewall is applied to. Empty if a server is directly
        referenced
        """
        server: _builtins.int
        """
        (int) ID of a server where the firewall is applied to. `0` if applied to a label_selector
        """
elif False:
    GetFirewallApplyToArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetFirewallApplyToArgs:
    def __init__(__self__, *,
                 label_selector: _builtins.str,
                 server: _builtins.int):
        """
        :param _builtins.str label_selector: (string) Label Selector to select servers the firewall is applied to. Empty if a server is directly
               referenced
        :param _builtins.int server: (int) ID of a server where the firewall is applied to. `0` if applied to a label_selector
        """
        pulumi.set(__self__, "label_selector", label_selector)
        pulumi.set(__self__, "server", server)

    @_builtins.property
    @pulumi.getter(name="labelSelector")
    def label_selector(self) -> _builtins.str:
        """
        (string) Label Selector to select servers the firewall is applied to. Empty if a server is directly
        referenced
        """
        return pulumi.get(self, "label_selector")

    @label_selector.setter
    def label_selector(self, value: _builtins.str):
        pulumi.set(self, "label_selector", value)

    @_builtins.property
    @pulumi.getter
    def server(self) -> _builtins.int:
        """
        (int) ID of a server where the firewall is applied to. `0` if applied to a label_selector
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: _builtins.int):
        pulumi.set(self, "server", value)


if not MYPY:
    class GetFirewallRuleArgsDict(TypedDict):
        direction: _builtins.str
        """
        (Required, string) Direction of the Firewall Rule. `in`, `out`
        """
        description: NotRequired[_builtins.str]
        """
        (Optional, string) Description of the firewall rule
        """
        destination_ips: NotRequired[Sequence[_builtins.str]]
        """
        (Required, List) List of CIDRs that are allowed within this Firewall Rule (when `direction` is `out`)
        """
        port: NotRequired[_builtins.str]
        """
        (Required, string) Port of the Firewall Rule. Required when `protocol` is `tcp` or `udp`
        """
        protocol: NotRequired[_builtins.str]
        """
        (Required, string) Protocol of the Firewall Rule. `tcp`, `icmp`, `udp`, `gre`, `esp`
        """
        source_ips: NotRequired[Sequence[_builtins.str]]
        """
        (Required, List) List of CIDRs that are allowed within this Firewall Rule (when `direction` is `in`)
        """
elif False:
    GetFirewallRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetFirewallRuleArgs:
    def __init__(__self__, *,
                 direction: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 destination_ips: Optional[Sequence[_builtins.str]] = None,
                 port: Optional[_builtins.str] = None,
                 protocol: Optional[_builtins.str] = None,
                 source_ips: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str direction: (Required, string) Direction of the Firewall Rule. `in`, `out`
        :param _builtins.str description: (Optional, string) Description of the firewall rule
        :param Sequence[_builtins.str] destination_ips: (Required, List) List of CIDRs that are allowed within this Firewall Rule (when `direction` is `out`)
        :param _builtins.str port: (Required, string) Port of the Firewall Rule. Required when `protocol` is `tcp` or `udp`
        :param _builtins.str protocol: (Required, string) Protocol of the Firewall Rule. `tcp`, `icmp`, `udp`, `gre`, `esp`
        :param Sequence[_builtins.str] source_ips: (Required, List) List of CIDRs that are allowed within this Firewall Rule (when `direction` is `in`)
        """
        pulumi.set(__self__, "direction", direction)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_ips is not None:
            pulumi.set(__self__, "destination_ips", destination_ips)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if source_ips is not None:
            pulumi.set(__self__, "source_ips", source_ips)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> _builtins.str:
        """
        (Required, string) Direction of the Firewall Rule. `in`, `out`
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: _builtins.str):
        pulumi.set(self, "direction", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        (Optional, string) Description of the firewall rule
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationIps")
    def destination_ips(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Required, List) List of CIDRs that are allowed within this Firewall Rule (when `direction` is `out`)
        """
        return pulumi.get(self, "destination_ips")

    @destination_ips.setter
    def destination_ips(self, value: Optional[Sequence[_builtins.str]]):
        pulumi.set(self, "destination_ips", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.str]:
        """
        (Required, string) Port of the Firewall Rule. Required when `protocol` is `tcp` or `udp`
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[_builtins.str]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        (Required, string) Protocol of the Firewall Rule. `tcp`, `icmp`, `udp`, `gre`, `esp`
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[_builtins.str]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="sourceIps")
    def source_ips(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Required, List) List of CIDRs that are allowed within this Firewall Rule (when `direction` is `in`)
        """
        return pulumi.get(self, "source_ips")

    @source_ips.setter
    def source_ips(self, value: Optional[Sequence[_builtins.str]]):
        pulumi.set(self, "source_ips", value)


if not MYPY:
    class GetServerNetworkArgsDict(TypedDict):
        alias_ips: Sequence[_builtins.str]
        """
        (list) A list of alias IP addresses assigned to the server in the network.
        """
        ip: _builtins.str
        """
        (string) The server's IP address within the network.
        """
        mac_address: _builtins.str
        """
        (string) The MAC address associated with the server's private network interface.
        """
        network_id: _builtins.int
        """
        (int) The unique identifier for the network.
        """
elif False:
    GetServerNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetServerNetworkArgs:
    def __init__(__self__, *,
                 alias_ips: Sequence[_builtins.str],
                 ip: _builtins.str,
                 mac_address: _builtins.str,
                 network_id: _builtins.int):
        """
        :param Sequence[_builtins.str] alias_ips: (list) A list of alias IP addresses assigned to the server in the network.
        :param _builtins.str ip: (string) The server's IP address within the network.
        :param _builtins.str mac_address: (string) The MAC address associated with the server's private network interface.
        :param _builtins.int network_id: (int) The unique identifier for the network.
        """
        pulumi.set(__self__, "alias_ips", alias_ips)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "mac_address", mac_address)
        pulumi.set(__self__, "network_id", network_id)

    @_builtins.property
    @pulumi.getter(name="aliasIps")
    def alias_ips(self) -> Sequence[_builtins.str]:
        """
        (list) A list of alias IP addresses assigned to the server in the network.
        """
        return pulumi.get(self, "alias_ips")

    @alias_ips.setter
    def alias_ips(self, value: Sequence[_builtins.str]):
        pulumi.set(self, "alias_ips", value)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        (string) The server's IP address within the network.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: _builtins.str):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> _builtins.str:
        """
        (string) The MAC address associated with the server's private network interface.
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: _builtins.str):
        pulumi.set(self, "mac_address", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> _builtins.int:
        """
        (int) The unique identifier for the network.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: _builtins.int):
        pulumi.set(self, "network_id", value)


