# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['FirewallAttachmentArgs', 'FirewallAttachment']

@pulumi.input_type
class FirewallAttachmentArgs:
    def __init__(__self__, *,
                 firewall_id: pulumi.Input[_builtins.int],
                 label_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 server_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None):
        """
        The set of arguments for constructing a FirewallAttachment resource.
        :param pulumi.Input[_builtins.int] firewall_id: ID of the firewall the resources
               should be attached to.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] label_selectors: List of label selectors used to
               select resources to attach to the firewall.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] server_ids: List of Server IDs to attach to the
               firewall.
        """
        pulumi.set(__self__, "firewall_id", firewall_id)
        if label_selectors is not None:
            pulumi.set(__self__, "label_selectors", label_selectors)
        if server_ids is not None:
            pulumi.set(__self__, "server_ids", server_ids)

    @_builtins.property
    @pulumi.getter(name="firewallId")
    def firewall_id(self) -> pulumi.Input[_builtins.int]:
        """
        ID of the firewall the resources
        should be attached to.
        """
        return pulumi.get(self, "firewall_id")

    @firewall_id.setter
    def firewall_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "firewall_id", value)

    @_builtins.property
    @pulumi.getter(name="labelSelectors")
    def label_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of label selectors used to
        select resources to attach to the firewall.
        """
        return pulumi.get(self, "label_selectors")

    @label_selectors.setter
    def label_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "label_selectors", value)

    @_builtins.property
    @pulumi.getter(name="serverIds")
    def server_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        List of Server IDs to attach to the
        firewall.
        """
        return pulumi.get(self, "server_ids")

    @server_ids.setter
    def server_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "server_ids", value)


@pulumi.input_type
class _FirewallAttachmentState:
    def __init__(__self__, *,
                 firewall_id: Optional[pulumi.Input[_builtins.int]] = None,
                 label_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 server_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None):
        """
        Input properties used for looking up and filtering FirewallAttachment resources.
        :param pulumi.Input[_builtins.int] firewall_id: ID of the firewall the resources
               should be attached to.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] label_selectors: List of label selectors used to
               select resources to attach to the firewall.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] server_ids: List of Server IDs to attach to the
               firewall.
        """
        if firewall_id is not None:
            pulumi.set(__self__, "firewall_id", firewall_id)
        if label_selectors is not None:
            pulumi.set(__self__, "label_selectors", label_selectors)
        if server_ids is not None:
            pulumi.set(__self__, "server_ids", server_ids)

    @_builtins.property
    @pulumi.getter(name="firewallId")
    def firewall_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        ID of the firewall the resources
        should be attached to.
        """
        return pulumi.get(self, "firewall_id")

    @firewall_id.setter
    def firewall_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "firewall_id", value)

    @_builtins.property
    @pulumi.getter(name="labelSelectors")
    def label_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of label selectors used to
        select resources to attach to the firewall.
        """
        return pulumi.get(self, "label_selectors")

    @label_selectors.setter
    def label_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "label_selectors", value)

    @_builtins.property
    @pulumi.getter(name="serverIds")
    def server_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        List of Server IDs to attach to the
        firewall.
        """
        return pulumi.get(self, "server_ids")

    @server_ids.setter
    def server_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "server_ids", value)


@pulumi.type_token("hcloud:index/firewallAttachment:FirewallAttachment")
class FirewallAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 firewall_id: Optional[pulumi.Input[_builtins.int]] = None,
                 label_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 server_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 __props__=None):
        """
        Attaches resource to a Hetzner Cloud Firewall.

        _Note_: only one `FirewallAttachment` per Firewall is allowed.
        Any resources that should be attached to that Firewall need to be
        specified in that `FirewallAttachment`.

        ## Example Usage

        ### Attach Servers

        ```python
        import pulumi
        import pulumi_hcloud as hcloud

        test_server = hcloud.Server("test_server",
            name="test-server",
            server_type="cx22",
            image="ubuntu-20.04")
        basic_firewall = hcloud.Firewall("basic_firewall", name="basic_firewall")
        fw_ref = hcloud.FirewallAttachment("fw_ref",
            firewall_id=basic_firewall.id,
            server_ids=[test_server.id])
        ```

        ### Attach Label Selectors

        ```python
        import pulumi
        import pulumi_hcloud as hcloud

        test_server = hcloud.Server("test_server",
            name="test-server",
            server_type="cx22",
            image="ubuntu-20.04",
            labels={
                "firewall-attachment": "test-server",
            })
        basic_firewall = hcloud.Firewall("basic_firewall", name="basic_firewall")
        fw_ref = hcloud.FirewallAttachment("fw_ref",
            firewall_id=basic_firewall.id,
            label_selectors=["firewall-attachment=test-server"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] firewall_id: ID of the firewall the resources
               should be attached to.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] label_selectors: List of label selectors used to
               select resources to attach to the firewall.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] server_ids: List of Server IDs to attach to the
               firewall.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FirewallAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Attaches resource to a Hetzner Cloud Firewall.

        _Note_: only one `FirewallAttachment` per Firewall is allowed.
        Any resources that should be attached to that Firewall need to be
        specified in that `FirewallAttachment`.

        ## Example Usage

        ### Attach Servers

        ```python
        import pulumi
        import pulumi_hcloud as hcloud

        test_server = hcloud.Server("test_server",
            name="test-server",
            server_type="cx22",
            image="ubuntu-20.04")
        basic_firewall = hcloud.Firewall("basic_firewall", name="basic_firewall")
        fw_ref = hcloud.FirewallAttachment("fw_ref",
            firewall_id=basic_firewall.id,
            server_ids=[test_server.id])
        ```

        ### Attach Label Selectors

        ```python
        import pulumi
        import pulumi_hcloud as hcloud

        test_server = hcloud.Server("test_server",
            name="test-server",
            server_type="cx22",
            image="ubuntu-20.04",
            labels={
                "firewall-attachment": "test-server",
            })
        basic_firewall = hcloud.Firewall("basic_firewall", name="basic_firewall")
        fw_ref = hcloud.FirewallAttachment("fw_ref",
            firewall_id=basic_firewall.id,
            label_selectors=["firewall-attachment=test-server"])
        ```

        :param str resource_name: The name of the resource.
        :param FirewallAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FirewallAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 firewall_id: Optional[pulumi.Input[_builtins.int]] = None,
                 label_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 server_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FirewallAttachmentArgs.__new__(FirewallAttachmentArgs)

            if firewall_id is None and not opts.urn:
                raise TypeError("Missing required property 'firewall_id'")
            __props__.__dict__["firewall_id"] = firewall_id
            __props__.__dict__["label_selectors"] = label_selectors
            __props__.__dict__["server_ids"] = server_ids
        super(FirewallAttachment, __self__).__init__(
            'hcloud:index/firewallAttachment:FirewallAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            firewall_id: Optional[pulumi.Input[_builtins.int]] = None,
            label_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            server_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None) -> 'FirewallAttachment':
        """
        Get an existing FirewallAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] firewall_id: ID of the firewall the resources
               should be attached to.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] label_selectors: List of label selectors used to
               select resources to attach to the firewall.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] server_ids: List of Server IDs to attach to the
               firewall.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FirewallAttachmentState.__new__(_FirewallAttachmentState)

        __props__.__dict__["firewall_id"] = firewall_id
        __props__.__dict__["label_selectors"] = label_selectors
        __props__.__dict__["server_ids"] = server_ids
        return FirewallAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="firewallId")
    def firewall_id(self) -> pulumi.Output[_builtins.int]:
        """
        ID of the firewall the resources
        should be attached to.
        """
        return pulumi.get(self, "firewall_id")

    @_builtins.property
    @pulumi.getter(name="labelSelectors")
    def label_selectors(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of label selectors used to
        select resources to attach to the firewall.
        """
        return pulumi.get(self, "label_selectors")

    @_builtins.property
    @pulumi.getter(name="serverIds")
    def server_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.int]]]:
        """
        List of Server IDs to attach to the
        firewall.
        """
        return pulumi.get(self, "server_ids")

