# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetLocationResult',
    'AwaitableGetLocationResult',
    'get_location',
    'get_location_output',
]

@pulumi.output_type
class GetLocationResult:
    """
    A collection of values returned by getLocation.
    """
    def __init__(__self__, city=None, country=None, description=None, id=None, latitude=None, longitude=None, name=None, network_zone=None):
        if city and not isinstance(city, str):
            raise TypeError("Expected argument 'city' to be a str")
        pulumi.set(__self__, "city", city)
        if country and not isinstance(country, str):
            raise TypeError("Expected argument 'country' to be a str")
        pulumi.set(__self__, "country", country)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if latitude and not isinstance(latitude, float):
            raise TypeError("Expected argument 'latitude' to be a float")
        pulumi.set(__self__, "latitude", latitude)
        if longitude and not isinstance(longitude, float):
            raise TypeError("Expected argument 'longitude' to be a float")
        pulumi.set(__self__, "longitude", longitude)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_zone and not isinstance(network_zone, str):
            raise TypeError("Expected argument 'network_zone' to be a str")
        pulumi.set(__self__, "network_zone", network_zone)

    @_builtins.property
    @pulumi.getter
    def city(self) -> _builtins.str:
        """
        Name of the closest city to the Location. City name and optionally state in short form.
        """
        return pulumi.get(self, "city")

    @_builtins.property
    @pulumi.getter
    def country(self) -> _builtins.str:
        """
        Country the Location resides in. ISO 3166-1 alpha-2 code of the country.
        """
        return pulumi.get(self, "country")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the Location.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.int]:
        """
        ID of the Location.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def latitude(self) -> _builtins.float:
        """
        Latitude of the city closest to the Location.
        """
        return pulumi.get(self, "latitude")

    @_builtins.property
    @pulumi.getter
    def longitude(self) -> _builtins.float:
        """
        Longitude of the city closest to the Location.
        """
        return pulumi.get(self, "longitude")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the Location.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkZone")
    def network_zone(self) -> _builtins.str:
        """
        Name of the Network Zone this Location resides in.
        """
        return pulumi.get(self, "network_zone")


class AwaitableGetLocationResult(GetLocationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLocationResult(
            city=self.city,
            country=self.country,
            description=self.description,
            id=self.id,
            latitude=self.latitude,
            longitude=self.longitude,
            name=self.name,
            network_zone=self.network_zone)


def get_location(id: Optional[_builtins.int] = None,
                 name: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLocationResult:
    """
    Provides details about a specific Hetzner Cloud Location.

    Use this resource to get detailed information about a specific Location.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_hcloud as hcloud

    by_id = hcloud.get_location(id=1)
    by_name = hcloud.get_location(name="fsn1")
    ```


    :param _builtins.int id: ID of the Location.
    :param _builtins.str name: Name of the Location.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('hcloud:index/getLocation:getLocation', __args__, opts=opts, typ=GetLocationResult).value

    return AwaitableGetLocationResult(
        city=pulumi.get(__ret__, 'city'),
        country=pulumi.get(__ret__, 'country'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        latitude=pulumi.get(__ret__, 'latitude'),
        longitude=pulumi.get(__ret__, 'longitude'),
        name=pulumi.get(__ret__, 'name'),
        network_zone=pulumi.get(__ret__, 'network_zone'))
def get_location_output(id: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                        name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLocationResult]:
    """
    Provides details about a specific Hetzner Cloud Location.

    Use this resource to get detailed information about a specific Location.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_hcloud as hcloud

    by_id = hcloud.get_location(id=1)
    by_name = hcloud.get_location(name="fsn1")
    ```


    :param _builtins.int id: ID of the Location.
    :param _builtins.str name: Name of the Location.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('hcloud:index/getLocation:getLocation', __args__, opts=opts, typ=GetLocationResult)
    return __ret__.apply(lambda __response__: GetLocationResult(
        city=pulumi.get(__response__, 'city'),
        country=pulumi.get(__response__, 'country'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        latitude=pulumi.get(__response__, 'latitude'),
        longitude=pulumi.get(__response__, 'longitude'),
        name=pulumi.get(__response__, 'name'),
        network_zone=pulumi.get(__response__, 'network_zone')))
