# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetLocationsResult',
    'AwaitableGetLocationsResult',
    'get_locations',
    'get_locations_output',
]

@pulumi.output_type
class GetLocationsResult:
    """
    A collection of values returned by getLocations.
    """
    def __init__(__self__, descriptions=None, id=None, location_ids=None, locations=None, names=None):
        if descriptions and not isinstance(descriptions, list):
            raise TypeError("Expected argument 'descriptions' to be a list")
        pulumi.set(__self__, "descriptions", descriptions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location_ids and not isinstance(location_ids, list):
            raise TypeError("Expected argument 'location_ids' to be a list")
        pulumi.set(__self__, "location_ids", location_ids)
        if locations and not isinstance(locations, list):
            raise TypeError("Expected argument 'locations' to be a list")
        pulumi.set(__self__, "locations", locations)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use locations list instead""")
    def descriptions(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "descriptions")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="locationIds")
    @_utilities.deprecated("""Use locations list instead""")
    def location_ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "location_ids")

    @_builtins.property
    @pulumi.getter
    def locations(self) -> Sequence['outputs.GetLocationsLocationResult']:
        return pulumi.get(self, "locations")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use locations list instead""")
    def names(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "names")


class AwaitableGetLocationsResult(GetLocationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLocationsResult(
            descriptions=self.descriptions,
            id=self.id,
            location_ids=self.location_ids,
            locations=self.locations,
            names=self.names)


def get_locations(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLocationsResult:
    """
    Provides a list of available Hetzner Cloud Locations.

    This resource may be useful to create highly available infrastructure, distributed across several locations.
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('hcloud:index/getLocations:getLocations', __args__, opts=opts, typ=GetLocationsResult).value

    return AwaitableGetLocationsResult(
        descriptions=pulumi.get(__ret__, 'descriptions'),
        id=pulumi.get(__ret__, 'id'),
        location_ids=pulumi.get(__ret__, 'location_ids'),
        locations=pulumi.get(__ret__, 'locations'),
        names=pulumi.get(__ret__, 'names'))
def get_locations_output(opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLocationsResult]:
    """
    Provides a list of available Hetzner Cloud Locations.

    This resource may be useful to create highly available infrastructure, distributed across several locations.
    """
    __args__ = dict()
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('hcloud:index/getLocations:getLocations', __args__, opts=opts, typ=GetLocationsResult)
    return __ret__.apply(lambda __response__: GetLocationsResult(
        descriptions=pulumi.get(__response__, 'descriptions'),
        id=pulumi.get(__response__, 'id'),
        location_ids=pulumi.get(__response__, 'location_ids'),
        locations=pulumi.get(__response__, 'locations'),
        names=pulumi.get(__response__, 'names')))
