# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetSshKeyResult',
    'AwaitableGetSshKeyResult',
    'get_ssh_key',
    'get_ssh_key_output',
]

@pulumi.output_type
class GetSshKeyResult:
    """
    A collection of values returned by getSshKey.
    """
    def __init__(__self__, fingerprint=None, id=None, labels=None, name=None, public_key=None, selector=None, with_selector=None):
        if fingerprint and not isinstance(fingerprint, str):
            raise TypeError("Expected argument 'fingerprint' to be a str")
        pulumi.set(__self__, "fingerprint", fingerprint)
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if public_key and not isinstance(public_key, str):
            raise TypeError("Expected argument 'public_key' to be a str")
        pulumi.set(__self__, "public_key", public_key)
        if selector and not isinstance(selector, str):
            raise TypeError("Expected argument 'selector' to be a str")
        pulumi.set(__self__, "selector", selector)
        if with_selector and not isinstance(with_selector, str):
            raise TypeError("Expected argument 'with_selector' to be a str")
        pulumi.set(__self__, "with_selector", with_selector)

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> Optional[_builtins.str]:
        """
        Fingerprint of the SSH Key.
        """
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.int]:
        """
        ID of the SSH Key.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        User-defined [labels](https://docs.hetzner.cloud/reference/cloud#labels) (key-value pairs) for the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the SSH Key.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> _builtins.str:
        """
        Public key of the SSH Key pair.
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Please use the with_selector property instead.""")
    def selector(self) -> Optional[_builtins.str]:
        """
        Filter results using a [Label Selector](https://docs.hetzner.cloud/reference/cloud#label-selector).
        """
        return pulumi.get(self, "selector")

    @_builtins.property
    @pulumi.getter(name="withSelector")
    def with_selector(self) -> Optional[_builtins.str]:
        """
        Filter results using a [Label Selector](https://docs.hetzner.cloud/reference/cloud#label-selector).
        """
        return pulumi.get(self, "with_selector")


class AwaitableGetSshKeyResult(GetSshKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSshKeyResult(
            fingerprint=self.fingerprint,
            id=self.id,
            labels=self.labels,
            name=self.name,
            public_key=self.public_key,
            selector=self.selector,
            with_selector=self.with_selector)


def get_ssh_key(fingerprint: Optional[_builtins.str] = None,
                id: Optional[_builtins.int] = None,
                name: Optional[_builtins.str] = None,
                selector: Optional[_builtins.str] = None,
                with_selector: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSshKeyResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_hcloud as hcloud

    by_id = hcloud.get_ssh_key(id=24332897)
    by_name = hcloud.get_ssh_key(name="my-ssh-key")
    by_fingerprint = hcloud.get_ssh_key(fingerprint="55:58:dc:bd:61:6e:7d:24:07:a7:7d:9b:be:99:83:a8")
    by_label = hcloud.get_ssh_key(with_selector="key=value")
    main = hcloud.Server("main", ssh_keys=[
        by_id.id,
        by_name.id,
        by_fingerprint.id,
    ])
    ```


    :param _builtins.str fingerprint: Fingerprint of the SSH Key.
    :param _builtins.int id: ID of the SSH Key.
    :param _builtins.str name: Name of the SSH Key.
    :param _builtins.str selector: Filter results using a [Label Selector](https://docs.hetzner.cloud/reference/cloud#label-selector).
    :param _builtins.str with_selector: Filter results using a [Label Selector](https://docs.hetzner.cloud/reference/cloud#label-selector).
    """
    __args__ = dict()
    __args__['fingerprint'] = fingerprint
    __args__['id'] = id
    __args__['name'] = name
    __args__['selector'] = selector
    __args__['withSelector'] = with_selector
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('hcloud:index/getSshKey:getSshKey', __args__, opts=opts, typ=GetSshKeyResult).value

    return AwaitableGetSshKeyResult(
        fingerprint=pulumi.get(__ret__, 'fingerprint'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        public_key=pulumi.get(__ret__, 'public_key'),
        selector=pulumi.get(__ret__, 'selector'),
        with_selector=pulumi.get(__ret__, 'with_selector'))
def get_ssh_key_output(fingerprint: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       id: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                       name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       selector: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       with_selector: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSshKeyResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_hcloud as hcloud

    by_id = hcloud.get_ssh_key(id=24332897)
    by_name = hcloud.get_ssh_key(name="my-ssh-key")
    by_fingerprint = hcloud.get_ssh_key(fingerprint="55:58:dc:bd:61:6e:7d:24:07:a7:7d:9b:be:99:83:a8")
    by_label = hcloud.get_ssh_key(with_selector="key=value")
    main = hcloud.Server("main", ssh_keys=[
        by_id.id,
        by_name.id,
        by_fingerprint.id,
    ])
    ```


    :param _builtins.str fingerprint: Fingerprint of the SSH Key.
    :param _builtins.int id: ID of the SSH Key.
    :param _builtins.str name: Name of the SSH Key.
    :param _builtins.str selector: Filter results using a [Label Selector](https://docs.hetzner.cloud/reference/cloud#label-selector).
    :param _builtins.str with_selector: Filter results using a [Label Selector](https://docs.hetzner.cloud/reference/cloud#label-selector).
    """
    __args__ = dict()
    __args__['fingerprint'] = fingerprint
    __args__['id'] = id
    __args__['name'] = name
    __args__['selector'] = selector
    __args__['withSelector'] = with_selector
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('hcloud:index/getSshKey:getSshKey', __args__, opts=opts, typ=GetSshKeyResult)
    return __ret__.apply(lambda __response__: GetSshKeyResult(
        fingerprint=pulumi.get(__response__, 'fingerprint'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        public_key=pulumi.get(__response__, 'public_key'),
        selector=pulumi.get(__response__, 'selector'),
        with_selector=pulumi.get(__response__, 'with_selector')))
