# MACT Security Architecture - Quick Reference

```
┌────────────────────────────────────────────────────────────────────────┐
│                         CLIENT SIDE (Public)                           │
├────────────────────────────────────────────────────────────────────────┤
│                                                                        │
│  👨‍💻 Developer's Laptop                                                │
│  ┌──────────────────────────────────────────────────────────────────┐ │
│  │  $ pip install git+https://github.com/YOUR_USERNAME/M-ACT.git    │ │
│  │                                                                  │ │
│  │  Installs:                                                       │ │
│  │  ✅ mact command (client CLI)                                   │ │
│  │  ✅ frpc binary (tunnel client)                                 │ │
│  │  ❌ mact-admin (excluded from package)                          │ │
│  │                                                                  │ │
│  │  $ mact create MyProject -port 3000                             │ │
│  │    ↓                                                             │ │
│  │    HTTP POST https://m-act.live/rooms/create                    │ │
│  │    NO AUTHENTICATION REQUIRED ✅                                │ │
│  └──────────────────────────────────────────────────────────────────┘ │
│                                                                        │
└────────────────────────────────────────────────────────────────────────┘
                                    ↓
                                    │ HTTPS (public endpoints)
                                    ↓
┌────────────────────────────────────────────────────────────────────────┐
│                      SERVER SIDE (DigitalOcean)                        │
├────────────────────────────────────────────────────────────────────────┤
│                                                                        │
│  🌐 Nginx (Port 443) - Public Facing                                  │
│  ┌──────────────────────────────────────────────────────────────────┐ │
│  │  https://m-act.live                                              │ │
│  │  https://project-name.m-act.live                                 │ │
│  │                                                                  │ │
│  │  Routes to:                                                      │ │
│  │  • /rooms/* → Backend (127.0.0.1:5000)                          │ │
│  │  • /admin/* → Backend (127.0.0.1:5000) [REQUIRES AUTH]          │ │
│  │  • /* → Proxy (127.0.0.1:9000)                                  │ │
│  └──────────────────────────────────────────────────────────────────┘ │
│                         ↓                                              │
│  📦 Backend (Port 5000) - Localhost Only                              │
│  ┌──────────────────────────────────────────────────────────────────┐ │
│  │  listen: 127.0.0.1:5000 (NOT 0.0.0.0) 🔒                        │ │
│  │                                                                  │ │
│  │  Public Endpoints (No Auth):                                    │ │
│  │  ✅ POST /rooms/create                                          │ │
│  │  ✅ POST /rooms/join                                            │ │
│  │  ✅ GET /rooms/status                                           │ │
│  │                                                                  │ │
│  │  Admin Endpoints (Auth Required):                               │ │
│  │  🔒 GET /admin/rooms      [Bearer ADMIN_AUTH_TOKEN]            │ │
│  │  🔒 DELETE /admin/rooms/<id>  [Bearer ADMIN_AUTH_TOKEN]        │ │
│  │                                                                  │ │
│  │  Environment:                                                    │ │
│  │  ADMIN_AUTH_TOKEN=Kx3mP8nQ2rT5vL9wZ1aB... (32 chars)           │ │
│  └──────────────────────────────────────────────────────────────────┘ │
│                         ↑                                              │
│                         │ localhost:5000 only                          │
│                         │                                              │
│  🔧 Admin Terminal (SSH Access Required)                              │
│  ┌──────────────────────────────────────────────────────────────────┐ │
│  │  $ ssh root@m-act.live                                           │ │
│  │  (Requires SSH key) 🔑                                           │ │
│  │                                                                  │ │
│  │  $ export ADMIN_AUTH_TOKEN=Kx3mP8nQ2rT5vL9wZ1aB...              │ │
│  │  (Same token as backend) 🔑                                      │ │
│  │                                                                  │ │
│  │  $ mact-admin rooms list                                         │ │
│  │    ↓                                                             │ │
│  │    HTTP GET http://localhost:5000/admin/rooms                   │ │
│  │    Headers: Authorization: Bearer ADMIN_AUTH_TOKEN              │ │
│  │    TWO-LAYER AUTH: SSH + Token 🔒🔒                             │ │
│  └──────────────────────────────────────────────────────────────────┘ │
│                                                                        │
└────────────────────────────────────────────────────────────────────────┘


═══════════════════════════════════════════════════════════════════════════
                            ACCESS MATRIX
═══════════════════════════════════════════════════════════════════════════

┌──────────────────┬─────────────────┬──────────────────┬──────────────────┐
│ Action           │ Public Client   │ Admin (No SSH)   │ Admin (SSH + Token) │
├──────────────────┼─────────────────┼──────────────────┼──────────────────┤
│ Create Room      │ ✅ Yes          │ ❌ No            │ ✅ Yes           │
│ Join Room        │ ✅ Yes          │ ❌ No            │ ✅ Yes           │
│ View Own Room    │ ✅ Yes          │ ❌ No            │ ✅ Yes           │
│ View All Rooms   │ ❌ No           │ ❌ No            │ ✅ Yes           │
│ Delete Any Room  │ ❌ No           │ ❌ No            │ ✅ Yes           │
│ Kick Users       │ ❌ No           │ ❌ No            │ ✅ Yes           │
│ View System Logs │ ❌ No           │ ❌ No            │ ✅ Yes           │
│ System Health    │ ❌ No           │ ❌ No            │ ✅ Yes           │
└──────────────────┴─────────────────┴──────────────────┴──────────────────┘


═══════════════════════════════════════════════════════════════════════════
                          AUTHENTICATION FLOW
═══════════════════════════════════════════════════════════════════════════

PUBLIC CLIENT (Developer):
┌─────────────────────────────────────────────────────────────────────┐
│ 1. pip install mact-cli from GitHub                                 │
│ 2. mact create ProjectName -port 3000                               │
│ 3. CLI sends: POST /rooms/create (no auth header)                   │
│ 4. Backend: ✅ Allow (public endpoint)                              │
│ 5. Room created successfully                                        │
└─────────────────────────────────────────────────────────────────────┘

ADMIN (Server Administrator):
┌─────────────────────────────────────────────────────────────────────┐
│ 1. ssh root@m-act.live (requires SSH key) 🔑                        │
│ 2. export ADMIN_AUTH_TOKEN=secure-token (requires knowledge) 🔑     │
│ 3. mact-admin rooms list                                             │
│ 4. CLI sends: GET /admin/rooms                                       │
│    Headers: Authorization: Bearer secure-token                       │
│ 5. Backend checks:                                                   │
│    ❓ Is Authorization header present? → Yes ✅                     │
│    ❓ Does token match ADMIN_AUTH_TOKEN? → Yes ✅                   │
│ 6. Backend: ✅ Allow (authenticated)                                │
│ 7. Returns list of all rooms                                         │
└─────────────────────────────────────────────────────────────────────┘

UNAUTHORIZED ACCESS ATTEMPT:
┌─────────────────────────────────────────────────────────────────────┐
│ 1. Developer tries: curl https://m-act.live/admin/rooms             │
│ 2. Backend checks:                                                   │
│    ❓ Is Authorization header present? → No ❌                      │
│ 3. Backend: ❌ 401 Unauthorized                                     │
│ 4. Access denied                                                     │
└─────────────────────────────────────────────────────────────────────┘


═══════════════════════════════════════════════════════════════════════════
                         SECURITY LAYERS
═══════════════════════════════════════════════════════════════════════════

Layer 1: Network Isolation
┌────────────────────────────────────────┐
│ Backend listens on 127.0.0.1:5000     │
│ NOT accessible from internet directly  │
│ Only Nginx can reach it (same machine) │
└────────────────────────────────────────┘
            ↓
Layer 2: SSH Access Control
┌────────────────────────────────────────┐
│ Admin CLI only works on server         │
│ Requires SSH to access server          │
│ SSH requires key-based authentication  │
└────────────────────────────────────────┘
            ↓
Layer 3: Token Authentication
┌────────────────────────────────────────┐
│ Admin endpoints check ADMIN_AUTH_TOKEN │
│ Token must be 32+ random characters    │
│ Token rotated every 90 days            │
└────────────────────────────────────────┘
            ↓
Layer 4: Rate Limiting (Future)
┌────────────────────────────────────────┐
│ Prevent brute force token guessing     │
│ Limit room creation rate               │
│ Monitor for abuse patterns             │
└────────────────────────────────────────┘


═══════════════════════════════════════════════════════════════════════════
                     WHERE TO SET ADMIN_AUTH_TOKEN
═══════════════════════════════════════════════════════════════════════════

📁 Location 1: Backend Environment File (REQUIRED)
─────────────────────────────────────────────────
File: /opt/mact/deployment/mact-backend.env

Content:
┌──────────────────────────────────────────────────────┐
│ FLASK_ENV=production                                 │
│ BACKEND_PORT=5000                                    │
│ BACKEND_HOST=127.0.0.1                               │
│ ADMIN_AUTH_TOKEN=Kx3mP8nQ2rT5vL9wZ1aB4cD6eF7gH0iJ    │
│ CORS_ORIGINS=https://m-act.live,https://*.m-act.live│
│ LOG_LEVEL=INFO                                       │
└──────────────────────────────────────────────────────┘

How to set:
$ sudo nano /opt/mact/deployment/mact-backend.env
# Add the ADMIN_AUTH_TOKEN line
$ sudo systemctl restart mact-backend


📁 Location 2: Admin User Shell (REQUIRED for CLI)
───────────────────────────────────────────────────
File: ~/.bashrc

Content:
┌──────────────────────────────────────────────────────┐
│ # MACT Admin Token                                   │
│ export ADMIN_AUTH_TOKEN=Kx3mP8nQ2rT5vL9wZ1aB4cD6eF... │
└──────────────────────────────────────────────────────┘

How to set:
$ echo 'export ADMIN_AUTH_TOKEN=your-token' >> ~/.bashrc
$ source ~/.bashrc
$ echo $ADMIN_AUTH_TOKEN  # Verify it's set


🔐 How to Generate Secure Token
────────────────────────────────
$ python3 -c "import secrets; print(secrets.token_urlsafe(32))"
Output: Kx3mP8nQ2rT5vL9wZ1aB4cD6eF7gH0iJk2Lm3Nn4O

Copy this output and use it in BOTH locations above.


═══════════════════════════════════════════════════════════════════════════
                         QUICK CHECKLIST
═══════════════════════════════════════════════════════════════════════════

Setup Admin Access:
□ Generate token: python3 -c "import secrets; print(secrets.token_urlsafe(32))"
□ Add to backend env: echo "ADMIN_AUTH_TOKEN=..." >> /opt/mact/deployment/mact-backend.env
□ Add to shell: echo "export ADMIN_AUTH_TOKEN=..." >> ~/.bashrc
□ Restart backend: sudo systemctl restart mact-backend
□ Test: mact-admin rooms list

Verify Security:
□ Backend listens on 127.0.0.1:5000 (NOT 0.0.0.0)
□ SSH uses key-based auth (not passwords)
□ Admin token is 32+ characters
□ Token not committed to git
□ UFW firewall enabled
□ Nginx properly configured

Test Public Access:
□ Developer can: mact create TestProject -port 3000
□ Developer cannot: curl https://m-act.live/admin/rooms

Test Admin Access:
□ SSH to server works
□ mact-admin --help works
□ mact-admin system health shows status
□ mact-admin rooms list shows all rooms
```
