# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# import os
# import sys
# sys.path.insert(0, os.path.abspath('.'))
# import os
# import sys
# sys.path.insert(0, os.path.abspath('..'))
import os, sys, pathlib, importlib, types
ROOT = pathlib.Path(__file__).resolve().parents[2]  # repo root
sys.path.insert(0, str(ROOT / "src"))               # src/ layout

# TEMP shim for bad "import Modules" statements
try:
    sys.modules["Modules"] = importlib.import_module("el1xr_opt.Modules")
except Exception:
    sys.modules.setdefault("Modules", types.ModuleType("Modules"))


# -- Project information -----------------------------------------------------

project = ''
copyright = '2025, EL1XR-dev'
author = 'EL1XR-dev Team: Erik F. Alvarez'

# The short X.Y version
version = 'version 1.0.1'
# The full version, including alpha/beta/rc tags
release = ''


# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.todo',
    'sphinx.ext.githubpages',
    "sphinx.ext.autodoc",
    "sphinx.ext.autosummary",
    "sphinx.ext.napoleon",
    "sphinx.ext.viewcode",
    "sphinx.ext.intersphinx",
    "sphinx.ext.mathjax",
    "sphinx_copybutton",
    "sphinx_autodoc_typehints",
]
autosummary_generate = False
napoleon_google_docstring = False
napoleon_numpy_docstring = False

autodoc_mock_imports = [
    "pyomo",
    "gurobipy",
    "gurobi",
    # add any other large/optional deps used only at runtime
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
# language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
# html_theme_options = {}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = []

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# The default sidebars (for documents that don't match any pattern) are
# defined by theme itself.  Builtin themes are using these templates by
# default: ``['localtoc.html', 'relations.html', 'sourcelink.html',
# 'searchbox.html']``.
#
# html_sidebars = {}
html_theme = "sphinx_book_theme"
html_logo  = '../img/el1xr_opt_logo_v6.png'
html_theme_options = {
    "repository_url": "https://github.com/EL1XR-dev/el1xr_opt",
    "use_repository_button": True,
    "use_issues_button": True,
}
# Do NOT set footer_start/footer_end/navbar_*/*extra* items that include "about.html"

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

html_js_files = [
    '../custom.js',
]
