TRIVY_SAMPLE = {
    "SchemaVersion": 2,
    "CreatedAt": "2025-05-17T13:51:07.592255-07:00",
    "ArtifactName": "000000000000.dkr.ecr.us-east-1.amazonaws.com/test-repository:1234567890",
    "ArtifactType": "container_image",
    "Metadata": {
        "Size": 1037615616,
        "OS": {"Family": "debian", "Name": "12.8"},
        "ImageID": "sha256:4ed21711a31e7d5f6be9b4ab4f2810c472bf62113fb207790bc3333a4e70bac1",
        "DiffIDs": [
            "sha256:c0f1022b22a9b36851b358f44e5475e39d166e71a8073cf53c894a299239b1c5",
            "sha256:5d3c0bf69709b57971680491ecc0c36aa3fe7a6fea6905646820de6d9351eb8e",
            "sha256:51de1a91f98c3b0e9079cc9262b0efd0558960edb61ee6b9b504dbc148d65a06",
            "sha256:2e874c52d16267c79ae1d3e3e9b6e50de44e3540e76aeb1089481c459680a5af",
            "sha256:49eaa3f858d92a216dcdbd5483e9f03b9c51bc116d70180d36fb679b60fed4e6",
            "sha256:27e7ee08596e87e6f0c586faa6a234358c43423444d646338768e0ae98ce4d4f",
            "sha256:6c69440d610b696680a4f8a5926758da18c9235593afd5f0bf4346d84a3081f2",
            "sha256:61bf605c951ee9608dd78e8b84991903e65a44e81d628f70fe4a4789d917ac36",
            "sha256:08bbaabad23800155ef9736e4133da5b141c131aa11718dd387ba50594bd8612",
        ],
        "RepoTags": [
            "000000000000.dkr.ecr.us-east-1.amazonaws.com/test-repository:1234567890"
        ],
        "RepoDigests": [
            "000000000000.dkr.ecr.us-east-1.amazonaws.com/test-repository@sha256:88016fd13f6aa39b702c1714662"
        ],
        "ImageConfig": {
            "architecture": "amd64",
            "created": "2025-04-10T20:05:25.187632619Z",
            "history": [
                {
                    "created": "2024-10-18T23:23:40Z",
                    "created_by": "# debian.sh --arch 'amd64' out/ 'bookworm' '@1733097600'",
                    "comment": "debuerreotype 0.15",
                },
                {
                    "created": "2024-10-18T23:23:40Z",
                    "created_by": "ENV PATH=/usr/local/bin:/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin",
                    "comment": "buildkit.dockerfile.v0",
                    "empty_layer": True,
                },
                {
                    "created": "2024-10-18T23:23:40Z",
                    "created_by": "RUN /bin/sh -c set -eux; \tapt-get update; \tapt-get install -y --no-install-recommends \t\tca-certificates \t\tnetbase \t\ttzdata \t; \trm -rf /var/lib/apt/lists/* # buildkit",
                    "comment": "buildkit.dockerfile.v0",
                },
                {
                    "created": "2024-10-18T23:23:40Z",
                    "created_by": "ENV GPG_KEY=1234",
                    "comment": "buildkit.dockerfile.v0",
                    "empty_layer": True,
                },
                {
                    "created": "2024-10-18T23:23:40Z",
                    "created_by": "ENV PYTHON_VERSION=3.13.0",
                    "comment": "buildkit.dockerfile.v0",
                    "empty_layer": True,
                },
                {
                    "created": "2024-10-18T23:23:40Z",
                    "created_by": "ENV PYTHON_SHA256=086de5882e3cb310d4dca48457522e2e48018ecd43da9cdf827f6a0759efb07d",
                    "comment": "buildkit.dockerfile.v0",
                    "empty_layer": True,
                },
                {
                    "created": "2024-10-18T23:23:40Z",
                    "created_by": 'RUN /bin/sh -c set -eux; \t\tsavedAptMark="$(apt-mark showmanual)"; \tapt-get update; \tapt-get install -y --no-install-recommends \t\tdpkg-dev \t\tgcc \t\tgnupg \t\tlibbluetooth-dev \t\tlibbz2-dev \t\tlibc6-dev \t\tlibdb-dev \t\tlibffi-dev \t\tlibgdbm-dev \t\tliblzma-dev \t\tlibncursesw5-dev \t\tlibreadline-dev \t\tlibsqlite3-dev \t\tlibssl-dev \t\tmake \t\ttk-dev \t\tuuid-dev \t\twget \t\txz-utils \t\tzlib1g-dev \t; \t\twget -O python.tar.xz "https://www.python.org/ftp/python/${PYTHON_VERSION%%[a-z]*}/Python-$PYTHON_VERSION.tar.xz"; \techo "$PYTHON_SHA256 *python.tar.xz" | sha256sum -c -; \twget -O python.tar.xz.asc "https://www.python.org/ftp/python/${PYTHON_VERSION%%[a-z]*}/Python-$PYTHON_VERSION.tar.xz.asc"; \tGNUPGHOME="$(mktemp -d)"; export GNUPGHOME; \tgpg --batch --keyserver hkps://keys.openpgp.org --recv-keys "$GPG_KEY"; \tgpg --batch --verify python.tar.xz.asc python.tar.xz; \tgpgconf --kill all; \trm -rf "$GNUPGHOME" python.tar.xz.asc; \tmkdir -p /usr/src/python; \ttar --extract --directory /usr/src/python --strip-components=1 --file python.tar.xz; \trm python.tar.xz; \t\tcd /usr/src/python; \tgnuArch="$(dpkg-architecture --query DEB_BUILD_GNU_TYPE)"; \t./configure \t\t--build="$gnuArch" \t\t--enable-loadable-sqlite-extensions \t\t--enable-optimizations \t\t--enable-option-checking=fatal \t\t--enable-shared \t\t--with-lto \t\t--with-ensurepip \t; \tnproc="$(nproc)"; \tEXTRA_CFLAGS="$(dpkg-buildflags --get CFLAGS)"; \tLDFLAGS="$(dpkg-buildflags --get LDFLAGS)"; \tLDFLAGS="${LDFLAGS:--Wl},--strip-all"; \tmake -j "$nproc" \t\t"EXTRA_CFLAGS=${EXTRA_CFLAGS:-}" \t\t"LDFLAGS=${LDFLAGS:-}" \t; \trm python; \tmake -j "$nproc" \t\t"EXTRA_CFLAGS=${EXTRA_CFLAGS:-}" \t\t"LDFLAGS=${LDFLAGS:--Wl},-rpath=\'\\$\\$ORIGIN/../lib\'" \t\tpython \t; \tmake install; \t\tcd /; \trm -rf /usr/src/python; \t\tfind /usr/local -depth \t\t\\( \t\t\t\\( -type d -a \\( -name test -o -name tests -o -name idle_test \\) \\) \t\t\t-o \\( -type f -a \\( -name \'*.pyc\' -o -name \'*.pyo\' -o -name \'libpython*.a\' \\) \\) \t\t\\) -exec rm -rf \'{}\' + \t; \t\tldconfig; \t\tapt-mark auto \'.*\' \u003e /dev/null; \tapt-mark manual $savedAptMark; \tfind /usr/local -type f -executable -not \\( -name \'*tkinter*\' \\) -exec ldd \'{}\' \';\' \t\t| awk \'/=\u003e/ { so = $(NF-1); if (index(so, "/usr/local/") == 1) { next }; gsub("^/(usr/)?", "", so); printf "*%s\\n", so }\' \t\t| sort -u \t\t| xargs -r dpkg-query --search \t\t| cut -d: -f1 \t\t| sort -u \t\t| xargs -r apt-mark manual \t; \tapt-get purge -y --auto-remove -o APT::AutoRemove::RecommendsImportant=false; \trm -rf /var/lib/apt/lists/*; \t\texport PYTHONDONTWRITEBYTECODE=1; \tpython3 --version; \tpip3 --version # buildkit',
                    "comment": "buildkit.dockerfile.v0",
                },
                {
                    "created": "2024-10-18T23:23:40Z",
                    "created_by": 'RUN /bin/sh -c set -eux; \tfor src in idle3 pip3 pydoc3 python3 python3-config; do \t\tdst="$(echo "$src" | tr -d 3)"; \t\t[ -s "/usr/local/bin/$src" ]; \t\t[ ! -e "/usr/local/bin/$dst" ]; \t\tln -svT "$src" "/usr/local/bin/$dst"; \tdone # buildkit',
                    "comment": "buildkit.dockerfile.v0",
                },
                {
                    "created": "2024-10-18T23:23:40Z",
                    "created_by": 'CMD ["python3"]',
                    "comment": "buildkit.dockerfile.v0",
                    "empty_layer": True,
                },
                {
                    "created": "2025-04-10T20:04:15.082458834Z",
                    "created_by": "RUN /bin/sh -c useradd -m -s /bin/bash myuser # buildkit",
                    "comment": "buildkit.dockerfile.v0",
                },
                {
                    "created": "2025-04-10T20:04:15.105197285Z",
                    "created_by": "WORKDIR /app",
                    "comment": "buildkit.dockerfile.v0",
                },
                {
                    "created": "2025-04-10T20:04:15.131458903Z",
                    "created_by": "COPY . . # buildkit",
                    "comment": "buildkit.dockerfile.v0",
                },
                {
                    "created": "2025-04-10T20:05:22.038231224Z",
                    "created_by": "RUN /bin/sh -c pip install --no-cache-dir . # buildkit",
                    "comment": "buildkit.dockerfile.v0",
                },
                {
                    "created": "2025-04-10T20:05:25.187632619Z",
                    "created_by": "RUN /bin/sh -c apt-get update \u0026\u0026     apt-get install -y curl dumb-init \u0026\u0026     rm -rf /var/lib/apt/lists/* # buildkit",
                    "comment": "buildkit.dockerfile.v0",
                },
                {
                    "created": "2025-04-10T20:05:25.187632619Z",
                    "created_by": "ENV PYTHONUNBUFFERED=1",
                    "comment": "buildkit.dockerfile.v0",
                    "empty_layer": True,
                },
                {
                    "created": "2025-04-10T20:05:25.187632619Z",
                    "created_by": "ENV PYTHONIOENCODING=utf-8",
                    "comment": "buildkit.dockerfile.v0",
                    "empty_layer": True,
                },
                {
                    "created": "2025-04-10T20:05:25.187632619Z",
                    "created_by": "ENV PYTHONPATH=/app",
                    "comment": "buildkit.dockerfile.v0",
                    "empty_layer": True,
                },
                {
                    "created": "2025-04-10T20:05:25.187632619Z",
                    "created_by": "USER myuser",
                    "comment": "buildkit.dockerfile.v0",
                    "empty_layer": True,
                },
                {
                    "created": "2025-04-10T20:05:25.187632619Z",
                    "created_by": "EXPOSE map[8000/tcp:{}]",
                    "comment": "buildkit.dockerfile.v0",
                    "empty_layer": True,
                },
                {
                    "created": "2025-04-10T20:05:25.187632619Z",
                    "created_by": 'HEALTHCHECK \u0026{["CMD-SHELL" "curl -f http://localhost:8000/health || exit 1"] "30s" "30s" "5s" "0s" \'\\x03\'}',
                    "comment": "buildkit.dockerfile.v0",
                    "empty_layer": True,
                },
                {
                    "created": "2025-04-10T20:05:25.187632619Z",
                    "created_by": 'ENTRYPOINT ["dumb-init" "--"]',
                    "comment": "buildkit.dockerfile.v0",
                    "empty_layer": True,
                },
                {
                    "created": "2025-04-10T20:05:25.187632619Z",
                    "created_by": 'CMD ["uvicorn" "app.main:app" "--host" "0.0.0.0" "--port" "8000" "--log-level" "debug"]',
                    "comment": "buildkit.dockerfile.v0",
                    "empty_layer": True,
                },
            ],
            "os": "linux",
            "rootfs": {
                "type": "layers",
                "diff_ids": [
                    "sha256:c0f1022b22a9b36851b358f44e5475e39d166e71a8073cf53c894a299239b1c5",
                    "sha256:5d3c0bf69709b57971680491ecc0c36aa3fe7a6fea6905646820de6d9351eb8e",
                    "sha256:51de1a91f98c3b0e9079cc9262b0efd0558960edb61ee6b9b504dbc148d65a06",
                    "sha256:2e874c52d16267c79ae1d3e3e9b6e50de44e3540e76aeb1089481c459680a5af",
                    "sha256:49eaa3f858d92a216dcdbd5483e9f03b9c51bc116d70180d36fb679b60fed4e6",
                    "sha256:27e7ee08596e87e6f0c586faa6a234358c43423444d646338768e0ae98ce4d4f",
                    "sha256:6c69440d610b696680a4f8a5926758da18c9235593afd5f0bf4346d84a3081f2",
                    "sha256:61bf605c951ee9608dd78e8b84991903e65a44e81d628f70fe4a4789d917ac36",
                    "sha256:08bbaabad23800155ef9736e4133da5b141c131aa11718dd387ba50594bd8612",
                ],
            },
            "config": {
                "Cmd": [
                    "uvicorn",
                    "app.main:app",
                    "--host",
                    "0.0.0.0",
                    "--port",
                    "8000",
                    "--log-level",
                    "debug",
                ],
                "Healthcheck": {
                    "Test": [
                        "CMD-SHELL",
                        "curl -f http://localhost:8000/health || exit 1",
                    ],
                    "Interval": 30000000000,
                    "Timeout": 30000000000,
                    "StartPeriod": 5000000000,
                    "Retries": 3,
                },
                "Entrypoint": ["dumb-init", "--"],
                "Env": [
                    "PATH=/usr/local/bin:/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin",
                    "GPG_KEY=7169605F62C751356D054A26A821E680E5FA6305",
                    "PYTHON_VERSION=3.13.0",
                    "PYTHON_SHA256=086de5882e3cb310d4dca48457522e2e48018ecd43da9cdf827f6a0759efb07d",
                    "PYTHONUNBUFFERED=1",
                    "PYTHONIOENCODING=utf-8",
                    "PYTHONPATH=/app",
                ],
                "User": "myuser",
                "WorkingDir": "/app",
                "ExposedPorts": {"8000/tcp": {}},
                "ArgsEscaped": True,
            },
        },
        "Layers": [
            {
                "Size": 77885440,
                "Digest": "sha256:8cf9fb7a0b56cf93bf2502aff8087344f2dd06e29fb027b0c06aa2726ab3eda8",
                "DiffID": "sha256:c0f1022b22a9b36851b358f44e5475e39d166e71a8073cf53c894a299239b1c5",
            },
            {
                "Size": 8792064,
                "Digest": "sha256:dcccf87d013dafa7f4bd6b72c6c3c1f5a3a347e626690a07568d0a925cfb262e",
                "DiffID": "sha256:5d3c0bf69709b57971680491ecc0c36aa3fe7a6fea6905646820de6d9351eb8e",
            },
            {
                "Size": 38065152,
                "Digest": "sha256:acee09de1c5d11742e97e43b537a9c6dd6ec1346a50b75e9b68f39de44a4216f",
                "DiffID": "sha256:51de1a91f98c3b0e9079cc9262b0efd0558960edb61ee6b9b504dbc148d65a06",
            },
            {
                "Size": 5120,
                "Digest": "sha256:a576ef79af7ef1fe063c34530a90c344f6d622795c713ff9f2a771f3edc00cee",
                "DiffID": "sha256:2e874c52d16267c79ae1d3e3e9b6e50de44e3540e76aeb1089481c459680a5af",
            },
            {
                "Size": 20480,
                "Digest": "sha256:fdaf2ac62f09e481ce5c593489230dabec3f5495c2c5c6ef8214e095aced01e0",
                "DiffID": "sha256:49eaa3f858d92a216dcdbd5483e9f03b9c51bc116d70180d36fb679b60fed4e6",
            },
            {
                "Size": 1536,
                "Digest": "sha256:721b4aaffc5ab4fad3250e06fa516dd9f14e757fdd5511c8c7f72dd8920b3950",
                "DiffID": "sha256:27e7ee08596e87e6f0c586faa6a234358c43423444d646338768e0ae98ce4d4f",
            },
            {
                "Size": 205312,
                "Digest": "sha256:e80b22904d9d6c163cd262e443525280f528ee1a5a5a56096ba418f31076ef64",
                "DiffID": "sha256:6c69440d610b696680a4f8a5926758da18c9235593afd5f0bf4346d84a3081f2",
            },
            {
                "Size": 906178048,
                "Digest": "sha256:564dfad33fbd75c3d8a1ce6c0e6b3dfdb9e22a3d6aebe2b87df1c8072051463b",
                "DiffID": "sha256:61bf605c951ee9608dd78e8b84991903e65a44e81d628f70fe4a4789d917ac36",
            },
            {
                "Size": 6462464,
                "Digest": "sha256:e6d300c655d216ade160232a4caf78aef2b8dedb06aa1214d88da2815a51ca18",
                "DiffID": "sha256:08bbaabad23800155ef9736e4133da5b141c131aa11718dd387ba50594bd8612",
            },
        ],
    },
    "Results": [
        {
            "Target": "000000000000.dkr.ecr.us-east-1.amazonaws.com/test-repository:1234567890 (debian 12.8)",
            "Class": "os-pkgs",
            "Type": "debian",
            "Vulnerabilities": [
                {
                    "VulnerabilityID": "CVE-2023-4039",
                    "PkgID": "gcc-12-base@12.2.0-14",
                    "PkgName": "gcc-12-base",
                    "PkgIdentifier": {
                        "PURL": "pkg:deb/debian/gcc-12-base@12.2.0-14?arch=amd64\u0026distro=debian-12.8",
                        "UID": "9a668c24c45de553",
                    },
                    "InstalledVersion": "12.2.0-14",
                    "FixedVersion": "12.2.0-14+deb12u1",
                    "Status": "fixed",
                    "Layer": {
                        "Digest": "sha256:8cf9fb7a0b56cf93bf2502aff8087344f2dd06e29fb027b0c06aa2726ab3eda8",
                        "DiffID": "sha256:c0f1022b22a9b36851b358f44e5475e39d166e71a8073cf53c894a299239b1c5",
                    },
                    "SeveritySource": "debian",
                    "PrimaryURL": "https://avd.aquasec.com/nvd/cve-2023-4039",
                    "DataSource": {
                        "ID": "debian",
                        "Name": "Debian Security Tracker",
                        "URL": "https://salsa.debian.org/security-tracker-team/security-tracker",
                    },
                    "Title": "gcc: -fstack-protector fails to guard dynamic stack allocations on ARM64",
                    "Description": "**DISPUTED**A failure in the -fstack-protector feature in GCC-based toolchains \nthat target AArch64 allows an attacker to exploit an existing buffer \noverflow in dynamically-sized local variables in your application \nwithout this being detected. This stack-protector failure only applies \nto C99-style dynamically-sized local variables or those created using \nalloca(). The stack-protector operates as intended for statically-sized \nlocal variables.\n\nThe default behavior when the stack-protector \ndetects an overflow is to terminate your application, resulting in \ncontrolled loss of availability. An attacker who can exploit a buffer \noverflow without triggering the stack-protector might be able to change \nprogram flow control to cause an uncontrolled loss of availability or to\n go further and affect confidentiality or integrity. NOTE: The GCC project argues that this is a missed hardening bug and not a vulnerability by itself.",
                    "Severity": "LOW",
                    "CweIDs": ["CWE-693"],
                    "VendorSeverity": {
                        "amazon": 2,
                        "azure": 2,
                        "cbl-mariner": 2,
                        "debian": 1,
                        "nvd": 2,
                        "oracle-oval": 1,
                        "ubuntu": 1,
                    },
                    "CVSS": {
                        "nvd": {
                            "V3Vector": "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:L/I:L/A:N",
                            "V3Score": 4.8,
                        }
                    },
                    "References": [
                        "https://access.redhat.com/security/cve/CVE-2023-4039",
                        "https://developer.arm.com/Arm%20Security%20Center/GCC%20Stack%20Protector%20Vulnerability%20AArch64",
                        "https://gcc.gnu.org/git/?p=gcc.git;a=blob_plain;f=SECURITY.txt",
                        "https://gcc.gnu.org/pipermail/gcc-patches/2023-October/634066.html",
                        "https://github.com/metaredteam/external-disclosures/security/advisories/GHSA-x7ch-h5rf-w2mf",
                        "https://inbox.sourceware.org/gcc-patches/46cfa37b-56eb-344d-0745-e0d35393392d@gotplt.org",
                        "https://linux.oracle.com/cve/CVE-2023-4039.html",
                        "https://linux.oracle.com/errata/ELSA-2023-28766.html",
                        "https://nvd.nist.gov/vuln/detail/CVE-2023-4039",
                        "https://rtx.meta.security/mitigation/2023/09/12/CVE-2023-4039.html",
                        "https://www.cve.org/CVERecord?id=CVE-2023-4039",
                    ],
                    "PublishedDate": "2023-09-13T09:15:15.69Z",
                    "LastModifiedDate": "2025-02-13T17:17:14.717Z",
                },
                {
                    "VulnerabilityID": "CVE-2024-26462",
                    "PkgID": "krb5-locales@1.20.1-2+deb12u2",
                    "PkgName": "krb5-locales",
                    "PkgIdentifier": {
                        "PURL": "pkg:deb/debian/krb5-locales@1.20.1-2%2Bdeb12u2?arch=all\u0026distro=debian-12.8",
                        "UID": "b1c9fe20ecc3a63c",
                    },
                    "InstalledVersion": "1.20.1-2+deb12u2",
                    "FixedVersion": "1.20.1-2+deb12u3",
                    "Status": "fixed",
                    "Layer": {
                        "Digest": "sha256:e6d300c655d216ade160232a4caf78aef2b8dedb06aa1214d88da2815a51ca18",
                        "DiffID": "sha256:08bbaabad23800155ef9736e4133da5b141c131aa11718dd387ba50594bd8612",
                    },
                    "SeveritySource": "nvd",
                    "PrimaryURL": "https://avd.aquasec.com/nvd/cve-2024-26462",
                    "DataSource": {
                        "ID": "debian",
                        "Name": "Debian Security Tracker",
                        "URL": "https://salsa.debian.org/security-tracker-team/security-tracker",
                    },
                    "Title": "krb5: Memory leak at /krb5/src/kdc/ndr.c",
                    "Description": "Kerberos 5 (aka krb5) 1.21.2 contains a memory leak vulnerability in /krb5/src/kdc/ndr.c.",
                    "Severity": "MEDIUM",
                    "CweIDs": ["CWE-401"],
                    "VendorSeverity": {
                        "alma": 2,
                        "amazon": 2,
                        "azure": 2,
                        "nvd": 2,
                        "oracle-oval": 2,
                        "photon": 2,
                        "redhat": 2,
                        "ubuntu": 2,
                    },
                    "CVSS": {
                        "nvd": {
                            "V3Vector": "CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:H",
                            "V3Score": 5.5,
                        },
                        "redhat": {
                            "V3Vector": "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H",
                            "V3Score": 7.5,
                        },
                    },
                    "References": [
                        "https://access.redhat.com/errata/RHSA-2024:9331",
                        "https://access.redhat.com/security/cve/CVE-2024-26462",
                        "https://bugzilla.redhat.com/2266731",
                        "https://bugzilla.redhat.com/2266740",
                        "https://bugzilla.redhat.com/2266742",
                        "https://errata.almalinux.org/9/ALSA-2024-9331.html",
                        "https://github.com/LuMingYinDetect/krb5_defects/blob/main/krb5_detect_3.md",
                        "https://linux.oracle.com/cve/CVE-2024-26462.html",
                        "https://linux.oracle.com/errata/ELSA-2024-9331.html",
                        "https://mailman.mit.edu/pipermail/kerberos/2024-March/023095.html",
                        "https://nvd.nist.gov/vuln/detail/CVE-2024-26462",
                        "https://security.netapp.com/advisory/ntap-20240415-0012/",
                        "https://ubuntu.com/security/notices/USN-7314-1",
                        "https://www.cve.org/CVERecord?id=CVE-2024-26462",
                    ],
                    "PublishedDate": "2024-02-29T01:44:18.857Z",
                    "LastModifiedDate": "2025-03-25T20:15:21.143Z",
                },
                {
                    "VulnerabilityID": "CVE-2025-24528",
                    "PkgID": "krb5-locales@1.20.1-2+deb12u2",
                    "PkgName": "krb5-locales",
                    "PkgIdentifier": {
                        "PURL": "pkg:deb/debian/krb5-locales@1.20.1-2%2Bdeb12u2?arch=all\u0026distro=debian-12.8",
                        "UID": "b1c9fe20ecc3a63c",
                    },
                    "InstalledVersion": "1.20.1-2+deb12u2",
                    "FixedVersion": "1.20.1-2+deb12u3",
                    "Status": "fixed",
                    "Layer": {
                        "Digest": "sha256:e6d300c655d216ade160232a4caf78aef2b8dedb06aa1214d88da2815a51ca18",
                        "DiffID": "sha256:08bbaabad23800155ef9736e4133da5b141c131aa11718dd387ba50594bd8612",
                    },
                    "PrimaryURL": "https://avd.aquasec.com/nvd/cve-2025-24528",
                    "DataSource": {
                        "ID": "debian",
                        "Name": "Debian Security Tracker",
                        "URL": "https://salsa.debian.org/security-tracker-team/security-tracker",
                    },
                    "Title": "krb5: overflow when calculating ulog block size",
                    "Description": "A flaw was found in krb5. With incremental propagation enabled, an authenticated attacker can cause kadmind to write beyond the end of the mapped region for the iprop log file. This issue can trigger a process crash and lead to a denial of service.",
                    "Severity": "MEDIUM",
                    "VendorSeverity": {
                        "alma": 2,
                        "oracle-oval": 2,
                        "redhat": 2,
                        "rocky": 2,
                        "ubuntu": 2,
                    },
                    "CVSS": {
                        "redhat": {
                            "V3Vector": "CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:H",
                            "V3Score": 6.5,
                        }
                    },
                    "References": [
                        "https://access.redhat.com/errata/RHSA-2025:2722",
                        "https://access.redhat.com/security/cve/CVE-2025-24528",
                        "https://bugzilla.redhat.com/2342796",
                        "https://bugzilla.redhat.com/show_bug.cgi?id=2342796",
                        "https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2025-24528",
                        "https://errata.almalinux.org/8/ALSA-2025-2722.html",
                        "https://errata.rockylinux.org/RLSA-2025:2722",
                        "https://github.com/krb5/krb5/commit/78ceba024b64d49612375be4a12d1c066b0bfbd0",
                        "https://linux.oracle.com/cve/CVE-2025-24528.html",
                        "https://linux.oracle.com/errata/ELSA-2025-2722.html",
                        "https://nvd.nist.gov/vuln/detail/CVE-2025-24528",
                        "https://ubuntu.com/security/notices/USN-7314-1",
                        "https://www.cve.org/CVERecord?id=CVE-2025-24528",
                    ],
                },
                {
                    "VulnerabilityID": "CVE-2024-26462",
                    "PkgID": "libk5crypto3@1.20.1-2+deb12u2",
                    "PkgName": "libk5crypto3",
                    "PkgIdentifier": {
                        "PURL": "pkg:deb/debian/libk5crypto3@1.20.1-2%2Bdeb12u2?arch=amd64\u0026distro=debian-12.8",
                        "UID": "8ac3863f268e4e8e",
                    },
                    "InstalledVersion": "1.20.1-2+deb12u2",
                    "FixedVersion": "1.20.1-2+deb12u3",
                    "Status": "fixed",
                    "Layer": {
                        "Digest": "sha256:e6d300c655d216ade160232a4caf78aef2b8dedb06aa1214d88da2815a51ca18",
                        "DiffID": "sha256:08bbaabad23800155ef9736e4133da5b141c131aa11718dd387ba50594bd8612",
                    },
                    "SeveritySource": "nvd",
                    "PrimaryURL": "https://avd.aquasec.com/nvd/cve-2024-26462",
                    "DataSource": {
                        "ID": "debian",
                        "Name": "Debian Security Tracker",
                        "URL": "https://salsa.debian.org/security-tracker-team/security-tracker",
                    },
                    "Title": "krb5: Memory leak at /krb5/src/kdc/ndr.c",
                    "Description": "Kerberos 5 (aka krb5) 1.21.2 contains a memory leak vulnerability in /krb5/src/kdc/ndr.c.",
                    "Severity": "MEDIUM",
                    "CweIDs": ["CWE-401"],
                    "VendorSeverity": {
                        "alma": 2,
                        "amazon": 2,
                        "azure": 2,
                        "nvd": 2,
                        "oracle-oval": 2,
                        "photon": 2,
                        "redhat": 2,
                        "ubuntu": 2,
                    },
                    "CVSS": {
                        "nvd": {
                            "V3Vector": "CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:H",
                            "V3Score": 5.5,
                        },
                        "redhat": {
                            "V3Vector": "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H",
                            "V3Score": 7.5,
                        },
                    },
                    "References": [
                        "https://access.redhat.com/errata/RHSA-2024:9331",
                        "https://access.redhat.com/security/cve/CVE-2024-26462",
                        "https://bugzilla.redhat.com/2266731",
                        "https://bugzilla.redhat.com/2266740",
                        "https://bugzilla.redhat.com/2266742",
                        "https://errata.almalinux.org/9/ALSA-2024-9331.html",
                        "https://github.com/LuMingYinDetect/krb5_defects/blob/main/krb5_detect_3.md",
                        "https://linux.oracle.com/cve/CVE-2024-26462.html",
                        "https://linux.oracle.com/errata/ELSA-2024-9331.html",
                        "https://mailman.mit.edu/pipermail/kerberos/2024-March/023095.html",
                        "https://nvd.nist.gov/vuln/detail/CVE-2024-26462",
                        "https://security.netapp.com/advisory/ntap-20240415-0012/",
                        "https://ubuntu.com/security/notices/USN-7314-1",
                        "https://www.cve.org/CVERecord?id=CVE-2024-26462",
                    ],
                    "PublishedDate": "2024-02-29T01:44:18.857Z",
                    "LastModifiedDate": "2025-03-25T20:15:21.143Z",
                },
                {
                    "VulnerabilityID": "CVE-2025-24528",
                    "PkgID": "libk5crypto3@1.20.1-2+deb12u2",
                    "PkgName": "libk5crypto3",
                    "PkgIdentifier": {
                        "PURL": "pkg:deb/debian/libk5crypto3@1.20.1-2%2Bdeb12u2?arch=amd64\u0026distro=debian-12.8",
                        "UID": "8ac3863f268e4e8e",
                    },
                    "InstalledVersion": "1.20.1-2+deb12u2",
                    "FixedVersion": "1.20.1-2+deb12u3",
                    "Status": "fixed",
                    "Layer": {
                        "Digest": "sha256:e6d300c655d216ade160232a4caf78aef2b8dedb06aa1214d88da2815a51ca18",
                        "DiffID": "sha256:08bbaabad23800155ef9736e4133da5b141c131aa11718dd387ba50594bd8612",
                    },
                    "PrimaryURL": "https://avd.aquasec.com/nvd/cve-2025-24528",
                    "DataSource": {
                        "ID": "debian",
                        "Name": "Debian Security Tracker",
                        "URL": "https://salsa.debian.org/security-tracker-team/security-tracker",
                    },
                    "Title": "krb5: overflow when calculating ulog block size",
                    "Description": "A flaw was found in krb5. With incremental propagation enabled, an authenticated attacker can cause kadmind to write beyond the end of the mapped region for the iprop log file. This issue can trigger a process crash and lead to a denial of service.",
                    "Severity": "MEDIUM",
                    "VendorSeverity": {
                        "alma": 2,
                        "oracle-oval": 2,
                        "redhat": 2,
                        "rocky": 2,
                        "ubuntu": 2,
                    },
                    "CVSS": {
                        "redhat": {
                            "V3Vector": "CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:H",
                            "V3Score": 6.5,
                        }
                    },
                    "References": [
                        "https://access.redhat.com/errata/RHSA-2025:2722",
                        "https://access.redhat.com/security/cve/CVE-2025-24528",
                        "https://bugzilla.redhat.com/2342796",
                        "https://bugzilla.redhat.com/show_bug.cgi?id=2342796",
                        "https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2025-24528",
                        "https://errata.almalinux.org/8/ALSA-2025-2722.html",
                        "https://errata.rockylinux.org/RLSA-2025:2722",
                        "https://github.com/krb5/krb5/commit/78ceba024b64d49612375be4a12d1c066b0bfbd0",
                        "https://linux.oracle.com/cve/CVE-2025-24528.html",
                        "https://linux.oracle.com/errata/ELSA-2025-2722.html",
                        "https://nvd.nist.gov/vuln/detail/CVE-2025-24528",
                        "https://ubuntu.com/security/notices/USN-7314-1",
                        "https://www.cve.org/CVERecord?id=CVE-2025-24528",
                    ],
                },
                {
                    "VulnerabilityID": "CVE-2024-26462",
                    "PkgID": "libkrb5-3@1.20.1-2+deb12u2",
                    "PkgName": "libkrb5-3",
                    "PkgIdentifier": {
                        "PURL": "pkg:deb/debian/libkrb5-3@1.20.1-2%2Bdeb12u2?arch=amd64\u0026distro=debian-12.8",
                        "UID": "bd3137b2f754153e",
                    },
                    "InstalledVersion": "1.20.1-2+deb12u2",
                    "FixedVersion": "1.20.1-2+deb12u3",
                    "Status": "fixed",
                    "Layer": {
                        "Digest": "sha256:e6d300c655d216ade160232a4caf78aef2b8dedb06aa1214d88da2815a51ca18",
                        "DiffID": "sha256:08bbaabad23800155ef9736e4133da5b141c131aa11718dd387ba50594bd8612",
                    },
                    "SeveritySource": "nvd",
                    "PrimaryURL": "https://avd.aquasec.com/nvd/cve-2024-26462",
                    "DataSource": {
                        "ID": "debian",
                        "Name": "Debian Security Tracker",
                        "URL": "https://salsa.debian.org/security-tracker-team/security-tracker",
                    },
                    "Title": "krb5: Memory leak at /krb5/src/kdc/ndr.c",
                    "Description": "Kerberos 5 (aka krb5) 1.21.2 contains a memory leak vulnerability in /krb5/src/kdc/ndr.c.",
                    "Severity": "MEDIUM",
                    "CweIDs": ["CWE-401"],
                    "VendorSeverity": {
                        "alma": 2,
                        "amazon": 2,
                        "azure": 2,
                        "nvd": 2,
                        "oracle-oval": 2,
                        "photon": 2,
                        "redhat": 2,
                        "ubuntu": 2,
                    },
                    "CVSS": {
                        "nvd": {
                            "V3Vector": "CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:H",
                            "V3Score": 5.5,
                        },
                        "redhat": {
                            "V3Vector": "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H",
                            "V3Score": 7.5,
                        },
                    },
                    "References": [
                        "https://access.redhat.com/errata/RHSA-2024:9331",
                        "https://access.redhat.com/security/cve/CVE-2024-26462",
                        "https://bugzilla.redhat.com/2266731",
                        "https://bugzilla.redhat.com/2266740",
                        "https://bugzilla.redhat.com/2266742",
                        "https://errata.almalinux.org/9/ALSA-2024-9331.html",
                        "https://github.com/LuMingYinDetect/krb5_defects/blob/main/krb5_detect_3.md",
                        "https://linux.oracle.com/cve/CVE-2024-26462.html",
                        "https://linux.oracle.com/errata/ELSA-2024-9331.html",
                        "https://mailman.mit.edu/pipermail/kerberos/2024-March/023095.html",
                        "https://nvd.nist.gov/vuln/detail/CVE-2024-26462",
                        "https://security.netapp.com/advisory/ntap-20240415-0012/",
                        "https://ubuntu.com/security/notices/USN-7314-1",
                        "https://www.cve.org/CVERecord?id=CVE-2024-26462",
                    ],
                    "PublishedDate": "2024-02-29T01:44:18.857Z",
                    "LastModifiedDate": "2025-03-25T20:15:21.143Z",
                },
                {
                    "VulnerabilityID": "CVE-2025-24528",
                    "PkgID": "libkrb5-3@1.20.1-2+deb12u2",
                    "PkgName": "libkrb5-3",
                    "PkgIdentifier": {
                        "PURL": "pkg:deb/debian/libkrb5-3@1.20.1-2%2Bdeb12u2?arch=amd64\u0026distro=debian-12.8",
                        "UID": "bd3137b2f754153e",
                    },
                    "InstalledVersion": "1.20.1-2+deb12u2",
                    "FixedVersion": "1.20.1-2+deb12u3",
                    "Status": "fixed",
                    "Layer": {
                        "Digest": "sha256:e6d300c655d216ade160232a4caf78aef2b8dedb06aa1214d88da2815a51ca18",
                        "DiffID": "sha256:08bbaabad23800155ef9736e4133da5b141c131aa11718dd387ba50594bd8612",
                    },
                    "PrimaryURL": "https://avd.aquasec.com/nvd/cve-2025-24528",
                    "DataSource": {
                        "ID": "debian",
                        "Name": "Debian Security Tracker",
                        "URL": "https://salsa.debian.org/security-tracker-team/security-tracker",
                    },
                    "Title": "krb5: overflow when calculating ulog block size",
                    "Description": "A flaw was found in krb5. With incremental propagation enabled, an authenticated attacker can cause kadmind to write beyond the end of the mapped region for the iprop log file. This issue can trigger a process crash and lead to a denial of service.",
                    "Severity": "MEDIUM",
                    "VendorSeverity": {
                        "alma": 2,
                        "oracle-oval": 2,
                        "redhat": 2,
                        "rocky": 2,
                        "ubuntu": 2,
                    },
                    "CVSS": {
                        "redhat": {
                            "V3Vector": "CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:H",
                            "V3Score": 6.5,
                        }
                    },
                    "References": [
                        "https://access.redhat.com/errata/RHSA-2025:2722",
                        "https://access.redhat.com/security/cve/CVE-2025-24528",
                        "https://bugzilla.redhat.com/2342796",
                        "https://bugzilla.redhat.com/show_bug.cgi?id=2342796",
                        "https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2025-24528",
                        "https://errata.almalinux.org/8/ALSA-2025-2722.html",
                        "https://errata.rockylinux.org/RLSA-2025:2722",
                        "https://github.com/krb5/krb5/commit/78ceba024b64d49612375be4a12d1c066b0bfbd0",
                        "https://linux.oracle.com/cve/CVE-2025-24528.html",
                        "https://linux.oracle.com/errata/ELSA-2025-2722.html",
                        "https://nvd.nist.gov/vuln/detail/CVE-2025-24528",
                        "https://ubuntu.com/security/notices/USN-7314-1",
                        "https://www.cve.org/CVERecord?id=CVE-2025-24528",
                    ],
                },
                {
                    "VulnerabilityID": "CVE-2024-26462",
                    "PkgID": "libkrb5support0@1.20.1-2+deb12u2",
                    "PkgName": "libkrb5support0",
                    "PkgIdentifier": {
                        "PURL": "pkg:deb/debian/libkrb5support0@1.20.1-2%2Bdeb12u2?arch=amd64\u0026distro=debian-12.8",
                        "UID": "a045d3196df5657",
                    },
                    "InstalledVersion": "1.20.1-2+deb12u2",
                    "FixedVersion": "1.20.1-2+deb12u3",
                    "Status": "fixed",
                    "Layer": {
                        "Digest": "sha256:e6d300c655d216ade160232a4caf78aef2b8dedb06aa1214d88da2815a51ca18",
                        "DiffID": "sha256:08bbaabad23800155ef9736e4133da5b141c131aa11718dd387ba50594bd8612",
                    },
                    "SeveritySource": "nvd",
                    "PrimaryURL": "https://avd.aquasec.com/nvd/cve-2024-26462",
                    "DataSource": {
                        "ID": "debian",
                        "Name": "Debian Security Tracker",
                        "URL": "https://salsa.debian.org/security-tracker-team/security-tracker",
                    },
                    "Title": "krb5: Memory leak at /krb5/src/kdc/ndr.c",
                    "Description": "Kerberos 5 (aka krb5) 1.21.2 contains a memory leak vulnerability in /krb5/src/kdc/ndr.c.",
                    "Severity": "MEDIUM",
                    "CweIDs": ["CWE-401"],
                    "VendorSeverity": {
                        "alma": 2,
                        "amazon": 2,
                        "azure": 2,
                        "nvd": 2,
                        "oracle-oval": 2,
                        "photon": 2,
                        "redhat": 2,
                        "ubuntu": 2,
                    },
                    "CVSS": {
                        "nvd": {
                            "V3Vector": "CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:H",
                            "V3Score": 5.5,
                        },
                        "redhat": {
                            "V3Vector": "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H",
                            "V3Score": 7.5,
                        },
                    },
                    "References": [
                        "https://access.redhat.com/errata/RHSA-2024:9331",
                        "https://access.redhat.com/security/cve/CVE-2024-26462",
                        "https://bugzilla.redhat.com/2266731",
                        "https://bugzilla.redhat.com/2266740",
                        "https://bugzilla.redhat.com/2266742",
                        "https://errata.almalinux.org/9/ALSA-2024-9331.html",
                        "https://github.com/LuMingYinDetect/krb5_defects/blob/main/krb5_detect_3.md",
                        "https://linux.oracle.com/cve/CVE-2024-26462.html",
                        "https://linux.oracle.com/errata/ELSA-2024-9331.html",
                        "https://mailman.mit.edu/pipermail/kerberos/2024-March/023095.html",
                        "https://nvd.nist.gov/vuln/detail/CVE-2024-26462",
                        "https://security.netapp.com/advisory/ntap-20240415-0012/",
                        "https://ubuntu.com/security/notices/USN-7314-1",
                        "https://www.cve.org/CVERecord?id=CVE-2024-26462",
                    ],
                    "PublishedDate": "2024-02-29T01:44:18.857Z",
                    "LastModifiedDate": "2025-03-25T20:15:21.143Z",
                },
                {
                    "VulnerabilityID": "CVE-2025-24528",
                    "PkgID": "libkrb5support0@1.20.1-2+deb12u2",
                    "PkgName": "libkrb5support0",
                    "PkgIdentifier": {
                        "PURL": "pkg:deb/debian/libkrb5support0@1.20.1-2%2Bdeb12u2?arch=amd64\u0026distro=debian-12.8",
                        "UID": "a045d3196df5657",
                    },
                    "InstalledVersion": "1.20.1-2+deb12u2",
                    "FixedVersion": "1.20.1-2+deb12u3",
                    "Status": "fixed",
                    "Layer": {
                        "Digest": "sha256:e6d300c655d216ade160232a4caf78aef2b8dedb06aa1214d88da2815a51ca18",
                        "DiffID": "sha256:08bbaabad23800155ef9736e4133da5b141c131aa11718dd387ba50594bd8612",
                    },
                    "PrimaryURL": "https://avd.aquasec.com/nvd/cve-2025-24528",
                    "DataSource": {
                        "ID": "debian",
                        "Name": "Debian Security Tracker",
                        "URL": "https://salsa.debian.org/security-tracker-team/security-tracker",
                    },
                    "Title": "krb5: overflow when calculating ulog block size",
                    "Description": "A flaw was found in krb5. With incremental propagation enabled, an authenticated attacker can cause kadmind to write beyond the end of the mapped region for the iprop log file. This issue can trigger a process crash and lead to a denial of service.",
                    "Severity": "MEDIUM",
                    "VendorSeverity": {
                        "alma": 2,
                        "oracle-oval": 2,
                        "redhat": 2,
                        "rocky": 2,
                        "ubuntu": 2,
                    },
                    "CVSS": {
                        "redhat": {
                            "V3Vector": "CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:H",
                            "V3Score": 6.5,
                        }
                    },
                    "References": [
                        "https://access.redhat.com/errata/RHSA-2025:2722",
                        "https://access.redhat.com/security/cve/CVE-2025-24528",
                        "https://bugzilla.redhat.com/2342796",
                        "https://bugzilla.redhat.com/show_bug.cgi?id=2342796",
                        "https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2025-24528",
                        "https://errata.almalinux.org/8/ALSA-2025-2722.html",
                        "https://errata.rockylinux.org/RLSA-2025:2722",
                        "https://github.com/krb5/krb5/commit/78ceba024b64d49612375be4a12d1c066b0bfbd0",
                        "https://linux.oracle.com/cve/CVE-2025-24528.html",
                        "https://linux.oracle.com/errata/ELSA-2025-2722.html",
                        "https://nvd.nist.gov/vuln/detail/CVE-2025-24528",
                        "https://ubuntu.com/security/notices/USN-7314-1",
                        "https://www.cve.org/CVERecord?id=CVE-2025-24528",
                    ],
                },
                {
                    "VulnerabilityID": "CVE-2025-31115",
                    "VendorIDs": ["DSA-5895-1"],
                    "PkgID": "liblzma5@5.4.1-0.2",
                    "PkgName": "liblzma5",
                    "PkgIdentifier": {
                        "PURL": "pkg:deb/debian/liblzma5@5.4.1-0.2?arch=amd64\u0026distro=debian-12.8",
                        "UID": "8f93c26606557a6b",
                    },
                    "InstalledVersion": "5.4.1-0.2",
                    "FixedVersion": "5.4.1-1",
                    "Status": "fixed",
                    "Layer": {
                        "Digest": "sha256:8cf9fb7a0b56cf93bf2502aff8087344f2dd06e29fb027b0c06aa2726ab3eda8",
                        "DiffID": "sha256:c0f1022b22a9b36851b358f44e5475e39d166e71a8073cf53c894a299239b1c5",
                    },
                    "PrimaryURL": "https://avd.aquasec.com/nvd/cve-2025-31115",
                    "DataSource": {
                        "ID": "debian",
                        "Name": "Debian Security Tracker",
                        "URL": "https://salsa.debian.org/security-tracker-team/security-tracker",
                    },
                    "Title": "xz: XZ has a heap-use-after-free bug in threaded .xz decoder",
                    "Description": "XZ Utils provide a general-purpose data-compression library plus command-line tools. In XZ Utils 5.3.3alpha to 5.8.0, the multithreaded .xz decoder in liblzma has a bug where invalid input can at least result in a crash. The effects include heap use after free and writing to an address based on the null pointer plus an offset. Applications and libraries that use the lzma_stream_decoder_mt function are affected. The bug has been fixed in XZ Utils 5.8.1, and the fix has been committed to the v5.4, v5.6, v5.8, and master branches in the xz Git repository. No new release packages will be made from the old stable branches, but a standalone patch is available that applies to all affected releases.",
                    "Severity": "HIGH",
                    "CweIDs": ["CWE-366", "CWE-416", "CWE-476", "CWE-826"],
                    "VendorSeverity": {
                        "azure": 3,
                        "photon": 3,
                        "redhat": 3,
                        "ubuntu": 2,
                    },
                    "CVSS": {
                        "redhat": {
                            "V3Vector": "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H",
                            "V3Score": 7.5,
                        }
                    },
                    "References": [
                        "http://www.openwall.com/lists/oss-security/2025/04/03/1",
                        "http://www.openwall.com/lists/oss-security/2025/04/03/2",
                        "http://www.openwall.com/lists/oss-security/2025/04/03/3",
                        "https://access.redhat.com/security/cve/CVE-2025-31115",
                        "https://github.com/tukaani-project/xz/commit/d5a2ffe41bb77b918a8c96084885d4dbe4bf6480",
                        "https://github.com/tukaani-project/xz/security/advisories/GHSA-6cc8-p5mm-29w2",
                        "https://nvd.nist.gov/vuln/detail/CVE-2025-31115",
                        "https://tukaani.org/xz/xz-cve-2025-31115.patch",
                        "https://ubuntu.com/security/notices/USN-7414-1",
                        "https://www.cve.org/CVERecord?id=CVE-2025-31115",
                    ],
                    "PublishedDate": "2025-04-03T17:15:30.54Z",
                    "LastModifiedDate": "2025-04-07T14:18:34.453Z",
                },
                {
                    "VulnerabilityID": "CVE-2024-13176",
                    "PkgID": "libssl3@3.0.15-1~deb12u1",
                    "PkgName": "libssl3",
                    "PkgIdentifier": {
                        "PURL": "pkg:deb/debian/libssl3@3.0.15-1~deb12u1?arch=amd64\u0026distro=debian-12.8",
                        "UID": "b1a37070ace2492",
                    },
                    "InstalledVersion": "3.0.15-1~deb12u1",
                    "FixedVersion": "3.0.16-1~deb12u1",
                    "Status": "fixed",
                    "Layer": {
                        "Digest": "sha256:dcccf87d013dafa7f4bd6b72c6c3c1f5a3a347e626690a07568d0a925cfb262e",
                        "DiffID": "sha256:5d3c0bf69709b57971680491ecc0c36aa3fe7a6fea6905646820de6d9351eb8e",
                    },
                    "PrimaryURL": "https://avd.aquasec.com/nvd/cve-2024-13176",
                    "DataSource": {
                        "ID": "debian",
                        "Name": "Debian Security Tracker",
                        "URL": "https://salsa.debian.org/security-tracker-team/security-tracker",
                    },
                    "Title": "openssl: Timing side-channel in ECDSA signature computation",
                    "Description": "Issue summary: A timing side-channel which could potentially allow recovering\nthe private key exists in the ECDSA signature computation.\n\nImpact summary: A timing side-channel in ECDSA signature computations\ncould allow recovering the private key by an attacker. However, measuring\nthe timing would require either local access to the signing application or\na very fast network connection with low latency.\n\nThere is a timing signal of around 300 nanoseconds when the top word of\nthe inverted ECDSA nonce value is zero. This can happen with significant\nprobability only for some of the supported elliptic curves. In particular\nthe NIST P-521 curve is affected. To be able to measure this leak, the attacker\nprocess must either be located in the same physical computer or must\nhave a very fast network connection with low latency. For that reason\nthe severity of this vulnerability is Low.\n\nThe FIPS modules in 3.4, 3.3, 3.2, 3.1 and 3.0 are affected by this issue.",
                    "Severity": "MEDIUM",
                    "CweIDs": ["CWE-385"],
                    "VendorSeverity": {
                        "amazon": 2,
                        "azure": 2,
                        "cbl-mariner": 2,
                        "redhat": 1,
                        "ubuntu": 1,
                    },
                    "CVSS": {
                        "redhat": {
                            "V3Vector": "CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:H/I:N/A:N",
                            "V3Score": 4.7,
                        }
                    },
                    "References": [
                        "http://www.openwall.com/lists/oss-security/2025/01/20/2",
                        "https://access.redhat.com/security/cve/CVE-2024-13176",
                        "https://github.com/openssl/openssl/commit/07272b05b04836a762b4baa874958af51d513844",
                        "https://github.com/openssl/openssl/commit/2af62e74fb59bc469506bc37eb2990ea408d9467",
                        "https://github.com/openssl/openssl/commit/392dcb336405a0c94486aa6655057f59fd3a0902",
                        "https://github.com/openssl/openssl/commit/4b1cb94a734a7d4ec363ac0a215a25c181e11f65",
                        "https://github.com/openssl/openssl/commit/77c608f4c8857e63e98e66444e2e761c9627916f",
                        "https://github.openssl.org/openssl/extended-releases/commit/0d5fd1ab987f7571e2c955d8d8b638fc0fb54ded",
                        "https://github.openssl.org/openssl/extended-releases/commit/a2639000db19878d5d89586ae7b725080592ae86",
                        "https://nvd.nist.gov/vuln/detail/CVE-2024-13176",
                        "https://openssl-library.org/news/secadv/20250120.txt",
                        "https://security.netapp.com/advisory/ntap-20250124-0005/",
                        "https://security.netapp.com/advisory/ntap-20250418-0010/",
                        "https://ubuntu.com/security/notices/USN-7264-1",
                        "https://ubuntu.com/security/notices/USN-7278-1",
                        "https://www.cve.org/CVERecord?id=CVE-2024-13176",
                        "https://www.oracle.com/security-alerts/cpuapr2025.html#AppendixMSQL",
                    ],
                    "PublishedDate": "2025-01-20T14:15:26.247Z",
                    "LastModifiedDate": "2025-04-19T01:15:43.007Z",
                },
                {
                    "VulnerabilityID": "CVE-2023-4039",
                    "PkgID": "libstdc++6@12.2.0-14",
                    "PkgName": "libstdc++6",
                    "PkgIdentifier": {
                        "PURL": "pkg:deb/debian/libstdc%2B%2B6@12.2.0-14?arch=amd64\u0026distro=debian-12.8",
                        "UID": "9ccd92ac6a932d40",
                    },
                    "InstalledVersion": "12.2.0-14",
                    "FixedVersion": "12.2.0-14+deb12u1",
                    "Status": "fixed",
                    "Layer": {
                        "Digest": "sha256:8cf9fb7a0b56cf93bf2502aff8087344f2dd06e29fb027b0c06aa2726ab3eda8",
                        "DiffID": "sha256:c0f1022b22a9b36851b358f44e5475e39d166e71a8073cf53c894a299239b1c5",
                    },
                    "SeveritySource": "debian",
                    "PrimaryURL": "https://avd.aquasec.com/nvd/cve-2023-4039",
                    "DataSource": {
                        "ID": "debian",
                        "Name": "Debian Security Tracker",
                        "URL": "https://salsa.debian.org/security-tracker-team/security-tracker",
                    },
                    "Title": "gcc: -fstack-protector fails to guard dynamic stack allocations on ARM64",
                    "Description": "**DISPUTED**A failure in the -fstack-protector feature in GCC-based toolchains \nthat target AArch64 allows an attacker to exploit an existing buffer \noverflow in dynamically-sized local variables in your application \nwithout this being detected. This stack-protector failure only applies \nto C99-style dynamically-sized local variables or those created using \nalloca(). The stack-protector operates as intended for statically-sized \nlocal variables.\n\nThe default behavior when the stack-protector \ndetects an overflow is to terminate your application, resulting in \ncontrolled loss of availability. An attacker who can exploit a buffer \noverflow without triggering the stack-protector might be able to change \nprogram flow control to cause an uncontrolled loss of availability or to\n go further and affect confidentiality or integrity. NOTE: The GCC project argues that this is a missed hardening bug and not a vulnerability by itself.",
                    "Severity": "LOW",
                    "CweIDs": ["CWE-693"],
                    "VendorSeverity": {
                        "amazon": 2,
                        "azure": 2,
                        "cbl-mariner": 2,
                        "debian": 1,
                        "nvd": 2,
                        "oracle-oval": 1,
                        "ubuntu": 1,
                    },
                    "CVSS": {
                        "nvd": {
                            "V3Vector": "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:L/I:L/A:N",
                            "V3Score": 4.8,
                        }
                    },
                    "References": [
                        "https://access.redhat.com/security/cve/CVE-2023-4039",
                        "https://developer.arm.com/Arm%20Security%20Center/GCC%20Stack%20Protector%20Vulnerability%20AArch64",
                        "https://gcc.gnu.org/git/?p=gcc.git;a=blob_plain;f=SECURITY.txt",
                        "https://gcc.gnu.org/pipermail/gcc-patches/2023-October/634066.html",
                        "https://github.com/metaredteam/external-disclosures/security/advisories/GHSA-x7ch-h5rf-w2mf",
                        "https://inbox.sourceware.org/gcc-patches/46cfa37b-56eb-344d-0745-e0d35393392d@gotplt.org",
                        "https://linux.oracle.com/cve/CVE-2023-4039.html",
                        "https://linux.oracle.com/errata/ELSA-2023-28766.html",
                        "https://nvd.nist.gov/vuln/detail/CVE-2023-4039",
                        "https://rtx.meta.security/mitigation/2023/09/12/CVE-2023-4039.html",
                        "https://www.cve.org/CVERecord?id=CVE-2023-4039",
                    ],
                    "PublishedDate": "2023-09-13T09:15:15.69Z",
                    "LastModifiedDate": "2025-02-13T17:17:14.717Z",
                },
                {
                    "VulnerabilityID": "CVE-2024-12133",
                    "VendorIDs": ["DSA-5863-1"],
                    "PkgID": "libtasn1-6@4.19.0-2",
                    "PkgName": "libtasn1-6",
                    "PkgIdentifier": {
                        "PURL": "pkg:deb/debian/libtasn1-6@4.19.0-2?arch=amd64\u0026distro=debian-12.8",
                        "UID": "4a3050a779ad6979",
                    },
                    "InstalledVersion": "4.19.0-2",
                    "FixedVersion": "4.19.0-2+deb12u1",
                    "Status": "fixed",
                    "Layer": {
                        "Digest": "sha256:8cf9fb7a0b56cf93bf2502aff8087344f2dd06e29fb027b0c06aa2726ab3eda8",
                        "DiffID": "sha256:c0f1022b22a9b36851b358f44e5475e39d166e71a8073cf53c894a299239b1c5",
                    },
                    "PrimaryURL": "https://avd.aquasec.com/nvd/cve-2024-12133",
                    "DataSource": {
                        "ID": "debian",
                        "Name": "Debian Security Tracker",
                        "URL": "https://salsa.debian.org/security-tracker-team/security-tracker",
                    },
                    "Title": "libtasn1: Inefficient DER Decoding in libtasn1 Leading to Potential Remote DoS",
                    "Description": "A flaw in libtasn1 causes inefficient handling of specific certificate data. When processing a large number of elements in a certificate, libtasn1 takes much longer than expected, which can slow down or even crash the system. This flaw allows an attacker to send a specially crafted certificate, causing a denial of service attack.",
                    "Severity": "MEDIUM",
                    "CweIDs": ["CWE-407"],
                    "VendorSeverity": {
                        "azure": 2,
                        "cbl-mariner": 2,
                        "oracle-oval": 2,
                        "photon": 3,
                        "redhat": 2,
                        "ubuntu": 2,
                    },
                    "CVSS": {
                        "redhat": {
                            "V3Vector": "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:L",
                            "V3Score": 5.3,
                        }
                    },
                    "References": [
                        "http://www.openwall.com/lists/oss-security/2025/02/06/6",
                        "https://access.redhat.com/errata/RHSA-2025:4049",
                        "https://access.redhat.com/errata/RHSA-2025:7077",
                        "https://access.redhat.com/security/cve/CVE-2024-12133",
                        "https://bugzilla.redhat.com/show_bug.cgi?id=2344611",
                        "https://gitlab.com/gnutls/libtasn1/-/blob/master/doc/security/CVE-2024-12133.md?ref_type=heads",
                        "https://gitlab.com/gnutls/libtasn1/-/issues/52",
                        "https://linux.oracle.com/cve/CVE-2024-12133.html",
                        "https://linux.oracle.com/errata/ELSA-2025-4049.html",
                        "https://lists.debian.org/debian-lts-announce/2025/02/msg00025.html",
                        "https://nvd.nist.gov/vuln/detail/CVE-2024-12133",
                        "https://ubuntu.com/security/notices/USN-7275-1",
                        "https://ubuntu.com/security/notices/USN-7275-2",
                        "https://www.cve.org/CVERecord?id=CVE-2024-12133",
                    ],
                    "PublishedDate": "2025-02-10T16:15:37.26Z",
                    "LastModifiedDate": "2025-05-13T09:15:19.16Z",
                },
                {
                    "VulnerabilityID": "CVE-2023-4641",
                    "PkgID": "login@1:4.13+dfsg1-1+b1",
                    "PkgName": "login",
                    "PkgIdentifier": {
                        "PURL": "pkg:deb/debian/login@4.13%2Bdfsg1-1%2Bb1?arch=amd64\u0026distro=debian-12.8\u0026epoch=1",
                        "UID": "9c383ff5c6ed1c81",
                    },
                    "InstalledVersion": "1:4.13+dfsg1-1+b1",
                    "FixedVersion": "1:4.13+dfsg1-1+deb12u1",
                    "Status": "fixed",
                    "Layer": {
                        "Digest": "sha256:8cf9fb7a0b56cf93bf2502aff8087344f2dd06e29fb027b0c06aa2726ab3eda8",
                        "DiffID": "sha256:c0f1022b22a9b36851b358f44e5475e39d166e71a8073cf53c894a299239b1c5",
                    },
                    "SeveritySource": "nvd",
                    "PrimaryURL": "https://avd.aquasec.com/nvd/cve-2023-4641",
                    "DataSource": {
                        "ID": "debian",
                        "Name": "Debian Security Tracker",
                        "URL": "https://salsa.debian.org/security-tracker-team/security-tracker",
                    },
                    "Title": "shadow-utils: possible password leak during passwd(1) change",
                    "Description": "A flaw was found in shadow-utils. When asking for a new password, shadow-utils asks the password twice. If the password fails on the second attempt, shadow-utils fails in cleaning the buffer used to store the first entry. This may allow an attacker with enough access to retrieve the password from the memory.",
                    "Severity": "MEDIUM",
                    "CweIDs": ["CWE-303", "CWE-287"],
                    "VendorSeverity": {
                        "alma": 1,
                        "amazon": 1,
                        "cbl-mariner": 2,
                        "nvd": 2,
                        "oracle-oval": 1,
                        "photon": 2,
                        "redhat": 1,
                        "ubuntu": 1,
                    },
                    "CVSS": {
                        "nvd": {
                            "V3Vector": "CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:H/I:N/A:N",
                            "V3Score": 5.5,
                        },
                        "redhat": {
                            "V3Vector": "CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:H/I:N/A:N",
                            "V3Score": 4.7,
                        },
                    },
                    "References": [
                        "https://access.redhat.com/errata/RHSA-2023:6632",
                        "https://access.redhat.com/errata/RHSA-2023:7112",
                        "https://access.redhat.com/errata/RHSA-2024:0417",
                        "https://access.redhat.com/errata/RHSA-2024:2577",
                        "https://access.redhat.com/security/cve/CVE-2023-4641",
                        "https://bugzilla.redhat.com/2215945",
                        "https://bugzilla.redhat.com/show_bug.cgi?id=2215945",
                        "https://errata.almalinux.org/9/ALSA-2023-6632.html",
                        "https://linux.oracle.com/cve/CVE-2023-4641.html",
                        "https://linux.oracle.com/errata/ELSA-2023-7112.html",
                        "https://nvd.nist.gov/vuln/detail/CVE-2023-4641",
                        "https://ubuntu.com/security/notices/USN-6640-1",
                        "https://www.cve.org/CVERecord?id=CVE-2023-4641",
                    ],
                    "PublishedDate": "2023-12-27T16:15:13.363Z",
                    "LastModifiedDate": "2024-11-21T08:35:35.837Z",
                },
                {
                    "VulnerabilityID": "CVE-2023-29383",
                    "PkgID": "login@1:4.13+dfsg1-1+b1",
                    "PkgName": "login",
                    "PkgIdentifier": {
                        "PURL": "pkg:deb/debian/login@4.13%2Bdfsg1-1%2Bb1?arch=amd64\u0026distro=debian-12.8\u0026epoch=1",
                        "UID": "9c383ff5c6ed1c81",
                    },
                    "InstalledVersion": "1:4.13+dfsg1-1+b1",
                    "FixedVersion": "1:4.13+dfsg1-1+deb12u1",
                    "Status": "fixed",
                    "Layer": {
                        "Digest": "sha256:8cf9fb7a0b56cf93bf2502aff8087344f2dd06e29fb027b0c06aa2726ab3eda8",
                        "DiffID": "sha256:c0f1022b22a9b36851b358f44e5475e39d166e71a8073cf53c894a299239b1c5",
                    },
                    "SeveritySource": "nvd",
                    "PrimaryURL": "https://avd.aquasec.com/nvd/cve-2023-29383",
                    "DataSource": {
                        "ID": "debian",
                        "Name": "Debian Security Tracker",
                        "URL": "https://salsa.debian.org/security-tracker-team/security-tracker",
                    },
                    "Title": "shadow: Improper input validation in shadow-utils package utility chfn",
                    "Description": 'In Shadow 4.13, it is possible to inject control characters into fields provided to the SUID program chfn (change finger). Although it is not possible to exploit this directly (e.g., adding a new user fails because \\n is in the block list), it is possible to misrepresent the /etc/passwd file when viewed. Use of \\r manipulations and Unicode characters to work around blocking of the : character make it possible to give the impression that a new user has been added. In other words, an adversary may be able to convince a system administrator to take the system offline (an indirect, social-engineered denial of service) by demonstrating that "cat /etc/passwd" shows a rogue user account.',
                    "Severity": "LOW",
                    "CweIDs": ["CWE-74", "CWE-125"],
                    "VendorSeverity": {
                        "cbl-mariner": 1,
                        "nvd": 1,
                        "photon": 1,
                        "redhat": 2,
                        "ubuntu": 1,
                    },
                    "CVSS": {
                        "nvd": {
                            "V3Vector": "CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:L/A:N",
                            "V3Score": 3.3,
                        },
                        "redhat": {
                            "V3Vector": "CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:U/C:N/I:N/A:H",
                            "V3Score": 5.5,
                        },
                    },
                    "References": [
                        "https://access.redhat.com/security/cve/CVE-2023-29383",
                        "https://github.com/shadow-maint/shadow/commit/e5905c4b84d4fb90aefcd96ee618411ebfac663d",
                        "https://github.com/shadow-maint/shadow/pull/687",
                        "https://nvd.nist.gov/vuln/detail/CVE-2023-29383",
                        "https://www.cve.org/CVERecord?id=CVE-2023-29383",
                        "https://www.trustwave.com/en-us/resources/blogs/spiderlabs-blog/cve-2023-29383-abusing-linux-chfn-to-misrepresent-etc-passwd/",
                        "https://www.trustwave.com/en-us/resources/security-resources/security-advisories/?fid=31797",
                    ],
                    "PublishedDate": "2023-04-14T22:15:07.68Z",
                    "LastModifiedDate": "2025-02-06T22:15:35.057Z",
                },
                {
                    "VulnerabilityID": "CVE-2024-13176",
                    "PkgID": "openssl@3.0.15-1~deb12u1",
                    "PkgName": "openssl",
                    "PkgIdentifier": {
                        "PURL": "pkg:deb/debian/openssl@3.0.15-1~deb12u1?arch=amd64\u0026distro=debian-12.8",
                        "UID": "e8a7a2c98e6b5686",
                    },
                    "InstalledVersion": "3.0.15-1~deb12u1",
                    "FixedVersion": "3.0.16-1~deb12u1",
                    "Status": "fixed",
                    "Layer": {
                        "Digest": "sha256:dcccf87d013dafa7f4bd6b72c6c3c1f5a3a347e626690a07568d0a925cfb262e",
                        "DiffID": "sha256:5d3c0bf69709b57971680491ecc0c36aa3fe7a6fea6905646820de6d9351eb8e",
                    },
                    "PrimaryURL": "https://avd.aquasec.com/nvd/cve-2024-13176",
                    "DataSource": {
                        "ID": "debian",
                        "Name": "Debian Security Tracker",
                        "URL": "https://salsa.debian.org/security-tracker-team/security-tracker",
                    },
                    "Title": "openssl: Timing side-channel in ECDSA signature computation",
                    "Description": "Issue summary: A timing side-channel which could potentially allow recovering\nthe private key exists in the ECDSA signature computation.\n\nImpact summary: A timing side-channel in ECDSA signature computations\ncould allow recovering the private key by an attacker. However, measuring\nthe timing would require either local access to the signing application or\na very fast network connection with low latency.\n\nThere is a timing signal of around 300 nanoseconds when the top word of\nthe inverted ECDSA nonce value is zero. This can happen with significant\nprobability only for some of the supported elliptic curves. In particular\nthe NIST P-521 curve is affected. To be able to measure this leak, the attacker\nprocess must either be located in the same physical computer or must\nhave a very fast network connection with low latency. For that reason\nthe severity of this vulnerability is Low.\n\nThe FIPS modules in 3.4, 3.3, 3.2, 3.1 and 3.0 are affected by this issue.",
                    "Severity": "MEDIUM",
                    "CweIDs": ["CWE-385"],
                    "VendorSeverity": {
                        "amazon": 2,
                        "azure": 2,
                        "cbl-mariner": 2,
                        "redhat": 1,
                        "ubuntu": 1,
                    },
                    "CVSS": {
                        "redhat": {
                            "V3Vector": "CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:H/I:N/A:N",
                            "V3Score": 4.7,
                        }
                    },
                    "References": [
                        "http://www.openwall.com/lists/oss-security/2025/01/20/2",
                        "https://access.redhat.com/security/cve/CVE-2024-13176",
                        "https://github.com/openssl/openssl/commit/07272b05b04836a762b4baa874958af51d513844",
                        "https://github.com/openssl/openssl/commit/2af62e74fb59bc469506bc37eb2990ea408d9467",
                        "https://github.com/openssl/openssl/commit/392dcb336405a0c94486aa6655057f59fd3a0902",
                        "https://github.com/openssl/openssl/commit/4b1cb94a734a7d4ec363ac0a215a25c181e11f65",
                        "https://github.com/openssl/openssl/commit/77c608f4c8857e63e98e66444e2e761c9627916f",
                        "https://github.openssl.org/openssl/extended-releases/commit/0d5fd1ab987f7571e2c955d8d8b638fc0fb54ded",
                        "https://github.openssl.org/openssl/extended-releases/commit/a2639000db19878d5d89586ae7b725080592ae86",
                        "https://nvd.nist.gov/vuln/detail/CVE-2024-13176",
                        "https://openssl-library.org/news/secadv/20250120.txt",
                        "https://security.netapp.com/advisory/ntap-20250124-0005/",
                        "https://security.netapp.com/advisory/ntap-20250418-0010/",
                        "https://ubuntu.com/security/notices/USN-7264-1",
                        "https://ubuntu.com/security/notices/USN-7278-1",
                        "https://www.cve.org/CVERecord?id=CVE-2024-13176",
                        "https://www.oracle.com/security-alerts/cpuapr2025.html#AppendixMSQL",
                    ],
                    "PublishedDate": "2025-01-20T14:15:26.247Z",
                    "LastModifiedDate": "2025-04-19T01:15:43.007Z",
                },
                {
                    "VulnerabilityID": "CVE-2023-4641",
                    "PkgID": "passwd@1:4.13+dfsg1-1+b1",
                    "PkgName": "passwd",
                    "PkgIdentifier": {
                        "PURL": "pkg:deb/debian/passwd@4.13%2Bdfsg1-1%2Bb1?arch=amd64\u0026distro=debian-12.8\u0026epoch=1",
                        "UID": "7c92045fbcb07f48",
                    },
                    "InstalledVersion": "1:4.13+dfsg1-1+b1",
                    "FixedVersion": "1:4.13+dfsg1-1+deb12u1",
                    "Status": "fixed",
                    "Layer": {
                        "Digest": "sha256:8cf9fb7a0b56cf93bf2502aff8087344f2dd06e29fb027b0c06aa2726ab3eda8",
                        "DiffID": "sha256:c0f1022b22a9b36851b358f44e5475e39d166e71a8073cf53c894a299239b1c5",
                    },
                    "SeveritySource": "nvd",
                    "PrimaryURL": "https://avd.aquasec.com/nvd/cve-2023-4641",
                    "DataSource": {
                        "ID": "debian",
                        "Name": "Debian Security Tracker",
                        "URL": "https://salsa.debian.org/security-tracker-team/security-tracker",
                    },
                    "Title": "shadow-utils: possible password leak during passwd(1) change",
                    "Description": "A flaw was found in shadow-utils. When asking for a new password, shadow-utils asks the password twice. If the password fails on the second attempt, shadow-utils fails in cleaning the buffer used to store the first entry. This may allow an attacker with enough access to retrieve the password from the memory.",
                    "Severity": "MEDIUM",
                    "CweIDs": ["CWE-303", "CWE-287"],
                    "VendorSeverity": {
                        "alma": 1,
                        "amazon": 1,
                        "cbl-mariner": 2,
                        "nvd": 2,
                        "oracle-oval": 1,
                        "photon": 2,
                        "redhat": 1,
                        "ubuntu": 1,
                    },
                    "CVSS": {
                        "nvd": {
                            "V3Vector": "CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:H/I:N/A:N",
                            "V3Score": 5.5,
                        },
                        "redhat": {
                            "V3Vector": "CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:H/I:N/A:N",
                            "V3Score": 4.7,
                        },
                    },
                    "References": [
                        "https://access.redhat.com/errata/RHSA-2023:6632",
                        "https://access.redhat.com/errata/RHSA-2023:7112",
                        "https://access.redhat.com/errata/RHSA-2024:0417",
                        "https://access.redhat.com/errata/RHSA-2024:2577",
                        "https://access.redhat.com/security/cve/CVE-2023-4641",
                        "https://bugzilla.redhat.com/2215945",
                        "https://bugzilla.redhat.com/show_bug.cgi?id=2215945",
                        "https://errata.almalinux.org/9/ALSA-2023-6632.html",
                        "https://linux.oracle.com/cve/CVE-2023-4641.html",
                        "https://linux.oracle.com/errata/ELSA-2023-7112.html",
                        "https://nvd.nist.gov/vuln/detail/CVE-2023-4641",
                        "https://ubuntu.com/security/notices/USN-6640-1",
                        "https://www.cve.org/CVERecord?id=CVE-2023-4641",
                    ],
                    "PublishedDate": "2023-12-27T16:15:13.363Z",
                    "LastModifiedDate": "2024-11-21T08:35:35.837Z",
                },
                {
                    "VulnerabilityID": "CVE-2023-29383",
                    "PkgID": "passwd@1:4.13+dfsg1-1+b1",
                    "PkgName": "passwd",
                    "PkgIdentifier": {
                        "PURL": "pkg:deb/debian/passwd@4.13%2Bdfsg1-1%2Bb1?arch=amd64\u0026distro=debian-12.8\u0026epoch=1",
                        "UID": "7c92045fbcb07f48",
                    },
                    "InstalledVersion": "1:4.13+dfsg1-1+b1",
                    "FixedVersion": "1:4.13+dfsg1-1+deb12u1",
                    "Status": "fixed",
                    "Layer": {
                        "Digest": "sha256:8cf9fb7a0b56cf93bf2502aff8087344f2dd06e29fb027b0c06aa2726ab3eda8",
                        "DiffID": "sha256:c0f1022b22a9b36851b358f44e5475e39d166e71a8073cf53c894a299239b1c5",
                    },
                    "SeveritySource": "nvd",
                    "PrimaryURL": "https://avd.aquasec.com/nvd/cve-2023-29383",
                    "DataSource": {
                        "ID": "debian",
                        "Name": "Debian Security Tracker",
                        "URL": "https://salsa.debian.org/security-tracker-team/security-tracker",
                    },
                    "Title": "shadow: Improper input validation in shadow-utils package utility chfn",
                    "Description": 'In Shadow 4.13, it is possible to inject control characters into fields provided to the SUID program chfn (change finger). Although it is not possible to exploit this directly (e.g., adding a new user fails because \\n is in the block list), it is possible to misrepresent the /etc/passwd file when viewed. Use of \\r manipulations and Unicode characters to work around blocking of the : character make it possible to give the impression that a new user has been added. In other words, an adversary may be able to convince a system administrator to take the system offline (an indirect, social-engineered denial of service) by demonstrating that "cat /etc/passwd" shows a rogue user account.',
                    "Severity": "LOW",
                    "CweIDs": ["CWE-74", "CWE-125"],
                    "VendorSeverity": {
                        "cbl-mariner": 1,
                        "nvd": 1,
                        "photon": 1,
                        "redhat": 2,
                        "ubuntu": 1,
                    },
                    "CVSS": {
                        "nvd": {
                            "V3Vector": "CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:L/A:N",
                            "V3Score": 3.3,
                        },
                        "redhat": {
                            "V3Vector": "CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:U/C:N/I:N/A:H",
                            "V3Score": 5.5,
                        },
                    },
                    "References": [
                        "https://access.redhat.com/security/cve/CVE-2023-29383",
                        "https://github.com/shadow-maint/shadow/commit/e5905c4b84d4fb90aefcd96ee618411ebfac663d",
                        "https://github.com/shadow-maint/shadow/pull/687",
                        "https://nvd.nist.gov/vuln/detail/CVE-2023-29383",
                        "https://www.cve.org/CVERecord?id=CVE-2023-29383",
                        "https://www.trustwave.com/en-us/resources/blogs/spiderlabs-blog/cve-2023-29383-abusing-linux-chfn-to-misrepresent-etc-passwd/",
                        "https://www.trustwave.com/en-us/resources/security-resources/security-advisories/?fid=31797",
                    ],
                    "PublishedDate": "2023-04-14T22:15:07.68Z",
                    "LastModifiedDate": "2025-02-06T22:15:35.057Z",
                },
                {
                    "VulnerabilityID": "CVE-2024-56406",
                    "VendorIDs": ["DSA-5902-1"],
                    "PkgID": "perl-base@5.36.0-7+deb12u1",
                    "PkgName": "perl-base",
                    "PkgIdentifier": {
                        "PURL": "pkg:deb/debian/perl-base@5.36.0-7%2Bdeb12u1?arch=amd64\u0026distro=debian-12.8",
                        "UID": "b59784f4ccb7e75e",
                    },
                    "InstalledVersion": "5.36.0-7+deb12u1",
                    "FixedVersion": "5.36.0-7+deb12u2",
                    "Status": "fixed",
                    "Layer": {
                        "Digest": "sha256:8cf9fb7a0b56cf93bf2502aff8087344f2dd06e29fb027b0c06aa2726ab3eda8",
                        "DiffID": "sha256:c0f1022b22a9b36851b358f44e5475e39d166e71a8073cf53c894a299239b1c5",
                    },
                    "PrimaryURL": "https://avd.aquasec.com/nvd/cve-2024-56406",
                    "DataSource": {
                        "ID": "debian",
                        "Name": "Debian Security Tracker",
                        "URL": "https://salsa.debian.org/security-tracker-team/security-tracker",
                    },
                    "Title": "perl: Perl 5.34, 5.36, 5.38 and 5.40 are vulnerable to a heap buffer overflow when transliterating non-ASCII bytes",
                    "Description": "A heap buffer overflow vulnerability was discovered in Perl. \n\nRelease branches 5.34, 5.36, 5.38 and 5.40 are affected, including development versions from 5.33.1 through 5.41.10.\n\nWhen there are non-ASCII bytes in the left-hand-side of the `tr` operator, `S_do_trans_invmap` can overflow the destination pointer `d`.\n\n   $ perl -e '$_ = \"\\x{FF}\" x 1000000; tr/\\xFF/\\x{100}/;' \n   Segmentation fault (core dumped)\n\nIt is believed that this vulnerability can enable Denial of Service and possibly Code Execution attacks on platforms that lack sufficient defenses.",
                    "Severity": "HIGH",
                    "CweIDs": ["CWE-122", "CWE-787"],
                    "VendorSeverity": {
                        "azure": 3,
                        "cbl-mariner": 3,
                        "photon": 3,
                        "redhat": 3,
                        "ubuntu": 2,
                    },
                    "CVSS": {
                        "redhat": {
                            "V3Vector": "CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:U/C:L/I:L/A:H",
                            "V3Score": 7.3,
                        }
                    },
                    "References": [
                        "http://www.openwall.com/lists/oss-security/2025/04/13/3",
                        "http://www.openwall.com/lists/oss-security/2025/04/13/4",
                        "http://www.openwall.com/lists/oss-security/2025/04/13/5",
                        "https://access.redhat.com/security/cve/CVE-2024-56406",
                        "https://github.com/Perl/perl5/commit/87f42aa0e0096e9a346c9672aa3a0bd3bef8c1dd.patch",
                        "https://metacpan.org/release/SHAY/perl-5.38.4/changes",
                        "https://metacpan.org/release/SHAY/perl-5.40.2/changes",
                        "https://nvd.nist.gov/vuln/detail/CVE-2024-56406",
                        "https://ubuntu.com/security/notices/USN-7434-1",
                        "https://ubuntu.com/security/notices/USN-7434-2",
                        "https://www.cve.org/CVERecord?id=CVE-2024-56406",
                    ],
                    "PublishedDate": "2025-04-13T14:15:14.527Z",
                    "LastModifiedDate": "2025-04-30T15:21:11.547Z",
                },
            ],
        },
        {
            "Target": "Python",
            "Class": "lang-pkgs",
            "Type": "python-pkg",
            "Vulnerabilities": [
                {
                    "VulnerabilityID": "CVE-2025-43859",
                    "PkgName": "h11",
                    "PkgPath": "usr/local/lib/python3.13/site-packages/h11-0.14.0.dist-info/METADATA",
                    "PkgIdentifier": {
                        "PURL": "pkg:pypi/h11@0.14.0",
                        "UID": "4b5e1a819dc74524",
                    },
                    "InstalledVersion": "0.14.0",
                    "FixedVersion": "0.16.0",
                    "Status": "fixed",
                    "Layer": {
                        "Digest": "sha256:564dfad33fbd75c3d8a1ce6c0e6b3dfdb9e22a3d6aebe2b87df1c8072051463b",
                        "DiffID": "sha256:61bf605c951ee9608dd78e8b84991903e65a44e81d628f70fe4a4789d917ac36",
                    },
                    "SeveritySource": "ghsa",
                    "PrimaryURL": "https://avd.aquasec.com/nvd/cve-2025-43859",
                    "DataSource": {
                        "ID": "ghsa",
                        "Name": "GitHub Security Advisory pip",
                        "URL": "https://github.com/advisories?query=type%3Areviewed+ecosystem%3Apip",
                    },
                    "Title": "h11: h11 accepts some malformed Chunked-Encoding bodies",
                    "Description": "h11 is a Python implementation of HTTP/1.1. Prior to version 0.16.0, a leniency in h11's parsing of line terminators in chunked-coding message bodies can lead to request smuggling vulnerabilities under certain conditions. This issue has been patched in version 0.16.0. Since exploitation requires the combination of buggy h11 with a buggy (reverse) proxy, fixing either component is sufficient to mitigate this issue.",
                    "Severity": "CRITICAL",
                    "CweIDs": ["CWE-444"],
                    "VendorSeverity": {"ghsa": 4, "redhat": 3, "ubuntu": 2},
                    "CVSS": {
                        "ghsa": {
                            "V3Vector": "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:N",
                            "V3Score": 9.1,
                        },
                        "redhat": {
                            "V3Vector": "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:N",
                            "V3Score": 7.4,
                        },
                    },
                    "References": [
                        "https://access.redhat.com/security/cve/CVE-2025-43859",
                        "https://github.com/python-hyper/h11",
                        "https://github.com/python-hyper/h11/commit/114803a29ce50116dc47951c690ad4892b1a36ed",
                        "https://github.com/python-hyper/h11/security/advisories/GHSA-vqfr-h8mv-ghfj",
                        "https://nvd.nist.gov/vuln/detail/CVE-2025-43859",
                        "https://ubuntu.com/security/notices/USN-7503-1",
                        "https://www.cve.org/CVERecord?id=CVE-2025-43859",
                    ],
                    "PublishedDate": "2025-04-24T19:15:47.06Z",
                    "LastModifiedDate": "2025-04-29T13:52:28.49Z",
                }
            ],
        },
    ],
}
