# Execution Engine Parameters

- **`max_cycles`**: Maximum number of turns agents can take (what you see as "Turn 1", "Turn 2", etc.). Controls conversation length. Default: 20.

- **`max_events_per_cycle`**: Maximum events processed in a single cycle. An "event" is an internal processing unit (message routing, agent execution, etc.). This throttles the processing rate per cycle. Default: 50.

- **`max_events_per_workspace`**: Total event budget for the entire workspace execution. Hard limit on total processing to prevent runaway execution. Each agent action typically uses 1-3 events. Default: 2000.

- **`max_total_workspaces`**: Maximum number of workspaces that can be created. Prevents workspace explosion when agents request subteams. Default: 50.

- **`max_workspace_depth`**: Maximum nesting depth for subteam workspaces (root=0, child=1, grandchild=2, etc.). Prevents infinite recursion via subteam requests. Default: 8.

- **`max_subteam_requests_per_agent`**: How many subteams a single agent can request. Prevents a single agent from creating too many child workspaces. Default: 3.

- **`fatal_cycle_threshold`**: Kill workspace after N consecutive cycles with no output. Detects infinite loops where agents keep processing but produce no messages. Default: 5.

- **`enable_display`**: Shows real-time message display in terminal (Turn 1, Turn 2, etc.). Set to `False` for silent execution. Default: `True`.
