# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.components_schemas_composio_tool_definition import ComponentsSchemasComposioToolDefinition
from ...types.paginated_slim_tool_definition_list import PaginatedSlimToolDefinitionList
from .raw_client import AsyncRawIntegrationProvidersClient, RawIntegrationProvidersClient


class IntegrationProvidersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawIntegrationProvidersClient(client_wrapper=client_wrapper)

    @property
    def _client_wrapper(self) -> SyncClientWrapper:
        return self._raw_client._client_wrapper

    @property
    def with_raw_response(self) -> RawIntegrationProvidersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawIntegrationProvidersClient
        """
        return self._raw_client

    def retrieve_integration_provider_tool_definition(
        self,
        integration_name: str,
        integration_provider: str,
        tool_name: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ComponentsSchemasComposioToolDefinition:
        """
        Retrieve a specific integration tool definition.

        Parameters
        ----------
        integration_name : str
            The integration name

        integration_provider : str
            The integration provider name

        tool_name : str
            The tool's unique name, as specified by the integration provider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ComponentsSchemasComposioToolDefinition


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.integration_providers.retrieve_integration_provider_tool_definition(
            integration_name="integration_name",
            integration_provider="integration_provider",
            tool_name="tool_name",
        )
        """
        _response = self._raw_client.retrieve_integration_provider_tool_definition(
            integration_name, integration_provider, tool_name, request_options=request_options
        )
        return _response.data

    def list_integration_tools(
        self,
        integration_provider: str,
        *,
        important: typing.Optional[bool] = None,
        include_deprecated: typing.Optional[bool] = None,
        integration_name: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        search: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedSlimToolDefinitionList:
        """
        List all integration tools for a given provider and integration.

        Parameters
        ----------
        integration_provider : str
            The integration provider name

        important : typing.Optional[bool]
            Whether to filter the tools by important

        include_deprecated : typing.Optional[bool]
            Whether to include deprecated tools

        integration_name : typing.Optional[str]
            The Vellum Integration name

        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        search : typing.Optional[str]
            The search term to filter the tools by

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedSlimToolDefinitionList


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.integration_providers.list_integration_tools(
            integration_provider="integration_provider",
        )
        """
        _response = self._raw_client.list_integration_tools(
            integration_provider,
            important=important,
            include_deprecated=include_deprecated,
            integration_name=integration_name,
            limit=limit,
            offset=offset,
            search=search,
            request_options=request_options,
        )
        return _response.data


class AsyncIntegrationProvidersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawIntegrationProvidersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawIntegrationProvidersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawIntegrationProvidersClient
        """
        return self._raw_client

    async def retrieve_integration_provider_tool_definition(
        self,
        integration_name: str,
        integration_provider: str,
        tool_name: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ComponentsSchemasComposioToolDefinition:
        """
        Retrieve a specific integration tool definition.

        Parameters
        ----------
        integration_name : str
            The integration name

        integration_provider : str
            The integration provider name

        tool_name : str
            The tool's unique name, as specified by the integration provider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ComponentsSchemasComposioToolDefinition


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.integration_providers.retrieve_integration_provider_tool_definition(
                integration_name="integration_name",
                integration_provider="integration_provider",
                tool_name="tool_name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve_integration_provider_tool_definition(
            integration_name, integration_provider, tool_name, request_options=request_options
        )
        return _response.data

    async def list_integration_tools(
        self,
        integration_provider: str,
        *,
        important: typing.Optional[bool] = None,
        include_deprecated: typing.Optional[bool] = None,
        integration_name: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        search: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedSlimToolDefinitionList:
        """
        List all integration tools for a given provider and integration.

        Parameters
        ----------
        integration_provider : str
            The integration provider name

        important : typing.Optional[bool]
            Whether to filter the tools by important

        include_deprecated : typing.Optional[bool]
            Whether to include deprecated tools

        integration_name : typing.Optional[str]
            The Vellum Integration name

        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        search : typing.Optional[str]
            The search term to filter the tools by

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedSlimToolDefinitionList


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.integration_providers.list_integration_tools(
                integration_provider="integration_provider",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_integration_tools(
            integration_provider,
            important=important,
            include_deprecated=include_deprecated,
            integration_name=integration_name,
            limit=limit,
            offset=offset,
            search=search,
            request_options=request_options,
        )
        return _response.data
