# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .finish_reason_enum import FinishReasonEnum
from .ml_model_usage import MlModelUsage
from .price import Price


class PromptExecutionMeta(UniversalBaseModel):
    """
    The subset of the metadata tracked by Vellum during prompt execution that the request opted into with `expand_meta`.
    """

    model_name: typing.Optional[str] = None
    latency: typing.Optional[int] = None
    deployment_release_tag: typing.Optional[str] = None
    prompt_version_id: typing.Optional[str] = None
    finish_reason: typing.Optional[FinishReasonEnum] = None
    usage: typing.Optional[MlModelUsage] = None
    cost: typing.Optional[Price] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
