# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from .test_suite_run_exec_config import TestSuiteRunExecConfig
from .test_suite_run_progress import TestSuiteRunProgress
from .test_suite_run_state import TestSuiteRunState
from .test_suite_run_test_suite import TestSuiteRunTestSuite


class TestSuiteRunRead(UniversalBaseModel):
    id: str
    created: dt.datetime
    test_suite: TestSuiteRunTestSuite
    state: TestSuiteRunState = pydantic.Field()
    """
    The current state of this run
    
    * `QUEUED` - Queued
    * `RUNNING` - Running
    * `COMPLETE` - Complete
    * `FAILED` - Failed
    * `CANCELLED` - Cancelled
    """

    exec_config: typing.Optional[TestSuiteRunExecConfig] = pydantic.Field(default=None)
    """
    Configuration that defines how the Test Suite should be run
    """

    progress: typing.Optional[TestSuiteRunProgress] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .array_vellum_value import ArrayVellumValue  # noqa: E402, F401, I001

update_forward_refs(TestSuiteRunRead)
