# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from .logical_operator import LogicalOperator


class VellumValueLogicalConditionRequest(UniversalBaseModel):
    """
    A basic condition comparing two Vellum values.
    """

    type: typing.Literal["LOGICAL_CONDITION"] = "LOGICAL_CONDITION"
    lhs_variable: "VellumValueRequest"
    operator: LogicalOperator
    rhs_variable: "VellumValueRequest"

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .array_vellum_value_request import ArrayVellumValueRequest  # noqa: E402, F401, I001
from .vellum_value_request import VellumValueRequest  # noqa: E402, F401, I001

update_forward_refs(VellumValueLogicalConditionRequest)
