# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .workflow_node_result_event_state import WorkflowNodeResultEventState


class WorkflowResultEventOutputDataString(UniversalBaseModel):
    """
    A string output streamed from a Workflow execution.
    """

    id: typing.Optional[str] = None
    name: str
    state: WorkflowNodeResultEventState
    node_id: str
    delta: typing.Optional[str] = pydantic.Field(default=None)
    """
    The newly output string value, meant to be concatenated with all previous. Will be non-null for events of state STREAMING.
    """

    type: typing.Literal["STRING"] = "STRING"
    value: typing.Optional[str] = pydantic.Field(default=None)
    """
    The entire string value. Will be non-null for events of state FULFILLED.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
