<a id="mypy-boto3-neptune"></a>

# mypy-boto3-neptune

[![PyPI - mypy-boto3-neptune](https://img.shields.io/pypi/v/mypy-boto3-neptune.svg?color=blue)](https://pypi.org/project/mypy-boto3-neptune)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-neptune.svg?color=blue)](https://pypi.org/project/mypy-boto3-neptune)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-neptune?color=blue)](https://pypistats.org/packages/mypy-boto3-neptune)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.Neptune 1.18.0](https://boto3.amazonaws.com/v1/documentation/api/1.18.0/reference/services/neptune.html#Neptune)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 5.0.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-neptune docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_neptune/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-neptune](#mypy-boto3-neptune)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `Neptune` service.

```bash
python -m pip install boto3-stubs[neptune]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[neptune]` in your environment:
  `python -m pip install 'boto3-stubs[neptune]'`

Both type checking and auto-complete should work for `Neptune` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[neptune]` in your environment:
  `python -m pip install 'boto3-stubs[neptune]'`

Both type checking and auto-complete should work for `Neptune` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[neptune]` in your environment:
  `python -m pip install 'boto3-stubs[neptune]'`
- Run `mypy` as usual

Type checking should work for `Neptune` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[neptune]` in your environment:
  `python -m pip install 'boto3-stubs[neptune]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Neptune` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`NeptuneClient` provides annotations for `boto3.client("neptune")`.

```python
import boto3

from mypy_boto3_neptune import NeptuneClient

client: NeptuneClient = boto3.client("neptune")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: NeptuneClient = session.client("neptune")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_neptune.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_neptune import NeptuneClient
from mypy_boto3_neptune.paginator import (
    DescribeDBClusterEndpointsPaginator,
    DescribeDBClusterParameterGroupsPaginator,
    DescribeDBClusterParametersPaginator,
    DescribeDBClusterSnapshotsPaginator,
    DescribeDBClustersPaginator,
    DescribeDBEngineVersionsPaginator,
    DescribeDBInstancesPaginator,
    DescribeDBParameterGroupsPaginator,
    DescribeDBParametersPaginator,
    DescribeDBSubnetGroupsPaginator,
    DescribeEngineDefaultParametersPaginator,
    DescribeEventSubscriptionsPaginator,
    DescribeEventsPaginator,
    DescribeOrderableDBInstanceOptionsPaginator,
    DescribePendingMaintenanceActionsPaginator,
)

client: NeptuneClient = boto3.client("neptune")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_db_cluster_endpoints_paginator: DescribeDBClusterEndpointsPaginator = client.get_paginator("describe_db_cluster_endpoints")
describe_db_cluster_parameter_groups_paginator: DescribeDBClusterParameterGroupsPaginator = client.get_paginator("describe_db_cluster_parameter_groups")
describe_db_cluster_parameters_paginator: DescribeDBClusterParametersPaginator = client.get_paginator("describe_db_cluster_parameters")
describe_db_cluster_snapshots_paginator: DescribeDBClusterSnapshotsPaginator = client.get_paginator("describe_db_cluster_snapshots")
describe_db_clusters_paginator: DescribeDBClustersPaginator = client.get_paginator("describe_db_clusters")
describe_db_engine_versions_paginator: DescribeDBEngineVersionsPaginator = client.get_paginator("describe_db_engine_versions")
describe_db_instances_paginator: DescribeDBInstancesPaginator = client.get_paginator("describe_db_instances")
describe_db_parameter_groups_paginator: DescribeDBParameterGroupsPaginator = client.get_paginator("describe_db_parameter_groups")
describe_db_parameters_paginator: DescribeDBParametersPaginator = client.get_paginator("describe_db_parameters")
describe_db_subnet_groups_paginator: DescribeDBSubnetGroupsPaginator = client.get_paginator("describe_db_subnet_groups")
describe_engine_default_parameters_paginator: DescribeEngineDefaultParametersPaginator = client.get_paginator("describe_engine_default_parameters")
describe_event_subscriptions_paginator: DescribeEventSubscriptionsPaginator = client.get_paginator("describe_event_subscriptions")
describe_events_paginator: DescribeEventsPaginator = client.get_paginator("describe_events")
describe_orderable_db_instance_options_paginator: DescribeOrderableDBInstanceOptionsPaginator = client.get_paginator("describe_orderable_db_instance_options")
describe_pending_maintenance_actions_paginator: DescribePendingMaintenanceActionsPaginator = client.get_paginator("describe_pending_maintenance_actions")
```

<a id="waiters-annotations"></a>

### Waiters annotations

`mypy_boto3_neptune.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_neptune import NeptuneClient
from mypy_boto3_neptune.waiter import (
    DBInstanceAvailableWaiter,
    DBInstanceDeletedWaiter,
)

client: NeptuneClient = boto3.client("neptune")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
db_instance_available_waiter: DBInstanceAvailableWaiter = client.get_waiter("db_instance_available")
db_instance_deleted_waiter: DBInstanceDeletedWaiter = client.get_waiter("db_instance_deleted")
```

<a id="literals"></a>

### Literals

`mypy_boto3_neptune.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_neptune.literals import (
    ApplyMethodType,
    DBInstanceAvailableWaiterName,
    DBInstanceDeletedWaiterName,
    DescribeDBClusterEndpointsPaginatorName,
    DescribeDBClusterParameterGroupsPaginatorName,
    DescribeDBClusterParametersPaginatorName,
    DescribeDBClusterSnapshotsPaginatorName,
    DescribeDBClustersPaginatorName,
    DescribeDBEngineVersionsPaginatorName,
    DescribeDBInstancesPaginatorName,
    DescribeDBParameterGroupsPaginatorName,
    DescribeDBParametersPaginatorName,
    DescribeDBSubnetGroupsPaginatorName,
    DescribeEngineDefaultParametersPaginatorName,
    DescribeEventSubscriptionsPaginatorName,
    DescribeEventsPaginatorName,
    DescribeOrderableDBInstanceOptionsPaginatorName,
    DescribePendingMaintenanceActionsPaginatorName,
    SourceTypeType,
)

def check_value(value: ApplyMethodType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_neptune.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_neptune.type_defs import (
    AddRoleToDBClusterMessageRequestTypeDef,
    AddSourceIdentifierToSubscriptionMessageRequestTypeDef,
    AddSourceIdentifierToSubscriptionResultTypeDef,
    AddTagsToResourceMessageRequestTypeDef,
    ApplyPendingMaintenanceActionMessageRequestTypeDef,
    ApplyPendingMaintenanceActionResultTypeDef,
    AvailabilityZoneTypeDef,
    CharacterSetTypeDef,
    CloudwatchLogsExportConfigurationTypeDef,
    CopyDBClusterParameterGroupMessageRequestTypeDef,
    CopyDBClusterParameterGroupResultTypeDef,
    CopyDBClusterSnapshotMessageRequestTypeDef,
    CopyDBClusterSnapshotResultTypeDef,
    CopyDBParameterGroupMessageRequestTypeDef,
    CopyDBParameterGroupResultTypeDef,
    CreateDBClusterEndpointMessageRequestTypeDef,
    CreateDBClusterEndpointOutputTypeDef,
    CreateDBClusterMessageRequestTypeDef,
    CreateDBClusterParameterGroupMessageRequestTypeDef,
    CreateDBClusterParameterGroupResultTypeDef,
    CreateDBClusterResultTypeDef,
    CreateDBClusterSnapshotMessageRequestTypeDef,
    CreateDBClusterSnapshotResultTypeDef,
    CreateDBInstanceMessageRequestTypeDef,
    CreateDBInstanceResultTypeDef,
    CreateDBParameterGroupMessageRequestTypeDef,
    CreateDBParameterGroupResultTypeDef,
    CreateDBSubnetGroupMessageRequestTypeDef,
    CreateDBSubnetGroupResultTypeDef,
    CreateEventSubscriptionMessageRequestTypeDef,
    CreateEventSubscriptionResultTypeDef,
    DBClusterEndpointMessageTypeDef,
    DBClusterEndpointTypeDef,
    DBClusterMemberTypeDef,
    DBClusterMessageTypeDef,
    DBClusterOptionGroupStatusTypeDef,
    DBClusterParameterGroupDetailsTypeDef,
    DBClusterParameterGroupNameMessageTypeDef,
    DBClusterParameterGroupTypeDef,
    DBClusterParameterGroupsMessageTypeDef,
    DBClusterRoleTypeDef,
    DBClusterSnapshotAttributeTypeDef,
    DBClusterSnapshotAttributesResultTypeDef,
    DBClusterSnapshotMessageTypeDef,
    DBClusterSnapshotTypeDef,
    DBClusterTypeDef,
    DBEngineVersionMessageTypeDef,
    DBEngineVersionTypeDef,
    DBInstanceMessageTypeDef,
    DBInstanceStatusInfoTypeDef,
    DBInstanceTypeDef,
    DBParameterGroupDetailsTypeDef,
    DBParameterGroupNameMessageTypeDef,
    DBParameterGroupStatusTypeDef,
    DBParameterGroupTypeDef,
    DBParameterGroupsMessageTypeDef,
    DBSecurityGroupMembershipTypeDef,
    DBSubnetGroupMessageTypeDef,
    DBSubnetGroupTypeDef,
    DeleteDBClusterEndpointMessageRequestTypeDef,
    DeleteDBClusterEndpointOutputTypeDef,
    DeleteDBClusterMessageRequestTypeDef,
    DeleteDBClusterParameterGroupMessageRequestTypeDef,
    DeleteDBClusterResultTypeDef,
    DeleteDBClusterSnapshotMessageRequestTypeDef,
    DeleteDBClusterSnapshotResultTypeDef,
    DeleteDBInstanceMessageRequestTypeDef,
    DeleteDBInstanceResultTypeDef,
    DeleteDBParameterGroupMessageRequestTypeDef,
    DeleteDBSubnetGroupMessageRequestTypeDef,
    DeleteEventSubscriptionMessageRequestTypeDef,
    DeleteEventSubscriptionResultTypeDef,
    DescribeDBClusterEndpointsMessageRequestTypeDef,
    DescribeDBClusterParameterGroupsMessageRequestTypeDef,
    DescribeDBClusterParametersMessageRequestTypeDef,
    DescribeDBClusterSnapshotAttributesMessageRequestTypeDef,
    DescribeDBClusterSnapshotAttributesResultTypeDef,
    DescribeDBClusterSnapshotsMessageRequestTypeDef,
    DescribeDBClustersMessageRequestTypeDef,
    DescribeDBEngineVersionsMessageRequestTypeDef,
    DescribeDBInstancesMessageRequestTypeDef,
    DescribeDBParameterGroupsMessageRequestTypeDef,
    DescribeDBParametersMessageRequestTypeDef,
    DescribeDBSubnetGroupsMessageRequestTypeDef,
    DescribeEngineDefaultClusterParametersMessageRequestTypeDef,
    DescribeEngineDefaultClusterParametersResultTypeDef,
    DescribeEngineDefaultParametersMessageRequestTypeDef,
    DescribeEngineDefaultParametersResultTypeDef,
    DescribeEventCategoriesMessageRequestTypeDef,
    DescribeEventSubscriptionsMessageRequestTypeDef,
    DescribeEventsMessageRequestTypeDef,
    DescribeOrderableDBInstanceOptionsMessageRequestTypeDef,
    DescribePendingMaintenanceActionsMessageRequestTypeDef,
    DescribeValidDBInstanceModificationsMessageRequestTypeDef,
    DescribeValidDBInstanceModificationsResultTypeDef,
    DomainMembershipTypeDef,
    DoubleRangeTypeDef,
    EndpointTypeDef,
    EngineDefaultsTypeDef,
    EventCategoriesMapTypeDef,
    EventCategoriesMessageTypeDef,
    EventSubscriptionTypeDef,
    EventSubscriptionsMessageTypeDef,
    EventTypeDef,
    EventsMessageTypeDef,
    FailoverDBClusterMessageRequestTypeDef,
    FailoverDBClusterResultTypeDef,
    FilterTypeDef,
    ListTagsForResourceMessageRequestTypeDef,
    ModifyDBClusterEndpointMessageRequestTypeDef,
    ModifyDBClusterEndpointOutputTypeDef,
    ModifyDBClusterMessageRequestTypeDef,
    ModifyDBClusterParameterGroupMessageRequestTypeDef,
    ModifyDBClusterResultTypeDef,
    ModifyDBClusterSnapshotAttributeMessageRequestTypeDef,
    ModifyDBClusterSnapshotAttributeResultTypeDef,
    ModifyDBInstanceMessageRequestTypeDef,
    ModifyDBInstanceResultTypeDef,
    ModifyDBParameterGroupMessageRequestTypeDef,
    ModifyDBSubnetGroupMessageRequestTypeDef,
    ModifyDBSubnetGroupResultTypeDef,
    ModifyEventSubscriptionMessageRequestTypeDef,
    ModifyEventSubscriptionResultTypeDef,
    OptionGroupMembershipTypeDef,
    OrderableDBInstanceOptionTypeDef,
    OrderableDBInstanceOptionsMessageTypeDef,
    PaginatorConfigTypeDef,
    ParameterTypeDef,
    PendingCloudwatchLogsExportsTypeDef,
    PendingMaintenanceActionTypeDef,
    PendingMaintenanceActionsMessageTypeDef,
    PendingModifiedValuesTypeDef,
    PromoteReadReplicaDBClusterMessageRequestTypeDef,
    PromoteReadReplicaDBClusterResultTypeDef,
    RangeTypeDef,
    RebootDBInstanceMessageRequestTypeDef,
    RebootDBInstanceResultTypeDef,
    RemoveRoleFromDBClusterMessageRequestTypeDef,
    RemoveSourceIdentifierFromSubscriptionMessageRequestTypeDef,
    RemoveSourceIdentifierFromSubscriptionResultTypeDef,
    RemoveTagsFromResourceMessageRequestTypeDef,
    ResetDBClusterParameterGroupMessageRequestTypeDef,
    ResetDBParameterGroupMessageRequestTypeDef,
    ResourcePendingMaintenanceActionsTypeDef,
    ResponseMetadataTypeDef,
    RestoreDBClusterFromSnapshotMessageRequestTypeDef,
    RestoreDBClusterFromSnapshotResultTypeDef,
    RestoreDBClusterToPointInTimeMessageRequestTypeDef,
    RestoreDBClusterToPointInTimeResultTypeDef,
    StartDBClusterMessageRequestTypeDef,
    StartDBClusterResultTypeDef,
    StopDBClusterMessageRequestTypeDef,
    StopDBClusterResultTypeDef,
    SubnetTypeDef,
    TagListMessageTypeDef,
    TagTypeDef,
    TimezoneTypeDef,
    UpgradeTargetTypeDef,
    ValidDBInstanceModificationsMessageTypeDef,
    ValidStorageOptionsTypeDef,
    VpcSecurityGroupMembershipTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AddRoleToDBClusterMessageRequestTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-neptune` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-neptune docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_neptune/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
