# Generated by Django 5.2 on 2025-01-13 08:12

import django.db.models.deletion
from django.db import migrations, models

import lamindb.base.fields


def migrate_refs_to_aux(apps, schema_editor):
    Reference = apps.get_model("lamindb", "Reference")

    for ref in Reference.objects.all():
        # Get existing _aux or initialize new dict
        aux_data = ref._aux or {}

        # Create or update the adhoc section
        aux_data["adhoc"] = {
            "preprint": ref.preprint,
            "public": ref.public,
            "journal": ref.journal,
        }

        ref._aux = aux_data
        ref.save(update_fields=["_aux"])


class Migration(migrations.Migration):
    dependencies = [
        ("lamindb", "0073_merge_ourprojects"),
    ]

    operations = [
        migrations.RemoveField(
            model_name="ulabel",
            name="is_concept",
        ),
        migrations.AddField(
            model_name="ulabel",
            name="is_type",
            field=lamindb.base.fields.BooleanField(
                blank=True, db_index=True, default=None, null=True
            ),
        ),
        migrations.AddField(
            model_name="ulabel",
            name="type",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="records",
                to="lamindb.ulabel",
            ),
        ),
        migrations.AlterField(
            model_name="ulabel",
            name="name",
            field=lamindb.base.fields.CharField(
                blank=True, db_index=True, default=None, max_length=150
            ),
        ),
        migrations.AddField(
            model_name="feature",
            name="is_type",
            field=lamindb.base.fields.BooleanField(
                blank=True, db_index=True, default=None, null=True
            ),
        ),
        migrations.AddField(
            model_name="featureset",
            name="is_type",
            field=lamindb.base.fields.BooleanField(
                blank=True, db_index=True, default=None, null=True
            ),
        ),
        migrations.AddField(
            model_name="featureset",
            name="type",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="records",
                to="lamindb.featureset",
            ),
        ),
        migrations.AddField(
            model_name="param",
            name="is_type",
            field=lamindb.base.fields.BooleanField(
                blank=True, db_index=True, default=None, null=True
            ),
        ),
        migrations.AddField(
            model_name="reference",
            name="is_type",
            field=lamindb.base.fields.BooleanField(
                blank=True, db_index=True, default=None, null=True
            ),
        ),
        migrations.AddField(
            model_name="reference",
            name="type",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="records",
                to="lamindb.reference",
            ),
        ),
        migrations.AlterField(
            model_name="feature",
            name="type",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="records",
                to="lamindb.feature",
            ),
        ),
        migrations.AlterField(
            model_name="param",
            name="type",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="records",
                to="lamindb.param",
            ),
        ),
        migrations.RenameField(
            model_name="project",
            old_name="contributors",
            new_name="persons",
        ),
        migrations.AddField(
            model_name="project",
            name="parents",
            field=models.ManyToManyField(related_name="children", to="lamindb.project"),
        ),
        migrations.AddField(
            model_name="project",
            name="type",
            field=lamindb.base.fields.CharField(
                blank=True, db_index=True, default=None, max_length=64, null=True
            ),
        ),
        migrations.AlterField(
            model_name="project",
            name="abbr",
            field=lamindb.base.fields.CharField(
                blank=True, db_index=True, default=None, max_length=32, null=True
            ),
        ),
        migrations.AlterField(
            model_name="reference",
            name="abbr",
            field=lamindb.base.fields.CharField(
                blank=True, db_index=True, default=None, max_length=32, null=True
            ),
        ),
        migrations.RenameField(
            model_name="artifact",
            old_name="aux",
            new_name="_aux",
        ),
        migrations.RenameField(
            model_name="collection",
            old_name="aux",
            new_name="_aux",
        ),
        migrations.RenameField(
            model_name="feature",
            old_name="aux",
            new_name="_aux",
        ),
        migrations.RenameField(
            model_name="featureset",
            old_name="aux",
            new_name="_aux",
        ),
        migrations.RenameField(
            model_name="featurevalue",
            old_name="aux",
            new_name="_aux",
        ),
        migrations.RenameField(
            model_name="param",
            old_name="aux",
            new_name="_aux",
        ),
        migrations.RenameField(
            model_name="paramvalue",
            old_name="aux",
            new_name="_aux",
        ),
        migrations.RenameField(
            model_name="person",
            old_name="aux",
            new_name="_aux",
        ),
        migrations.RenameField(
            model_name="project",
            old_name="aux",
            new_name="_aux",
        ),
        migrations.RenameField(
            model_name="reference",
            old_name="aux",
            new_name="_aux",
        ),
        migrations.RenameField(
            model_name="run",
            old_name="aux",
            new_name="_aux",
        ),
        migrations.RenameField(
            model_name="storage",
            old_name="aux",
            new_name="_aux",
        ),
        migrations.RenameField(
            model_name="transform",
            old_name="aux",
            new_name="_aux",
        ),
        migrations.RenameField(
            model_name="ulabel",
            old_name="aux",
            new_name="_aux",
        ),
        migrations.AddField(
            model_name="space",
            name="uid",
            field=lamindb.base.fields.CharField(
                blank=True,
                db_default="00000000",
                db_index=True,
                default="00000000",
                max_length=12,
                unique=True,
            ),
        ),
        # migrate references
        migrations.RunPython(
            migrate_refs_to_aux,
        ),
        # Then remove the old fields
        migrations.RemoveField(
            model_name="reference",
            name="preprint",
        ),
        migrations.RemoveField(
            model_name="reference",
            name="public",
        ),
        migrations.RemoveField(
            model_name="reference",
            name="journal",
        ),
        migrations.AlterField(
            model_name="artifact",
            name="_aux",
            field=lamindb.base.fields.JSONField(
                blank=True, db_default=None, default=None, null=True
            ),
        ),
        migrations.AlterField(
            model_name="artifact",
            name="_curator",
            field=lamindb.base.fields.JSONField(
                blank=True, db_default=None, default=None, null=True
            ),
        ),
        migrations.AlterField(
            model_name="collection",
            name="_aux",
            field=lamindb.base.fields.JSONField(
                blank=True, db_default=None, default=None, null=True
            ),
        ),
        migrations.AlterField(
            model_name="feature",
            name="_aux",
            field=lamindb.base.fields.JSONField(
                blank=True, db_default=None, default=None, null=True
            ),
        ),
        migrations.AlterField(
            model_name="featureset",
            name="_aux",
            field=lamindb.base.fields.JSONField(
                blank=True, db_default=None, default=None, null=True
            ),
        ),
        migrations.AlterField(
            model_name="featurevalue",
            name="_aux",
            field=lamindb.base.fields.JSONField(
                blank=True, db_default=None, default=None, null=True
            ),
        ),
        migrations.AlterField(
            model_name="param",
            name="_aux",
            field=lamindb.base.fields.JSONField(
                blank=True, db_default=None, default=None, null=True
            ),
        ),
        migrations.AlterField(
            model_name="paramvalue",
            name="_aux",
            field=lamindb.base.fields.JSONField(
                blank=True, db_default=None, default=None, null=True
            ),
        ),
        migrations.AlterField(
            model_name="person",
            name="_aux",
            field=lamindb.base.fields.JSONField(
                blank=True, db_default=None, default=None, null=True
            ),
        ),
        migrations.AlterField(
            model_name="project",
            name="_aux",
            field=lamindb.base.fields.JSONField(
                blank=True, db_default=None, default=None, null=True
            ),
        ),
        migrations.AlterField(
            model_name="reference",
            name="_aux",
            field=lamindb.base.fields.JSONField(
                blank=True, db_default=None, default=None, null=True
            ),
        ),
        migrations.AlterField(
            model_name="run",
            name="_aux",
            field=lamindb.base.fields.JSONField(
                blank=True, db_default=None, default=None, null=True
            ),
        ),
        migrations.AlterField(
            model_name="storage",
            name="_aux",
            field=lamindb.base.fields.JSONField(
                blank=True, db_default=None, default=None, null=True
            ),
        ),
        migrations.AlterField(
            model_name="transform",
            name="_aux",
            field=lamindb.base.fields.JSONField(
                blank=True, db_default=None, default=None, null=True
            ),
        ),
        migrations.AlterField(
            model_name="ulabel",
            name="_aux",
            field=lamindb.base.fields.JSONField(
                blank=True, db_default=None, default=None, null=True
            ),
        ),
        migrations.RenameField(
            model_name="reference",
            old_name="published_at",
            new_name="date",
        ),
    ]
