# Generated by Django 5.2 on 2025-01-15 17:55

import django.db.models.deletion
import django.db.models.functions.datetime
from django.db import migrations, models

import lamindb.base.fields
import lamindb.base.users
import lamindb.models


def update_type_values(apps, schema_editor):
    Transform = apps.get_model("lamindb", "Transform")
    Transform.objects.filter(type="glue").update(type="linker")


class Migration(migrations.Migration):
    dependencies = [
        ("lamindb", "0076_lamindbv1_part6"),
    ]

    operations = [
        migrations.RunPython(update_type_values),
        migrations.CreateModel(
            name="FeatureProject",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_project",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "project",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_feature",
                        to="lamindb.project",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
            ],
            options={
                "unique_together": {("feature", "project")},
            },
            bases=(lamindb.models.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="project",
            name="features",
            field=models.ManyToManyField(
                related_name="projects",
                through="lamindb.FeatureProject",
                to="lamindb.feature",
            ),
        ),
        migrations.CreateModel(
            name="SchemaProject",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "project",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_schema",
                        to="lamindb.project",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "schema",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_project",
                        to="lamindb.schema",
                    ),
                ),
            ],
            options={
                "unique_together": {("schema", "project")},
            },
            bases=(lamindb.models.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="project",
            name="schemas",
            field=models.ManyToManyField(
                related_name="projects",
                through="lamindb.SchemaProject",
                to="lamindb.schema",
            ),
        ),
        migrations.CreateModel(
            name="ULabelProject",
            fields=[
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        editable=False,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "project",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_ulabel",
                        to="lamindb.project",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.models.current_run,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.run",
                    ),
                ),
                (
                    "ulabel",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_project",
                        to="lamindb.ulabel",
                    ),
                ),
            ],
            options={
                "unique_together": {("ulabel", "project")},
            },
            bases=(lamindb.models.IsLink, models.Model),
        ),
        migrations.AddField(
            model_name="project",
            name="ulabels",
            field=models.ManyToManyField(
                related_name="projects",
                through="lamindb.ULabelProject",
                to="lamindb.ulabel",
            ),
        ),
    ]
