# Generated by Django 5.2 on 2025-05-11 18:42

import django.db.models.deletion
import django.db.models.functions.datetime
from django.db import migrations, models

import lamindb.base.fields
import lamindb.base.users
import lamindb.models.sqlrecord


class Migration(migrations.Migration):
    dependencies = [
        ("lamindb", "0094_writeloglock_writelogmigrationstate_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="RunFeatureValue",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "created_at",
                    lamindb.base.fields.DateTimeField(
                        blank=True,
                        db_default=django.db.models.functions.datetime.Now(),
                        db_index=True,
                        editable=False,
                    ),
                ),
                (
                    "created_by",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        default=lamindb.base.users.current_user_id,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="lamindb.user",
                    ),
                ),
                (
                    "featurevalue",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_run",
                        to="lamindb.featurevalue",
                    ),
                ),
                (
                    "run",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_featurevalue",
                        to="lamindb.run",
                    ),
                ),
            ],
            options={
                "unique_together": {("run", "featurevalue")},
            },
            bases=(models.Model, lamindb.models.sqlrecord.IsLink),
        ),
        migrations.AddField(
            model_name="run",
            name="_feature_values",
            field=models.ManyToManyField(
                related_name="runs",
                through="lamindb.RunFeatureValue",
                to="lamindb.featurevalue",
            ),
        ),
        migrations.RemoveField(
            model_name="flextable",
            name="created_by",
        ),
        migrations.RemoveField(
            model_name="flextable",
            name="projects",
        ),
        migrations.RemoveField(
            model_name="flextable",
            name="schema",
        ),
        migrations.RemoveField(
            model_name="flextable",
            name="space",
        ),
        migrations.RemoveField(
            model_name="flextable",
            name="type",
        ),
        migrations.RemoveField(
            model_name="flextable",
            name="ulabels",
        ),
        migrations.RemoveField(
            model_name="flextabledata",
            name="space",
        ),
        migrations.RemoveField(
            model_name="flextabledata",
            name="value_artifact",
        ),
        migrations.RemoveField(
            model_name="flextabledata",
            name="value_collection",
        ),
        migrations.RemoveField(
            model_name="flextabledata",
            name="value_person",
        ),
        migrations.RemoveField(
            model_name="flextabledata",
            name="value_project",
        ),
        migrations.RemoveField(
            model_name="flextabledata",
            name="value_ulabel",
        ),
        migrations.RemoveField(
            model_name="rundata",
            name="space",
        ),
        migrations.RemoveField(
            model_name="rundata",
            name="value_artifact",
        ),
        migrations.RemoveField(
            model_name="rundata",
            name="value_collection",
        ),
        migrations.RemoveField(
            model_name="rundata",
            name="value_person",
        ),
        migrations.RemoveField(
            model_name="rundata",
            name="value_project",
        ),
        migrations.RemoveField(
            model_name="rundata",
            name="value_ulabel",
        ),
        migrations.DeleteModel(
            name="FlexTable",
        ),
        migrations.DeleteModel(
            name="FlexTableData",
        ),
        migrations.DeleteModel(
            name="RunData",
        ),
    ]
