# Generated by Django 5.2 on 2025-05-26 09:33

import django.db.models.deletion
from django.db import migrations, models
from lamindb_setup.core.hashing import hash_dict, hash_string

import lamindb.base.fields


def populate_hash_values(apps, schema_editor):
    from tqdm import tqdm

    FeatureValue = apps.get_model("lamindb", "FeatureValue")

    records_queryset = FeatureValue.objects.filter(hash__isnull=True)
    total_count = records_queryset.count()
    print(f"\nFound {total_count} FeatureValue records with hash=None. Populating...")

    # Convert to list to avoid QuerySet modification issues
    records_to_update = list(records_queryset)

    batch_size = 1000
    updated_count = 0

    for batch_start in tqdm(range(0, len(records_to_update), batch_size)):
        batch_records = records_to_update[batch_start : batch_start + batch_size]

        # Calculate hashes for all records in batch
        for record in batch_records:
            if not isinstance(record.value, dict):
                record.hash = hash_string(str(record.value))
            else:
                record.hash = hash_dict(record.value)

        # Bulk update the entire batch
        FeatureValue.objects.bulk_update(batch_records, ["hash"], batch_size=batch_size)
        updated_count += len(batch_records)

    print(f"Finished. Updated: {updated_count} records.")


class Migration(migrations.Migration):
    dependencies = [
        ("lamindb", "0100_branch_alter_artifact__branch_code_and_more"),
    ]

    operations = [
        migrations.AlterField(
            model_name="artifact",
            name="_branch_code",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                db_column="_branch_code",
                db_default=1,
                default=1,
                on_delete=django.db.models.deletion.PROTECT,
                to="lamindb.branch",
            ),
        ),
        migrations.AlterField(
            model_name="collection",
            name="_branch_code",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                db_column="_branch_code",
                db_default=1,
                default=1,
                on_delete=django.db.models.deletion.PROTECT,
                to="lamindb.branch",
            ),
        ),
        migrations.AlterField(
            model_name="feature",
            name="_branch_code",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                db_column="_branch_code",
                db_default=1,
                default=1,
                on_delete=django.db.models.deletion.PROTECT,
                to="lamindb.branch",
            ),
        ),
        migrations.AlterField(
            model_name="featurevalue",
            name="_branch_code",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                db_column="_branch_code",
                db_default=1,
                default=1,
                on_delete=django.db.models.deletion.PROTECT,
                to="lamindb.branch",
            ),
        ),
        migrations.AlterField(
            model_name="person",
            name="_branch_code",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                db_column="_branch_code",
                db_default=1,
                default=1,
                on_delete=django.db.models.deletion.PROTECT,
                to="lamindb.branch",
            ),
        ),
        migrations.AlterField(
            model_name="project",
            name="_branch_code",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                db_column="_branch_code",
                db_default=1,
                default=1,
                on_delete=django.db.models.deletion.PROTECT,
                to="lamindb.branch",
            ),
        ),
        migrations.AlterField(
            model_name="record",
            name="_branch_code",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                db_column="_branch_code",
                db_default=1,
                default=1,
                on_delete=django.db.models.deletion.PROTECT,
                to="lamindb.branch",
            ),
        ),
        migrations.AlterField(
            model_name="recordrecord",
            name="_branch_code",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                db_column="_branch_code",
                db_default=1,
                default=1,
                on_delete=django.db.models.deletion.PROTECT,
                to="lamindb.branch",
            ),
        ),
        migrations.AlterField(
            model_name="reference",
            name="_branch_code",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                db_column="_branch_code",
                db_default=1,
                default=1,
                on_delete=django.db.models.deletion.PROTECT,
                to="lamindb.branch",
            ),
        ),
        migrations.AlterField(
            model_name="run",
            name="_branch_code",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                db_column="_branch_code",
                db_default=1,
                default=1,
                on_delete=django.db.models.deletion.PROTECT,
                to="lamindb.branch",
            ),
        ),
        migrations.AlterField(
            model_name="schema",
            name="_branch_code",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                db_column="_branch_code",
                db_default=1,
                default=1,
                on_delete=django.db.models.deletion.PROTECT,
                to="lamindb.branch",
            ),
        ),
        migrations.AlterField(
            model_name="sheet",
            name="_branch_code",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                db_column="_branch_code",
                db_default=1,
                default=1,
                on_delete=django.db.models.deletion.PROTECT,
                to="lamindb.branch",
            ),
        ),
        migrations.AlterField(
            model_name="storage",
            name="_branch_code",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                db_column="_branch_code",
                db_default=1,
                default=1,
                on_delete=django.db.models.deletion.PROTECT,
                to="lamindb.branch",
            ),
        ),
        migrations.AlterField(
            model_name="transform",
            name="_branch_code",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                db_column="_branch_code",
                db_default=1,
                default=1,
                on_delete=django.db.models.deletion.PROTECT,
                to="lamindb.branch",
            ),
        ),
        migrations.AlterField(
            model_name="ulabel",
            name="_branch_code",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                db_column="_branch_code",
                db_default=1,
                default=1,
                on_delete=django.db.models.deletion.PROTECT,
                to="lamindb.branch",
            ),
        ),
        migrations.RenameField(
            model_name="artifact",
            old_name="_branch_code",
            new_name="branch",
        ),
        migrations.RenameField(
            model_name="collection",
            old_name="_branch_code",
            new_name="branch",
        ),
        migrations.RenameField(
            model_name="feature",
            old_name="_branch_code",
            new_name="branch",
        ),
        migrations.RenameField(
            model_name="featurevalue",
            old_name="_branch_code",
            new_name="branch",
        ),
        migrations.RenameField(
            model_name="person",
            old_name="_branch_code",
            new_name="branch",
        ),
        migrations.RenameField(
            model_name="project",
            old_name="_branch_code",
            new_name="branch",
        ),
        migrations.RenameField(
            model_name="record",
            old_name="_branch_code",
            new_name="branch",
        ),
        migrations.RenameField(
            model_name="recordrecord",
            old_name="_branch_code",
            new_name="branch",
        ),
        migrations.RenameField(
            model_name="reference",
            old_name="_branch_code",
            new_name="branch",
        ),
        migrations.RenameField(
            model_name="run",
            old_name="_branch_code",
            new_name="branch",
        ),
        migrations.RenameField(
            model_name="schema",
            old_name="_branch_code",
            new_name="branch",
        ),
        migrations.RenameField(
            model_name="sheet",
            old_name="_branch_code",
            new_name="branch",
        ),
        migrations.RenameField(
            model_name="storage",
            old_name="_branch_code",
            new_name="branch",
        ),
        migrations.RenameField(
            model_name="transform",
            old_name="_branch_code",
            new_name="branch",
        ),
        migrations.RenameField(
            model_name="ulabel",
            old_name="_branch_code",
            new_name="branch",
        ),
        migrations.AlterField(
            model_name="artifact",
            name="hash",
            field=lamindb.base.fields.CharField(
                blank=True,
                db_index=True,
                default=None,
                editable=False,
                max_length=22,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="feature",
            name="name",
            field=lamindb.base.fields.CharField(
                blank=True, db_index=True, default=None, max_length=150
            ),
        ),
        migrations.AlterField(
            model_name="feature",
            name="type",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="features",
                to="lamindb.feature",
            ),
        ),
        migrations.AlterField(
            model_name="project",
            name="type",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="projects",
                to="lamindb.project",
            ),
        ),
        migrations.AlterField(
            model_name="record",
            name="type",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="records",
                to="lamindb.record",
            ),
        ),
        migrations.AlterField(
            model_name="reference",
            name="type",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="references",
                to="lamindb.reference",
            ),
        ),
        migrations.AlterField(
            model_name="schema",
            name="type",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="schemas",
                to="lamindb.schema",
            ),
        ),
        migrations.AlterField(
            model_name="transform",
            name="hash",
            field=lamindb.base.fields.CharField(
                blank=True, db_index=True, default=None, max_length=22, null=True
            ),
        ),
        migrations.AlterField(
            model_name="ulabel",
            name="type",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="ulabels",
                to="lamindb.ulabel",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="transform",
            unique_together={("key", "hash")},
        ),
        migrations.AddConstraint(
            model_name="artifact",
            constraint=models.UniqueConstraint(
                condition=models.Q(("key__isnull", False)),
                fields=("storage", "key", "hash"),
                name="unique_artifact_storage_key_hash",
            ),
        ),
        migrations.AlterField(
            model_name="feature",
            name="_expect_many",
            field=models.BooleanField(db_default=None, default=None, null=True),
        ),
        migrations.AlterField(
            model_name="run",
            name="uid",
            field=lamindb.base.fields.CharField(
                blank=True,
                db_index=True,
                default=lamindb.base.uids.base62_16,
                editable=False,
                max_length=20,
                unique=True,
            ),
        ),
        migrations.RemoveConstraint(
            model_name="featurevalue",
            name="unique_simple_feature_value",
        ),
        migrations.RemoveConstraint(
            model_name="featurevalue",
            name="unique_complex_feature_value",
        ),
        migrations.AlterUniqueTogether(
            name="featurevalue",
            unique_together={("feature", "hash")},
        ),
        migrations.RunPython(populate_hash_values),
    ]
