# Generated by Django 5.2 on 2025-07-04 17:07

import django.db.models.deletion
from django.db import migrations, models

import lamindb.base.fields


class Migration(migrations.Migration):
    dependencies = [
        ("lamindb", "0108_remove_record_sheet_remove_sheetproject_sheet_and_more"),
    ]

    operations = [
        migrations.AddField(
            model_name="record",
            name="input_of_runs",
            field=models.ManyToManyField(
                related_name="input_records", to="lamindb.run"
            ),
        ),
        migrations.AlterField(
            model_name="record",
            name="run",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                default=None,
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="output_records",
                to="lamindb.run",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="recordrecord",
            unique_together={("record", "feature", "value")},
        ),
        migrations.AlterUniqueTogether(
            name="recordrun",
            unique_together={("record", "feature", "value")},
        ),
        migrations.AlterUniqueTogether(
            name="recordulabel",
            unique_together={("record", "feature", "value")},
        ),
        migrations.AddField(
            model_name="record",
            name="values_artifacts",
            field=models.ManyToManyField(
                related_name="linked_in_records",
                through="lamindb.RecordArtifact",
                to="lamindb.artifact",
            ),
        ),
        migrations.AlterField(
            model_name="recordartifact",
            name="value",
            field=lamindb.base.fields.ForeignKey(
                blank=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="links_linked_in_record",
                to="lamindb.artifact",
            ),
        ),
        migrations.CreateModel(
            name="ArtifactRecord",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "artifact",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="links_record",
                        to="lamindb.artifact",
                    ),
                ),
                (
                    "feature",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifactrecord",
                        to="lamindb.feature",
                    ),
                ),
                (
                    "record",
                    lamindb.base.fields.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="links_artifact",
                        to="lamindb.record",
                    ),
                ),
            ],
            options={
                "unique_together": {("artifact", "record", "feature")},
            },
            bases=(models.Model, lamindb.models.sqlrecord.IsLink),
        ),
        migrations.AlterField(
            model_name="record",
            name="artifacts",
            field=models.ManyToManyField(
                related_name="records",
                through="lamindb.ArtifactRecord",
                to="lamindb.artifact",
            ),
        ),
        migrations.AddField(
            model_name="artifactrecord",
            name="feature_ref_is_name",
            field=lamindb.base.fields.BooleanField(blank=True, default=None, null=True),
        ),
        migrations.AddField(
            model_name="artifactrecord",
            name="label_ref_is_name",
            field=lamindb.base.fields.BooleanField(blank=True, default=None, null=True),
        ),
    ]
