# -*- coding: utf-8 -*-
"""shellfish ~ shell and file-system utils"""

from __future__ import annotations

from os import path as path

from asyncify import aiorun as aiorun
from funkify import funkify as _funkify
from shellfish import dotenv as dotenv, fs as fs, process as process, sh as sh
from shellfish.__about__ import __version__ as __version__
from shellfish._types import (
    STDIN as STDIN,
    STDIO as STDIO,
    FsPath as FsPath,
    PathLikeAny as PathLikeAny,
    PathLikeBytes as PathLikeBytes,
    PathLikeStr as PathLikeStr,
    PathLikeStrBytes as PathLikeStrBytes,
    PopenArg as PopenArg,
    PopenArgs as PopenArgs,
    PopenArgv as PopenArgv,
    PopenEnv as PopenEnv,
    SymlinkType as SymlinkType,
)
from shellfish.echo import echo as echo
from shellfish.fs import (
    chmod as chmod,
    copy_file as copy_file,
    cp as cp,
    dir_exists as dir_exists,
    dir_exists_async as dir_exists_async,
    dirpath_gen as dirpath_gen,
    dirs_gen as dirs_gen,
    exists as exists,
    exists_async as exists_async,
    extension as extension,
    file_exists as file_exists,
    file_exists_async as file_exists_async,
    file_lines_gen as file_lines_gen,
    filecmp as filecmp,
    filepath_gen as filepath_gen,
    filepath_mtimedelta_sec as filepath_mtimedelta_sec,
    files_dirs_gen as files_dirs_gen,
    files_gen as files_gen,
    filesize as filesize,
    filesize_async as filesize_async,
    fspath as fspath,
    is_dir as is_dir,
    is_dir_async as is_dir_async,
    is_file as is_file,
    is_file_async as is_file_async,
    is_link as is_link,
    is_link_async as is_link_async,
    isdir as isdir,
    isdir_async as isdir_async,
    isfile as isfile,
    isfile_async as isfile_async,
    islink as islink,
    islink_async as islink_async,
    lbin as lbin,
    lbytes as lbytes,
    lbytes_async as lbytes_async,
    lbytes_gen as lbytes_gen,
    lbytes_gen_async as lbytes_gen_async,
    listdir_async as listdir_async,
    listdir_gen as listdir_gen,
    ljson as ljson,
    ljson_async as ljson_async,
    lstat_async as lstat_async,
    lstr as lstr,
    lstr_async as lstr_async,
    lstring as lstring,
    lstring_async as lstring_async,
    mkdir as mkdir,
    mkdirp as mkdirp,
    move as move,
    path_gen as path_gen,
    rbin as rbin,
    rbin_async as rbin_async,
    rbin_gen as rbin_gen,
    rbin_gen_async as rbin_gen_async,
    rbytes as rbytes,
    rbytes_async as rbytes_async,
    rbytes_gen as rbytes_gen,
    rbytes_gen_async as rbytes_gen_async,
    read_bytes as read_bytes,
    read_bytes_async as read_bytes_async,
    read_bytes_gen as read_bytes_gen,
    read_bytes_gen_async as read_bytes_gen_async,
    read_json as read_json,
    read_json_async as read_json_async,
    read_str as read_str,
    read_str_async as read_str_async,
    rename as rename,
    rjson as rjson,
    rjson_async as rjson_async,
    rm_gen as rm_gen,
    rmdir as rmdir,
    rmfile as rmfile,
    rstr as rstr,
    rstr_async as rstr_async,
    rstring as rstring,
    rstring_async as rstring_async,
    safepath as safepath,
    sbin as sbin,
    sbin_async as sbin_async,
    sbytes as sbytes,
    sbytes_async as sbytes_async,
    sbytes_gen as sbytes_gen,
    sbytes_gen_async as sbytes_gen_async,
    scandir as scandir,
    scandir_gen as scandir_gen,
    scandir_list as scandir_list,
    sep_join as sep_join,
    sep_lstrip as sep_lstrip,
    sep_rstrip as sep_rstrip,
    sep_split as sep_split,
    sep_strip as sep_strip,
    shebang as shebang,
    sjson as sjson,
    sjson_async as sjson_async,
    sstr as sstr,
    sstr_async as sstr_async,
    sstring as sstring,
    sstring_async as sstring_async,
    stat as stat,
    stat_async as stat_async,
    symlink as symlink,
    touch as touch,
    walk_gen as walk_gen,
    wbin as wbin,
    wbin_async as wbin_async,
    wbin_gen as wbin_gen,
    wbin_gen_async as wbin_gen_async,
    wbytes as wbytes,
    wbytes_async as wbytes_async,
    wbytes_gen as wbytes_gen,
    wbytes_gen_async as wbytes_gen_async,
    wjson as wjson,
    wjson_async as wjson_async,
    write_bytes as write_bytes,
    write_bytes_async as write_bytes_async,
    write_bytes_gen as write_bytes_gen,
    write_bytes_gen_async as write_bytes_gen_async,
    write_json as write_json,
    write_json_async as write_json_async,
    write_str as write_str,
    write_str_async as write_str_async,
    wstr as wstr,
    wstr_async as wstr_async,
    wstring as wstring,
    wstring_async as wstring_async,
)
from shellfish.process import env as env
from shellfish.sh import (
    LIN as LIN,
    WIN as WIN,
    Done as Done,
    DoneDict as DoneDict,
    DoneError as DoneError,
    DoneObj as DoneObj,
    Flag as Flag,
    FlagMeta as FlagMeta,
    HrTime as HrTime,
    TimeoutExpired as TimeoutExpired,
    basename as basename,
    cd as cd,
    decode_stdio_bytes as decode_stdio_bytes,
    dirname as dirname,
    do as do,
    do_ as do_,
    do_async as do_async,
    doa as doa,
    export as export,
    flatten_args as flatten_args,
    link_dir as link_dir,
    link_dirs as link_dirs,
    link_file as link_file,
    link_files as link_files,
    ls as ls,
    ls_dirs as ls_dirs,
    ls_files as ls_files,
    ls_files_dirs as ls_files_dirs,
    mkenv as mkenv,
    mv as mv,
    pwd as pwd,
    q as q,
    quote as quote,
    rm as rm,
    run as run,
    seconds2hrtime as seconds2hrtime,
    setenv as setenv,
    shell as shell,
    shplit as shplit,
    shx as shx,
    source as source,
    sync as sync,
    tree as tree,
    unlink_dir as unlink_dir,
    unlink_dirs as unlink_dirs,
    unlink_file as unlink_file,
    unlink_files as unlink_files,
    utf8_string as utf8_string,
    where as where,
    which as which,
    which_lru as which_lru,
    x as x,
)
from shellfish.stdio import Stdio as Stdio

_funkify(sh.do, key="shellfish.sh")
_funkify(sh.do, key="shellfish")

ps = process

__all__ = (
    "LIN",
    "WIN",
    "Done",
    "DoneDict",
    "DoneError",
    "DoneObj",
    "Flag",
    "FlagMeta",
    "FsPath",
    "HrTime",
    "PathLikeBytes",
    "PathLikeStr",
    "PathLikeStrBytes",
    "PopenArg",
    "PopenArgs",
    "PopenArgv",
    "PopenEnv",
    "Stdio",
    "SymlinkType",
    "TimeoutExpired",
    "__version__",
    "aiorun",
    "basename",
    "cd",
    "chmod",
    "copy_file",
    "cp",
    "decode_stdio_bytes",
    "dir_exists",
    "dir_exists_async",
    "dirname",
    "dirpath_gen",
    "dirs_gen",
    "do",
    "do_",
    "do_async",
    "doa",
    "dotenv",
    "echo",
    "env",
    "exists",
    "exists_async",
    "export",
    "extension",
    "file_exists",
    "file_exists_async",
    "file_lines_gen",
    "filecmp",
    "filepath_gen",
    "filepath_mtimedelta_sec",
    "files_dirs_gen",
    "files_gen",
    "filesize",
    "filesize_async",
    "flatten_args",
    "fs",
    "fspath",
    "is_dir",
    "is_dir_async",
    "is_file",
    "is_file_async",
    "is_link",
    "is_link_async",
    "isdir",
    "isdir_async",
    "isfile",
    "isfile_async",
    "islink",
    "islink_async",
    "lbin",
    "lbytes",
    "lbytes_async",
    "lbytes_gen",
    "lbytes_gen_async",
    "link_dir",
    "link_dirs",
    "link_file",
    "link_files",
    "listdir_async",
    "listdir_gen",
    "ljson",
    "ljson_async",
    "ls",
    "ls_dirs",
    "ls_files",
    "ls_files_dirs",
    "lstat_async",
    "lstr",
    "lstr_async",
    "lstring",
    "lstring_async",
    "mkdir",
    "mkdirp",
    "mkenv",
    "move",
    "mv",
    "path",
    "path_gen",
    "process",
    "ps",
    "pwd",
    "q",
    "quote",
    "rbin",
    "rbin_async",
    "rbin_gen",
    "rbin_gen_async",
    "rbytes",
    "rbytes_async",
    "rbytes_gen",
    "rbytes_gen_async",
    "read_bytes",
    "read_bytes_async",
    "read_bytes_gen",
    "read_bytes_gen_async",
    "read_json",
    "read_json_async",
    "read_str",
    "read_str_async",
    "rename",
    "rjson",
    "rjson_async",
    "rm",
    "rm_gen",
    "rmdir",
    "rmfile",
    "rstr",
    "rstr_async",
    "rstring",
    "rstring_async",
    "run",
    "safepath",
    "sbin",
    "sbin_async",
    "sbytes",
    "sbytes_async",
    "sbytes_gen",
    "sbytes_gen_async",
    "scandir",
    "scandir_gen",
    "scandir_list",
    "seconds2hrtime",
    "sep_join",
    "sep_lstrip",
    "sep_rstrip",
    "sep_split",
    "sep_strip",
    "setenv",
    "sh",
    "shebang",
    "shell",
    "shplit",
    "shx",
    "sjson",
    "sjson_async",
    "source",
    "sstr",
    "sstr_async",
    "sstring",
    "sstring_async",
    "stat",
    "stat_async",
    "symlink",
    "sync",
    "touch",
    "tree",
    "unlink_dir",
    "unlink_dirs",
    "unlink_file",
    "unlink_files",
    "utf8_string",
    "walk_gen",
    "wbin",
    "wbin_async",
    "wbin_gen",
    "wbin_gen_async",
    "wbytes",
    "wbytes_async",
    "wbytes_gen",
    "wbytes_gen_async",
    "where",
    "which",
    "which_lru",
    "wjson",
    "wjson_async",
    "write_bytes",
    "write_bytes_async",
    "write_bytes_gen",
    "write_bytes_gen_async",
    "write_json",
    "write_json_async",
    "write_str",
    "write_str_async",
    "wstr",
    "wstr_async",
    "wstring",
    "wstring_async",
    "x",
)
