# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetRulestackResult',
    'AwaitableGetRulestackResult',
    'get_rulestack',
    'get_rulestack_output',
]

@pulumi.output_type
class GetRulestackResult:
    """
    A collection of values returned by getRulestack.
    """
    def __init__(__self__, account_group=None, account_id=None, config_type=None, description=None, id=None, lookup_x_forwarded_for=None, minimum_app_id_version=None, name=None, profile_configs=None, scope=None, state=None, tags=None):
        if account_group and not isinstance(account_group, str):
            raise TypeError("Expected argument 'account_group' to be a str")
        pulumi.set(__self__, "account_group", account_group)
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if config_type and not isinstance(config_type, str):
            raise TypeError("Expected argument 'config_type' to be a str")
        pulumi.set(__self__, "config_type", config_type)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lookup_x_forwarded_for and not isinstance(lookup_x_forwarded_for, str):
            raise TypeError("Expected argument 'lookup_x_forwarded_for' to be a str")
        pulumi.set(__self__, "lookup_x_forwarded_for", lookup_x_forwarded_for)
        if minimum_app_id_version and not isinstance(minimum_app_id_version, str):
            raise TypeError("Expected argument 'minimum_app_id_version' to be a str")
        pulumi.set(__self__, "minimum_app_id_version", minimum_app_id_version)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if profile_configs and not isinstance(profile_configs, list):
            raise TypeError("Expected argument 'profile_configs' to be a list")
        pulumi.set(__self__, "profile_configs", profile_configs)
        if scope and not isinstance(scope, str):
            raise TypeError("Expected argument 'scope' to be a str")
        pulumi.set(__self__, "scope", scope)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="accountGroup")
    def account_group(self) -> _builtins.str:
        """
        Account group.
        """
        return pulumi.get(self, "account_group")

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        The account ID.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="configType")
    def config_type(self) -> Optional[_builtins.str]:
        """
        Retrieve either the candidate or running config. Valid values are `candidate` or `running`. Defaults to `candidate`.
        """
        return pulumi.get(self, "config_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lookupXForwardedFor")
    def lookup_x_forwarded_for(self) -> _builtins.str:
        """
        Lookup x forwarded for.
        """
        return pulumi.get(self, "lookup_x_forwarded_for")

    @_builtins.property
    @pulumi.getter(name="minimumAppIdVersion")
    def minimum_app_id_version(self) -> _builtins.str:
        """
        Minimum App-ID version number.
        """
        return pulumi.get(self, "minimum_app_id_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="profileConfigs")
    def profile_configs(self) -> Sequence['outputs.GetRulestackProfileConfigResult']:
        return pulumi.get(self, "profile_configs")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[_builtins.str]:
        """
        The rulestack's scope. A local rulestack will require that you've retrieved a LRA JWT. A global rulestack will require that you've retrieved a GRA JWT. Valid values are `Local` or `Global`. Defaults to `Local`.
        """
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The rulestack state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        The tags.
        """
        return pulumi.get(self, "tags")


class AwaitableGetRulestackResult(GetRulestackResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRulestackResult(
            account_group=self.account_group,
            account_id=self.account_id,
            config_type=self.config_type,
            description=self.description,
            id=self.id,
            lookup_x_forwarded_for=self.lookup_x_forwarded_for,
            minimum_app_id_version=self.minimum_app_id_version,
            name=self.name,
            profile_configs=self.profile_configs,
            scope=self.scope,
            state=self.state,
            tags=self.tags)


def get_rulestack(config_type: Optional[_builtins.str] = None,
                  name: Optional[_builtins.str] = None,
                  scope: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRulestackResult:
    """
    Data source for retrieving rulestack information.

    ## Admin Permission Type

    * `Rulestack` (for `scope="Local"`)
    * `Global Rulestack` (for `scope="Global"`)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudngfwaws as cloudngfwaws

    example = cloudngfwaws.get_rulestack(name="my-rulestack-name")
    ```


    :param _builtins.str config_type: Retrieve either the candidate or running config. Valid values are `candidate` or `running`. Defaults to `candidate`.
    :param _builtins.str name: The name.
    :param _builtins.str scope: The rulestack's scope. A local rulestack will require that you've retrieved a LRA JWT. A global rulestack will require that you've retrieved a GRA JWT. Valid values are `Local` or `Global`. Defaults to `Local`.
    """
    __args__ = dict()
    __args__['configType'] = config_type
    __args__['name'] = name
    __args__['scope'] = scope
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudngfwaws:index/getRulestack:getRulestack', __args__, opts=opts, typ=GetRulestackResult).value

    return AwaitableGetRulestackResult(
        account_group=pulumi.get(__ret__, 'account_group'),
        account_id=pulumi.get(__ret__, 'account_id'),
        config_type=pulumi.get(__ret__, 'config_type'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        lookup_x_forwarded_for=pulumi.get(__ret__, 'lookup_x_forwarded_for'),
        minimum_app_id_version=pulumi.get(__ret__, 'minimum_app_id_version'),
        name=pulumi.get(__ret__, 'name'),
        profile_configs=pulumi.get(__ret__, 'profile_configs'),
        scope=pulumi.get(__ret__, 'scope'),
        state=pulumi.get(__ret__, 'state'),
        tags=pulumi.get(__ret__, 'tags'))
def get_rulestack_output(config_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         name: Optional[pulumi.Input[_builtins.str]] = None,
                         scope: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRulestackResult]:
    """
    Data source for retrieving rulestack information.

    ## Admin Permission Type

    * `Rulestack` (for `scope="Local"`)
    * `Global Rulestack` (for `scope="Global"`)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudngfwaws as cloudngfwaws

    example = cloudngfwaws.get_rulestack(name="my-rulestack-name")
    ```


    :param _builtins.str config_type: Retrieve either the candidate or running config. Valid values are `candidate` or `running`. Defaults to `candidate`.
    :param _builtins.str name: The name.
    :param _builtins.str scope: The rulestack's scope. A local rulestack will require that you've retrieved a LRA JWT. A global rulestack will require that you've retrieved a GRA JWT. Valid values are `Local` or `Global`. Defaults to `Local`.
    """
    __args__ = dict()
    __args__['configType'] = config_type
    __args__['name'] = name
    __args__['scope'] = scope
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudngfwaws:index/getRulestack:getRulestack', __args__, opts=opts, typ=GetRulestackResult)
    return __ret__.apply(lambda __response__: GetRulestackResult(
        account_group=pulumi.get(__response__, 'account_group'),
        account_id=pulumi.get(__response__, 'account_id'),
        config_type=pulumi.get(__response__, 'config_type'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        lookup_x_forwarded_for=pulumi.get(__response__, 'lookup_x_forwarded_for'),
        minimum_app_id_version=pulumi.get(__response__, 'minimum_app_id_version'),
        name=pulumi.get(__response__, 'name'),
        profile_configs=pulumi.get(__response__, 'profile_configs'),
        scope=pulumi.get(__response__, 'scope'),
        state=pulumi.get(__response__, 'state'),
        tags=pulumi.get(__response__, 'tags')))
