# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['IntelligentFeedArgs', 'IntelligentFeed']

@pulumi.input_type
class IntelligentFeedArgs:
    def __init__(__self__, *,
                 rulestack: pulumi.Input[_builtins.str],
                 url: pulumi.Input[_builtins.str],
                 audit_comment: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 time: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a IntelligentFeed resource.
        :param pulumi.Input[_builtins.str] rulestack: The rulestack.
        :param pulumi.Input[_builtins.str] url: The intelligent feed source.
        :param pulumi.Input[_builtins.str] audit_comment: The audit comment.
        :param pulumi.Input[_builtins.str] certificate: The certificate profile.
        :param pulumi.Input[_builtins.str] description: The description.
        :param pulumi.Input[_builtins.str] frequency: Update frequency. Valid values are `HOURLY` or `DAILY`. Defaults to `HOURLY`.
        :param pulumi.Input[_builtins.str] name: The name.
        :param pulumi.Input[_builtins.str] scope: The rulestack's scope. A local rulestack will require that you've retrieved a LRA JWT. A global rulestack will require that you've retrieved a GRA JWT. Valid values are `Local` or `Global`. Defaults to `Local`.
        :param pulumi.Input[_builtins.int] time: The time to poll for updates if frequency is daily. The number must be between [0, 23] incluside.
        :param pulumi.Input[_builtins.str] type: The intelligent feed type. Valid values are `IP_LIST` or `URL_LIST`. Defaults to `IP_LIST`.
        """
        pulumi.set(__self__, "rulestack", rulestack)
        pulumi.set(__self__, "url", url)
        if audit_comment is not None:
            pulumi.set(__self__, "audit_comment", audit_comment)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if time is not None:
            pulumi.set(__self__, "time", time)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def rulestack(self) -> pulumi.Input[_builtins.str]:
        """
        The rulestack.
        """
        return pulumi.get(self, "rulestack")

    @rulestack.setter
    def rulestack(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rulestack", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Input[_builtins.str]:
        """
        The intelligent feed source.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="auditComment")
    def audit_comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The audit comment.
        """
        return pulumi.get(self, "audit_comment")

    @audit_comment.setter
    def audit_comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "audit_comment", value)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate profile.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Update frequency. Valid values are `HOURLY` or `DAILY`. Defaults to `HOURLY`.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "frequency", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rulestack's scope. A local rulestack will require that you've retrieved a LRA JWT. A global rulestack will require that you've retrieved a GRA JWT. Valid values are `Local` or `Global`. Defaults to `Local`.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope", value)

    @_builtins.property
    @pulumi.getter
    def time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time to poll for updates if frequency is daily. The number must be between [0, 23] incluside.
        """
        return pulumi.get(self, "time")

    @time.setter
    def time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "time", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The intelligent feed type. Valid values are `IP_LIST` or `URL_LIST`. Defaults to `IP_LIST`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _IntelligentFeedState:
    def __init__(__self__, *,
                 audit_comment: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rulestack: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 time: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 update_token: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IntelligentFeed resources.
        :param pulumi.Input[_builtins.str] audit_comment: The audit comment.
        :param pulumi.Input[_builtins.str] certificate: The certificate profile.
        :param pulumi.Input[_builtins.str] description: The description.
        :param pulumi.Input[_builtins.str] frequency: Update frequency. Valid values are `HOURLY` or `DAILY`. Defaults to `HOURLY`.
        :param pulumi.Input[_builtins.str] name: The name.
        :param pulumi.Input[_builtins.str] rulestack: The rulestack.
        :param pulumi.Input[_builtins.str] scope: The rulestack's scope. A local rulestack will require that you've retrieved a LRA JWT. A global rulestack will require that you've retrieved a GRA JWT. Valid values are `Local` or `Global`. Defaults to `Local`.
        :param pulumi.Input[_builtins.int] time: The time to poll for updates if frequency is daily. The number must be between [0, 23] incluside.
        :param pulumi.Input[_builtins.str] type: The intelligent feed type. Valid values are `IP_LIST` or `URL_LIST`. Defaults to `IP_LIST`.
        :param pulumi.Input[_builtins.str] update_token: The update token.
        :param pulumi.Input[_builtins.str] url: The intelligent feed source.
        """
        if audit_comment is not None:
            pulumi.set(__self__, "audit_comment", audit_comment)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rulestack is not None:
            pulumi.set(__self__, "rulestack", rulestack)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if time is not None:
            pulumi.set(__self__, "time", time)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if update_token is not None:
            pulumi.set(__self__, "update_token", update_token)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="auditComment")
    def audit_comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The audit comment.
        """
        return pulumi.get(self, "audit_comment")

    @audit_comment.setter
    def audit_comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "audit_comment", value)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate profile.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Update frequency. Valid values are `HOURLY` or `DAILY`. Defaults to `HOURLY`.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "frequency", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def rulestack(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rulestack.
        """
        return pulumi.get(self, "rulestack")

    @rulestack.setter
    def rulestack(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rulestack", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rulestack's scope. A local rulestack will require that you've retrieved a LRA JWT. A global rulestack will require that you've retrieved a GRA JWT. Valid values are `Local` or `Global`. Defaults to `Local`.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope", value)

    @_builtins.property
    @pulumi.getter
    def time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time to poll for updates if frequency is daily. The number must be between [0, 23] incluside.
        """
        return pulumi.get(self, "time")

    @time.setter
    def time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "time", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The intelligent feed type. Valid values are `IP_LIST` or `URL_LIST`. Defaults to `IP_LIST`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="updateToken")
    def update_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The update token.
        """
        return pulumi.get(self, "update_token")

    @update_token.setter
    def update_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_token", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The intelligent feed source.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("cloudngfwaws:index/intelligentFeed:IntelligentFeed")
class IntelligentFeed(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_comment: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rulestack: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 time: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for intelligent feed manipulation.

        ## Admin Permission Type

        * `Rulestack` (for `scope="Local"`)
        * `Global Rulestack` (for `scope="Global"`)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudngfwaws as cloudngfwaws

        r = cloudngfwaws.Rulestack("r",
            name="terraform-rulestack",
            scope="Local",
            account_id="123456789",
            description="Made by Pulumi",
            profile_config={
                "anti_spyware": "BestPractice",
            })
        # Retrieve the feed information every day at midnight.
        example = cloudngfwaws.IntelligentFeed("example",
            rulestack=r.name,
            name="tf-feed",
            description="Also configured by Terraform",
            url="https://foobar.net",
            type="URL_LIST",
            frequency="DAILY",
            time=0)
        ```

        ## Import

        import name is <scope>:<rulestack>:<intelligent_feed_name>

        ```sh
        $ pulumi import cloudngfwaws:index/intelligentFeed:IntelligentFeed example Local:terraform-rulestack:tf-feed
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] audit_comment: The audit comment.
        :param pulumi.Input[_builtins.str] certificate: The certificate profile.
        :param pulumi.Input[_builtins.str] description: The description.
        :param pulumi.Input[_builtins.str] frequency: Update frequency. Valid values are `HOURLY` or `DAILY`. Defaults to `HOURLY`.
        :param pulumi.Input[_builtins.str] name: The name.
        :param pulumi.Input[_builtins.str] rulestack: The rulestack.
        :param pulumi.Input[_builtins.str] scope: The rulestack's scope. A local rulestack will require that you've retrieved a LRA JWT. A global rulestack will require that you've retrieved a GRA JWT. Valid values are `Local` or `Global`. Defaults to `Local`.
        :param pulumi.Input[_builtins.int] time: The time to poll for updates if frequency is daily. The number must be between [0, 23] incluside.
        :param pulumi.Input[_builtins.str] type: The intelligent feed type. Valid values are `IP_LIST` or `URL_LIST`. Defaults to `IP_LIST`.
        :param pulumi.Input[_builtins.str] url: The intelligent feed source.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntelligentFeedArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for intelligent feed manipulation.

        ## Admin Permission Type

        * `Rulestack` (for `scope="Local"`)
        * `Global Rulestack` (for `scope="Global"`)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudngfwaws as cloudngfwaws

        r = cloudngfwaws.Rulestack("r",
            name="terraform-rulestack",
            scope="Local",
            account_id="123456789",
            description="Made by Pulumi",
            profile_config={
                "anti_spyware": "BestPractice",
            })
        # Retrieve the feed information every day at midnight.
        example = cloudngfwaws.IntelligentFeed("example",
            rulestack=r.name,
            name="tf-feed",
            description="Also configured by Terraform",
            url="https://foobar.net",
            type="URL_LIST",
            frequency="DAILY",
            time=0)
        ```

        ## Import

        import name is <scope>:<rulestack>:<intelligent_feed_name>

        ```sh
        $ pulumi import cloudngfwaws:index/intelligentFeed:IntelligentFeed example Local:terraform-rulestack:tf-feed
        ```

        :param str resource_name: The name of the resource.
        :param IntelligentFeedArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntelligentFeedArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_comment: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rulestack: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 time: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntelligentFeedArgs.__new__(IntelligentFeedArgs)

            __props__.__dict__["audit_comment"] = audit_comment
            __props__.__dict__["certificate"] = certificate
            __props__.__dict__["description"] = description
            __props__.__dict__["frequency"] = frequency
            __props__.__dict__["name"] = name
            if rulestack is None and not opts.urn:
                raise TypeError("Missing required property 'rulestack'")
            __props__.__dict__["rulestack"] = rulestack
            __props__.__dict__["scope"] = scope
            __props__.__dict__["time"] = time
            __props__.__dict__["type"] = type
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__.__dict__["url"] = url
            __props__.__dict__["update_token"] = None
        super(IntelligentFeed, __self__).__init__(
            'cloudngfwaws:index/intelligentFeed:IntelligentFeed',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            audit_comment: Optional[pulumi.Input[_builtins.str]] = None,
            certificate: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            frequency: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            rulestack: Optional[pulumi.Input[_builtins.str]] = None,
            scope: Optional[pulumi.Input[_builtins.str]] = None,
            time: Optional[pulumi.Input[_builtins.int]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            update_token: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None) -> 'IntelligentFeed':
        """
        Get an existing IntelligentFeed resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] audit_comment: The audit comment.
        :param pulumi.Input[_builtins.str] certificate: The certificate profile.
        :param pulumi.Input[_builtins.str] description: The description.
        :param pulumi.Input[_builtins.str] frequency: Update frequency. Valid values are `HOURLY` or `DAILY`. Defaults to `HOURLY`.
        :param pulumi.Input[_builtins.str] name: The name.
        :param pulumi.Input[_builtins.str] rulestack: The rulestack.
        :param pulumi.Input[_builtins.str] scope: The rulestack's scope. A local rulestack will require that you've retrieved a LRA JWT. A global rulestack will require that you've retrieved a GRA JWT. Valid values are `Local` or `Global`. Defaults to `Local`.
        :param pulumi.Input[_builtins.int] time: The time to poll for updates if frequency is daily. The number must be between [0, 23] incluside.
        :param pulumi.Input[_builtins.str] type: The intelligent feed type. Valid values are `IP_LIST` or `URL_LIST`. Defaults to `IP_LIST`.
        :param pulumi.Input[_builtins.str] update_token: The update token.
        :param pulumi.Input[_builtins.str] url: The intelligent feed source.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntelligentFeedState.__new__(_IntelligentFeedState)

        __props__.__dict__["audit_comment"] = audit_comment
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["description"] = description
        __props__.__dict__["frequency"] = frequency
        __props__.__dict__["name"] = name
        __props__.__dict__["rulestack"] = rulestack
        __props__.__dict__["scope"] = scope
        __props__.__dict__["time"] = time
        __props__.__dict__["type"] = type
        __props__.__dict__["update_token"] = update_token
        __props__.__dict__["url"] = url
        return IntelligentFeed(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="auditComment")
    def audit_comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The audit comment.
        """
        return pulumi.get(self, "audit_comment")

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The certificate profile.
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Update frequency. Valid values are `HOURLY` or `DAILY`. Defaults to `HOURLY`.
        """
        return pulumi.get(self, "frequency")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def rulestack(self) -> pulumi.Output[_builtins.str]:
        """
        The rulestack.
        """
        return pulumi.get(self, "rulestack")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The rulestack's scope. A local rulestack will require that you've retrieved a LRA JWT. A global rulestack will require that you've retrieved a GRA JWT. Valid values are `Local` or `Global`. Defaults to `Local`.
        """
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter
    def time(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The time to poll for updates if frequency is daily. The number must be between [0, 23] incluside.
        """
        return pulumi.get(self, "time")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The intelligent feed type. Valid values are `IP_LIST` or `URL_LIST`. Defaults to `IP_LIST`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updateToken")
    def update_token(self) -> pulumi.Output[_builtins.str]:
        """
        The update token.
        """
        return pulumi.get(self, "update_token")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        The intelligent feed source.
        """
        return pulumi.get(self, "url")

