# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NgfwLogProfileArgs', 'NgfwLogProfile']

@pulumi.input_type
class NgfwLogProfileArgs:
    def __init__(__self__, *,
                 firewall_id: pulumi.Input[_builtins.str],
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 advanced_threat_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 cloud_watch_metric_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 cloudwatch_metric_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_config: Optional[pulumi.Input['NgfwLogProfileLogConfigArgs']] = None,
                 log_destinations: Optional[pulumi.Input[Sequence[pulumi.Input['NgfwLogProfileLogDestinationArgs']]]] = None,
                 ngfw: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NgfwLogProfile resource.
        :param pulumi.Input[_builtins.str] firewall_id: The Firewall Id for the NGFW.
        :param pulumi.Input[_builtins.str] account_id: The unique ID of the account.
        :param pulumi.Input[_builtins.bool] advanced_threat_log: Enable advanced threat logging.
        :param pulumi.Input[_builtins.str] cloud_watch_metric_namespace: The CloudWatch metric namespace.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cloudwatch_metric_fields: Cloudwatch metric fields.
        :param pulumi.Input['NgfwLogProfileLogConfigArgs'] log_config: Log configuration details.
        :param pulumi.Input[Sequence[pulumi.Input['NgfwLogProfileLogDestinationArgs']]] log_destinations: List of log destinations.
        :param pulumi.Input[_builtins.str] ngfw: The name of the NGFW.
        :param pulumi.Input[_builtins.str] region: The region of the NGFW.
        """
        pulumi.set(__self__, "firewall_id", firewall_id)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if advanced_threat_log is not None:
            pulumi.set(__self__, "advanced_threat_log", advanced_threat_log)
        if cloud_watch_metric_namespace is not None:
            pulumi.set(__self__, "cloud_watch_metric_namespace", cloud_watch_metric_namespace)
        if cloudwatch_metric_fields is not None:
            pulumi.set(__self__, "cloudwatch_metric_fields", cloudwatch_metric_fields)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if log_destinations is not None:
            pulumi.set(__self__, "log_destinations", log_destinations)
        if ngfw is not None:
            pulumi.set(__self__, "ngfw", ngfw)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="firewallId")
    def firewall_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Firewall Id for the NGFW.
        """
        return pulumi.get(self, "firewall_id")

    @firewall_id.setter
    def firewall_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "firewall_id", value)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique ID of the account.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="advancedThreatLog")
    def advanced_threat_log(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable advanced threat logging.
        """
        return pulumi.get(self, "advanced_threat_log")

    @advanced_threat_log.setter
    def advanced_threat_log(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "advanced_threat_log", value)

    @_builtins.property
    @pulumi.getter(name="cloudWatchMetricNamespace")
    def cloud_watch_metric_namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CloudWatch metric namespace.
        """
        return pulumi.get(self, "cloud_watch_metric_namespace")

    @cloud_watch_metric_namespace.setter
    def cloud_watch_metric_namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_watch_metric_namespace", value)

    @_builtins.property
    @pulumi.getter(name="cloudwatchMetricFields")
    def cloudwatch_metric_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Cloudwatch metric fields.
        """
        return pulumi.get(self, "cloudwatch_metric_fields")

    @cloudwatch_metric_fields.setter
    def cloudwatch_metric_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "cloudwatch_metric_fields", value)

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['NgfwLogProfileLogConfigArgs']]:
        """
        Log configuration details.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['NgfwLogProfileLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @_builtins.property
    @pulumi.getter(name="logDestinations")
    def log_destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NgfwLogProfileLogDestinationArgs']]]]:
        """
        List of log destinations.
        """
        return pulumi.get(self, "log_destinations")

    @log_destinations.setter
    def log_destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NgfwLogProfileLogDestinationArgs']]]]):
        pulumi.set(self, "log_destinations", value)

    @_builtins.property
    @pulumi.getter
    def ngfw(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the NGFW.
        """
        return pulumi.get(self, "ngfw")

    @ngfw.setter
    def ngfw(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ngfw", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the NGFW.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _NgfwLogProfileState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 advanced_threat_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 cloud_watch_metric_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 cloudwatch_metric_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 firewall_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_config: Optional[pulumi.Input['NgfwLogProfileLogConfigArgs']] = None,
                 log_destinations: Optional[pulumi.Input[Sequence[pulumi.Input['NgfwLogProfileLogDestinationArgs']]]] = None,
                 ngfw: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 update_token: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NgfwLogProfile resources.
        :param pulumi.Input[_builtins.str] account_id: The unique ID of the account.
        :param pulumi.Input[_builtins.bool] advanced_threat_log: Enable advanced threat logging.
        :param pulumi.Input[_builtins.str] cloud_watch_metric_namespace: The CloudWatch metric namespace.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cloudwatch_metric_fields: Cloudwatch metric fields.
        :param pulumi.Input[_builtins.str] firewall_id: The Firewall Id for the NGFW.
        :param pulumi.Input['NgfwLogProfileLogConfigArgs'] log_config: Log configuration details.
        :param pulumi.Input[Sequence[pulumi.Input['NgfwLogProfileLogDestinationArgs']]] log_destinations: List of log destinations.
        :param pulumi.Input[_builtins.str] ngfw: The name of the NGFW.
        :param pulumi.Input[_builtins.str] region: The region of the NGFW.
        :param pulumi.Input[_builtins.str] update_token: The update token.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if advanced_threat_log is not None:
            pulumi.set(__self__, "advanced_threat_log", advanced_threat_log)
        if cloud_watch_metric_namespace is not None:
            pulumi.set(__self__, "cloud_watch_metric_namespace", cloud_watch_metric_namespace)
        if cloudwatch_metric_fields is not None:
            pulumi.set(__self__, "cloudwatch_metric_fields", cloudwatch_metric_fields)
        if firewall_id is not None:
            pulumi.set(__self__, "firewall_id", firewall_id)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if log_destinations is not None:
            pulumi.set(__self__, "log_destinations", log_destinations)
        if ngfw is not None:
            pulumi.set(__self__, "ngfw", ngfw)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if update_token is not None:
            pulumi.set(__self__, "update_token", update_token)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique ID of the account.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="advancedThreatLog")
    def advanced_threat_log(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable advanced threat logging.
        """
        return pulumi.get(self, "advanced_threat_log")

    @advanced_threat_log.setter
    def advanced_threat_log(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "advanced_threat_log", value)

    @_builtins.property
    @pulumi.getter(name="cloudWatchMetricNamespace")
    def cloud_watch_metric_namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CloudWatch metric namespace.
        """
        return pulumi.get(self, "cloud_watch_metric_namespace")

    @cloud_watch_metric_namespace.setter
    def cloud_watch_metric_namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_watch_metric_namespace", value)

    @_builtins.property
    @pulumi.getter(name="cloudwatchMetricFields")
    def cloudwatch_metric_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Cloudwatch metric fields.
        """
        return pulumi.get(self, "cloudwatch_metric_fields")

    @cloudwatch_metric_fields.setter
    def cloudwatch_metric_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "cloudwatch_metric_fields", value)

    @_builtins.property
    @pulumi.getter(name="firewallId")
    def firewall_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Firewall Id for the NGFW.
        """
        return pulumi.get(self, "firewall_id")

    @firewall_id.setter
    def firewall_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "firewall_id", value)

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['NgfwLogProfileLogConfigArgs']]:
        """
        Log configuration details.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['NgfwLogProfileLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @_builtins.property
    @pulumi.getter(name="logDestinations")
    def log_destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NgfwLogProfileLogDestinationArgs']]]]:
        """
        List of log destinations.
        """
        return pulumi.get(self, "log_destinations")

    @log_destinations.setter
    def log_destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NgfwLogProfileLogDestinationArgs']]]]):
        pulumi.set(self, "log_destinations", value)

    @_builtins.property
    @pulumi.getter
    def ngfw(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the NGFW.
        """
        return pulumi.get(self, "ngfw")

    @ngfw.setter
    def ngfw(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ngfw", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the NGFW.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="updateToken")
    def update_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The update token.
        """
        return pulumi.get(self, "update_token")

    @update_token.setter
    def update_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_token", value)


@pulumi.type_token("cloudngfwaws:index/ngfwLogProfile:NgfwLogProfile")
class NgfwLogProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 advanced_threat_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 cloud_watch_metric_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 cloudwatch_metric_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 firewall_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_config: Optional[pulumi.Input[Union['NgfwLogProfileLogConfigArgs', 'NgfwLogProfileLogConfigArgsDict']]] = None,
                 log_destinations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NgfwLogProfileLogDestinationArgs', 'NgfwLogProfileLogDestinationArgsDict']]]]] = None,
                 ngfw: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for NGFW log profile manipulation.

        ## Admin Permission Type

        * `Firewall`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_cloudngfwaws as cloudngfwaws

        example_vpc = aws.index.Vpc("example",
            cidr_block=172.16.0.0/16,
            tags={
                name: tf-example,
            })
        subnet1 = aws.index.Subnet("subnet1",
            vpc_id=my_vpc.id,
            cidr_block=172.16.10.0/24,
            availability_zone=us-west-2a,
            tags={
                name: tf-example,
            })
        x = cloudngfwaws.Ngfw("x",
            name="example-instance",
            description="Example description",
            endpoints=[{
                "subnet_id": subnet1["id"],
                "mode": "ServiceManaged",
                "vpc_id": example_vpc["id"],
                "account_id": "12345678",
            }],
            rulestack="example-rulestack",
            tags={
                "Foo": "bar",
            })
        example = cloudngfwaws.NgfwLogProfile("example",
            firewall_id=x.firewall_id,
            account_id=x.account_id,
            advanced_threat_log=True,
            cloudwatch_metric_fields=[
                "Dataplane_CPU_Utilization",
                "Session_Throughput_Kbps",
                "BytesIn",
                "BytesOut",
            ],
            cloud_watch_metric_namespace="PaloAltoCloudNGFW",
            log_config={
                "log_destination": "my-s3-bucket",
                "log_destination_type": "S3",
                "log_types": ["TRAFFIC"],
                "account_id": "251583708250",
                "role_type": "IamBased",
            })
        subnet2 = aws.index.Subnet("subnet2",
            vpc_id=my_vpc.id,
            cidr_block=172.16.20.0/24,
            availability_zone=us-west-2b,
            tags={
                name: tf-example,
            })
        ```

        ## Import

        import name is <account_id>:<ngfw>

        ```sh
        $ pulumi import cloudngfwaws:index/ngfwLogProfile:NgfwLogProfile example 12345678:example-instance
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The unique ID of the account.
        :param pulumi.Input[_builtins.bool] advanced_threat_log: Enable advanced threat logging.
        :param pulumi.Input[_builtins.str] cloud_watch_metric_namespace: The CloudWatch metric namespace.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cloudwatch_metric_fields: Cloudwatch metric fields.
        :param pulumi.Input[_builtins.str] firewall_id: The Firewall Id for the NGFW.
        :param pulumi.Input[Union['NgfwLogProfileLogConfigArgs', 'NgfwLogProfileLogConfigArgsDict']] log_config: Log configuration details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NgfwLogProfileLogDestinationArgs', 'NgfwLogProfileLogDestinationArgsDict']]]] log_destinations: List of log destinations.
        :param pulumi.Input[_builtins.str] ngfw: The name of the NGFW.
        :param pulumi.Input[_builtins.str] region: The region of the NGFW.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NgfwLogProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for NGFW log profile manipulation.

        ## Admin Permission Type

        * `Firewall`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_cloudngfwaws as cloudngfwaws

        example_vpc = aws.index.Vpc("example",
            cidr_block=172.16.0.0/16,
            tags={
                name: tf-example,
            })
        subnet1 = aws.index.Subnet("subnet1",
            vpc_id=my_vpc.id,
            cidr_block=172.16.10.0/24,
            availability_zone=us-west-2a,
            tags={
                name: tf-example,
            })
        x = cloudngfwaws.Ngfw("x",
            name="example-instance",
            description="Example description",
            endpoints=[{
                "subnet_id": subnet1["id"],
                "mode": "ServiceManaged",
                "vpc_id": example_vpc["id"],
                "account_id": "12345678",
            }],
            rulestack="example-rulestack",
            tags={
                "Foo": "bar",
            })
        example = cloudngfwaws.NgfwLogProfile("example",
            firewall_id=x.firewall_id,
            account_id=x.account_id,
            advanced_threat_log=True,
            cloudwatch_metric_fields=[
                "Dataplane_CPU_Utilization",
                "Session_Throughput_Kbps",
                "BytesIn",
                "BytesOut",
            ],
            cloud_watch_metric_namespace="PaloAltoCloudNGFW",
            log_config={
                "log_destination": "my-s3-bucket",
                "log_destination_type": "S3",
                "log_types": ["TRAFFIC"],
                "account_id": "251583708250",
                "role_type": "IamBased",
            })
        subnet2 = aws.index.Subnet("subnet2",
            vpc_id=my_vpc.id,
            cidr_block=172.16.20.0/24,
            availability_zone=us-west-2b,
            tags={
                name: tf-example,
            })
        ```

        ## Import

        import name is <account_id>:<ngfw>

        ```sh
        $ pulumi import cloudngfwaws:index/ngfwLogProfile:NgfwLogProfile example 12345678:example-instance
        ```

        :param str resource_name: The name of the resource.
        :param NgfwLogProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NgfwLogProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 advanced_threat_log: Optional[pulumi.Input[_builtins.bool]] = None,
                 cloud_watch_metric_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 cloudwatch_metric_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 firewall_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_config: Optional[pulumi.Input[Union['NgfwLogProfileLogConfigArgs', 'NgfwLogProfileLogConfigArgsDict']]] = None,
                 log_destinations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NgfwLogProfileLogDestinationArgs', 'NgfwLogProfileLogDestinationArgsDict']]]]] = None,
                 ngfw: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NgfwLogProfileArgs.__new__(NgfwLogProfileArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["advanced_threat_log"] = advanced_threat_log
            __props__.__dict__["cloud_watch_metric_namespace"] = cloud_watch_metric_namespace
            __props__.__dict__["cloudwatch_metric_fields"] = cloudwatch_metric_fields
            if firewall_id is None and not opts.urn:
                raise TypeError("Missing required property 'firewall_id'")
            __props__.__dict__["firewall_id"] = firewall_id
            __props__.__dict__["log_config"] = log_config
            __props__.__dict__["log_destinations"] = log_destinations
            __props__.__dict__["ngfw"] = ngfw
            __props__.__dict__["region"] = region
            __props__.__dict__["update_token"] = None
        super(NgfwLogProfile, __self__).__init__(
            'cloudngfwaws:index/ngfwLogProfile:NgfwLogProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            advanced_threat_log: Optional[pulumi.Input[_builtins.bool]] = None,
            cloud_watch_metric_namespace: Optional[pulumi.Input[_builtins.str]] = None,
            cloudwatch_metric_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            firewall_id: Optional[pulumi.Input[_builtins.str]] = None,
            log_config: Optional[pulumi.Input[Union['NgfwLogProfileLogConfigArgs', 'NgfwLogProfileLogConfigArgsDict']]] = None,
            log_destinations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NgfwLogProfileLogDestinationArgs', 'NgfwLogProfileLogDestinationArgsDict']]]]] = None,
            ngfw: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            update_token: Optional[pulumi.Input[_builtins.str]] = None) -> 'NgfwLogProfile':
        """
        Get an existing NgfwLogProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The unique ID of the account.
        :param pulumi.Input[_builtins.bool] advanced_threat_log: Enable advanced threat logging.
        :param pulumi.Input[_builtins.str] cloud_watch_metric_namespace: The CloudWatch metric namespace.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cloudwatch_metric_fields: Cloudwatch metric fields.
        :param pulumi.Input[_builtins.str] firewall_id: The Firewall Id for the NGFW.
        :param pulumi.Input[Union['NgfwLogProfileLogConfigArgs', 'NgfwLogProfileLogConfigArgsDict']] log_config: Log configuration details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NgfwLogProfileLogDestinationArgs', 'NgfwLogProfileLogDestinationArgsDict']]]] log_destinations: List of log destinations.
        :param pulumi.Input[_builtins.str] ngfw: The name of the NGFW.
        :param pulumi.Input[_builtins.str] region: The region of the NGFW.
        :param pulumi.Input[_builtins.str] update_token: The update token.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NgfwLogProfileState.__new__(_NgfwLogProfileState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["advanced_threat_log"] = advanced_threat_log
        __props__.__dict__["cloud_watch_metric_namespace"] = cloud_watch_metric_namespace
        __props__.__dict__["cloudwatch_metric_fields"] = cloudwatch_metric_fields
        __props__.__dict__["firewall_id"] = firewall_id
        __props__.__dict__["log_config"] = log_config
        __props__.__dict__["log_destinations"] = log_destinations
        __props__.__dict__["ngfw"] = ngfw
        __props__.__dict__["region"] = region
        __props__.__dict__["update_token"] = update_token
        return NgfwLogProfile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The unique ID of the account.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="advancedThreatLog")
    def advanced_threat_log(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable advanced threat logging.
        """
        return pulumi.get(self, "advanced_threat_log")

    @_builtins.property
    @pulumi.getter(name="cloudWatchMetricNamespace")
    def cloud_watch_metric_namespace(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The CloudWatch metric namespace.
        """
        return pulumi.get(self, "cloud_watch_metric_namespace")

    @_builtins.property
    @pulumi.getter(name="cloudwatchMetricFields")
    def cloudwatch_metric_fields(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Cloudwatch metric fields.
        """
        return pulumi.get(self, "cloudwatch_metric_fields")

    @_builtins.property
    @pulumi.getter(name="firewallId")
    def firewall_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Firewall Id for the NGFW.
        """
        return pulumi.get(self, "firewall_id")

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> pulumi.Output[Optional['outputs.NgfwLogProfileLogConfig']]:
        """
        Log configuration details.
        """
        return pulumi.get(self, "log_config")

    @_builtins.property
    @pulumi.getter(name="logDestinations")
    def log_destinations(self) -> pulumi.Output[Optional[Sequence['outputs.NgfwLogProfileLogDestination']]]:
        """
        List of log destinations.
        """
        return pulumi.get(self, "log_destinations")

    @_builtins.property
    @pulumi.getter
    def ngfw(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the NGFW.
        """
        return pulumi.get(self, "ngfw")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region of the NGFW.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="updateToken")
    def update_token(self) -> pulumi.Output[_builtins.str]:
        """
        The update token.
        """
        return pulumi.get(self, "update_token")

