import os

DEPLOY_SAFE_VERSION = "1.4.1"
SAFE_CONTRACT_VERSIONS = (
    "0.0.1",
    "1.0.0",
    "1.1.1",
    "1.2.0",
    "1.3.0",
    "1.4.1",
)
SAFE_DEBUG = True if "SAFE_DEBUG" in os.environ else False
SALT_SENTINEL = "random"
TRUNCATE_DATA_BYTES = 500

# Safe v1.4.1 canonical addresses
DEFAULT_CREATECALL_ADDRESS = "0x9b35Af71d77eaf8d7e40252370304687390A1A52"
DEFAULT_FALLBACK_ADDRESS = "0xfd0732Dc9E303f09fCEf3a7388Ad10A83459Ec99"
DEFAULT_MULTISEND_ADDRESS = "0x38869bf66a61cF6bDB996A6aE40D5853Fd43B526"
DEFAULT_MULTISEND_CALLONLY_ADDRESS = "0x9641d764fc13c8B624c04430C7356C1C7C8102e2"
DEFAULT_PROXYFACTORY_ADDRESS = "0x4e1DCf7AD4e460CfD30791CCC4F9c8a4f820ec67"
DEFAULT_SAFEL2_SINGLETON_ADDRESS = "0x29fcB43b46531BcA003ddC8FCB67FFE91900C762"
DEFAULT_SAFE_SINGLETON_ADDRESS = "0x41675C099F32341bf84BFc5382aF534df5C7461a"

# Safe v1.4.1 setup() function
# setup(address[],uint256,address,bytes,address,address,uint256,address)
SAFE_SETUP_FUNC_SELECTOR = "0xb63e800d"
SAFE_SETUP_FUNC_TYPES = (
    "address[]",
    "uint256",
    "address",
    "bytes",
    "address",
    "address",
    "uint256",
    "address",
)

# Symbols
SYMBOL_CHECK = "✔"
SYMBOL_CROSS = "✖"
SYMBOL_CAUTION = "!!"
SYMBOL_WARNING = "⚠️"
