from typing import Dict

import uvicorn
from flowcept.flowceptor.consumers.agent.base_agent_context_manager import BaseAgentContextManager
from flowcept.flowceptor.consumers.agent.client_agent import run_tool
from flowcept.instrumentation.flowcept_agent_task import agent_flowcept_task
from mcp.server.fastmcp import FastMCP

from flowcept.configs import AGENT


class Agent2ContextManager(BaseAgentContextManager):

    def __init__(self):
        super().__init__()

    def message_handler(self, msg_obj: Dict) -> bool:
        print(msg_obj)
        if msg_obj.get('type', '') == 'task':
            subtype = msg_obj.get("subtype", '')
            if subtype == 'call_agent_task':
                tool_name = msg_obj["activity_id"]
                args = msg_obj["used"]
                if tool_name == 'agent_task2':
                    self.logger.debug(f"I am Agent 2. I saw that Agent 1 executed agent_task1 and sent its message to the MQ.\nNow I'm going to execute my action.")
                    self.logger.debug(f"Args for agent_task2: {args}")
                    r = run_tool(tool_name="agent_task2", kwargs={"data": args["data"]}, port=8001)
                    self.logger.info(f"Response: {r}")
        return True


agent_controller = Agent2ContextManager()
mcp = FastMCP("Agent2", require_session=True, lifespan=agent_controller.lifespan)


@mcp.tool()
@agent_flowcept_task  # Must be in this order. @mcp.tool then @flowcept_task
def agent_task2(data):
    print(f"This is the data generated by Agent 1: {data}")
    return {
        "msg": "I'm agent 2 and I executed!",
    }

@mcp.tool()
def liveness():
    return "Im alive"


def main():
    """
    Start the MCP server.
    """
    uvicorn.run(
        mcp.streamable_http_app, host=AGENT.get("mcp_host", "0.0.0.0"), port=8001, lifespan="on"
    )


if __name__ == "__main__":
    main()

