"""Add DBCache table

Revision ID: e5ec30dfcd87
Revises: c90d46f6d3f2
Create Date: 2024-12-17 16:48:04.006190

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "e5ec30dfcd87"
down_revision = "c90d46f6d3f2"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "dbcache",
        sa.Column("id", sa.String(length=255), nullable=False),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column("namespace", sa.String(), nullable=False),
        sa.Column("cache_key", sa.String(), nullable=False),
        sa.Column("cache_value", postgresql.BYTEA(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(op.f("ix_dbcache_id"), "dbcache", ["id"], unique=False)
    op.create_index(
        op.f("ix_dbcache_namespace"), "dbcache", ["namespace"], unique=False
    )
    # Index over (namespace, cache_key), with unique set to True to ensure
    # unique cache keys within a namespace
    op.create_index(
        op.f("ix_dbcache_namespace_cache_key"),
        "dbcache",
        ["namespace", "cache_key"],
        unique=True,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_dbcache_namespace"), table_name="dbcache")
    op.drop_index(op.f("ix_dbcache_id"), table_name="dbcache")
    op.drop_index(op.f("ix_dbcache_namespace_cache_key"), table_name="dbcache")
    op.drop_table("dbcache")
    # ### end Alembic commands ###
