"""added duplicate group table

Revision ID: 80d28dea3b6b
Revises: c09e76282dd1
Create Date: 2025-10-29 16:59:09.551676

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "80d28dea3b6b"
down_revision = "c09e76282dd1"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "duplicate_group",
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column("id", postgresql.UUID(as_uuid=True), nullable=False),
        sa.Column("rule_version", sa.Text(), nullable=False),
        sa.Column("is_active", sa.Boolean(), server_default="t", nullable=False),
        sa.Column("dedup_key", sa.Text(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.drop_index(
        "ix_privacyrequest_duplicate_request_group_id", table_name="privacyrequest"
    )
    op.drop_column("privacyrequest", "duplicate_request_group_id")
    op.add_column(
        "privacyrequest",
        sa.Column(
            "duplicate_request_group_id", postgresql.UUID(as_uuid=True), nullable=True
        ),
    )
    op.create_foreign_key(
        "fk_privacyrequest_duplicate_group",
        "privacyrequest",
        "duplicate_group",
        ["duplicate_request_group_id"],
        ["id"],
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(
        "fk_privacyrequest_duplicate_group", "privacyrequest", type_="foreignkey"
    )
    op.drop_column("privacyrequest", "duplicate_request_group_id")
    op.add_column(
        "privacyrequest",
        sa.Column("duplicate_request_group_id", sa.String(), nullable=True),
    )
    op.create_index(
        "ix_privacyrequest_duplicate_request_group_id",
        "privacyrequest",
        ["duplicate_request_group_id"],
        unique=False,
    )
    op.drop_table("duplicate_group")
    # ### end Alembic commands ###
