# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# import os
# import sys
# sys.path.insert(0, os.path.abspath('.'))


# -- Project information -----------------------------------------------------

project = "annofab-cli"
copyright = "2020"
author = "yuji38kwmt"


# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = ["sphinx_last_updated_by_git", "sphinxarg.ext"]

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = "ja"

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ["_build", "Thumbs.db", ".DS_Store"]

# コードブロックのほとんどがコマンドの説明なので、デフォルトのハイライト言語はpythonからtextに変更する
# https://www.sphinx-doc.org/ja/master/usage/configuration.html#confval-highlight_language
highlight_language = "text"

# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "pydata_sphinx_theme"

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ["_static"]

html_css_files = ["css/custom.css"]

html_theme_options = {
    "github_url": "https://github.com/kurusugawa-computer/annofab-cli",
    "use_edit_page_button": True,
    # "last_updated" を footerに配置すると広告に重なるので、"last_updated"は右側に配置する
    "secondary_sidebar_items": ["page-toc", "edit-this-page", "last-updated"],
    
    # icon_links`を指定しないと、pydata-sphinx-theme v0.13.0で
    # Handler <function update_config at 0x7f0333cb1430> for event 'builder-inited' threw an exception (exception: 'icon_links') というエラーが発生する  # noqa: E501
    # https://github.com/pydata/pydata-sphinx-theme/issues/1220
    "icon_links": [],
}

html_context = {
    "github_user": "kurusugawa-computer",
    "github_repo": "annofab-cli",
    "github_version": "main",
    "doc_path": "docs",
}

