from __future__ import annotations
from collections import namedtuple
from typing import Any, Callable, List, Optional, Union, TypeVar, Dict

# namedtuples for dictionary features
UnidicFeatures17: type[namedtuple]
UnidicFeatures26: type[namedtuple]
UnidicFeatures29: type[namedtuple]

T = TypeVar("T")
NodeT = TypeVar("NodeT", bound="Node")
UnidicNodeT = TypeVar("UnidicNodeT", bound="UnidicNode")

class Node:
    _surface: Optional[str]
    features: Any
    wrapper: Any

    def __init__(self) -> None: ...
    def __repr__(self) -> str: ...

    @property
    def surface(self) -> str: ...
    @surface.setter
    def surface(self, ss: str) -> None: ...
    @property
    def feature(self) -> Any: ...
    @property
    def feature_raw(self) -> str: ...
    @property
    def length(self) -> int: ...
    @property
    def rlength(self) -> int: ...
    @property
    def posid(self) -> int: ...
    @property
    def char_type(self) -> int: ...
    @property
    def stat(self) -> int: ...
    @property
    def is_unk(self) -> bool: ...
    @property
    def white_space(self) -> str: ...

    def pad_none(self, fields: List[str]) -> List[Optional[str]]: ...
    def set_feature(self, feature: bytes) -> None: ...
    @staticmethod
    def wrap(c_node: Any, wrapper: Any) -> Node: ...

class UnidicNode(Node):
    @property
    def pos(self) -> str: ...
    @staticmethod
    def wrap(c_node: Any, wrapper: Any) -> UnidicNode: ...

class GenericTagger:
    wrapper: Any
    _cache: Dict[int, str]

    def __init__(
        self,
        args: str = "",
        wrapper: Callable[..., Any] = ...,
        quiet: bool = False
    ) -> None: ...

    def __call__(self, text: str) -> List[Node]: ...
    def parse(self, text: str) -> str: ...
    def parseToNodeList(self, text: str) -> List[Node]: ...
    def nbest(self, text: str, num: int = 10) -> str: ...
    def nbestToNodeList(self, text: str, num: int = 10) -> List[List[Node]]: ...

    @property
    def dictionary_info(self) -> List[Dict[str, Union[str, int]]]: ...

    def wrap(self, node: Any) -> Node: ...

class Tagger(GenericTagger):
    def __init__(self, arg: str = "") -> None: ...
    def wrap(self, node: Any) -> UnidicNode: ...

def create_feature_wrapper(
    name: str,
    fields: List[str],
    default: Optional[Any] = None
) -> type[tuple]: ...

def build_dictionary(args: str) -> int: ...

def try_import_unidic() -> Optional[str]: ...

def make_tuple(*args: Any) -> tuple[Any, ...]: ...

def get_error_details(argc: int, argv: Any) -> str: ...

def get_detailed_error(args: List[str], argc: int, argv: Any) -> str: ...

FAILMESSAGE: str
