"""Auto-generated LIFX protocol packets.

DO NOT EDIT THIS FILE MANUALLY.
Generated from https://github.com/LIFX/public-protocol/blob/main/protocol.yml
by protocol/generator.py

Uses nested packet classes organized by category (Device, Light, etc.).
Each packet inherits from base Packet class which provides generic pack/unpack.
"""

from __future__ import annotations

from dataclasses import dataclass
from typing import Any, ClassVar

from lifx.protocol.base import Packet
from lifx.protocol.protocol_types import (
    DeviceService,
    LightHsbk,
    LightLastHevCycleResult,
    LightWaveform,
    MultiZoneApplicationRequest,
    MultiZoneEffectSettings,
    MultiZoneExtendedApplicationRequest,
    TileBufferRect,
    TileEffectSettings,
    TileStateDevice,
)


class Device(Packet):
    """Device category packets."""

    @dataclass
    class Acknowledgement(Packet):
        """Packet type 45."""

        PKT_TYPE: ClassVar[int] = 45
        _fields: ClassVar[list[dict[str, Any]]] = []

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "OTHER"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        pass

    @dataclass
    class EchoRequest(Packet):
        """Packet type 58."""

        PKT_TYPE: ClassVar[int] = 58
        STATE_TYPE: ClassVar[int] = 59
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Payload", "type": "[64]byte", "size_bytes": 64}
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "OTHER"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        payload: bytes

    @dataclass
    class EchoResponse(Packet):
        """Packet type 59."""

        PKT_TYPE: ClassVar[int] = 59
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Payload", "type": "[64]byte", "size_bytes": 64}
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "OTHER"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        payload: bytes

    @dataclass
    class GetGroup(Packet):
        """Packet type 51."""

        PKT_TYPE: ClassVar[int] = 51
        STATE_TYPE: ClassVar[int] = 53
        _fields: ClassVar[list[dict[str, Any]]] = []

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "GET"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        pass

    @dataclass
    class GetHostFirmware(Packet):
        """Packet type 14."""

        PKT_TYPE: ClassVar[int] = 14
        STATE_TYPE: ClassVar[int] = 15
        _fields: ClassVar[list[dict[str, Any]]] = []

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "GET"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        pass

    @dataclass
    class GetInfo(Packet):
        """Packet type 34."""

        PKT_TYPE: ClassVar[int] = 34
        STATE_TYPE: ClassVar[int] = 35
        _fields: ClassVar[list[dict[str, Any]]] = []

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "GET"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        pass

    @dataclass
    class GetLabel(Packet):
        """Packet type 23."""

        PKT_TYPE: ClassVar[int] = 23
        STATE_TYPE: ClassVar[int] = 25
        _fields: ClassVar[list[dict[str, Any]]] = []

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "GET"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        pass

    @dataclass
    class GetLocation(Packet):
        """Packet type 48."""

        PKT_TYPE: ClassVar[int] = 48
        STATE_TYPE: ClassVar[int] = 50
        _fields: ClassVar[list[dict[str, Any]]] = []

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "GET"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        pass

    @dataclass
    class GetPower(Packet):
        """Packet type 20."""

        PKT_TYPE: ClassVar[int] = 20
        STATE_TYPE: ClassVar[int] = 22
        _fields: ClassVar[list[dict[str, Any]]] = []

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "GET"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        pass

    @dataclass
    class GetService(Packet):
        """Packet type 2."""

        PKT_TYPE: ClassVar[int] = 2
        STATE_TYPE: ClassVar[int] = 3
        _fields: ClassVar[list[dict[str, Any]]] = []

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "GET"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        pass

    @dataclass
    class GetVersion(Packet):
        """Packet type 32."""

        PKT_TYPE: ClassVar[int] = 32
        STATE_TYPE: ClassVar[int] = 33
        _fields: ClassVar[list[dict[str, Any]]] = []

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "GET"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        pass

    @dataclass
    class GetWifiFirmware(Packet):
        """Packet type 18."""

        PKT_TYPE: ClassVar[int] = 18
        STATE_TYPE: ClassVar[int] = 19
        _fields: ClassVar[list[dict[str, Any]]] = []

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "GET"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        pass

    @dataclass
    class GetWifiInfo(Packet):
        """Packet type 16."""

        PKT_TYPE: ClassVar[int] = 16
        STATE_TYPE: ClassVar[int] = 17
        _fields: ClassVar[list[dict[str, Any]]] = []

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "GET"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        pass

    @dataclass
    class SetGroup(Packet):
        """Packet type 52."""

        PKT_TYPE: ClassVar[int] = 52
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Group", "type": "[16]byte", "size_bytes": 16},
            {"name": "Label", "type": "[32]byte", "size_bytes": 32},
            {"name": "UpdatedAt", "type": "uint64", "size_bytes": 8},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "SET"
        _requires_ack: ClassVar[bool] = True
        _requires_response: ClassVar[bool] = False

        group: bytes
        label: bytes
        updated_at: int

    @dataclass
    class SetLabel(Packet):
        """Packet type 24."""

        PKT_TYPE: ClassVar[int] = 24
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Label", "type": "[32]byte", "size_bytes": 32}
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "SET"
        _requires_ack: ClassVar[bool] = True
        _requires_response: ClassVar[bool] = False

        label: bytes

    @dataclass
    class SetLocation(Packet):
        """Packet type 49."""

        PKT_TYPE: ClassVar[int] = 49
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Location", "type": "[16]byte", "size_bytes": 16},
            {"name": "Label", "type": "[32]byte", "size_bytes": 32},
            {"name": "UpdatedAt", "type": "uint64", "size_bytes": 8},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "SET"
        _requires_ack: ClassVar[bool] = True
        _requires_response: ClassVar[bool] = False

        location: bytes
        label: bytes
        updated_at: int

    @dataclass
    class SetPower(Packet):
        """Packet type 21."""

        PKT_TYPE: ClassVar[int] = 21
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Level", "type": "uint16", "size_bytes": 2}
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "SET"
        _requires_ack: ClassVar[bool] = True
        _requires_response: ClassVar[bool] = False

        level: int

    @dataclass
    class SetReboot(Packet):
        """Packet type 38."""

        PKT_TYPE: ClassVar[int] = 38
        _fields: ClassVar[list[dict[str, Any]]] = []

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "SET"
        _requires_ack: ClassVar[bool] = True
        _requires_response: ClassVar[bool] = False

        pass

    @dataclass
    class StateGroup(Packet):
        """Packet type 53."""

        PKT_TYPE: ClassVar[int] = 53
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Group", "type": "[16]byte", "size_bytes": 16},
            {"name": "Label", "type": "[32]byte", "size_bytes": 32},
            {"name": "UpdatedAt", "type": "uint64", "size_bytes": 8},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "STATE"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        group: bytes
        label: bytes
        updated_at: int

    @dataclass
    class StateHostFirmware(Packet):
        """Packet type 15."""

        PKT_TYPE: ClassVar[int] = 15
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Build", "type": "uint64", "size_bytes": 8},
            {"type": "reserved", "size_bytes": 8},
            {"name": "VersionMinor", "type": "uint16", "size_bytes": 2},
            {"name": "VersionMajor", "type": "uint16", "size_bytes": 2},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "STATE"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        build: int
        version_minor: int
        version_major: int

    @dataclass
    class StateInfo(Packet):
        """Packet type 35."""

        PKT_TYPE: ClassVar[int] = 35
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Time", "type": "uint64", "size_bytes": 8},
            {"name": "Uptime", "type": "uint64", "size_bytes": 8},
            {"name": "Downtime", "type": "uint64", "size_bytes": 8},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "STATE"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        time: int
        uptime: int
        downtime: int

    @dataclass
    class StateLabel(Packet):
        """Packet type 25."""

        PKT_TYPE: ClassVar[int] = 25
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Label", "type": "[32]byte", "size_bytes": 32}
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "STATE"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        label: bytes

    @dataclass
    class StateLocation(Packet):
        """Packet type 50."""

        PKT_TYPE: ClassVar[int] = 50
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Location", "type": "[16]byte", "size_bytes": 16},
            {"name": "Label", "type": "[32]byte", "size_bytes": 32},
            {"name": "UpdatedAt", "type": "uint64", "size_bytes": 8},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "STATE"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        location: bytes
        label: bytes
        updated_at: int

    @dataclass
    class StatePower(Packet):
        """Packet type 22."""

        PKT_TYPE: ClassVar[int] = 22
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Level", "type": "uint16", "size_bytes": 2}
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "STATE"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        level: int

    @dataclass
    class StateService(Packet):
        """Packet type 3."""

        PKT_TYPE: ClassVar[int] = 3
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Service", "type": "<DeviceService>", "size_bytes": 1},
            {"name": "Port", "type": "uint32", "size_bytes": 4},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "STATE"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        service: DeviceService
        port: int

    @dataclass
    class StateUnhandled(Packet):
        """Packet type 223."""

        PKT_TYPE: ClassVar[int] = 223
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "UnhandledType", "type": "uint16", "size_bytes": 2}
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "STATE"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        unhandled_type: int

    @dataclass
    class StateVersion(Packet):
        """Packet type 33."""

        PKT_TYPE: ClassVar[int] = 33
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Vendor", "type": "uint32", "size_bytes": 4},
            {"name": "Product", "type": "uint32", "size_bytes": 4},
            {"type": "reserved", "size_bytes": 4},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "STATE"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        vendor: int
        product: int

    @dataclass
    class StateWifiFirmware(Packet):
        """Packet type 19."""

        PKT_TYPE: ClassVar[int] = 19
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Build", "type": "uint64", "size_bytes": 8},
            {"type": "reserved", "size_bytes": 8},
            {"name": "VersionMinor", "type": "uint16", "size_bytes": 2},
            {"name": "VersionMajor", "type": "uint16", "size_bytes": 2},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "STATE"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        build: int
        version_minor: int
        version_major: int

    @dataclass
    class StateWifiInfo(Packet):
        """Packet type 17."""

        PKT_TYPE: ClassVar[int] = 17
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Signal", "type": "float32", "size_bytes": 4},
            {"type": "reserved", "size_bytes": 4},
            {"type": "reserved", "size_bytes": 4},
            {"type": "reserved", "size_bytes": 2},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "STATE"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        signal: float


class Light(Packet):
    """Light category packets."""

    @dataclass
    class GetColor(Packet):
        """Packet type 101."""

        PKT_TYPE: ClassVar[int] = 101
        STATE_TYPE: ClassVar[int] = 107
        _fields: ClassVar[list[dict[str, Any]]] = []

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "GET"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        pass

    @dataclass
    class GetHevCycle(Packet):
        """Packet type 142."""

        PKT_TYPE: ClassVar[int] = 142
        STATE_TYPE: ClassVar[int] = 144
        _fields: ClassVar[list[dict[str, Any]]] = []

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "GET"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        pass

    @dataclass
    class GetHevCycleConfiguration(Packet):
        """Packet type 145."""

        PKT_TYPE: ClassVar[int] = 145
        STATE_TYPE: ClassVar[int] = 147
        _fields: ClassVar[list[dict[str, Any]]] = []

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "GET"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        pass

    @dataclass
    class GetInfrared(Packet):
        """Packet type 120."""

        PKT_TYPE: ClassVar[int] = 120
        STATE_TYPE: ClassVar[int] = 121
        _fields: ClassVar[list[dict[str, Any]]] = []

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "GET"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        pass

    @dataclass
    class GetLastHevCycleResult(Packet):
        """Packet type 148."""

        PKT_TYPE: ClassVar[int] = 148
        STATE_TYPE: ClassVar[int] = 149
        _fields: ClassVar[list[dict[str, Any]]] = []

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "GET"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        pass

    @dataclass
    class GetPower(Packet):
        """Packet type 116."""

        PKT_TYPE: ClassVar[int] = 116
        STATE_TYPE: ClassVar[int] = 118
        _fields: ClassVar[list[dict[str, Any]]] = []

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "GET"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        pass

    @dataclass
    class SetColor(Packet):
        """Packet type 102."""

        PKT_TYPE: ClassVar[int] = 102
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"type": "reserved", "size_bytes": 1},
            {"name": "Color", "type": "<LightHsbk>", "size_bytes": 8},
            {"name": "Duration", "type": "uint32", "size_bytes": 4},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "SET"
        _requires_ack: ClassVar[bool] = True
        _requires_response: ClassVar[bool] = False

        color: LightHsbk
        duration: int

    @dataclass
    class SetHevCycle(Packet):
        """Packet type 143."""

        PKT_TYPE: ClassVar[int] = 143
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Enable", "type": "bool", "size_bytes": 1},
            {"name": "DurationS", "type": "uint32", "size_bytes": 4},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "SET"
        _requires_ack: ClassVar[bool] = True
        _requires_response: ClassVar[bool] = False

        enable: bool
        duration_s: int

    @dataclass
    class SetHevCycleConfiguration(Packet):
        """Packet type 146."""

        PKT_TYPE: ClassVar[int] = 146
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Indication", "type": "bool", "size_bytes": 1},
            {"name": "DurationS", "type": "uint32", "size_bytes": 4},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "SET"
        _requires_ack: ClassVar[bool] = True
        _requires_response: ClassVar[bool] = False

        indication: bool
        duration_s: int

    @dataclass
    class SetInfrared(Packet):
        """Packet type 122."""

        PKT_TYPE: ClassVar[int] = 122
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Brightness", "type": "uint16", "size_bytes": 2}
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "SET"
        _requires_ack: ClassVar[bool] = True
        _requires_response: ClassVar[bool] = False

        brightness: int

    @dataclass
    class SetPower(Packet):
        """Packet type 117."""

        PKT_TYPE: ClassVar[int] = 117
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Level", "type": "uint16", "size_bytes": 2},
            {"name": "Duration", "type": "uint32", "size_bytes": 4},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "SET"
        _requires_ack: ClassVar[bool] = True
        _requires_response: ClassVar[bool] = False

        level: int
        duration: int

    @dataclass
    class SetWaveform(Packet):
        """Packet type 103."""

        PKT_TYPE: ClassVar[int] = 103
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"type": "reserved", "size_bytes": 1},
            {"name": "Transient", "type": "bool", "size_bytes": 1},
            {"name": "Color", "type": "<LightHsbk>", "size_bytes": 8},
            {"name": "Period", "type": "uint32", "size_bytes": 4},
            {"name": "Cycles", "type": "float32", "size_bytes": 4},
            {"name": "SkewRatio", "type": "int16", "size_bytes": 2},
            {"name": "Waveform", "type": "<LightWaveform>", "size_bytes": 1},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "SET"
        _requires_ack: ClassVar[bool] = True
        _requires_response: ClassVar[bool] = False

        transient: bool
        color: LightHsbk
        period: int
        cycles: float
        skew_ratio: int
        waveform: LightWaveform

    @dataclass
    class SetWaveformOptional(Packet):
        """Packet type 119."""

        PKT_TYPE: ClassVar[int] = 119
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"type": "reserved", "size_bytes": 1},
            {"name": "Transient", "type": "bool", "size_bytes": 1},
            {"name": "Color", "type": "<LightHsbk>", "size_bytes": 8},
            {"name": "Period", "type": "uint32", "size_bytes": 4},
            {"name": "Cycles", "type": "float32", "size_bytes": 4},
            {"name": "SkewRatio", "type": "int16", "size_bytes": 2},
            {"name": "Waveform", "type": "<LightWaveform>", "size_bytes": 1},
            {"name": "SetHue", "type": "bool", "size_bytes": 1},
            {"name": "SetSaturation", "type": "bool", "size_bytes": 1},
            {"name": "SetBrightness", "type": "bool", "size_bytes": 1},
            {"name": "SetKelvin", "type": "bool", "size_bytes": 1},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "SET"
        _requires_ack: ClassVar[bool] = True
        _requires_response: ClassVar[bool] = False

        transient: bool
        color: LightHsbk
        period: int
        cycles: float
        skew_ratio: int
        waveform: LightWaveform
        set_hue: bool
        set_saturation: bool
        set_brightness: bool
        set_kelvin: bool

    @dataclass
    class StateColor(Packet):
        """Packet type 107."""

        PKT_TYPE: ClassVar[int] = 107
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Color", "type": "<LightHsbk>", "size_bytes": 8},
            {"type": "reserved", "size_bytes": 2},
            {"name": "Power", "type": "uint16", "size_bytes": 2},
            {"name": "Label", "type": "[32]byte", "size_bytes": 32},
            {"type": "reserved", "size_bytes": 8},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "STATE"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        color: LightHsbk
        power: int
        label: bytes

    @dataclass
    class StateHevCycle(Packet):
        """Packet type 144."""

        PKT_TYPE: ClassVar[int] = 144
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "DurationS", "type": "uint32", "size_bytes": 4},
            {"name": "RemainingS", "type": "uint32", "size_bytes": 4},
            {"name": "LastPower", "type": "bool", "size_bytes": 1},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "STATE"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        duration_s: int
        remaining_s: int
        last_power: bool

    @dataclass
    class StateHevCycleConfiguration(Packet):
        """Packet type 147."""

        PKT_TYPE: ClassVar[int] = 147
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Indication", "type": "bool", "size_bytes": 1},
            {"name": "DurationS", "type": "uint32", "size_bytes": 4},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "STATE"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        indication: bool
        duration_s: int

    @dataclass
    class StateInfrared(Packet):
        """Packet type 121."""

        PKT_TYPE: ClassVar[int] = 121
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Brightness", "type": "uint16", "size_bytes": 2}
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "STATE"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        brightness: int

    @dataclass
    class StateLastHevCycleResult(Packet):
        """Packet type 149."""

        PKT_TYPE: ClassVar[int] = 149
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Result", "type": "<LightLastHevCycleResult>", "size_bytes": 1},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "STATE"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        result: LightLastHevCycleResult

    @dataclass
    class StatePower(Packet):
        """Packet type 118."""

        PKT_TYPE: ClassVar[int] = 118
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Level", "type": "uint16", "size_bytes": 2}
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "STATE"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        level: int


class MultiZone(Packet):
    """MultiZone category packets."""

    @dataclass
    class GetExtendedColorZones(Packet):
        """Packet type 511."""

        PKT_TYPE: ClassVar[int] = 511
        STATE_TYPE: ClassVar[int] = 512
        _fields: ClassVar[list[dict[str, Any]]] = []

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "GET"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        pass

    @dataclass
    class SetExtendedColorZones(Packet):
        """Packet type 510."""

        PKT_TYPE: ClassVar[int] = 510
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Duration", "type": "uint32", "size_bytes": 4},
            {
                "name": "Apply",
                "type": "<MultiZoneExtendedApplicationRequest>",
                "size_bytes": 1,
            },
            {"name": "Index", "type": "uint16", "size_bytes": 2},
            {"name": "ColorsCount", "type": "uint8", "size_bytes": 1},
            {"name": "Colors", "type": "[82]<LightHsbk>", "size_bytes": 656},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "SET"
        _requires_ack: ClassVar[bool] = True
        _requires_response: ClassVar[bool] = False

        duration: int
        apply: MultiZoneExtendedApplicationRequest
        index: int
        colors_count: int
        colors: list[LightHsbk]

    @dataclass
    class StateExtendedColorZones(Packet):
        """Packet type 512."""

        PKT_TYPE: ClassVar[int] = 512
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Count", "type": "uint16", "size_bytes": 2},
            {"name": "Index", "type": "uint16", "size_bytes": 2},
            {"name": "ColorsCount", "type": "uint8", "size_bytes": 1},
            {"name": "Colors", "type": "[82]<LightHsbk>", "size_bytes": 656},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "STATE"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        count: int
        index: int
        colors_count: int
        colors: list[LightHsbk]

    @dataclass
    class GetColorZones(Packet):
        """Packet type 502."""

        PKT_TYPE: ClassVar[int] = 502
        STATE_TYPE: ClassVar[int] = 506
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "StartIndex", "type": "uint8", "size_bytes": 1},
            {"name": "EndIndex", "type": "uint8", "size_bytes": 1},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "GET"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        start_index: int
        end_index: int

    @dataclass
    class GetEffect(Packet):
        """Packet type 507."""

        PKT_TYPE: ClassVar[int] = 507
        STATE_TYPE: ClassVar[int] = 509
        _fields: ClassVar[list[dict[str, Any]]] = []

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "GET"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        pass

    @dataclass
    class SetColorZones(Packet):
        """Packet type 501."""

        PKT_TYPE: ClassVar[int] = 501
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "StartIndex", "type": "uint8", "size_bytes": 1},
            {"name": "EndIndex", "type": "uint8", "size_bytes": 1},
            {"name": "Color", "type": "<LightHsbk>", "size_bytes": 8},
            {"name": "Duration", "type": "uint32", "size_bytes": 4},
            {"name": "Apply", "type": "<MultiZoneApplicationRequest>", "size_bytes": 1},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "SET"
        _requires_ack: ClassVar[bool] = True
        _requires_response: ClassVar[bool] = False

        start_index: int
        end_index: int
        color: LightHsbk
        duration: int
        apply: MultiZoneApplicationRequest

    @dataclass
    class SetEffect(Packet):
        """Packet type 508."""

        PKT_TYPE: ClassVar[int] = 508
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Settings", "type": "<MultiZoneEffectSettings>", "size_bytes": 59},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "SET"
        _requires_ack: ClassVar[bool] = True
        _requires_response: ClassVar[bool] = False

        settings: MultiZoneEffectSettings

    @dataclass
    class StateEffect(Packet):
        """Packet type 509."""

        PKT_TYPE: ClassVar[int] = 509
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Settings", "type": "<MultiZoneEffectSettings>", "size_bytes": 59},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "STATE"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        settings: MultiZoneEffectSettings

    @dataclass
    class StateMultiZone(Packet):
        """Packet type 506."""

        PKT_TYPE: ClassVar[int] = 506
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Count", "type": "uint8", "size_bytes": 1},
            {"name": "Index", "type": "uint8", "size_bytes": 1},
            {"name": "Colors", "type": "[8]<LightHsbk>", "size_bytes": 64},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "STATE"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        count: int
        index: int
        colors: list[LightHsbk]

    @dataclass
    class StateZone(Packet):
        """Packet type 503."""

        PKT_TYPE: ClassVar[int] = 503
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "Count", "type": "uint8", "size_bytes": 1},
            {"name": "Index", "type": "uint8", "size_bytes": 1},
            {"name": "Color", "type": "<LightHsbk>", "size_bytes": 8},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "STATE"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        count: int
        index: int
        color: LightHsbk


class Tile(Packet):
    """Tile category packets."""

    @dataclass
    class CopyFrameBuffer(Packet):
        """Packet type 716."""

        PKT_TYPE: ClassVar[int] = 716
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "TileIndex", "type": "uint8", "size_bytes": 1},
            {"name": "Length", "type": "uint8", "size_bytes": 1},
            {"name": "SrcFbIndex", "type": "uint8", "size_bytes": 1},
            {"name": "DstFbIndex", "type": "uint8", "size_bytes": 1},
            {"name": "SrcX", "type": "uint8", "size_bytes": 1},
            {"name": "SrcY", "type": "uint8", "size_bytes": 1},
            {"name": "DstX", "type": "uint8", "size_bytes": 1},
            {"name": "DstY", "type": "uint8", "size_bytes": 1},
            {"name": "Width", "type": "uint8", "size_bytes": 1},
            {"name": "Height", "type": "uint8", "size_bytes": 1},
            {"name": "Duration", "type": "uint32", "size_bytes": 4},
            {"type": "reserved", "size_bytes": 1},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "SET"
        _requires_ack: ClassVar[bool] = True
        _requires_response: ClassVar[bool] = False

        tile_index: int
        length: int
        src_fb_index: int
        dst_fb_index: int
        src_x: int
        src_y: int
        dst_x: int
        dst_y: int
        width: int
        height: int
        duration: int

    @dataclass
    class Get64(Packet):
        """Packet type 707."""

        PKT_TYPE: ClassVar[int] = 707
        STATE_TYPE: ClassVar[int] = 711
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "TileIndex", "type": "uint8", "size_bytes": 1},
            {"name": "Length", "type": "uint8", "size_bytes": 1},
            {"name": "Rect", "type": "<TileBufferRect>", "size_bytes": 4},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "GET"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        tile_index: int
        length: int
        rect: TileBufferRect

    @dataclass
    class GetDeviceChain(Packet):
        """Packet type 701."""

        PKT_TYPE: ClassVar[int] = 701
        STATE_TYPE: ClassVar[int] = 702
        _fields: ClassVar[list[dict[str, Any]]] = []

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "GET"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        pass

    @dataclass
    class GetEffect(Packet):
        """Packet type 718."""

        PKT_TYPE: ClassVar[int] = 718
        STATE_TYPE: ClassVar[int] = 720
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"type": "reserved", "size_bytes": 1},
            {"type": "reserved", "size_bytes": 1},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "GET"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        pass

    @dataclass
    class Set64(Packet):
        """Packet type 715."""

        PKT_TYPE: ClassVar[int] = 715
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "TileIndex", "type": "uint8", "size_bytes": 1},
            {"name": "Length", "type": "uint8", "size_bytes": 1},
            {"name": "Rect", "type": "<TileBufferRect>", "size_bytes": 4},
            {"name": "Duration", "type": "uint32", "size_bytes": 4},
            {"name": "Colors", "type": "[64]<LightHsbk>", "size_bytes": 512},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "SET"
        _requires_ack: ClassVar[bool] = True
        _requires_response: ClassVar[bool] = False

        tile_index: int
        length: int
        rect: TileBufferRect
        duration: int
        colors: list[LightHsbk]

    @dataclass
    class SetEffect(Packet):
        """Packet type 719."""

        PKT_TYPE: ClassVar[int] = 719
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"type": "reserved", "size_bytes": 1},
            {"type": "reserved", "size_bytes": 1},
            {"name": "Settings", "type": "<TileEffectSettings>", "size_bytes": 186},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "SET"
        _requires_ack: ClassVar[bool] = True
        _requires_response: ClassVar[bool] = False

        settings: TileEffectSettings

    @dataclass
    class SetUserPosition(Packet):
        """Packet type 703."""

        PKT_TYPE: ClassVar[int] = 703
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "TileIndex", "type": "uint8", "size_bytes": 1},
            {"type": "reserved", "size_bytes": 1},
            {"type": "reserved", "size_bytes": 1},
            {"name": "UserX", "type": "float32", "size_bytes": 4},
            {"name": "UserY", "type": "float32", "size_bytes": 4},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "SET"
        _requires_ack: ClassVar[bool] = True
        _requires_response: ClassVar[bool] = False

        tile_index: int
        user_x: float
        user_y: float

    @dataclass
    class State64(Packet):
        """Packet type 711."""

        PKT_TYPE: ClassVar[int] = 711
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "TileIndex", "type": "uint8", "size_bytes": 1},
            {"name": "Rect", "type": "<TileBufferRect>", "size_bytes": 4},
            {"name": "Colors", "type": "[64]<LightHsbk>", "size_bytes": 512},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "STATE"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        tile_index: int
        rect: TileBufferRect
        colors: list[LightHsbk]

    @dataclass
    class StateDeviceChain(Packet):
        """Packet type 702."""

        PKT_TYPE: ClassVar[int] = 702
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"name": "StartIndex", "type": "uint8", "size_bytes": 1},
            {"name": "TileDevices", "type": "[16]<TileStateDevice>", "size_bytes": 880},
            {"name": "TileDevicesCount", "type": "uint8", "size_bytes": 1},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "STATE"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        start_index: int
        tile_devices: list[TileStateDevice]
        tile_devices_count: int

    @dataclass
    class StateEffect(Packet):
        """Packet type 720."""

        PKT_TYPE: ClassVar[int] = 720
        _fields: ClassVar[list[dict[str, Any]]] = [
            {"type": "reserved", "size_bytes": 1},
            {"name": "Settings", "type": "<TileEffectSettings>", "size_bytes": 186},
        ]

        # Packet metadata for automatic handling
        _packet_kind: ClassVar[str] = "STATE"
        _requires_ack: ClassVar[bool] = False
        _requires_response: ClassVar[bool] = False

        settings: TileEffectSettings


# Packet Registry - maps packet type to nested packet class
PACKET_REGISTRY: dict[int, type[Packet]] = {
    2: Device.GetService,
    3: Device.StateService,
    14: Device.GetHostFirmware,
    15: Device.StateHostFirmware,
    16: Device.GetWifiInfo,
    17: Device.StateWifiInfo,
    18: Device.GetWifiFirmware,
    19: Device.StateWifiFirmware,
    20: Device.GetPower,
    21: Device.SetPower,
    22: Device.StatePower,
    23: Device.GetLabel,
    24: Device.SetLabel,
    25: Device.StateLabel,
    32: Device.GetVersion,
    33: Device.StateVersion,
    34: Device.GetInfo,
    35: Device.StateInfo,
    38: Device.SetReboot,
    45: Device.Acknowledgement,
    48: Device.GetLocation,
    49: Device.SetLocation,
    50: Device.StateLocation,
    51: Device.GetGroup,
    52: Device.SetGroup,
    53: Device.StateGroup,
    58: Device.EchoRequest,
    59: Device.EchoResponse,
    101: Light.GetColor,
    102: Light.SetColor,
    103: Light.SetWaveform,
    107: Light.StateColor,
    116: Light.GetPower,
    117: Light.SetPower,
    118: Light.StatePower,
    119: Light.SetWaveformOptional,
    120: Light.GetInfrared,
    121: Light.StateInfrared,
    122: Light.SetInfrared,
    142: Light.GetHevCycle,
    143: Light.SetHevCycle,
    144: Light.StateHevCycle,
    145: Light.GetHevCycleConfiguration,
    146: Light.SetHevCycleConfiguration,
    147: Light.StateHevCycleConfiguration,
    148: Light.GetLastHevCycleResult,
    149: Light.StateLastHevCycleResult,
    223: Device.StateUnhandled,
    501: MultiZone.SetColorZones,
    502: MultiZone.GetColorZones,
    503: MultiZone.StateZone,
    506: MultiZone.StateMultiZone,
    507: MultiZone.GetEffect,
    508: MultiZone.SetEffect,
    509: MultiZone.StateEffect,
    510: MultiZone.SetExtendedColorZones,
    511: MultiZone.GetExtendedColorZones,
    512: MultiZone.StateExtendedColorZones,
    701: Tile.GetDeviceChain,
    702: Tile.StateDeviceChain,
    703: Tile.SetUserPosition,
    707: Tile.Get64,
    711: Tile.State64,
    715: Tile.Set64,
    716: Tile.CopyFrameBuffer,
    718: Tile.GetEffect,
    719: Tile.SetEffect,
    720: Tile.StateEffect,
}


def get_packet_class(pkt_type: int) -> type[Packet] | None:
    """Get packet class for a given packet type.

    Args:
        pkt_type: Packet type number

    Returns:
        Nested packet class, or None if unknown
    """
    return PACKET_REGISTRY.get(pkt_type)
