# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""

from __future__ import annotations

from json import loads
from sys import version_info
from typing import Any, Dict, List, Optional, Union

from pydantic import BaseModel, ConfigDict

if version_info >= (3, 11):
    from typing import Self
else:
    from typing_extensions import Self


from algoliasearch.analytics.models.click_position import ClickPosition
from algoliasearch.analytics.models.currency_code import CurrencyCode

_ALIASES = {
    "search": "search",
    "count": "count",
    "click_through_rate": "clickThroughRate",
    "average_click_position": "averageClickPosition",
    "click_positions": "clickPositions",
    "conversion_rate": "conversionRate",
    "tracked_search_count": "trackedSearchCount",
    "click_count": "clickCount",
    "conversion_count": "conversionCount",
    "nb_hits": "nbHits",
    "currencies": "currencies",
    "add_to_cart_rate": "addToCartRate",
    "add_to_cart_count": "addToCartCount",
    "purchase_rate": "purchaseRate",
    "purchase_count": "purchaseCount",
}


def _alias_generator(name: str) -> str:
    return _ALIASES.get(name, name)


class TopSearchWithRevenueAnalytics(BaseModel):
    """
    TopSearchWithRevenueAnalytics
    """

    search: str
    """ Search query. """
    count: int
    """ Number of searches. """
    click_through_rate: Union[float, None]
    """ Click-through rate: calculated as the number of tracked searches with at least one click event divided by the number of tracked searches. If null, Algolia didn't receive any search requests with `clickAnalytics` set to true.  """
    average_click_position: Union[float, None]
    """ Average position of a clicked search result in the list of search results. If null, Algolia didn't receive any search requests with `clickAnalytics` set to true.  """
    click_positions: List[ClickPosition]
    """ List of positions in the search results and clicks associated with this search. """
    conversion_rate: Union[float, None]
    """ Conversion rate: calculated as the number of tracked searches with at least one conversion event divided by the number of tracked searches. If null, Algolia didn't receive any search requests with `clickAnalytics` set to true.  """
    tracked_search_count: int
    """ Number of tracked searches. Tracked searches are search requests where the `clickAnalytics` parameter is true. """
    click_count: int
    """ Number of clicks associated with this search. """
    conversion_count: int
    """ Number of conversions from this search. """
    nb_hits: int
    """ Number of results (hits). """
    currencies: Dict[str, CurrencyCode]
    """ Revenue associated with this search: broken down by currency.  """
    add_to_cart_rate: Union[float, None]
    """ Add-to-cart rate: calculated as the number of tracked searches with at least one add-to-cart event divided by the number of tracked searches. If null, Algolia didn't receive any search requests with `clickAnalytics` set to true.  """
    add_to_cart_count: int
    """ Number of add-to-cart events from this search. """
    purchase_rate: Union[float, None]
    """ Purchase rate: calculated as the number of tracked searches with at least one purchase event divided by the number of tracked searches. If null, Algolia didn't receive any search requests with `clickAnalytics` set to true.  """
    purchase_count: int
    """ Number of purchase events from this search. """

    model_config = ConfigDict(
        strict=False,
        use_enum_values=True,
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=_alias_generator,
        extra="allow",
    )

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TopSearchWithRevenueAnalytics from a JSON string"""
        return cls.from_dict(loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias."""
        return self.model_dump(
            by_alias=True,
            exclude_none=True,
            exclude_unset=True,
        )

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TopSearchWithRevenueAnalytics from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        obj["clickPositions"] = (
            [ClickPosition.from_dict(_item) for _item in obj["clickPositions"]]
            if obj.get("clickPositions") is not None
            else None
        )
        obj["currencies"] = (
            dict(
                (_k, CurrencyCode.from_dict(_v)) for _k, _v in obj["currencies"].items()
            )
            if obj.get("currencies") is not None
            else None
        )

        return cls.model_validate(obj)
