# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""

from __future__ import annotations

from json import loads
from sys import version_info
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, ConfigDict

if version_info >= (3, 11):
    from typing import Self
else:
    from typing_extensions import Self


from algoliasearch.ingestion.models.event import Event

_ALIASES = {
    "run_id": "runID",
    "event_id": "eventID",
    "data": "data",
    "events": "events",
    "message": "message",
    "created_at": "createdAt",
}


def _alias_generator(name: str) -> str:
    return _ALIASES.get(name, name)


class WatchResponse(BaseModel):
    """
    WatchResponse
    """

    run_id: str
    """ Universally unique identifier (UUID) of a task run. """
    event_id: Optional[str] = None
    """ Universally unique identifier (UUID) of an event. """
    data: Optional[List[object]] = None
    """ This field is always null when used with the Push endpoint. When used for a source discover or source validate run, it will include the sampled data of the source.  """
    events: Optional[List[Event]] = None
    """ in case of error, observability events will be added to the response. """
    message: Optional[str] = None
    """ a message describing the outcome of the operation that has been ran (push, discover or validate) run. """
    created_at: Optional[str] = None
    """ Date of creation in RFC 3339 format. """

    model_config = ConfigDict(
        strict=False,
        use_enum_values=True,
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=_alias_generator,
        extra="allow",
    )

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WatchResponse from a JSON string"""
        return cls.from_dict(loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias."""
        return self.model_dump(
            by_alias=True,
            exclude_none=True,
            exclude_unset=True,
        )

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WatchResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        obj["events"] = (
            [Event.from_dict(_item) for _item in obj["events"]]
            if obj.get("events") is not None
            else None
        )

        return cls.model_validate(obj)
