# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""

from __future__ import annotations

from json import loads
from sys import version_info
from typing import Any, Dict, Optional

from pydantic import BaseModel, ConfigDict

if version_info >= (3, 11):
    from typing import Self
else:
    from typing_extensions import Self


from algoliasearch.monitoring.models.region import Region
from algoliasearch.monitoring.models.server_status import ServerStatus
from algoliasearch.monitoring.models.type import Type

_ALIASES = {
    "name": "name",
    "region": "region",
    "is_slave": "is_slave",
    "is_replica": "is_replica",
    "cluster": "cluster",
    "status": "status",
    "type": "type",
}


def _alias_generator(name: str) -> str:
    return _ALIASES.get(name, name)


class Server(BaseModel):
    """
    Server
    """

    name: Optional[str] = None
    """ Server name. """
    region: Optional[Region] = None
    is_slave: Optional[bool] = None
    """ Included to support legacy applications. Use `is_replica` instead.  """
    is_replica: Optional[bool] = None
    """ Whether this server is a replica of another server. """
    cluster: Optional[str] = None
    """ Name of the cluster to which this server belongs. """
    status: Optional[ServerStatus] = None
    type: Optional[Type] = None

    model_config = ConfigDict(
        strict=False,
        use_enum_values=True,
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=_alias_generator,
        extra="allow",
    )

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Server from a JSON string"""
        return cls.from_dict(loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias."""
        return self.model_dump(
            by_alias=True,
            exclude_none=True,
            exclude_unset=True,
        )

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Server from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        obj["region"] = obj.get("region")
        obj["status"] = obj.get("status")
        obj["type"] = obj.get("type")

        return cls.model_validate(obj)
