# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""

from __future__ import annotations

from json import loads
from sys import version_info
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, ConfigDict

if version_info >= (3, 11):
    from typing import Self
else:
    from typing_extensions import Self


from algoliasearch.query_suggestions.models.facet import Facet

_ALIASES = {
    "index_name": "indexName",
    "replicas": "replicas",
    "analytics_tags": "analyticsTags",
    "facets": "facets",
    "min_hits": "minHits",
    "min_letters": "minLetters",
    "generate": "generate",
    "external": "external",
}


def _alias_generator(name: str) -> str:
    return _ALIASES.get(name, name)


class SourceIndex(BaseModel):
    """
    Configuration of an Algolia index for Query Suggestions.
    """

    index_name: str
    """ Name of the Algolia index (case-sensitive) to use as source for query suggestions. """
    replicas: Optional[bool] = None
    """ If true, Query Suggestions uses all replica indices to find popular searches. If false, only the primary index is used.  """
    analytics_tags: Optional[List[str]] = None
    facets: Optional[List[Facet]] = None
    min_hits: Optional[int] = None
    """ Minimum number of hits required to be included as a suggestion.  A search query must at least generate `minHits` search results to be included in the Query Suggestions index.  """
    min_letters: Optional[int] = None
    """ Minimum letters required to be included as a suggestion.  A search query must be at least `minLetters` long to be included in the Query Suggestions index.  """
    generate: Optional[List[List[str]]] = None
    external: Optional[List[str]] = None

    model_config = ConfigDict(
        strict=False,
        use_enum_values=True,
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=_alias_generator,
        extra="allow",
    )

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SourceIndex from a JSON string"""
        return cls.from_dict(loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias."""
        return self.model_dump(
            by_alias=True,
            exclude_none=True,
            exclude_unset=True,
        )

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SourceIndex from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        obj["facets"] = (
            [Facet.from_dict(_item) for _item in obj["facets"]]
            if obj.get("facets") is not None
            else None
        )

        return cls.model_validate(obj)
