# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""

from __future__ import annotations

from json import loads
from sys import version_info
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, ConfigDict

if version_info >= (3, 11):
    from typing import Self
else:
    from typing_extensions import Self


from algoliasearch.search.models.consequence_hide import ConsequenceHide
from algoliasearch.search.models.consequence_params import ConsequenceParams
from algoliasearch.search.models.promote import Promote

_ALIASES = {
    "params": "params",
    "promote": "promote",
    "filter_promotes": "filterPromotes",
    "hide": "hide",
    "user_data": "userData",
}


def _alias_generator(name: str) -> str:
    return _ALIASES.get(name, name)


class Consequence(BaseModel):
    """
    Effect of the rule.  For more information, see [Consequences](https://www.algolia.com/doc/guides/managing-results/rules/rules-overview/#consequences).
    """

    params: Optional[ConsequenceParams] = None
    promote: Optional[List[Promote]] = None
    """ Records you want to pin to a specific position in the search results.  You can promote up to 300 records, either individually, or as groups of up to 100 records each.  """
    filter_promotes: Optional[bool] = None
    """ Whether promoted records must match an active filter for the consequence to be applied.  This ensures that user actions (filtering the search) are given a higher precendence. For example, if you promote a record with the `color: red` attribute, and the user filters the search for `color: blue`, the \"red\" record won't be shown.  """
    hide: Optional[List[ConsequenceHide]] = None
    """ Records you want to hide from the search results. """
    user_data: Optional[object] = None
    """ A JSON object with custom data that will be appended to the `userData` array in the response. This object isn't interpreted by the API and is limited to 1&nbsp;kB of minified JSON.  """

    model_config = ConfigDict(
        strict=False,
        use_enum_values=True,
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=_alias_generator,
        extra="allow",
    )

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Consequence from a JSON string"""
        return cls.from_dict(loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias."""
        return self.model_dump(
            by_alias=True,
            exclude_none=True,
            exclude_unset=True,
        )

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Consequence from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        obj["params"] = (
            ConsequenceParams.from_dict(obj["params"])
            if obj.get("params") is not None
            else None
        )
        obj["promote"] = (
            [Promote.from_dict(_item) for _item in obj["promote"]]
            if obj.get("promote") is not None
            else None
        )
        obj["hide"] = (
            [ConsequenceHide.from_dict(_item) for _item in obj["hide"]]
            if obj.get("hide") is not None
            else None
        )

        return cls.model_validate(obj)
