# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""

from __future__ import annotations

from json import loads
from sys import version_info
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, ConfigDict

if version_info >= (3, 11):
    from typing import Self
else:
    from typing_extensions import Self


from algoliasearch.search.models.advanced_syntax_features import AdvancedSyntaxFeatures
from algoliasearch.search.models.alternatives_as_exact import AlternativesAsExact
from algoliasearch.search.models.distinct import Distinct
from algoliasearch.search.models.exact_on_single_word_query import (
    ExactOnSingleWordQuery,
)
from algoliasearch.search.models.ignore_plurals import IgnorePlurals
from algoliasearch.search.models.mode import Mode
from algoliasearch.search.models.optional_words import OptionalWords
from algoliasearch.search.models.query_type import QueryType
from algoliasearch.search.models.re_ranking_apply_filter import ReRankingApplyFilter
from algoliasearch.search.models.remove_stop_words import RemoveStopWords
from algoliasearch.search.models.remove_words_if_no_results import (
    RemoveWordsIfNoResults,
)
from algoliasearch.search.models.rendering_content import RenderingContent
from algoliasearch.search.models.semantic_search import SemanticSearch
from algoliasearch.search.models.supported_language import SupportedLanguage
from algoliasearch.search.models.typo_tolerance import TypoTolerance

_ALIASES = {
    "attributes_for_faceting": "attributesForFaceting",
    "replicas": "replicas",
    "pagination_limited_to": "paginationLimitedTo",
    "unretrievable_attributes": "unretrievableAttributes",
    "disable_typo_tolerance_on_words": "disableTypoToleranceOnWords",
    "attributes_to_transliterate": "attributesToTransliterate",
    "camel_case_attributes": "camelCaseAttributes",
    "decompounded_attributes": "decompoundedAttributes",
    "index_languages": "indexLanguages",
    "disable_prefix_on_attributes": "disablePrefixOnAttributes",
    "allow_compression_of_integer_array": "allowCompressionOfIntegerArray",
    "numeric_attributes_for_filtering": "numericAttributesForFiltering",
    "separators_to_index": "separatorsToIndex",
    "searchable_attributes": "searchableAttributes",
    "user_data": "userData",
    "custom_normalization": "customNormalization",
    "attribute_for_distinct": "attributeForDistinct",
    "max_facet_hits": "maxFacetHits",
    "keep_diacritics_on_characters": "keepDiacriticsOnCharacters",
    "custom_ranking": "customRanking",
    "attributes_to_retrieve": "attributesToRetrieve",
    "ranking": "ranking",
    "relevancy_strictness": "relevancyStrictness",
    "attributes_to_highlight": "attributesToHighlight",
    "attributes_to_snippet": "attributesToSnippet",
    "highlight_pre_tag": "highlightPreTag",
    "highlight_post_tag": "highlightPostTag",
    "snippet_ellipsis_text": "snippetEllipsisText",
    "restrict_highlight_and_snippet_arrays": "restrictHighlightAndSnippetArrays",
    "hits_per_page": "hitsPerPage",
    "min_word_sizefor1_typo": "minWordSizefor1Typo",
    "min_word_sizefor2_typos": "minWordSizefor2Typos",
    "typo_tolerance": "typoTolerance",
    "allow_typos_on_numeric_tokens": "allowTyposOnNumericTokens",
    "disable_typo_tolerance_on_attributes": "disableTypoToleranceOnAttributes",
    "ignore_plurals": "ignorePlurals",
    "remove_stop_words": "removeStopWords",
    "query_languages": "queryLanguages",
    "decompound_query": "decompoundQuery",
    "enable_rules": "enableRules",
    "enable_personalization": "enablePersonalization",
    "query_type": "queryType",
    "remove_words_if_no_results": "removeWordsIfNoResults",
    "mode": "mode",
    "semantic_search": "semanticSearch",
    "advanced_syntax": "advancedSyntax",
    "optional_words": "optionalWords",
    "disable_exact_on_attributes": "disableExactOnAttributes",
    "exact_on_single_word_query": "exactOnSingleWordQuery",
    "alternatives_as_exact": "alternativesAsExact",
    "advanced_syntax_features": "advancedSyntaxFeatures",
    "distinct": "distinct",
    "replace_synonyms_in_highlight": "replaceSynonymsInHighlight",
    "min_proximity": "minProximity",
    "response_fields": "responseFields",
    "max_values_per_facet": "maxValuesPerFacet",
    "sort_facet_values_by": "sortFacetValuesBy",
    "attribute_criteria_computed_by_min_proximity": "attributeCriteriaComputedByMinProximity",
    "rendering_content": "renderingContent",
    "enable_re_ranking": "enableReRanking",
    "re_ranking_apply_filter": "reRankingApplyFilter",
    "primary": "primary",
}


def _alias_generator(name: str) -> str:
    return _ALIASES.get(name, name)


class SettingsResponse(BaseModel):
    """
    SettingsResponse
    """

    attributes_for_faceting: Optional[List[str]] = None
    """ Attributes used for [faceting](https://www.algolia.com/doc/guides/managing-results/refine-results/faceting/).  Facets are attributes that let you categorize search results. They can be used for filtering search results. By default, no attribute is used for faceting. Attribute names are case-sensitive.  **Modifiers**  - `filterOnly(\"ATTRIBUTE\")`.   Allows the attribute to be used as a filter but doesn't evaluate the facet values.  - `searchable(\"ATTRIBUTE\")`.   Allows searching for facet values.  - `afterDistinct(\"ATTRIBUTE\")`.   Evaluates the facet count _after_ deduplication with `distinct`.   This ensures accurate facet counts.   You can apply this modifier to searchable facets: `afterDistinct(searchable(ATTRIBUTE))`.  """
    replicas: Optional[List[str]] = None
    """ Creates [replica indices](https://www.algolia.com/doc/guides/managing-results/refine-results/sorting/in-depth/replicas/).  Replicas are copies of a primary index with the same records but different settings, synonyms, or rules. If you want to offer a different ranking or sorting of your search results, you'll use replica indices. All index operations on a primary index are automatically forwarded to its replicas. To add a replica index, you must provide the complete set of replicas to this parameter. If you omit a replica from this list, the replica turns into a regular, standalone index that will no longer be synced with the primary index.  **Modifier**  - `virtual(\"REPLICA\")`.   Create a virtual replica,   Virtual replicas don't increase the number of records and are optimized for [Relevant sorting](https://www.algolia.com/doc/guides/managing-results/refine-results/sorting/in-depth/relevant-sort/).  """
    pagination_limited_to: Optional[int] = None
    """ Maximum number of search results that can be obtained through pagination.  Higher pagination limits might slow down your search. For pagination limits above 1,000, the sorting of results beyond the 1,000th hit can't be guaranteed.  """
    unretrievable_attributes: Optional[List[str]] = None
    """ Attributes that can't be retrieved at query time.  This can be useful if you want to use an attribute for ranking or to [restrict access](https://www.algolia.com/doc/guides/security/api-keys/how-to/user-restricted-access-to-data/), but don't want to include it in the search results. Attribute names are case-sensitive.  """
    disable_typo_tolerance_on_words: Optional[List[str]] = None
    """ Creates a list of [words which require exact matches](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/typo-tolerance/in-depth/configuring-typo-tolerance/#turn-off-typo-tolerance-for-certain-words). This also turns off [word splitting and concatenation](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/splitting-and-concatenation/) for the specified words.  """
    attributes_to_transliterate: Optional[List[str]] = None
    """ Attributes, for which you want to support [Japanese transliteration](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/language-specific-configurations/#japanese-transliteration-and-type-ahead).  Transliteration supports searching in any of the Japanese writing systems. To support transliteration, you must set the indexing language to Japanese. Attribute names are case-sensitive.  """
    camel_case_attributes: Optional[List[str]] = None
    """ Attributes for which to split [camel case](https://wikipedia.org/wiki/Camel_case) words. Attribute names are case-sensitive.  """
    decompounded_attributes: Optional[object] = None
    """ Searchable attributes to which Algolia should apply [word segmentation](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-segmentation/) (decompounding). Attribute names are case-sensitive.  Compound words are formed by combining two or more individual words, and are particularly prevalent in Germanic languages—for example, \"firefighter\". With decompounding, the individual components are indexed separately.  You can specify different lists for different languages. Decompounding is supported for these languages: Dutch (`nl`), German (`de`), Finnish (`fi`), Danish (`da`), Swedish (`sv`), and Norwegian (`no`). Decompounding doesn't work for words with [non-spacing mark Unicode characters](https://www.charactercodes.net/category/non-spacing_mark). For example, `Gartenstühle` won't be decompounded if the `ü` consists of `u` (U+0075) and `◌̈` (U+0308).  """
    index_languages: Optional[List[SupportedLanguage]] = None
    """ Languages for language-specific processing steps, such as word detection and dictionary settings.  **You should always specify an indexing language.** If you don't specify an indexing language, the search engine uses all [supported languages](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/supported-languages/), or the languages you specified with the `ignorePlurals` or `removeStopWords` parameters. This can lead to unexpected search results. For more information, see [Language-specific configuration](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/language-specific-configurations/).  """
    disable_prefix_on_attributes: Optional[List[str]] = None
    """ Searchable attributes for which you want to turn off [prefix matching](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/override-search-engine-defaults/#adjusting-prefix-search). Attribute names are case-sensitive.  """
    allow_compression_of_integer_array: Optional[bool] = None
    """ Whether arrays with exclusively non-negative integers should be compressed for better performance. If true, the compressed arrays may be reordered.  """
    numeric_attributes_for_filtering: Optional[List[str]] = None
    """ Numeric attributes that can be used as [numerical filters](https://www.algolia.com/doc/guides/managing-results/rules/detecting-intent/how-to/applying-a-custom-filter-for-a-specific-query/#numerical-filters). Attribute names are case-sensitive.  By default, all numeric attributes are available as numerical filters. For faster indexing, reduce the number of numeric attributes.  To turn off filtering for all numeric attributes, specify an attribute that doesn't exist in your index, such as `NO_NUMERIC_FILTERING`.  **Modifier**  - `equalOnly(\"ATTRIBUTE\")`.   Support only filtering based on equality comparisons `=` and `!=`.  """
    separators_to_index: Optional[str] = None
    """ Control which non-alphanumeric characters are indexed.  By default, Algolia ignores [non-alphanumeric characters](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/typo-tolerance/how-to/how-to-search-in-hyphenated-attributes/#handling-non-alphanumeric-characters) like hyphen (`-`), plus (`+`), and parentheses (`(`,`)`). To include such characters, define them with `separatorsToIndex`.  Separators are all non-letter characters except spaces and currency characters, such as $€£¥.  With `separatorsToIndex`, Algolia treats separator characters as separate words. For example, in a search for \"Disney+\", Algolia considers \"Disney\" and \"+\" as two separate words.  """
    searchable_attributes: Optional[List[str]] = None
    """ Attributes used for searching. Attribute names are case-sensitive.  By default, all attributes are searchable and the [Attribute](https://www.algolia.com/doc/guides/managing-results/relevance-overview/in-depth/ranking-criteria/#attribute) ranking criterion is turned off. With a non-empty list, Algolia only returns results with matches in the selected attributes. In addition, the Attribute ranking criterion is turned on: matches in attributes that are higher in the list of `searchableAttributes` rank first. To make matches in two attributes rank equally, include them in a comma-separated string, such as `\"title,alternate_title\"`. Attributes with the same priority are always unordered.  For more information, see [Searchable attributes](https://www.algolia.com/doc/guides/sending-and-managing-data/prepare-your-data/how-to/setting-searchable-attributes/).  **Modifier**  - `unordered(\"ATTRIBUTE\")`.   Ignore the position of a match within the attribute.  Without a modifier, matches at the beginning of an attribute rank higher than matches at the end.  """
    user_data: Optional[object] = None
    """ An object with custom data.  You can store up to 32kB as custom data.  """
    custom_normalization: Optional[Dict[str, Dict[str, str]]] = None
    """ Characters and their normalized replacements. This overrides Algolia's default [normalization](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/normalization/).  """
    attribute_for_distinct: Optional[str] = None
    """ Attribute that should be used to establish groups of results. Attribute names are case-sensitive.  All records with the same value for this attribute are considered a group. You can combine `attributeForDistinct` with the `distinct` search parameter to control how many items per group are included in the search results.  If you want to use the same attribute also for faceting, use the `afterDistinct` modifier of the `attributesForFaceting` setting. This applies faceting _after_ deduplication, which will result in accurate facet counts.  """
    max_facet_hits: Optional[int] = None
    """ Maximum number of facet values to return when [searching for facet values](https://www.algolia.com/doc/guides/managing-results/refine-results/faceting/#search-for-facet-values). """
    keep_diacritics_on_characters: Optional[str] = None
    """ Characters for which diacritics should be preserved.  By default, Algolia removes diacritics from letters. For example, `é` becomes `e`. If this causes issues in your search, you can specify characters that should keep their diacritics.  """
    custom_ranking: Optional[List[str]] = None
    """ Attributes to use as [custom ranking](https://www.algolia.com/doc/guides/managing-results/must-do/custom-ranking/). Attribute names are case-sensitive.  The custom ranking attributes decide which items are shown first if the other ranking criteria are equal.  Records with missing values for your selected custom ranking attributes are always sorted last. Boolean attributes are sorted based on their alphabetical order.  **Modifiers**  - `asc(\"ATTRIBUTE\")`.   Sort the index by the values of an attribute, in ascending order.  - `desc(\"ATTRIBUTE\")`.   Sort the index by the values of an attribute, in descending order.  If you use two or more custom ranking attributes, [reduce the precision](https://www.algolia.com/doc/guides/managing-results/must-do/custom-ranking/how-to/controlling-custom-ranking-metrics-precision/) of your first attributes, or the other attributes will never be applied.  """
    attributes_to_retrieve: Optional[List[str]] = None
    """ Attributes to include in the API response.  To reduce the size of your response, you can retrieve only some of the attributes. Attribute names are case-sensitive.  - `*` retrieves all attributes, except attributes included in the `customRanking` and `unretrievableAttributes` settings. - To retrieve all attributes except a specific one, prefix the attribute with a dash and combine it with the `*`: `[\"*\", \"-ATTRIBUTE\"]`. - The `objectID` attribute is always included.  """
    ranking: Optional[List[str]] = None
    """ Determines the order in which Algolia returns your results.  By default, each entry corresponds to a [ranking criteria](https://www.algolia.com/doc/guides/managing-results/relevance-overview/in-depth/ranking-criteria/). The tie-breaking algorithm sequentially applies each criterion in the order they're specified. If you configure a replica index for [sorting by an attribute](https://www.algolia.com/doc/guides/managing-results/refine-results/sorting/how-to/sort-by-attribute/), you put the sorting attribute at the top of the list.  **Modifiers**  - `asc(\"ATTRIBUTE\")`.   Sort the index by the values of an attribute, in ascending order. - `desc(\"ATTRIBUTE\")`.   Sort the index by the values of an attribute, in descending order.  Before you modify the default setting, you should test your changes in the dashboard, and by [A/B testing](https://www.algolia.com/doc/guides/ab-testing/what-is-ab-testing/).  """
    relevancy_strictness: Optional[int] = None
    """ Relevancy threshold below which less relevant results aren't included in the results.  You can only set `relevancyStrictness` on [virtual replica indices](https://www.algolia.com/doc/guides/managing-results/refine-results/sorting/in-depth/replicas/#what-are-virtual-replicas). Use this setting to strike a balance between the relevance and number of returned results.  """
    attributes_to_highlight: Optional[List[str]] = None
    """ Attributes to highlight.  By default, all searchable attributes are highlighted. Use `*` to highlight all attributes or use an empty array `[]` to turn off highlighting. Attribute names are case-sensitive.  With highlighting, strings that match the search query are surrounded by HTML tags defined by `highlightPreTag` and `highlightPostTag`. You can use this to visually highlight matching parts of a search query in your UI.  For more information, see [Highlighting and snippeting](https://www.algolia.com/doc/guides/building-search-ui/ui-and-ux-patterns/highlighting-snippeting/js/).  """
    attributes_to_snippet: Optional[List[str]] = None
    """ Attributes for which to enable snippets. Attribute names are case-sensitive.  Snippets provide additional context to matched words. If you enable snippets, they include 10 words, including the matched word. The matched word will also be wrapped by HTML tags for highlighting. You can adjust the number of words with the following notation: `ATTRIBUTE:NUMBER`, where `NUMBER` is the number of words to be extracted.  """
    highlight_pre_tag: Optional[str] = None
    """ HTML tag to insert before the highlighted parts in all highlighted results and snippets. """
    highlight_post_tag: Optional[str] = None
    """ HTML tag to insert after the highlighted parts in all highlighted results and snippets. """
    snippet_ellipsis_text: Optional[str] = None
    """ String used as an ellipsis indicator when a snippet is truncated. """
    restrict_highlight_and_snippet_arrays: Optional[bool] = None
    """ Whether to restrict highlighting and snippeting to items that at least partially matched the search query. By default, all items are highlighted and snippeted.  """
    hits_per_page: Optional[int] = None
    """ Number of hits per page. """
    min_word_sizefor1_typo: Optional[int] = None
    """ Minimum number of characters a word in the search query must contain to accept matches with [one typo](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/typo-tolerance/in-depth/configuring-typo-tolerance/#configuring-word-length-for-typos). """
    min_word_sizefor2_typos: Optional[int] = None
    """ Minimum number of characters a word in the search query must contain to accept matches with [two typos](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/typo-tolerance/in-depth/configuring-typo-tolerance/#configuring-word-length-for-typos). """
    typo_tolerance: Optional[TypoTolerance] = None
    allow_typos_on_numeric_tokens: Optional[bool] = None
    """ Whether to allow typos on numbers in the search query.  Turn off this setting to reduce the number of irrelevant matches when searching in large sets of similar numbers.  """
    disable_typo_tolerance_on_attributes: Optional[List[str]] = None
    """ Attributes for which you want to turn off [typo tolerance](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/typo-tolerance/). Attribute names are case-sensitive.  Returning only exact matches can help when:  - [Searching in hyphenated attributes](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/typo-tolerance/how-to/how-to-search-in-hyphenated-attributes/). - Reducing the number of matches when you have too many.   This can happen with attributes that are long blocks of text, such as product descriptions.  Consider alternatives such as `disableTypoToleranceOnWords` or adding synonyms if your attributes have intentional unusual spellings that might look like typos.  """
    ignore_plurals: Optional[IgnorePlurals] = None
    remove_stop_words: Optional[RemoveStopWords] = None
    query_languages: Optional[List[SupportedLanguage]] = None
    """ Languages for language-specific query processing steps such as plurals, stop-word removal, and word-detection dictionaries.  This setting sets a default list of languages used by the `removeStopWords` and `ignorePlurals` settings. This setting also sets a dictionary for word detection in the logogram-based [CJK](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/normalization/#normalization-for-logogram-based-languages-cjk) languages. To support this, you must place the CJK language **first**.  **You should always specify a query language.** If you don't specify an indexing language, the search engine uses all [supported languages](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/supported-languages/), or the languages you specified with the `ignorePlurals` or `removeStopWords` parameters. This can lead to unexpected search results. For more information, see [Language-specific configuration](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/language-specific-configurations/).  """
    decompound_query: Optional[bool] = None
    """ Whether to split compound words in the query into their building blocks.  For more information, see [Word segmentation](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/language-specific-configurations/#splitting-compound-words). Word segmentation is supported for these languages: German, Dutch, Finnish, Swedish, and Norwegian. Decompounding doesn't work for words with [non-spacing mark Unicode characters](https://www.charactercodes.net/category/non-spacing_mark). For example, `Gartenstühle` won't be decompounded if the `ü` consists of `u` (U+0075) and `◌̈` (U+0308).  """
    enable_rules: Optional[bool] = None
    """ Whether to enable rules. """
    enable_personalization: Optional[bool] = None
    """ Whether to enable Personalization. """
    query_type: Optional[QueryType] = None
    remove_words_if_no_results: Optional[RemoveWordsIfNoResults] = None
    mode: Optional[Mode] = None
    semantic_search: Optional[SemanticSearch] = None
    advanced_syntax: Optional[bool] = None
    """ Whether to support phrase matching and excluding words from search queries.  Use the `advancedSyntaxFeatures` parameter to control which feature is supported.  """
    optional_words: Optional[OptionalWords] = None
    disable_exact_on_attributes: Optional[List[str]] = None
    """ Searchable attributes for which you want to [turn off the Exact ranking criterion](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/override-search-engine-defaults/in-depth/adjust-exact-settings/#turn-off-exact-for-some-attributes). Attribute names are case-sensitive.  This can be useful for attributes with long values, where the likelihood of an exact match is high, such as product descriptions. Turning off the Exact ranking criterion for these attributes favors exact matching on other attributes. This reduces the impact of individual attributes with a lot of content on ranking.  """
    exact_on_single_word_query: Optional[ExactOnSingleWordQuery] = None
    alternatives_as_exact: Optional[List[AlternativesAsExact]] = None
    """ Determine which plurals and synonyms should be considered an exact matches.  By default, Algolia treats singular and plural forms of a word, and single-word synonyms, as [exact](https://www.algolia.com/doc/guides/managing-results/relevance-overview/in-depth/ranking-criteria/#exact) matches when searching. For example:  - \"swimsuit\" and \"swimsuits\" are treated the same - \"swimsuit\" and \"swimwear\" are treated the same (if they are [synonyms](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/adding-synonyms/#regular-synonyms)).  - `ignorePlurals`.   Plurals and similar declensions added by the `ignorePlurals` setting are considered exact matches.  - `singleWordSynonym`.   Single-word synonyms, such as \"NY\" = \"NYC\", are considered exact matches.  - `multiWordsSynonym`.   Multi-word synonyms, such as \"NY\" = \"New York\", are considered exact matches.  """
    advanced_syntax_features: Optional[List[AdvancedSyntaxFeatures]] = None
    """ Advanced search syntax features you want to support.  - `exactPhrase`.   Phrases in quotes must match exactly.   For example, `sparkly blue \"iPhone case\"` only returns records with the exact string \"iPhone case\".  - `excludeWords`.   Query words prefixed with a `-` must not occur in a record.   For example, `search -engine` matches records that contain \"search\" but not \"engine\".  This setting only has an effect if `advancedSyntax` is true.  """
    distinct: Optional[Distinct] = None
    replace_synonyms_in_highlight: Optional[bool] = None
    """ Whether to replace a highlighted word with the matched synonym.  By default, the original words are highlighted even if a synonym matches. For example, with `home` as a synonym for `house` and a search for `home`, records matching either \"home\" or \"house\" are included in the search results, and either \"home\" or \"house\" are highlighted.  With `replaceSynonymsInHighlight` set to `true`, a search for `home` still matches the same records, but all occurrences of \"house\" are replaced by \"home\" in the highlighted response.  """
    min_proximity: Optional[int] = None
    """ Minimum proximity score for two matching words.  This adjusts the [Proximity ranking criterion](https://www.algolia.com/doc/guides/managing-results/relevance-overview/in-depth/ranking-criteria/#proximity) by equally scoring matches that are farther apart.  For example, if `minProximity` is 2, neighboring matches and matches with one word between them would have the same score.  """
    response_fields: Optional[List[str]] = None
    """ Properties to include in the API response of search and browse requests.  By default, all response properties are included. To reduce the response size, you can select which properties should be included.  An empty list may lead to an empty API response (except properties you can't exclude).  You can't exclude these properties: `message`, `warning`, `cursor`, `abTestVariantID`, or any property added by setting `getRankingInfo` to true.  Your search depends on the `hits` field. If you omit this field, searches won't return any results. Your UI might also depend on other properties, for example, for pagination. Before restricting the response size, check the impact on your search experience.  """
    max_values_per_facet: Optional[int] = None
    """ Maximum number of facet values to return for each facet. """
    sort_facet_values_by: Optional[str] = None
    """ Order in which to retrieve facet values.  - `count`.   Facet values are retrieved by decreasing count.   The count is the number of matching records containing this facet value.  - `alpha`.   Retrieve facet values alphabetically.  This setting doesn't influence how facet values are displayed in your UI (see `renderingContent`). For more information, see [facet value display](https://www.algolia.com/doc/guides/building-search-ui/ui-and-ux-patterns/facet-display/js/).  """
    attribute_criteria_computed_by_min_proximity: Optional[bool] = None
    """ Whether the best matching attribute should be determined by minimum proximity.  This setting only affects ranking if the Attribute ranking criterion comes before Proximity in the `ranking` setting. If true, the best matching attribute is selected based on the minimum proximity of multiple matches. Otherwise, the best matching attribute is determined by the order in the `searchableAttributes` setting.  """
    rendering_content: Optional[RenderingContent] = None
    enable_re_ranking: Optional[bool] = None
    """ Whether this search will use [Dynamic Re-Ranking](https://www.algolia.com/doc/guides/algolia-ai/re-ranking/).  This setting only has an effect if you activated Dynamic Re-Ranking for this index in the Algolia dashboard.  """
    re_ranking_apply_filter: Optional[ReRankingApplyFilter] = None
    primary: Optional[str] = None
    """ Replica indices only: the name of the primary index for this replica.  """

    model_config = ConfigDict(
        strict=False,
        use_enum_values=True,
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=_alias_generator,
        extra="allow",
    )

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SettingsResponse from a JSON string"""
        return cls.from_dict(loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias."""
        return self.model_dump(
            by_alias=True,
            exclude_none=True,
            exclude_unset=True,
        )

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SettingsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        obj["indexLanguages"] = obj.get("indexLanguages")
        obj["typoTolerance"] = (
            TypoTolerance.from_dict(obj["typoTolerance"])
            if obj.get("typoTolerance") is not None
            else None
        )
        obj["ignorePlurals"] = (
            IgnorePlurals.from_dict(obj["ignorePlurals"])
            if obj.get("ignorePlurals") is not None
            else None
        )
        obj["removeStopWords"] = (
            RemoveStopWords.from_dict(obj["removeStopWords"])
            if obj.get("removeStopWords") is not None
            else None
        )
        obj["queryLanguages"] = obj.get("queryLanguages")
        obj["queryType"] = obj.get("queryType")
        obj["removeWordsIfNoResults"] = obj.get("removeWordsIfNoResults")
        obj["mode"] = obj.get("mode")
        obj["semanticSearch"] = (
            SemanticSearch.from_dict(obj["semanticSearch"])
            if obj.get("semanticSearch") is not None
            else None
        )
        obj["optionalWords"] = (
            OptionalWords.from_dict(obj["optionalWords"])
            if obj.get("optionalWords") is not None
            else None
        )
        obj["exactOnSingleWordQuery"] = obj.get("exactOnSingleWordQuery")
        obj["alternativesAsExact"] = obj.get("alternativesAsExact")
        obj["advancedSyntaxFeatures"] = obj.get("advancedSyntaxFeatures")
        obj["distinct"] = (
            Distinct.from_dict(obj["distinct"])
            if obj.get("distinct") is not None
            else None
        )
        obj["renderingContent"] = (
            RenderingContent.from_dict(obj["renderingContent"])
            if obj.get("renderingContent") is not None
            else None
        )
        obj["reRankingApplyFilter"] = (
            ReRankingApplyFilter.from_dict(obj["reRankingApplyFilter"])
            if obj.get("reRankingApplyFilter") is not None
            else None
        )

        return cls.model_validate(obj)
