# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""

from __future__ import annotations

from json import loads
from re import match
from sys import version_info
from typing import Any, Dict, Optional

from pydantic import BaseModel, ConfigDict, field_validator

if version_info >= (3, 11):
    from typing import Self
else:
    from typing_extensions import Self


from algoliasearch.search.models.user_highlight_result import UserHighlightResult

_ALIASES = {
    "user_id": "userID",
    "cluster_name": "clusterName",
    "nb_records": "nbRecords",
    "data_size": "dataSize",
    "object_id": "objectID",
    "highlight_result": "_highlightResult",
}


def _alias_generator(name: str) -> str:
    return _ALIASES.get(name, name)


class UserHit(BaseModel):
    """
    UserHit
    """

    user_id: str
    """ Unique identifier of the user who makes the search request. """
    cluster_name: str
    """ Cluster name. """
    nb_records: int
    """ Number of records in the cluster. """
    data_size: int
    """ Data size taken by all the users assigned to the cluster. """
    object_id: str
    """ userID of the requested user. Same as userID. """
    highlight_result: UserHighlightResult

    @field_validator("user_id")
    def user_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not match(r"^[a-zA-Z0-9 \-*.]+$", value):
            raise ValueError(
                r"must validate the regular expression /^[a-zA-Z0-9 \-*.]+$/"
            )
        return value

    model_config = ConfigDict(
        strict=False,
        use_enum_values=True,
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=_alias_generator,
        extra="allow",
    )

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserHit from a JSON string"""
        return cls.from_dict(loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias."""
        return self.model_dump(
            by_alias=True,
            exclude_none=True,
            exclude_unset=True,
        )

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserHit from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        obj["_highlightResult"] = (
            UserHighlightResult.from_dict(obj["_highlightResult"])
            if obj.get("_highlightResult") is not None
            else None
        )

        return cls.model_validate(obj)
