"""Init all tables

Revision ID: f22991f23e5b
Revises:
Create Date: 2025-09-20 12:00:17.458343

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = "f22991f23e5b"
down_revision: Union[str, Sequence[str], None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "agents",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("name", sa.String(), nullable=True),
        sa.Column("description", sa.Text(), nullable=True),
        sa.Column("config", sa.JSON(), nullable=True),
        sa.Column("folder_path", sa.String(), nullable=True),
        sa.Column("files", sa.JSON(), nullable=True),
        sa.Column("generation_phase", sa.String(), nullable=False),
        sa.Column("agent_description_draft", sa.JSON(), nullable=True),
        sa.Column("generation_metadata", sa.JSON(), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
        if_not_exists=True,
    )
    op.create_index(op.f("ix_agents_id"), "agents", ["id"], unique=False, if_not_exists=True)
    op.create_index(op.f("ix_agents_name"), "agents", ["name"], unique=False, if_not_exists=True)
    op.create_table(
        "topics",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("name", sa.String(), nullable=True),
        sa.Column("description", sa.Text(), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
        if_not_exists=True,
    )
    op.create_index(op.f("ix_topics_id"), "topics", ["id"], unique=False, if_not_exists=True)
    op.create_index(op.f("ix_topics_name"), "topics", ["name"], unique=True, if_not_exists=True)
    op.create_table(
        "agent_chat_history",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("agent_id", sa.Integer(), nullable=False),
        sa.Column("sender", sa.String(), nullable=False),
        sa.Column("text", sa.Text(), nullable=False),
        sa.Column("type", sa.String(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(
            ["agent_id"],
            ["agents.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        if_not_exists=True,
    )
    op.create_index(op.f("ix_agent_chat_history_agent_id"), "agent_chat_history", ["agent_id"], unique=False, if_not_exists=True)
    op.create_table(
        "conversations",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("title", sa.String(), nullable=False),
        sa.Column("agent_id", sa.Integer(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(
            ["agent_id"],
            ["agents.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        if_not_exists=True,
    )
    op.create_index(op.f("ix_conversations_agent_id"), "conversations", ["agent_id"], unique=False, if_not_exists=True)
    op.create_index(op.f("ix_conversations_id"), "conversations", ["id"], unique=False, if_not_exists=True)
    op.create_table(
        "documents",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("filename", sa.String(), nullable=True),
        sa.Column("original_filename", sa.String(), nullable=True),
        sa.Column("file_path", sa.String(), nullable=True),
        sa.Column("file_size", sa.Integer(), nullable=True),
        sa.Column("mime_type", sa.String(), nullable=True),
        sa.Column("topic_id", sa.Integer(), nullable=True),
        sa.Column("agent_id", sa.Integer(), nullable=True),
        sa.Column("source_document_id", sa.Integer(), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(
            ["agent_id"],
            ["agents.id"],
        ),
        sa.ForeignKeyConstraint(
            ["source_document_id"],
            ["documents.id"],
        ),
        sa.ForeignKeyConstraint(
            ["topic_id"],
            ["topics.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        if_not_exists=True,
    )
    op.create_index(op.f("ix_documents_filename"), "documents", ["filename"], unique=False, if_not_exists=True)
    op.create_index(op.f("ix_documents_id"), "documents", ["id"], unique=False, if_not_exists=True)
    op.create_table(
        "messages",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("conversation_id", sa.Integer(), nullable=False),
        sa.Column("sender", sa.String(), nullable=False),
        sa.Column("content", sa.Text(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(
            ["conversation_id"],
            ["conversations.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        if_not_exists=True,
    )
    op.create_index(op.f("ix_messages_conversation_id"), "messages", ["conversation_id"], unique=False, if_not_exists=True)
    op.create_index(op.f("ix_messages_id"), "messages", ["id"], unique=False, if_not_exists=True)
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_messages_id"), table_name="messages", if_exists=True)
    op.drop_index(op.f("ix_messages_conversation_id"), table_name="messages", if_exists=True)
    op.drop_table("messages", if_exists=True)
    op.drop_index(op.f("ix_documents_id"), table_name="documents", if_exists=True)
    op.drop_index(op.f("ix_documents_filename"), table_name="documents", if_exists=True)
    op.drop_table("documents", if_exists=True)
    op.drop_index(op.f("ix_conversations_id"), table_name="conversations")
    op.drop_index(op.f("ix_conversations_agent_id"), table_name="conversations", if_exists=True)
    op.drop_table("conversations", if_exists=True)
    op.drop_index(op.f("ix_agent_chat_history_agent_id"), table_name="agent_chat_history", if_exists=True)
    op.drop_table("agent_chat_history", if_exists=True)
    op.drop_index(op.f("ix_topics_name"), table_name="topics", if_exists=True)
    op.drop_index(op.f("ix_topics_id"), table_name="topics", if_exists=True)
    op.drop_table("topics", if_exists=True)
    op.drop_index(op.f("ix_agents_name"), table_name="agents", if_exists=True)
    op.drop_index(op.f("ix_agents_id"), table_name="agents", if_exists=True)
    op.drop_table("agents", if_exists=True)
    # ### end Alembic commands ###
