---
title: Open Targets Gentropy
hide:
  - navigation
  - toc
---

</br>

<div style="text-align: center;">
    <img width="800" height="300" src="assets/imgs/gentropy.svg">
</div>

<style>
  .md-typeset h1,
  .md-content__button {
    display: none;
  }
</style>

<br>
</br>

<p align="center">
<a href="https://github.com/astral-sh/ruff"><img src="https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/astral-sh/ruff/main/assets/badge/v2.json" alt="Ruff" /></a>
<a href="https://pypi.python.org/pypi/gentropy/"><img src="https://img.shields.io/pypi/pyversions/gentropy.svg" alt="PyPI pyversions" /></a>
<a href="https://badge.fury.io/py/gentropy"><img src="https://badge.fury.io/py/gentropy.svg" alt="PyPI version" /></a>
<a href="https://opentargets.github.io/gentropy/"><img src="https://github.com/opentargets/gentropy/actions/workflows/release.yaml/badge.svg" alt="image" /></a>
<a href="https://codecov.io/gh/opentargets/gentropy"><img src="https://codecov.io/gh/opentargets/gentropy/branch/main/graph/badge.svg?token=5ixzgu8KFP" alt="codecov" /></a>
<a href="https://opensource.org/licenses/Apache-2.0"><img src="https://img.shields.io/badge/License-Apache_2.0-blue.svg" alt="License" /></a>
<a href="https://doi.org/10.5281/zenodo.10527086"><img src="https://zenodo.org/badge/DOI/10.5281/zenodo.10527086.svg" alt="DOI" /></a>
</p>
---

Open Targets Gentropy is a Python package to facilitate the interpretation and analysis of GWAS and functional genomic studies for target identification. This package contains a toolkit for the harmonisation, statistical analysis and prioritisation of genetic signals to assist drug discovery.

#### Key Features:

- **Specialized Datatypes**: Introduces essential genetics datatypes like _StudyLocus_, _LocusToGene_, and _SummaryStatistics_.
- **Performance-Oriented**: Optimized for large-scale genetic data analysis, including locus-to-gene scoring, fine mapping, and colocalization analysis.
- **User-Friendly**: The package is designed to be intuitive, allowing both beginners and experienced researchers to conduct complex genetic with ease.

## About Open Targets

Open Targets is a pre-competitive, public-private partnership that uses human genetics and genomics data to systematically identify and prioritise drug targets. Through large-scale genomic experiments and the development of innovative computational techniques, the partnership aims to help researchers select the best targets for the development of new therapies. For more information, visit the Open Targets [website](https://www.opentargets.org).
