---
title: Data Sources
---

# Data Sources

This section contains information about the data source harmonisation tools available in Open Targets Gentropy.

## GWAS study sources

1. [GWAS Catalog](gwas_catalog/_gwas_catalog.md) (with or without full summary statistics)
1. [FinnGen](finngen/_finngen.md)
1. [UKB PPP (EUR)](ukb_ppp_eur/_ukb_ppp_eur.md)

## Molecular QTLs

1. [GTEx (eQTL catalogue)](eqtl_catalogue/_eqtl_catalogue.md)

## Interaction / Interval-based Experiments

1. [Intervals](intervals/_intervals.md)-based datasets, informing about the relationships between genetic elements and their functional implications.

## Variant annotation/validation

1. [GnomAD](gnomad/_gnomad.md) v4.0
2. GWAS catalog's [harmonisation pipeline](https://www.ebi.ac.uk/gwas/docs/methods/summary-statistics#_harmonised_summary_statistics_data)
3. Ensembl's [Variant Effect Predictor](https://www.ensembl.org/info/docs/tools/vep/index.html)

## Linkage disequilibrium

1. [GnomAD](gnomad/_gnomad.md) v2.1.1 LD matrixes (7 ancestries)

## Locus-to-gene gold standard

1. [Open Targets training set](open_targets/l2g_gold_standard.md)

## Gene annotation

1. [Open Targets Platform Target Dataset](open_targets/_open_targets.md) (derived from Ensembl)

## Biological samples

1. [Uberon](biosample_ontologies/_uberon.md)
2. [Cell Ontology](biosample_ontologies/_cell_ontology.md)
