---
title: Interaction and Interval-based Studies
---

# List of Interaction and Interval-based Studies

In this section, we provide a list of studies that focus on interaction and interval-based investigations, shedding light on the intricate relationships between genetic elements and their functional implications.

1. **Promoter Capture Hi-C (Javierre et al., 2016):**
   _Title:_ "Lineage-Specific Genome Architecture Links Enhancers and Non-coding Disease Variants to Target Gene Promoters".
   This study presents evidence linking genetic variation to genes through the application of Promoter Capture Hi-C across each of the 17 human primary hematopoietic cell types. The method captures interactions between promoters and distal regulatory elements, providing valuable insights into the three-dimensional chromatin architecture. DOI: 10.1016/j.cell.2016.09.037

2. **Enhancer-TSS Correlation (Andersson et al., 2014):**
   _Title:_ "An Atlas of Active Enhancers across Human Cell Types and Tissues".
   This study explores genetic variation's impact on genes by examining the correlation between the transcriptional activity of enhancers and transcription start sites. The findings are documented in the FANTOM5 CAGE expression atlas, offering a comprehensive view of the regulatory landscape. DOI: 10.1038/nature12787

3. **DHS-Promoter Correlation (Thurman et al., 2012):**
   _Title:_ "The accessible chromatin landscape of the human genome".
   Investigating genetic variation's connection to genes, this study employs the correlation of DNase I hypersensitive sites (DHS) and gene promoters. The analysis spans 125 cell and tissue types from the ENCODE project, providing a broad understanding of the regulatory interactions across diverse biological contexts. DOI: 10.1038/nature11232

4. **Promoter Capture Hi-C (Jung et al., 2019):**
   _Title:_ "A compendium of promoter-centered long-range chromatin interactions in the human genome".
   This study compiles a compendium of promoter-centered long-range chromatin interactions in the human genome. By focusing on the three-dimensional organization of chromatin, the research contributes to our understanding of the spatial arrangement of genetic elements and their implications in gene regulation. DOI: 10.1038/s41588-019-0494-8

For in-depth details on each study, you may refer to the respective publications.
