---
title: Open Targets
---

<p align="center">
  <img width="400" height="200" src="../../../../assets/imgs/open_targets_platform.svg">
</p>
<style>
  .md-typeset h1,
  .md-content__button {
    display: none;
  }
</style>

The Open Targets Platform is a comprehensive resource that aims to aggregate and harmonize various types of data to facilitate the identification, prioritization, and validation of drug targets. By integrating publicly available datasets, including data generated by the Open Targets consortium, the Platform builds and scores target-disease associations to assist in drug target identification and prioritization. It also integrates relevant annotation information about targets, diseases, phenotypes, and drugs, as well as their most relevant relationships.

Within our analyses, we utilize Open Targets to infer two datasets:

1. **The list of targets:**
   This dataset provides a compilation of targets. In the Open Targets Platform, a target is understood as any naturally-occurring molecule that can be targeted by a medicinal product. The EMBL-EBI Ensembl database serves as the source for human targets in the Platform, with the Ensembl gene ID as the primary identifier. For more details, refer to [this link](https://platform-docs.opentargets.org/target).

2. **The list of Gold Standard Positives:**
   We use this dataset for training the Locus-to-Gene model. The current list contains 496 Gold Standard Positives.
