# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.client_facing_electrocardiogram_response import ClientFacingElectrocardiogramResponse
from .raw_client import AsyncRawElectrocardiogramClient, RawElectrocardiogramClient


class ElectrocardiogramClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawElectrocardiogramClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawElectrocardiogramClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawElectrocardiogramClient
        """
        return self._raw_client

    def get(
        self,
        user_id: str,
        *,
        start_date: dt.date,
        end_date: typing.Optional[dt.date] = None,
        provider: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientFacingElectrocardiogramResponse:
        """
        Get electrocardiogram summary for user_id

        Parameters
        ----------
        user_id : str

        start_date : dt.date

        end_date : typing.Optional[dt.date]

        provider : typing.Optional[str]
            Provider oura/strava etc

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingElectrocardiogramResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        import datetime
        client = Vital(api_key="YOUR_API_KEY", )
        client.electrocardiogram.get(user_id='user_id', start_date=datetime.date.fromisoformat("2023-01-15", ), )
        """
        _response = self._raw_client.get(
            user_id, start_date=start_date, end_date=end_date, provider=provider, request_options=request_options
        )
        return _response.data


class AsyncElectrocardiogramClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawElectrocardiogramClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawElectrocardiogramClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawElectrocardiogramClient
        """
        return self._raw_client

    async def get(
        self,
        user_id: str,
        *,
        start_date: dt.date,
        end_date: typing.Optional[dt.date] = None,
        provider: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientFacingElectrocardiogramResponse:
        """
        Get electrocardiogram summary for user_id

        Parameters
        ----------
        user_id : str

        start_date : dt.date

        end_date : typing.Optional[dt.date]

        provider : typing.Optional[str]
            Provider oura/strava etc

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingElectrocardiogramResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import datetime
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.electrocardiogram.get(user_id='user_id', start_date=datetime.date.fromisoformat("2023-01-15", ), )
        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            user_id, start_date=start_date, end_date=end_date, provider=provider, request_options=request_options
        )
        return _response.data
