# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.providers import Providers
from ..types.user_historical_pulls_response import UserHistoricalPullsResponse
from ..types.user_resources_response import UserResourcesResponse
from .raw_client import AsyncRawIntrospectClient, RawIntrospectClient
from .types.get_user_historical_pulls_introspect_request_provider import GetUserHistoricalPullsIntrospectRequestProvider


class IntrospectClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawIntrospectClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawIntrospectClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawIntrospectClient
        """
        return self._raw_client

    def get_user_resources(
        self,
        *,
        user_id: typing.Optional[str] = None,
        provider: typing.Optional[Providers] = None,
        user_limit: typing.Optional[int] = None,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UserResourcesResponse:
        """
        Parameters
        ----------
        user_id : typing.Optional[str]
            Filter by user ID.

        provider : typing.Optional[Providers]

        user_limit : typing.Optional[int]

        cursor : typing.Optional[str]

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserResourcesResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.introspect.get_user_resources()
        """
        _response = self._raw_client.get_user_resources(
            user_id=user_id,
            provider=provider,
            user_limit=user_limit,
            cursor=cursor,
            next_cursor=next_cursor,
            request_options=request_options,
        )
        return _response.data

    def get_user_historical_pulls(
        self,
        *,
        user_id: typing.Optional[str] = None,
        provider: typing.Optional[GetUserHistoricalPullsIntrospectRequestProvider] = None,
        user_limit: typing.Optional[int] = None,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UserHistoricalPullsResponse:
        """
        Parameters
        ----------
        user_id : typing.Optional[str]
            Filter by user ID.

        provider : typing.Optional[GetUserHistoricalPullsIntrospectRequestProvider]

        user_limit : typing.Optional[int]

        cursor : typing.Optional[str]

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserHistoricalPullsResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.introspect.get_user_historical_pulls()
        """
        _response = self._raw_client.get_user_historical_pulls(
            user_id=user_id,
            provider=provider,
            user_limit=user_limit,
            cursor=cursor,
            next_cursor=next_cursor,
            request_options=request_options,
        )
        return _response.data


class AsyncIntrospectClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawIntrospectClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawIntrospectClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawIntrospectClient
        """
        return self._raw_client

    async def get_user_resources(
        self,
        *,
        user_id: typing.Optional[str] = None,
        provider: typing.Optional[Providers] = None,
        user_limit: typing.Optional[int] = None,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UserResourcesResponse:
        """
        Parameters
        ----------
        user_id : typing.Optional[str]
            Filter by user ID.

        provider : typing.Optional[Providers]

        user_limit : typing.Optional[int]

        cursor : typing.Optional[str]

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserResourcesResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.introspect.get_user_resources()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_user_resources(
            user_id=user_id,
            provider=provider,
            user_limit=user_limit,
            cursor=cursor,
            next_cursor=next_cursor,
            request_options=request_options,
        )
        return _response.data

    async def get_user_historical_pulls(
        self,
        *,
        user_id: typing.Optional[str] = None,
        provider: typing.Optional[GetUserHistoricalPullsIntrospectRequestProvider] = None,
        user_limit: typing.Optional[int] = None,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UserHistoricalPullsResponse:
        """
        Parameters
        ----------
        user_id : typing.Optional[str]
            Filter by user ID.

        provider : typing.Optional[GetUserHistoricalPullsIntrospectRequestProvider]

        user_limit : typing.Optional[int]

        cursor : typing.Optional[str]

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserHistoricalPullsResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.introspect.get_user_historical_pulls()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_user_historical_pulls(
            user_id=user_id,
            provider=provider,
            user_limit=user_limit,
            cursor=cursor,
            next_cursor=next_cursor,
            request_options=request_options,
        )
        return _response.data
